/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression.data;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.DataExpr;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class CompiledFunctionExpr
extends DataExpr<Class<?>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 3098987741558862963L;
    private IAST variables;
    private IAST types;
    private IExpr expr;

    public static CompiledFunctionExpr newInstance(IAST variables, IAST types, IExpr expr, Class<?> clazz) {
        return new CompiledFunctionExpr(variables, types, expr, clazz);
    }

    protected CompiledFunctionExpr(IAST variables, IAST types, IExpr expr, Class<?> clazz) {
        super(S.CompiledFunction, clazz);
        this.variables = variables;
        this.types = types;
        this.expr = expr;
    }

    public IExpr copy() {
        return new CompiledFunctionExpr(this.variables, this.types, this.expr, (Class)this.fData);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CompiledFunctionExpr) {
            return ((Class)this.fData).equals(((CompiledFunctionExpr)obj).fData);
        }
        return false;
    }

    public IExpr evaluate(IAST ast, EvalEngine engine) {
        try {
            AbstractFunctionEvaluator fun = (AbstractFunctionEvaluator)((Class)this.fData).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return fun.evaluate(ast, engine);
        }
        catch (ReflectiveOperationException rex) {
            LOGGER.error("CompiledFunctionExpr.evaluate() failed", (Throwable)rex);
            return F.NIL;
        }
    }

    public IExpr getExpr() {
        return this.expr;
    }

    public IAST getVariables() {
        return this.variables;
    }

    @Override
    public int hashCode() {
        return this.fData == null ? 461 : 461 + ((Class)this.fData).hashCode();
    }

    @Override
    public int hierarchy() {
        return 32788;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("CompiledFunction(Arg count: ");
        buf.append(this.variables.argSize());
        buf.append(" Types: {");
        this.types.joinToString(buf, ",");
        buf.append("} Variables: {");
        this.variables.joinToString(buf, ",");
        buf.append("}");
        buf.append(")");
        return buf.toString();
    }
}

