/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression.data;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.matheclipse.core.expression.DataExpr;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.WL;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class ByteArrayExpr
extends DataExpr<byte[]>
implements Externalizable {
    private static final long serialVersionUID = 5799157739970931450L;

    public static ByteArrayExpr newInstance(byte[] array) {
        return new ByteArrayExpr(array);
    }

    public ByteArrayExpr() {
        super(S.ByteArray, null);
    }

    protected ByteArrayExpr(byte[] array) {
        super(S.ByteArray, array);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ByteArrayExpr) {
            return Arrays.equals((byte[])this.fData, (byte[])((ByteArrayExpr)obj).fData);
        }
        return false;
    }

    @Override
    public int hierarchy() {
        return 32787;
    }

    @Override
    public int hashCode() {
        return this.fData == null ? 541 : 541 + Arrays.hashCode((byte[])this.fData);
    }

    public IExpr copy() {
        return new ByteArrayExpr((byte[])this.fData);
    }

    @Override
    public IAST normal(boolean nilIfUnevaluated) {
        byte[] bArray = (byte[])this.toData();
        return WL.toList(bArray);
    }

    @Override
    public String toString() {
        return this.fHead.toString() + "[" + ((byte[])this.fData).length + " Bytes]";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int len = in.readInt();
        this.fData = new byte[len];
        in.read((byte[])this.fData);
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        output.writeInt(((byte[])this.fData).length);
        output.write((byte[])this.fData);
    }
}

