/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apfloat.Apfloat;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.AbortException;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.ASTAssociation;
import org.matheclipse.core.expression.ASTRealMatrix;
import org.matheclipse.core.expression.ASTRealVector;
import org.matheclipse.core.expression.ASTSeriesData;
import org.matheclipse.core.expression.BigIntegerSym;
import org.matheclipse.core.expression.Context;
import org.matheclipse.core.expression.ContextPath;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IntegerSym;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.data.ByteArrayExpr;
import org.matheclipse.core.expression.data.NumericArrayExpr;
import org.matheclipse.core.expression.data.SparseArrayExpr;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IPatternSequence;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.tensor.qty.IQuantity;

public class WL {
    private static final Logger LOGGER = LogManager.getLogger();

    public static IExpr deserialize(byte[] bArray) {
        if (bArray == null || bArray.length < 3) {
            return F.NIL;
        }
        ReadObject ro = new ReadObject(bArray);
        return ro.read();
    }

    public static IExpr deserializeInternal(byte[] bArray) {
        if (bArray == null || bArray.length < 3) {
            return F.NIL;
        }
        ReadInternalObject ro = new ReadInternalObject(bArray);
        return ro.read();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IExpr deserializeResource(String resourceName, boolean internal) {
        try (InputStream resourceAsStream = Config.class.getResourceAsStream(resourceName);){
            if (resourceAsStream == null) {
                IAssociation iAssociation = F.NIL;
                return iAssociation;
            }
            byte[] byteArray = ByteStreams.toByteArray((InputStream)resourceAsStream);
            IExpr iExpr = WL.deserializeInternal(byteArray);
            return iExpr;
        }
        catch (IOException ex) {
            LOGGER.error("WL.deserializeResource() failed", (Throwable)ex);
            return F.NIL;
        }
    }

    public static int[] parseVarint(byte[] array, int position) {
        byte next_byte;
        int count = 0;
        boolean continuation = true;
        int shift = 0;
        int length = 0;
        while (continuation && count < 8) {
            ++count;
            next_byte = array[position++];
            length |= (next_byte & 0x7F) << shift;
            shift += 7;
            continuation = (next_byte & 0x80) != 0;
        }
        if (continuation) {
            next_byte = array[position++];
            if ((next_byte = (byte)(next_byte & 0x7F)) == 0) {
                throw new UnsupportedOperationException("Invalid last varint byte.");
            }
            length |= next_byte << shift;
        }
        return new int[]{length, position};
    }

    public static byte[] serialize(IExpr expr) {
        if (expr.isPresent()) {
            byte[] byArray;
            WriteObject wo = new WriteObject();
            try {
                wo.write(expr);
                byArray = wo.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        wo.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.debug("WL.serialize() failed", (Throwable)e);
                }
            }
            wo.close();
            return byArray;
        }
        return null;
    }

    public static byte[] serializeInternal(IExpr expr) {
        if (expr.isPresent()) {
            byte[] byArray;
            WriteInternalObject wo = new WriteInternalObject();
            try {
                wo.write(expr);
                byArray = wo.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        wo.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.debug("WL.serializeInternal() failed", (Throwable)e);
                }
            }
            wo.close();
            return byArray;
        }
        return null;
    }

    public static byte[] toByteArray(IAST list) {
        byte[] result = new byte[list.size() - 1];
        for (int i = 1; i < list.size(); ++i) {
            int val;
            if (!list.get(i).isInteger() || (val = ((IInteger)list.get(i)).toIntDefault()) < 0 || val >= 256) {
                return null;
            }
            result[i - 1] = (byte)val;
        }
        return result;
    }

    public static IASTMutable toList(byte[] bArray) {
        IASTAppendable list = F.ListAlloc(bArray.length);
        for (int i = 0; i < bArray.length; ++i) {
            int value = 0xFF & bArray[i];
            list.append(value);
        }
        return list;
    }

    public static byte[] varintBytes(int length) {
        int next;
        byte[] buf = new byte[9];
        if (length < 0) {
            throw new UnsupportedOperationException("Negative values cannot be encoded as varint.");
        }
        int count = 0;
        while (true) {
            next = length & 0x7F;
            if ((length >>= 7) == 0) break;
            buf[count] = (byte)(next | 0x80);
            ++count;
        }
        buf[count] = (byte)next;
        byte[] result = new byte[++count];
        for (int i = 0; i < count; ++i) {
            result[i] = buf[i];
        }
        return result;
    }

    private static class WriteInternalObject
    extends WriteObject {
        public WriteInternalObject() {
        }

        public WriteInternalObject(ByteArrayOutputStream stream) {
            super(stream);
        }

        @Override
        public void write(IExpr arg1) throws IOException {
            Short exprID = S.GLOBAL_IDS_MAP.get(arg1);
            if (exprID != null) {
                this.stream.write(-47);
                this.stream.write(WL.varintBytes(exprID.shortValue()));
                return;
            }
            super.write(arg1);
        }
    }

    private static class WriteObject
    implements Closeable {
        ByteArrayOutputStream stream;

        public WriteObject() {
            this(new ByteArrayOutputStream());
        }

        public WriteObject(ByteArrayOutputStream stream) {
            this.stream = stream;
            stream.write(56);
            stream.write(58);
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }

        public byte[] toByteArray() {
            return this.stream.toByteArray();
        }

        public void write(IExpr arg1) throws IOException {
            int hier = arg1.hierarchy();
            switch (hier) {
                case 1024: {
                    this.writeAST(arg1);
                    return;
                }
                case 512: {
                    this.writeSymbol(arg1);
                    return;
                }
                case 32: {
                    this.writeAST2(S.Complex, ((IComplex)arg1).re(), ((IComplex)arg1).im());
                    return;
                }
                case 8: {
                    this.writeInteger(arg1);
                    return;
                }
                case 16: {
                    this.writeAST2(S.Rational, ((IRational)arg1).numerator(), ((IRational)arg1).denominator());
                    return;
                }
                case 2: {
                    this.stream.write(114);
                    this.writeDouble(((INum)arg1).doubleValue());
                    return;
                }
                case 4: {
                    this.writeAST2(S.Complex, ((IComplexNum)arg1).re(), ((IComplexNum)arg1).im());
                    return;
                }
                case 256: {
                    this.writeString(arg1);
                    return;
                }
                case 32787: {
                    this.writeBinaryString(arg1);
                    return;
                }
                case 4096: {
                    IPattern blank = (IPattern)arg1;
                    IExpr blankCondition = blank.getHeadTest();
                    if (blank.isPatternDefault()) {
                        blank = F.$b();
                        this.writeAST1(S.Optional, blank);
                    } else if (blankCondition != null) {
                        this.writeAST1(S.Blank, blankCondition);
                    } else {
                        this.writeAST0(S.Blank);
                    }
                    return;
                }
                case 2048: {
                    if (arg1 instanceof IPatternSequence) {
                        IPatternSequence pat = (IPatternSequence)arg1;
                        IExpr condition = pat.getHeadTest();
                        ISymbol symbol = pat.getSymbol();
                        if (symbol == null) {
                            if (pat.isNullSequence()) {
                                if (condition != null) {
                                    this.writeAST1(S.BlankNullSequence, condition);
                                } else {
                                    this.writeAST0(S.BlankNullSequence);
                                }
                            } else if (condition != null) {
                                this.writeAST1(S.BlankSequence, condition);
                            } else {
                                this.writeAST0(S.BlankSequence);
                            }
                        } else if (pat.isNullSequence()) {
                            if (condition != null) {
                                this.writeAST2(S.Pattern, pat.getSymbol(), F.unaryAST1(S.BlankNullSequence, condition));
                            } else {
                                this.writeAST2(S.Pattern, pat.getSymbol(), F.headAST0(S.BlankNullSequence));
                            }
                        } else if (condition != null) {
                            this.writeAST2(S.Pattern, pat.getSymbol(), F.unaryAST1(S.BlankSequence, condition));
                        } else {
                            this.writeAST2(S.Pattern, pat.getSymbol(), F.headAST0(S.BlankSequence));
                        }
                    } else {
                        IPattern pat = (IPattern)arg1;
                        IExpr condition = pat.getHeadTest();
                        if (pat.isPatternDefault()) {
                            pat = F.$p(pat.getSymbol());
                            this.writeAST1(S.Optional, pat);
                        } else if (condition != null) {
                            this.writeAST2(S.Pattern, pat.getSymbol(), F.unaryAST1(S.Blank, condition));
                        } else {
                            this.writeAST2(S.Pattern, pat.getSymbol(), F.headAST0(S.Blank));
                        }
                    }
                    return;
                }
                case 128: {
                    this.writeQuantity(arg1);
                    return;
                }
                case 64: {
                    this.writeSeriesData(arg1);
                    return;
                }
                case 32795: {
                    this.writeSparseArray((SparseArrayExpr)arg1);
                    return;
                }
                case 32796: {
                    this.writeNumericArray((NumericArrayExpr)arg1);
                }
            }
        }

        private void writeAST(IExpr arg1) throws IOException {
            IAST ast = (IAST)arg1;
            if (ast instanceof ASTRealVector) {
                RealVector vector = ((ASTRealVector)ast).getRealVector();
                this.stream.write(-63);
                this.stream.write(35);
                this.stream.write(1);
                this.stream.write(WL.varintBytes(vector.getDimension()));
                for (int i = 0; i < vector.getDimension(); ++i) {
                    this.writeDouble(vector.getEntry(i));
                }
                return;
            }
            if (ast instanceof ASTRealMatrix) {
                RealMatrix matrix = ((ASTRealMatrix)ast).getRealMatrix();
                this.stream.write(-63);
                this.stream.write(35);
                this.stream.write(2);
                this.stream.write(WL.varintBytes(matrix.getRowDimension()));
                this.stream.write(WL.varintBytes(matrix.getColumnDimension()));
                for (int i = 0; i < matrix.getRowDimension(); ++i) {
                    for (int j = 0; j < matrix.getColumnDimension(); ++j) {
                        this.writeDouble(matrix.getEntry(i, j));
                    }
                }
                return;
            }
            if (ast instanceof ASTAssociation) {
                this.stream.write(65);
                this.stream.write(WL.varintBytes(ast.argSize()));
                for (int i = 1; i < ast.size(); ++i) {
                    IAST rule = (IAST)ast.getRule(i);
                    if (rule.isRuleDelayed()) {
                        this.stream.write(58);
                    } else {
                        this.stream.write(45);
                    }
                    this.write(rule.arg1());
                    this.write(rule.arg2());
                }
                return;
            }
            this.stream.write(102);
            this.stream.write(WL.varintBytes(ast.argSize()));
            for (int i = 0; i < ast.size(); ++i) {
                this.write(ast.get(i));
            }
        }

        private void writePackedArray(IAST list) throws IOException {
            NumericArrayExpr numericArray = NumericArrayExpr.newListByType(list, (byte)-1, S.Integers);
            if (numericArray != null) {
                this.stream.write(-63);
                byte arrayType = numericArray.getType();
                this.stream.write(arrayType);
                this.writeNumericArrayData(arrayType, numericArray);
            } else {
                this.write(list);
            }
        }

        private void writeSparseArray(SparseArrayExpr sparseArray) throws IOException {
            IASTAppendable fullForm = sparseArray.fullForm();
            if (fullForm.size() == 5) {
                this.stream.write(102);
                this.stream.write(WL.varintBytes(fullForm.argSize()));
                this.write(fullForm.head());
                this.write(fullForm.arg1());
                this.writePackedArray((IAST)fullForm.arg2());
                this.write(fullForm.arg3());
                IAST list = (IAST)fullForm.arg4();
                this.stream.write(102);
                this.stream.write(WL.varintBytes(list.argSize()));
                this.write(S.List);
                this.write(list.arg1());
                IAST list2 = (IAST)list.arg2();
                this.stream.write(102);
                this.stream.write(WL.varintBytes(list2.argSize()));
                this.write(S.List);
                this.writePackedArray((IAST)list2.arg1());
                this.writePackedArray((IAST)list2.arg2());
                this.writePackedArray((IAST)list.arg3());
            } else {
                this.write(fullForm);
            }
        }

        private void writeNumericArray(NumericArrayExpr numericArray) throws IOException {
            byte arrayType = numericArray.getType();
            byte[] buf = new byte[]{-62, arrayType};
            this.stream.write(buf);
            this.writeNumericArrayData(arrayType, numericArray);
        }

        private void writeNumericArrayData(byte arrayType, NumericArrayExpr numericArray) throws IOException {
            int[] dimensions = numericArray.getDimension();
            int rank = dimensions.length;
            this.stream.write(WL.varintBytes(rank));
            int size = 1;
            for (int i = 0; i < rank; ++i) {
                this.stream.write(dimensions[i]);
                size *= dimensions[i];
            }
            switch (arrayType) {
                case 0: 
                case 16: {
                    byte[] byteArr = (byte[])numericArray.toData();
                    this.stream.write(byteArr, 0, size);
                    return;
                }
                case 1: 
                case 17: {
                    short[] shortArr = (short[])numericArray.toData();
                    for (int i = 0; i < shortArr.length; ++i) {
                        this.writeInteger16(shortArr[i]);
                    }
                    return;
                }
                case 2: 
                case 18: {
                    int[] intArr = (int[])numericArray.toData();
                    for (int i = 0; i < intArr.length; ++i) {
                        this.writeInteger32(intArr[i]);
                    }
                    return;
                }
                case 3: 
                case 19: {
                    long[] longArr = (long[])numericArray.toData();
                    for (int i = 0; i < longArr.length; ++i) {
                        this.writeInteger64(longArr[i]);
                    }
                    return;
                }
                case 34: {
                    float[] floatArr = (float[])numericArray.toData();
                    for (int i = 0; i < floatArr.length; ++i) {
                        this.writeFloat(floatArr[i]);
                    }
                    return;
                }
                case 35: {
                    double[] doubleArr = (double[])numericArray.toData();
                    for (int i = 0; i < doubleArr.length; ++i) {
                        this.writeDouble(doubleArr[i]);
                    }
                    return;
                }
                case 51: {
                    float[] floatArr = (float[])numericArray.toData();
                    int doubledSize = floatArr.length;
                    int i = 0;
                    while (i < doubledSize) {
                        this.writeFloat(floatArr[i++]);
                    }
                    return;
                }
                case 52: {
                    double[] doubleArr = (double[])numericArray.toData();
                    int doubledSize = doubleArr.length;
                    int i = 0;
                    while (i < doubledSize) {
                        this.writeDouble(doubleArr[i++]);
                    }
                    break;
                }
            }
        }

        private void writeQuantity(IExpr arg1) throws IOException {
            IQuantity quantity = (IQuantity)arg1;
            this.stream.write(102);
            this.stream.write(WL.varintBytes(2));
            this.write(quantity.head());
            this.write(quantity.value());
            this.write(F.stringx(quantity.unitString()));
        }

        private void writeSeriesData(IExpr arg1) throws IOException {
            ASTSeriesData ast = (ASTSeriesData)arg1;
            this.stream.write(102);
            this.stream.write(WL.varintBytes(ast.argSize()));
            for (int i = 0; i < ast.size(); ++i) {
                this.write(ast.get(i));
            }
        }

        private void writeAST0(IExpr head) throws IOException {
            this.stream.write(102);
            this.stream.write(0);
            this.write(head);
        }

        private void writeAST1(IExpr head, IExpr arg1) throws IOException {
            this.stream.write(102);
            this.stream.write(1);
            this.write(head);
            this.write(arg1);
        }

        private void writeAST2(IExpr head, IExpr arg1, IExpr arg2) throws IOException {
            this.stream.write(102);
            this.stream.write(2);
            this.write(head);
            this.write(arg1);
            this.write(arg2);
        }

        private void writeFloat(float f) {
            int bits = Float.floatToIntBits(f);
            this.stream.write((byte)(bits & 0xFF));
            this.stream.write((byte)(bits >> 8 & 0xFF));
            this.stream.write((byte)(bits >> 16 & 0xFF));
            this.stream.write((byte)(bits >> 24 & 0xFF));
        }

        private void writeDouble(double d) {
            long bits = Double.doubleToRawLongBits(d);
            this.stream.write((byte)(bits & 0xFFL));
            this.stream.write((byte)(bits >> 8 & 0xFFL));
            this.stream.write((byte)(bits >> 16 & 0xFFL));
            this.stream.write((byte)(bits >> 24 & 0xFFL));
            this.stream.write((byte)(bits >> 32 & 0xFFL));
            this.stream.write((byte)(bits >> 40 & 0xFFL));
            this.stream.write((byte)(bits >> 48 & 0xFFL));
            this.stream.write((byte)(bits >> 56 & 0xFFL));
        }

        private void writeInteger(IExpr arg1) throws IOException {
            block6: {
                IInteger s;
                block4: {
                    int bits;
                    block7: {
                        block5: {
                            s = (IInteger)arg1;
                            if (!(s instanceof IntegerSym)) break block4;
                            bits = ((IntegerSym)s).intValue();
                            if (-128 > bits || bits > 127) break block5;
                            this.stream.write(67);
                            this.stream.write((byte)bits);
                            break block6;
                        }
                        if (Short.MIN_VALUE > bits || bits > Short.MAX_VALUE) break block7;
                        this.stream.write(106);
                        this.writeInteger16((short)bits);
                        break block6;
                    }
                    if (Integer.MIN_VALUE > bits || bits > Integer.MAX_VALUE) break block6;
                    this.stream.write(105);
                    this.writeInteger32(bits);
                    break block6;
                }
                if (s instanceof BigIntegerSym) {
                    try {
                        long bits = ((BigIntegerSym)s).toLong();
                        this.stream.write(76);
                        this.writeInteger64(bits);
                    }
                    catch (ArithmeticException ae) {
                        String big = ((BigIntegerSym)s).toBigNumerator().toString();
                        this.stream.write(73);
                        this.stream.write(WL.varintBytes(big.length()));
                        for (int i = 0; i < big.length(); ++i) {
                            this.stream.write(big.charAt(i));
                        }
                    }
                }
            }
        }

        private void writeInteger8(byte bits) {
            this.stream.write(bits);
        }

        private void writeInteger16(short bits) {
            this.stream.write((byte)(bits & 0xFF));
            this.stream.write((byte)(bits >> 8 & 0xFF));
        }

        private void writeInteger32(int bits) {
            this.stream.write((byte)(bits & 0xFF));
            this.stream.write((byte)(bits >> 8 & 0xFF));
            this.stream.write((byte)(bits >> 16 & 0xFF));
            this.stream.write((byte)(bits >> 24 & 0xFF));
        }

        private void writeInteger64(long bits) {
            this.stream.write((byte)(bits & 0xFFL));
            this.stream.write((byte)(bits >> 8 & 0xFFL));
            this.stream.write((byte)(bits >> 16 & 0xFFL));
            this.stream.write((byte)(bits >> 24 & 0xFFL));
            this.stream.write((byte)(bits >> 32 & 0xFFL));
            this.stream.write((byte)(bits >> 40 & 0xFFL));
            this.stream.write((byte)(bits >> 48 & 0xFFL));
            this.stream.write((byte)(bits >> 56 & 0xFFL));
        }

        private void writeString(IExpr arg1) throws IOException {
            IStringX s = (IStringX)arg1;
            char[] str = s.toString().toCharArray();
            int size = str.length;
            this.stream.write(83);
            this.stream.write(WL.varintBytes(size));
            for (int i = 0; i < size; ++i) {
                this.stream.write(str[i]);
            }
        }

        private void writeBinaryString(IExpr arg1) throws IOException {
            byte[] bArray = (byte[])((ByteArrayExpr)arg1).toData();
            int size = bArray.length;
            this.stream.write(66);
            this.stream.write(WL.varintBytes(size));
            this.stream.write(bArray, 0, size);
        }

        private void writeSymbol(IExpr arg1) throws IOException {
            ISymbol s = (ISymbol)arg1;
            Context context = s.getContext();
            char[] str = context == Context.SYSTEM ? s.toString().toCharArray() : (context.getContextName() + s.getSymbolName()).toCharArray();
            int size = str.length;
            this.stream.write(115);
            this.stream.write(WL.varintBytes(size));
            for (int i = 0; i < size; ++i) {
                this.stream.write(str[i]);
            }
        }
    }

    private static class ReadInternalObject
    extends ReadObject {
        public ReadInternalObject(byte[] array) {
            super(array);
        }

        public ReadInternalObject(byte[] array, int position) {
            super(array, position);
        }

        @Override
        protected IExpr internalRead(byte exprType) {
            if (exprType == -47) {
                return S.exprID((short)this.parseLength());
            }
            return super.internalRead(exprType);
        }
    }

    private static class ReadObject {
        byte[] array;
        int position;

        public ReadObject(byte[] array) {
            this(array, 2);
        }

        public ReadObject(byte[] array, int position) {
            this.array = array;
            this.position = position;
        }

        protected int parseLength() {
            int[] result = WL.parseVarint(this.array, this.position);
            this.position = result[1];
            return result[0];
        }

        public IExpr read() {
            byte exprType = this.array[this.position++];
            try {
                return this.internalRead(exprType);
            }
            catch (AbortException abortException) {
                return F.NIL;
            }
        }

        protected IExpr internalRead(byte exprType) throws AbortException {
            switch (exprType) {
                case 67: {
                    byte value = this.array[this.position++];
                    return F.ZZ(value);
                }
                case 106: {
                    ByteBuffer b16 = ByteBuffer.wrap(this.array, this.position, 2);
                    b16.order(ByteOrder.LITTLE_ENDIAN);
                    short v = b16.getShort();
                    this.position += 2;
                    return F.ZZ(v);
                }
                case 105: {
                    ByteBuffer b32 = ByteBuffer.wrap(this.array, this.position, 4);
                    b32.order(ByteOrder.LITTLE_ENDIAN);
                    int iValue = b32.getInt();
                    this.position += 4;
                    return F.ZZ(iValue);
                }
                case 76: {
                    ByteBuffer b64 = ByteBuffer.wrap(this.array, this.position, 8);
                    b64.order(ByteOrder.LITTLE_ENDIAN);
                    long lValue = b64.getLong();
                    this.position += 8;
                    return F.ZZ(lValue);
                }
                case 73: {
                    int length = this.parseLength();
                    StringBuilder bigIntegerString = new StringBuilder();
                    for (int i = 0; i < length; ++i) {
                        char ch = (char)this.array[this.position++];
                        bigIntegerString.append(ch);
                    }
                    return F.ZZ(new BigInteger(bigIntegerString.toString()));
                }
                case 82: {
                    int length = this.parseLength();
                    StringBuilder brStr = new StringBuilder();
                    for (int i = 0; i < length; ++i) {
                        brStr.append((char)this.array[this.position++]);
                    }
                    String s = brStr.toString();
                    int index = s.indexOf(96);
                    if (index <= 0) break;
                    String numStr = s.substring(0, index);
                    String precString = s.substring(index + 1);
                    if ((index = precString.indexOf(46)) <= 0) break;
                    int prec = Integer.parseInt(precString.substring(0, index));
                    Apfloat af = new Apfloat(numStr, (long)prec, 10);
                    return F.num(af);
                }
                case 114: {
                    double real64 = this.parseDouble();
                    return F.num(real64);
                }
                case -63: {
                    return this.readPackedArray();
                }
                case -62: {
                    return this.readNumericArray();
                }
                case 115: {
                    return this.readSymbol();
                }
                case 102: {
                    IFunctionEvaluator evaluator;
                    IExpr temp;
                    int length = this.parseLength();
                    IASTAppendable ast = F.ast((IExpr)F.NIL, length);
                    ast.set(0, this.read());
                    for (int i = 0; i < length; ++i) {
                        ast.append(this.read());
                    }
                    IExpr head = ast.head();
                    if ((head == S.Complex || head == S.Rational || head == S.Pattern || head == S.Optional) && (temp = (evaluator = (IFunctionEvaluator)((IBuiltInSymbol)head).getEvaluator()).evaluate(ast, EvalEngine.get())).isPresent()) {
                        return temp;
                    }
                    return ast;
                }
                case 65: {
                    int length = this.parseLength();
                    ASTAssociation assoc = new ASTAssociation();
                    for (int i = 0; i < length; ++i) {
                        byte value = this.array[this.position++];
                        IBuiltInSymbol ruleHead = S.Rule;
                        if (value == 58) {
                            ruleHead = S.RuleDelayed;
                        }
                        IExpr arg1 = this.read();
                        IExpr arg2 = this.read();
                        assoc.appendRule(F.binaryAST2((IExpr)ruleHead, arg1, arg2));
                    }
                    return assoc;
                }
                case 83: {
                    int length = this.parseLength();
                    StringBuilder str = new StringBuilder();
                    for (int i = 0; i < length; ++i) {
                        str.append((char)this.array[this.position++]);
                    }
                    return F.stringx(str);
                }
                case 66: {
                    int length = this.parseLength();
                    byte[] bArray = new byte[length];
                    System.arraycopy(this.array, this.position, bArray, 0, length);
                    this.position += length;
                    return ByteArrayExpr.newInstance(bArray);
                }
            }
            throw AbortException.ABORTED;
        }

        private IExpr readPackedArray() throws AbortException {
            byte arrayType = this.array[this.position++];
            switch (arrayType) {
                case 0: {
                    int rank = this.parseLength();
                    int[] dimensions = new int[rank];
                    for (int i = 0; i < rank; ++i) {
                        dimensions[i] = this.parseLength();
                    }
                    if (rank == 1) {
                        IASTAppendable list = F.ListAlloc(dimensions[0]);
                        for (int i = 0; i < dimensions[0]; ++i) {
                            int value = this.parseInteger8();
                            list.append(value);
                        }
                        return list;
                    }
                    if (rank != 2) break;
                    IASTAppendable m = F.ListAlloc(dimensions[0]);
                    for (int i = 0; i < dimensions[0]; ++i) {
                        IASTAppendable row = F.ListAlloc(dimensions[1]);
                        for (int j = 0; j < dimensions[1]; ++j) {
                            row.append(this.parseInteger8());
                        }
                        m.append(row);
                    }
                    return m;
                }
                case 35: {
                    int rank = this.parseLength();
                    int[] dimensions = new int[rank];
                    for (int i = 0; i < rank; ++i) {
                        dimensions[i] = this.parseLength();
                    }
                    if (rank == 1) {
                        double[] vector = new double[dimensions[0]];
                        for (int i = 0; i < vector.length; ++i) {
                            double d;
                            vector[i] = d = this.parseDouble();
                        }
                        return new ASTRealVector(vector, false);
                    }
                    if (rank != 2) break;
                    double[][] matrix = new double[dimensions[0]][dimensions[1]];
                    for (int i = 0; i < dimensions[0]; ++i) {
                        for (int j = 0; j < dimensions[1]; ++j) {
                            double d;
                            matrix[i][j] = d = this.parseDouble();
                        }
                    }
                    return new ASTRealMatrix(matrix, false);
                }
            }
            throw AbortException.ABORTED;
        }

        private IExpr readNumericArray() throws AbortException {
            byte arrayType = this.array[this.position++];
            int rank = this.parseLength();
            int[] dimensions = new int[rank];
            int size = 1;
            for (int i = 0; i < rank; ++i) {
                dimensions[i] = this.parseLength();
                size *= dimensions[i];
            }
            switch (arrayType) {
                case 0: 
                case 16: {
                    byte[] byteArr = new byte[size];
                    System.arraycopy(this.array, this.position, byteArr, 0, size);
                    this.position += size;
                    return NumericArrayExpr.newInstance(byteArr, dimensions, arrayType);
                }
                case 1: 
                case 17: {
                    short[] shortArr = new short[size];
                    for (int i = 0; i < size; ++i) {
                        shortArr[i] = this.parseInteger16();
                    }
                    return NumericArrayExpr.newInstance(shortArr, dimensions, arrayType);
                }
                case 2: 
                case 18: {
                    int[] intArr = new int[size];
                    for (int i = 0; i < size; ++i) {
                        intArr[i] = this.parseInteger32();
                    }
                    return NumericArrayExpr.newInstance(intArr, dimensions, arrayType);
                }
                case 3: 
                case 19: {
                    long[] longArr = new long[size];
                    for (int i = 0; i < size; ++i) {
                        longArr[i] = this.parseInteger64();
                    }
                    return NumericArrayExpr.newInstance(longArr, dimensions, arrayType);
                }
                case 34: {
                    float[] floatArr = new float[size];
                    for (int i = 0; i < size; ++i) {
                        floatArr[i] = this.parseFloat();
                    }
                    return NumericArrayExpr.newInstance(floatArr, dimensions, arrayType);
                }
                case 35: {
                    double[] doubleArr = new double[size];
                    for (int i = 0; i < size; ++i) {
                        doubleArr[i] = this.parseDouble();
                    }
                    return NumericArrayExpr.newInstance(doubleArr, dimensions, arrayType);
                }
                case 51: {
                    int doubledSize = size * 2;
                    float[] floatArr = new float[doubledSize];
                    int i = 0;
                    while (i < doubledSize) {
                        floatArr[i++] = this.parseFloat();
                        floatArr[i++] = this.parseFloat();
                    }
                    return NumericArrayExpr.newInstance(floatArr, dimensions, arrayType);
                }
                case 52: {
                    int doubledSize = size * 2;
                    double[] doubleArr = new double[doubledSize];
                    int i = 0;
                    while (i < doubledSize) {
                        doubleArr[i++] = this.parseDouble();
                        doubleArr[i++] = this.parseDouble();
                    }
                    return NumericArrayExpr.newInstance(doubleArr, dimensions, arrayType);
                }
            }
            throw AbortException.ABORTED;
        }

        private int parseInteger8() {
            byte b = this.array[this.position++];
            return b;
        }

        private short parseInteger16() {
            int bits = 0;
            this.position += 2;
            int pos2 = this.position - 1;
            bits = (this.array[pos2--] & 0xFF) << 8 | this.array[pos2--] & 0xFF;
            return (short)bits;
        }

        private int parseInteger32() {
            int bits = 0;
            this.position += 4;
            int pos2 = this.position - 1;
            bits = (bits | this.array[pos2--] & 0xFF) << 8;
            bits = (bits | this.array[pos2--] & 0xFF) << 8;
            bits = (bits | this.array[pos2--] & 0xFF) << 8;
            return bits |= this.array[pos2--] & 0xFF;
        }

        private long parseInteger64() {
            long bits = 0L;
            this.position += 8;
            int pos2 = this.position - 1;
            bits = (bits | (long)(this.array[pos2--] & 0xFF)) << 8;
            bits = (bits | (long)(this.array[pos2--] & 0xFF)) << 8;
            bits = (bits | (long)(this.array[pos2--] & 0xFF)) << 8;
            bits = (bits | (long)(this.array[pos2--] & 0xFF)) << 8;
            bits = (bits | (long)(this.array[pos2--] & 0xFF)) << 8;
            bits = (bits | (long)(this.array[pos2--] & 0xFF)) << 8;
            bits = (bits | (long)(this.array[pos2--] & 0xFF)) << 8;
            return bits |= (long)(this.array[pos2--] & 0xFF);
        }

        private float parseFloat() {
            int bits = 0;
            this.position += 4;
            int pos2 = this.position - 1;
            bits = (bits | this.array[pos2--] & 0xFF) << 8;
            bits = (bits | this.array[pos2--] & 0xFF) << 8;
            bits = (bits | this.array[pos2--] & 0xFF) << 8;
            return Float.intBitsToFloat(bits |= this.array[pos2--] & 0xFF);
        }

        private double parseDouble() {
            long bits = 0L;
            this.position += 8;
            int pos2 = this.position - 1;
            bits = (bits | (long)(this.array[pos2--] & 0xFF)) << 8;
            bits = (bits | (long)(this.array[pos2--] & 0xFF)) << 8;
            bits = (bits | (long)(this.array[pos2--] & 0xFF)) << 8;
            bits = (bits | (long)(this.array[pos2--] & 0xFF)) << 8;
            bits = (bits | (long)(this.array[pos2--] & 0xFF)) << 8;
            bits = (bits | (long)(this.array[pos2--] & 0xFF)) << 8;
            bits = (bits | (long)(this.array[pos2--] & 0xFF)) << 8;
            return Double.longBitsToDouble(bits |= (long)(this.array[pos2--] & 0xFF));
        }

        private IExpr readSymbol() {
            EvalEngine engine;
            int contextStart;
            int length = this.parseLength();
            StringBuilder symbol = new StringBuilder();
            int contextEnd = contextStart = this.position;
            for (int i = 0; i < length; ++i) {
                char ch;
                if ((ch = (char)this.array[this.position++]) == '`') {
                    contextEnd = this.position;
                }
                symbol.append(ch);
            }
            String lcSymbolName = symbol.toString();
            String contextName = "";
            if (contextEnd > contextStart) {
                contextName = lcSymbolName.substring(0, contextEnd - contextStart);
                lcSymbolName = lcSymbolName.substring(contextEnd - contextStart);
            }
            if ((engine = EvalEngine.get()).isRelaxedSyntax() && lcSymbolName.length() > 1) {
                lcSymbolName = lcSymbolName.toLowerCase(Locale.ENGLISH);
            }
            if (contextEnd == contextStart || contextName.equals("System`")) {
                ISymbol sym = Context.SYSTEM.get(lcSymbolName);
                if (sym != null) {
                    return sym;
                }
            } else if (contextName.equals("Rubi`")) {
                return F.$rubi(lcSymbolName);
            }
            ContextPath contextPath = engine.getContextPath();
            Context context = contextPath.getContext(contextName);
            return ContextPath.getSymbol(lcSymbolName, context, engine.isRelaxedSyntax());
        }
    }

    static class ARRAY_TYPES_ELEM_SIZE {
        static final byte Integer8 = 1;
        static final byte Integer16 = 2;
        static final byte Integer32 = 4;
        static final byte Integer64 = 8;
        static final byte UnsignedInteger8 = 1;
        static final byte UnsignedInteger16 = 2;
        static final byte UnsignedInteger32 = 4;
        static final byte UnsignedInteger64 = 8;
        static final byte Real32 = 4;
        static final byte Real64 = 8;
        static final byte ComplexReal32 = 8;
        static final byte ComplexReal64 = 16;

        ARRAY_TYPES_ELEM_SIZE() {
        }
    }

    private static class WXF_CONSTANTS {
        static final byte Function = 102;
        static final byte Symbol = 115;
        static final byte String = 83;
        static final byte BinaryString = 66;
        static final byte Integer8 = 67;
        static final byte Integer16 = 106;
        static final byte Integer32 = 105;
        static final byte Integer64 = 76;
        static final byte Real64 = 114;
        static final byte BigInteger = 73;
        static final byte BigReal = 82;
        static final byte PackedArray = -63;
        static final byte RawArray = -62;
        static final byte Association = 65;
        static final byte Rule = 45;
        static final byte RuleDelayed = 58;
        static final byte InternalExprID = -47;

        private WXF_CONSTANTS() {
        }
    }
}

