/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.AttributeFunctions;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.exception.RuleCreationError;
import org.matheclipse.core.expression.AbstractAST;
import org.matheclipse.core.expression.Context;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.StringX;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.generic.UnaryVariable2Slot;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcherAndInvoker;
import org.matheclipse.core.patternmatching.RulesData;
import org.matheclipse.core.polynomials.longexponent.ExprPolynomialRing;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;
import org.matheclipse.parser.client.ParserConfig;

public class Symbol
implements ISymbol,
Serializable {
    private static final long serialVersionUID = 6048546131696113624L;
    private static final Logger LOGGER = LogManager.getLogger();
    protected transient Context fContext;
    protected int fAttributes = 0;
    protected int fEvalFlags = 0;
    private transient IExpr fValue;
    protected transient RulesData fRulesData;
    protected String fSymbolName;

    public Symbol(String symbolName, Context context) {
        this.fContext = context;
        this.fSymbolName = symbolName;
    }

    @Override
    public IExpr accept(IVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return visitor.visit(this);
    }

    @Override
    public final void addAttributes(int attributes) {
        this.fAttributes |= attributes;
        if (this.isLocked()) {
            throw new RuleCreationError(this);
        }
        EvalEngine engine = EvalEngine.get();
        engine.addModifiedVariable(this);
    }

    @Override
    public final ISymbol addEvalFlags(int flags) {
        this.fEvalFlags |= flags;
        return this;
    }

    @Override
    public final IExpr apply(IExpr ... expressions) {
        return F.function(this, expressions);
    }

    @Override
    public final IExpr assignedValue() {
        if (this instanceof IBuiltInSymbol) {
            return this.fValue;
        }
        this.addEvalFlags(1);
        return this.fValue;
    }

    @Override
    public void assignValue(IExpr value, boolean setDelayed) {
        this.fValue = value;
        this.clearEvalFlags(1);
        if (setDelayed) {
            this.addEvalFlags(0x10000002);
        } else {
            this.clearEvalFlags(0x10000002);
        }
    }

    @Override
    public final void clear(EvalEngine engine) {
        if (!engine.isPackageMode() && this.isLocked()) {
            throw new RuleCreationError(this);
        }
        this.clearValue();
        if (this.fRulesData != null) {
            this.fRulesData.clear();
        }
    }

    @Override
    public void clearAll(EvalEngine engine) {
        if (!engine.isPackageMode() && this.isLocked()) {
            throw new RuleCreationError(this);
        }
        this.fAttributes = 0;
        this.clearValue();
        if (this.fRulesData != null) {
            this.fRulesData = null;
        }
    }

    @Override
    public void clearAttributes(int attributes) {
        this.fAttributes &= 0xFFFFFFFF ^ attributes;
        if (this.isLocked()) {
            throw new RuleCreationError(this);
        }
        EvalEngine engine = EvalEngine.get();
        engine.addModifiedVariable(this);
    }

    @Override
    public void clearEvalFlags(int flags) {
        this.fEvalFlags &= 0xFFFFFFFF ^ flags;
    }

    @Override
    public void clearValue() {
        this.fValue = null;
        this.clearEvalFlags(1);
    }

    @Override
    public int compareTo(IExpr expr) {
        int y;
        if (expr instanceof ISymbol) {
            if (this == expr) {
                return 0;
            }
            return StringX.US_COLLATOR.compare(this.fSymbolName, ((ISymbol)expr).getSymbolName());
        }
        if (expr.isAST()) {
            int id = expr.headID();
            if (id == 355 && expr.isDirectedInfinity()) {
                return -1;
            }
            if (id >= 922 && id <= 1036) {
                if (expr.isNot() && expr.first().isSymbol()) {
                    int cp = this.compareTo(expr.first());
                    return cp != 0 ? cp : -1;
                }
                if (expr.isPower()) {
                    int baseCompare = this.compareTo(expr.base());
                    if (baseCompare == 0) {
                        return F.C1.compareTo(expr.exponent());
                    }
                    return baseCompare;
                }
            }
            return -1 * expr.compareTo(this);
        }
        int x = this.hierarchy();
        return x < (y = expr.hierarchy()) ? -1 : (x == y ? 0 : 1);
    }

    @Override
    public boolean containsRules() {
        return this.fRulesData != null;
    }

    public IExpr copy() {
        try {
            return (IExpr)this.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("Symbol.copy() failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public final RulesData createRulesData(int[] sizes) {
        if (this.fRulesData == null) {
            this.fRulesData = new RulesData(sizes);
        }
        return this.fRulesData;
    }

    @Override
    public IAST definition() {
        List<IAST> rules = null;
        if (this.fRulesData != null) {
            rules = this.fRulesData.definition();
        }
        IASTAppendable result = F.ListAlloc(rules == null ? 1 : rules.size());
        if (this.hasAssignedSymbolValue()) {
            if (this.isEvalFlagOn(0x10000002)) {
                result.append(F.SetDelayed(this, this.assignedValue()));
            } else {
                result.append(F.Set(this, this.assignedValue()));
            }
        }
        if (rules != null) {
            result.appendAll(rules);
        }
        return result;
    }

    @Override
    public String definitionToString() {
        StringWriter buf = new StringWriter();
        IAST attributesList = AttributeFunctions.attributesList(this);
        if (attributesList.size() > 1) {
            buf.append("Attributes(");
            buf.append(this.toString());
            buf.append(")=");
            buf.append(attributesList.toString());
            buf.append("\n");
        }
        OutputFormFactory off = OutputFormFactory.get(EvalEngine.get().isRelaxedSyntax());
        off.setIgnoreNewLine(true);
        IAST list = this.definition();
        for (int i = 1; i < list.size(); ++i) {
            if (!off.convert(buf, list.get(i))) {
                return "ERROR-IN-OUTPUTFORM";
            }
            if (i >= list.size() - 1) continue;
            buf.append("\n");
            off.setColumnCounter(0);
        }
        return buf.toString();
    }

    @Override
    public IExpr divide(IExpr that) {
        IExpr inverse = that.inverse();
        if (inverse.isOne()) {
            return this;
        }
        if (inverse.isMinusOne()) {
            return this.negate();
        }
        if (this.hasNoValue() && this != that && !that.isPlusTimesPower()) {
            return F.Times((IExpr)this, inverse);
        }
        return ISymbol.super.times(inverse);
    }

    public boolean equals(Object obj) {
        if (Config.FUZZ_TESTING && obj instanceof ISymbol && this.fSymbolName.equals(((ISymbol)obj).getSymbolName()) && this.fContext.equals(((ISymbol)obj).getContext()) && this != obj) {
            throw new NullPointerException();
        }
        return this == obj;
    }

    @Override
    public final IExpr evalDownRule(EvalEngine engine, IExpr expression) {
        if (this.fRulesData == null) {
            return F.NIL;
        }
        return this.fRulesData.evalDownRule(expression, engine);
    }

    @Override
    public IExpr evalMessage(String messageName) {
        IExpr temp;
        if (this.fRulesData != null && (temp = (IExpr)this.fRulesData.getMessages().get(messageName)) != null) {
            return temp;
        }
        return F.NIL;
    }

    @Override
    public final INumber evalNumber() {
        IExpr result;
        IExpr temp;
        if (this.isNumericFunction(true)) {
            IExpr result2 = F.evaln(this);
            if (result2.isNumber()) {
                return (INumber)result2;
            }
        } else if (this.hasAssignedSymbolValue() && (temp = this.assignedValue()) != null && temp.isNumericFunction(true) && (result = F.evaln(this)).isNumber()) {
            return (INumber)result;
        }
        return null;
    }

    @Override
    public final ISignedNumber evalReal() {
        IExpr result;
        IExpr temp;
        if (this.isNumericFunction(true)) {
            IExpr result2 = F.evaln(this);
            if (result2.isReal()) {
                return (ISignedNumber)result2;
            }
        } else if (this.hasAssignedSymbolValue() && (temp = this.assignedValue()) != null && temp.isNumericFunction(true) && (result = F.evaln(this)).isReal()) {
            return (ISignedNumber)result;
        }
        return null;
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        if (this.hasAssignedSymbolValue()) {
            return this.assignedValue();
        }
        return this.evalDownRule(engine, this);
    }

    @Override
    public IExpr evaluateHead(IAST ast, EvalEngine engine) {
        IExpr result = this.evaluate(engine);
        return result.isPresent() ? ast.apply(result) : F.NIL;
    }

    @Override
    public final IExpr evalUpRules(IExpr expression, EvalEngine engine) {
        if (this.fRulesData == null) {
            return F.NIL;
        }
        return this.fRulesData.evalUpRule(expression, engine);
    }

    @Override
    public String fullFormString() {
        try {
            StringBuilder sb = new StringBuilder();
            OutputFormFactory.get(EvalEngine.get().isRelaxedSyntax()).convertSymbol(sb, this);
            return sb.toString();
        }
        catch (Exception e1) {
            return this.fSymbolName;
        }
    }

    @Override
    public final int getAttributes() {
        return this.fAttributes;
    }

    @Override
    public final Context getContext() {
        return this.fContext;
    }

    @Override
    public IExpr getDefaultValue() {
        IExpr value = this.fRulesData != null ? this.fRulesData.getDefaultValue(Integer.MIN_VALUE) : null;
        return value == null ? F.NIL : value;
    }

    @Override
    public IExpr getDefaultValue(int pos) {
        IExpr value = this.fRulesData != null ? this.fRulesData.getDefaultValue(pos) : null;
        return value == null ? F.NIL : value;
    }

    @Override
    public final RulesData getRulesData() {
        return this.fRulesData;
    }

    @Override
    public final String getSymbolName() {
        return this.fSymbolName;
    }

    @Override
    public final boolean hasAssignedSymbolValue() {
        return this.fValue != null;
    }

    private boolean hasNoValue() {
        return this.fValue == null && this.fRulesData == null;
    }

    @Override
    public final boolean hasFlatAttribute() {
        return ISymbol.hasFlatAttribute(this.fAttributes);
    }

    @Override
    public final boolean hasHoldAllCompleteAttribute() {
        return ISymbol.hasHoldAllCompleteAttribute(this.fAttributes);
    }

    @Override
    public final boolean hasListableAttribute() {
        return ISymbol.hasListableAttribute(this.fAttributes);
    }

    public int hashCode() {
        return this.fSymbolName == null ? 31 : this.fSymbolName.hashCode();
    }

    @Override
    public boolean hasOneIdentityAttribute() {
        return (this.fAttributes & 1) == 1;
    }

    @Override
    public final boolean hasOrderlessAttribute() {
        return ISymbol.hasOrderlessAttribute(this.fAttributes);
    }

    @Override
    public final boolean hasOrderlessFlatAttribute() {
        return ISymbol.hasOrderlessFlatAttribute(this.fAttributes);
    }

    @Override
    public final ISymbol head() {
        return S.Symbol;
    }

    @Override
    public final int hierarchy() {
        return 512;
    }

    @Override
    public CharSequence internalFormString(boolean symbolsAsFactoryMethod, int depth) {
        IExpr.SourceCodeProperties p = AbstractAST.stringFormProperties(symbolsAsFactoryMethod);
        return this.internalJavaString(p, depth, x -> null);
    }

    @Override
    public CharSequence internalJavaString(IExpr.SourceCodeProperties properties, int depth, Function<ISymbol, ? extends CharSequence> variables) {
        String name;
        CharSequence result = variables.apply(this);
        if (result != null) {
            return result;
        }
        String prefix = AbstractAST.getPrefixF(properties);
        if (properties.symbolsAsFactoryMethod) {
            return new StringBuilder(prefix).append(this.internalJavaStringAsFactoryMethod());
        }
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS ? (name = this.fSymbolName.length() == 1 ? AST2Expr.PREDEFINED_SYMBOLS_MAP.get(this.fSymbolName) : AST2Expr.PREDEFINED_SYMBOLS_MAP.get(this.fSymbolName.toLowerCase(Locale.ENGLISH))) != null : (name = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(this.fSymbolName.toLowerCase(Locale.ENGLISH))) != null && name.equals(this.fSymbolName)) {
            return new StringBuilder(prefix).append(name);
        }
        char ch = this.fSymbolName.charAt(0);
        if (!properties.noSymbolPrefix && this.fSymbolName.length() == 1 && 'a' <= ch && ch <= 'z') {
            return new StringBuilder(prefix).append(this.fSymbolName);
        }
        return this.fSymbolName;
    }

    protected CharSequence internalJavaStringAsFactoryMethod() {
        String alias;
        char ch;
        if (this.fSymbolName.length() == 1) {
            ch = this.fSymbolName.charAt(0);
            if ('a' <= ch && ch <= 'z') {
                return this.fSymbolName;
            }
            if (Config.RUBI_CONVERT_SYMBOLS && 'A' <= ch && ch <= 'G' && ch != 'D' && ch != 'E' || 'A' <= ch && ch <= 'G' && ch != 'D' && ch != 'E' || 'P' == ch || ch == 'Q') {
                return new StringBuilder(this.fSymbolName).append("Symbol");
            }
        }
        if (Config.RUBI_CONVERT_SYMBOLS) {
            if (this.fSymbolName.length() == 2 && '\u00a7' == this.fSymbolName.charAt(0) && Character.isLowerCase(this.fSymbolName.charAt(1))) {
                ch = this.fSymbolName.charAt(1);
                if ('a' <= ch && ch <= 'z') {
                    return new StringBuilder("p").append(ch);
                }
            } else if (this.fSymbolName.equals("Int")) {
                return "Integrate";
            }
        }
        if (Character.isUpperCase(this.fSymbolName.charAt(0)) && (alias = F.getPredefinedInternalFormString(this.fSymbolName)) != null) {
            if (Config.RUBI_CONVERT_SYMBOLS && alias.startsWith("Rubi`")) {
                return new StringBuilder("$rubi(\"").append(alias, 5, alias.length()).append("\")");
            }
            return alias;
        }
        return new StringBuilder("$s(\"").append(this.fSymbolName).append("\")");
    }

    @Override
    public CharSequence internalScalaString(boolean symbolsAsFactoryMethod, int depth) {
        IExpr.SourceCodeProperties p = AbstractAST.scalaFormProperties(symbolsAsFactoryMethod);
        return this.internalJavaString(p, depth, x -> null);
    }

    @Override
    public final boolean isAtom() {
        return true;
    }

    @Override
    public final boolean isEvalFlagOff(int i) {
        return (this.fEvalFlags & i) == 0;
    }

    @Override
    public final boolean isEvalFlagOn(int i) {
        return (this.fEvalFlags & i) == i;
    }

    @Override
    public boolean isLocked() {
        return !EvalEngine.get().isPackageMode() && (this.fContext == Context.SYSTEM || this.fContext == Context.RUBI);
    }

    @Override
    public boolean isLocked(boolean packageMode) {
        return !packageMode && (this.fContext == Context.SYSTEM || this.fContext == Context.RUBI);
    }

    @Override
    public boolean isNegative() {
        IExpr temp;
        return this.isNumericFunction(true) && (temp = F.evaln(this)).isReal() && temp.isNegative();
    }

    @Override
    public boolean isNumericFunction(boolean allowList) {
        return this.isConstantAttribute();
    }

    @Override
    public boolean isPolynomial(IAST variables) {
        if (variables.isAST0()) {
            return true;
        }
        ExprPolynomialRing ring = new ExprPolynomialRing(variables);
        return ring.isPolynomial(this);
    }

    @Override
    public boolean isPolynomial(IExpr variable) {
        return this.isPolynomial(F.list(variable));
    }

    @Override
    public boolean isPolynomialOfMaxDegree(ISymbol variable, long maxDegree) {
        return maxDegree != 0L || !this.equals(variable);
    }

    @Override
    public boolean isPolynomialStruct() {
        return (this.fAttributes & 2) == 2 || this.isVariable();
    }

    @Override
    public boolean isPositive() {
        IExpr temp;
        return this.isNumericFunction(true) && (temp = F.evaln(this)).isReal() && temp.isPositive();
    }

    @Override
    public final boolean isString(String str) {
        return this.fSymbolName.equals(str);
    }

    @Override
    public final boolean isStringIgnoreCase(String str) {
        return this.fSymbolName.equalsIgnoreCase(str);
    }

    @Override
    public final boolean isSymbolName(String name) {
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
            if (this.fSymbolName.length() == 1) {
                return this.fSymbolName.equals(name);
            }
            return this.fSymbolName.equalsIgnoreCase(name);
        }
        return this.fSymbolName.equals(name);
    }

    @Override
    public final boolean isValue() {
        return this.evaluate(EvalEngine.get()).isPresent();
    }

    @Override
    public final boolean isVariable() {
        return (this.fAttributes & 0x402) == 0 && this != S.ComplexInfinity && this != S.Indeterminate && this != S.DirectedInfinity && this != S.Infinity;
    }

    @Override
    public IExpr of(EvalEngine engine, IExpr ... args) {
        IASTMutable ast = F.function(this, args);
        return engine.evaluate(ast);
    }

    @Override
    public IExpr of1(EvalEngine engine, IExpr arg, IExpr ... parts) {
        IASTAppendable ast = F.ast((IExpr)this, 1 + parts.length);
        ast.append(arg);
        ast.appendAll(parts, 0, parts.length);
        return engine.evaluate(ast);
    }

    @Override
    public final IExpr ofNIL(EvalEngine engine, IExpr ... args) {
        IASTMutable ast = F.function(this, args);
        IExpr temp = engine.evaluateNIL(ast);
        if (temp.isPresent() && temp.head() == this) {
            return F.NIL;
        }
        return temp;
    }

    @Override
    public boolean ofQ(EvalEngine engine, IExpr ... args) {
        IASTMutable ast = F.function(this, args);
        return engine.evalTrue(ast);
    }

    @Override
    public final boolean ofQ(IExpr ... args) {
        return this.ofQ(EvalEngine.get(), args);
    }

    @Override
    public IExpr inverse() {
        if (this.hasNoValue()) {
            return F.Power((IExpr)this, F.CN1);
        }
        return this.power(F.CN1);
    }

    @Override
    public IExpr opposite() {
        if (this.hasNoValue()) {
            return F.Times((IExpr)F.CN1, (IExpr)this);
        }
        return this.times(F.CN1);
    }

    @Override
    public IExpr plus(IExpr that) {
        if (this.hasNoValue() && this != that && !that.isPlusTimesPower()) {
            if (that.isZero()) {
                return this;
            }
            return F.Plus((IExpr)this, that);
        }
        return ISymbol.super.plus(that);
    }

    @Override
    public final void putDownRule(int setSymbol, boolean equalRule, IExpr leftHandSide, IExpr rightHandSide, boolean packageMode) {
        this.putDownRule(setSymbol, equalRule, leftHandSide, rightHandSide, Integer.MAX_VALUE, packageMode);
    }

    @Override
    public final void putDownRule(int setSymbol, boolean equalRule, IExpr leftHandSide, IExpr rightHandSide, int priority, boolean packageMode) {
        if (!packageMode) {
            if (this.isLocked(packageMode)) {
                throw new RuleCreationError(leftHandSide);
            }
            EvalEngine.get().addModifiedVariable(this);
        }
        if (leftHandSide.isSymbol()) {
            this.assignValue(rightHandSide, false);
            return;
        }
        if (this.fRulesData == null) {
            this.fRulesData = new RulesData();
        }
        this.fRulesData.putDownRule(setSymbol, equalRule, leftHandSide, rightHandSide, priority);
    }

    @Override
    public final void putDownRule(PatternMatcherAndInvoker pmEvaluator) {
        if (this.fRulesData == null) {
            this.fRulesData = new RulesData();
        }
        this.fRulesData.insertMatcher(pmEvaluator);
    }

    @Override
    public void putMessage(int setSymbol, String messageName, IStringX message) {
        if (this.fRulesData == null) {
            this.fRulesData = new RulesData();
        }
        this.fRulesData.getMessages().put(messageName, message);
    }

    @Override
    public final IPatternMatcher putUpRule(int setSymbol, boolean equalRule, IAST leftHandSide, IExpr rightHandSide) {
        return this.putUpRule(setSymbol, equalRule, leftHandSide, rightHandSide, Integer.MAX_VALUE);
    }

    @Override
    public final IPatternMatcher putUpRule(int setSymbol, boolean equalRule, IAST leftHandSide, IExpr rightHandSide, int priority) {
        EvalEngine engine = EvalEngine.get();
        if (!engine.isPackageMode()) {
            if (this.isLocked(false)) {
                throw new RuleCreationError(leftHandSide);
            }
            engine.addModifiedVariable(this);
        }
        if (this.fRulesData == null) {
            this.fRulesData = new RulesData();
        }
        return this.fRulesData.putUpRule(setSymbol, equalRule, leftHandSide, rightHandSide);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.fSymbolName = stream.readUTF();
        this.fAttributes = stream.read();
        IExpr value = (IExpr)stream.readObject();
        this.assignValue(value, false);
        int contextNumber = stream.readInt();
        switch (contextNumber) {
            case 1: {
                this.fContext = Context.SYSTEM;
                break;
            }
            case 2: {
                this.fContext = Context.RUBI;
                break;
            }
            case 3: {
                this.fContext = Context.DUMMY;
                break;
            }
            default: {
                String contextName = stream.readUTF();
                this.fContext = EvalEngine.get().getContextPath().getContext(contextName);
                Symbol symbol = (Symbol)this.fContext.get(this.fSymbolName);
                if (symbol == null) {
                    this.fContext.put(this.fSymbolName, this);
                    symbol = this;
                } else {
                    symbol.fAttributes = this.fAttributes;
                    symbol.fValue = this.fValue;
                    symbol.clearEvalFlags(1);
                }
                boolean hasDownRulesData = stream.readBoolean();
                if (!hasDownRulesData) break;
                symbol.fRulesData = (RulesData)stream.readObject();
            }
        }
    }

    public Object readResolve() {
        return this.fContext == Context.DUMMY ? this : this.fContext.get(this.fSymbolName);
    }

    @Override
    public void readRules(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.fSymbolName = stream.readUTF();
        this.fAttributes = stream.read();
        boolean hasDownRulesData = stream.readBoolean();
        if (hasDownRulesData) {
            this.fRulesData = new RulesData();
            this.fRulesData = (RulesData)stream.readObject();
        }
    }

    @Override
    public IExpr[] reassignSymbolValue(Function<IExpr, IExpr> function, ISymbol functionSymbol, EvalEngine engine) {
        if (this.hasAssignedSymbolValue()) {
            IExpr calculatedResult;
            IExpr[] result = new IExpr[2];
            result[0] = this.fValue;
            if (this.isEvalFlagOn(1) && result[0].isAST()) {
                result[0] = ((IAST)result[0]).copy();
            }
            if ((calculatedResult = function.apply(result[0])).isPresent()) {
                this.assignValue(calculatedResult, false);
                result[1] = calculatedResult;
                return result;
            }
        }
        IOFunctions.printMessage(functionSymbol, "rvalue", F.list(this), engine);
        return null;
    }

    @Override
    public IExpr[] reassignSymbolValue(IASTMutable ast, ISymbol functionSymbol, EvalEngine engine) {
        if (this.hasAssignedSymbolValue()) {
            IExpr[] result = new IExpr[2];
            result[0] = this.fValue;
            ast.set(1, result[0]);
            IExpr calculatedResult = engine.evaluate(ast);
            if (calculatedResult != null) {
                this.assignValue(calculatedResult, false);
                result[1] = calculatedResult;
                return result;
            }
        }
        throw new ArgumentTypeException(functionSymbol.toString() + " - Symbol: " + this.toString() + " has no value! Reassignment with a new value is not possible");
    }

    @Override
    public final boolean removeRule(int setSymbol, boolean equalRule, IExpr leftHandSide, boolean packageMode) {
        if (!packageMode) {
            if (this.isLocked(packageMode)) {
                throw new RuleCreationError(leftHandSide);
            }
            EvalEngine.get().addModifiedVariable(this);
        }
        if (leftHandSide.isSymbol()) {
            this.clearValue();
            return true;
        }
        if (this.fRulesData != null) {
            return this.fRulesData.removeRule(setSymbol, equalRule, leftHandSide);
        }
        return false;
    }

    @Override
    public void setAttributes(int attributes) {
        this.fAttributes = attributes;
        if (this.isLocked()) {
            throw new RuleCreationError(this);
        }
        EvalEngine engine = EvalEngine.get();
        engine.addModifiedVariable(this);
    }

    @Override
    public void setDefaultValue(IExpr expr) {
        this.setDefaultValue(Integer.MIN_VALUE, expr);
    }

    @Override
    public void setDefaultValue(int pos, IExpr expr) {
        if (this.fRulesData == null) {
            this.fRulesData = new RulesData();
        }
        this.fRulesData.putfDefaultValues(pos, expr);
    }

    @Override
    public void setRulesData(RulesData rd) {
        this.fRulesData = rd;
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            OutputFormFactory.get(EvalEngine.get().isRelaxedSyntax()).convertSymbol(sb, this);
            return sb.toString();
        }
        catch (Exception e1) {
            return this.fSymbolName;
        }
    }

    @Override
    public IExpr times(IExpr that) {
        if (this.hasNoValue() && this != that && !that.isPlusTimesPower()) {
            if (that.isZero()) {
                return F.C0;
            }
            if (that.isOne()) {
                return this;
            }
            return F.Times((IExpr)this, that);
        }
        return ISymbol.super.times(that);
    }

    @Override
    public String toMMA() {
        String str = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(this.fSymbolName);
        if (str != null) {
            return str;
        }
        return this.fSymbolName;
    }

    @Override
    public IExpr variables2Slots(Map<IExpr, IExpr> map, Collection<IExpr> variableCollector) {
        UnaryVariable2Slot uv2s = new UnaryVariable2Slot(map, variableCollector);
        return uv2s.apply(this);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeUTF(this.fSymbolName);
        stream.write(this.fAttributes);
        stream.writeObject(this.fValue);
        if (this.fContext.equals(Context.SYSTEM)) {
            stream.writeInt(1);
        } else if (this.fContext.equals(Context.RUBI)) {
            stream.writeInt(2);
        } else if (this.fContext.equals(Context.DUMMY)) {
            stream.writeInt(3);
        } else {
            stream.writeInt(0);
            stream.writeUTF(this.fContext.getContextName());
            if (this.fRulesData == null) {
                stream.writeBoolean(false);
            } else {
                stream.writeBoolean(true);
                stream.writeObject(this.fRulesData);
            }
        }
    }

    private Object writeReplace() {
        return this.optional();
    }

    @Override
    public boolean writeRules(ObjectOutputStream stream) throws IOException {
        stream.writeUTF(this.fSymbolName);
        stream.write(this.fAttributes);
        if (this.fRulesData == null) {
            stream.writeBoolean(false);
        } else {
            stream.writeBoolean(true);
            stream.writeObject(this.fRulesData);
        }
        return true;
    }
}

