/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.Collator;
import java.util.Locale;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.expression.AbstractAST;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;

public class StringX
implements IStringX {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Collator US_COLLATOR = Collator.getInstance(Locale.US);
    private static final long serialVersionUID = -68464824682534930L;
    private short fMimeType;
    private String fString;

    public static StringX copyValueOf(char[] data) {
        return StringX.newInstance(String.copyValueOf(data));
    }

    public static StringX copyValueOf(char[] data, int offset, int count) {
        return StringX.newInstance(String.copyValueOf(data, offset, count));
    }

    public static StringX newInstance(byte[] bytes, Charset charset) {
        StringX d = new StringX(null);
        d.fString = new String(bytes, charset);
        return d;
    }

    protected static StringX newInstance(String value) {
        return new StringX(value);
    }

    protected static StringX newInstance(String value, short mimeType) {
        return new StringX(value, mimeType);
    }

    public static StringX valueOf(boolean b) {
        return StringX.newInstance(String.valueOf(b));
    }

    public static StringX valueOf(char c) {
        return StringX.newInstance(String.valueOf(c));
    }

    public static StringX valueOf(char[] data) {
        return StringX.newInstance(String.valueOf(data));
    }

    public static StringX valueOf(char[] data, int offset, int count) {
        return StringX.newInstance(String.valueOf(data, offset, count));
    }

    public static StringX valueOf(double d) {
        return StringX.newInstance(String.valueOf(d));
    }

    public static StringX valueOf(float f) {
        return StringX.newInstance(String.valueOf(f));
    }

    public static StringX valueOf(int i) {
        return StringX.newInstance(String.valueOf(i));
    }

    public static StringX valueOf(long l) {
        return StringX.newInstance(String.valueOf(l));
    }

    public static StringX valueOf(Object obj) {
        return StringX.newInstance(String.valueOf(obj));
    }

    public static StringX valueOf(Object obj, short mimeType) {
        return StringX.newInstance(String.valueOf(obj), mimeType);
    }

    public static StringX valueOf(StringBuilder builder) {
        return StringX.newInstance(builder.toString());
    }

    private StringX(String str) {
        this.fMimeType = 1;
        this.fString = str;
    }

    private StringX(String str, short mimeType) {
        this.fMimeType = mimeType;
        this.fString = str;
    }

    @Override
    public IExpr accept(IVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return visitor.visit(this);
    }

    public char charAt(int index) {
        return this.fString.charAt(index);
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof StringX) {
            return US_COLLATOR.compare(this.fString, ((StringX)expr).fString);
        }
        return IStringX.super.compareTo(expr);
    }

    @Override
    public int compareTo(StringX anotherString) {
        return US_COLLATOR.compare(this.fString, anotherString.fString);
    }

    public int compareToIgnoreCase(StringX str) {
        return this.fString.compareToIgnoreCase(str.fString);
    }

    public String concat(StringX str) {
        return this.fString.concat(str.fString);
    }

    @Override
    public boolean contentEquals(CharSequence cs) {
        return this.fString.contentEquals(cs);
    }

    public IExpr copy() {
        try {
            return (IExpr)this.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("StringX.copy() failed", (Throwable)e);
            return null;
        }
    }

    public boolean endsWith(String suffix) {
        return this.fString.endsWith(suffix);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StringX) {
            return this.fString.equals(((StringX)obj).fString);
        }
        return false;
    }

    public boolean equalsIgnoreCase(String anotherString) {
        return this.fString.equalsIgnoreCase(anotherString);
    }

    @Override
    public String fullFormString() {
        return "\"" + this.fString + "\"";
    }

    public byte[] getBytes() {
        return this.fString.getBytes(StandardCharsets.UTF_8);
    }

    public byte[] getBytes(String charsetName) throws UnsupportedEncodingException {
        return this.fString.getBytes(charsetName);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        this.fString.getChars(srcBegin, srcEnd, dst, dstBegin);
    }

    @Override
    public short getMimeType() {
        return this.fMimeType;
    }

    public int hashCode() {
        return this.fString == null ? 37 : 37 + this.fString.hashCode();
    }

    @Override
    public ISymbol head() {
        return S.String;
    }

    @Override
    public int hierarchy() {
        return 256;
    }

    @Override
    public int indexOf(int ch) {
        return this.fString.indexOf(ch);
    }

    @Override
    public int indexOf(int ch, int fromIndex) {
        return this.fString.indexOf(ch, fromIndex);
    }

    @Override
    public int indexOf(String str) {
        return this.fString.indexOf(str);
    }

    @Override
    public int indexOf(String str, int fromIndex) {
        return this.fString.indexOf(str, fromIndex);
    }

    public String intern() {
        return this.fString.intern();
    }

    @Override
    public CharSequence internalFormString(boolean symbolsAsFactoryMethod, int depth) {
        if (symbolsAsFactoryMethod) {
            return new StringBuilder("$str(\"").append(this.fString).append("\")");
        }
        return new StringBuilder(this.fString.length() + 2).append("\"").append(this.fString).append("\"");
    }

    @Override
    public CharSequence internalJavaString(IExpr.SourceCodeProperties properties, int depth, Function<ISymbol, ? extends CharSequence> variables) {
        String prefix = AbstractAST.getPrefixF(properties);
        return new StringBuilder(prefix).append("$str(\"").append(this.fString).append("\")");
    }

    @Override
    public int lastIndexOf(int ch) {
        return this.fString.lastIndexOf(ch);
    }

    @Override
    public int lastIndexOf(int ch, int fromIndex) {
        return this.fString.lastIndexOf(ch, fromIndex);
    }

    @Override
    public int lastIndexOf(String str) {
        return this.fString.lastIndexOf(str);
    }

    @Override
    public int lastIndexOf(String str, int fromIndex) {
        return this.fString.lastIndexOf(str, fromIndex);
    }

    public int length() {
        return this.fString.length();
    }

    public boolean matches(String regex) {
        return this.fString.matches(regex);
    }

    public boolean regionMatches(boolean ignoreCase, int toffset, String other, int ooffset, int len) {
        return this.fString.regionMatches(ignoreCase, toffset, other, ooffset, len);
    }

    public boolean regionMatches(int toffset, String other, int ooffset, int len) {
        return this.fString.regionMatches(toffset, other, ooffset, len);
    }

    public String replace(char oldChar, char newChar) {
        return this.fString.replace(oldChar, newChar);
    }

    public String replaceFirst(String regex, String replacement) {
        return this.fString.replaceFirst(regex, replacement);
    }

    public String[] split(String regex) {
        return this.fString.split(regex);
    }

    public String[] split(String regex, int limit) {
        return this.fString.split(regex, limit);
    }

    public boolean startsWith(String prefix) {
        return this.fString.startsWith(prefix);
    }

    public boolean startsWith(String prefix, int toffset) {
        return this.fString.startsWith(prefix, toffset);
    }

    public CharSequence subSequence(int start, int end) {
        return this.fString.subSequence(start, end);
    }

    @Override
    public String substring(int beginIndex) {
        return this.fString.substring(beginIndex);
    }

    @Override
    public String substring(int beginIndex, int endIndex) {
        return this.fString.substring(beginIndex, endIndex);
    }

    public char[] toCharArray() {
        return this.fString.toCharArray();
    }

    @Override
    public String toLowerCase() {
        return this.fString.toLowerCase();
    }

    public String toLowerCase(Locale locale) {
        return this.fString.toLowerCase(locale);
    }

    public String toString() {
        return this.fString;
    }

    @Override
    public String toUpperCase() {
        return this.fString.toUpperCase();
    }

    public String toUpperCase(Locale locale) {
        return this.fString.toUpperCase(locale);
    }

    public String trim() {
        return this.fString.trim();
    }
}

