/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.PatternSequence;
import org.matheclipse.core.form.output.WolframFormFactory;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMap;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.parser.client.ParserConfig;

public class RepeatedPattern
extends PatternSequence {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1086461999754718513L;
    protected IExpr fRepeatedExpr;
    protected int fMin;
    protected int fMax;
    protected IPatternMatcher fMatcher;

    public static RepeatedPattern valueOf(IExpr patternExpr, EvalEngine engine) {
        return RepeatedPattern.valueOf(patternExpr, 1, Integer.MAX_VALUE, false, engine);
    }

    public static RepeatedPattern valueOf(IExpr patternExpr, int min, int max, boolean zeroArgsAllowed, EvalEngine engine) {
        RepeatedPattern p = new RepeatedPattern();
        p.fSymbol = null;
        p.fHeadTest = null;
        p.fDefault = false;
        p.fZeroArgsAllowed = zeroArgsAllowed;
        p.fRepeatedExpr = patternExpr;
        p.fMatcher = engine.evalPatternMatcher(patternExpr);
        p.fMin = min;
        p.fMax = max;
        return p;
    }

    protected RepeatedPattern() {
    }

    @Override
    public int compareTo(IExpr expr) {
        int cp;
        if (expr instanceof RepeatedPattern && (cp = this.fRepeatedExpr.compareTo(((RepeatedPattern)expr).fRepeatedExpr)) != 0) {
            return cp;
        }
        return super.compareTo(expr);
    }

    @Override
    public IExpr copy() {
        try {
            return (IExpr)this.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("RepeatedPattern.copy() failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RepeatedPattern) {
            RepeatedPattern pattern = (RepeatedPattern)obj;
            if (this.fSymbol == null) {
                if (pattern.fSymbol == null && this.fDefault == pattern.fDefault && this.fZeroArgsAllowed == pattern.fZeroArgsAllowed) {
                    return this.fRepeatedExpr.equals(pattern.fRepeatedExpr);
                }
                return false;
            }
            if (this.fSymbol.equals(pattern.fSymbol) && this.fDefault == pattern.fDefault && this.fZeroArgsAllowed == pattern.fZeroArgsAllowed) {
                return this.fRepeatedExpr.equals(pattern.fRepeatedExpr);
            }
        }
        return false;
    }

    @Override
    public String fullFormString() {
        StringBuilder buf = new StringBuilder();
        if (this.fZeroArgsAllowed) {
            buf.append("RepeatedNull");
        } else {
            buf.append("Repeated");
        }
        buf.append(ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS ? (char)'(' : '[');
        buf.append(this.fRepeatedExpr.fullFormString());
        buf.append(ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS ? (char)')' : ']');
        return buf.toString();
    }

    public IExpr getRepeatedExpr() {
        return this.fRepeatedExpr;
    }

    @Override
    public int hashCode() {
        return this.fSymbol == null ? 213 : 37 + this.fSymbol.hashCode();
    }

    @Override
    public boolean isRepeated() {
        return true;
    }

    @Override
    public boolean matchPatternSequence(IAST sequence, IPatternMap patternMap, ISymbol optionsPatternHead) {
        int size = sequence.argSize();
        if (size < this.fMin || size > this.fMax) {
            return false;
        }
        EvalEngine engine = EvalEngine.get();
        for (int i = 1; i < sequence.size(); ++i) {
            if (this.fMatcher.testBlank(sequence.get(i), engine)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.fRepeatedExpr.toString());
        if (this.fZeroArgsAllowed) {
            buffer.append("...");
        } else {
            buffer.append("..");
        }
        return buffer.toString();
    }

    @Override
    public String toWolframString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(WolframFormFactory.get().toString(this.fRepeatedExpr));
        if (this.fZeroArgsAllowed) {
            buffer.append("...");
        } else {
            buffer.append("..");
        }
        return buffer.toString();
    }
}

