/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.util.Pair;
import org.matheclipse.core.expression.AbstractAST;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPatternObject;
import org.matheclipse.core.interfaces.IPatternSequence;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMap;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcher;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;
import org.matheclipse.parser.client.ParserConfig;

public class PatternSequence
implements IPatternSequence {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 2773651826316158627L;
    protected IExpr fHeadTest;
    protected ISymbol fSymbol;
    protected boolean fDefault = false;
    protected boolean fZeroArgsAllowed = false;

    public static PatternSequence valueOf(ISymbol symbol, IExpr check, boolean def, boolean zeroArgsAllowed) {
        PatternSequence p = new PatternSequence();
        p.fSymbol = symbol;
        p.fHeadTest = check;
        p.fDefault = def;
        p.fZeroArgsAllowed = zeroArgsAllowed;
        return p;
    }

    public static PatternSequence valueOf(ISymbol symbol, IExpr check, boolean zeroArgsAllowed) {
        PatternSequence p = new PatternSequence();
        p.fSymbol = symbol;
        p.fHeadTest = check;
        p.fZeroArgsAllowed = zeroArgsAllowed;
        return p;
    }

    public static PatternSequence valueOf(ISymbol symbol, boolean zeroArgsAllowed) {
        return PatternSequence.valueOf(symbol, null, zeroArgsAllowed);
    }

    protected PatternSequence() {
    }

    @Override
    public int[] addPattern(List<Pair<IExpr, IPatternObject>> patternIndexMap) {
        IPatternMap.addPattern(patternIndexMap, this);
        int[] result = new int[]{2, 1};
        if (this.fHeadTest != null) {
            result[1] = result[1] + 2;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PatternSequence) {
            PatternSequence pattern = (PatternSequence)obj;
            if (this.fSymbol == null) {
                if (pattern.fSymbol == null && this.fDefault == pattern.fDefault && this.fZeroArgsAllowed == pattern.fZeroArgsAllowed) {
                    if (this.fHeadTest != null && pattern.fHeadTest != null) {
                        return this.fHeadTest.equals(pattern.fHeadTest);
                    }
                    return this.fHeadTest == pattern.fHeadTest;
                }
                return false;
            }
            if (this.fSymbol.equals(pattern.fSymbol) && this.fDefault == pattern.fDefault && this.fZeroArgsAllowed == pattern.fZeroArgsAllowed) {
                if (this.fHeadTest != null && pattern.fHeadTest != null) {
                    return this.fHeadTest.equals(pattern.fHeadTest);
                }
                return this.fHeadTest == pattern.fHeadTest;
            }
        }
        return false;
    }

    @Override
    public boolean equivalent(IPatternObject patternExpr2, IPatternMap pm1, IPatternMap pm2) {
        if (this == patternExpr2) {
            return true;
        }
        if (patternExpr2 instanceof PatternSequence) {
            IPatternSequence p2 = (IPatternSequence)patternExpr2;
            if (this.getIndex(pm1) != p2.getIndex(pm2)) {
                return false;
            }
            IExpr o1 = this.getHeadTest();
            IExpr o2 = p2.getHeadTest();
            if (o1 == null || o2 == null) {
                return o1 == o2;
            }
            return o1.equals(o2);
        }
        return false;
    }

    @Override
    public boolean matchPattern(IExpr expr, IPatternMap patternMap) {
        IAST sequence = F.Sequence(expr);
        return this.matchPatternSequence(sequence, patternMap, S.Missing);
    }

    @Override
    public boolean matchPatternSequence(IAST sequence, IPatternMap patternMap, ISymbol optionsPatternHead) {
        if (!this.isConditionMatchedSequence(sequence, patternMap)) {
            return false;
        }
        if (sequence.size() == 1 && !this.isNullSequence()) {
            return false;
        }
        IExpr value = patternMap.getValue(this);
        if (value != null) {
            return sequence.equals(value);
        }
        return patternMap.setValue(this, sequence);
    }

    @Override
    public IExpr getHeadTest() {
        return this.fHeadTest;
    }

    @Override
    public int getEvalFlags() {
        return 2;
    }

    @Override
    public int getIndex(IPatternMap pm) {
        if (pm != null) {
            return pm.get(this.fSymbol);
        }
        return -1;
    }

    @Override
    public ISymbol getSymbol() {
        return this.fSymbol;
    }

    public int hashCode() {
        return this.fSymbol == null ? 203 : 17 + this.fSymbol.hashCode();
    }

    @Override
    public int hierarchy() {
        return 2048;
    }

    @Override
    public CharSequence internalJavaString(IExpr.SourceCodeProperties properties, int depth, Function<ISymbol, ? extends CharSequence> variables) {
        if (properties.symbolsAsFactoryMethod) {
            String prefix = AbstractAST.getPrefixF(properties);
            StringBuilder buffer = new StringBuilder();
            buffer.append(prefix).append("$ps(");
            if (this.fSymbol == null) {
                buffer.append("(ISymbol)null");
                if (this.fHeadTest != null) {
                    buffer.append(",").append(this.fHeadTest.internalJavaString(properties, 0, variables));
                }
                if (this.fDefault) {
                    if (this.fHeadTest == null) {
                        buffer.append(",null");
                    }
                    buffer.append(",true");
                }
            } else {
                buffer.append("\"" + this.fSymbol.toString() + "\"");
                if (this.fHeadTest != null) {
                    buffer.append(",").append(this.fHeadTest.internalJavaString(properties, 0, variables));
                }
                if (this.fDefault) {
                    buffer.append(",true");
                }
            }
            return buffer.append(')');
        }
        return this.toCharSequence();
    }

    public String toString() {
        return this.toCharSequence().toString();
    }

    private CharSequence toCharSequence() {
        StringBuilder buffer = new StringBuilder();
        if (this.fSymbol == null) {
            buffer.append("__");
            if (this.fZeroArgsAllowed) {
                buffer.append('_');
            }
            if (this.fDefault) {
                buffer.append('.');
            }
            if (this.fHeadTest != null) {
                buffer.append(this.fHeadTest.toString());
            }
        } else if (this.fHeadTest == null) {
            buffer.append(this.fSymbol.toString());
            buffer.append("__");
            if (this.fZeroArgsAllowed) {
                buffer.append('_');
            }
            if (this.fDefault) {
                buffer.append('.');
            }
        } else {
            buffer.append(this.fSymbol.toString());
            buffer.append("__");
            if (this.fZeroArgsAllowed) {
                buffer.append('_');
            }
            if (this.fDefault) {
                buffer.append('.');
            }
            buffer.append(this.fHeadTest.toString());
        }
        return buffer;
    }

    @Override
    public String fullFormString() {
        StringBuilder buf = new StringBuilder();
        if (this.fSymbol == null) {
            buf.append(this.fZeroArgsAllowed ? "BlankNullSequence" : "BlankSequence");
            buf.append(ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS ? (char)'(' : '[');
            if (this.fHeadTest != null) {
                buf.append(this.fHeadTest.fullFormString());
            }
            buf.append(ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS ? (char)')' : ']');
        } else {
            buf.append("PatternSequence");
            buf.append(ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS ? (char)'(' : '[');
            buf.append(this.fSymbol.toString());
            buf.append(", ");
            buf.append(this.fZeroArgsAllowed ? "BlankNullSequence" : "BlankSequence");
            if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
                buf.append('(');
            } else {
                buf.append('[');
            }
            if (this.fHeadTest != null) {
                buf.append(this.fHeadTest.fullFormString());
            }
            buf.append(ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS ? "))" : "]]");
        }
        return buf.toString();
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof PatternSequence) {
            if (this.fSymbol == null) {
                if (((PatternSequence)expr).fSymbol != null) {
                    return -1;
                }
            } else {
                if (((PatternSequence)expr).fSymbol == null) {
                    return 1;
                }
                int cp = this.fSymbol.compareTo(((PatternSequence)expr).fSymbol);
                if (cp != 0) {
                    return cp;
                }
            }
            if (this.fHeadTest == null) {
                if (((PatternSequence)expr).fHeadTest != null) {
                    return -1;
                }
            } else {
                if (((PatternSequence)expr).fHeadTest == null) {
                    return 1;
                }
                return this.fHeadTest.compareTo(((PatternSequence)expr).fHeadTest);
            }
            return 0;
        }
        return IPatternSequence.super.compareTo(expr);
    }

    public IExpr copy() {
        try {
            return (IExpr)this.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("PatternSequence.copy() failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public ISymbol head() {
        return S.Pattern;
    }

    @Override
    public boolean isBlank() {
        return false;
    }

    @Override
    public boolean isConditionMatchedSequence(IAST sequence, IPatternMap patternMap) {
        if (this.fHeadTest == null) {
            return patternMap.setValue(this, sequence);
        }
        for (int i = 1; i < sequence.size(); ++i) {
            if (sequence.get(i).head().equals(this.fHeadTest)) continue;
            return false;
        }
        return patternMap.setValue(this, sequence);
    }

    @Override
    public IExpr variables2Slots(Map<IExpr, IExpr> map, Collection<IExpr> variableCollector) {
        return F.NIL;
    }

    @Override
    public IExpr accept(IVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isDefault() {
        return this.fDefault;
    }

    @Override
    public boolean isNullSequence() {
        return this.fZeroArgsAllowed;
    }

    @Override
    public boolean isFreeOfPatterns() {
        return false;
    }

    @Override
    public final boolean isPatternExpr() {
        return true;
    }

    @Override
    public final boolean isPatternSequence(boolean testNullSequence) {
        if (testNullSequence) {
            return this.fZeroArgsAllowed;
        }
        return true;
    }

    public boolean isCase(IExpr that) {
        PatternMatcher matcher = new PatternMatcher(this);
        return ((IPatternMatcher)matcher).test(that);
    }
}

