/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.util.List;
import java.util.function.Function;
import org.hipparchus.util.Pair;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.expression.AbstractAST;
import org.matheclipse.core.expression.Blank;
import org.matheclipse.core.expression.Context;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IPatternObject;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMap;
import org.matheclipse.parser.client.ParserConfig;

public class Pattern
extends Blank {
    private static final long serialVersionUID = 7617138748475243L;
    protected final ISymbol fSymbol;

    public static IPattern valueOf(ISymbol symbol) {
        IPattern value;
        if (symbol.getContext().equals(Context.DUMMY) && (value = F.getPredefinedPattern(symbol.toString())) != null) {
            return value;
        }
        return new Pattern(symbol);
    }

    public static IPattern valueOf(ISymbol symbol, IExpr check) {
        return new Pattern(symbol, check);
    }

    public static IPattern valueOf(ISymbol symbol, IExpr check, boolean def) {
        return new Pattern(symbol, check, def);
    }

    Pattern(ISymbol symbol) {
        this(symbol, null, false);
    }

    Pattern(ISymbol symbol, IExpr condition) {
        this(symbol, condition, false);
    }

    public Pattern(ISymbol symbol, IExpr condition, boolean def) {
        super(condition, def);
        this.fSymbol = symbol;
    }

    @Override
    public int[] addPattern(List<Pair<IExpr, IPatternObject>> patternIndexMap) {
        IPatternMap.addPattern(patternIndexMap, this);
        int[] result = new int[2];
        if (this.isPatternDefault() || this.isPatternOptional()) {
            result[0] = 4;
            result[1] = 3;
        } else {
            result[0] = 1;
            result[1] = 6;
        }
        if (this.fHeadTest != null) {
            result[1] = result[1] + 2;
        }
        return result;
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof Pattern) {
            Pattern pat = (Pattern)expr;
            int cp = this.fSymbol.compareTo(pat.fSymbol);
            if (cp != 0) {
                return cp;
            }
        }
        return super.compareTo(expr);
    }

    @Override
    public IExpr copy() {
        return new Pattern(this.fSymbol, this.fHeadTest, this.fDefault);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Pattern) {
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            Pattern pattern = (Pattern)obj;
            if (this.fDefault != pattern.fDefault) {
                return false;
            }
            if (this.fSymbol.equals(pattern.fSymbol)) {
                return super.equals(obj);
            }
        }
        return false;
    }

    @Override
    public boolean equivalent(IPatternObject patternObject, IPatternMap pm1, IPatternMap pm2) {
        if (this == patternObject) {
            return true;
        }
        if (patternObject instanceof Pattern) {
            IPattern p2 = (IPattern)patternObject;
            if (this.getIndex(pm1) != p2.getIndex(pm2)) {
                return false;
            }
            IExpr o1 = this.getHeadTest();
            IExpr o2 = p2.getHeadTest();
            if (o1 == null || o2 == null) {
                return o1 == o2;
            }
            return o1.equals(o2);
        }
        return false;
    }

    @Override
    public boolean matchPattern(IExpr expr, IPatternMap patternMap) {
        if (!this.isConditionMatched(expr, patternMap)) {
            return false;
        }
        IExpr value = patternMap.getValue(this);
        if (value != null) {
            return expr.equals(value);
        }
        return patternMap.setValue(this, expr);
    }

    @Override
    public String fullFormString() {
        StringBuilder buf = new StringBuilder();
        if (this.fDefault) {
            buf.append("Optional");
            buf.append(ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS ? (char)'(' : '[');
        }
        buf.append("Pattern");
        buf.append(ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS ? (char)'(' : '[');
        buf.append(this.fSymbol.toString());
        buf.append(", ");
        buf.append("Blank");
        buf.append(ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS ? (char)'(' : '[');
        if (this.fHeadTest != null) {
            buf.append(this.fHeadTest.fullFormString());
        }
        buf.append(ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS ? "))" : "]]");
        if (this.fDefault) {
            buf.append(ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS ? (char)')' : ']');
        }
        return buf.toString();
    }

    @Override
    public int getIndex(IPatternMap pm) {
        if (pm != null) {
            return pm.get(this.fSymbol);
        }
        return -1;
    }

    @Override
    public ISymbol getSymbol() {
        return this.fSymbol;
    }

    @Override
    public int hashCode() {
        return this.fSymbol == null ? 19 : 19 + this.fSymbol.hashCode();
    }

    @Override
    public ISymbol head() {
        return S.Pattern;
    }

    @Override
    public int hierarchy() {
        return 2048;
    }

    @Override
    public boolean isConditionMatched(IExpr expr, IPatternMap patternMap) {
        return this.fHeadTest == null || expr.head().equals(this.fHeadTest);
    }

    @Override
    public CharSequence internalJavaString(IExpr.SourceCodeProperties properties, int depth, Function<ISymbol, ? extends CharSequence> variables) {
        char ch2;
        String prefix = AbstractAST.getPrefixF(properties);
        StringBuilder buffer = new StringBuilder(prefix);
        String symbolStr = this.fSymbol.toString();
        char ch = symbolStr.charAt(0);
        if (symbolStr.length() == 1 && ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'G' && ch != 'D' && ch != 'E' || ch == 'P' || ch == 'Q')) {
            if (!this.fDefault) {
                if (this.fHeadTest == null) {
                    return buffer.append(symbolStr).append("_");
                }
                if (this.fHeadTest == S.Symbol) {
                    return buffer.append(symbolStr).append("_Symbol");
                }
            } else if (this.fHeadTest == null) {
                return buffer.append(symbolStr).append("_DEFAULT");
            }
        }
        if (Config.RUBI_CONVERT_SYMBOLS && ch == '\u00a7' && symbolStr.length() == 2 && 'a' <= (ch2 = symbolStr.charAt(1)) && ch2 <= 'z') {
            if (!this.fDefault) {
                if (this.fHeadTest == null) {
                    return buffer.append("p").append(ch2).append("_");
                }
            } else if (this.fHeadTest == null) {
                return buffer.append("p").append(ch2).append("_DEFAULT");
            }
        }
        buffer.append("$p(");
        if (symbolStr.length() == 1 && 'a' <= ch && ch <= 'z') {
            buffer.append(prefix).append(symbolStr);
        } else {
            buffer.append("\"").append(symbolStr).append("\"");
        }
        if (this.fHeadTest != null) {
            if (this.fHeadTest == S.Integer) {
                buffer.append(", Integer");
            } else if (this.fHeadTest == S.Symbol) {
                buffer.append(", Symbol");
            } else {
                buffer.append(",").append(this.fHeadTest.internalJavaString(properties, 0, variables));
            }
        }
        if (this.fDefault) {
            buffer.append(",true");
        }
        return buffer.append(')');
    }

    @Override
    public boolean isBlank() {
        return false;
    }

    @Override
    public final boolean isPattern() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.fHeadTest == null) {
            buffer.append(this.fSymbol.toString());
            buffer.append('_');
            if (this.fDefault) {
                buffer.append('.');
            }
        } else {
            buffer.append(this.fSymbol.toString());
            buffer.append('_');
            if (this.fDefault) {
                buffer.append('.');
            }
            buffer.append(this.fHeadTest.toString());
        }
        return buffer.toString();
    }

    private Object writeReplace() {
        return this.optional();
    }
}

