/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.PatternSequence;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMap;
import org.matheclipse.parser.client.ParserConfig;

public class OptionsPattern
extends PatternSequence {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1086461999754718513L;
    protected IExpr fDefaultOptions = F.NIL;
    private ISymbol fOptionsPatternHead = null;

    public static OptionsPattern valueOf(ISymbol symbol) {
        return OptionsPattern.valueOf(symbol, F.NIL);
    }

    public static OptionsPattern valueOf(ISymbol symbol, IExpr defaultOptions) {
        OptionsPattern p = new OptionsPattern();
        p.fSymbol = symbol;
        p.fHeadTest = null;
        p.fDefault = false;
        p.fZeroArgsAllowed = true;
        p.fDefaultOptions = defaultOptions;
        p.fOptionsPatternHead = null;
        return p;
    }

    protected OptionsPattern() {
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof OptionsPattern) {
            OptionsPattern optionsPattern = (OptionsPattern)expr;
            if (this.fDefaultOptions.isPresent() && optionsPattern.fDefaultOptions.isPresent()) {
                int cp = this.fDefaultOptions.compareTo(optionsPattern.fDefaultOptions);
                if (cp != 0) {
                    return cp;
                }
            } else if (this.fDefaultOptions != optionsPattern.fDefaultOptions) {
                return this.fDefaultOptions.isPresent() ? 1 : -1;
            }
        }
        return super.compareTo(expr);
    }

    @Override
    public IExpr copy() {
        try {
            return (IExpr)this.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("OptionsPattern.copy() failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OptionsPattern) {
            OptionsPattern pattern = (OptionsPattern)obj;
            if (this.fSymbol == null) {
                if (pattern.fSymbol == null && this.fDefault == pattern.fDefault && this.fZeroArgsAllowed == pattern.fZeroArgsAllowed) {
                    return this.fDefaultOptions.equals(pattern.fDefaultOptions);
                }
                return false;
            }
            if (this.fSymbol.equals(pattern.fSymbol) && this.fDefault == pattern.fDefault && this.fZeroArgsAllowed == pattern.fZeroArgsAllowed) {
                return this.fDefaultOptions.equals(pattern.fDefaultOptions);
            }
        }
        return false;
    }

    @Override
    public String fullFormString() {
        StringBuilder buf = new StringBuilder();
        if (this.fSymbol != null) {
            buf.append("Pattern");
            buf.append(ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS ? (char)'(' : '[');
            buf.append(this.fSymbol.fullFormString());
            buf.append(ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS ? ",OptionsPattern())" : ",OptionsPattern[]]");
        } else {
            buf.append(ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS ? "OptionsPattern()" : "OptionsPattern[]");
        }
        return buf.toString();
    }

    public IExpr getDefaultOptions() {
        return this.fDefaultOptions;
    }

    public ISymbol getOptionsPatternHead() {
        return this.fOptionsPatternHead;
    }

    @Override
    public int hashCode() {
        return this.fSymbol == null ? 213 : 37 + this.fSymbol.hashCode();
    }

    @Override
    public boolean isOptionsPattern() {
        return true;
    }

    @Override
    public boolean matchPatternSequence(IAST sequence, IPatternMap patternMap, ISymbol optionsPatternHead) {
        if (this.fOptionsPatternHead != null && !this.fOptionsPatternHead.equals(optionsPatternHead)) {
            return false;
        }
        if (sequence.size() == 1) {
            this.fOptionsPatternHead = optionsPatternHead;
            return patternMap.setValue(this, sequence);
        }
        for (int i = 1; i < sequence.size(); ++i) {
            if (sequence.get(i).isRuleAST()) continue;
            return false;
        }
        IExpr value = patternMap.getValue(this);
        if (value != null) {
            if (value.isList() || value.isSequence()) {
                IAST list = (IAST)value;
                for (int i = 1; i < list.size(); ++i) {
                    if (list.get(i).isRuleAST()) continue;
                    return false;
                }
            } else if (!value.isRuleAST()) {
                return false;
            }
            this.fOptionsPatternHead = optionsPatternHead;
            return true;
        }
        this.fOptionsPatternHead = optionsPatternHead;
        return patternMap.setValue(this, sequence);
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.fSymbol == null) {
            buffer.append("OptionsPattern()");
        } else {
            buffer.append(this.fSymbol.toString());
            buffer.append(":OptionsPattern()");
        }
        return buffer.toString();
    }

    @Override
    public String toWolframString() {
        StringBuilder buffer = new StringBuilder();
        if (this.fSymbol == null) {
            buffer.append("OptionsPattern[]");
        } else {
            buffer.append(this.fSymbol.toString());
            buffer.append(":OptionsPattern[]");
        }
        return buffer.toString();
    }
}

