/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import org.apfloat.Apfloat;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;

public final class NumStr
extends Num {
    private static final long serialVersionUID = -6378124858265275437L;
    private String fFloatStr;
    private long fPrecision;
    private int fExponent;

    public NumStr(String floatStr) {
        this(floatStr, 1);
    }

    public NumStr(String floatStr, int exponent) {
        int index = floatStr.indexOf("*^");
        this.fExponent = 0;
        this.fFloatStr = floatStr;
        if (index > 0) {
            this.fFloatStr = floatStr.substring(0, index);
            this.fExponent = Integer.parseInt(floatStr.substring(index + 2));
        }
        this.fDouble = this.fExponent != 0 ? Double.parseDouble(this.fFloatStr + "E" + this.fExponent) : Double.parseDouble(this.fFloatStr);
        this.fPrecision = this.fFloatStr.length();
        if (this.fFloatStr.startsWith("0.")) {
            this.fPrecision -= 2L;
        } else if (this.fFloatStr.indexOf(".") > 0) {
            --this.fPrecision;
        }
        if (this.fPrecision < 16L) {
            this.fPrecision = 16L;
        }
    }

    @Override
    public ApfloatNum apfloatNumValue() {
        long precision = EvalEngine.getApfloat().precision();
        long l = precision = this.fPrecision > precision ? this.fPrecision : precision;
        if (this.fExponent == 0) {
            return ApfloatNum.valueOf(this.fFloatStr, this.fPrecision);
        }
        return ApfloatNum.valueOf(this.fFloatStr + "E" + this.fExponent, this.fPrecision);
    }

    @Override
    public Apfloat apfloatValue() {
        long precision = EvalEngine.getApfloat().precision();
        long l = precision = this.fPrecision > precision ? this.fPrecision : precision;
        if (this.fExponent == 0) {
            return new Apfloat(this.fFloatStr, this.fPrecision);
        }
        return new Apfloat(this.fFloatStr + "E" + this.fExponent, this.fPrecision);
    }

    @Override
    public long determinePrecision() {
        return this.precision();
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        if (engine.isNumericMode() && engine.isArbitraryMode()) {
            long precision;
            long l = precision = this.fPrecision < engine.getNumericPrecision() ? engine.getNumericPrecision() : this.fPrecision;
            if (this.fExponent == 0) {
                return ApfloatNum.valueOf(this.fFloatStr, precision);
            }
            return ApfloatNum.valueOf(this.fFloatStr + "E" + this.fExponent, precision);
        }
        return super.evaluate(engine);
    }

    @Override
    public INumber evaluatePrecision(EvalEngine engine) {
        if (engine.isArbitraryMode()) {
            long precision;
            long l = precision = this.fPrecision < engine.getNumericPrecision() ? engine.getNumericPrecision() : this.fPrecision;
            if (this.fExponent == 0) {
                return ApfloatNum.valueOf(this.fFloatStr, precision);
            }
            return ApfloatNum.valueOf(this.fFloatStr + "E" + this.fExponent, precision);
        }
        return super.evaluatePrecision(engine);
    }

    @Override
    public IExpr plus(IExpr that) {
        if (EvalEngine.isApfloat(this.fPrecision)) {
            long precision = this.fPrecision;
            if (that instanceof ApfloatNum) {
                ApfloatNum arg2 = (ApfloatNum)that;
                precision = arg2.precision() < precision ? arg2.precision() : precision;
                return this.apfloatNumValue().add(arg2.apfloatNumValue());
            }
            if (that instanceof Num) {
                return this.apfloatNumValue().add(((INum)that).apfloatNumValue());
            }
            if (that instanceof ApcomplexNum) {
                ApcomplexNum arg2 = (ApcomplexNum)that;
                precision = arg2.precision() < precision ? arg2.precision() : precision;
                return ApcomplexNum.valueOf(this.apfloatValue()).add((ApcomplexNum)that);
            }
            if (that instanceof ComplexNum) {
                return ApcomplexNum.valueOf(this.apfloatValue()).add(((ComplexNum)that).apcomplexNumValue());
            }
        }
        return super.plus(that);
    }

    @Override
    public IExpr times(IExpr that) {
        if (EvalEngine.isApfloat(this.fPrecision)) {
            long precision = this.fPrecision;
            if (that instanceof ApfloatNum) {
                ApfloatNum arg2 = (ApfloatNum)that;
                precision = arg2.precision() < precision ? arg2.precision() : precision;
                return this.apfloatNumValue().multiply(arg2.apfloatNumValue());
            }
            if (that instanceof Num) {
                return this.apfloatNumValue().multiply(((INum)that).apfloatNumValue());
            }
            if (that instanceof ApcomplexNum) {
                ApcomplexNum arg2 = (ApcomplexNum)that;
                precision = arg2.precision() < precision ? arg2.precision() : precision;
                return ApcomplexNum.valueOf(this.apfloatValue()).multiply((ApcomplexNum)that);
            }
            if (that instanceof ComplexNum) {
                return ApcomplexNum.valueOf(this.apfloatValue()).multiply(((ComplexNum)that).apcomplexNumValue());
            }
        }
        return super.times(that);
    }

    public int getExponent() {
        return this.fExponent;
    }

    public String getFloatStr() {
        return this.fFloatStr;
    }

    @Override
    public long precision() {
        return this.fPrecision;
    }
}

