/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import com.google.common.math.DoubleMath;
import java.math.RoundingMode;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatRuntimeException;
import org.hipparchus.complex.Complex;
import org.hipparchus.util.MathUtils;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.expression.AbstractAST;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.form.DoubleToMMA;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;
import org.matheclipse.parser.client.ParserConfig;

public class Num
implements INum {
    private static final long serialVersionUID = 188084692735007429L;
    private static final Logger LOGGER = LogManager.getLogger();
    double fDouble;

    public static Num valueOf(double d) {
        if (d >= -1.1 && d <= 1.1) {
            int i = (int)d;
            switch (i) {
                case -1: {
                    if (d != -1.0) break;
                    return F.CND1;
                }
                case 0: {
                    if (d != 0.0 && d != -0.0) break;
                    return F.CD0;
                }
                case 1: {
                    if (d != 1.0) break;
                    return F.CD1;
                }
            }
        }
        return new Num(d);
    }

    public static double valueOf(String chars) {
        return Double.parseDouble(chars);
    }

    protected Num() {
        this.fDouble = 0.0;
    }

    Num(double value) {
        this.fDouble = value;
    }

    @Override
    public IExpr accept(IVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return visitor.visit(this);
    }

    @Override
    public INum add(INum val) {
        if (val instanceof ApfloatNum) {
            Apfloat arg2 = ((ApfloatNum)val).apfloatValue();
            return F.num(EvalEngine.getApfloat().add(this.apfloatValue(), arg2));
        }
        return Num.valueOf(this.fDouble + val.getRealPart());
    }

    @Override
    public INum subtract(INum val) {
        if (val instanceof ApfloatNum) {
            Apfloat arg2 = ((ApfloatNum)val).apfloatValue();
            return F.num(EvalEngine.getApfloat().subtract(this.apfloatValue(), arg2));
        }
        return Num.valueOf(this.fDouble - val.getRealPart());
    }

    @Override
    public INum divide(INum val) {
        if (val instanceof ApfloatNum) {
            Apfloat arg2 = ((ApfloatNum)val).apfloatValue();
            return F.num(EvalEngine.getApfloat().divide(this.apfloatValue(), arg2));
        }
        return Num.valueOf(this.fDouble / val.getRealPart());
    }

    @Override
    public ApcomplexNum apcomplexNumValue() {
        return ApcomplexNum.valueOf(this.apcomplexValue());
    }

    @Override
    public Apcomplex apcomplexValue() {
        return new Apcomplex(new Apfloat(this.fDouble));
    }

    @Override
    public ApfloatNum apfloatNumValue() {
        return ApfloatNum.valueOf(this.fDouble);
    }

    @Override
    public Apfloat apfloatValue() {
        return new Apfloat(this.fDouble);
    }

    @Override
    public IInteger ceilFraction() {
        try {
            return F.ZZ(NumberUtil.toLong(Math.ceil(this.fDouble)));
        }
        catch (ArithmeticException ae) {
            ArgumentTypeException.throwArg(this, F.Ceiling(this));
            return null;
        }
    }

    @Override
    public int compareAbsValueToOne() {
        double temp = Math.abs(this.fDouble);
        return Double.compare(temp, 1.0);
    }

    @Override
    public int compareTo(double that) {
        return Double.compare(this.fDouble, that);
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof Num) {
            return Double.compare(this.fDouble, ((Num)expr).fDouble);
        }
        if (expr.isNumber()) {
            if (expr.isReal()) {
                return Double.compare(this.fDouble, ((ISignedNumber)expr).doubleValue());
            }
            int c = this.compareTo(((INumber)expr).re());
            if (c != 0) {
                return c;
            }
        }
        return -1;
    }

    @Override
    public ComplexNum complexNumValue() {
        return ComplexNum.valueOf(this.doubleValue(), 0.0);
    }

    public IExpr copy() {
        try {
            return (IExpr)this.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("Num.copy() failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public ISignedNumber divideBy(ISignedNumber that) {
        if (that instanceof Num) {
            return Num.valueOf(this.fDouble / ((Num)that).fDouble);
        }
        if (that instanceof ApfloatNum) {
            return this.apfloatNumValue().divide(that.apfloatNumValue());
        }
        return Num.valueOf(this.fDouble / that.doubleValue());
    }

    @Override
    public double doubleValue() {
        return this.fDouble;
    }

    @Override
    public IExpr dec() {
        return Num.valueOf(this.fDouble - 1.0);
    }

    @Override
    public IExpr inc() {
        return Num.valueOf(this.fDouble + 1.0);
    }

    @Override
    public Num abs() {
        return Num.valueOf(Math.abs(this.fDouble));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Num) {
            Num c = (Num)other;
            if (Double.isNaN(c.fDouble)) {
                return Double.isNaN(this.fDouble);
            }
            return Double.doubleToLongBits(this.fDouble) == Double.doubleToLongBits(c.fDouble);
        }
        return false;
    }

    @Override
    public boolean equalsInt(int i) {
        return F.isNumIntValue(this.fDouble, i);
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        if (this.fDouble == Double.POSITIVE_INFINITY) {
            return F.CInfinity;
        }
        if (this.fDouble == Double.NEGATIVE_INFINITY) {
            return F.CNInfinity;
        }
        if (Double.isNaN(this.fDouble)) {
            return S.Indeterminate;
        }
        if (engine.isNumericMode() && engine.isArbitraryMode()) {
            return ApfloatNum.valueOf(this.fDouble);
        }
        return F.NIL;
    }

    @Override
    public INumber evaluatePrecision(EvalEngine engine) {
        return this;
    }

    @Override
    public ISignedNumber evalReal() {
        return this;
    }

    @Override
    public INumber evalNumber() {
        return this;
    }

    @Override
    public ISignedNumber fractionalPart() {
        return F.num(this.getRealPart() % 1.0);
    }

    @Override
    public String fullFormString() {
        return Num.fullFormString(this.fDouble);
    }

    public static String fullFormString(double d) {
        Object result = Double.toString(d);
        if (!ParserConfig.EXPLICIT_TIMES_OPERATOR) {
            int indx = ((String)result).indexOf("E");
            result = indx > 0 ? ((String)result).replace("E", "`*^") : (String)result + "`";
        }
        return result;
    }

    @Override
    public IInteger integerPart() {
        return this.isNegative() ? this.ceilFraction() : this.floorFraction();
    }

    @Override
    public IInteger floorFraction() {
        try {
            return F.ZZ(NumberUtil.toLong(Math.floor(this.fDouble)));
        }
        catch (ArithmeticException ae) {
            ArgumentTypeException.throwArg(this, F.Floor(this));
            return null;
        }
    }

    @Override
    public ISignedNumber im() {
        return F.CD0;
    }

    @Override
    public double imDoubleValue() {
        return 0.0;
    }

    @Override
    public ISignedNumber re() {
        return this;
    }

    @Override
    public double reDoubleValue() {
        return this.doubleValue();
    }

    @Override
    public double getRealPart() {
        double temp = this.fDouble;
        if (temp == -0.0) {
            temp = 0.0;
        }
        return temp;
    }

    public final int hashCode() {
        if (Double.isNaN(this.fDouble)) {
            return 11;
        }
        return 629 * MathUtils.hash((double)this.fDouble);
    }

    @Override
    public ISymbol head() {
        return S.Real;
    }

    @Override
    public int hierarchy() {
        return 2;
    }

    @Override
    public CharSequence internalFormString(boolean symbolsAsFactoryMethod, int depth) {
        IExpr.SourceCodeProperties p = AbstractAST.stringFormProperties(symbolsAsFactoryMethod);
        return this.internalJavaString(p, depth, x -> null);
    }

    @Override
    public CharSequence internalJavaString(IExpr.SourceCodeProperties properties, int depth, Function<ISymbol, ? extends CharSequence> variables) {
        String prefix = AbstractAST.getPrefixF(properties);
        StringBuilder javaForm = new StringBuilder(prefix);
        if (this.isZero()) {
            return javaForm.append("CD0");
        }
        if (this.isOne()) {
            return javaForm.append("CD1");
        }
        if (this.isMinusOne()) {
            return javaForm.append("CND1");
        }
        return javaForm.append("num(").append(this.fDouble).append(")");
    }

    @Override
    public CharSequence internalScalaString(boolean symbolsAsFactoryMethod, int depth) {
        IExpr.SourceCodeProperties p = AbstractAST.scalaFormProperties(symbolsAsFactoryMethod);
        return this.internalJavaString(p, depth, x -> null);
    }

    @Override
    public int intValue() {
        return (int)this.fDouble;
    }

    @Override
    public ISignedNumber inverse() {
        if (this.isOne()) {
            return this;
        }
        return Num.valueOf(1.0 / this.fDouble);
    }

    @Override
    public long determinePrecision() {
        return 16L;
    }

    @Override
    public boolean isE() {
        return F.isZero(this.fDouble - Math.E);
    }

    @Override
    public boolean isGT(ISignedNumber that) {
        return this.fDouble > that.doubleValue();
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.fDouble);
    }

    @Override
    public boolean isLT(ISignedNumber that) {
        return this.fDouble < that.doubleValue();
    }

    @Override
    public boolean isMinusOne() {
        return F.isZero(this.fDouble + 1.0);
    }

    public boolean isNaN() {
        return Double.isNaN(this.fDouble);
    }

    @Override
    public boolean isNegative() {
        return this.fDouble < 0.0;
    }

    @Override
    public boolean isNumEqualInteger(IInteger value) throws ArithmeticException {
        return F.isNumEqualInteger(this.fDouble, value);
    }

    @Override
    public boolean isNumEqualRational(IRational value) throws ArithmeticException {
        return F.isNumEqualRational(this.fDouble, value);
    }

    @Override
    public boolean isNumIntValue() {
        return F.isNumIntValue(this.fDouble);
    }

    @Override
    public boolean isOne() {
        return F.isZero(this.fDouble - 1.0);
    }

    @Override
    public boolean isPi() {
        return F.isZero(this.fDouble - Math.PI);
    }

    @Override
    public boolean isPositive() {
        return this.fDouble > 0.0;
    }

    @Override
    public boolean isRationalValue(IRational value) {
        return F.isZero(this.fDouble - value.doubleValue());
    }

    @Override
    public boolean isSame(IExpr expression, double epsilon) {
        if (expression instanceof Num) {
            return F.isZero(this.fDouble - ((Num)expression).fDouble, epsilon);
        }
        return false;
    }

    @Override
    public boolean isZero() {
        return F.isZero(this.fDouble, Config.DOUBLE_TOLERANCE);
    }

    @Override
    public long leafCountSimplify() {
        return 2L;
    }

    public long longValue() {
        return (long)this.fDouble;
    }

    public double minus(double that) {
        return this.fDouble - that;
    }

    @Override
    public INum multiply(INum val) {
        if (val instanceof ApfloatNum) {
            return F.num(EvalEngine.getApfloat().multiply(this.apfloatValue(), ((ApfloatNum)val).apfloatValue()));
        }
        return Num.valueOf(this.fDouble * val.getRealPart());
    }

    @Override
    public ISignedNumber negate() {
        return Num.valueOf(-this.fDouble);
    }

    @Override
    public Num numValue() {
        return this;
    }

    @Override
    public ISignedNumber opposite() {
        return Num.valueOf(-this.fDouble);
    }

    public double plus(double that) {
        return this.fDouble + that;
    }

    @Override
    public IExpr plus(IExpr that) {
        if (that instanceof Num) {
            return Num.valueOf(this.fDouble + ((Num)that).fDouble);
        }
        if (that instanceof IComplexNum) {
            if (that instanceof ApcomplexNum) {
                return this.apcomplexNumValue().add(((ApcomplexNum)that).apcomplexNumValue());
            }
            return ComplexNum.valueOf(this.fDouble).add((IComplexNum)((ComplexNum)that));
        }
        if (that instanceof ApfloatNum) {
            return this.apfloatNumValue().add(((ApfloatNum)that).apfloatNumValue());
        }
        return INum.super.plus(that);
    }

    @Override
    public INum pow(INum val) {
        return Num.valueOf(Math.pow(this.fDouble, val.getRealPart()));
    }

    @Override
    public IExpr power(IExpr that) {
        if (that instanceof Num) {
            if (this.fDouble < 0.0) {
                return ComplexNum.valueOf(this.fDouble).power(that);
            }
            return Num.valueOf(Math.pow(this.fDouble, ((Num)that).getRealPart()));
        }
        if (that instanceof IComplexNum) {
            if (that instanceof ApcomplexNum) {
                return F.complexNum(EvalEngine.getApfloat().pow(this.apcomplexValue(), ((ApcomplexNum)that).apcomplexValue()));
            }
            return ComplexNum.valueOf(this.fDouble).power(that);
        }
        if (that instanceof ApfloatNum) {
            if (this.fDouble < 0.0) {
                return F.complexNum(EvalEngine.getApfloat().pow((Apcomplex)this.apfloatValue(), ((ApfloatNum)that).apcomplexValue()));
            }
            return F.num(EvalEngine.getApfloat().pow(this.apfloatValue(), ((ApfloatNum)that).apfloatValue()));
        }
        return INum.super.power(that);
    }

    @Override
    public long precision() throws ApfloatRuntimeException {
        return 15L;
    }

    @Override
    public IInteger roundExpr() {
        return F.ZZ(DoubleMath.roundToBigInteger((double)this.fDouble, (RoundingMode)RoundingMode.HALF_EVEN));
    }

    @Override
    public ISignedNumber roundClosest(ISignedNumber multiple) {
        if (multiple.isRational()) {
            return F.ZZ(DoubleMath.roundToBigInteger((double)(this.fDouble / multiple.doubleValue()), (RoundingMode)RoundingMode.HALF_EVEN)).multiply((IRational)multiple);
        }
        double factor = multiple.doubleValue();
        return F.num(DoubleMath.roundToBigInteger((double)(this.fDouble / factor), (RoundingMode)RoundingMode.HALF_EVEN).doubleValue() * factor);
    }

    @Override
    public int complexSign() {
        return (int)Math.signum(this.fDouble);
    }

    @Override
    public IExpr sqrt() {
        if (this.fDouble < 0.0) {
            Complex c = new Complex(this.fDouble);
            return F.complexNum(c.sqrt());
        }
        return Num.valueOf(Math.sqrt(this.fDouble));
    }

    @Override
    public ISignedNumber subtractFrom(ISignedNumber that) {
        if (that instanceof Num) {
            return Num.valueOf(this.fDouble - ((Num)that).fDouble);
        }
        if (that instanceof ApfloatNum) {
            return this.apfloatNumValue().subtract(that.apfloatNumValue());
        }
        return Num.valueOf(this.doubleValue() - that.doubleValue());
    }

    @Override
    public IExpr times(IExpr that) {
        if (that instanceof Num) {
            return Num.valueOf(this.fDouble * ((Num)that).fDouble);
        }
        if (that instanceof IComplexNum) {
            if (that instanceof ApcomplexNum) {
                return this.apcomplexNumValue().multiply(((ApcomplexNum)that).apcomplexNumValue());
            }
            return ComplexNum.valueOf(this.fDouble).multiply((ComplexNum)that);
        }
        if (that instanceof ApfloatNum) {
            return this.apfloatNumValue().multiply(((ApfloatNum)that).apfloatNumValue());
        }
        return INum.super.times(that);
    }

    @Override
    public int toInt() throws ArithmeticException {
        return NumberUtil.toInt(this.fDouble);
    }

    @Override
    public int toIntDefault(int defaultValue) {
        if (DoubleMath.isMathematicalInteger((double)this.fDouble)) {
            return (int)this.fDouble;
        }
        return defaultValue;
    }

    @Override
    public long toLongDefault(long defaultValue) {
        try {
            return NumberUtil.toLong(this.fDouble);
        }
        catch (ArithmeticException ae) {
            return defaultValue;
        }
    }

    @Override
    public long toLong() throws ArithmeticException {
        return NumberUtil.toLong(this.fDouble);
    }

    public String toString() {
        if (ParserConfig.EXPLICIT_TIMES_OPERATOR) {
            return Double.toString(this.fDouble);
        }
        StringBuilder buf = new StringBuilder();
        DoubleToMMA.doubleToMMA(buf, this.fDouble, 5, 7);
        return buf.toString();
    }

    @Override
    public IExpr ulp() {
        return Num.valueOf(Math.ulp(this.fDouble));
    }

    @Override
    public IExpr cos() {
        return Num.valueOf(Math.cos(this.fDouble));
    }

    @Override
    public IExpr cosh() {
        return Num.valueOf(Math.cosh(this.fDouble));
    }

    @Override
    public IExpr exp() {
        return Num.valueOf(Math.exp(this.fDouble));
    }

    @Override
    public IExpr log() {
        return Num.valueOf(Math.log(this.fDouble));
    }

    @Override
    public IExpr pow(int n) {
        return Num.valueOf(Math.pow(this.fDouble, n));
    }

    @Override
    public IExpr rootN(int n) {
        return Num.valueOf(Math.pow(this.fDouble, 1.0 / (double)n));
    }

    @Override
    public IExpr sign() {
        if (this.isNaN() || this.isZero()) {
            return this;
        }
        return Num.valueOf(Math.abs(this.fDouble));
    }

    @Override
    public IExpr sin() {
        return Num.valueOf(Math.sin(this.fDouble));
    }

    @Override
    public IExpr sinh() {
        return Num.valueOf(Math.sinh(this.fDouble));
    }

    @Override
    public IExpr tan() {
        return Num.valueOf(Math.tan(this.fDouble));
    }

    @Override
    public IExpr tanh() {
        return Num.valueOf(Math.tanh(this.fDouble));
    }

    @Override
    public IExpr getPi() {
        return F.num(Math.PI);
    }

    @Override
    public IExpr toDegrees() {
        return Num.valueOf(this.fDouble * 180.0 / Math.PI);
    }

    @Override
    public IExpr toRadians() {
        return Num.valueOf(this.fDouble * Math.PI / 180.0);
    }
}

