/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.util.Comparator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apfloat.Apfloat;
import org.apfloat.FixedPrecisionApfloatHelper;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalAttributes;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class IntervalSym {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Comparator<IExpr> INTERVAL_COMPARATOR = new Comparator<IExpr>(){

        @Override
        public int compare(IExpr o1, IExpr o2) {
            if (o1.first().equals(o2.first())) {
                if (o1.second().equals(o2.second())) {
                    return 0;
                }
                return S.Greater.ofQ(o1.second(), o2.second()) ? 1 : -1;
            }
            return S.Greater.ofQ(o1.first(), o2.first()) ? 1 : -1;
        }
    };

    private static boolean isNormalized(IAST interval) {
        return interval.isEvalFlagOn(262144);
    }

    public static IAST normalize(IAST intervalList) {
        if (IntervalSym.isNormalized(intervalList)) {
            return intervalList;
        }
        IAST norm = IntervalSym.normalize(intervalList, EvalEngine.get());
        if (norm.isPresent()) {
            return norm;
        }
        if (IntervalSym.isNormalized(intervalList)) {
            return intervalList;
        }
        return F.NIL;
    }

    public static IAST normalize(IAST intervalList, EvalEngine engine) {
        try {
            IASTAppendable result = intervalList.copyAppendable();
            boolean evaled = false;
            for (int i = 1; i < intervalList.size(); ++i) {
                IAST temp = IntervalSym.normalizeArgument(intervalList.get(i), engine);
                if (!temp.isPresent()) continue;
                evaled = true;
                result.set(i, temp);
            }
            if (EvalAttributes.sort(result, INTERVAL_COMPARATOR)) {
                evaled = true;
            }
            result.addEvalFlags(262144);
            if (result.size() > 2) {
                int j = 1;
                IAST list1 = (IAST)result.arg1();
                IExpr min1 = list1.arg1();
                IExpr max1 = list1.arg2();
                int i = 2;
                while (i < result.size()) {
                    IAST list2 = (IAST)result.get(i);
                    IExpr min2 = list2.arg1();
                    IExpr max2 = list2.arg2();
                    if (min2.lessEqual(max1).isTrue()) {
                        if (max2.lessEqual(max1).isTrue()) {
                            evaled = true;
                            result.remove(i);
                            continue;
                        }
                        evaled = true;
                        result.remove(i);
                        list1 = F.list(min1, max2);
                        max1 = max2;
                        continue;
                    }
                    result.set(j++, list1);
                    list1 = list2;
                    min1 = min2;
                    max1 = max2;
                    ++i;
                }
                result.set(j, list1);
            }
            if (evaled) {
                return result;
            }
            if (intervalList instanceof IASTMutable) {
                intervalList.addEvalFlags(262144);
                if (EvalAttributes.sort((IASTMutable)intervalList, INTERVAL_COMPARATOR)) {
                    return intervalList;
                }
            }
            return F.NIL;
        }
        catch (RuntimeException rex) {
            LOGGER.log(engine.getLogLevel(), "Interval", (Throwable)rex);
            return F.NIL;
        }
    }

    public static Apfloat[] interval(Apfloat x) {
        FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
        return new Apfloat[]{h.nextDown(x), h.nextUp(x)};
    }

    private static IAST normalizeArgument(IExpr arg, EvalEngine engine) {
        if (arg.isList()) {
            if (arg.size() == 3) {
                IExpr max;
                IAST list = (IAST)arg;
                IExpr arg1 = list.arg1();
                IExpr arg2 = list.arg2();
                if (arg1.isReal() && arg2.isReal()) {
                    if (arg1.greaterThan(arg2).isTrue()) {
                        return F.list(arg2, arg1);
                    }
                    return F.NIL;
                }
                IExpr min = arg1.isNumber() ? arg1 : engine.evaluate(arg1);
                IExpr iExpr = max = arg2.isNumber() ? arg2 : engine.evaluate(arg2);
                if (min.isRealResult() && max.isRealResult() && min.greaterThan(max).isTrue()) {
                    return F.list(max, min);
                }
                return F.NIL;
            }
            String str = IOFunctions.getMessage("nvld", F.list(arg), engine);
            throw new ArgumentTypeException(str);
        }
        if (arg instanceof INum) {
            if (arg instanceof ApfloatNum) {
                Apfloat apfloat = ((ApfloatNum)arg).fApfloat;
                Apfloat[] values = IntervalSym.interval(apfloat);
                return F.list(F.num(values[0]), F.num(values[1]));
            }
            double value = ((ISignedNumber)arg).doubleValue();
            return F.list(F.num(Math.nextDown(value)), F.num(Math.nextUp(value)));
        }
        return F.list(arg, arg);
    }

    private static IExpr mag(IExpr inf, IExpr sup, EvalEngine engine) {
        if (engine.evalGreaterEqual(inf, F.C0)) {
            return sup;
        }
        if (engine.evalLessEqual(sup, F.C0)) {
            return inf.negate();
        }
        return F.Max(inf.negate(), sup);
    }

    public static IExpr max(IAST ast) {
        IAST interval = IntervalSym.normalize(ast);
        if (interval.isPresent()) {
            IASTAppendable result = F.ast((IExpr)S.Max, interval.size());
            for (int i = 1; i < interval.size(); ++i) {
                IAST list = (IAST)interval.get(i);
                result.append(list.arg2());
            }
            return result;
        }
        return F.NIL;
    }

    private static IExpr mig(IExpr inf, IExpr sup, EvalEngine engine) {
        if (engine.evalGreater(inf, F.C0)) {
            return inf;
        }
        if (engine.evalLess(sup, F.C0)) {
            return sup.negate();
        }
        return F.C0;
    }

    public static IExpr min(IAST ast) {
        IAST interval = IntervalSym.normalize(ast);
        if (interval.isPresent()) {
            IASTAppendable result = F.ast((IExpr)S.Min, interval.size());
            for (int i = 1; i < interval.size(); ++i) {
                IAST list = (IAST)interval.get(i);
                result.append(list.arg1());
            }
            return result;
        }
        return F.NIL;
    }

    public static IExpr abs(IAST ast) {
        IAST interval = IntervalSym.normalize(ast);
        if (interval.isPresent()) {
            IASTAppendable result = F.IntervalAlloc(interval.size());
            EvalEngine engine = EvalEngine.get();
            for (int i = 1; i < interval.size(); ++i) {
                IAST list = (IAST)interval.get(i);
                IExpr min = list.arg1();
                IExpr max = list.arg2();
                if (!min.isRealResult() || !max.isRealResult()) {
                    return F.NIL;
                }
                result.append(F.list(IntervalSym.mig(min, max, engine), IntervalSym.mag(min, max, engine)));
            }
            return result;
        }
        return F.NIL;
    }

    private static IAST mutableProcessorConditions(IAST ast, IExprProcessor ... processors) {
        IAST interval;
        if (processors != null && processors.length > 0 && (interval = IntervalSym.normalize(ast)).isPresent()) {
            try {
                IASTAppendable result = F.IntervalAlloc(interval.size());
                for (int i = 1; i < interval.size(); ++i) {
                    IExprProcessor processor;
                    IAST list = (IAST)interval.get(i);
                    IExpr min = list.arg1();
                    IExpr max = list.arg2();
                    boolean processed = false;
                    IExprProcessor[] iExprProcessorArray = processors;
                    int n = iExprProcessorArray.length;
                    for (int j = 0; j < n && !(processed = (processor = iExprProcessorArray[j]).apply(min, max, result, i)); ++j) {
                    }
                    if (processed) continue;
                    return F.NIL;
                }
                return result;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return F.NIL;
    }

    public static IExpr arccosh(IAST ast) {
        EvalEngine engine = EvalEngine.get();
        return IntervalSym.mutableProcessorConditions(ast, (min, max, result, index) -> {
            if (engine.evalGreaterEqual(min, F.C1) && engine.evalLessEqual(max, F.CInfinity)) {
                result.append(index, F.list(F.ArcCosh(min), F.ArcCosh(max)));
                return true;
            }
            return false;
        });
    }

    public static IExpr arcsinh(IAST ast) {
        return IntervalSym.mutableProcessorConditions(ast, (min, max, result, index) -> {
            if (min.isRealResult() && max.isRealResult()) {
                result.append(index, F.list(F.ArcSinh(min), F.ArcSinh(max)));
                return true;
            }
            return false;
        });
    }

    public static IExpr arctanh(IAST ast) {
        EvalEngine engine = EvalEngine.get();
        return IntervalSym.mutableProcessorConditions(ast, (min, max, result, index) -> {
            if (engine.evalGreaterEqual(min, F.CN1) && engine.evalLessEqual(max, F.C1)) {
                result.append(index, F.list(F.ArcTanh(min), F.ArcTanh(max)));
                return true;
            }
            return false;
        });
    }

    public static IExpr arccos(IAST ast) {
        EvalEngine engine = EvalEngine.get();
        return IntervalSym.mutableProcessorConditions(ast, (min, max, result, index) -> {
            if (engine.evalGreaterEqual(min, F.CN1) && engine.evalLessEqual(max, F.C1)) {
                result.append(index, F.list(F.ArcCos(min), F.ArcCos(max)));
                return true;
            }
            return false;
        });
    }

    public static IExpr arccot(IAST ast) {
        EvalEngine engine = EvalEngine.get();
        return IntervalSym.mutableProcessorConditions(ast, (min, max, result, index) -> {
            if (engine.evalGreaterEqual(min, F.C0) && engine.evalGreaterEqual(max, F.C0)) {
                result.append(F.list(F.ArcCot(min), F.ArcCot(max)));
                return true;
            }
            return false;
        }, (min, max, result, index) -> {
            if (engine.evalLess(min, F.C0) && engine.evalGreaterEqual(max, F.C0)) {
                result.append(F.list(F.CNPiHalf, F.ArcCot(min)));
                result.append(F.list(F.ArcCot(max), F.CPiHalf));
                return true;
            }
            return false;
        }, (min, max, result, index) -> {
            if (engine.evalLess(min, F.C0) && engine.evalLess(max, F.C0)) {
                result.append(F.list(F.ArcCot(min), F.ArcCot(max)));
                return true;
            }
            return false;
        });
    }

    public static IExpr arcsin(IAST ast) {
        EvalEngine engine = EvalEngine.get();
        return IntervalSym.mutableProcessorConditions(ast, (min, max, result, index) -> {
            if (engine.evalGreaterEqual(min, F.CN1) && engine.evalLessEqual(max, F.C1)) {
                result.append(index, F.list(F.ArcSin(min), F.ArcSin(max)));
                return true;
            }
            return false;
        });
    }

    public static IExpr arctan(IAST ast) {
        return IntervalSym.mutableProcessorConditions(ast, (min, max, result, index) -> {
            if (min.isRealResult() && max.isRealResult()) {
                result.append(index, F.list(F.ArcTan(min), F.ArcTan(max)));
                return true;
            }
            return false;
        });
    }

    public static IAST coth(IAST ast) {
        EvalEngine engine = EvalEngine.get();
        return IntervalSym.mutableProcessorConditions(ast, (min, max, result, index) -> {
            if (engine.evalGreaterEqual(min, F.C0) && engine.evalGreaterEqual(max, F.C0)) {
                result.append(F.list(F.Coth(max), F.Coth(min)));
                return true;
            }
            return false;
        }, (min, max, result, index) -> {
            if (engine.evalLess(min, F.C0) && engine.evalGreaterEqual(max, F.C0)) {
                result.append(F.list(F.CNInfinity, F.Coth(min)));
                result.append(F.list(F.Coth(max), F.CInfinity));
                return true;
            }
            return false;
        }, (min, max, result, index) -> {
            if (engine.evalLess(min, F.C0) && engine.evalLess(max, F.C0)) {
                result.append(F.list(F.Coth(min), F.Coth(max)));
                return true;
            }
            return false;
        });
    }

    public static IAST cosh(IAST ast) {
        EvalEngine engine = EvalEngine.get();
        return IntervalSym.mutableProcessorConditions(ast, (min, max, result, index) -> {
            if (min.isRealResult() && max.isRealResult()) {
                if (engine.evalGreaterEqual(min, F.C0) && engine.evalGreaterEqual(max, F.C0)) {
                    result.append(F.list(F.Cosh(min), F.Cosh(max)));
                } else if (engine.evalLess(min, F.C0) && engine.evalGreaterEqual(max, F.C0)) {
                    result.append(F.list(F.C1, F.Max(F.Cosh(min), F.Cosh(max))));
                } else if (engine.evalLess(min, F.C0) && engine.evalLess(max, F.C0)) {
                    result.append(F.list(F.Cosh(min), F.Cosh(max)));
                }
                return true;
            }
            return false;
        });
    }

    public static IAST csch(IAST ast) {
        EvalEngine engine = EvalEngine.get();
        return IntervalSym.mutableProcessorConditions(ast, (min, max, result, index) -> {
            if (engine.evalGreaterEqual(min, F.C0) && engine.evalGreaterEqual(max, F.C0)) {
                result.append(F.list(F.Csch(max), F.Csch(min)));
                return true;
            }
            return false;
        }, (min, max, result, index) -> {
            if (engine.evalLess(min, F.C0) && engine.evalGreaterEqual(max, F.C0)) {
                result.append(F.list(F.CNInfinity, F.Csch(min)));
                result.append(F.list(F.Csch(max), F.CInfinity));
                return true;
            }
            return false;
        }, (min, max, result, index) -> {
            if (engine.evalLess(min, F.C0) && engine.evalLess(max, F.C0)) {
                result.append(F.list(F.Csch(min), F.Csch(max)));
                return true;
            }
            return false;
        });
    }

    public static IAST sech(IAST ast) {
        EvalEngine engine = EvalEngine.get();
        return IntervalSym.mutableProcessorConditions(ast, (min, max, result, index) -> {
            if (min.isRealResult() && max.isRealResult()) {
                if (engine.evalGreaterEqual(min, F.C0) && engine.evalGreaterEqual(max, F.C0)) {
                    result.append(F.list(F.Sech(max), F.Sech(min)));
                } else if (engine.evalLess(min, F.C0) && engine.evalGreaterEqual(max, F.C0)) {
                    result.append(F.list(F.Min(F.Sech(min), F.Sech(max)), F.C1));
                } else if (engine.evalLess(min, F.C0) && engine.evalLess(max, F.C0)) {
                    result.append(F.list(F.Sech(min), F.Sech(max)));
                }
                return true;
            }
            return false;
        });
    }

    public static IAST sinh(IAST ast) {
        return IntervalSym.mutableProcessorConditions(ast, (min, max, result, index) -> {
            if (min.isRealResult() && max.isRealResult()) {
                result.append(index, F.list(F.Sinh(min), F.Sinh(max)));
                return true;
            }
            return false;
        });
    }

    public static IAST tanh(IAST ast) {
        return IntervalSym.mutableProcessorConditions(ast, (min, max, result, index) -> {
            if (min.isRealResult() && max.isRealResult()) {
                result.append(index, F.list(F.Tanh(min), F.Tanh(max)));
                return true;
            }
            return false;
        });
    }

    public static IAST inverse(IAST interval) {
        IAST normalizedInterval = IntervalSym.normalize(interval);
        if (normalizedInterval.isPresent()) {
            IASTAppendable result = F.IntervalAlloc(normalizedInterval.size());
            for (int i = 1; i < normalizedInterval.size(); ++i) {
                IAST list = (IAST)normalizedInterval.get(i);
                if (list.arg1().isRealResult() && list.arg2().isRealResult()) {
                    if (list.arg1().isNegativeResult()) {
                        if (list.arg2().isNegativeResult()) {
                            result.append(F.list(list.arg1().inverse(), list.arg2().inverse()));
                            continue;
                        }
                        result.append(F.list(F.CNInfinity, list.arg1().inverse()));
                        if (list.arg2().isZero()) continue;
                        result.append(F.list(list.arg2().inverse(), F.CInfinity));
                        continue;
                    }
                    if (list.arg1().isZero()) {
                        if (list.arg2().isZero()) {
                            result.append(F.list(F.CNInfinity, F.CInfinity));
                            continue;
                        }
                        result.append(F.list(list.arg2().inverse(), F.CInfinity));
                        continue;
                    }
                    result.append(F.list(list.arg1().inverse(), list.arg2().inverse()));
                    continue;
                }
                return F.NIL;
            }
            return result;
        }
        return F.NIL;
    }

    public static IAST csc(IAST ast) {
        IAST interval = IntervalSym.sin(ast);
        if (interval.isPresent()) {
            return IntervalSym.inverse(interval);
        }
        return F.NIL;
    }

    public static IAST cos(IAST ast) {
        EvalEngine engine = EvalEngine.get();
        return IntervalSym.mutableProcessorConditions(ast, (min, max, result, index) -> {
            IAST difference = F.Subtract(max, min);
            if (engine.evalGreaterEqual(difference, F.C2Pi)) {
                result.append(index, F.list(F.CN1, F.C1));
            } else {
                double dMin = engine.evalDouble(F.Sin(min).negate());
                double dMax = engine.evalDouble(F.Sin(max).negate());
                if (engine.evalLessEqual(difference, S.Pi)) {
                    if (dMin >= 0.0) {
                        if (dMax >= 0.0) {
                            result.append(index, F.list(F.Cos(min), F.Cos(max)));
                        } else {
                            result.append(index, F.list(F.Min(F.Cos(min), F.Cos(max)), F.C1));
                        }
                    } else if (dMax < 0.0) {
                        result.append(index, F.list(F.Cos(max), F.Cos(min)));
                    } else {
                        result.append(index, F.list(F.CN1, F.Max(F.Cos(min), F.Cos(max))));
                    }
                } else if (dMin >= 0.0) {
                    if (dMax > 0.0) {
                        result.append(index, F.list(F.CN1, F.C1));
                    } else {
                        result.append(index, F.list(F.Min(F.Cos(min), F.Cos(max)), F.C1));
                    }
                } else if (dMax < 0.0) {
                    result.append(index, F.list(F.CN1, F.C1));
                } else {
                    result.append(index, F.list(F.CN1, F.Max(F.Cos(min), F.Cos(max))));
                }
            }
            return true;
        });
    }

    public static IAST cot(IAST ast) {
        EvalEngine engine = EvalEngine.get();
        return IntervalSym.mutableProcessorConditions(ast, (min, max, result, index) -> {
            IAST difference = F.Subtract(max, min);
            if (engine.evalGreaterEqual(difference, S.Pi)) {
                result.append(F.list(F.CNInfinity, F.CInfinity));
            } else {
                double dMin = engine.evalDouble(F.Cot(min));
                double dMax = engine.evalDouble(F.Cot(max));
                if (engine.evalLessEqual(difference, F.CPiHalf)) {
                    if (dMin < 0.0) {
                        if (dMax >= 0.0) {
                            result.append(F.list(F.CNInfinity, F.Cot(min)));
                            result.append(F.list(F.Cot(max), F.CInfinity));
                        } else {
                            result.append(F.list(F.Cot(max), F.Cot(min)));
                        }
                    } else {
                        result.append(F.list(F.Cot(min), F.Cot(max)));
                    }
                } else if (dMin >= 0.0) {
                    if (dMax < 0.0) {
                        result.append(F.list(F.CNInfinity, F.Cot(max)));
                        result.append(F.list(F.Cot(min), F.CInfinity));
                    } else if (dMin < dMax) {
                        result.append(F.list(F.CNInfinity, F.Cot(min)));
                        result.append(F.list(F.Cot(max), F.CInfinity));
                    } else {
                        result.append(F.list(F.CNInfinity, F.CInfinity));
                    }
                } else if (dMax < 0.0) {
                    if (dMin < dMax) {
                        result.append(F.list(F.Cot(max), F.CInfinity));
                        result.append(F.list(F.CNInfinity, F.Cot(min)));
                    } else {
                        result.append(F.list(F.CNInfinity, F.CInfinity));
                    }
                } else {
                    result.append(F.list(F.CNInfinity, F.CInfinity));
                }
            }
            return true;
        });
    }

    public static IExpr mapSymbol(ISymbol symbol, IAST ast) {
        IAST interval = IntervalSym.normalize(ast);
        if (interval.isPresent()) {
            IASTAppendable result = F.IntervalAlloc(interval.size());
            for (int i = 1; i < interval.size(); ++i) {
                IAST list = (IAST)interval.get(i);
                IExpr min = list.arg1();
                IExpr max = list.arg2();
                if (!min.isRealResult() || !max.isRealResult()) {
                    return F.NIL;
                }
                result.append(F.list(F.unaryAST1(symbol, min), F.unaryAST1(symbol, max)));
            }
            return result;
        }
        return F.NIL;
    }

    public static IAST log(IAST ast) {
        EvalEngine engine = EvalEngine.get();
        return IntervalSym.mutableProcessorConditions(ast, (min, max, result, index) -> {
            if (min.isNonNegativeResult() && max.isNonNegativeResult()) {
                min = S.Log.of(engine, min);
                max = S.Log.of(engine, max);
                result.append(index, F.list(min, max));
                return true;
            }
            return false;
        });
    }

    public static IAST sec(IAST ast) {
        IAST interval = IntervalSym.cos(ast);
        if (interval.isPresent()) {
            return IntervalSym.inverse(interval);
        }
        return F.NIL;
    }

    public static IAST sin(IAST ast) {
        EvalEngine engine = EvalEngine.get();
        return IntervalSym.mutableProcessorConditions(ast, (min, max, result, index) -> {
            IAST difference = F.Subtract(max, min);
            if (engine.evalGreaterEqual(difference, F.C2Pi)) {
                result.append(index, F.list(F.CN1, F.C1));
            } else {
                double dMin = engine.evalDouble(F.Cos(min));
                double dMax = engine.evalDouble(F.Cos(max));
                if (engine.evalLessEqual(difference, S.Pi)) {
                    if (dMin >= 0.0) {
                        if (dMax >= 0.0) {
                            result.append(index, F.list(F.Sin(min), F.Sin(max)));
                        } else {
                            result.append(index, F.list(F.Min(F.Sin(min), F.Sin(max)), F.C1));
                        }
                    } else if (dMax < 0.0) {
                        result.append(index, F.list(F.Sin(max), F.Sin(min)));
                    } else {
                        result.append(index, F.list(F.CN1, F.Max(F.Sin(min), F.Sin(max))));
                    }
                } else if (dMin >= 0.0) {
                    if (dMax > 0.0) {
                        result.append(index, F.list(F.CN1, F.C1));
                    } else {
                        result.append(index, F.list(F.Min(F.Sin(min), F.Sin(max)), F.C1));
                    }
                } else if (dMax < 0.0) {
                    result.append(index, F.list(F.CN1, F.C1));
                } else {
                    result.append(index, F.list(F.CN1, F.Max(F.Sin(min), F.Sin(max))));
                }
            }
            return true;
        });
    }

    public static IAST tan(IAST ast) {
        EvalEngine engine = EvalEngine.get();
        return IntervalSym.mutableProcessorConditions(ast, (min, max, result, index) -> {
            IAST difference = F.Subtract(max, min);
            if (engine.evalGreaterEqual(difference, S.Pi)) {
                result.append(F.list(F.CNInfinity, F.CInfinity));
            } else {
                double dMin = engine.evalDouble(F.Tan(min));
                double dMax = engine.evalDouble(F.Tan(max));
                if (engine.evalLessEqual(difference, F.CPiHalf)) {
                    if (dMin >= 0.0) {
                        if (dMax < 0.0) {
                            result.append(F.list(F.CNInfinity, F.Tan(max)));
                            result.append(F.list(F.Tan(min), F.CInfinity));
                        } else {
                            result.append(F.list(F.Tan(min), F.Tan(max)));
                        }
                    } else {
                        result.append(F.list(F.Tan(min), F.Tan(max)));
                    }
                } else if (dMin >= 0.0) {
                    if (dMax < 0.0 || dMin > dMax) {
                        result.append(F.list(F.CNInfinity, F.Tan(max)));
                        result.append(F.list(F.Tan(min), F.CInfinity));
                    } else {
                        result.append(F.list(F.CNInfinity, F.CInfinity));
                    }
                } else if (dMax < 0.0) {
                    if (dMin <= dMax) {
                        result.append(F.list(F.CNInfinity, F.CInfinity));
                    } else {
                        result.append(F.list(F.CNInfinity, F.Tan(max)));
                        result.append(F.list(F.Tan(min), F.CInfinity));
                    }
                } else {
                    result.append(F.list(F.Tan(min), F.Tan(max)));
                }
            }
            return true;
        });
    }

    public static IExpr plus(IAST ast1, IAST ast2) {
        IAST interval1 = IntervalSym.normalize(ast1);
        IAST interval2 = IntervalSym.normalize(ast2);
        if (interval1.isPresent() && interval2.isPresent()) {
            IASTAppendable result = F.IntervalAlloc(interval1.size() * interval2.size());
            for (int i = 1; i < interval1.size(); ++i) {
                IAST list1 = (IAST)interval1.get(i);
                IExpr min1 = list1.arg1();
                IExpr max1 = list1.arg2();
                for (int j = 1; j < interval2.size(); ++j) {
                    IAST list2 = (IAST)interval2.get(j);
                    IExpr min2 = list2.arg1();
                    IExpr max2 = list2.arg2();
                    IAST list = F.list(min1.plus(min2), max1.plus(max2));
                    result.append(list);
                }
            }
            return result;
        }
        return F.NIL;
    }

    public static IExpr plus(IExpr scalar, IAST ast2) {
        IAST interval2 = IntervalSym.normalize(ast2);
        if (scalar.isRealResult() && interval2.isPresent()) {
            IASTAppendable result = F.IntervalAlloc(interval2.size());
            for (int j = 1; j < interval2.size(); ++j) {
                IAST list2 = (IAST)interval2.get(j);
                IExpr min2 = list2.arg1();
                IExpr max2 = list2.arg2();
                IAST list = F.list(scalar.plus(min2), scalar.plus(max2));
                result.append(list);
            }
            return result;
        }
        return F.NIL;
    }

    public static IExpr times(IAST ast1, IAST ast2) {
        IAST interval1 = IntervalSym.normalize(ast1);
        IAST interval2 = IntervalSym.normalize(ast2);
        if (interval1.isPresent() && interval2.isPresent()) {
            IASTAppendable result = F.IntervalAlloc(interval1.size() * interval2.size());
            for (int i = 1; i < interval1.size(); ++i) {
                IAST list1 = (IAST)interval1.get(i);
                IExpr min1 = list1.arg1();
                IExpr max1 = list1.arg2();
                for (int j = 1; j < interval2.size(); ++j) {
                    IAST list2 = (IAST)interval2.get(j);
                    IExpr min2 = list2.arg1();
                    IExpr max2 = list2.arg2();
                    IAST list = F.list(F.Min(min1.times(min2), min1.times(max2), max1.times(min2), max1.times(max2)), F.Max(min1.times(min2), min1.times(max2), max1.times(min2), max1.times(max2)));
                    result.append(list);
                }
            }
            return result;
        }
        return F.NIL;
    }

    public static IExpr times(IExpr scalar, IAST ast2) {
        IAST interval2 = IntervalSym.normalize(ast2);
        if (scalar.isRealResult() && interval2.isPresent()) {
            IASTAppendable result = F.IntervalAlloc(interval2.size());
            for (int j = 1; j < interval2.size(); ++j) {
                IAST list2 = (IAST)interval2.get(j);
                IExpr min2 = list2.arg1();
                IExpr max2 = list2.arg2();
                IAST list = F.list(F.Min(scalar.times(min2), scalar.times(max2), scalar.times(min2), scalar.times(max2)), F.Max(scalar.times(min2), scalar.times(max2), scalar.times(min2), scalar.times(max2)));
                result.append(list);
            }
            return result;
        }
        return F.NIL;
    }

    public static IExpr power(IAST baseInterval, IInteger exponent) {
        IAST interval = IntervalSym.normalize(baseInterval);
        if (interval.isPresent()) {
            boolean negative = false;
            if (exponent.isNegative()) {
                negative = true;
                exponent = exponent.negate();
            }
            if (exponent.isOne()) {
                if (negative) {
                    return IntervalSym.inverse(interval);
                }
                return baseInterval;
            }
            IASTAppendable result = F.IntervalAlloc(baseInterval.size());
            for (int i = 1; i < interval.size(); ++i) {
                IAST list = (IAST)interval.get(i);
                if (list.arg1().isRealResult() && list.arg2().isRealResult()) {
                    if (exponent.isEven()) {
                        if (list.arg1().isNonNegativeResult()) {
                            result.append(F.list(list.arg1().power(exponent), list.arg2().power(exponent)));
                            continue;
                        }
                        if (list.arg2().isNegativeResult()) {
                            result.append(F.list(list.arg2().power(exponent), list.arg1().power(exponent)));
                            continue;
                        }
                        result.append(F.list(F.C0, F.Max(list.arg1().power(exponent), list.arg2().power(exponent))));
                        continue;
                    }
                    result.append(F.list(list.arg1().power(exponent), list.arg2().power(exponent)));
                    continue;
                }
                return F.NIL;
            }
            if (negative) {
                return F.Power((IExpr)result, F.CN1);
            }
            return result;
        }
        return F.NIL;
    }

    public static IExpr power(IAST baseInterval, ISignedNumber exponent) {
        IAST interval = IntervalSym.normalize(baseInterval);
        if (interval.isPresent()) {
            boolean negative = false;
            if (exponent.isNegative()) {
                negative = true;
                exponent = exponent.negate();
            }
            if (exponent.isOne()) {
                if (negative) {
                    return IntervalSym.inverse(interval);
                }
                return baseInterval;
            }
            IASTAppendable result = F.IntervalAlloc(baseInterval.size());
            for (int i = 1; i < interval.size(); ++i) {
                IAST list = (IAST)interval.get(i);
                if (!list.arg1().isNonNegativeResult() || !list.arg2().isNonNegativeResult()) {
                    return F.NIL;
                }
                result.append(F.list(list.arg1().power(exponent), list.arg2().power(exponent)));
            }
            if (negative) {
                return F.Power((IExpr)result, F.CN1);
            }
            return result;
        }
        return F.NIL;
    }

    public static IExpr power(IExpr base, IAST intervalExponent) {
        IAST interval = IntervalSym.normalize(intervalExponent);
        if (interval.isPresent()) {
            if (base.isNegative()) {
                if (base.isMinusOne()) {
                    return F.NIL;
                }
                return F.Times((IExpr)F.Power((IExpr)F.CN1, intervalExponent), (IExpr)F.Power(base.negate(), intervalExponent));
            }
            IASTAppendable result = F.IntervalAlloc(intervalExponent.size());
            for (int i = 1; i < interval.size(); ++i) {
                IAST list = (IAST)interval.get(i);
                if (base.isZero() && (list.arg1().isNegativeResult() || list.arg2().isNegativeResult())) {
                    return S.Indeterminate;
                }
                result.append(F.list(base.power(list.arg1()), base.power(list.arg2())));
            }
            return result;
        }
        return F.NIL;
    }

    @FunctionalInterface
    public static interface IExprProcessor {
        public boolean apply(IExpr var1, IExpr var2, IASTAppendable var3, int var4);
    }
}

