/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import com.google.common.math.IntMath;
import com.google.common.math.LongMath;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.function.Function;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.fraction.BigFraction;
import org.hipparchus.util.ArithmeticUtils;
import org.matheclipse.core.expression.AbstractAST;
import org.matheclipse.core.expression.AbstractFractionSym;
import org.matheclipse.core.expression.AbstractIntegerSym;
import org.matheclipse.core.expression.BigIntegerSym;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.numbertheory.Primality;

public class IntegerSym
extends AbstractIntegerSym {
    private static final long serialVersionUID = 6389228668633533063L;
    static final int LOW = -128;
    static final int HIGH = 128;
    static final IntegerSym[] CACHE = new IntegerSym[257];
    int fIntValue;

    public IntegerSym() {
        this.fIntValue = 0;
    }

    public IntegerSym(int value) {
        this.fIntValue = value;
    }

    @Override
    public IInteger abs() {
        if (this.fIntValue < 0) {
            return IntegerSym.valueOf((long)this.fIntValue * -1L);
        }
        return this;
    }

    @Override
    public IInteger add(IInteger that) {
        if (this.fIntValue == 0) {
            return that;
        }
        if (that instanceof BigIntegerSym) {
            return ((BigIntegerSym)that).add(this);
        }
        IntegerSym is = (IntegerSym)that;
        if (is.fIntValue == 0) {
            return this;
        }
        return IntegerSym.valueOf((long)this.fIntValue + (long)is.fIntValue);
    }

    @Override
    public IRational add(IRational parm1) {
        if (parm1.isZero()) {
            return this;
        }
        if (parm1 instanceof AbstractFractionSym) {
            return ((AbstractFractionSym)parm1).add(this);
        }
        if (parm1 instanceof IntegerSym) {
            IntegerSym is = (IntegerSym)parm1;
            long newnum = (long)this.fIntValue + (long)is.fIntValue;
            return IntegerSym.valueOf(newnum);
        }
        BigIntegerSym p1 = (BigIntegerSym)parm1;
        BigInteger newnum = this.toBigNumerator().add(p1.toBigNumerator());
        return IntegerSym.valueOf(newnum);
    }

    @Override
    public long bitLength() {
        if (this.fIntValue == 0) {
            return 0L;
        }
        return 32 - Integer.numberOfLeadingZeros(this.fIntValue < 0 ? -this.fIntValue : this.fIntValue);
    }

    @Override
    public int compareAbsValueToOne() {
        long num = this.fIntValue;
        if (this.fIntValue < 0) {
            num *= -1L;
        }
        if (num == 1L) {
            return 0;
        }
        return num > 0L ? 1 : -1;
    }

    @Override
    public int compareInt(int value) {
        return this.fIntValue > value ? 1 : (this.fIntValue == value ? 0 : -1);
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof IRational) {
            if (expr instanceof IntegerSym) {
                int num = ((IntegerSym)expr).fIntValue;
                return this.fIntValue < num ? -1 : (num == this.fIntValue ? 0 : 1);
            }
            if (expr instanceof AbstractFractionSym) {
                return -((AbstractFractionSym)expr).compareTo(AbstractFractionSym.valueOf(this.fIntValue));
            }
            if (expr instanceof BigIntegerSym) {
                return -expr.compareTo(this);
            }
        } else if (expr.isReal()) {
            return Double.compare(this.fIntValue, ((ISignedNumber)expr).doubleValue());
        }
        return super.compareTo(expr);
    }

    @Override
    public ComplexNum complexNumValue() {
        return ComplexNum.valueOf(this.doubleValue());
    }

    @Override
    public IInteger dec() {
        return this.add(F.CN1);
    }

    @Override
    public IInteger inc() {
        return this.add(F.C1);
    }

    @Override
    public IInteger div(IInteger that) {
        if (that instanceof IntegerSym) {
            return IntegerSym.valueOf(this.fIntValue / ((IntegerSym)that).fIntValue);
        }
        return IntegerSym.valueOf(this.toBigNumerator().divide(that.toBigNumerator()));
    }

    @Override
    public IInteger[] divideAndRemainder(IInteger that) {
        IInteger[] res = new IntegerSym[2];
        BigInteger[] largeRes = this.toBigNumerator().divideAndRemainder(that.toBigNumerator());
        res[0] = IntegerSym.valueOf(largeRes[0]);
        res[1] = IntegerSym.valueOf(largeRes[1]);
        return res;
    }

    @Override
    public IInteger iquo(IInteger that) {
        BigInteger[] largeRes = this.toBigNumerator().divideAndRemainder(that.toBigNumerator());
        return IntegerSym.valueOf(largeRes[0]);
    }

    @Override
    public IInteger irem(IInteger that) {
        BigInteger[] largeRes = this.toBigNumerator().divideAndRemainder(that.toBigNumerator());
        return IntegerSym.valueOf(largeRes[1]);
    }

    @Override
    public ISignedNumber divideBy(ISignedNumber that) {
        if (that instanceof IntegerSym) {
            return AbstractFractionSym.valueOf(this).divideBy(that);
        }
        if (that instanceof AbstractFractionSym) {
            return AbstractFractionSym.valueOf(this).divideBy(that);
        }
        return Num.valueOf((double)this.fIntValue / that.doubleValue());
    }

    @Override
    public double doubleValue() {
        return this.fIntValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IntegerSym) {
            return this.fIntValue == ((IntegerSym)obj).fIntValue;
        }
        return false;
    }

    @Override
    public final boolean equalsFraction(int numerator, int denominator) {
        return denominator == 1 && this.fIntValue == numerator;
    }

    @Override
    public boolean equalsInt(int value) {
        return this.fIntValue == value;
    }

    @Override
    public IExpr exponent(IInteger base) {
        IInteger b = this;
        if (this.complexSign() < 0) {
            b = b.negate();
        } else {
            if (b.isZero()) {
                return F.CInfinity;
            }
            if (b.isOne()) {
                return F.C0;
            }
        }
        if (b.equals(base)) {
            return F.C1;
        }
        BigInteger rest = Primality.countExponent(b.toBigNumerator(), base.toBigNumerator());
        return IntegerSym.valueOf(rest);
    }

    @Override
    public IInteger gcd(IInteger that) {
        if (that instanceof IntegerSym) {
            try {
                return IntegerSym.valueOf(ArithmeticUtils.gcd((int)this.fIntValue, (int)((IntegerSym)that).fIntValue));
            }
            catch (MathRuntimeException mathRuntimeException) {
                // empty catch block
            }
        }
        return IntegerSym.valueOf(this.toBigNumerator().gcd(that.toBigNumerator()));
    }

    @Override
    public IInteger denominator() {
        return F.C1;
    }

    @Override
    public BigFraction toBigFraction() {
        return new BigFraction(this.fIntValue);
    }

    @Override
    public IInteger numerator() {
        return this;
    }

    public final int hashCode() {
        return this.fIntValue;
    }

    @Override
    public ISignedNumber im() {
        return F.C0;
    }

    @Override
    public long integerLength(IInteger radix) {
        long length = 0L;
        IInteger ai = this;
        while (!ai.isZero()) {
            ai = ai.div(radix);
            ++length;
        }
        return length;
    }

    @Override
    public CharSequence internalJavaString(IExpr.SourceCodeProperties properties, int depth, Function<ISymbol, ? extends CharSequence> variables) {
        String prefix = AbstractAST.getPrefixF(properties);
        StringBuilder javaForm = new StringBuilder(prefix);
        int value = NumberUtil.toInt(this.fIntValue);
        switch (value) {
            case -1: {
                return javaForm.append("CN1");
            }
            case -2: {
                return javaForm.append("CN2");
            }
            case -3: {
                return javaForm.append("CN3");
            }
            case -4: {
                return javaForm.append("CN4");
            }
            case -5: {
                return javaForm.append("CN5");
            }
            case -6: {
                return javaForm.append("CN6");
            }
            case -7: {
                return javaForm.append("CN7");
            }
            case -8: {
                return javaForm.append("CN8");
            }
            case -9: {
                return javaForm.append("CN9");
            }
            case -10: {
                return javaForm.append("CN10");
            }
            case 0: {
                return javaForm.append("C0");
            }
            case 1: {
                return javaForm.append("C1");
            }
            case 2: {
                return javaForm.append("C2");
            }
            case 3: {
                return javaForm.append("C3");
            }
            case 4: {
                return javaForm.append("C4");
            }
            case 5: {
                return javaForm.append("C5");
            }
            case 6: {
                return javaForm.append("C6");
            }
            case 7: {
                return javaForm.append("C7");
            }
            case 8: {
                return javaForm.append("C8");
            }
            case 9: {
                return javaForm.append("C9");
            }
            case 10: {
                return javaForm.append("C10");
            }
        }
        return javaForm.append("ZZ(").append(value).append("L)");
    }

    @Override
    public CharSequence internalScalaString(boolean symbolsAsFactoryMethod, int depth) {
        IExpr.SourceCodeProperties p = AbstractAST.scalaFormProperties(symbolsAsFactoryMethod);
        return this.internalJavaString(p, depth, x -> null);
    }

    @Override
    public byte byteValue() {
        return (byte)this.fIntValue;
    }

    @Override
    public int intValue() {
        return this.fIntValue;
    }

    @Override
    public IRational inverse() {
        if (this.isOne() || this.isMinusOne()) {
            return this;
        }
        if (this.fIntValue < 0) {
            return AbstractFractionSym.valueOf(-1L, -this.fIntValue);
        }
        return AbstractFractionSym.valueOf(1L, this.fIntValue);
    }

    @Override
    public boolean isEven() {
        return (this.fIntValue & 1) == 0;
    }

    @Override
    public boolean isGT(ISignedNumber obj) {
        if (obj instanceof IntegerSym) {
            return this.fIntValue > ((IntegerSym)obj).fIntValue;
        }
        if (obj instanceof BigIntegerSym) {
            return this.toBigNumerator().compareTo(((BigIntegerSym)obj).toBigNumerator()) > 0;
        }
        if (obj instanceof AbstractFractionSym) {
            return -((AbstractFractionSym)obj).compareTo(AbstractFractionSym.valueOf(this.fIntValue)) > 0;
        }
        return this.doubleValue() > obj.doubleValue();
    }

    public boolean isLargerThan(BigInteger that) {
        return this.toBigNumerator().compareTo(that) > 0;
    }

    @Override
    public boolean isLT(ISignedNumber obj) {
        if (obj instanceof IntegerSym) {
            return this.fIntValue < ((IntegerSym)obj).fIntValue;
        }
        if (obj instanceof BigIntegerSym) {
            return this.toBigNumerator().compareTo(((BigIntegerSym)obj).toBigNumerator()) < 0;
        }
        if (obj instanceof AbstractFractionSym) {
            return -((AbstractFractionSym)obj).compareTo(AbstractFractionSym.valueOf(this.fIntValue)) < 0;
        }
        return this.doubleValue() < obj.doubleValue();
    }

    @Override
    public boolean isMinusOne() {
        return this.fIntValue == -1;
    }

    @Override
    public boolean isNegative() {
        return this.fIntValue < 0;
    }

    @Override
    public boolean isOdd() {
        return (this.fIntValue & 1) == 1;
    }

    @Override
    public boolean isOne() {
        return this.fIntValue == 1;
    }

    @Override
    public boolean isPositive() {
        return this.fIntValue > 0;
    }

    @Override
    public boolean isProbablePrime() {
        if (this.fIntValue < 0) {
            return this.negate().isProbablePrime();
        }
        return LongMath.isPrime((long)this.fIntValue);
    }

    @Override
    public boolean isProbablePrime(int certainty) {
        return LongMath.isPrime((long)this.fIntValue);
    }

    @Override
    public boolean isRationalValue(IRational value) {
        return this.equals(value);
    }

    @Override
    public boolean isZero() {
        return this.fIntValue == 0;
    }

    @Override
    public IInteger lcm(IInteger that) {
        if (that instanceof IntegerSym) {
            try {
                return IntegerSym.valueOf(ArithmeticUtils.lcm((int)this.fIntValue, (int)((IntegerSym)that).fIntValue));
            }
            catch (MathRuntimeException mathRuntimeException) {
                // empty catch block
            }
        }
        return super.lcm(that);
    }

    @Override
    public long longValue() {
        return this.fIntValue;
    }

    @Override
    public IInteger mod(IInteger that) {
        if (that instanceof IntegerSym) {
            return IntegerSym.valueOf(IntMath.mod((int)this.fIntValue, (int)((IntegerSym)that).fIntValue));
        }
        return IntegerSym.valueOf(this.toBigNumerator().mod(that.toBigNumerator()));
    }

    @Override
    public IInteger modInverse(IInteger that) {
        int a = this.fIntValue;
        if (a >= 0 && that instanceof IntegerSym) {
            int b = ((IntegerSym)that).fIntValue;
            if (b <= 0) {
                throw new ArithmeticException("integer: modulus not positive");
            }
            if (a == 0) {
                throw new ArithmeticException("integer argument not invertible.");
            }
            if (b == 1) {
                return F.C0;
            }
            int modVal = a;
            if (modVal == 1) {
                return F.C1;
            }
            int b0 = b;
            int x0 = 0;
            int x1 = 1;
            while (modVal > 1) {
                if (b == 0) {
                    throw new ArithmeticException("integer argument not invertible.");
                }
                int q = modVal / b;
                int t = b;
                b = modVal % b;
                modVal = t;
                t = x0;
                x0 = x1 - q * x0;
                x1 = t;
            }
            if (x1 > 0) {
                return AbstractIntegerSym.valueOf(x1);
            }
            return AbstractIntegerSym.valueOf(x1 + b0);
        }
        return IntegerSym.valueOf(this.toBigNumerator().modInverse(that.toBigNumerator()));
    }

    @Override
    public IInteger modPow(IInteger exp, IInteger m) {
        if (m.isZero()) {
            throw new ArithmeticException("the argument " + m.toString() + " should be nonzero.");
        }
        return IntegerSym.valueOf(this.toBigNumerator().modPow(exp.toBigNumerator(), m.toBigNumerator()));
    }

    @Override
    public IInteger multiply(IInteger that) {
        switch (this.fIntValue) {
            case 0: {
                return F.C0;
            }
            case 1: {
                return that;
            }
            case -1: {
                return that.negate();
            }
        }
        if (that instanceof BigIntegerSym) {
            return ((BigIntegerSym)that).multiply(this);
        }
        IntegerSym is = (IntegerSym)that;
        if (is.fIntValue == 1) {
            return this;
        }
        return IntegerSym.valueOf((long)this.fIntValue * (long)is.fIntValue);
    }

    @Override
    public IInteger multiply(int value) {
        switch (this.fIntValue) {
            case 0: {
                return F.C0;
            }
            case 1: {
                return IntegerSym.valueOf(value);
            }
            case -1: {
                return IntegerSym.valueOf(value).negate();
            }
        }
        if (value == 0) {
            return F.C0;
        }
        if (value == 1) {
            return this;
        }
        return IntegerSym.valueOf((long)this.fIntValue * (long)value);
    }

    @Override
    public IRational multiply(IRational parm1) {
        if (parm1.isZero()) {
            return F.C0;
        }
        if (parm1.isOne()) {
            return this;
        }
        if (parm1.isMinusOne()) {
            return this.negate();
        }
        if (parm1 instanceof AbstractFractionSym) {
            return ((AbstractFractionSym)parm1).multiply(this);
        }
        if (parm1 instanceof IntegerSym) {
            IntegerSym is = (IntegerSym)parm1;
            long newnum = (long)this.fIntValue * (long)is.fIntValue;
            return IntegerSym.valueOf(newnum);
        }
        BigIntegerSym p1 = (BigIntegerSym)parm1;
        BigInteger newnum = this.toBigNumerator().multiply(p1.toBigNumerator());
        return IntegerSym.valueOf(newnum);
    }

    @Override
    public IInteger negate() {
        if (this.fIntValue == Integer.MIN_VALUE) {
            return IntegerSym.valueOf(-1L * (long)this.fIntValue);
        }
        return IntegerSym.valueOf(-this.fIntValue);
    }

    @Override
    public IRational normalize() {
        return this;
    }

    @Override
    public IExpr nthRoot(int n) throws ArithmeticException {
        IntegerSym result;
        if (n < 0) {
            throw new IllegalArgumentException("nthRoot(" + n + ") n must be >= 0");
        }
        if (n == 2) {
            return this.sqrt();
        }
        if (this.complexSign() == 0) {
            return F.C0;
        }
        if (this.complexSign() < 0) {
            if (n % 2 == 0) {
                throw new ArithmeticException();
            }
            return this.negate().nthRoot(n).negate();
        }
        IInteger temp = this;
        do {
            result = temp;
        } while ((temp = this.divideAndRemainder(temp.powerRational((long)n - 1L))[0].add(temp.multiply(AbstractIntegerSym.valueOf(n - 1))).divideAndRemainder(AbstractIntegerSym.valueOf(n))[0]).compareTo(result) < 0);
        return result;
    }

    @Override
    public IInteger[] nthRootSplit(int n) throws ArithmeticException {
        IInteger[] result = new IInteger[2];
        if (this.complexSign() == 0) {
            result[0] = F.C0;
            result[1] = F.C1;
            return result;
        }
        if (this.complexSign() < 0) {
            if (n % 2 == 0) {
                throw new ArithmeticException();
            }
            result = this.negate().nthRootSplit(n);
            result[1] = result[1].negate();
            return result;
        }
        long b = this.fIntValue;
        long[] nthRoot = Primality.countRoot1021(b, n);
        result[0] = AbstractIntegerSym.valueOf(nthRoot[0]);
        result[1] = AbstractIntegerSym.valueOf(nthRoot[1]);
        return result;
    }

    @Override
    public final INumber numericNumber() {
        return F.num(this);
    }

    @Override
    public Num numValue() {
        return Num.valueOf(this.doubleValue());
    }

    @Override
    public IInteger quotient(IInteger that) {
        if (that instanceof BigIntegerSym) {
            return super.quotient(that);
        }
        int thatValue = ((IntegerSym)that).fIntValue;
        long quotient = this.fIntValue / thatValue;
        long mod = this.fIntValue % thatValue;
        if (mod == 0L) {
            return IntegerSym.valueOf(quotient);
        }
        if (quotient < 0L) {
            return IntegerSym.valueOf(quotient - 1L);
        }
        return IntegerSym.valueOf(quotient);
    }

    @Override
    public ISignedNumber re() {
        return this;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        byte attributeFlags = objectInput.readByte();
        switch (attributeFlags) {
            case 1: {
                byte value = objectInput.readByte();
                this.fIntValue = value;
                return;
            }
            case 2: {
                short value = objectInput.readShort();
                this.fIntValue = value;
                return;
            }
            case 4: {
                int value;
                this.fIntValue = value = objectInput.readInt();
                return;
            }
        }
    }

    @Override
    public IExpr remainder(IExpr that) {
        if (that instanceof IntegerSym) {
            return IntegerSym.valueOf(this.toBigNumerator().remainder(((IntegerSym)that).toBigNumerator()));
        }
        if (that instanceof BigIntegerSym) {
            return IntegerSym.valueOf(this.toBigNumerator().remainder(((BigIntegerSym)that).fBigIntValue));
        }
        return this;
    }

    public IInteger remainder(IInteger that) {
        return IntegerSym.valueOf(this.toBigNumerator().remainder(that.toBigNumerator()));
    }

    @Override
    public IInteger roundExpr() {
        return this;
    }

    @Override
    public IInteger shiftLeft(int n) {
        if (n == 0) {
            return this;
        }
        if (n <= 31) {
            return IntegerSym.valueOf(this.fIntValue << n);
        }
        return IntegerSym.valueOf(this.toBigNumerator().shiftLeft(n));
    }

    @Override
    public IInteger shiftRight(int n) {
        if (n == 0) {
            return this;
        }
        return IntegerSym.valueOf(this.fIntValue >> n);
    }

    @Override
    public int complexSign() {
        return this.fIntValue > 0 ? 1 : (this.fIntValue == 0 ? 0 : -1);
    }

    @Override
    public IExpr sqrt() {
        if (this.fIntValue >= 0) {
            try {
                return IntegerSym.valueOf(IntMath.sqrt((int)this.fIntValue, (RoundingMode)RoundingMode.UNNECESSARY));
            }
            catch (ArithmeticException | IllegalArgumentException runtimeException) {
                // empty catch block
            }
        }
        return F.Sqrt(this);
    }

    @Override
    public IInteger subtract(IInteger that) {
        return this.add(that.negate());
    }

    @Override
    public IRational subtract(IRational parm1) {
        if (parm1.isZero()) {
            return this;
        }
        if (parm1 instanceof AbstractFractionSym) {
            return ((AbstractFractionSym)parm1).negate().add(this);
        }
        if (parm1 instanceof IntegerSym) {
            IntegerSym is = (IntegerSym)parm1;
            long newnum = (long)this.fIntValue - (long)is.fIntValue;
            return IntegerSym.valueOf(newnum);
        }
        BigIntegerSym p1 = (BigIntegerSym)parm1;
        BigInteger newnum = this.toBigNumerator().subtract(p1.toBigNumerator());
        return IntegerSym.valueOf(newnum);
    }

    @Override
    public BigInteger toBigDenominator() {
        return BigInteger.ONE;
    }

    @Override
    public BigInteger toBigNumerator() {
        return BigInteger.valueOf(this.fIntValue);
    }

    @Override
    public int toInt() throws ArithmeticException {
        return this.fIntValue;
    }

    @Override
    public int toIntDefault(int defaultValue) {
        return this.fIntValue;
    }

    @Override
    public long toLongDefault(long defaultValue) {
        return this.fIntValue;
    }

    @Override
    public long toLong() throws ArithmeticException {
        return this.fIntValue;
    }

    public String toString() {
        return Integer.toString(this.fIntValue);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.fIntValue <= 127 && this.fIntValue >= -128) {
            objectOutput.writeByte(1);
            objectOutput.writeByte((byte)this.fIntValue);
            return;
        }
        if (this.fIntValue <= Short.MAX_VALUE && this.fIntValue >= Short.MIN_VALUE) {
            objectOutput.writeByte(2);
            objectOutput.writeShort((short)this.fIntValue);
            return;
        }
        objectOutput.writeByte(4);
        objectOutput.writeInt(this.fIntValue);
    }

    private Object writeReplace() {
        return this.optional();
    }

    static {
        int j = -128;
        for (int k = 0; k < CACHE.length; ++k) {
            IntegerSym.CACHE[k] = new IntegerSym(j++);
        }
    }
}

