/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ASTElementLimitExceeded;
import org.matheclipse.core.expression.AbstractAST;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.ObjIntPredicate;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public abstract class HMArrayList
extends AbstractAST
implements IASTAppendable,
Serializable,
RandomAccess {
    private static final long serialVersionUID = 8683452581122892189L;
    private static final Logger LOGGER = LogManager.getLogger();
    protected transient IExpr[] array;
    transient int firstIndex;
    protected transient int lastIndex;

    HMArrayList() {
        this(10);
    }

    HMArrayList(Collection<? extends IExpr> collection) {
        this.hashValue = 0;
        this.firstIndex = 0;
        Object[] objects = collection.toArray();
        int size = objects.length;
        this.array = HMArrayList.newElementArray(size + size / 10);
        System.arraycopy(objects, 0, this.array, 0, size);
        this.lastIndex = size;
    }

    HMArrayList(IExpr headExpr, IExpr ... arguments) {
        this.hashValue = 0;
        this.firstIndex = 0;
        this.lastIndex = arguments.length + 1;
        switch (this.lastIndex) {
            case 0: {
                this.array = new IExpr[]{headExpr};
                break;
            }
            case 1: {
                this.array = new IExpr[]{headExpr};
                break;
            }
            case 2: {
                this.array = new IExpr[]{headExpr, arguments[0]};
                break;
            }
            case 3: {
                this.array = new IExpr[]{headExpr, arguments[0], arguments[1]};
                break;
            }
            case 4: {
                this.array = new IExpr[]{headExpr, arguments[0], arguments[1], arguments[2]};
                break;
            }
            case 5: {
                this.array = new IExpr[]{headExpr, arguments[0], arguments[1], arguments[2], arguments[3]};
                break;
            }
            case 6: {
                this.array = new IExpr[]{headExpr, arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]};
                break;
            }
            case 7: {
                this.array = new IExpr[]{headExpr, arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]};
                break;
            }
            case 8: {
                this.array = new IExpr[]{headExpr, arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6]};
                break;
            }
            case 9: {
                this.array = new IExpr[]{headExpr, arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7]};
                break;
            }
            default: {
                this.array = HMArrayList.newElementArray(this.lastIndex);
                this.array[0] = headExpr;
                System.arraycopy(arguments, 0, this.array, 1, this.lastIndex - 1);
            }
        }
    }

    protected HMArrayList(IExpr[] array) {
        this.array = array;
        this.hashValue = 0;
        this.firstIndex = 0;
        this.lastIndex = array.length;
    }

    public HMArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.hashValue = 0;
        this.lastIndex = 0;
        this.firstIndex = 0;
        if (capacity > 0) {
            this.array = HMArrayList.newElementArray(capacity);
        }
    }

    @Override
    public boolean append(IExpr object) {
        this.hashValue = 0;
        if (this.lastIndex == this.array.length) {
            this.growAtEnd(1);
        }
        this.array[this.lastIndex++] = object;
        return true;
    }

    @Override
    public final void append(int location, IExpr object) {
        this.hashValue = 0;
        int size = this.lastIndex - this.firstIndex;
        if (0 < location && location < size) {
            if (this.firstIndex == 0 && this.lastIndex == this.array.length) {
                this.growForInsert(location, 1);
            } else if (location < size / 2 && this.firstIndex > 0 || this.lastIndex == this.array.length) {
                System.arraycopy(this.array, this.firstIndex, this.array, --this.firstIndex, location);
            } else {
                int index = location + this.firstIndex;
                System.arraycopy(this.array, index, this.array, index + 1, size - location);
                ++this.lastIndex;
            }
            this.array[location + this.firstIndex] = object;
        } else if (location == 0) {
            if (this.firstIndex == 0) {
                this.growAtFront(1);
            }
            this.array[--this.firstIndex] = object;
        } else if (location == size) {
            if (this.lastIndex == this.array.length) {
                this.growAtEnd(1);
            }
            this.array[this.lastIndex++] = object;
        } else {
            throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(location) + ", Size: " + Integer.valueOf(this.lastIndex - this.firstIndex));
        }
    }

    @Override
    public boolean appendAll(Collection<? extends IExpr> collection) {
        this.hashValue = 0;
        Object[] dumpArray = collection.toArray();
        if (dumpArray.length == 0) {
            return false;
        }
        if (dumpArray.length > this.array.length - this.lastIndex) {
            this.growAtEnd(dumpArray.length);
        }
        System.arraycopy(dumpArray, 0, this.array, this.lastIndex, dumpArray.length);
        this.lastIndex += dumpArray.length;
        return true;
    }

    @Override
    public boolean appendAll(Map<? extends IExpr, ? extends IExpr> map) {
        for (Map.Entry<? extends IExpr, ? extends IExpr> entry : map.entrySet()) {
            this.append(F.Rule(entry.getKey(), entry.getValue()));
        }
        return true;
    }

    @Override
    public boolean appendAll(IAST ast, int startPosition, int endPosition) {
        if (ast.size() > 0 && startPosition < endPosition) {
            this.hashValue = 0;
            int length = endPosition - startPosition;
            if (length > this.array.length - this.lastIndex) {
                this.growAtEnd(length);
            }
            for (int i = startPosition; i < endPosition; ++i) {
                this.array[this.lastIndex++] = ast.get(i);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean appendAll(int location, Collection<? extends IExpr> collection) {
        this.hashValue = 0;
        int size = this.lastIndex - this.firstIndex;
        if (location < 0 || location > size) {
            throw new IndexOutOfBoundsException("Index: " + location + ", Size: " + Integer.valueOf(this.lastIndex - this.firstIndex));
        }
        Object[] dumparray = collection.toArray();
        int growSize = dumparray.length;
        if (growSize == 0) {
            return false;
        }
        if (0 < location && location < size) {
            if (this.array.length - size < growSize) {
                this.growForInsert(location, growSize);
            } else if (location < size / 2 && this.firstIndex > 0 || this.lastIndex > this.array.length - growSize) {
                int newFirst = this.firstIndex - growSize;
                if (newFirst < 0) {
                    int index = location + this.firstIndex;
                    System.arraycopy(this.array, index, this.array, index - newFirst, size - location);
                    this.lastIndex -= newFirst;
                    newFirst = 0;
                }
                System.arraycopy(this.array, this.firstIndex, this.array, newFirst, location);
                this.firstIndex = newFirst;
            } else {
                int index = location + this.firstIndex;
                System.arraycopy(this.array, index, this.array, index + growSize, size - location);
                this.lastIndex += growSize;
            }
        } else if (location == 0) {
            this.growAtFront(growSize);
            this.firstIndex -= growSize;
        } else if (location == size) {
            if (this.lastIndex > this.array.length - growSize) {
                this.growAtEnd(growSize);
            }
            this.lastIndex += growSize;
        }
        System.arraycopy(dumparray, 0, this.array, location + this.firstIndex, growSize);
        return true;
    }

    @Override
    public boolean appendAll(List<? extends IExpr> list, int startPosition, int endPosition) {
        if (list.size() > 0 && startPosition < endPosition) {
            this.hashValue = 0;
            int length = endPosition - startPosition;
            if (length > this.array.length - this.lastIndex) {
                this.growAtEnd(length);
            }
            for (int i = startPosition; i < endPosition; ++i) {
                this.array[this.lastIndex++] = list.get(i);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean appendAll(IExpr[] args, int startPosition, int endPosition) {
        if (args.length > 0 && startPosition < endPosition) {
            this.hashValue = 0;
            int length = endPosition - startPosition;
            if (length > this.array.length - this.lastIndex) {
                this.growAtEnd(length);
            }
            for (int i = startPosition; i < endPosition; ++i) {
                this.array[this.lastIndex++] = args[i];
            }
            return true;
        }
        return false;
    }

    @Override
    public void forEach(int startOffset, int endOffset, Consumer<? super IExpr> action) {
        int index = this.firstIndex + startOffset;
        if (index < this.lastIndex) {
            for (int i = startOffset; i < endOffset; ++i) {
                action.accept(this.array[index++]);
            }
        }
    }

    @Override
    public void forEach(int startOffset, int endOffset, ObjIntConsumer<? super IExpr> action) {
        int index = this.firstIndex + startOffset;
        if (index < this.lastIndex) {
            for (int i = startOffset; i < endOffset; ++i) {
                action.accept(this.array[index++], i);
            }
        }
    }

    @Override
    public final boolean appendArgs(IAST ast) {
        return this.appendArgs(ast, ast.size());
    }

    @Override
    public final boolean appendArgs(IAST ast, int untilPosition) {
        if (untilPosition > 1) {
            this.hashValue = 0;
            int length = untilPosition - 1;
            if (length > this.array.length - this.lastIndex) {
                this.growAtEnd(length);
            }
            for (int i = 1; i < untilPosition; ++i) {
                this.array[this.lastIndex++] = ast.get(i);
            }
            return true;
        }
        return false;
    }

    @Override
    public IASTAppendable appendArgs(int start, int end, IntFunction<IExpr> function) {
        IExpr temp;
        if (start >= end) {
            return this;
        }
        this.hashValue = 0;
        int length = end - start;
        if (length > this.array.length - this.lastIndex) {
            this.growAtEnd(length);
        }
        for (int i = start; i < end && (temp = function.apply(i)).isPresent(); ++i) {
            this.array[this.lastIndex++] = temp;
        }
        return this;
    }

    @Override
    public IASTAppendable appendArgs(int end, IntFunction<IExpr> function) {
        return this.appendArgs(1, end, function);
    }

    @Override
    public IExpr arg1() {
        return this.array[this.firstIndex + 1];
    }

    @Override
    public IExpr arg2() {
        return this.array[this.firstIndex + 2];
    }

    @Override
    public IExpr arg3() {
        return this.array[this.firstIndex + 3];
    }

    @Override
    public IExpr arg4() {
        return this.array[this.firstIndex + 4];
    }

    @Override
    public IExpr arg5() {
        return this.array[this.firstIndex + 5];
    }

    @Override
    public final int argSize() {
        return this.lastIndex - this.firstIndex - 1;
    }

    @Override
    public Set<IExpr> asSet() {
        int size = this.size();
        HashSet<IExpr> set = new HashSet<IExpr>(size > 16 ? size : 16);
        for (int i = 1; i < size; ++i) {
            set.add(this.array[this.firstIndex + i]);
        }
        return set;
    }

    @Override
    public void clear() {
        if (this.firstIndex != this.lastIndex) {
            Arrays.fill(this.array, this.firstIndex, this.lastIndex, null);
            this.lastIndex = 0;
            this.firstIndex = 0;
        }
        this.hashValue = 0;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (this.array.length < minimumCapacity) {
            if (this.firstIndex > 0) {
                this.growAtFront(minimumCapacity - this.array.length);
            } else {
                this.growAtEnd(minimumCapacity - this.array.length);
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractAST) {
            int size = this.lastIndex - this.firstIndex;
            AbstractAST ast = (AbstractAST)obj;
            if (size != ast.size()) {
                return false;
            }
            IExpr head = this.array[this.firstIndex];
            if (head instanceof ISymbol ? head != ast.head() : !head.equals(ast.head())) {
                return false;
            }
            if (this.hashCode() != ((Object)ast).hashCode()) {
                return false;
            }
            return this.forAll((? super IExpr x, int i) -> x.equals(ast.getRule(i)), 1);
        }
        return false;
    }

    @Override
    public boolean exists(Predicate<? super IExpr> predicate, int startOffset) {
        int i = this.firstIndex + startOffset;
        while (i < this.lastIndex) {
            if (!predicate.test(this.array[i++])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean existsLeft(BiPredicate<IExpr, IExpr> stopPredicate) {
        for (int i = this.firstIndex + 2; i < this.lastIndex; ++i) {
            if (!stopPredicate.test(this.array[i - 1], this.array[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean exists(ObjIntPredicate<? super IExpr> predicate, int startOffset) {
        int i = this.firstIndex + startOffset;
        int j = startOffset;
        while (i < this.lastIndex) {
            if (!predicate.test(this.array[i++], j++)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final IAST filter(IASTAppendable filterAST, IASTAppendable restAST, Predicate<? super IExpr> predicate) {
        for (int i = this.firstIndex + 1; i < this.lastIndex; ++i) {
            IExpr temp = this.array[i];
            if (predicate.test(temp)) {
                filterAST.append(temp);
                continue;
            }
            restAST.append(temp);
        }
        return filterAST;
    }

    @Override
    public final IAST filterFunction(IASTAppendable filterAST, IASTAppendable restAST, Function<IExpr, IExpr> function) {
        for (int i = this.firstIndex + 1; i < this.lastIndex; ++i) {
            IExpr temp = this.array[i];
            IExpr expr = function.apply(temp);
            if (expr.isPresent()) {
                filterAST.append(expr);
                continue;
            }
            restAST.append(temp);
        }
        return filterAST;
    }

    @Override
    public boolean forAll(Predicate<? super IExpr> predicate, int startOffset) {
        int i = this.firstIndex + startOffset;
        while (i < this.lastIndex) {
            if (predicate.test(this.array[i++])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forAll(ObjIntPredicate<? super IExpr> predicate, int startOffset) {
        int i = this.firstIndex + startOffset;
        int j = startOffset;
        while (i < this.lastIndex) {
            if (predicate.test(this.array[i++], j++)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void forEach(Consumer<? super IExpr> action, int startOffset) {
        int i = this.firstIndex + startOffset;
        while (i < this.lastIndex) {
            action.accept(this.array[i++]);
        }
    }

    @Override
    public int indexOf(IExpr expr) {
        int index = 1;
        int i = this.firstIndex + 1;
        while (i < this.lastIndex) {
            if (this.array[i++].equals(expr)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public int indexOf(Predicate<? super IExpr> predicate, int fromIndex) {
        int index = fromIndex;
        int i = this.firstIndex + index;
        while (i < this.lastIndex) {
            if (predicate.test(this.array[i++])) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public final IExpr findFirst(Function<IExpr, IExpr> function) {
        int i = this.firstIndex + 1;
        while (i < this.lastIndex) {
            IExpr temp;
            if (!(temp = function.apply(this.array[i++])).isPresent()) continue;
            return temp;
        }
        return F.NIL;
    }

    @Override
    public IExpr get(int location) {
        if (LOGGER.isDebugEnabled()) {
            int index = this.firstIndex + location;
            if (index < this.lastIndex) {
                return this.array[index];
            }
            throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(location) + ", Size: " + Integer.valueOf(this.lastIndex - this.firstIndex));
        }
        return this.array[this.firstIndex + location];
    }

    private void growAtEnd(int required) {
        int size = this.lastIndex - this.firstIndex;
        if (this.firstIndex >= required - (this.array.length - this.lastIndex)) {
            int newLast = this.lastIndex - this.firstIndex;
            if (size > 0) {
                System.arraycopy(this.array, this.firstIndex, this.array, 0, size);
                int start = newLast < this.firstIndex ? this.firstIndex : newLast;
                Arrays.fill(this.array, start, this.array.length, null);
            }
            this.firstIndex = 0;
            this.lastIndex = newLast;
        } else {
            int increment = size / 2;
            if (required > increment) {
                increment = required;
            }
            if (increment < 12) {
                increment = 12;
            }
            IExpr[] newArray = HMArrayList.newElementArray(size + increment);
            if (size > 0) {
                System.arraycopy(this.array, this.firstIndex, newArray, 0, size);
                this.firstIndex = 0;
                this.lastIndex = size;
            }
            this.array = newArray;
        }
    }

    private void growAtFront(int required) {
        int size = this.lastIndex - this.firstIndex;
        if (this.array.length - this.lastIndex + this.firstIndex >= required) {
            int newFirst = this.array.length - size;
            if (size > 0) {
                System.arraycopy(this.array, this.firstIndex, this.array, newFirst, size);
                int length = this.firstIndex + size > newFirst ? newFirst : this.firstIndex + size;
                Arrays.fill(this.array, this.firstIndex, length, null);
            }
            this.firstIndex = newFirst;
            this.lastIndex = this.array.length;
        } else {
            int increment = size / 2;
            if (required > increment) {
                increment = required;
            }
            if (increment < 12) {
                increment = 12;
            }
            IExpr[] newArray = HMArrayList.newElementArray(size + increment);
            if (size > 0) {
                System.arraycopy(this.array, this.firstIndex, newArray, newArray.length - size, size);
            }
            this.firstIndex = newArray.length - size;
            this.lastIndex = newArray.length;
            this.array = newArray;
        }
    }

    private void growForInsert(int location, int required) {
        int size = this.lastIndex - this.firstIndex;
        int increment = size / 2;
        if (required > increment) {
            increment = required;
        }
        if (increment < 12) {
            increment = 12;
        }
        IExpr[] newArray = HMArrayList.newElementArray(size + increment);
        int newFirst = increment - required;
        System.arraycopy(this.array, location + this.firstIndex, newArray, newFirst + location + required, size - location);
        System.arraycopy(this.array, this.firstIndex, newArray, newFirst, location);
        this.firstIndex = newFirst;
        this.lastIndex = size + increment;
        this.array = newArray;
    }

    @Override
    public int hashCode() {
        if (this.hashValue == 0) {
            this.hashValue = -2128831035;
            for (int i = this.firstIndex; i < this.lastIndex; ++i) {
                this.hashValue = this.hashValue * 16777619 ^ this.array[i].hashCode() & 0xFF;
            }
        }
        return this.hashValue;
    }

    @Override
    public final IExpr head() {
        return this.array[this.firstIndex];
    }

    protected final void init(IExpr[] array) {
        this.array = array;
        this.hashValue = 0;
        this.firstIndex = 0;
        this.lastIndex = array.length;
    }

    @Override
    public IAST mapReverse(Function<IExpr, IExpr> function) {
        IExpr temp;
        IASTMutable result = F.NIL;
        int i = this.firstIndex + 1;
        int j = this.lastIndex - 1;
        while (i < this.lastIndex) {
            if ((temp = function.apply(this.array[i++])).isPresent()) {
                result = this.copy();
                result.set(j--, temp);
                break;
            }
            --j;
        }
        if (result.isPresent()) {
            while (i < this.lastIndex) {
                if ((temp = function.apply(this.array[i++])).isPresent()) {
                    result.set(j, temp);
                }
                --j;
            }
            return result;
        }
        return this;
    }

    @Override
    public final IAST map(IASTMutable clonedResultAST, Function<IExpr, IExpr> function) {
        int j = 1;
        for (int i = this.firstIndex + 1; i < this.lastIndex; ++i) {
            IExpr temp = function.apply(this.array[i]);
            if (temp != null) {
                clonedResultAST.set(j, temp);
            }
            ++j;
        }
        return clonedResultAST;
    }

    @Override
    public final IASTAppendable mapThreadEvaled(EvalEngine engine, IASTAppendable appendAST, IAST replacement, int position) {
        Function<IExpr, IExpr> function = x -> {
            IASTMutable a = replacement.setAtCopy(position, (IExpr)x);
            return engine.evaluate(a);
        };
        for (int i = this.firstIndex + 1; i < this.lastIndex; ++i) {
            IExpr temp = function.apply(this.array[i]);
            if (temp == null) continue;
            appendAST.append(temp);
        }
        return appendAST;
    }

    private static IExpr[] newElementArray(int size) {
        if (Config.MAX_AST_SIZE < size) {
            throw new ASTElementLimitExceeded(size);
        }
        return new IExpr[size];
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.lastIndex = fields.get("size", 0);
        this.array = HMArrayList.newElementArray(this.lastIndex);
        for (int i = 0; i < this.lastIndex; ++i) {
            this.array[i] = (IExpr)stream.readObject();
        }
    }

    @Override
    public IExpr remove(int location) {
        IExpr result;
        this.hashValue = 0;
        int size = this.lastIndex - this.firstIndex;
        if (0 <= location && location < size) {
            if (location == size - 1) {
                result = this.array[--this.lastIndex];
                this.array[this.lastIndex] = null;
            } else if (location == 0) {
                result = this.array[this.firstIndex];
                this.array[this.firstIndex++] = null;
            } else {
                int elementIndex = this.firstIndex + location;
                result = this.array[elementIndex];
                if (location < size / 2) {
                    System.arraycopy(this.array, this.firstIndex, this.array, this.firstIndex + 1, location);
                    this.array[this.firstIndex++] = null;
                } else {
                    System.arraycopy(this.array, elementIndex + 1, this.array, elementIndex, size - location - 1);
                    this.array[--this.lastIndex] = null;
                }
            }
            if (this.firstIndex == this.lastIndex) {
                this.lastIndex = 0;
                this.firstIndex = 0;
            }
        } else {
            throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(location) + ", Size: " + Integer.valueOf(this.lastIndex - this.firstIndex));
        }
        return result;
    }

    @Override
    public void removeRange(int start, int end) {
        this.hashValue = 0;
        if (start >= 0 && start <= end && end <= this.lastIndex - this.firstIndex) {
            if (start == end) {
                return;
            }
            int size = this.lastIndex - this.firstIndex;
            if (end == size) {
                Arrays.fill(this.array, this.firstIndex + start, this.lastIndex, null);
                this.lastIndex = this.firstIndex + start;
            } else if (start == 0) {
                Arrays.fill(this.array, this.firstIndex, this.firstIndex + end, null);
                this.firstIndex += end;
            } else {
                System.arraycopy(this.array, this.firstIndex + end, this.array, this.firstIndex + start, size - end);
                int newLast = this.lastIndex + start - end;
                Arrays.fill(this.array, newLast, this.lastIndex, null);
                this.lastIndex = newLast;
            }
        } else {
            throw new IndexOutOfBoundsException("Index: " + (this.lastIndex - this.firstIndex - end));
        }
    }

    @Override
    public IExpr set(int location, IExpr object) {
        this.hashValue = 0;
        IExpr result = this.array[this.firstIndex + location];
        this.array[this.firstIndex + location] = object;
        return result;
    }

    @Override
    public final int size() {
        return this.lastIndex - this.firstIndex;
    }

    @Override
    public Stream<IExpr> stream() {
        return Arrays.stream(this.array, this.firstIndex + 1, this.lastIndex - this.firstIndex);
    }

    @Override
    public Stream<IExpr> stream(int startInclusive, int endExclusive) {
        return Arrays.stream(this.toArray(), this.firstIndex + startInclusive, this.firstIndex + endExclusive);
    }

    @Override
    public IExpr[] toArray() {
        int size = this.lastIndex - this.firstIndex;
        IExpr[] result = new IExpr[size];
        System.arraycopy(this.array, this.firstIndex, result, 0, size);
        return result;
    }

    public void trimToSize() {
        int size = this.lastIndex - this.firstIndex;
        IExpr[] newArray = HMArrayList.newElementArray(size);
        System.arraycopy(this.array, this.firstIndex, newArray, 0, size);
        this.array = newArray;
        this.firstIndex = 0;
        this.lastIndex = this.array.length;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        int size = this.lastIndex - this.firstIndex;
        fields.put("size", size);
        stream.writeFields();
        for (int i = 0; i < size; ++i) {
            stream.writeObject(this.get(i));
        }
    }
}

