/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.math.BigInteger;
import java.util.function.Function;
import org.hipparchus.fraction.BigFraction;
import org.hipparchus.util.ArithmeticUtils;
import org.matheclipse.core.expression.AbstractAST;
import org.matheclipse.core.expression.AbstractFractionSym;
import org.matheclipse.core.expression.AbstractIntegerSym;
import org.matheclipse.core.expression.BigFractionSym;
import org.matheclipse.core.expression.BigIntegerSym;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IntegerSym;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.ParserConfig;

public class FractionSym
extends AbstractFractionSym {
    private static final long serialVersionUID = 1225728601457694359L;
    public static final FractionSym ZERO = new FractionSym(0, 1);
    public static final FractionSym ONE = new FractionSym(1, 1);
    public static final FractionSym MONE = new FractionSym(-1, 1);
    public static final FractionSym TWO = new FractionSym(2, 1);
    int fNumerator;
    int fDenominator;

    private static boolean isOne(long num, long den) {
        return num == den && num != 0L;
    }

    FractionSym(int nom, int denom) {
        this.fNumerator = nom;
        this.fDenominator = denom;
    }

    @Override
    public IFraction abs() {
        return FractionSym.valueOf(Math.abs((long)this.fNumerator), this.fDenominator);
    }

    @Override
    public IFraction add(IFraction other) {
        if (this.isZero()) {
            return other;
        }
        if (other instanceof BigFractionSym) {
            return ((BigFractionSym)other).add(this);
        }
        FractionSym fs = (FractionSym)other;
        if (fs.fNumerator == 0) {
            return this;
        }
        if (this.fDenominator == fs.fDenominator) {
            return FractionSym.valueOf((long)this.fNumerator + (long)fs.fNumerator, this.fDenominator);
        }
        int gcd = ArithmeticUtils.gcd((int)this.fDenominator, (int)fs.fDenominator);
        if (gcd == 1) {
            long denomgcd = this.fDenominator;
            long otherdenomgcd = fs.fDenominator;
            long newdenom = denomgcd * otherdenomgcd;
            long newnum = otherdenomgcd * (long)this.fNumerator + (long)this.fDenominator * (long)fs.fNumerator;
            return FractionSym.valueOf(newnum, newdenom);
        }
        long denomgcd = (long)this.fDenominator / (long)gcd;
        long otherdenomgcd = (long)fs.fDenominator / (long)gcd;
        long newdenom = denomgcd * (long)fs.fDenominator;
        long newnum = otherdenomgcd * (long)this.fNumerator + denomgcd * (long)fs.fNumerator;
        return FractionSym.valueOf(newnum, newdenom);
    }

    @Override
    public IRational add(IRational parm1) {
        if (parm1.isZero()) {
            return this;
        }
        if (parm1 instanceof IFraction) {
            return this.add((IFraction)parm1);
        }
        if (parm1 instanceof IntegerSym) {
            IntegerSym is = (IntegerSym)parm1;
            long newnum = (long)this.fNumerator + (long)this.fDenominator * (long)is.fIntValue;
            return FractionSym.valueOf(newnum, this.fDenominator);
        }
        BigInteger newnum = this.toBigNumerator().add(this.toBigDenominator().multiply(parm1.toBigNumerator()));
        return FractionSym.valueOf(newnum, this.toBigDenominator());
    }

    @Override
    public IInteger ceil() {
        if (this.fDenominator == 1) {
            return AbstractIntegerSym.valueOf(this.fNumerator);
        }
        int div = this.fNumerator / this.fDenominator;
        if (this.fNumerator > 0) {
            ++div;
        }
        return AbstractIntegerSym.valueOf(div);
    }

    @Override
    public IInteger ceilFraction() {
        if (this.fDenominator == 1) {
            return F.ZZ(this.fNumerator);
        }
        int div = this.fNumerator / this.fDenominator;
        if (this.fNumerator > 0) {
            ++div;
        }
        return F.ZZ(div);
    }

    @Override
    public int compareAbsValueToOne() {
        long num = this.fNumerator;
        if (this.fNumerator < 0) {
            num *= -1L;
        }
        if (FractionSym.isOne(num, this.fDenominator)) {
            return 0;
        }
        return num > (long)this.fDenominator ? 1 : -1;
    }

    @Override
    public int compareInt(int value) {
        long valo = (long)this.fDenominator * (long)value;
        return (long)this.fNumerator < valo ? -1 : ((long)this.fNumerator == valo ? 0 : 1);
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof FractionSym) {
            FractionSym temp = (FractionSym)expr;
            int numerator = temp.fNumerator;
            if (temp.fDenominator == this.fDenominator) {
                return this.fNumerator < numerator ? -1 : (this.fNumerator == numerator ? 0 : 1);
            }
            long valt = (long)this.fNumerator * (long)temp.fDenominator;
            long valo = (long)this.fDenominator * (long)numerator;
            return valt < valo ? -1 : (valt == valo ? 0 : 1);
        }
        if (expr instanceof IRational) {
            if (expr instanceof IntegerSym) {
                return this.compareInt(((IntegerSym)expr).fIntValue);
            }
            if (expr instanceof BigIntegerSym) {
                return new BigFractionSym(((AbstractIntegerSym)expr).toBigNumerator().negate(), BigInteger.ONE).compareTo(this);
            }
            if (expr instanceof BigFractionSym) {
                return -expr.compareTo(this);
            }
        } else if (expr.isReal()) {
            return Double.compare(this.doubleValue(), ((ISignedNumber)expr).doubleValue());
        }
        return -1;
    }

    @Override
    public ComplexNum complexNumValue() {
        double nr = this.fNumerator;
        double dr = this.fDenominator;
        return ComplexNum.valueOf(nr / dr);
    }

    @Override
    public IRational dec() {
        return this.add(F.CN1);
    }

    @Override
    public IRational inc() {
        return this.add(F.C1);
    }

    @Override
    public IFraction div(IFraction other) {
        if (other instanceof BigFractionSym) {
            return ((BigFractionSym)other).idiv(this);
        }
        FractionSym fs = (FractionSym)other;
        if (fs.fDenominator == 1) {
            if (fs.fNumerator == 1) {
                return this;
            }
            if (fs.fNumerator == -1) {
                return this.negate();
            }
        }
        long newnum = (long)this.fNumerator * (long)fs.fDenominator;
        long newdenom = (long)this.fDenominator * (long)fs.fNumerator;
        if (newdenom == 0L && fs.fNumerator < 0) {
            newnum = -newnum;
        }
        return FractionSym.valueOf(newnum, newdenom);
    }

    @Override
    public IInteger[] divideAndRemainder() {
        IInteger[] result = new IInteger[]{AbstractIntegerSym.valueOf(this.fNumerator / this.fDenominator), AbstractIntegerSym.valueOf(this.fNumerator % this.fDenominator)};
        return result;
    }

    @Override
    public double doubleValue() {
        return (double)this.fNumerator / (double)this.fDenominator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IFraction) {
            return ((IFraction)o).equalsFraction(this.fNumerator, this.fDenominator);
        }
        return false;
    }

    @Override
    public final boolean equalsFraction(int numerator, int denominator) {
        return this.fNumerator == numerator && this.fDenominator == denominator;
    }

    @Override
    public boolean equalsInt(int value) {
        return this.fNumerator == value && this.fDenominator == 1;
    }

    @Override
    public IInteger floor() {
        if (this.fDenominator == 1) {
            return AbstractIntegerSym.valueOf(this.fNumerator);
        }
        int div = this.fNumerator / this.fDenominator;
        if (this.fNumerator < 0) {
            --div;
        }
        return AbstractIntegerSym.valueOf(div);
    }

    @Override
    public IInteger floorFraction() {
        if (this.fDenominator == 1) {
            return F.ZZ(this.fNumerator);
        }
        int div = this.fNumerator / this.fDenominator;
        if (this.fNumerator < 0) {
            --div;
        }
        return F.ZZ(div);
    }

    @Override
    public IFraction fractionalPart() {
        if (this.fDenominator == 1) {
            return ZERO;
        }
        return FractionSym.valueOf(this.fNumerator % this.fDenominator, this.fDenominator);
    }

    @Override
    public String fullFormString() {
        StringBuilder buf = new StringBuilder("Rational");
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
            buf.append('(');
        } else {
            buf.append('[');
        }
        buf.append(Integer.toString(this.fNumerator));
        buf.append(',');
        buf.append(Integer.toString(this.fDenominator));
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
            buf.append(')');
        } else {
            buf.append(']');
        }
        return buf.toString();
    }

    @Override
    public IExpr gcd(IExpr that) {
        if (that instanceof FractionSym) {
            return this.gcd((FractionSym)that);
        }
        return super.gcd(that);
    }

    @Override
    public IFraction gcd(IFraction other) {
        if (this.isZero()) {
            return other;
        }
        if (other.isZero()) {
            return this;
        }
        if (other instanceof BigFractionSym) {
            return ((BigFractionSym)other).gcd(this);
        }
        FractionSym fs = (FractionSym)other;
        int gcddenom = ArithmeticUtils.gcd((int)this.fDenominator, (int)fs.fDenominator);
        long denom = (long)(this.fDenominator / gcddenom) * (long)fs.fDenominator;
        long num = ArithmeticUtils.gcd((int)(this.fNumerator < 0 ? -this.fNumerator : this.fNumerator), (int)(fs.fNumerator < 0 ? -fs.fNumerator : fs.fNumerator));
        return FractionSym.valueOf(num, denom);
    }

    @Override
    public BigInteger toBigDenominator() {
        return BigInteger.valueOf(this.fDenominator);
    }

    @Override
    public BigInteger toBigNumerator() {
        return BigInteger.valueOf(this.fNumerator);
    }

    @Override
    public BigFraction toBigFraction() {
        return new BigFraction(this.fNumerator, this.fDenominator);
    }

    public int hashCode() {
        return 37 * (629 + this.fNumerator) + this.fDenominator;
    }

    @Override
    public CharSequence internalFormString(boolean symbolsAsFactoryMethod, int depth) {
        IExpr.SourceCodeProperties p = AbstractAST.stringFormProperties(symbolsAsFactoryMethod);
        return this.internalJavaString(p, depth, x -> null);
    }

    @Override
    public CharSequence internalJavaString(IExpr.SourceCodeProperties properties, int depth, Function<ISymbol, ? extends CharSequence> variables) {
        String prefix = AbstractAST.getPrefixF(properties);
        StringBuilder javaForm = new StringBuilder(prefix);
        if (this.fNumerator == 1) {
            switch (this.fDenominator) {
                case 2: {
                    return javaForm.append("C1D2");
                }
                case 3: {
                    return javaForm.append("C1D3");
                }
                case 4: {
                    return javaForm.append("C1D4");
                }
            }
        }
        if (this.fNumerator == -1) {
            switch (this.fDenominator) {
                case 2: {
                    return javaForm.append("CN1D2");
                }
                case 3: {
                    return javaForm.append("CN1D3");
                }
                case 4: {
                    return javaForm.append("CN1D4");
                }
            }
        }
        return javaForm.append("QQ(").append(this.fNumerator).append("L,").append(this.fDenominator).append("L)");
    }

    @Override
    public CharSequence internalScalaString(boolean symbolsAsFactoryMethod, int depth) {
        IExpr.SourceCodeProperties p = AbstractAST.scalaFormProperties(symbolsAsFactoryMethod);
        return this.internalJavaString(p, depth, x -> null);
    }

    @Override
    public IFraction inverse() {
        return FractionSym.valueOf(this.fDenominator, this.fNumerator);
    }

    public boolean isDefined() {
        return this.fDenominator != 0;
    }

    @Override
    public boolean isIntegral() {
        return this.fDenominator == 1;
    }

    @Override
    public boolean isMinusOne() {
        return this.fNumerator == -1 * this.fDenominator && this.fNumerator != 0;
    }

    @Override
    public boolean isNegative() {
        return this.fNumerator < 0;
    }

    @Override
    public boolean isOne() {
        return this.fNumerator == this.fDenominator && this.fNumerator != 0;
    }

    @Override
    public boolean isPositive() {
        return this.fNumerator > 0;
    }

    @Override
    public boolean isZero() {
        return this.fNumerator == 0;
    }

    public IFraction mul(BigInteger other) {
        if (other.bitLength() <= 31) {
            int oint = other.intValue();
            if (oint == 1) {
                return this;
            }
            if (oint == -1) {
                return this.negate();
            }
            long newnum = (long)this.fNumerator * (long)oint;
            return FractionSym.valueOf(newnum, this.fDenominator);
        }
        if (this.isOne()) {
            return FractionSym.valueOf(other, BigInteger.ONE);
        }
        if (this.isMinusOne()) {
            return FractionSym.valueOf(other.negate(), BigInteger.ONE);
        }
        return FractionSym.valueOf(this.toBigNumerator().multiply(other), this.toBigDenominator());
    }

    @Override
    public IFraction mul(IFraction other) {
        if (other.isOne()) {
            return this;
        }
        if (this.isOne()) {
            return other;
        }
        if (other.isMinusOne()) {
            return this.negate();
        }
        if (this.isMinusOne()) {
            return other.negate();
        }
        if (other instanceof BigFractionSym) {
            return other.mul(this);
        }
        FractionSym fs = (FractionSym)other;
        long newnum = (long)this.fNumerator * (long)fs.fNumerator;
        long newdenom = (long)this.fDenominator * (long)fs.fDenominator;
        return FractionSym.valueOf(newnum, newdenom);
    }

    @Override
    public IRational multiply(IRational parm1) {
        if (this.isZero() || parm1.isZero()) {
            return F.C0;
        }
        if (parm1.isOne()) {
            return this;
        }
        if (parm1.isMinusOne()) {
            return this.negate();
        }
        if (parm1 instanceof IFraction) {
            return this.mul((IFraction)parm1);
        }
        if (parm1 instanceof IntegerSym) {
            IntegerSym is = (IntegerSym)parm1;
            long newnum = (long)this.fNumerator * (long)is.fIntValue;
            return FractionSym.valueOf(newnum, this.fDenominator);
        }
        BigIntegerSym p1 = (BigIntegerSym)parm1;
        BigInteger newnum = this.toBigNumerator().multiply(p1.toBigNumerator());
        return FractionSym.valueOf(newnum, this.toBigDenominator());
    }

    @Override
    public IRational multiply(int n) {
        if (this.isZero() || n == 0) {
            return F.C0;
        }
        if (n == 1) {
            return this;
        }
        if (n == -1) {
            return this.negate();
        }
        long newnum = (long)this.fNumerator * (long)n;
        return FractionSym.valueOf(newnum, this.fDenominator);
    }

    @Override
    public IFraction negate() {
        return AbstractFractionSym.valueOf(-((long)this.fNumerator), this.fDenominator);
    }

    @Override
    public IRational normalize() {
        if (this.fDenominator == 1) {
            return F.ZZ(this.fNumerator);
        }
        if (this.isZero()) {
            return F.C0;
        }
        return this;
    }

    @Override
    public IInteger roundExpr() {
        BigFraction temp = new BigFraction(this.fNumerator, this.fDenominator);
        return AbstractIntegerSym.valueOf(NumberUtil.round(temp, 6));
    }

    @Override
    public int complexSign() {
        return this.fNumerator < 0 ? -1 : (this.fNumerator == 0 ? 0 : 1);
    }

    @Override
    public int toInt() throws ArithmeticException {
        if (this.fDenominator == 1) {
            return this.fNumerator;
        }
        if (this.fNumerator == 0) {
            return 0;
        }
        throw new ArithmeticException("toInt: denominator != 1");
    }

    @Override
    public int toIntDefault(int defaultValue) {
        if (this.fDenominator == 1) {
            return this.fNumerator;
        }
        if (this.fNumerator == 0) {
            return 0;
        }
        return defaultValue;
    }

    @Override
    public long toLongDefault(long defaultValue) {
        if (this.fDenominator == 1) {
            return this.fNumerator;
        }
        if (this.fNumerator == 0) {
            return 0L;
        }
        return defaultValue;
    }

    @Override
    public long toLong() throws ArithmeticException {
        if (this.fDenominator == 1) {
            return this.fNumerator;
        }
        if (this.fNumerator == 0) {
            return 0L;
        }
        throw new ArithmeticException("toLong: denominator != 1");
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            OutputFormFactory.get().convertFraction(sb, this.toBigNumerator(), this.toBigDenominator(), Integer.MIN_VALUE, false);
            return sb.toString();
        }
        catch (Exception e1) {
            return this.toBigNumerator().toString() + "/" + this.toBigDenominator().toString();
        }
    }

    private Object writeReplace() {
        return this.optional();
    }
}

