/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import edu.jas.kern.ComputerThreads;
import edu.jas.kern.PreemptStatus;
import java.awt.Desktop;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatContext;
import org.hipparchus.Field;
import org.hipparchus.complex.Complex;
import org.hipparchus.fraction.BigFraction;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.Algebra;
import org.matheclipse.core.builtin.Arithmetic;
import org.matheclipse.core.builtin.AssociationFunctions;
import org.matheclipse.core.builtin.AssumptionFunctions;
import org.matheclipse.core.builtin.AttributeFunctions;
import org.matheclipse.core.builtin.BesselFunctions;
import org.matheclipse.core.builtin.BooleanFunctions;
import org.matheclipse.core.builtin.BoxesFunctions;
import org.matheclipse.core.builtin.ClusteringFunctions;
import org.matheclipse.core.builtin.Combinatoric;
import org.matheclipse.core.builtin.CompilerFunctions;
import org.matheclipse.core.builtin.ComputationalGeometryFunctions;
import org.matheclipse.core.builtin.ConstantDefinitions;
import org.matheclipse.core.builtin.ContainsFunctions;
import org.matheclipse.core.builtin.CurveFitterFunctions;
import org.matheclipse.core.builtin.EllipticIntegrals;
import org.matheclipse.core.builtin.EntityFunctions;
import org.matheclipse.core.builtin.ExpTrigsFunctions;
import org.matheclipse.core.builtin.FileFunctions;
import org.matheclipse.core.builtin.FinancialFunctions;
import org.matheclipse.core.builtin.FunctionDefinitions;
import org.matheclipse.core.builtin.GeodesyFunctions;
import org.matheclipse.core.builtin.GraphDataFunctions;
import org.matheclipse.core.builtin.GraphFunctions;
import org.matheclipse.core.builtin.GraphicsFunctions;
import org.matheclipse.core.builtin.HypergeometricFunctions;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.ImageFunctions;
import org.matheclipse.core.builtin.IntegerFunctions;
import org.matheclipse.core.builtin.IntervalFunctions;
import org.matheclipse.core.builtin.JavaFunctions;
import org.matheclipse.core.builtin.LinearAlgebra;
import org.matheclipse.core.builtin.ListFunctions;
import org.matheclipse.core.builtin.ManipulateFunction;
import org.matheclipse.core.builtin.MinMaxFunctions;
import org.matheclipse.core.builtin.NumberTheory;
import org.matheclipse.core.builtin.NumericArrayFunctions;
import org.matheclipse.core.builtin.OutputFunctions;
import org.matheclipse.core.builtin.PatternMatching;
import org.matheclipse.core.builtin.PolynomialFunctions;
import org.matheclipse.core.builtin.PredicateQ;
import org.matheclipse.core.builtin.Programming;
import org.matheclipse.core.builtin.QuantityFunctions;
import org.matheclipse.core.builtin.RandomFunctions;
import org.matheclipse.core.builtin.RootsFunctions;
import org.matheclipse.core.builtin.SeriesFunctions;
import org.matheclipse.core.builtin.SidesFunctions;
import org.matheclipse.core.builtin.SimplifyFunctions;
import org.matheclipse.core.builtin.SourceCodeFunctions;
import org.matheclipse.core.builtin.SparseArrayFunctions;
import org.matheclipse.core.builtin.SpecialFunctions;
import org.matheclipse.core.builtin.StatisticsFunctions;
import org.matheclipse.core.builtin.StringFunctions;
import org.matheclipse.core.builtin.StructureFunctions;
import org.matheclipse.core.builtin.TensorFunctions;
import org.matheclipse.core.builtin.UnitTestingFunctions;
import org.matheclipse.core.builtin.VectorAnalysisFunctions;
import org.matheclipse.core.builtin.WXFFunctions;
import org.matheclipse.core.builtin.WindowFunctions;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.convert.Object2Expr;
import org.matheclipse.core.eval.EvalAttributes;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ASTElementLimitExceeded;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.ICoreFunctionEvaluator;
import org.matheclipse.core.eval.util.Assumptions;
import org.matheclipse.core.eval.util.BiIntFunction;
import org.matheclipse.core.eval.util.IAssumptions;
import org.matheclipse.core.eval.util.Lambda;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.AST0;
import org.matheclipse.core.expression.AST1;
import org.matheclipse.core.expression.AST2;
import org.matheclipse.core.expression.AST3;
import org.matheclipse.core.expression.ASTAssociation;
import org.matheclipse.core.expression.ASTRRBTree;
import org.matheclipse.core.expression.AbstractAST;
import org.matheclipse.core.expression.AbstractFractionSym;
import org.matheclipse.core.expression.AbstractIntegerSym;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.B1;
import org.matheclipse.core.expression.B2;
import org.matheclipse.core.expression.B3;
import org.matheclipse.core.expression.Blank;
import org.matheclipse.core.expression.BuiltInDummy;
import org.matheclipse.core.expression.BuiltInRubi;
import org.matheclipse.core.expression.BuiltInSymbol;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.ComplexSym;
import org.matheclipse.core.expression.Context;
import org.matheclipse.core.expression.ContextPath;
import org.matheclipse.core.expression.ExprField;
import org.matheclipse.core.expression.ISymbolObserver;
import org.matheclipse.core.expression.IntegerSym;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.OptionsPattern;
import org.matheclipse.core.expression.Pattern;
import org.matheclipse.core.expression.PatternSequence;
import org.matheclipse.core.expression.RepeatedPattern;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.StringX;
import org.matheclipse.core.expression.Symbol;
import org.matheclipse.core.expression.data.GraphExpr;
import org.matheclipse.core.expression.data.SparseArrayExpr;
import org.matheclipse.core.form.Documentation;
import org.matheclipse.core.form.output.JSBuilder;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IPatternSequence;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISparseArray;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.parser.ExprParser;
import org.matheclipse.core.parser.ExprParserFactory;
import org.matheclipse.core.reflection.system.Integrate;
import org.matheclipse.core.tensor.QuantityParser;
import org.matheclipse.parser.client.ParserConfig;
import org.matheclipse.parser.trie.TrieMatch;

public class F
extends S {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Cache<IAST, IExpr> REMEMBER_INTEGER_CACHE = CacheBuilder.newBuilder().maximumSize(500L).build();
    private static volatile boolean isSystemStarted = false;
    private static volatile boolean systemInitialized = false;
    public static final Map<String, String> PREDEFINED_INTERNAL_FORM_STRINGS = ParserConfig.TRIE_STRING2STRING_BUILDER.withMatch(TrieMatch.EXACT).build();
    private static final Map<String, IPattern> PREDEFINED_PATTERN_MAP = Config.TRIE_STRING2PATTERN_BUILDER.withMatch(TrieMatch.EXACT).build();
    private static final Map<String, IPatternSequence> PREDEFINED_PATTERNSEQUENCE_MAP = Config.TRIE_STRING2PATTERNSEQUENCE_BUILDER.withMatch(TrieMatch.EXACT).build();
    public static final ISymbolObserver SYMBOL_OBSERVER = new ISymbolObserver(){

        @Override
        public final boolean createPredefinedSymbol(String symbol) {
            return false;
        }

        @Override
        public void createUserSymbol(ISymbol symbol) {
        }
    };
    public static final IAssociation NIL = AbstractAST.NIL;
    public static final IPattern a_ = F.initPredefinedPattern(a);
    public static final IPattern b_ = F.initPredefinedPattern(b);
    public static final IPattern c_ = F.initPredefinedPattern(c);
    public static final IPattern d_ = F.initPredefinedPattern(d);
    public static final IPattern e_ = F.initPredefinedPattern(e);
    public static final IPattern f_ = F.initPredefinedPattern(f);
    public static final IPattern g_ = F.initPredefinedPattern(g);
    public static final IPattern h_ = F.initPredefinedPattern(h);
    public static final IPattern i_ = F.initPredefinedPattern(i);
    public static final IPattern j_ = F.initPredefinedPattern(j);
    public static final IPattern k_ = F.initPredefinedPattern(k);
    public static final IPattern l_ = F.initPredefinedPattern(l);
    public static final IPattern m_ = F.initPredefinedPattern(m);
    public static final IPattern n_ = F.initPredefinedPattern(n);
    public static final IPattern o_ = F.initPredefinedPattern(o);
    public static final IPattern p_ = F.initPredefinedPattern(p);
    public static final IPattern q_ = F.initPredefinedPattern(q);
    public static final IPattern r_ = F.initPredefinedPattern(r);
    public static final IPattern s_ = F.initPredefinedPattern(s);
    public static final IPattern t_ = F.initPredefinedPattern(t);
    public static final IPattern u_ = F.initPredefinedPattern(u);
    public static final IPattern v_ = F.initPredefinedPattern(v);
    public static final IPattern w_ = F.initPredefinedPattern(w);
    public static final IPattern x_ = F.initPredefinedPattern(x);
    public static final IPattern y_ = F.initPredefinedPattern(y);
    public static final IPattern z_ = F.initPredefinedPattern(z);
    public static final IPatternSequence x__ = F.initPredefinedPatternSequence(x);
    public static final IPatternSequence y__ = F.initPredefinedPatternSequence(y);
    public static final IPatternSequence z__ = F.initPredefinedPatternSequence(z);
    public static final IPatternSequence x___ = F.initPredefinedPatternSequence(x, true);
    public static final IPatternSequence y___ = F.initPredefinedPatternSequence(y, true);
    public static final IPatternSequence z___ = F.initPredefinedPatternSequence(z, true);
    public static final IPattern A_ = F.initPredefinedPattern(ASymbol);
    public static final IPattern B_ = F.initPredefinedPattern(BSymbol);
    public static final IPattern C_ = F.initPredefinedPattern(CSymbol);
    public static final IPattern F_ = F.initPredefinedPattern(FSymbol);
    public static final IPattern G_ = F.initPredefinedPattern(GSymbol);
    public static final IPattern P_ = F.initPredefinedPattern(PSymbol);
    public static final IPattern Q_ = F.initPredefinedPattern(QSymbol);
    public static final IPattern m_Integer = new Pattern(m, Integer);
    public static final IPattern n_Integer = new Pattern(n, Integer);
    public static final IPattern a_Symbol = new Pattern(a, Symbol);
    public static final IPattern b_Symbol = new Pattern(b, Symbol);
    public static final IPattern c_Symbol = new Pattern(c, Symbol);
    public static final IPattern d_Symbol = new Pattern(d, Symbol);
    public static final IPattern e_Symbol = new Pattern(e, Symbol);
    public static final IPattern f_Symbol = new Pattern(f, Symbol);
    public static final IPattern g_Symbol = new Pattern(g, Symbol);
    public static final IPattern h_Symbol = new Pattern(h, Symbol);
    public static final IPattern i_Symbol = new Pattern(i, Symbol);
    public static final IPattern j_Symbol = new Pattern(j, Symbol);
    public static final IPattern k_Symbol = new Pattern(k, Symbol);
    public static final IPattern l_Symbol = new Pattern(l, Symbol);
    public static final IPattern m_Symbol = new Pattern(m, Symbol);
    public static final IPattern n_Symbol = new Pattern(n, Symbol);
    public static final IPattern o_Symbol = new Pattern(o, Symbol);
    public static final IPattern p_Symbol = new Pattern(p, Symbol);
    public static final IPattern q_Symbol = new Pattern(q, Symbol);
    public static final IPattern r_Symbol = new Pattern(r, Symbol);
    public static final IPattern s_Symbol = new Pattern(s, Symbol);
    public static final IPattern t_Symbol = new Pattern(t, Symbol);
    public static final IPattern u_Symbol = new Pattern(u, Symbol);
    public static final IPattern v_Symbol = new Pattern(v, Symbol);
    public static final IPattern w_Symbol = new Pattern(w, Symbol);
    public static final IPattern x_Symbol = new Pattern(x, Symbol);
    public static final IPattern y_Symbol = new Pattern(y, Symbol);
    public static final IPattern z_Symbol = new Pattern(z, Symbol);
    public static final IPattern a_DEFAULT = new Pattern(a, null, true);
    public static final IPattern b_DEFAULT = new Pattern(b, null, true);
    public static final IPattern c_DEFAULT = new Pattern(c, null, true);
    public static final IPattern d_DEFAULT = new Pattern(d, null, true);
    public static final IPattern e_DEFAULT = new Pattern(e, null, true);
    public static final IPattern f_DEFAULT = new Pattern(f, null, true);
    public static final IPattern g_DEFAULT = new Pattern(g, null, true);
    public static final IPattern h_DEFAULT = new Pattern(h, null, true);
    public static final IPattern i_DEFAULT = new Pattern(i, null, true);
    public static final IPattern j_DEFAULT = new Pattern(j, null, true);
    public static final IPattern k_DEFAULT = new Pattern(k, null, true);
    public static final IPattern l_DEFAULT = new Pattern(l, null, true);
    public static final IPattern m_DEFAULT = new Pattern(m, null, true);
    public static final IPattern n_DEFAULT = new Pattern(n, null, true);
    public static final IPattern o_DEFAULT = new Pattern(o, null, true);
    public static final IPattern p_DEFAULT = new Pattern(p, null, true);
    public static final IPattern q_DEFAULT = new Pattern(q, null, true);
    public static final IPattern r_DEFAULT = new Pattern(r, null, true);
    public static final IPattern s_DEFAULT = new Pattern(s, null, true);
    public static final IPattern t_DEFAULT = new Pattern(t, null, true);
    public static final IPattern u_DEFAULT = new Pattern(u, null, true);
    public static final IPattern v_DEFAULT = new Pattern(v, null, true);
    public static final IPattern w_DEFAULT = new Pattern(w, null, true);
    public static final IPattern x_DEFAULT = new Pattern(x, null, true);
    public static final IPattern y_DEFAULT = new Pattern(y, null, true);
    public static final IPattern z_DEFAULT = new Pattern(z, null, true);
    public static final IPattern A_DEFAULT = new Pattern(ASymbol, null, true);
    public static final IPattern B_DEFAULT = new Pattern(BSymbol, null, true);
    public static final IPattern C_DEFAULT = new Pattern(CSymbol, null, true);
    public static final IPattern F_DEFAULT = new Pattern(FSymbol, null, true);
    public static final IPattern G_DEFAULT = new Pattern(GSymbol, null, true);
    public static final IPattern P_DEFAULT = new Pattern(PSymbol, null, true);
    public static final IPattern Q_DEFAULT = new Pattern(QSymbol, null, true);
    public static final IInteger C0 = AbstractIntegerSym.valueOf(0);
    public static final IInteger C1 = AbstractIntegerSym.valueOf(1);
    public static final IInteger C2 = AbstractIntegerSym.valueOf(2);
    public static final IInteger C3 = AbstractIntegerSym.valueOf(3);
    public static final IInteger C4 = AbstractIntegerSym.valueOf(4);
    public static final IInteger C5 = AbstractIntegerSym.valueOf(5);
    public static final IInteger C6 = AbstractIntegerSym.valueOf(6);
    public static final IInteger C7 = AbstractIntegerSym.valueOf(7);
    public static final IInteger C8 = AbstractIntegerSym.valueOf(8);
    public static final IInteger C9 = AbstractIntegerSym.valueOf(9);
    public static final IInteger C10 = AbstractIntegerSym.valueOf(10);
    public static final IInteger C100 = AbstractIntegerSym.valueOf(100);
    public static final IInteger C1000 = new IntegerSym(1000);
    public static final IComplex CI = ComplexSym.valueOf(0L, 1L, 1L, 1L);
    public static final IComplex CNI = ComplexSym.valueOf(0L, 1L, -1L, 1L);
    public static final IFraction C1D2 = AbstractFractionSym.valueOf(1L, 2L);
    public static final IFraction C3D2 = AbstractFractionSym.valueOf(3L, 2L);
    public static final IFraction C3D4 = AbstractFractionSym.valueOf(3L, 4L);
    public static final IFraction C5D2 = AbstractFractionSym.valueOf(5L, 2L);
    public static final IFraction CN1D2 = AbstractFractionSym.valueOf(-1L, 2L);
    public static final IFraction CN3D2 = AbstractFractionSym.valueOf(-3L, 2L);
    public static final IFraction C1D3 = AbstractFractionSym.valueOf(1L, 3L);
    public static final IFraction CN1D3 = AbstractFractionSym.valueOf(-1L, 3L);
    public static final IFraction C1D4 = AbstractFractionSym.valueOf(1L, 4L);
    public static final IFraction CN1D4 = AbstractFractionSym.valueOf(-1L, 4L);
    public static final Num CND1 = new Num(-1.0);
    public static final Num CD0 = new Num(0.0);
    public static final Num CD1 = new Num(1.0);
    public static final IComplexNum CDI = ComplexNum.I;
    public static final IComplexNum CDNI = ComplexNum.NI;
    public static final IStringX CEmptyString;
    public static final IAST CEmptySequence;
    public static final IAST CEmptyList;
    public static final IAST CMissingNotFound;
    public static final IAST CListC0;
    public static final IAST CListC1;
    public static final IAST CListCN1;
    public static final IAST CListC1C1;
    public static final IAST CListC1C2;
    public static final IAST CListC2;
    public static final IAST CListC2C1;
    public static final IAST CListC2C2;
    public static final IAST CInfinity;
    public static final IAST CReturnFalse;
    public static final IAST CReturnTrue;
    public static final IAST CThrowFalse;
    public static final IAST CThrowTrue;
    public static final IAST oo;
    public static final IAST CNInfinity;
    public static final IAST Noo;
    public static final IAST CIInfinity;
    public static final IAST CNIInfinity;
    public static final IAST CComplexInfinity;
    public static final IAST CNPi;
    public static final IAST CN2Pi;
    public static final IAST C2Pi;
    public static final IAST CNPiHalf;
    public static final IAST CPiHalf;
    public static final IAST CSqrt2;
    public static final IAST CSqrt3;
    public static final IAST CSqrt5;
    public static final IAST CSqrt6;
    public static final IAST CSqrt7;
    public static final IAST CSqrt10;
    public static final IAST C1DSqrt2;
    public static final IAST C1DSqrt3;
    public static final IAST C1DSqrt5;
    public static final IAST C1DSqrt6;
    public static final IAST C1DSqrt7;
    public static final IAST C1DSqrt10;
    public static final IAST Slot1;
    public static final IAST Slot2;
    public static final IAST Slot3;
    public static final Field<IExpr> EXPR_FIELD;
    public static final IInteger CN1;
    public static final IInteger CN2;
    public static final IInteger CN3;
    public static final IInteger CN4;
    public static final IInteger CN5;
    public static final IInteger CN6;
    public static final IInteger CN7;
    public static final IInteger CN8;
    public static final IInteger CN9;
    public static final IInteger CN10;
    private static final Map<ISymbol, IExpr> UNARY_INVERSE_FUNCTIONS;
    public static final List<ISymbol> DENOMINATOR_NUMERATOR_SYMBOLS;
    public static final List<IExpr> DENOMINATOR_TRIG_TRUE_EXPRS;
    public static final List<ISymbol> NUMERATOR_NUMERATOR_SYMBOLS;
    public static final List<IExpr> NUMERATOR_TRIG_TRUE_EXPRS;
    private static final CountDownLatch COUNT_DOWN_LATCH;

    public static boolean isSystemInitialized() {
        return systemInitialized;
    }

    public static String getPredefinedInternalFormString(String key) {
        return PREDEFINED_INTERNAL_FORM_STRINGS.get(key);
    }

    public static IPattern getPredefinedPattern(String key) {
        return PREDEFINED_PATTERN_MAP.get(key);
    }

    public static IPatternSequence getPredefinedPatternSequence(String key) {
        return PREDEFINED_PATTERNSEQUENCE_MAP.get(key);
    }

    public static IExpr getUnaryInverseFunction(IExpr symbol) {
        return UNARY_INVERSE_FUNCTIONS.get(symbol);
    }

    public static final void await() throws InterruptedException {
        COUNT_DOWN_LATCH.await();
    }

    private static void createInverseFunctionMap() {
        UNARY_INVERSE_FUNCTIONS.put(Abs, F.Function(F.Times((IExpr)CN1, (IExpr)Slot1)));
        UNARY_INVERSE_FUNCTIONS.put(ProductLog, F.Function(F.Times((IExpr)Slot1, (IExpr)F.Power((IExpr)E, Slot1))));
        UNARY_INVERSE_FUNCTIONS.put(Cos, ArcCos);
        UNARY_INVERSE_FUNCTIONS.put(Cot, ArcCot);
        UNARY_INVERSE_FUNCTIONS.put(Csc, ArcCsc);
        UNARY_INVERSE_FUNCTIONS.put(Sec, ArcSec);
        UNARY_INVERSE_FUNCTIONS.put(Sin, ArcSin);
        UNARY_INVERSE_FUNCTIONS.put(Tan, ArcTan);
        UNARY_INVERSE_FUNCTIONS.put(ArcCos, Cos);
        UNARY_INVERSE_FUNCTIONS.put(ArcCot, Cot);
        UNARY_INVERSE_FUNCTIONS.put(ArcCsc, Csc);
        UNARY_INVERSE_FUNCTIONS.put(ArcSec, Sec);
        UNARY_INVERSE_FUNCTIONS.put(ArcSin, Sin);
        UNARY_INVERSE_FUNCTIONS.put(ArcTan, Tan);
        UNARY_INVERSE_FUNCTIONS.put(Cosh, ArcCosh);
        UNARY_INVERSE_FUNCTIONS.put(Coth, ArcCoth);
        UNARY_INVERSE_FUNCTIONS.put(Csch, ArcCsch);
        UNARY_INVERSE_FUNCTIONS.put(Sech, ArcSech);
        UNARY_INVERSE_FUNCTIONS.put(Sinh, ArcSinh);
        UNARY_INVERSE_FUNCTIONS.put(Tanh, ArcTanh);
        UNARY_INVERSE_FUNCTIONS.put(ArcCosh, Cosh);
        UNARY_INVERSE_FUNCTIONS.put(ArcCoth, Coth);
        UNARY_INVERSE_FUNCTIONS.put(ArcCsch, Csch);
        UNARY_INVERSE_FUNCTIONS.put(ArcSech, Sech);
        UNARY_INVERSE_FUNCTIONS.put(ArcSinh, Sinh);
        UNARY_INVERSE_FUNCTIONS.put(ArcTanh, Tanh);
        UNARY_INVERSE_FUNCTIONS.put(Log, Exp);
        UNARY_INVERSE_FUNCTIONS.put(Identity, Identity);
        UNARY_INVERSE_FUNCTIONS.put(Erf, InverseErf);
        UNARY_INVERSE_FUNCTIONS.put(Erfc, InverseErfc);
        UNARY_INVERSE_FUNCTIONS.put(Haversine, InverseHaversine);
        UNARY_INVERSE_FUNCTIONS.put(InverseHaversine, Haversine);
        UNARY_INVERSE_FUNCTIONS.put(Gudermannian, InverseGudermannian);
        UNARY_INVERSE_FUNCTIONS.put(InverseGudermannian, Gudermannian);
        UNARY_INVERSE_FUNCTIONS.put(InverseErf, Erf);
        UNARY_INVERSE_FUNCTIONS.put(InverseErfc, Erfc);
    }

    public static final IASTMutable $(IExpr head, IExpr ... a) {
        switch (a.length) {
            case 0: {
                return F.headAST0(head);
            }
            case 1: {
                return F.unaryAST1(head, a[0]);
            }
            case 2: {
                return F.binaryAST2(head, a[0], a[1]);
            }
            case 3: {
                return F.ternaryAST3(head, a[0], a[1], a[2]);
            }
        }
        return F.ast(a, head);
    }

    public static PatternSequence $bs(IExpr condition) {
        return PatternSequence.valueOf(null, condition, false);
    }

    public static PatternSequence $bns(IExpr condition) {
        return PatternSequence.valueOf(null, condition, false);
    }

    public static IPattern $b() {
        return org.matheclipse.core.expression.Blank.valueOf();
    }

    public static IPattern $b(IExpr condition) {
        return org.matheclipse.core.expression.Blank.valueOf(condition);
    }

    public static IPattern $b(IExpr condition, boolean def) {
        return new Blank(condition, def);
    }

    public static IPattern $p(ISymbol symbol) {
        return org.matheclipse.core.expression.Pattern.valueOf(symbol);
    }

    public static IPattern $p(ISymbol symbol, boolean matchDefaultValue) {
        return F.$p(symbol, null, matchDefaultValue);
    }

    public static IPattern $p(ISymbol symbol, IExpr headerCheck) {
        return org.matheclipse.core.expression.Pattern.valueOf(symbol, headerCheck);
    }

    public static IPattern $p(ISymbol symbol, IExpr headerCheck, boolean matchDefaultValue) {
        return org.matheclipse.core.expression.Pattern.valueOf(symbol, headerCheck, matchDefaultValue);
    }

    public static IPattern $p(String symbolName) {
        return org.matheclipse.core.expression.Pattern.valueOf(F.$s(symbolName));
    }

    public static IPattern $p(String symbolName, boolean def) {
        return F.$p(F.$s(symbolName), null, def);
    }

    public static IPattern $p(String symbolName, IExpr check) {
        return org.matheclipse.core.expression.Pattern.valueOf(F.$s(symbolName), check);
    }

    public static IPattern $p(String symbolName, IExpr check, boolean def) {
        return org.matheclipse.core.expression.Pattern.valueOf(F.$s(symbolName), check, def);
    }

    public static IPattern pattern(ISymbol symbol) {
        return org.matheclipse.core.expression.Pattern.valueOf(symbol);
    }

    public static IPattern pattern(ISymbol symbol, IExpr check, boolean def) {
        return org.matheclipse.core.expression.Pattern.valueOf(symbol, check, def);
    }

    public static IPatternSequence $ps(ISymbol symbol) {
        return PatternSequence.valueOf(symbol, false);
    }

    public static IPatternSequence $ps(ISymbol symbol, boolean zeroArgsAllowed) {
        return PatternSequence.valueOf(symbol, zeroArgsAllowed);
    }

    public static IPatternSequence $ps(ISymbol symbol, IExpr check) {
        return PatternSequence.valueOf(symbol, check, false);
    }

    public static IPatternSequence $ps(ISymbol symbol, IExpr check, boolean def, boolean zeroArgsAllowed) {
        return PatternSequence.valueOf(symbol, check, def, zeroArgsAllowed);
    }

    public static IPatternSequence $OptionsPattern() {
        return org.matheclipse.core.expression.OptionsPattern.valueOf(null);
    }

    public static IPatternSequence $OptionsPattern(ISymbol symbol) {
        return org.matheclipse.core.expression.OptionsPattern.valueOf(symbol);
    }

    public static IPatternSequence $OptionsPattern(ISymbol symbol, IExpr defaultOptions) {
        return org.matheclipse.core.expression.OptionsPattern.valueOf(symbol, defaultOptions);
    }

    public static IPatternSequence $Repeated(IExpr patternExpr, int min, int max, EvalEngine engine) {
        boolean nullAllowed = min <= 0;
        return RepeatedPattern.valueOf(patternExpr, min, max, nullAllowed, engine);
    }

    public static IPatternSequence $ps(String symbolName) {
        return PatternSequence.valueOf(F.$s(symbolName), false);
    }

    public static IAST SymbolQ(IExpr x) {
        return new AST1(SymbolQ, x);
    }

    public static IAST Symmetric(IExpr a0) {
        return new AST1(Symmetric, a0);
    }

    public static IAST SymmetricMatrixQ(IExpr a0) {
        return new AST1(SymmetricMatrixQ, a0);
    }

    public static IExpr symjify(Object object) {
        return F.symjify(object, true);
    }

    public static IExpr symjify(Object object, boolean evaluate) {
        IExpr temp = Object2Expr.convert(object, true, false);
        return evaluate ? F.eval(temp) : temp;
    }

    public static IExpr symjify(String str) {
        return F.symjify(str, true);
    }

    public static IExpr symjify(String str, boolean evaluate) {
        EvalEngine engine = EvalEngine.get();
        ExprParser parser = new ExprParser(engine);
        IExpr temp = parser.parse(str);
        return evaluate ? engine.evaluate(temp) : temp;
    }

    public static IInteger symjify(long value) {
        return F.ZZ(value);
    }

    public static INum symjify(double value) {
        return F.num(value);
    }

    public static IBuiltInSymbol symjify(boolean value) {
        return value ? True : False;
    }

    public static ISymbol $s(String symbolName) {
        ISymbol symbol;
        String name = symbolName;
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS && symbolName.length() != 1) {
            name = symbolName.toLowerCase(Locale.ENGLISH);
        }
        if ((symbol = org.matheclipse.core.expression.Context.PREDEFINED_SYMBOLS_MAP.get(name)) != null) {
            return symbol;
        }
        symbol = (ISymbol)HIDDEN_SYMBOLS_MAP.get(name);
        if (symbol != null) {
            return symbol;
        }
        if (Config.SERVER_MODE) {
            ISymbol secondTry;
            if ((ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS || java.lang.Character.isUpperCase(name.charAt(0))) && SYMBOL_OBSERVER.createPredefinedSymbol(name) && (secondTry = org.matheclipse.core.expression.Context.PREDEFINED_SYMBOLS_MAP.get(name)) != null) {
                return secondTry;
            }
            symbol = F.symbol(name, EvalEngine.get());
            HIDDEN_SYMBOLS_MAP.put(name, symbol);
            if (name.charAt(0) == '$') {
                SYMBOL_OBSERVER.createUserSymbol(symbol);
            }
        } else {
            symbol = new BuiltInDummy(name);
            HIDDEN_SYMBOLS_MAP.put(name, symbol);
        }
        return symbol;
    }

    public static ISymbol $rubi(String symbolName) {
        return F.$rubi(symbolName, BuiltInSymbol.DUMMY_EVALUATOR);
    }

    public static ISymbol $rubi(String symbolName, IEvaluator evaluator) {
        String name = F.symbolNameNormalized(symbolName);
        ISymbol symbol = org.matheclipse.core.expression.Context.RUBI.get(name);
        if (symbol != null) {
            return symbol;
        }
        BuiltInRubi bSymbol = new BuiltInRubi(name);
        bSymbol.setEvaluator(evaluator);
        org.matheclipse.core.expression.Context.RUBI.put(name, bSymbol);
        return bSymbol;
    }

    public static String symbolNameNormalized(String symbolName) {
        return ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS ? (symbolName.length() == 1 ? symbolName : symbolName.toLowerCase(Locale.ENGLISH)) : symbolName;
    }

    public static final IStringX $str(char ch) {
        return StringX.valueOf(ch);
    }

    public static final IStringX $str(String str) {
        return StringX.valueOf(str);
    }

    public static final IStringX $str(String str, short mimeType) {
        return StringX.valueOf(str, mimeType);
    }

    public static IAST Abs(IExpr z) {
        return new AST1(Abs, z);
    }

    public static IAST AbsoluteCorrelation(IExpr a0, IExpr a1) {
        return new AST2(AbsoluteCorrelation, a0, a1);
    }

    public static IASTMutable AddSides(IExpr equationOrInequality, IExpr a1) {
        return new AST2(AddSides, equationOrInequality, a1);
    }

    public static IAST Alternatives(IExpr ... a) {
        return F.function(Alternatives, a);
    }

    public static IExpr and(IExpr a, Integer i) {
        return F.And(a, (IExpr)F.ZZ(i.longValue()));
    }

    public static IExpr and(IExpr a, BigInteger i) {
        return F.And(a, (IExpr)F.ZZ(i));
    }

    public static IExpr and(Integer i, IExpr b) {
        return F.And((IExpr)F.ZZ(i.longValue()), b);
    }

    public static IExpr and(BigInteger i, IExpr b) {
        return F.And((IExpr)F.ZZ(i), b);
    }

    public static IASTAppendable And() {
        return F.ast(And);
    }

    public static IASTMutable AmbientLight(IExpr color) {
        return new AST1(AmbientLight, color);
    }

    public static IAST And(IExpr ... expr) {
        return F.function(And, expr);
    }

    public static IAST And(IExpr expr1, IExpr expr2) {
        return new B2.And(expr1, expr2);
    }

    public static IAST And(IExpr expr1, IExpr expr2, IExpr expr3) {
        return new B3.And(expr1, expr2, expr3);
    }

    public static IAST AngleVector(IExpr a0) {
        return new AST1(AngleVector, a0);
    }

    public static IAST AntiSymmetric(IExpr a0) {
        return new AST1(AntiSymmetric, a0);
    }

    public static IAST Apart(IExpr a0) {
        return new AST1(Apart, a0);
    }

    public static IAST Apart(IExpr a0, IExpr a1) {
        return new AST2(Apart, a0, a1);
    }

    public static IAST AppellF1(IExpr a, IExpr b1, IExpr b2, IExpr c, IExpr z1, IExpr z2) {
        IExpr[] arr = new IExpr[]{a, b1, b2, c, z1, z2};
        return new AST(AppellF1, arr);
    }

    public static IAST Append(IExpr a0, IExpr a1) {
        return new AST2(Append, a0, a1);
    }

    public static IAST AppendTo(IExpr a0, IExpr a1) {
        return new AST2(AppendTo, a0, a1);
    }

    public static IASTMutable Apply(IExpr a0, IExpr a1) {
        return new AST2(Apply, a0, a1);
    }

    public static IASTMutable ApplySides(IExpr a0, IExpr equationOrInequality) {
        return new AST2(ApplySides, a0, equationOrInequality);
    }

    public static IASTMutable ApplyListC1(IExpr a0, IExpr a1) {
        return new AST3(Apply, a0, a1, CListC1);
    }

    public static IAST AiryAi(IExpr a0) {
        return new AST1(AiryAi, a0);
    }

    public static IAST AiryAiPrime(IExpr a0) {
        return new AST1(AiryAiPrime, a0);
    }

    public static IAST AiryBi(IExpr a0) {
        return new AST1(AiryBi, a0);
    }

    public static IAST AiryBiPrime(IExpr a0) {
        return new AST1(AiryBiPrime, a0);
    }

    public static IAST Array(IExpr a0, IExpr a1) {
        return new AST2(Array, a0, a1);
    }

    public static IAST Arrays(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(Arrays, a0, a1, a2);
    }

    public static IAST Arrays(IExpr a0, IExpr a1) {
        return new AST2(Arrays, a0, a1);
    }

    public static IAST Arrays(IExpr a0) {
        return new AST1(Arrays, a0);
    }

    public static IAST ArcCos(IExpr z) {
        return new AST1(ArcCos, z);
    }

    public static IAST ArcCosh(IExpr z) {
        return new AST1(ArcCosh, z);
    }

    public static IAST ArcCot(IExpr z) {
        return new AST1(ArcCot, z);
    }

    public static IAST ArcCoth(IExpr z) {
        return new AST1(ArcCoth, z);
    }

    public static IAST ArcCsc(IExpr z) {
        return new AST1(ArcCsc, z);
    }

    public static IAST ArcCsch(IExpr z) {
        return new AST1(ArcCsch, z);
    }

    public static IAST ArcSec(IExpr z) {
        return new AST1(ArcSec, z);
    }

    public static IAST ArcSech(IExpr z) {
        return new AST1(ArcSech, z);
    }

    public static IAST ArcSin(IExpr z) {
        return new AST1(ArcSin, z);
    }

    public static IAST ArcSinh(IExpr z) {
        return new AST1(ArcSinh, z);
    }

    public static IAST ArcTan(IExpr z) {
        return new AST1(ArcTan, z);
    }

    public static IAST ArcTan(IExpr x, IExpr y) {
        return new AST2(ArcTan, x, y);
    }

    public static IAST ArcTanh(IExpr z) {
        return new AST1(ArcTanh, z);
    }

    public static IAST Arg(IExpr z) {
        return new AST1(Arg, z);
    }

    public static IAST ArrayQ(IExpr a0) {
        return new AST1(ArrayQ, a0);
    }

    public static IAST Arrays(IAST dimension) {
        return F.Arrays(dimension, Complexes, F.List());
    }

    public static IAST Arrays(IAST dimension, ISymbol domain) {
        return F.Arrays(dimension, domain, F.List());
    }

    public static IAST Arrays(IAST dimension, ISymbol domain, IAST symmetry) {
        return new AST3(Arrays, dimension, domain, symmetry);
    }

    public static IAST ArithmeticGeometricMean(IExpr a0, IExpr a1) {
        return new AST2(ArithmeticGeometricMean, a0, a1);
    }

    public static IAssociation assoc(IAST listOfRules) {
        if (listOfRules.isAST1() && listOfRules.arg1().isListOfRules(true)) {
            return new ASTAssociation((IAST)listOfRules.arg1());
        }
        return new ASTAssociation(listOfRules);
    }

    public static IAssociation assoc() {
        return new ASTAssociation();
    }

    public static ISparseArray sparseArray(IAST arrayRulesList) {
        return SparseArrayExpr.newArrayRules(arrayRulesList, null, -1, C0);
    }

    public static ISparseArray sparseArray(IAST arrayRulesList, int[] dimension) {
        return SparseArrayExpr.newArrayRules(arrayRulesList, dimension, 0, C0);
    }

    public static ISparseArray sparseMatrix(BiIntFunction<? extends IExpr> binaryFunction, int n, int m) {
        if (n > Config.MAX_MATRIX_DIMENSION_SIZE || m > Config.MAX_MATRIX_DIMENSION_SIZE) {
            ASTElementLimitExceeded.throwIt((long)n * (long)m);
        }
        int[] dimension = new int[]{n, m};
        SparseArrayExpr sparseMatrix = SparseArrayExpr.newArrayRules(CEmptyList, dimension, 0, C0);
        for (int i = 0; i < n; ++i) {
            IASTAppendable row = F.ListAlloc(m);
            for (int j = 0; j < m; ++j) {
                IExpr value = binaryFunction.apply(i, j);
                if (value.isZero()) continue;
                sparseMatrix.set(new int[]{i + 1, j + 1}, value);
            }
        }
        return sparseMatrix;
    }

    public static IAST ast(IAST f, IExpr head, boolean include, int first, int last) {
        AST ast = null;
        if (include) {
            ast = AST.newInstance(last - first, head, false);
            ast.appendAll(f, first, last);
        } else {
            ast = AST.newInstance(f.size() - last + first - 1, head, false);
            ast.appendAll(f, 1, first);
            ast.appendAll(f, last, f.size());
        }
        return ast;
    }

    public static final IASTAppendable ast(IExpr head) {
        return AST.newInstance(head);
    }

    public static IASTAppendable ast(IExpr head, int initialCapacity) {
        if (initialCapacity > 32) {
            return ASTRRBTree.newInstance(initialCapacity, head);
        }
        return AST.newInstance(initialCapacity, head);
    }

    @Deprecated
    public static IASTAppendable ast(IExpr head, int initialCapacity, boolean initNull) {
        return AST.newInstance(initialCapacity, head, initNull);
    }

    public static IASTAppendable ast(IExpr head, Collection<? extends IExpr> collection) {
        return F.ast(head, collection, 0);
    }

    public static IASTAppendable ast(IExpr head, Collection<? extends IExpr> collection, int initialCapacity) {
        IASTAppendable result = F.ast(head, collection.size() + initialCapacity);
        result.appendAll(collection);
        return result;
    }

    public static IASTMutable astMutable(IExpr head, int initialCapacity) {
        return AST.newInstance(initialCapacity, head, true);
    }

    public static IASTAppendable constantArray(IExpr value, int copies) {
        return value.constantArray(List, 0, copies);
    }

    public static IASTAppendable constantArray(IExpr head, IExpr value, int copies) {
        return value.constantArray(head, 0, copies);
    }

    public static IASTAppendable ast(IExpr[] arr, IExpr head) {
        return new AST(head, arr);
    }

    public static IASTAppendable ast(ISymbol head, int[] arr) {
        return AST.newInstance(head, arr);
    }

    public static IASTAppendable ast(ISymbol head, Complex[] arr) {
        return AST.newInstance(head, false, arr);
    }

    public static IASTAppendable ast(ISymbol head, boolean evalComplex, Complex[] arr) {
        return AST.newInstance(head, evalComplex, arr);
    }

    public static IAST AtomQ(IExpr a) {
        return new AST1(AtomQ, a);
    }

    public static IAST Attributes(IExpr a) {
        return new AST1(Attributes, a);
    }

    public static IAST BaseForm(IExpr a0, IExpr a1) {
        return new AST2(BaseForm, a0, a1);
    }

    public static IAST BellB(IExpr a0) {
        return new AST1(BellB, a0);
    }

    public static IAST BellB(IExpr a0, IExpr a1) {
        return new AST2(BellB, a0, a1);
    }

    public static IAST BellY(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(BellY, a0, a1, a2);
    }

    public static IAST BernoulliB(IExpr a0) {
        return new AST1(BernoulliB, a0);
    }

    public static IAST BernoulliB(IExpr a0, IExpr a1) {
        return new AST2(BernoulliB, a0, a1);
    }

    public static IAST BernoulliDistribution(IExpr a0) {
        return new AST1(BernoulliDistribution, a0);
    }

    public static final IASTAppendable binary(IExpr head, IExpr arg1, IExpr arg2) {
        return new AST(new IExpr[]{head, arg1, arg2});
    }

    public static final IASTMutable binaryAST2(IExpr head, IExpr arg1, IExpr arg2) {
        return new AST2(head, arg1, arg2);
    }

    public static final IASTMutable binaryAST2(IExpr head, String arg1, IExpr arg2) {
        return new AST2(head, F.$str(arg1), arg2);
    }

    public static final IASTMutable binaryAST2(IExpr head, String arg1, String arg2) {
        return new AST2(head, F.$str(arg1), F.$str(arg2));
    }

    public static IAST Binomial(IExpr a0, IExpr a1) {
        return new AST2(Binomial, a0, a1);
    }

    public static IAST Binomial(int a0, int a1) {
        return new AST2(Binomial, F.ZZ(a0), F.ZZ(a1));
    }

    public static IAST BlankSequence() {
        return new AST0(BlankSequence);
    }

    public static IAST Block(IExpr a0, IExpr a1) {
        return new AST2(Block, a0, a1);
    }

    public static ISymbol bool(boolean value) {
        return value ? True : False;
    }

    public static IAST Boole(IExpr a) {
        return new AST1(Boole, a);
    }

    public static IAST BooleanConvert(IExpr a0, IExpr a1) {
        return new AST2(BooleanConvert, a0, a1);
    }

    public static IAST BooleanQ(IExpr a) {
        return new AST1(BooleanQ, a);
    }

    public static IAST BooleanMinimize(IExpr a) {
        return new AST1(BooleanMinimize, a);
    }

    public static IAST BooleanTable(IExpr a0, IExpr a1) {
        return new AST2(BooleanTable, a0, a1);
    }

    public static IAST BooleanVariables(IExpr a0) {
        return new AST1(BooleanVariables, a0);
    }

    public static IAST BesselI(IExpr a0, IExpr a1) {
        return new AST2(BesselI, a0, a1);
    }

    public static IAST BesselJ(IExpr a0, IExpr a1) {
        return new AST2(BesselJ, a0, a1);
    }

    public static IAST BesselY(IExpr a0, IExpr a1) {
        return new AST2(BesselY, a0, a1);
    }

    public static IAST BesselK(IExpr a0, IExpr a1) {
        return new AST2(BesselK, a0, a1);
    }

    public static IAST Beta(IExpr a0, IExpr a1) {
        return new AST2(Beta, a0, a1);
    }

    public static IAST Beta(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(Beta, a0, a1, a2);
    }

    public static IAST BetaRegularized(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(BetaRegularized, a0, a1, a2);
    }

    public static IAST BetaRegularized(IExpr a0, IExpr a1, IExpr a2, IExpr a3) {
        return F.quaternary(BetaRegularized, a0, a1, a2, a3);
    }

    public static IAST Break() {
        return new AST0(Break);
    }

    public static IAST C(int index) {
        return new AST1(C, F.ZZ(index));
    }

    public static IAST Cancel(IExpr a) {
        return new AST1(Cancel, a);
    }

    public static IAST CancelButton() {
        return new AST0(CancelButton);
    }

    public static IAST CarlsonRC(IExpr a0, IExpr a1) {
        return new AST2(CarlsonRC, a0, a1);
    }

    public static IAST CarlsonRD(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(CarlsonRD, a0, a1, a2);
    }

    public static IAST CarlsonRF(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(CarlsonRF, a0, a1, a2);
    }

    public static IAST CarlsonRG(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(CarlsonRG, a0, a1, a2);
    }

    public static IAST CarmichaelLambda(IExpr a0) {
        return new AST1(CarmichaelLambda, a0);
    }

    public static IExpr cast(Object obj) {
        return Object2Expr.convert(obj, true, false);
    }

    public static IAST CatalanNumber(IExpr a) {
        return new AST1(CatalanNumber, a);
    }

    public static IAST Catch(IExpr a) {
        return new AST1(Catch, a);
    }

    public static IAST CauchyDistribution(IExpr a0, IExpr a1) {
        return new AST2(CauchyDistribution, a0, a1);
    }

    public static IComplex CC(IFraction re) {
        return F.complex(re, F.fraction(0L, 1L));
    }

    public static IComplex CC(IRational re, IRational im) {
        return ComplexSym.valueOf(re, im);
    }

    public static IComplex CC(long realNumerator, long realDenominator, long imagNumerator, long imagDenominator) {
        return ComplexSym.valueOf(realNumerator, realDenominator, imagNumerator, imagDenominator);
    }

    public static IAST CDF(IExpr distribution) {
        return new AST1(CDF, distribution);
    }

    public static IAST CDF(IExpr distribution, IExpr a1) {
        return new AST2(CDF, distribution, a1);
    }

    public static IAST Ceiling(IExpr z) {
        return new AST1(Ceiling, z);
    }

    public static IAST ChebyshevT(IExpr a0, IExpr a1) {
        return new AST2(ChebyshevT, a0, a1);
    }

    public static IAST ChebyshevU(IExpr a0, IExpr a1) {
        return new AST2(ChebyshevU, a0, a1);
    }

    public static IAST CharacteristicPolynomial(IExpr a0, IExpr a1) {
        return new AST2(CharacteristicPolynomial, a0, a1);
    }

    public static IAST Chop(IExpr a0) {
        return new AST1(Chop, a0);
    }

    public static IExpr chopExpr(IExpr arg, double delta) {
        if (arg.isNumber()) {
            return F.chopNumber((INumber)arg, delta);
        }
        return arg;
    }

    public static INumber chopNumber(INumber arg, double delta) {
        if (arg instanceof INum) {
            if (F.isZero(((INum)arg).getRealPart(), delta)) {
                return C0;
            }
        } else if (arg instanceof IComplexNum) {
            Complex c = ((IComplexNum)arg).evalComplex();
            if (F.isZero(c.getReal(), delta)) {
                if (F.isZero(c.getImaginary(), delta)) {
                    return C0;
                }
                return F.complexNum(0.0, c.getImaginary());
            }
            if (F.isZero(c.getImaginary(), delta)) {
                return F.num(((IComplexNum)arg).getRealPart());
            }
        }
        return arg;
    }

    public static Complex chopComplex(Complex arg) {
        return F.chopComplex(arg, 1.0E-10);
    }

    public static Complex chopComplex(Complex arg, double delta) {
        Complex c = arg;
        if (F.isZero(c.getReal(), delta)) {
            if (F.isZero(c.getImaginary(), delta)) {
                return org.hipparchus.complex.Complex.ZERO;
            }
            return new Complex(0.0, c.getImaginary());
        }
        if (F.isZero(c.getImaginary(), delta)) {
            return new Complex(c.getReal());
        }
        return arg;
    }

    public static IAST CentralMoment(IExpr a0, IExpr a1) {
        return new AST2(CentralMoment, a0, a1);
    }

    public static IAST Clear(IExpr ... a) {
        return F.function(Clear, a);
    }

    public static IAST ClearAttributes(IExpr a0, IExpr a1) {
        return new AST2(ClearAttributes, a0, a1);
    }

    public static IAST Coefficient(IExpr a0, IExpr a1) {
        return new AST2(Coefficient, a0, a1);
    }

    public static IAST Coefficient(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(Coefficient, a0, a1, a2);
    }

    public static IAST CoefficientList(IExpr a0, IExpr a1) {
        return new AST2(CoefficientList, a0, a1);
    }

    public static IAST Collect(IExpr a0, IExpr a1) {
        return new AST2(Collect, a0, a1);
    }

    public static IAST Colon(IExpr a0, IExpr a1) {
        return new AST2(Colon, a0, a1);
    }

    public static int compareTo(IExpr a, IExpr b) throws UnsupportedOperationException {
        if (a instanceof ISignedNumber && b instanceof ISignedNumber) {
            return a.compareTo(b);
        }
        IExpr tempA = F.eval(a);
        IExpr tempB = F.eval(b);
        if (tempA instanceof ISignedNumber && tempB instanceof ISignedNumber) {
            return tempA.compareTo(tempB);
        }
        throw new UnsupportedOperationException("compareTo() - first or second argument could not be converted into a signed number.");
    }

    public static int compareTo(IExpr a, Integer i) throws UnsupportedOperationException {
        if (a instanceof ISignedNumber) {
            return a.compareTo(F.ZZ(i.longValue()));
        }
        IExpr temp = F.eval(a);
        if (temp instanceof ISignedNumber) {
            return temp.compareTo(F.ZZ(i.longValue()));
        }
        throw new UnsupportedOperationException("compareTo() - first argument could not be converted into a signed number.");
    }

    public static int compareTo(IExpr a, BigInteger i) throws UnsupportedOperationException {
        if (a instanceof ISignedNumber) {
            return a.compareTo(F.ZZ(i));
        }
        IExpr temp = F.eval(a);
        if (temp instanceof ISignedNumber) {
            return temp.compareTo(F.ZZ(i));
        }
        throw new UnsupportedOperationException("compareTo() - first argument could not be converted into a signed number.");
    }

    public static int compareTo(Integer i, IExpr b) throws UnsupportedOperationException {
        if (b instanceof ISignedNumber) {
            return F.ZZ(i.longValue()).compareTo(b);
        }
        IExpr temp = F.eval(b);
        if (temp instanceof ISignedNumber) {
            return F.ZZ(i.longValue()).compareTo(temp);
        }
        throw new UnsupportedOperationException("compareTo() - second argument could not be converted into a signed number.");
    }

    public static int compareTo(BigInteger i, IExpr b) throws UnsupportedOperationException {
        if (b instanceof ISignedNumber) {
            return F.ZZ(i).compareTo(b);
        }
        IExpr temp = F.eval(b);
        if (temp instanceof ISignedNumber) {
            return F.ZZ(i).compareTo(temp);
        }
        throw new UnsupportedOperationException("compareTo() - second argument could not be converted into a signed number.");
    }

    public static IAST Compile(IExpr a0, IExpr a1) {
        return new AST2(Compile, a0, a1);
    }

    public static IAST CompilePrint(IExpr a0, IExpr a1) {
        return new AST2(CompilePrint, a0, a1);
    }

    public static IAST Complement(IExpr a0, IExpr a1) {
        return new AST2(Complement, a0, a1);
    }

    public static IComplex complex(double realPart, double imagPart) {
        return F.complex(realPart, imagPart, Config.DOUBLE_EPSILON);
    }

    public static IComplex complex(double realPart, double imagPart, double epsilon) {
        return ComplexSym.valueOf(AbstractFractionSym.valueOfEpsilon(realPart, epsilon), AbstractFractionSym.valueOfEpsilon(imagPart, epsilon));
    }

    public static IComplex complexConvergent(double realPart, double imagPart) {
        return ComplexSym.valueOf(AbstractFractionSym.valueOfConvergent(realPart), AbstractFractionSym.valueOfConvergent(imagPart));
    }

    public static IComplex complex(IRational re) {
        return F.complex(re, F.fraction(0L, 1L));
    }

    public static IComplex complex(IRational re, IRational im) {
        return ComplexSym.valueOf(re, im);
    }

    public static IComplex complex(long real_numerator, long real_denominator, long imag_numerator, long imag_denominator) {
        return ComplexSym.valueOf(real_numerator, real_denominator, imag_numerator, imag_denominator);
    }

    public static IAST Complex(IExpr a0, IExpr a1) {
        return new AST2(Complex, a0, a1);
    }

    public static IComplexNum complexNum(Apcomplex c) {
        return ApcomplexNum.valueOf(c);
    }

    public static IComplexNum complexNum(Apfloat realPart) {
        return ApcomplexNum.valueOf(realPart, (Apfloat)Apcomplex.ZERO);
    }

    public static IComplexNum complexNum(Apfloat realPart, Apfloat imaginaryPart) {
        return ApcomplexNum.valueOf(realPart, imaginaryPart);
    }

    public static IComplexNum complexNum(String realPart, String imaginaryPart, long precision) {
        return ApcomplexNum.valueOf(new Apfloat(realPart, precision), new Apfloat(imaginaryPart, precision));
    }

    public static IComplexNum complexNum(Complex c) {
        return ComplexNum.valueOf(c);
    }

    public static IComplexNum complexNum(double r) {
        return F.complexNum(r, 0.0);
    }

    public static IComplexNum complexNum(double r, double i) {
        return ComplexNum.valueOf(r, i);
    }

    public static IComplexNum complexNum(IComplex value) {
        IRational realFraction = value.getRealPart();
        IRational imagFraction = value.getImaginaryPart();
        EvalEngine engine = EvalEngine.get();
        if (engine.isArbitraryMode()) {
            return ApcomplexNum.valueOf(realFraction.toBigNumerator(), realFraction.toBigDenominator(), imagFraction.toBigNumerator(), imagFraction.toBigDenominator());
        }
        double nr = realFraction.numerator().doubleValue();
        double dr = realFraction.denominator().doubleValue();
        double ni = imagFraction.numerator().doubleValue();
        double di = imagFraction.denominator().doubleValue();
        return F.complexNum(nr / dr, ni / di);
    }

    public static IComplexNum complexNum(IFraction value) {
        EvalEngine engine = EvalEngine.get();
        if (engine.isArbitraryMode()) {
            return ApcomplexNum.valueOf(value.toBigNumerator(), value.toBigDenominator(), BigInteger.ZERO, BigInteger.ONE);
        }
        return F.complexNum(value.doubleValue(), 0.0);
    }

    public static IComplexNum complexNum(IInteger value) {
        EvalEngine engine = EvalEngine.get();
        if (engine.isArbitraryMode()) {
            return ApcomplexNum.valueOf(value.toBigNumerator(), BigInteger.ONE, BigInteger.ZERO, BigInteger.ONE);
        }
        return F.complexNum(value.doubleValue(), 0.0);
    }

    public static IAST CompoundExpression(IExpr ... expr) {
        return F.function(CompoundExpression, expr);
    }

    public static IASTMutable function(IExpr head, IExpr ... a) {
        int size = a.length;
        switch (size) {
            case 1: {
                return new AST1(head, a[0]);
            }
            case 2: {
                return new AST2(head, a[0], a[1]);
            }
            case 3: {
                return new AST3(head, a[0], a[1], a[2]);
            }
        }
        return new AST(head, a);
    }

    public static IAST Condition(IExpr pattern, IExpr test) {
        return new B2.Condition(pattern, test);
    }

    public static IAST ConditionalExpression(IExpr expr, IExpr condition) {
        return new AST2(ConditionalExpression, expr, condition);
    }

    public static IAST Cone(IExpr matrix) {
        return new AST1(Cone, matrix);
    }

    public static IAST Cone(IExpr matrix, IExpr radius) {
        return new AST2(Cone, matrix, radius);
    }

    public static IAST Conjugate(IExpr a0) {
        return new AST1(Conjugate, a0);
    }

    public static IAST ConstantArray(IExpr a0, IExpr a1) {
        return new AST2(ConstantArray, a0, a1);
    }

    public static IAST ConjugateTranspose(IExpr a0) {
        return new AST1(ConjugateTranspose, a0);
    }

    public static IAST Continue() {
        return new AST0(Continue);
    }

    public static IAST ContinuedFraction(IExpr a0) {
        return new AST1(ContinuedFraction, a0);
    }

    public static IAST CoplanarPoints(IExpr a0) {
        return new AST1(CoplanarPoints, a0);
    }

    public static IAST CoprimeQ(IExpr a0, IExpr a1) {
        return new AST2(CoprimeQ, a0, a1);
    }

    public static IAST Cos(IExpr z) {
        return new B1.Cos(z);
    }

    public static IAST Cosh(IExpr z) {
        return new AST1(Cosh, z);
    }

    public static IAST CoshIntegral(IExpr z) {
        return new AST1(CoshIntegral, z);
    }

    public static IAST CosIntegral(IExpr z) {
        return new AST1(CosIntegral, z);
    }

    public static IAST Cot(IExpr z) {
        return new AST1(Cot, z);
    }

    public static IAST Coth(IExpr z) {
        return new AST1(Coth, z);
    }

    public static IAST Count(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(Count, a0, a1, a2);
    }

    public static IAST Covariance(IExpr a0, IExpr a1) {
        return new AST2(Covariance, a0, a1);
    }

    public static IAST Cross(IExpr a0, IExpr a1) {
        return new AST2(Cross, a0, a1);
    }

    public static IAST Csc(IExpr z) {
        return new B1.Csc(z);
    }

    public static IAST Csch(IExpr z) {
        return new AST1(Csch, z);
    }

    public static IAST Cuboid(IExpr pMin, IExpr pMax) {
        return new AST2(Cuboid, pMin, pMax);
    }

    public static IAST Cycles(IExpr a0) {
        return new AST1(Cycles, a0);
    }

    public static IAST Cylinder(IExpr matrix) {
        return new AST1(Cylinder, matrix);
    }

    public static IAST Cylinder(IExpr matrix, IExpr radius) {
        return new AST2(Cylinder, matrix, radius);
    }

    public static IAST D() {
        return F.ast(D);
    }

    public static IAST D(IExpr f, IExpr x) {
        return new AST2(D, f, x);
    }

    public static IAST Decrement(IExpr a) {
        return new AST1(Decrement, a);
    }

    public static IAST Defer(IExpr a0) {
        return new AST1(Defer, a0);
    }

    public static IAST Delete(IExpr a0, IExpr a1) {
        return new AST2(Delete, a0, a1);
    }

    public static IAST DeleteCases(IExpr ... a) {
        return F.function(DeleteCases, a);
    }

    public static IAST Denominator(IExpr expr) {
        return new AST1(Denominator, expr);
    }

    public static IAST Depth(IExpr a0) {
        return new AST1(Depth, a0);
    }

    public static IAST Derivative(IExpr ... a) {
        return F.function(Derivative, a);
    }

    public static IAST DesignMatrix(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(DesignMatrix, a0, a1, a2);
    }

    public static IAST Det(IExpr a0) {
        return new AST1(Det, a0);
    }

    public static IAST DialogReturn() {
        return new AST0(DialogReturn);
    }

    public static IAST DialogReturn(IExpr a0) {
        return new AST1(DialogReturn, a0);
    }

    public static IAST DiagonalMatrix(IExpr a0) {
        return new AST1(DiagonalMatrix, a0);
    }

    public static IAST DiagonalMatrix(IExpr a0, IExpr a1) {
        return new AST2(DiagonalMatrix, a0, a1);
    }

    public static IAST DiagonalMatrixQ(IExpr a0) {
        return new AST1(DiagonalMatrixQ, a0);
    }

    public static IAST DiagonalMatrixQ(IExpr a0, IExpr a1) {
        return new AST2(DiagonalMatrixQ, a0, a1);
    }

    public static IAST DigitQ(IExpr a0) {
        return new AST1(DigitQ, a0);
    }

    public static IAST Dimensions(IExpr a0) {
        return new AST1(Dimensions, a0);
    }

    public static IAST DiracDelta(IExpr a0) {
        return new AST1(DiracDelta, a0);
    }

    public static IAST DirectedEdge(IExpr a, IExpr b) {
        return new B2.DirectedEdge(a, b);
    }

    public static IAST DirectedInfinity(IExpr a0) {
        return new AST1(DirectedInfinity, a0);
    }

    public static IAST DiscreteUniformDistribution(IExpr a) {
        return new AST1(DiscreteUniformDistribution, a);
    }

    public static IAST Discriminant(IExpr a0, IExpr a1) {
        return new AST2(Discriminant, a0, a1);
    }

    public static IAST Distribute(IExpr a) {
        return new AST1(Distribute, a);
    }

    public static IAST Distribute(IExpr a0, IExpr a1) {
        return new AST2(Distribute, a0, a1);
    }

    public static IAST Distribute(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(Distribute, a0, a1, a2);
    }

    public static IAST Distributed(IExpr x, IAST distribution) {
        return new AST2(Distributed, x, distribution);
    }

    public static IExpr div(IExpr a, Integer i) {
        return F.Times(a, (IExpr)F.Power((IExpr)F.ZZ(i.longValue()), CN1));
    }

    public static IExpr div(IExpr a, BigInteger i) {
        return F.Times(a, (IExpr)F.Power((IExpr)F.ZZ(i), CN1));
    }

    public static IExpr div(Integer i, IExpr b) {
        return F.Times((IExpr)F.ZZ(i.longValue()), (IExpr)F.Power(b, CN1));
    }

    public static IExpr div(BigInteger i, IExpr b) {
        return F.Times((IExpr)F.ZZ(i), (IExpr)F.Power(b, CN1));
    }

    public static IASTMutable DirectionalLight(IExpr color, IExpr point) {
        return new AST2(DirectionalLight, color, point);
    }

    public static IAST Divide(IExpr arg1, IExpr arg2) {
        return new B2.Times(arg1, new B2.Power(arg2, CN1));
    }

    public static IASTMutable DivideSides(IExpr equationOrInequality) {
        return new AST1(DivideSides, equationOrInequality);
    }

    public static IASTMutable DivideSides(IExpr equationOrInequality, IExpr a1) {
        return new AST2(DivideSides, equationOrInequality, a1);
    }

    public static IAST Divisible(IExpr a0, IExpr a1) {
        return new AST2(Divisible, a0, a1);
    }

    public static IAST DivisorSigma(IExpr a0, IExpr a1) {
        return new AST2(DivisorSigma, a0, a1);
    }

    public static IAST Divisors(IExpr a0) {
        return new AST1(Divisors, a0);
    }

    public static IAST Do(IExpr a0, IExpr a1) {
        return new AST2(Do, a0, a1);
    }

    public static IAST Dot(IExpr ... a) {
        return F.function(Dot, a);
    }

    public static IAST Dot(IExpr a, IExpr b) {
        return new AST2(Dot, a, b);
    }

    public static IAST Dot(IExpr a, IExpr b, IExpr c) {
        return new AST3(Dot, a, b, c);
    }

    public static IAST Drop(IExpr list, IExpr a1) {
        return new AST2(Drop, list, a1);
    }

    public static IAST Drop(IExpr list, IExpr a1, IExpr a2) {
        return new AST3(Drop, list, a1, a2);
    }

    public static IAST DSolve(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(DSolve, a0, a1, a2);
    }

    public static IAST Eigenvalues(IExpr m) {
        return new AST1(Eigenvalues, m);
    }

    public static IAST Eigenvectors(IExpr m) {
        return new AST1(Eigenvectors, m);
    }

    public static IAST Element(IExpr variable, IExpr domain) {
        return new AST2(Element, variable, domain);
    }

    public static IAST ElementData(IExpr name, IExpr property) {
        return new AST2(ElementData, name, property);
    }

    public static IAST Eliminate(IExpr a0, IExpr a1) {
        return new AST2(Eliminate, a0, a1);
    }

    public static IAST EllipticE(IExpr m) {
        return new AST1(EllipticE, m);
    }

    public static IAST EllipticE(IExpr phi, IExpr m) {
        return new AST2(EllipticE, phi, m);
    }

    public static IAST EllipticF(IExpr phi, IExpr m) {
        return new AST2(EllipticF, phi, m);
    }

    public static IAST EllipticK(IExpr m) {
        return new AST1(EllipticK, m);
    }

    public static IAST EllipticPi(IExpr n, IExpr m) {
        return new AST2(EllipticPi, n, m);
    }

    public static IAST EllipticPi(IExpr n, IExpr phi, IExpr m) {
        return new AST3(EllipticPi, n, phi, m);
    }

    public static IAST Equal(IExpr ... a) {
        return F.function(Equal, a);
    }

    public static IAST Equal(IExpr lhs, IExpr rhs) {
        return new B2.Equal(lhs, rhs);
    }

    public static IAST Equal(IExpr lhs, int rhs) {
        return new B2.Equal(lhs, F.ZZ(rhs));
    }

    public static IAST Equivalent(IExpr lhs, IExpr rhs) {
        return new AST2(Equivalent, lhs, rhs);
    }

    public static IAST Erf(IExpr a) {
        return new AST1(Erf, a);
    }

    public static IAST Erfc(IExpr a) {
        return new AST1(Erfc, a);
    }

    public static IAST Erfi(IExpr a) {
        return new AST1(Erfi, a);
    }

    public static IAST ErlangDistribution(IExpr a0, IExpr a1) {
        return new AST2(ErlangDistribution, a0, a1);
    }

    public static IExpr eval(IExpr a) {
        return EvalEngine.get().evaluate(a);
    }

    public static IExpr eval(String str) {
        return EvalEngine.get().evaluate(str);
    }

    @Deprecated
    private static IExpr eval(ISymbol head, IExpr a0) {
        IASTAppendable ast = F.ast(head);
        ast.append(a0);
        return EvalEngine.get().evaluate(ast);
    }

    public static IExpr evalExpand(IExpr expr) {
        IAST ast;
        EvalEngine engine = EvalEngine.get();
        if (expr.isAST() && ((ast = (IAST)expr).isPlus() ? ast.exists(IExpr::isPlusTimesPower) : ast.isTimes() || ast.isPower())) {
            return engine.evaluate(F.Expand(expr));
        }
        return expr;
    }

    public static IExpr evalExpandAll(IExpr a) {
        return F.evalExpandAll(a, EvalEngine.get());
    }

    public static IExpr evalExpandAll(IExpr a, EvalEngine engine) {
        return engine.evaluate(F.ExpandAll(a));
    }

    @Deprecated
    public static IExpr evaln(IExpr a0) {
        return F.eval(N, a0);
    }

    @Deprecated
    public static IExpr evalQuiet(IExpr a) {
        return EvalEngine.get().evalQuiet(a);
    }

    @Deprecated
    public static IExpr evalQuietNull(IExpr a) {
        return EvalEngine.get().evalQuietNull(a);
    }

    @Deprecated
    public static boolean evalTrue(IExpr expr) {
        return EvalEngine.get().evalTrue(expr);
    }

    public static IAST EvenQ(IExpr x) {
        return new AST1(EvenQ, x);
    }

    public static IAST ExactNumberQ(IExpr expr) {
        return new AST1(ExactNumberQ, expr);
    }

    public static IAST Exists(IExpr a0, IExpr a1) {
        return new AST2(Exists, a0, a1);
    }

    public static IAST Exists(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(Exists, a0, a1, a2);
    }

    public static ISignedNumber expr(Number number) {
        if (number instanceof Integer || number instanceof Long || number instanceof Short || number instanceof Byte) {
            return F.ZZ(number.longValue());
        }
        if (number instanceof Double || number instanceof Float) {
            return F.num(number.doubleValue());
        }
        if (number instanceof BigInteger) {
            return F.ZZ((BigInteger)number);
        }
        throw new IllegalArgumentException(number.getClass().getName());
    }

    public static IAST EuclideanDistance(IExpr a0, IExpr a1) {
        return new AST2(EuclideanDistance, a0, a1);
    }

    public static IAST EulerE(IExpr a0) {
        return new AST1(EulerE, a0);
    }

    public static IAST EulerPhi(IExpr a0) {
        return new AST1(EulerPhi, a0);
    }

    public static IAST Exp(IExpr z) {
        return new B2.Power(E, z);
    }

    public static IAST ExpToTrig(IExpr a0) {
        return new AST1(ExpToTrig, a0);
    }

    public static IExpr expand(IExpr a, boolean expandNegativePowers, boolean distributePlus, boolean evalParts) {
        if (a.isAST()) {
            EvalEngine engine = EvalEngine.get();
            IAST ast = engine.evalFlatOrderlessAttributesRecursive((IAST)a).orElse((IAST)a);
            return Algebra.expand(ast, null, expandNegativePowers, distributePlus, evalParts).orElse(a);
        }
        return a;
    }

    public static IAST Expand(IExpr expr) {
        return new AST1(Expand, expr);
    }

    public static IAST Expand(IExpr expr, IExpr pattern) {
        return new AST2(Expand, expr, pattern);
    }

    public static IExpr expandAll(IExpr a, boolean expandNegativePowers, boolean distributePlus) {
        if (a.isAST()) {
            EvalEngine engine = EvalEngine.get();
            IAST ast = engine.evalFlatOrderlessAttributesRecursive((IAST)a).orElse((IAST)a);
            return Algebra.expandAll(ast, null, expandNegativePowers, distributePlus, false, engine).orElse(ast);
        }
        return a;
    }

    public static IAST ExpandAll(IExpr a0) {
        return new AST1(ExpandAll, a0);
    }

    public static IAST ExpIntegralE(IExpr a0, IExpr a1) {
        return new AST2(ExpIntegralE, a0, a1);
    }

    public static IAST ExpIntegralEi(IExpr a) {
        return new AST1(ExpIntegralEi, a);
    }

    public static IAST Exponent(IExpr a0, IExpr a1) {
        return new AST2(Exponent, a0, a1);
    }

    public static IAST Exponent(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(Exponent, a0, a1, a2);
    }

    public static IAST ExponentialDistribution(IExpr a0) {
        return new AST1(ExponentialDistribution, a0);
    }

    public static IAST ExportString(IExpr a0, IExpr a1) {
        return new AST2(ExportString, a0, a1);
    }

    public static IAST Extract(IExpr a0, IExpr a1) {
        return new AST2(Extract, a0, a1);
    }

    public static IAST Factor(IExpr poly) {
        return new AST1(Factor, poly);
    }

    public static IAST FactorTerms(IExpr poly) {
        return new AST1(FactorTerms, poly);
    }

    public static IAST Factorial(IExpr a0) {
        return new AST1(Factorial, a0);
    }

    public static IAST Factorial(int a0) {
        return new AST1(Factorial, F.ZZ(a0));
    }

    public static IAST Factorial2(IExpr a0) {
        return new AST1(Factorial2, a0);
    }

    public static IAST FactorialPower(IExpr a0, IExpr a1) {
        return new AST2(FactorialPower, a0, a1);
    }

    public static IAST FactorInteger(IExpr a0) {
        return new AST1(FactorInteger, a0);
    }

    public static IAST FactorSquareFree(IExpr a) {
        return new AST1(FactorSquareFree, a);
    }

    public static IAST FactorSquareFreeList(IExpr a) {
        return new AST1(FactorSquareFreeList, a);
    }

    public static IAST Fibonacci(IExpr a0) {
        return new AST1(Fibonacci, a0);
    }

    public static IAST Fibonacci(IExpr a0, IExpr a1) {
        return new AST2(Fibonacci, a0, a1);
    }

    public static IAST FindFit(IExpr a0, IExpr a1, IExpr a2, IExpr a3) {
        return F.quaternary(FindFit, a0, a1, a2, a3);
    }

    public static IAST FindMaximum(IExpr f, IExpr x) {
        return new AST2(FindMaximum, f, x);
    }

    public static IAST FindMinimum(IExpr f, IExpr x) {
        return new AST2(FindMinimum, f, x);
    }

    public static IAST FindRoot(IExpr f, IExpr x) {
        return new AST2(FindRoot, f, x);
    }

    public static IAST FindShortestPath(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(FindShortestPath, a0, a1, a2);
    }

    public static IAST FindShortestTour(IExpr a0) {
        return new AST1(FindShortestTour, a0);
    }

    public static IAST FindSpanningTree(IExpr a0) {
        return new AST1(FindSpanningTree, a0);
    }

    public static IAST Fit(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(Fit, a0, a1, a2);
    }

    public static IAST FiveNum(IExpr a) {
        return new AST1(FiveNum, a);
    }

    public static IAST First(IExpr a0) {
        return new AST1(First, a0);
    }

    public static IAST Flatten(IExpr a0) {
        return new AST1(Flatten, a0);
    }

    public static IAST Flatten(IExpr a0, IExpr a1) {
        return new AST2(Flatten, a0, a1);
    }

    public static IAST Floor(IExpr z) {
        return new AST1(Floor, z);
    }

    public static IAST Fold(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(Fold, a0, a1, a2);
    }

    public static IAST ForAll(IExpr a0, IExpr a1) {
        return new AST2(ForAll, a0, a1);
    }

    public static IAST ForAll(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(ForAll, a0, a1, a2);
    }

    public static IFraction fraction(BigFraction value) {
        return AbstractFractionSym.valueOf(value);
    }

    public static IFraction fraction(BigInteger numerator, BigInteger denominator) {
        return AbstractFractionSym.valueOf(numerator, denominator);
    }

    public static IFraction fraction(IInteger numerator, IInteger denominator) {
        return AbstractFractionSym.valueOf(numerator, denominator);
    }

    public static IRational fraction(long numerator, long denominator) {
        return AbstractFractionSym.valueOf(numerator, denominator);
    }

    public static IFraction fraction(double value) {
        return AbstractFractionSym.valueOfEpsilon(value, Config.DOUBLE_EPSILON);
    }

    public static IFraction fraction(double value, double epsilon) {
        return AbstractFractionSym.valueOfEpsilon(value, epsilon);
    }

    public static IFraction fractionConvergent(double value) {
        return AbstractFractionSym.valueOfConvergent(value);
    }

    public static IExpr fractionExact(double value, boolean attemptNiceFraction) {
        return !attemptNiceFraction ? AbstractFractionSym.valueOfExact(value) : AbstractFractionSym.valueOfExactNice(value);
    }

    public static IAST FractionBox(IExpr a0, IExpr a1) {
        return new AST2(FractionBox, a0, a1);
    }

    public static IAST FractionalPart(IExpr a) {
        return new AST1(FractionalPart, a);
    }

    public static IAST FreeQ(IExpr expr, IExpr form) {
        return new B2.FreeQ(expr, form);
    }

    public static IAST FrechetDistribution(IExpr a0, IExpr a1) {
        return new AST2(FrechetDistribution, a0, a1);
    }

    public static IAST FresnelC(IExpr a) {
        return new AST1(FresnelC, a);
    }

    public static IAST FresnelS(IExpr a) {
        return new AST1(FresnelS, a);
    }

    public static IAST FullForm(IExpr a0) {
        return new AST1(FullForm, a0);
    }

    public static IAST FullSimplify(IExpr a) {
        return new AST1(FullSimplify, a);
    }

    public static IAST Function(IExpr a0) {
        return new AST1(Function, a0);
    }

    public static IAST Function(IExpr a0, IExpr a1) {
        return new AST2(Function, a0, a1);
    }

    public static IAST FunctionDomain(IExpr a0, IExpr a1) {
        return new AST2(FunctionDomain, a0, a1);
    }

    public static IAST FunctionDomain(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(FunctionDomain, a0, a1, a2);
    }

    public static IAST FunctionExpand(IExpr a0) {
        return new AST1(FunctionExpand, a0);
    }

    public static IAST FunctionExpand(IExpr a0, IExpr a1) {
        return new AST2(FunctionExpand, a0, a1);
    }

    public static IAST FunctionRange(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(FunctionRange, a0, a1, a2);
    }

    public static IAST FunctionRange(IExpr a0, IExpr a1, IExpr a2, IExpr a3) {
        return F.quaternary(FunctionRange, a0, a1, a2, a3);
    }

    public static IAST FunctionURL(IExpr a0) {
        return new AST1(FunctionURL, a0);
    }

    public static IAST Get(IExpr a0) {
        return new AST1(Get, a0);
    }

    public static IAST Get(String str) {
        return new AST1(Get, F.stringx(str));
    }

    public static IAST Gamma(IExpr a0) {
        return new AST1(Gamma, a0);
    }

    public static IAST Gamma(IExpr a0, IExpr a1) {
        return new AST2(Gamma, a0, a1);
    }

    public static IAST Gamma(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(Gamma, a0, a1, a2);
    }

    public static IAST GammaDistribution(IExpr a0, IExpr a1) {
        return new AST2(GammaDistribution, a0, a1);
    }

    public static IAST GammaDistribution(IExpr a0, IExpr a1, IExpr a2, IExpr a3) {
        return F.quaternary(GammaDistribution, a0, a1, a2, a3);
    }

    public static IAST GammaRegularized(IExpr a0, IExpr a1) {
        return new AST2(GammaRegularized, a0, a1);
    }

    public static IAST GammaRegularized(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(GammaRegularized, a0, a1, a2);
    }

    public static IAST Gather(IExpr a0, IExpr a1) {
        return new AST2(Gather, a0, a1);
    }

    public static IAST GatherBy(IExpr a0, IExpr a1) {
        return new AST2(GatherBy, a0, a1);
    }

    public static IAST GCD(IExpr a0) {
        return new AST1(GCD, a0);
    }

    public static IAST GCD(IExpr a0, IExpr a1) {
        return new AST2(GCD, a0, a1);
    }

    public static IAST GegenbauerC(IExpr a0, IExpr a1) {
        return new AST2(GegenbauerC, a0, a1);
    }

    public static IAST GegenbauerC(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(GegenbauerC, a0, a1, a2);
    }

    public static IAST GeoDistance(IExpr a0, IExpr a1) {
        return new AST2(GeoDistance, a0, a1);
    }

    public static IAST GeometricMean(IExpr a0) {
        return new AST1(GeometricMean, a0);
    }

    public static IAST Grad(IExpr a0, IExpr a1) {
        return new AST2(Grad, a0, a1);
    }

    public static IAST Graph(IExpr a0) {
        return new AST1(Graph, a0);
    }

    public static IAST Graph(IExpr a0, IExpr a1) {
        return new AST2(Graph, a0, a1);
    }

    public static IAST Graph(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(Graph, a0, a1, a2);
    }

    public static IASTAppendable Graphics() {
        return F.ast(Graphics);
    }

    public static IASTAppendable Graphics3D(IExpr graphicPrimitives) {
        IASTAppendable ast = F.ast(Graphics3D);
        ast.append(graphicPrimitives);
        return ast;
    }

    public static IAST Graphics3D(IExpr graphicPrimitives, IExpr option) {
        IASTAppendable ast = F.ast(Graphics3D);
        ast.append(graphicPrimitives);
        ast.append(option);
        return ast;
    }

    public static IAST Greater(IExpr x, IExpr y) {
        return new B2.Greater(x, y);
    }

    public static IAST Greater(IExpr x, int y) {
        return new B2.Greater(x, F.ZZ(y));
    }

    public static IAST GreaterEqual(IExpr x, IExpr y) {
        return new B2.GreaterEqual(x, y);
    }

    public static IAST GreaterEqual(IExpr x, int y) {
        return new B2.GreaterEqual(x, F.ZZ(y));
    }

    public static IAST Gudermannian(IExpr a0) {
        return new AST1(Gudermannian, a0);
    }

    public static IAST GumbelDistribution() {
        return new AST0(GumbelDistribution);
    }

    public static IAST GumbelDistribution(IExpr a0, IExpr a1) {
        return new AST2(GumbelDistribution, a0, a1);
    }

    public static IAST HankelH1(IExpr a0, IExpr a1) {
        return new AST2(HankelH1, a0, a1);
    }

    public static IAST HankelH2(IExpr a0, IExpr a1) {
        return new AST2(HankelH2, a0, a1);
    }

    public static IAST HarmonicMean(IExpr a0) {
        return new AST1(HarmonicMean, a0);
    }

    public static IAST HarmonicNumber(IExpr a) {
        return new AST1(HarmonicNumber, a);
    }

    public static IAST HarmonicNumber(IExpr a0, IExpr a1) {
        return new AST2(HarmonicNumber, a0, a1);
    }

    public static IAST Haversine(IExpr a) {
        return new AST1(Haversine, a);
    }

    public static IAST Head(IExpr a) {
        return new AST1(Head, a);
    }

    public static final IASTMutable headAST0(IExpr head) {
        return new AST0(head);
    }

    public static IAST HeavisideTheta(IExpr a0) {
        return new AST1(HeavisideTheta, a0);
    }

    public static IAST HermitianMatrixQ(IExpr a0) {
        return new AST1(HermitianMatrixQ, a0);
    }

    public static IAST Histogram(IExpr a) {
        return new AST1(Histogram, a);
    }

    public static IAST Hold(IExpr a0) {
        return new AST1(Hold, a0);
    }

    public static IAST HoldForm(IExpr a0) {
        return new AST1(HoldForm, a0);
    }

    public static IAST HoldPattern(IExpr a0) {
        return new AST1(HoldPattern, a0);
    }

    public static IAST HurwitzZeta(IExpr a0, IExpr a1) {
        return new AST2(HurwitzZeta, a0, a1);
    }

    public static IAST Hypergeometric0F1(IExpr a0, IExpr a1) {
        return new AST2(Hypergeometric0F1, a0, a1);
    }

    public static IAST Hypergeometric1F1(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(Hypergeometric1F1, a0, a1, a2);
    }

    public static IAST Hypergeometric1F1Regularized(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(Hypergeometric1F1Regularized, a0, a1, a2);
    }

    public static IAST Hypergeometric2F1(IExpr a0, IExpr a1, IExpr a2, IExpr a3) {
        return F.quaternary(Hypergeometric2F1, a0, a1, a2, a3);
    }

    public static IAST HypergeometricPFQ(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(HypergeometricPFQ, a0, a1, a2);
    }

    public static IAST HypergeometricPFQRegularized(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(HypergeometricPFQRegularized, a0, a1, a2);
    }

    public static IAST HypergeometricU(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(HypergeometricU, a0, a1, a2);
    }

    public static IAST Identity(IExpr a0) {
        return new AST1(Identity, a0);
    }

    public static IAST If(IExpr condition, IExpr trueExpr) {
        return new B2.If(condition, trueExpr);
    }

    public static IAST If(IExpr condition, IExpr trueExpr, IExpr falseExpr) {
        return new B3.If(condition, trueExpr, falseExpr);
    }

    public static IAST If(IExpr condition, IExpr trueExpr, IExpr falseExpr, IExpr undefinedExpr) {
        return F.quaternary(If, condition, trueExpr, falseExpr, undefinedExpr);
    }

    public static IAST IInit(ISymbol sym, int[] sizes) {
        sym.createRulesData(sizes);
        return null;
    }

    public static IExpr Im(IExpr a0) {
        if (a0 != null && a0.isNumber()) {
            return ((INumber)a0).im();
        }
        return new AST1(Im, a0);
    }

    public static IAST Implies(IExpr a0, IExpr a1) {
        return new AST2(Implies, a0, a1);
    }

    public static IAST In(IExpr a0) {
        return new AST1(In, a0);
    }

    public static IAST Increment(IExpr a) {
        return new AST1(Increment, a);
    }

    public static IAST Inequality(IExpr ... a) {
        return F.function(Inequality, a);
    }

    public static IAST InexactNumberQ(IExpr a) {
        return new AST1(InexactNumberQ, a);
    }

    public static IAST Information(IExpr a) {
        return new AST1(Information, a);
    }

    public static IAST Information(IExpr a0, IExpr a1) {
        return new AST2(Information, a0, a1);
    }

    public static IPattern initPredefinedPattern(ISymbol symbol) {
        Pattern temp = new Pattern(symbol);
        PREDEFINED_PATTERN_MAP.put(symbol.toString(), temp);
        return temp;
    }

    public static IPatternSequence initPredefinedPatternSequence(ISymbol symbol) {
        return F.initPredefinedPatternSequence(symbol, false);
    }

    public static IPatternSequence initPredefinedPatternSequence(ISymbol symbol, boolean zeroArgsAllowed) {
        PatternSequence temp = PatternSequence.valueOf(symbol, zeroArgsAllowed);
        PREDEFINED_PATTERNSEQUENCE_MAP.put(symbol.toString(), temp);
        return temp;
    }

    public static synchronized void initSymbols() {
        if (!isSystemStarted) {
            try {
                isSystemStarted = true;
                try {
                    File sourceLocation;
                    String[] files;
                    String autoload = ".\\Autoload";
                    if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
                        autoload = ".\\AutoloadSymja";
                    }
                    if ((files = (sourceLocation = new File(autoload)).list()) != null) {
                        for (int i = 0; i < files.length; ++i) {
                            if (!files[i].endsWith(".m")) continue;
                            File sourceFile = new File(sourceLocation, files[i]);
                            FileFunctions.Get.loadPackage(EvalEngine.get(), sourceFile);
                        }
                    }
                }
                catch (AccessControlException acex) {
                    LOGGER.warn("Cannot read packages in autoload folder:", (Throwable)acex);
                }
                catch (RuntimeException ex) {
                    LOGGER.error((Object)ex);
                }
                systemInitialized = true;
            }
            catch (Throwable th) {
                LOGGER.error("F.initSymbols() failed", th);
            }
        }
    }

    public static IAST Insert(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(Insert, a0, a1, a2);
    }

    @Deprecated
    public static IInteger integer(BigInteger integerValue) {
        return AbstractIntegerSym.valueOf(integerValue);
    }

    @Deprecated
    public static IInteger integer(long integerValue) {
        return AbstractIntegerSym.valueOf(integerValue);
    }

    @Deprecated
    public static IInteger integer(String integerString, int radix) {
        return AbstractIntegerSym.valueOf(integerString, radix);
    }

    public static IAST IntegerPart(IExpr a0) {
        return new AST1(IntegerPart, a0);
    }

    public static IAST IntegerName(IExpr a0) {
        return new AST1(IntegerName, a0);
    }

    public static IAST IntegerName(IExpr a0, IExpr a1) {
        return new AST2(IntegerName, a0, a1);
    }

    public static IAST IntegerQ(IExpr expr) {
        return new B1.IntegerQ(expr);
    }

    public static IAST Integrate(IExpr f, IExpr x) {
        return new B2.Integrate(f, x);
    }

    public static IAST Interpolation(IExpr list) {
        return new AST1(Interpolation, list);
    }

    public static IAST InterpolatingPolynomial(IExpr a0, IExpr a1) {
        return new AST2(InterpolatingPolynomial, a0, a1);
    }

    public static IAST InterquartileRange(IExpr a) {
        return new AST1(InterquartileRange, a);
    }

    public static IASTAppendable IntervalAlloc(int capacity) {
        return F.ast((IExpr)Interval, capacity);
    }

    public static IAST Interval(IExpr list) {
        return new AST1(Interval, list);
    }

    public static IAST Interval(IExpr min, IExpr max) {
        return new AST1(Interval, F.binaryAST2((IExpr)List, min, max));
    }

    public static IAST intIterator(ISymbol head, Function<IExpr, IExpr> function, int from, int to, int step) {
        IASTAppendable result = F.ast((IExpr)head, to - from + 1);
        long numberOfLeaves = 0L;
        for (int i = from; i <= to; i += step) {
            IExpr temp = function.apply(F.ZZ(i));
            if ((numberOfLeaves += temp.leafCount() + 1L) >= (long)Config.MAX_AST_SIZE) {
                ASTElementLimitExceeded.throwIt(numberOfLeaves);
            }
            result.append(temp);
        }
        return result;
    }

    public static IRational sumRational(IntFunction<IRational> function, int from, int to, int step) {
        IRational result = C0;
        for (int i = from; i <= to; i += step) {
            result = result.add(function.apply(i));
        }
        return result;
    }

    public static IRational productRational(IntFunction<IRational> function, int from, int to, int step) {
        IRational result = C1;
        for (int i = from; i <= to; i += step) {
            result = result.multiply(function.apply(i));
        }
        return result;
    }

    public static IAST intIterator(ISymbol head, IntFunction<IExpr> function, int from, int to, int step) {
        IASTAppendable result = F.ast((IExpr)head, to - from + 1);
        for (int i = from; i <= to; i += step) {
            result.append(function.apply(i));
        }
        return result;
    }

    public static IAST intIterator(ISymbol head, Function<IExpr, IExpr> function, IAST list) {
        IASTAppendable result = F.ast((IExpr)head, list.size());
        for (int i = 1; i < list.size(); ++i) {
            result.append(function.apply(list.get(i)));
        }
        return result;
    }

    public static IAST Intersection(IExpr a0, IExpr a1) {
        return new AST2(Intersection, a0, a1);
    }

    public static IAST Inverse(IExpr a0) {
        return new AST1(Inverse, a0);
    }

    public static IAST InverseBetaRegularized(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(InverseBetaRegularized, a0, a1, a2);
    }

    public static IAST InverseBetaRegularized(IExpr a0, IExpr a1, IExpr a2, IExpr a3) {
        return F.quaternary(InverseBetaRegularized, a0, a1, a2, a3);
    }

    public static IAST InverseCDF(IExpr distribution, IExpr q) {
        return new AST2(InverseCDF, distribution, q);
    }

    public static IAST InverseErf(IExpr a0) {
        return new AST1(InverseErf, a0);
    }

    public static IAST InverseErfc(IExpr a0) {
        return new AST1(InverseErfc, a0);
    }

    public static IAST InverseFunction(IExpr a) {
        return new AST1(InverseFunction, a);
    }

    public static IAST InverseGammaRegularized(IExpr a0, IExpr a1) {
        return new AST2(InverseGammaRegularized, a0, a1);
    }

    public static IAST InverseGammaRegularized(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(InverseGammaRegularized, a0, a1, a2);
    }

    public static IAST InverseGudermannian(IExpr a0) {
        return new AST1(InverseGudermannian, a0);
    }

    public static IAST InverseHaversine(IExpr a) {
        return new AST1(InverseHaversine, a);
    }

    public static IAST InverseLaplaceTransform(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(InverseLaplaceTransform, a0, a1, a2);
    }

    public static IAST ISet(IExpr lhs, IExpr rhs) {
        if (lhs.isAST()) {
            ((IAST)lhs).setEvalFlags(((IAST)lhs).getEvalFlags() | 0x300);
        }
        PatternMatching.setDownRule(0, lhs, rhs, true);
        return NIL;
    }

    public static IAST ISetDelayed(IExpr lhs, IExpr rhs) {
        if (lhs.isAST()) {
            ((IAST)lhs).setEvalFlags(((IAST)lhs).getEvalFlags() | 0x300);
        }
        PatternMatching.setDelayedDownRule(java.lang.Integer.MAX_VALUE, lhs, rhs, true);
        return NIL;
    }

    public static IAST ISetDelayed(int priority, IExpr lhs, IExpr rhs) {
        if (lhs.isAST()) {
            ((IAST)lhs).setEvalFlags(((IAST)lhs).getEvalFlags() | 0x300);
        }
        PatternMatching.setDelayedDownRule(priority, lhs, rhs, true);
        return NIL;
    }

    public static IExpr IIntegrate(int priority, IAST lhs, IExpr rhs) {
        lhs.setEvalFlags(lhs.getEvalFlags() | 0x300);
        org.matheclipse.core.reflection.system.Integrate.INTEGRATE_RULES_DATA.integrate(lhs, rhs, priority);
        return NIL;
    }

    public static boolean isNumEqualInteger(double value, IInteger ii) throws ArithmeticException {
        return F.isZero(value - ii.doubleValue(), Config.DOUBLE_TOLERANCE);
    }

    public static boolean isNumEqualRational(double value, IRational rational) throws ArithmeticException {
        return F.isZero(value - rational.doubleValue(), Config.DOUBLE_TOLERANCE);
    }

    public static boolean isNumIntValue(double value) {
        return F.isZero(value - Math.rint(value), Config.DOUBLE_TOLERANCE);
    }

    public static boolean isNumIntValue(double value, double epsilon) {
        return F.isZero(value - Math.rint(value), epsilon);
    }

    public static boolean isNumIntValue(double value, int i) {
        return F.isZero(value - (double)i, Config.DOUBLE_TOLERANCE);
    }

    public static final boolean isEqual(double x, double y) {
        return F.isFuzzyEquals(x, y, Config.MACHINE_EPSILON);
    }

    public static final boolean isEqual(Complex x, Complex y) {
        return F.isFuzzyEquals(x, y, Config.MACHINE_EPSILON);
    }

    public static boolean isFuzzyEquals(double a, double b, double tolerance) {
        return Math.copySign(a - b, 1.0) < tolerance || a == b || Double.isNaN(a) && Double.isNaN(b);
    }

    public static final boolean isFuzzyEquals(Complex x, Complex y, double tolerance) {
        return F.isFuzzyEquals(x.getReal(), y.getReal(), tolerance) && F.isFuzzyEquals(x.getImaginary(), y.getImaginary(), tolerance);
    }

    public static double relativeDifference(double x, double y) {
        double error;
        if (Double.isInfinite(x) && Double.isInfinite(y)) {
            error = Double.compare(x, y) == 0 ? 0.0 : Double.POSITIVE_INFINITY;
        } else {
            double z = Math.abs(x + y) / 2.0;
            error = Math.abs(x - y);
            if (z > 0.0) {
                error /= z;
            }
        }
        return error;
    }

    public static boolean isZero(double value) {
        return F.isZero(value, Config.MACHINE_EPSILON);
    }

    public static boolean isZero(Complex value) {
        return org.hipparchus.complex.Complex.equals((Complex)value, (Complex)org.hipparchus.complex.Complex.ZERO, (double)Config.MACHINE_EPSILON);
    }

    public static boolean isZero(double x, double epsilon) {
        return F.isFuzzyEquals(x, 0.0, epsilon);
    }

    public static boolean isZero(Complex x, double epsilon) {
        return org.hipparchus.complex.Complex.equals((Complex)x, (Complex)org.hipparchus.complex.Complex.ZERO, (double)epsilon);
    }

    public static IAST JSFormData(String plainJavaScript, String format) {
        return new AST2(JSFormData, F.$str(plainJavaScript), F.$str(format));
    }

    public static IAST JacobiAmplitude(IExpr a0, IExpr a1) {
        return new AST2(JacobiAmplitude, a0, a1);
    }

    public static IAST JacobiCD(IExpr a0, IExpr a1) {
        return new AST2(JacobiCD, a0, a1);
    }

    public static IAST JacobiCN(IExpr a0, IExpr a1) {
        return new AST2(JacobiCN, a0, a1);
    }

    public static IAST JacobiDC(IExpr a0, IExpr a1) {
        return new AST2(JacobiDC, a0, a1);
    }

    public static IAST JacobiEpsilon(IExpr a0, IExpr a1) {
        return new AST2(JacobiEpsilon, a0, a1);
    }

    public static IAST JacobiNC(IExpr a0, IExpr a1) {
        return new AST2(JacobiNC, a0, a1);
    }

    public static IAST JacobiND(IExpr a0, IExpr a1) {
        return new AST2(JacobiND, a0, a1);
    }

    public static IAST JacobiDN(IExpr a0, IExpr a1) {
        return new AST2(JacobiDN, a0, a1);
    }

    public static IAST JacobiSC(IExpr a0, IExpr a1) {
        return new AST2(JacobiSC, a0, a1);
    }

    public static IAST JacobiSD(IExpr a0, IExpr a1) {
        return new AST2(JacobiSD, a0, a1);
    }

    public static IAST JacobiSN(IExpr a0, IExpr a1) {
        return new AST2(JacobiSN, a0, a1);
    }

    public static IAST JavaForm(IExpr a0, IExpr a1) {
        return new AST2(JavaForm, a0, a1);
    }

    public static IAST Join(IExpr a0, IExpr a1) {
        return new AST2(Join, a0, a1);
    }

    public static IAST KelvinBei(IExpr a0, IExpr a1) {
        return new AST2(KelvinBei, a0, a1);
    }

    public static IAST KelvinBer(IExpr a0, IExpr a1) {
        return new AST2(KelvinBer, a0, a1);
    }

    public static IAST Key(IExpr a0) {
        return new AST1(Key, a0);
    }

    public static IAST KleinInvariantJ(IExpr a0) {
        return new AST1(KleinInvariantJ, a0);
    }

    public static IAST KroneckerDelta(IExpr a0) {
        return new AST1(KroneckerDelta, a0);
    }

    public static IAST KroneckerDelta(IExpr a0, IExpr a1) {
        return new AST2(KroneckerDelta, a0, a1);
    }

    public static IAST LaguerreL(IExpr a0, IExpr a1) {
        return new AST2(LaguerreL, a0, a1);
    }

    public static IAST LaguerreL(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(LaguerreL, a0, a1, a2);
    }

    public static IAST LaplaceTransform(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(LaplaceTransform, a0, a1, a2);
    }

    public static IAST Last(IExpr a0) {
        return new AST1(Last, a0);
    }

    public static IAST LCM(IExpr a0, IExpr a1) {
        return new AST2(LCM, a0, a1);
    }

    public static IAST LegendreP(IExpr a0, IExpr a1) {
        return new AST2(LegendreP, a0, a1);
    }

    public static IAST LegendreP(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(LegendreP, a0, a1, a2);
    }

    public static IAST LegendreQ(IExpr a0, IExpr a1) {
        return new AST2(LegendreQ, a0, a1);
    }

    public static IAST LegendreQ(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(LegendreQ, a0, a1, a2);
    }

    public static IAST LeafCount(IExpr expr) {
        return new AST1(LeafCount, expr);
    }

    public static IAST Length(IExpr expr) {
        return new AST1(Length, expr);
    }

    public static IAST Less(IExpr x, IExpr y) {
        return new B2.Less(x, y);
    }

    public static IAST Less(IExpr x, int y) {
        return new B2.Less(x, F.ZZ(y));
    }

    public static IAST Less(IExpr x1, IExpr x2, IExpr x3) {
        return new AST3(Less, x1, x2, x3);
    }

    public static IAST Less(IExpr a0, IExpr a1, IExpr a2, IExpr a3) {
        return F.quaternary(Less, a0, a1, a2, a3);
    }

    public static IAST Less(IExpr a0, IExpr a1, IExpr a2, IExpr a3, IExpr a4) {
        return F.quinary(Less, a0, a1, a2, a3, a4);
    }

    public static IAST LessEqual(IExpr x, IExpr y) {
        return new B2.LessEqual(x, y);
    }

    public static IAST LessEqual(IExpr x, int y) {
        return new B2.LessEqual(x, F.ZZ(y));
    }

    public static IAST LessEqual(IExpr x1, IExpr x2, IExpr x3) {
        return new AST3(LessEqual, x1, x2, x3);
    }

    public static IAST LessEqual(IExpr a0, IExpr a1, IExpr a2, IExpr a3) {
        return F.quaternary(LessEqual, a0, a1, a2, a3);
    }

    public static IAST LeviCivitaTensor(IExpr d) {
        return new AST1(LeviCivitaTensor, d);
    }

    public static IAST Limit(IExpr f, IExpr rule) {
        return new AST2(Limit, f, rule);
    }

    public static IAST Limit(IExpr f, IExpr rule, IExpr direction) {
        return new AST3(Limit, f, rule, direction);
    }

    public static IASTAppendable Line() {
        return F.ast(Line);
    }

    public static IAST Line(IExpr listOfPoints) {
        return new B1.Line(listOfPoints);
    }

    public static IAST LinearModelFit(IExpr a0) {
        return new AST1(LinearModelFit, a0);
    }

    public static IAST LinearModelFit(IExpr a0, IExpr a1) {
        return new AST2(LinearModelFit, a0, a1);
    }

    public static IAST LinearModelFit(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(LinearModelFit, a0, a1, a2);
    }

    public static IAST LinearModelFit(IExpr a0, IExpr a1, IExpr a2, IExpr a3) {
        return F.quaternary(LinearModelFit, a0, a1, a2, a3);
    }

    public static IAST LinearProgramming(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(LinearProgramming, a0, a1, a2);
    }

    public static IAST LinearSolve(IExpr a0, IExpr a1) {
        return new AST2(LinearSolve, a0, a1);
    }

    public static int allocLevel1(IAST ast, Predicate<IExpr> predicate) {
        int allocSize = ast.argSize();
        for (int i = 1; i < ast.size(); ++i) {
            IExpr arg = ast.get(i);
            if (!predicate.test(arg)) continue;
            allocSize += arg.argSize();
        }
        return allocSize;
    }

    public static int allocMin8(IAST ast) {
        return ast.argSize() < 7 ? ast.argSize() : 7;
    }

    public static int allocMin8(int size) {
        return size < 7 ? size : 7;
    }

    public static int allocMin16(IAST ast) {
        return ast.argSize() < 15 ? ast.argSize() : 15;
    }

    public static int allocMin16(int size) {
        return size < 15 ? size : 15;
    }

    public static int allocMin32(IAST ast) {
        return ast.argSize() < 31 ? ast.argSize() : 31;
    }

    public static int allocMin32(int size) {
        return size < 31 ? size : 31;
    }

    public static int allocMin64(IAST ast) {
        return ast.argSize() < 63 ? ast.argSize() : 63;
    }

    public static int allocMax8(IAST ast) {
        return ast.argSize() > 7 ? ast.argSize() : 7;
    }

    public static int allocMax16(IAST ast) {
        return ast.argSize() > 15 ? ast.argSize() : 15;
    }

    public static int allocMax32(IAST ast) {
        return ast.argSize() > 31 ? ast.argSize() : 31;
    }

    public static int allocMax64(IAST ast) {
        return ast.argSize() > 63 ? ast.argSize() : 63;
    }

    public static IASTAppendable ListAlloc() {
        return F.ast((IExpr)List, 3);
    }

    public static IASTAppendable ListAlloc(int initialCapacity) {
        return F.ast((IExpr)List, initialCapacity);
    }

    public static IASTMutable ListAlloc(Collection<? extends IExpr> collection) {
        return F.ListAlloc(collection, 0);
    }

    public static IASTAppendable ListAlloc(Collection<? extends IExpr> collection, int capacity) {
        IASTAppendable result = F.ast((IExpr)List, collection.size() + capacity);
        result.appendAll(collection);
        return result;
    }

    public static IASTAppendable ListAlloc(IExpr ... a) {
        return F.ast(a, List);
    }

    public static IAST TemplateSlot(IExpr a0) {
        return new AST1(TemplateSlot, a0);
    }

    public static IAST TemplateSlot(IExpr a0, IExpr a1) {
        return new AST2(TemplateSlot, a0, a1);
    }

    public static IAST TensorDimensions(IExpr a0) {
        return new AST1(TensorDimensions, a0);
    }

    public static IAST tensorList(int n, Integer ... numbers) {
        int size;
        int nPositive = n;
        if (n < 0) {
            nPositive = -n;
        }
        if (nPositive > (size = numbers.length)) {
            nPositive = size;
        }
        IExpr[] a = new IInteger[nPositive];
        if (n < 0) {
            size = nPositive < size ? (size += n) : 0;
            int j = 0;
            for (int i = numbers.length - 1; i >= size; --i) {
                a[j++] = F.ZZ(numbers[i]);
            }
        } else {
            if (n < size) {
                size = n;
            }
            for (int i = 0; i < size; ++i) {
                a[i] = F.ZZ(numbers[i]);
            }
        }
        return F.ast(a, List);
    }

    public static IASTMutable List(double ... numbers) {
        IExpr[] a = new INum[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            a[i] = F.num(numbers[i]);
        }
        return F.function(List, a);
    }

    public static IASTMutable List(String ... strs) {
        IExpr[] a = new IStringX[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            a[i] = F.stringx(strs[i]);
        }
        return F.function(List, a);
    }

    public static IAST List() {
        return CEmptyList;
    }

    public static IAST listOfObjects(Object ... objects) {
        IExpr[] a = new IExpr[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            a[i] = Object2Expr.convert(objects[i], true, false);
        }
        return F.List(a);
    }

    public static IAST List(IExpr ... a) {
        switch (a.length) {
            case 1: {
                if (a[0] instanceof IntegerSym) {
                    if (a[0].equals(C0)) {
                        return CListC0;
                    }
                    if (a[0].equals(C1)) {
                        return CListC1;
                    }
                    if (a[0].equals(C2)) {
                        return CListC2;
                    }
                }
                return new B1.List(a[0]);
            }
            case 2: {
                if (a[0] instanceof IntegerSym) {
                    if (a[0].equals(C1)) {
                        if (a[1].equals(C1)) {
                            return CListC1C1;
                        }
                        if (a[1].equals(C2)) {
                            return CListC1C2;
                        }
                    } else if (a[0].equals(C2)) {
                        if (a[1].equals(C1)) {
                            return CListC2C1;
                        }
                        if (a[1].equals(C2)) {
                            return CListC2C2;
                        }
                    }
                }
                return new B2.List(a[0], a[1]);
            }
            case 3: {
                return new B3.List(a[0], a[1], a[2]);
            }
        }
        return F.ast(a, List);
    }

    public static IAST list(IExpr expr) {
        return new B1.List(expr);
    }

    public static IAST list(IExpr x1, IExpr x2) {
        return new B2.List(x1, x2);
    }

    public static IAST list(IExpr x1, IExpr x2, IExpr x3) {
        return new B3.List(x1, x2, x3);
    }

    public static IAST List(long ... numbers) {
        IExpr[] a = new IInteger[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            a[i] = F.ZZ(numbers[i]);
        }
        return F.List(a);
    }

    public static IASTMutable List(int ... numbers) {
        IExpr[] a = new IInteger[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            a[i] = F.ZZ(numbers[i]);
        }
        return F.function(List, a);
    }

    public static IAST ListConvolve(IExpr a0, IExpr a1) {
        return new AST2(ListConvolve, a0, a1);
    }

    public static IAST ListPlot(IExpr a) {
        return new AST1(ListPlot, a);
    }

    public static IAST ListPlot3D(IExpr a) {
        return new AST1(ListPlot3D, a);
    }

    public static IAST ListPointPlot3D(IExpr a) {
        return new AST1(ListPointPlot3D, a);
    }

    public static IAST ListQ(IExpr a) {
        return new AST1(ListQ, a);
    }

    @Deprecated
    public static IAST Literal(IExpr a0) {
        return new AST1(Literal, a0);
    }

    public static IAST Log(IExpr z) {
        return new B1.Log(z);
    }

    public static IAST Log(IExpr z, IExpr base) {
        return new AST2(Log, z, base);
    }

    public static IAST Log10(IExpr a0) {
        return new AST2(Log, C10, a0);
    }

    public static IAST LogGamma(IExpr a0) {
        return new AST1(LogGamma, a0);
    }

    public static IAST LogIntegral(IExpr a) {
        return new AST1(LogIntegral, a);
    }

    public static IAST LogisticSigmoid(IExpr a) {
        return new AST1(LogisticSigmoid, a);
    }

    public static IAST LogNormalDistribution(IExpr a0, IExpr a1) {
        return new AST2(LogNormalDistribution, a0, a1);
    }

    public static IAST LucasL(IExpr a) {
        return new AST1(LucasL, a);
    }

    public static IAST LucasL(IExpr a, IExpr b) {
        return new AST2(LucasL, a, b);
    }

    public static IAST MachineNumberQ(IExpr a0) {
        return new AST1(MachineNumberQ, a0);
    }

    public static IAST Manipulate(IExpr a0) {
        return new AST1(Manipulate, a0);
    }

    public static IAST Manipulate(IExpr a0, IExpr a1) {
        return new AST2(Manipulate, a0, a1);
    }

    public static IAST Map(IExpr f) {
        return new AST1(Map, f);
    }

    public static IAST Map(IExpr f, IExpr expr) {
        return new AST2(Map, f, expr);
    }

    public static IAST Map(IExpr f, IExpr expr, IExpr levelspec) {
        return new AST3(Map, f, expr, levelspec);
    }

    public static IAST MapThread(IExpr f, IExpr expr) {
        return new AST2(MapThread, f, expr);
    }

    public static IAST MapAll(IExpr a0) {
        return new AST1(MapAll, a0);
    }

    public static IAST MatchQ(IExpr expr, IExpr form) {
        return new AST2(MatchQ, expr, form);
    }

    public static IAST MathMLForm(IExpr expr) {
        return new AST1(MathMLForm, expr);
    }

    public static IAST MatrixD(IExpr expr, IExpr x) {
        return new AST2(MatrixD, expr, x);
    }

    public static IAST MatrixExp(IExpr a0) {
        return new AST1(MatrixExp, a0);
    }

    public static IAST MatrixLog(IExpr a0) {
        return new AST1(MatrixLog, a0);
    }

    public static IAST MatrixForm(IExpr a0) {
        return new AST1(MatrixForm, a0);
    }

    public static IAST MatrixPower(IExpr matrix, IExpr n) {
        return new AST2(MatrixPower, matrix, n);
    }

    public static IASTAppendable Max() {
        return F.ast(Max);
    }

    public static IAST Max(IExpr a0) {
        return new AST1(Max, a0);
    }

    public static IAST Max(IExpr a0, IExpr a1) {
        return new AST2(Max, a0, a1);
    }

    public static IAST Max(IExpr a0, IExpr a1, IExpr a2, IExpr a3) {
        return F.quaternary(Max, a0, a1, a2, a3);
    }

    public static IAST Maximize(IExpr a0, IExpr a1) {
        return new AST2(Maximize, a0, a1);
    }

    public static IAST Mean(IExpr list) {
        return new AST1(Mean, list);
    }

    public static IAST MeanDeviation(IExpr list) {
        return new AST1(MeanDeviation, list);
    }

    public static IAST Median(IExpr list) {
        return new AST1(Median, list);
    }

    public static IAST MeijerG(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(MeijerG, a0, a1, a2);
    }

    public static IAST MemberQ(IExpr list, IExpr form) {
        return new B2.MemberQ(list, form);
    }

    public static IAST MessageName(IExpr a0, IExpr a1) {
        return new AST2(MessageName, a0, a1);
    }

    public static IAST MessageName(ISymbol symbol, String str) {
        return new AST2(MessageName, symbol, F.$str(str));
    }

    public static IASTAppendable Min() {
        return F.ast(Min);
    }

    public static IAST Min(IExpr a0) {
        return new AST1(Min, a0);
    }

    public static IAST Min(IExpr a0, IExpr a1) {
        return new AST2(Min, a0, a1);
    }

    public static IAST Min(IExpr a0, IExpr a1, IExpr a2, IExpr a3) {
        return F.quaternary(Min, a0, a1, a2, a3);
    }

    public static IAST Minimize(IExpr a0, IExpr a1) {
        return new AST2(Minimize, a0, a1);
    }

    public static IExpr minus(IExpr a, Integer i) {
        return F.Plus((IExpr)F.ZZ(i.longValue() * -1L), a);
    }

    public static IExpr minus(IExpr a, BigInteger i) {
        return F.Plus((IExpr)F.ZZ(i.negate()), a);
    }

    public static IExpr minus(Integer i, IExpr b) {
        return F.Plus((IExpr)F.ZZ(i.longValue()), (IExpr)new B2.Times(CN1, b));
    }

    public static IExpr minus(BigInteger i, IExpr b) {
        return F.Plus((IExpr)F.ZZ(i), (IExpr)new B2.Times(CN1, b));
    }

    public static IAST Missing(IExpr reason) {
        return new B1.Missing(reason);
    }

    public static IAST Missing(String reason) {
        return new B1.Missing(F.stringx(reason));
    }

    public static IAST Missing(IExpr a0, IExpr a1) {
        return new AST2(Missing, a0, a1);
    }

    public static IAST MissingQ(IExpr a0) {
        return new AST1(MissingQ, a0);
    }

    public static IAST MoebiusMu(IExpr a0) {
        return new AST1(MoebiusMu, a0);
    }

    public static IExpr mod(IExpr a, Integer i) {
        return F.Mod(a, F.ZZ(i.longValue()));
    }

    public static IExpr mod(IExpr a, BigInteger i) {
        return F.Mod(a, F.ZZ(i));
    }

    public static IExpr mod(Integer i, IExpr b) {
        return F.Mod(F.ZZ(i.longValue()), b);
    }

    public static IExpr mod(BigInteger i, IExpr b) {
        return F.Mod(F.ZZ(i), b);
    }

    public static IExpr Mod(IExpr a0, IExpr a1) {
        return new AST2(Mod, a0, a1);
    }

    public static IAST Module(IExpr listOfLocalVariables, IExpr expr) {
        return new AST2(Module, listOfLocalVariables, expr);
    }

    public static IAST Most(IExpr a0) {
        return new AST1(Most, a0);
    }

    public static IExpr multiply(IExpr a, Integer i) {
        return new B2.Times(F.ZZ(i.longValue()), a);
    }

    public static IExpr multiply(IExpr a, BigInteger i) {
        return new B2.Times(F.ZZ(i), a);
    }

    public static IExpr multiply(Integer i, IExpr b) {
        return new B2.Times(F.ZZ(i.longValue()), b);
    }

    public static IExpr multiply(BigInteger i, IExpr b) {
        return F.Times((IExpr)F.ZZ(i), b);
    }

    public static IAST Multinomial(IExpr ... a) {
        return F.function(Multinomial, a);
    }

    public static IAST MultiplicativeOrder(IExpr a0, IExpr a1) {
        return new AST2(MultiplicativeOrder, a0, a1);
    }

    public static IASTMutable MultiplySides(IExpr equationOrInequality, IExpr x) {
        return new AST2(MultiplySides, equationOrInequality, x);
    }

    public static IAST N(IExpr a0) {
        return new AST1(N, a0);
    }

    public static IAST NakagamiDistribution(IExpr a0, IExpr a1) {
        return new AST2(NakagamiDistribution, a0, a1);
    }

    public static IAST NameQ(IExpr a0) {
        return new AST1(NameQ, a0);
    }

    public static IAST NameQ(String str) {
        return new AST1(NameQ, F.stringx(str));
    }

    public static IAST Needs(IExpr a0) {
        return new AST1(Needs, a0);
    }

    public static IExpr Negate(IExpr x) {
        if (x.isNumber()) {
            return x.negate();
        }
        if (x.isInfinity()) {
            return CNInfinity;
        }
        if (x.isNegativeInfinity()) {
            return CInfinity;
        }
        return new B2.Times(CN1, x);
    }

    public static IAST Negative(IExpr x) {
        return new AST1(Negative, x);
    }

    public static IAST Nest(IExpr a0, IExpr a1, int n) {
        return F.Nest(a0, a1, F.ZZ(n));
    }

    public static IAST Nest(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(Nest, a0, a1, a2);
    }

    public static IAST newInstance(int intialArgumentsCapacity, IExpr head) {
        return AST.newInstance(intialArgumentsCapacity, head, false);
    }

    public static IAST NewLimit(IExpr f, IExpr rule) {
        return new AST2(NewLimit, f, rule);
    }

    public static IAST NewLimit(IExpr f, IExpr rule, IExpr direction) {
        return new AST3(NewLimit, f, rule, direction);
    }

    public static IAST NMaximize(IExpr a0, IExpr a1) {
        return new AST2(NMaximize, a0, a1);
    }

    public static IAST NMinimize(IExpr a0, IExpr a1) {
        return new AST2(NMinimize, a0, a1);
    }

    public static IAST Norm(IExpr a) {
        return new AST1(Norm, a);
    }

    public static IAST NormalDistribution() {
        return new AST0(NormalDistribution);
    }

    public static IAST NormalDistribution(IExpr a0, IExpr a1) {
        return new AST2(NormalDistribution, a0, a1);
    }

    public static IAST ParetoDistribution(IExpr a0, IExpr a1) {
        return new AST2(ParetoDistribution, a0, a1);
    }

    public static IAST ParetoDistribution(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(ParetoDistribution, a0, a1, a2);
    }

    public static IAST ParetoDistribution(IExpr a0, IExpr a1, IExpr a2, IExpr a3) {
        return F.quaternary(ParetoDistribution, a0, a1, a2, a3);
    }

    public static IAST Normalize(IExpr a) {
        return new AST1(Normalize, a);
    }

    public static IAST Not(IExpr expr) {
        return new B1.Not(expr);
    }

    public static IAST NotElement(IExpr x, IExpr domain) {
        return new AST2(NotElement, x, domain);
    }

    public static IAST NullSpace(IExpr a0) {
        return new AST1(NullSpace, a0);
    }

    public static INum num(Apfloat af) {
        return ApfloatNum.valueOf(af);
    }

    public static INum num(String valueString) {
        EvalEngine engine = EvalEngine.get();
        if (engine.isArbitraryMode()) {
            return ApfloatNum.valueOf(valueString, engine.getNumericPrecision());
        }
        return Num.valueOf(Double.parseDouble(valueString));
    }

    public static INum num(String numberStr, long precision) {
        return F.num(new Apfloat(numberStr, precision));
    }

    public static INum num(double value) {
        return Num.valueOf(value);
    }

    public static INum num(IFraction value) {
        EvalEngine engine = EvalEngine.get();
        if (engine.isArbitraryMode()) {
            return ApfloatNum.valueOf(value.toBigNumerator(), value.toBigDenominator());
        }
        double n = value.toBigNumerator().doubleValue();
        double d = value.toBigDenominator().doubleValue();
        return F.num(n / d);
    }

    public static INum num(IInteger value) {
        EvalEngine engine = EvalEngine.get();
        if (engine.isArbitraryMode()) {
            return ApfloatNum.valueOf(value.toBigNumerator());
        }
        return F.num(value.doubleValue());
    }

    public static IAST NumberQ(IExpr a0) {
        return new AST1(NumberQ, a0);
    }

    public static IAST Numerator(IExpr expr) {
        return new AST1(Numerator, expr);
    }

    public static IAST NumericQ(IExpr a0) {
        return new AST1(NumericQ, a0);
    }

    public static IAST O(IExpr a0) {
        return new AST1(O, a0);
    }

    public static IAST OddQ(IExpr x) {
        return new AST1(OddQ, x);
    }

    public static IAST On(IExpr a0, IExpr a1) {
        return new AST2(On, a0, a1);
    }

    public static IAST On(IExpr a0) {
        return new AST1(On, a0);
    }

    public static IAST OptimizeExpression(IExpr a0) {
        return new AST1(OptimizeExpression, a0);
    }

    public static IAST Optional(IExpr a0, IExpr a1) {
        return new AST2(Optional, a0, a1);
    }

    public static IAST Optional(IExpr a0) {
        return new AST1(Optional, a0);
    }

    public static IAST Options(IExpr a0) {
        return new AST1(Options, a0);
    }

    public static IAST OptionValue(IExpr a0, IExpr a1) {
        return new AST2(OptionValue, a0, a1);
    }

    public static IAST OptionValue(IExpr a0) {
        return new AST1(OptionValue, a0);
    }

    public static IASTAppendable Or() {
        return F.ast(Or);
    }

    public static IAST Or(IExpr expr1, IExpr expr2) {
        return new B2.Or(expr1, expr2);
    }

    public static IAST Or(IExpr expr1, IExpr expr2, IExpr expr3) {
        return new B3.Or(expr1, expr2, expr3);
    }

    public static IAST Or(IExpr ... expr) {
        return F.function(Or, expr);
    }

    public static IAST Order(IExpr a0, IExpr a1) {
        return new AST2(Order, a0, a1);
    }

    public static IAST Ordering(IExpr a) {
        return new AST1(Ordering, a);
    }

    public static IAST OrderedQ(IExpr a) {
        return new AST1(OrderedQ, a);
    }

    public static IAST Out(IExpr a0) {
        return new AST1(Out, a0);
    }

    public static IAST Parenthesis(IExpr a0) {
        return new AST1(Parenthesis, a0);
    }

    public static IASTAppendable Part() {
        return F.ast(Part);
    }

    public static IAST Part(IExpr expr, IExpr i) {
        return new B2.Part(expr, i);
    }

    public static IAST Part(IExpr expr, IExpr i, IExpr j) {
        return new B3.Part(expr, i, j);
    }

    public static IASTAppendable Part(IExpr ... a) {
        return F.Part(0, a);
    }

    public static IASTAppendable Part(int extraSize, IExpr ... a) {
        IASTAppendable part = F.ast((IExpr)Part, a.length + extraSize + 1);
        for (int i = 0; i < a.length; ++i) {
            part.append(a[i]);
        }
        return part;
    }

    public static IAST PartitionsP(IExpr a0) {
        return new AST1(PartitionsP, a0);
    }

    public static IAST PartitionsQ(IExpr a0) {
        return new AST1(PartitionsQ, a0);
    }

    public static IAST PatternTest(IExpr pattern, IExpr test) {
        return new AST2(PatternTest, pattern, test);
    }

    public static IAST PDF(IExpr distribution) {
        return new AST1(PDF, distribution);
    }

    public static IAST PDF(IExpr distribution, IExpr x) {
        return new AST2(PDF, distribution, x);
    }

    public static IAST Piecewise(IExpr listOfConditions) {
        return new AST1(Piecewise, listOfConditions);
    }

    public static IAST Piecewise(IExpr listOfConditions, IExpr defaultValue) {
        return new AST2(Piecewise, listOfConditions, defaultValue);
    }

    public static IAST PiecewiseExpand(IExpr expr) {
        return new AST1(PiecewiseExpand, expr);
    }

    public static IAST Plot(IExpr a0, IExpr a1) {
        return new AST2(Plot, a0, a1);
    }

    public static IAST Plot(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(Plot, a0, a1, a2);
    }

    public static IAST Plot3D(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(Plot3D, a0, a1, a2);
    }

    public static IExpr plus(IExpr a, Integer i) {
        return F.Plus(a, (IExpr)F.ZZ(i.longValue()));
    }

    public static IExpr plus(IExpr a, BigInteger i) {
        return F.Plus(a, (IExpr)F.ZZ(i));
    }

    public static IExpr plus(Integer i, IExpr b) {
        return F.Plus((IExpr)F.ZZ(i.longValue()), b);
    }

    public static IExpr plus(BigInteger i, IExpr b) {
        return F.Plus((IExpr)F.ZZ(i), b);
    }

    public static IASTAppendable Plus() {
        return F.ast(Plus);
    }

    public static IASTAppendable PlusAlloc(int initialCapacity) {
        return F.ast((IExpr)Plus, initialCapacity);
    }

    public static IASTAppendable Plus(IExpr a0) {
        return F.unary(Plus, a0);
    }

    public static IAST Plus(IExpr ... a) {
        switch (a.length) {
            case 1: {
                return new AST1(Plus, a[0]);
            }
            case 2: {
                return new B2.Plus(a[0], a[1]);
            }
            case 3: {
                return new AST3(Plus, a[0], a[1], a[2]);
            }
        }
        return new AST(Plus, a);
    }

    public static IAST Plus(IExpr x, IExpr y) {
        if (x != null && y != null) {
            return F.plusOrderless(IExpr::isPlus, x, y);
        }
        return new B2.Plus(x, y);
    }

    public static IAST Plus(IExpr x, IExpr y, IExpr z) {
        if (x != null && y != null && z != null) {
            return F.plusOrderless(IExpr::isPlus, x, y, z);
        }
        return new B3.Plus(x, y, z);
    }

    public static IAST Plus(long num, IExpr ... a) {
        IASTAppendable ast = F.ast((IExpr)Plus, a.length + 1);
        ast.append(F.ZZ(num));
        ast.appendAll(a, 0, a.length);
        return ast;
    }

    public static IAST Pochhammer(IExpr a0, IExpr a1) {
        return new AST2(Pochhammer, a0, a1);
    }

    public static IAST Point(IAST list) {
        return new B1.Point(list);
    }

    public static IAST PolyGamma(IExpr a0) {
        return new AST1(PolyGamma, a0);
    }

    public static IAST PolyGamma(IExpr a0, IExpr a1) {
        return new AST2(PolyGamma, a0, a1);
    }

    public static IAST Polygon(IExpr a0) {
        return new AST1(Polygon, a0);
    }

    public static IAST PolyLog(IExpr a0, IExpr a1) {
        return new AST2(PolyLog, a0, a1);
    }

    public static IAST PolynomialGCD(IExpr a0, IExpr a1) {
        return new AST2(PolynomialGCD, a0, a1);
    }

    public static IAST PolynomialQ(IExpr expr, IExpr variable) {
        return new B2.PolynomialQ(expr, variable);
    }

    public static IAST PolynomialQuotient(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(PolynomialQuotient, a0, a1, a2);
    }

    public static IAST PolynomialQuotientRemainder(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(PolynomialQuotientRemainder, a0, a1, a2);
    }

    public static IAST PolynomialRemainder(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(PolynomialRemainder, a0, a1, a2);
    }

    public static IAST Position(IExpr a0, IExpr a1) {
        return new AST2(Position, a0, a1);
    }

    public static IAST Positive(IExpr a0) {
        return new AST1(Positive, a0);
    }

    public static IAST PossibleZeroQ(IExpr a0) {
        return new AST1(PossibleZeroQ, a0);
    }

    public static IAST Power(IExpr base, IExpr exponent) {
        return new B2.Power(base, exponent);
    }

    public static IExpr Power(IExpr base, long exponent) {
        if (exponent == 1L) {
            return base;
        }
        if (base.isNumber()) {
            if (exponent > 0L) {
                return base.power(exponent);
            }
            if (exponent == -1L) {
                if (base.isZero()) {
                    LOGGER.log(EvalEngine.get().getLogLevel(), "Infinite expression 0^(-1)");
                    return CComplexInfinity;
                }
                return base.inverse();
            }
            if (exponent == 0L && !base.isZero()) {
                return C1;
            }
        }
        return new B2.Power(base, F.ZZ(exponent));
    }

    public static IAST PowerExpand(IExpr a0) {
        return new AST1(PowerExpand, a0);
    }

    public static IAST PowerMod(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(PowerMod, a0, a1, a2);
    }

    public static ISymbol predefinedSymbol(String symbolName) {
        ISymbol temp = org.matheclipse.core.expression.Context.SYSTEM.get(symbolName);
        if (temp != null) {
            return temp;
        }
        String lcSymbolName = symbolName;
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS && symbolName.length() > 1) {
            lcSymbolName = symbolName.toLowerCase(Locale.ENGLISH);
        }
        temp = new Symbol(lcSymbolName, org.matheclipse.core.expression.Context.SYSTEM);
        org.matheclipse.core.expression.Context.SYSTEM.put(lcSymbolName, temp);
        return temp;
    }

    public static IAST Prepend(IExpr a0, IExpr a1) {
        return new AST2(Prepend, a0, a1);
    }

    public static IAST PrimeOmega(IExpr a0) {
        return new AST1(PrimeOmega, a0);
    }

    public static IAST PrimePi(IExpr a0) {
        return new AST1(PrimePi, a0);
    }

    public static IAST PrimeQ(IExpr a0) {
        return new AST1(PrimeQ, a0);
    }

    public static IAST Print(IExpr ... a) {
        return F.function(Print, a);
    }

    public static IAST Product(IExpr expr, IExpr iterationSpecification) {
        return new AST2(Product, expr, iterationSpecification);
    }

    public static IAST product(Function<IExpr, IExpr> function, int from, int to) {
        return F.intIterator((ISymbol)Times, function, from, to, 1);
    }

    public static IAST ProductLog(IExpr a0) {
        return new AST1(ProductLog, a0);
    }

    public static IAST ProductLog(IExpr a0, IExpr a1) {
        return new AST2(ProductLog, a0, a1);
    }

    public static IAST PseudoInverse(IExpr a0) {
        return new AST1(PseudoInverse, a0);
    }

    public static IFraction QQ(BigFraction frac) {
        return AbstractFractionSym.valueOf(frac);
    }

    public static IFraction QQ(IInteger numerator, IInteger denominator) {
        return AbstractFractionSym.valueOf(numerator, denominator);
    }

    public static IFraction QQ(long numerator, long denominator) {
        return AbstractFractionSym.valueOf(numerator, denominator);
    }

    public static IAST QRDecomposition(IExpr a0) {
        return new AST1(QRDecomposition, a0);
    }

    public static final IASTAppendable quaternary(IExpr head, IExpr a0, IExpr a1, IExpr a2, IExpr a3) {
        return new AST(new IExpr[]{head, a0, a1, a2, a3});
    }

    public static IAST Quantile(IExpr distribution) {
        return new AST1(Quantile, distribution);
    }

    public static IAST Quantile(IExpr list, IExpr q) {
        return new AST2(Quantile, list, q);
    }

    public static IAST Quantile(IExpr list, IExpr q, IExpr definition) {
        return new AST3(Quantile, list, q, definition);
    }

    public static IAST Quantity(IExpr magnitude, IExpr unit) {
        return new AST2(Quantity, magnitude, unit);
    }

    public static IAST QuantityMagnitude(IExpr quantity) {
        return new AST1(QuantityMagnitude, quantity);
    }

    public static IAST QuantityMagnitude(IExpr quantity, IExpr unit) {
        return new AST2(QuantityMagnitude, quantity, unit);
    }

    public static IAST Quartiles(IExpr a0) {
        return new AST1(Quartiles, a0);
    }

    public static IAST Quiet(IExpr a0) {
        return new AST1(Quiet, a0);
    }

    public static final IASTMutable quinary(IExpr head, IExpr a0, IExpr a1, IExpr a2, IExpr a3, IExpr a4) {
        return new AST(new IExpr[]{head, a0, a1, a2, a3, a4});
    }

    public static IAST Quotient(IExpr a0, IExpr a1) {
        return new AST2(Quotient, a0, a1);
    }

    public static IAST Quotient(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(Quotient, a0, a1, a2);
    }

    public static IAST RandomComplex(IExpr a0) {
        return new AST1(RandomComplex, a0);
    }

    public static IAST RandomInteger(IExpr a0) {
        return new AST1(RandomInteger, a0);
    }

    public static IAST RandomReal(IExpr a0) {
        return new AST1(RandomReal, a0);
    }

    public static IAST RandomVariate(IExpr a0) {
        return new AST1(RandomVariate, a0);
    }

    public static IAST RandomVariate(IExpr a0, IExpr a1) {
        return new AST2(RandomVariate, a0, a1);
    }

    public static IAST Range(IExpr a0) {
        return new AST1(Range, a0);
    }

    public static IAST Range(IExpr a0, IExpr a1) {
        return new AST2(Range, a0, a1);
    }

    public static IAST Range(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(Range, a0, a1, a2);
    }

    public static IAST Rational(IExpr a0, IExpr a1) {
        return new AST2(Rational, a0, a1);
    }

    public static IAST Rationalize(IExpr a0) {
        return new AST1(Rationalize, a0);
    }

    public static IAST Rationalize(IExpr a0, IExpr a1) {
        return new AST2(Rationalize, a0, a1);
    }

    public static IExpr Re(IExpr a0) {
        if (a0 != null && a0.isNumber()) {
            return ((INumber)a0).re();
        }
        return new AST1(Re, a0);
    }

    public static IAST RealAbs(IExpr a) {
        return new AST1(RealAbs, a);
    }

    public static IAST RealNumberQ(IExpr a) {
        return new AST1(RealNumberQ, a);
    }

    public static IAST RealSign(IExpr a) {
        return new AST1(RealSign, a);
    }

    public static IAST Reap(IExpr a) {
        return new AST1(Reap, a);
    }

    public static IAST Refine(IExpr a) {
        return new AST1(Refine, a);
    }

    public static IAST Refine(IExpr a0, IExpr a1) {
        return new AST2(Refine, a0, a1);
    }

    public static IAST RegularExpression(IExpr a0) {
        return new AST1(RegularExpression, a0);
    }

    public static IAST RegularExpression(String str) {
        return new AST1(RegularExpression, F.$str(str));
    }

    public static IAST Replace(IExpr a0, IExpr a1) {
        return new AST2(Replace, a0, a1);
    }

    public static IAST ReplaceAll(IExpr a0, IExpr a1) {
        return new AST2(ReplaceAll, a0, a1);
    }

    public static IAST ReplaceList(IExpr a0, IExpr a1) {
        return new AST2(ReplaceList, a0, a1);
    }

    public static IAST ReplacePart(IExpr a0, IExpr a1) {
        return new AST2(ReplacePart, a0, a1);
    }

    public static IAST ReplacePart(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(ReplacePart, a0, a1, a2);
    }

    public static IAST ReplaceRepeated(IExpr a0, IExpr a1) {
        return new AST2(ReplaceRepeated, a0, a1);
    }

    public static IAST Rest(IExpr a0) {
        return new AST1(Rest, a0);
    }

    public static IAST Resultant(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(Resultant, a0, a1, a2);
    }

    public static IAST RGBColor(IExpr red, IExpr green, IExpr blue) {
        return new AST3(RGBColor, red, green, blue);
    }

    public static IAST RGBColor(double red, double green, double blue) {
        return new AST3(RGBColor, F.num(red), F.num(green), F.num(blue));
    }

    public static ISymbol symbol(String symbolName) {
        return F.symbol(symbolName, null, EvalEngine.get());
    }

    public static ISymbol symbol(String symbolName, EvalEngine engine) {
        return F.symbol(symbolName, null, engine);
    }

    public static ISymbol symbol(String symbolName, IAST assumptionAST) {
        return F.symbol(symbolName, assumptionAST, EvalEngine.get());
    }

    public static ISymbol symbol(String symbolName, IAST assumptionAST, EvalEngine engine) {
        IExpr temp;
        ISymbol symbol = engine.getContextPath().symbol(symbolName, engine.getContext(), engine.isRelaxedSyntax());
        if (assumptionAST != null && (temp = Lambda.replaceSlots(assumptionAST, F.List(symbol)).orElse(assumptionAST)).isAST()) {
            IAssumptions assumptions = engine.getAssumptions();
            if (assumptions == null) {
                assumptions = org.matheclipse.core.eval.util.Assumptions.getInstance(temp);
                engine.setAssumptions(assumptions);
            } else {
                assumptions.addAssumption(temp);
            }
        }
        return symbol;
    }

    public static boolean hasSymbol(String symbolName, EvalEngine engine) {
        return engine.getContextPath().hasSymbol(symbolName, engine.isRelaxedSyntax());
    }

    public static ISymbol symbol(String symbolName, String contextStr, IAST assumptionAST, EvalEngine engine) {
        IExpr temp;
        if (contextStr.length() == 0) {
            return F.symbol(symbolName, assumptionAST, engine);
        }
        ContextPath contextPath = engine.getContextPath();
        Context context = contextPath.getContext(contextStr);
        ISymbol symbol = ContextPath.getSymbol(symbolName, context, engine.isRelaxedSyntax());
        if (assumptionAST != null && (temp = Lambda.replaceSlots(assumptionAST, F.List(symbol)).orElse(assumptionAST)).isAST()) {
            IAssumptions assumptions = engine.getAssumptions();
            if (assumptions == null) {
                assumptions = org.matheclipse.core.eval.util.Assumptions.getInstance(temp);
                engine.setAssumptions(assumptions);
            } else {
                assumptions.addAssumption(temp);
            }
        }
        return symbol;
    }

    public static ISymbol symbol(Context context, String symbolName, EvalEngine engine) {
        return ContextPath.getSymbol(symbolName, context, engine.isRelaxedSyntax());
    }

    public static final String usage(ISymbol head) {
        return F.usage(head.toString());
    }

    public static final String usage(String symbolName) {
        StringBuilder buf = new StringBuilder();
        Documentation.usageDocumentation(buf, symbolName);
        return buf.toString();
    }

    public static ISymbol Dummy(String symbolName) {
        String name = symbolName;
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS && symbolName.length() != 1) {
            name = symbolName.toLowerCase(Locale.ENGLISH);
        }
        return new Symbol(name, org.matheclipse.core.expression.Context.DUMMY);
    }

    public static ISymbol Dummy() {
        return F.Dummy(EvalEngine.uniqueName("$"));
    }

    public static IBuiltInSymbol localBiFunction(String symbolName, final BiFunction<IExpr, IExpr, IExpr> function) {
        BuiltInSymbol localBuittIn = new BuiltInSymbol(symbolName, java.lang.Integer.MAX_VALUE);
        localBuittIn.setEvaluator(new AbstractCoreFunctionEvaluator(){

            @Override
            public IExpr evaluate(IAST ast, EvalEngine engine) {
                return (IExpr)function.apply(ast.arg1(), ast.arg2());
            }
        });
        return localBuittIn;
    }

    public static IBuiltInSymbol localFunction(String symbolName, final Function<IExpr, IExpr> function) {
        return F.localFunction(symbolName, new AbstractCoreFunctionEvaluator(){

            @Override
            public IExpr evaluate(IAST ast, EvalEngine engine) {
                return (IExpr)function.apply(ast.arg1());
            }
        });
    }

    public static IBuiltInSymbol localFunction(String symbolName, IEvaluator evaluator) {
        BuiltInDummy localBuiltIn = new BuiltInDummy(symbolName);
        localBuiltIn.setEvaluator(evaluator);
        return localBuiltIn;
    }

    public static IBuiltInSymbol localBiPredicate(String symbolName, final BiPredicate<IExpr, IExpr> function) {
        return F.localFunction(symbolName, new AbstractCoreFunctionEvaluator(){

            @Override
            public IExpr evaluate(IAST ast, EvalEngine engine) {
                return F.bool(function.test(ast.arg1(), ast.arg2()));
            }
        });
    }

    public static IBuiltInSymbol localPredicate(String symbolName, final Predicate<IExpr> function) {
        return F.localFunction(symbolName, new AbstractCoreFunctionEvaluator(){

            @Override
            public IExpr evaluate(IAST ast, EvalEngine engine) {
                return F.bool(function.test(ast.arg1()));
            }
        });
    }

    public static ISymbol removeUserSymbol(String symbolName) {
        ContextPath contextPath = EvalEngine.get().getContextPath();
        return contextPath.removeSymbol(symbolName);
    }

    public static IAST Return(IExpr a) {
        if (a.isFalse()) {
            return CReturnFalse;
        }
        if (a.isTrue()) {
            return CReturnTrue;
        }
        return new AST1(Return, a);
    }

    public static IAST Reverse(IExpr a) {
        return new AST1(Reverse, a);
    }

    public static IAST RomanNumeral(IExpr a) {
        return new AST1(RomanNumeral, a);
    }

    public static IAST Root(IExpr function, IExpr k) {
        return new AST2(Root, function, k);
    }

    public static IAST Root(IExpr function, int k) {
        return new AST2(Root, function, F.ZZ(k));
    }

    public static IAST Roots(IExpr a0) {
        return new AST1(Roots, a0);
    }

    public static IAST Roots(IExpr a0, IExpr a1) {
        return new AST2(Roots, a0, a1);
    }

    public static IAST Round(IExpr x) {
        return new AST1(Round, x);
    }

    public static IAST RowBox(IAST list) {
        return new AST1(RowBox, list);
    }

    public static IAST RowReduce(IExpr m) {
        return new AST1(RowReduce, m);
    }

    public static IAST Rule(String lhsStr, IExpr rhs) {
        return new B2.Rule(F.$str(lhsStr), rhs);
    }

    public static IAST Rule(String lhsStr, String rhsStr) {
        return new B2.Rule(F.$str(lhsStr), F.$str(rhsStr));
    }

    public static IAST Rule(IExpr lhs, IExpr rhs) {
        return new B2.Rule(lhs, rhs);
    }

    public static IAST Rule(IExpr lhs, String rhsStr) {
        return new B2.Rule(lhs, F.$str(rhsStr));
    }

    public static IAST RuleDelayed(IExpr lhs, IExpr rhs) {
        return new B2.RuleDelayed(lhs, rhs);
    }

    public static IAST SameQ(IExpr lhs, IExpr rhs) {
        return new B2.SameQ(lhs, rhs);
    }

    public static IAST SatisfiabilityInstances(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(SatisfiabilityInstances, a0, a1, a2);
    }

    public static IAST SameQ(IExpr a0, double d) {
        return new AST2(SameQ, a0, F.num(d));
    }

    public static IAST Scan(IExpr a0, IExpr a1) {
        return new AST2(Scan, a0, a1);
    }

    public static IAST Sec(IExpr z) {
        return new AST1(Sec, z);
    }

    public static IAST Sech(IExpr z) {
        return new AST1(Sech, z);
    }

    public static IAST Select(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(Select, a0, a1, a2);
    }

    public static IAST Select(IExpr a0, IExpr a1) {
        return new AST2(Select, a0, a1);
    }

    public static final IAST senary(IExpr head, IExpr a0, IExpr a1, IExpr a2, IExpr a3, IExpr a4, IExpr a5) {
        return new AST(new IExpr[]{head, a0, a1, a2, a3, a4, a5});
    }

    public static IASTAppendable Sequence() {
        return F.ast(Sequence);
    }

    public static IAST Sequence(IExpr a0) {
        return F.unary(Sequence, a0);
    }

    public static IAST Sequence(IExpr ... a) {
        return F.function(Sequence, a);
    }

    public static IASTMutable Sequence(int ... numbers) {
        IExpr[] a = new IInteger[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            a[i] = F.ZZ(numbers[i]);
        }
        return F.function(Sequence, a);
    }

    public static IAST Series(IExpr ... a) {
        return F.function(Series, a);
    }

    public static IAST SeriesCoefficient(IExpr a0, IExpr a1) {
        return new AST2(SeriesCoefficient, a0, a1);
    }

    public static IAST SeriesData(IExpr ... a) {
        return F.function(SeriesData, a);
    }

    public static IAST Set(IExpr lhs, IExpr rhs) {
        return new B2.B2Set(lhs, rhs);
    }

    public static IAST SetAttributes(IExpr symbol, IExpr attribute) {
        return new AST2(SetAttributes, symbol, attribute);
    }

    public static IAST SetDelayed(IExpr lhs, IExpr rhs) {
        return new AST2(SetDelayed, lhs, rhs);
    }

    public static IAST Show(IExpr a0) {
        return new AST1(Show, a0);
    }

    public static IAST Sign(IExpr z) {
        return new AST1(Sign, z);
    }

    public static IAST Signature(IExpr a) {
        return new AST1(Signature, a);
    }

    public static IAST SignCmp(IExpr z) {
        return new AST1(SignCmp, z);
    }

    public static IAST Simplify(IExpr expr) {
        return new AST1(Simplify, expr);
    }

    public static IAST Simplify(IExpr expr, IExpr assum) {
        return new AST2(Simplify, expr, assum);
    }

    public static IAST Sin(IExpr z) {
        return new B1.Sin(z);
    }

    public static IAST Sinc(IExpr z) {
        return new AST1(Sinc, z);
    }

    public static IAST Sinh(IExpr z) {
        return new AST1(Sinh, z);
    }

    public static IAST SinhIntegral(IExpr z) {
        return new AST1(SinhIntegral, z);
    }

    public static IAST SinIntegral(IExpr z) {
        return new AST1(SinIntegral, z);
    }

    public static IAST Skewness(IExpr a0) {
        return new AST1(Skewness, a0);
    }

    public static IAST Slot(IExpr a0) {
        return new AST1(Slot, a0);
    }

    public static IAST Slot(int i) {
        return new AST1(Slot, F.ZZ(i));
    }

    public static IAST SlotSequence(int i) {
        return new AST1(SlotSequence, F.ZZ(i));
    }

    public static IAST Solve(IExpr a0, IExpr a1) {
        return new AST2(Solve, a0, a1);
    }

    public static IExpr[] solve(IAST equations, ISymbol variable) {
        IExpr solve = Solve.of(equations, variable);
        if (!solve.isListOfLists()) {
            return new IExpr[0];
        }
        IExpr[] result = new IExpr[solve.size() - 1];
        int j = 0;
        for (int i = 1; i < solve.size(); ++i) {
            IAST listRule = (IAST)solve.getAt(i);
            if (!listRule.first().isRule()) continue;
            IAST rule = (IAST)listRule.first();
            result[j++] = rule.second();
        }
        if (j < solve.size() - 1) {
            IExpr[] newResult = new IExpr[j];
            System.arraycopy(result, 0, newResult, 0, j);
            return newResult;
        }
        return result;
    }

    public static IAST Sort(IExpr a0, IExpr a1) {
        return new AST2(Sort, a0, a1);
    }

    public static IAST Sow(IExpr a) {
        return new AST1(Sow, a);
    }

    public static IAST Span(IExpr ... a) {
        return F.function(Span, a);
    }

    public static IAST Sphere(IExpr vector, IExpr radius) {
        return new AST2(Sphere, vector, radius);
    }

    public static IAST SphericalBesselJ(IExpr n, IExpr z) {
        return new AST2(SphericalBesselJ, n, z);
    }

    public static IAST SphericalBesselY(IExpr n, IExpr z) {
        return new AST2(SphericalBesselY, n, z);
    }

    public static IAST SphericalHankelH1(IExpr n, IExpr z) {
        return new AST2(SphericalHankelH1, n, z);
    }

    public static IAST SphericalHankelH2(IExpr n, IExpr z) {
        return new AST2(SphericalHankelH2, n, z);
    }

    public static IAST SphericalHarmonicY(IExpr a0, IExpr a1, IExpr a2, IExpr a3) {
        return F.function(SphericalHarmonicY, a0, a1, a2, a3);
    }

    public static IAST Sqr(IExpr x) {
        return new B2.Power(x, C2);
    }

    public static IAST Sqrt(IExpr x) {
        return new B2.Power(x, C1D2);
    }

    public static IAST Sqrt(int n) {
        return new B2.Power(F.ZZ(n), C1D2);
    }

    public static IAST StandardDeviation(IExpr a0) {
        return new AST1(StandardDeviation, a0);
    }

    public static IAST Standardize(IExpr a0) {
        return new AST1(Standardize, a0);
    }

    public static IAST StieltjesGamma(IExpr a0) {
        return new AST1(StieltjesGamma, a0);
    }

    public static IAST StieltjesGamma(IExpr a0, IExpr a1) {
        return new AST2(StieltjesGamma, a0, a1);
    }

    public static IAST StirlingS1(IExpr n, IExpr m) {
        return new AST2(StirlingS1, n, m);
    }

    public static IAST StirlingS2(IExpr n, IExpr m) {
        return new AST2(StirlingS2, n, m);
    }

    public static IAST StringJoin(IExpr a) {
        return new AST1(StringJoin, a);
    }

    public static IAST Surd(IExpr a0, IExpr a1) {
        return new AST2(Surd, a0, a1);
    }

    public static final IStringX stringx(char c) {
        return StringX.valueOf(c);
    }

    public static final IStringX stringx(String str) {
        return StringX.valueOf(str);
    }

    public static final IStringX stringx(String str, short mimeType) {
        return StringX.valueOf(str, mimeType);
    }

    public static final IStringX stringx(StringBuilder str) {
        return StringX.valueOf(str);
    }

    public static IAST StruveH(IExpr a0, IExpr a1) {
        return new AST2(StruveH, a0, a1);
    }

    public static IAST StruveL(IExpr a0, IExpr a1) {
        return new AST2(StruveL, a0, a1);
    }

    public static IAST StudentTDistribution(IExpr a0) {
        return new AST1(StudentTDistribution, a0);
    }

    public static IAST StudentTDistribution(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(StudentTDistribution, a0, a1, a2);
    }

    public static IAST Style(IExpr a0, IExpr a1) {
        return new AST2(Style, a0, a1);
    }

    public static IAST Subdivide(IExpr a0) {
        return new AST1(Subdivide, a0);
    }

    public static IAST Subdivide(IExpr a0, IExpr a1) {
        return new AST2(Subdivide, a0, a1);
    }

    public static IAST Subdivide(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(Subdivide, a0, a1, a2);
    }

    public static IAST Subfactorial(IExpr a0) {
        return new AST1(Subfactorial, a0);
    }

    public static IAST Subscript(IExpr x, IExpr y) {
        return new AST2(Subscript, x, y);
    }

    public static IExpr subs(IExpr expr, IExpr x, IExpr y) {
        return expr.replaceAll(F.Rule(x, y)).orElse(expr);
    }

    public static IExpr subst(IExpr expr, Function<IExpr, IExpr> function) {
        return expr.replaceAll(function).orElse(expr);
    }

    public static IExpr subst(IExpr expr, Map<? extends IExpr, ? extends IExpr> map) {
        return expr.replaceAll(map).orElse(expr);
    }

    public static IExpr subst(IExpr expr, IAST astRules) {
        if (astRules.isListOfLists()) {
            IExpr result = expr;
            for (IExpr subList : astRules) {
                result = F.subst(result, (IAST)subList);
            }
            return result;
        }
        return expr.replaceAll(astRules).orElse(expr);
    }

    public static IExpr subst(IExpr expr, IExpr subExpr, IExpr replacementExpr) {
        return expr.replaceAll(Functors.rules(F.Rule(subExpr, replacementExpr), EvalEngine.get())).orElse(expr);
    }

    public static IAST Subtract(IExpr x, IExpr y) {
        return new B2.Plus(x, new B2.Times(CN1, y));
    }

    public static IASTMutable SubtractSides(IExpr equationOrInequality) {
        return new AST1(SubtractSides, equationOrInequality);
    }

    public static IASTMutable SubtractSides(IExpr equationOrInequality, IExpr x) {
        return new AST2(SubtractSides, equationOrInequality, x);
    }

    public static IAST Sum(IExpr expr, IExpr iterationSpecification) {
        return new AST2(Sum, expr, iterationSpecification);
    }

    public static IAST Sum(IExpr expr, IExpr iterationSpecification1, IExpr iterationSpecification2) {
        return new AST3(Sum, expr, iterationSpecification1, iterationSpecification2);
    }

    public static IAST Sum(IExpr expr, IExpr iterationSpecification1, IExpr iterationSpecification2, IExpr iterationSpecification3) {
        return F.quaternary(Sum, expr, iterationSpecification1, iterationSpecification2, iterationSpecification3);
    }

    public static IRational sumRational(IntFunction<IRational> function, int iMin, int iMax) {
        return F.sumRational(function, iMin, iMax, 1);
    }

    public static IAST sum(Function<IExpr, IExpr> function, int iMin, int iMax) {
        return F.intIterator((ISymbol)Plus, function, iMin, iMax, 1);
    }

    public static IAST intSum(IntFunction<IExpr> function, int iMin, int iMax) {
        return F.intIterator((ISymbol)Plus, function, iMin, iMax, 1);
    }

    public static IAST sum(Function<IExpr, IExpr> function, int iMin, int iMax, int iStep) {
        return F.intIterator((ISymbol)Plus, function, iMin, iMax, iStep);
    }

    public static IAST Superscript(IExpr x, IExpr y) {
        return new AST2(Superscript, x, y);
    }

    public static IASTAppendable SurfaceGraphics() {
        return F.ast(SurfaceGraphics);
    }

    public static IAST Switch(IExpr ... a) {
        return F.function(Switch, a);
    }

    public static IAST Table(IExpr expr, IExpr iterationSpecification) {
        return new AST2(Table, expr, iterationSpecification);
    }

    public static IASTMutable TagSet(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(TagSet, a0, a1, a2);
    }

    public static IASTMutable TagSetDelayed(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(TagSetDelayed, a0, a1, a2);
    }

    public static IAST Take(IExpr a0, IExpr a1) {
        return new AST2(Take, a0, a1);
    }

    public static IASTMutable TakeLargest(IExpr a0, IExpr a1) {
        return new AST2(TakeLargest, a0, a1);
    }

    public static IASTMutable TakeLargestBy(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(TakeLargestBy, a0, a1, a2);
    }

    public static IASTMutable TakeSmallest(IExpr a0, IExpr a1) {
        return new AST2(TakeSmallest, a0, a1);
    }

    public static IASTMutable TakeSmallestBy(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(TakeSmallestBy, a0, a1, a2);
    }

    public static IAST Tan(IExpr z) {
        return new B1.Tan(z);
    }

    public static IAST Tanh(IExpr z) {
        return new AST1(Tanh, z);
    }

    public static IAST Taylor(IExpr a0, IExpr a1) {
        return new AST2(Taylor, a0, a1);
    }

    public static IAST TensorRank(IExpr a0) {
        return new AST1(TensorRank, a0);
    }

    public static IAST TensorSymmetry(IExpr a0) {
        return new AST1(TensorSymmetry, a0);
    }

    public static IAST TensorSymmetry(IExpr a0, IExpr a1) {
        return new AST2(TensorSymmetry, a0, a1);
    }

    public static IAST TeXForm(IExpr expr) {
        return new AST1(TeXForm, expr);
    }

    public static final IASTMutable ternaryAST3(IExpr head, IExpr arg1, IExpr arg2, IExpr arg3) {
        return new AST3(head, arg1, arg2, arg3);
    }

    public static IAST Thread(IExpr a0) {
        return new AST1(Thread, a0);
    }

    public static IAST Throw(IExpr a) {
        if (a.isFalse()) {
            return CThrowFalse;
        }
        if (a.isTrue()) {
            return CThrowTrue;
        }
        return new AST1(Throw, a);
    }

    public static IAST TimeConstrained(IExpr a0, IExpr a1) {
        return new AST2(TimeConstrained, a0, a1);
    }

    public static IAST TimeConstrained(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(TimeConstrained, a0, a1, a2);
    }

    public static IASTAppendable Times() {
        return F.ast(Times);
    }

    public static IASTAppendable TimesAlloc(int initialCapacity) {
        return F.ast((IExpr)Times, initialCapacity);
    }

    public static IASTAppendable Times(IExpr x) {
        return F.unary(Times, x);
    }

    public static IAST Times(IExpr ... a) {
        switch (a.length) {
            case 1: {
                return new AST1(Times, a[0]);
            }
            case 2: {
                return new B2.Times(a[0], a[1]);
            }
            case 3: {
                return new AST3(Times, a[0], a[1], a[2]);
            }
        }
        return new AST(Times, a);
    }

    public static IASTMutable Times(IExpr x, IExpr y) {
        if (x != null && y != null) {
            return F.timesOrderless(IExpr::isTimes, x, y);
        }
        return new B2.Times(x, y);
    }

    public static IAST Times(IExpr x, IExpr y, IExpr z) {
        if (x != null && y != null && z != null) {
            return F.timesOrderless(IExpr::isTimes, x, y, z);
        }
        return new B3.Times(x, y, z);
    }

    private static IASTMutable plusOrderless(Predicate<IExpr> t, IExpr a1, IExpr a2) {
        boolean test1 = t.test(a1);
        boolean test2 = t.test(a2);
        if (test1 || test2) {
            int size = test1 ? a1.size() : 1;
            IASTAppendable result = F.ast((IExpr)Plus, size += test2 ? a2.size() : 1);
            if (test1) {
                result.appendArgs((IAST)a1);
            } else {
                result.append(a1);
            }
            if (test2) {
                result.appendArgs((IAST)a2);
            } else {
                result.append(a2);
            }
            EvalAttributes.sort(result);
            return result;
        }
        if (a1.compareTo(a2) > 0) {
            return new B2.Plus(a2, a1);
        }
        return new B2.Plus(a1, a2);
    }

    private static IASTMutable plusOrderless(Predicate<IExpr> t, IExpr a1, IExpr a2, IExpr a3) {
        boolean test1 = t.test(a1);
        boolean test2 = t.test(a2);
        boolean test3 = t.test(a3);
        if (test1 || test2 || test3) {
            int size = test1 ? a1.size() : 1;
            size += test2 ? a2.size() : 1;
            IASTAppendable result = F.ast((IExpr)Plus, size += test3 ? a3.size() : 1);
            if (test1) {
                result.appendArgs((IAST)a1);
            } else {
                result.append(a1);
            }
            if (test2) {
                result.appendArgs((IAST)a2);
            } else {
                result.append(a2);
            }
            if (test3) {
                result.appendArgs((IAST)a3);
            } else {
                result.append(a3);
            }
            EvalAttributes.sort(result);
            return result;
        }
        B3.Plus result = new B3.Plus(a1, a2, a3);
        EvalAttributes.sort(result);
        return result;
    }

    private static IASTMutable timesOrderless(Predicate<IExpr> t, IExpr a1, IExpr a2) {
        boolean test1 = t.test(a1);
        boolean test2 = t.test(a2);
        if (test1 || test2) {
            int size = test1 ? a1.size() : 1;
            IASTAppendable result = F.ast((IExpr)Times, size += test2 ? a2.size() : 1);
            if (test1) {
                result.appendArgs((IAST)a1);
            } else {
                result.append(a1);
            }
            if (test2) {
                result.appendArgs((IAST)a2);
            } else {
                result.append(a2);
            }
            EvalAttributes.sort(result);
            return result;
        }
        if (a1.compareTo(a2) > 0) {
            return new B2.Times(a2, a1);
        }
        return new B2.Times(a1, a2);
    }

    private static IASTMutable timesOrderless(Predicate<IExpr> t, IExpr a1, IExpr a2, IExpr a3) {
        boolean test1 = t.test(a1);
        boolean test2 = t.test(a2);
        boolean test3 = t.test(a3);
        if (test1 || test2 || test3) {
            int size = test1 ? a1.size() : 1;
            size += test2 ? a2.size() : 1;
            IASTAppendable result = F.ast((IExpr)Times, size += test3 ? a3.size() : 1);
            if (test1) {
                result.appendArgs((IAST)a1);
            } else {
                result.append(a1);
            }
            if (test2) {
                result.appendArgs((IAST)a2);
            } else {
                result.append(a2);
            }
            if (test3) {
                result.appendArgs((IAST)a3);
            } else {
                result.append(a3);
            }
            EvalAttributes.sort(result);
            return result;
        }
        B3.Times result = new B3.Times(a1, a2, a3);
        EvalAttributes.sort(result);
        return result;
    }

    public static IAST Times(long num, IExpr ... a) {
        IASTAppendable ast = F.ast((IExpr)Times, a.length + 1);
        ast.append(F.ZZ(num));
        ast.appendAll(a, 0, a.length);
        return ast;
    }

    public static IAST ToExpression(IExpr a0) {
        return new AST1(ToExpression, a0);
    }

    public static IAST Together(IExpr a0) {
        return new AST1(Together, a0);
    }

    public static IAST Total(IExpr a0) {
        return new AST1(Total, a0);
    }

    public static IAST Tr(IExpr a0) {
        return new AST1(Tr, a0);
    }

    public static IAST Trace(IExpr a0) {
        return new AST1(Trace, a0);
    }

    public static IAST Transpose(IExpr list) {
        return new AST1(Transpose, list);
    }

    public static IAST TrigExpand(IExpr expr) {
        return new AST1(TrigExpand, expr);
    }

    public static IAST TrigReduce(IExpr expr) {
        return new AST1(TrigReduce, expr);
    }

    public static IAST TrigToExp(IExpr expr) {
        return new AST1(TrigToExp, expr);
    }

    public static IAST TrueQ(IExpr expr) {
        return new AST1(TrueQ, expr);
    }

    public static final IASTAppendable unary(IExpr head, IExpr arg) {
        return new AST(new IExpr[]{head, arg});
    }

    public static final IASTMutable unaryAST1(IExpr head, IExpr arg) {
        return new AST1(head, arg);
    }

    public static IAST UndirectedEdge(IExpr a, IExpr b) {
        return new B2.UndirectedEdge(a, b);
    }

    public static IAST Unequal(IExpr lhs, IExpr rhs) {
        return new AST2(Unequal, lhs, rhs);
    }

    public static IAST Unevaluated(IExpr a0) {
        return new AST1(Unevaluated, a0);
    }

    public static IAST Union(IExpr list1) {
        return new AST1(Union, list1);
    }

    public static IAST Union(IExpr list1, IExpr list2) {
        return new AST2(Union, list1, list2);
    }

    public static IAST Unique(IExpr a0) {
        return new AST1(Unique, a0);
    }

    public static IAST UnitConvert(IExpr quantity) {
        return new AST1(UnitConvert, quantity);
    }

    public static IAST UnitConvert(IExpr quantity, IExpr unit) {
        return new AST2(UnitConvert, quantity, unit);
    }

    public static IAST UniformDistribution(IExpr a) {
        return new AST1(UniformDistribution, a);
    }

    public static IAST UnitStep(IExpr a0) {
        return new AST1(UnitStep, a0);
    }

    public static IAST UnsameQ(IExpr lhs, IExpr rhs) {
        return new AST2(UnsameQ, lhs, rhs);
    }

    public static IAST Unset(IExpr a0) {
        return new AST1(Unset, a0);
    }

    public static IAST UpSet(IExpr a0, IExpr a1) {
        return new AST2(UpSet, a0, a1);
    }

    public static IAST UpSetDelayed(IExpr a0, IExpr a1) {
        return new AST2(UpSetDelayed, a0, a1);
    }

    public static IAST Variables(IExpr a0) {
        return new AST1(Variables, a0);
    }

    public static IAST Variance(IExpr a0) {
        return new AST1(Variance, a0);
    }

    public static IAST WeberE(IExpr v, IExpr z) {
        return new AST2(WeberE, v, z);
    }

    public static IAST WeberE(IExpr v, IExpr m, IExpr z) {
        return new AST3(WeberE, v, m, z);
    }

    public static IAST WeibullDistribution(IExpr a0, IExpr a1) {
        return new AST2(WeibullDistribution, a0, a1);
    }

    public static IAST WeibullDistribution(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(WeibullDistribution, a0, a1, a2);
    }

    public static IAST While(IExpr test, IExpr body) {
        return new AST2(While, test, body);
    }

    public static IAST WhittakerM(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(WhittakerM, a0, a1, a2);
    }

    public static IAST WhittakerW(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(WhittakerW, a0, a1, a2);
    }

    public static IAST With(IExpr listOfLocalVariables, IExpr expr) {
        return new B2.With(listOfLocalVariables, expr);
    }

    public static IAST ZeroSymmetric(IExpr a0) {
        return new AST1(ZeroSymmetric, a0);
    }

    public static IAST Zeta(IExpr s) {
        return new AST1(Zeta, s);
    }

    public static IAST Zeta(IExpr s, IExpr a) {
        return new AST2(Zeta, s, a);
    }

    public static IInteger ZZ(BigInteger integerValue) {
        return AbstractIntegerSym.valueOf(integerValue);
    }

    public static IInteger ZZ(int integerValue) {
        return AbstractIntegerSym.valueOf(integerValue);
    }

    public static IInteger ZZUniqueReference(int integerValue) {
        return AbstractIntegerSym.valueOfUniqueReference(integerValue);
    }

    public static IInteger ZZ(long integerValue) {
        return AbstractIntegerSym.valueOf(integerValue);
    }

    public static IInteger ZZ(String integerString, int radix) {
        return AbstractIntegerSym.valueOf(integerString, radix);
    }

    public static IAST operatorForm1Append(IAST ast1) {
        if (ast1.isAST1() && ast1.head().isAST() && ast1.head().size() > 1) {
            IAST head = (IAST)ast1.head();
            switch (head.size()) {
                case 2: {
                    return new AST2(ast1.topHead(), ast1.arg1(), head.arg1());
                }
                case 3: {
                    return new AST3(ast1.topHead(), ast1.arg1(), head.arg1(), head.arg2());
                }
            }
            IASTAppendable result = F.ast((IExpr)ast1.topHead(), head.size() + 1);
            result.append(ast1.arg1());
            result.appendArgs(head);
            return result;
        }
        return NIL;
    }

    public static IAST operatorFormAppend2(IAST astArg) {
        if (astArg.head().isAST2() && astArg.isAST1()) {
            return new AST3(astArg.topHead(), astArg.arg1(), ((IAST)astArg.head()).arg1(), ((IAST)astArg.head()).arg2());
        }
        return NIL;
    }

    public static IAST operatorForm2Prepend(IAST ast1, int[] expected, EvalEngine engine) {
        if (ast1.head().isAST1() && ast1.argSize() > 0) {
            if (ast1.argSize() + 1 < expected[0] || ast1.argSize() + 1 > expected[1]) {
                return IOFunctions.printArgMessage(ast1, expected, engine);
            }
            IExpr headArg1 = ast1.head().first();
            switch (ast1.size()) {
                case 2: {
                    return new AST2(ast1.topHead(), headArg1, ast1.arg1());
                }
                case 3: {
                    return new AST3(ast1.topHead(), headArg1, ast1.arg1(), ast1.arg2());
                }
            }
            IASTAppendable result = F.ast((IExpr)ast1.topHead(), ast1.size() + 1);
            result.append(headArg1);
            result.appendArgs(ast1);
            return result;
        }
        return NIL;
    }

    public static IAST Matrices(IExpr a0, IExpr a1, IExpr a2) {
        return new AST3(Matrices, a0, a1, a2);
    }

    public static IAST Matrices(IExpr a0, IExpr a1) {
        return new AST2(Matrices, a0, a1);
    }

    public static IAST Matrices(IExpr a0) {
        return new AST1(Matrices, a0);
    }

    public static IAST matrix(BiIntFunction<? extends IExpr> biFunction, int n, int m) {
        if (n > Config.MAX_MATRIX_DIMENSION_SIZE || m > Config.MAX_MATRIX_DIMENSION_SIZE) {
            ASTElementLimitExceeded.throwIt((long)n * (long)m);
        }
        IASTAppendable matrix = F.ListAlloc(n);
        for (int i = 0; i < n; ++i) {
            IASTAppendable row = F.ListAlloc(m);
            for (int j = 0; j < m; ++j) {
                row.append(biFunction.apply(i, j));
            }
            matrix.append(row);
        }
        matrix.isMatrix(true);
        return matrix;
    }

    public static IAST vector(IntFunction<? extends IExpr> iFunction, int n) {
        IASTAppendable matrix = F.ListAlloc(n);
        for (int i = 0; i < n; ++i) {
            matrix.append(iFunction.apply(i));
        }
        matrix.addEvalFlags(64);
        return matrix;
    }

    public static IAST Vectors(IExpr a0, IExpr a1) {
        return new AST2(Vectors, a0, a1);
    }

    public static IAST Vectors(IExpr a0) {
        return new AST1(Vectors, a0);
    }

    public static IExpr fromString(String string) {
        try {
            return QuantityParser.of(string);
        }
        catch (Exception exception) {
            return F.stringx(string);
        }
    }

    public static String show(IExpr expr) {
        try {
            if (expr.isSameHeadSizeGE(Show, 2)) {
                IAST show = (IAST)expr;
                return F.showGraphic(show.arg1());
            }
            return F.showGraphic(expr);
        }
        catch (Exception ex) {
            LOGGER.debug("F.show() failed", (Throwable)ex);
            return null;
        }
    }

    public static String showGraphic(IExpr expr) {
        try {
            if (expr.isSameHeadSizeGE(Graphics, 2)) {
                return F.openSVGOnDesktop((IAST)expr);
            }
            if (expr.isSameHeadSizeGE(Graphics3D, 2)) {
                StringBuilder buf = new StringBuilder();
                if (GraphicsFunctions.renderGraphics3D(buf, (IAST)expr, EvalEngine.get())) {
                    try {
                        String manipulateStr = buf.toString();
                        String html = JSBuilder.buildGraphics3D("<html>\n<head>\n<meta charset=\"utf-8\">\n<title>Graphics3D</title>\n`1`\n</head>\n<body>\n<div id=\"graphics3d\" style=\"width:100%; height:100%; margin: 0; padding: 0\">\n<script>\n`2`\n</script>\n`3`\n</div>\n</body>\n</html>", manipulateStr);
                        return F.openHTMLOnDesktop(html);
                    }
                    catch (Exception ex) {
                        LOGGER.debug("JSBuilder.buildGraphics3D() failed", (Throwable)ex);
                    }
                }
            } else if (expr instanceof GraphExpr) {
                String javaScriptStr = GraphFunctions.graphToJSForm((GraphExpr)expr);
                if (javaScriptStr != null) {
                    String html = "<html>\n<head>\n<meta charset=\"utf-8\">\n<head>\n  <title>VIS-Network</title>\n\n  <script type=\"text/javascript\" src=\"https://cdn.jsdelivr.net/npm/vis-network@6.0.0/dist/vis-network.min.js\"></script>\n  <style type=\"text/css\">\n    #mynetwork {\n      width: 600px;\n      height: 400px;\n      border: 1px solid lightgray;\n    }\n  </style>\n</head>\n<body>\n\n<h1>VIS-Network</h1>\n\n<div id=\"vis\"></div>\n\n<script type=\"text/javascript\">\n`1`\n  // create a network\n  var container = document.getElementById('vis');\n  var data = {\n    nodes: nodes,\n    edges: edges\n  };\n`2`\n  var network = new vis.Network(container, data, options);\n</script>\n\n\n</body>\n</html>";
                    html = StringUtils.replace((String)html, (String)"`1`", (String)javaScriptStr);
                    html = StringUtils.replace((String)html, (String)"`2`", (String)"var options = {};");
                    return F.openHTMLOnDesktop(html);
                }
            } else {
                if (expr.isAST(JSFormData, 3)) {
                    return F.printJSFormData(expr);
                }
                if (expr.isString()) {
                    IStringX str = (IStringX)expr;
                    if (str.getMimeType() == 2) {
                        String htmlSnippet = str.toString();
                        String htmlPage = "<html>\n<head>\n<meta charset=\"utf-8\">\n<title>HTML</title>\n</head>\n<body>\n`1`\n</body>\n</html>";
                        htmlPage = StringUtils.replace((String)htmlPage, (String)"`1`", (String)htmlSnippet);
                        EvalEngine.get().getOutPrintStream().println(htmlPage);
                        return F.openHTMLOnDesktop(htmlPage);
                    }
                } else if (expr.isList(x -> x.isAST(JSFormData, 3))) {
                    StringBuilder buf = new StringBuilder();
                    ((IAST)expr).forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> buf.append(F.printJSFormData(x))));
                    return buf.toString();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.debug("F.showGraphic() failed", (Throwable)ex);
        }
        return null;
    }

    private static String printJSFormData(IExpr expr) {
        IAST jsFormData = (IAST)expr;
        if (jsFormData.arg2().toString().equals("mathcell")) {
            try {
                String manipulateStr = jsFormData.arg1().toString();
                String html = JSBuilder.buildMathcell("<html>\n<head>\n<meta charset=\"utf-8\">\n<title>MathCell</title>\n</head>\n\n<body>\n`1`\n<div class=\"mathcell\" style=\"width: 100%; height: 100%; padding: .25in .5in .5in .5in;\">\n<script>\n`2`\n</script>\n`3`\n</div>\n</body>\n</html>", manipulateStr);
                return F.openHTMLOnDesktop(html);
            }
            catch (Exception ex) {
                LOGGER.debug("F.printJSFormData() failed", (Throwable)ex);
            }
        } else if (jsFormData.arg2().toString().equals("jsxgraph")) {
            try {
                String manipulateStr = jsFormData.arg1().toString();
                String html = JSBuilder.buildJSXGraph("<html>\n<head>\n<meta charset=\"utf-8\">\n<title>JSXGraph</title>\n`1`\n</head>\n<body>\n<div id=\"jxgbox\" class=\"jxgbox\" style=\"display: flex; width:99%; height:99%; margin: 0; flex-direction: column; overflow: hidden\">\n<script>\n`2`\n</script>\n`3`\n</div>\n</body>\n</html>", manipulateStr);
                return F.openHTMLOnDesktop(html);
            }
            catch (Exception ex) {
                LOGGER.debug("F.printJSFormData() failed", (Throwable)ex);
            }
        } else if (jsFormData.arg2().toString().equals("plotly")) {
            try {
                String manipulateStr = jsFormData.arg1().toString();
                String html = JSBuilder.buildPlotly("<html>\n<head>\n<meta charset=\"utf-8\">\n<title>Plotly</title>\n`1`\n</head>\n<body>\n<div id='plotly' style=\"display: flex; width: 100%; height: 100%; margin: 0; flex-direction: column; overflow: hidden\">\n<script>\n`2`\n</script>\n`3`\n</div>\n</body>\n</html>", manipulateStr);
                return F.openHTMLOnDesktop(html);
            }
            catch (Exception ex) {
                LOGGER.debug("F.printJSFormData() failed", (Throwable)ex);
            }
        } else if (jsFormData.arg2().toString().equals("treeform")) {
            try {
                String manipulateStr = jsFormData.arg1().toString();
                String html = "<html>\n<head>\n<meta charset=\"utf-8\">\n<head>\n  <title>VIS-Network</title>\n\n  <script type=\"text/javascript\" src=\"https://cdn.jsdelivr.net/npm/vis-network@6.0.0/dist/vis-network.min.js\"></script>\n  <style type=\"text/css\">\n    #mynetwork {\n      width: 600px;\n      height: 400px;\n      border: 1px solid lightgray;\n    }\n  </style>\n</head>\n<body>\n\n<h1>VIS-Network</h1>\n\n<div id=\"vis\"></div>\n\n<script type=\"text/javascript\">\n`1`\n  // create a network\n  var container = document.getElementById('vis');\n  var data = {\n    nodes: nodes,\n    edges: edges\n  };\n`2`\n  var network = new vis.Network(container, data, options);\n</script>\n\n\n</body>\n</html>";
                html = StringUtils.replace((String)html, (String)"`1`", (String)manipulateStr);
                html = StringUtils.replace((String)html, (String)"`2`", (String)"  var options = {\n          edges: {\n              smooth: {\n                  type: 'cubicBezier',\n                  forceDirection:  'vertical',\n                  roundness: 0.4\n              }\n          },\n          layout: {\n              hierarchical: {\n                  direction: \"UD\"\n              }\n          },\n          nodes: {\n            shape: 'box'\n          },\n          physics:false\n      }; ");
                return F.openHTMLOnDesktop(html);
            }
            catch (Exception ex) {
                LOGGER.debug("F.printJSFormData() failed", (Throwable)ex);
            }
        } else if (jsFormData.arg2().toString().equals("traceform")) {
            try {
                String jsStr = jsFormData.arg1().toString();
                String html = "<!doctype html>\n<html>\n  <head>\n       <meta charset=\"utf-8\">\n     <title>JSLists - Very simple nested list [Example 1]</title>\n     \n<style>\n*, *:before, *:after {box-sizing: border-box;}\nul, ol {margin: 0; padding: 0;}\nli {list-style: none; line-height: 1.6rem;}\n\n/* List styling */\n.jslists{\n   font-size: 1.3rem;\n   font-family: Arial, Helvetica, sans-serif;\n}\n.jslist-ul, .jslist-ol, .jslist-li {margin-left: 12px;}        /* Unordered lists */\n.jsl-collapsed {display: none;}\n.jsl-list-closed {\n    float: left;\n   clear: both;\n margin: 2px 4px 2px 0px;\n width: 18px;\n   height: 18px;\n    cursor: pointer;\n   background-image: url('data:image/svg+xml;utf8,<svg aria-hidden=\"true\" data-prefix=\"far\" data-icon=\"plus-square\" class=\"svg-inline--fa fa-plus-square fa-w-14\" role=\"img\" xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 448 512\"><path fill=\"currentColor\" d=\"M352 240v32c0 6.6-5.4 12-12 12h-88v88c0 6.6-5.4 12-12 12h-32c-6.6 0-12-5.4-12-12v-88h-88c-6.6 0-12-5.4-12-12v-32c0-6.6 5.4-12 12-12h88v-88c0-6.6 5.4-12 12-12h32c6.6 0 12 5.4 12 12v88h88c6.6 0 12 5.4 12 12zm96-160v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-48 346V86c0-3.3-2.7-6-6-6H54c-3.3 0-6 2.7-6 6v340c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z\"></path></svg>');\n    background-repeat: no-repeat;\n    background-position: center; \n}\n.jsl-open {display: block;}\n.jsl-list-open {background-image: url('data:image/svg+xml;utf8,<svg aria-hidden=\"true\" data-prefix=\"far\" data-icon=\"minus-square\" class=\"svg-inline--fa fa-minus-square fa-w-14\" role=\"img\" xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 448 512\"><path fill=\"currentColor\" d=\"M108 284c-6.6 0-12-5.4-12-12v-32c0-6.6 5.4-12 12-12h232c6.6 0 12 5.4 12 12v32c0 6.6-5.4 12-12 12H108zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-48 346V86c0-3.3-2.7-6-6-6H54c-3.3 0-6 2.7-6 6v340c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z\"></path></svg>');}\n\n            html, body {\n             width: 100%;\n               height: 100%;\n                margin: 0;\n               padding: 0;\n          }\n            body {\n               font-family: Arial, Helvetica, sans-serif;\n               font-size: 16px;\n         }\n            header {\n               position: absolute;\n              top: 0;\n               left: 0;\n             width: 100%;\n               height: 90px;\n               background-color: rgb(156, 158, 160);\n               padding-left: 18px;\n          }\n           header > div {\n               position: relative;\n               display: inline-block;\n               top: 50%;\n               transform: translateY(-50%);\n             font-size: 3.4rem;\n               font-weight: 900;\n            }\n            main {\n               position: absolute;\n              top: 90px;\n               height: calc(100vh - 90px);\n          }\n           main > div:nth-child(1) {\n                padding: 16px;\n           }\n            main > div:nth-child(2) {\n               padding: 18px;\n</style>\n    </head>\n  <body> \n               <ul id='traceform' class='jslists'>\n                   <li>TraceForm\n`1`\n                 </li>\n                </ul>\n            </div>\n \n       <script>\nvar blackCircle = '&#9679; ';\nvar openCircle = '&#9678; ';\n\n(function() {\n \"use strict\";\n    function define_JSLists() {\n     var JSLists = {};\n\n       var JSLists_Error = function(error, alertType) {\n           console.log(error);\n      }\n        var getUl = function(){\n           return document.getElementsByTagName(\"UL\");\n        };\n\n       var getOl = function(){\n           return document.getElementsByTagName(\"OL\");\n        };\n\n       var getAllLists = function(){\n           var olLists = Array.prototype.slice.call(document.getElementsByTagName(\"UL\")),\n               ulLists = Array.prototype.slice.call(document.getElementsByTagName(\"OL\"))\n           var gLists = olLists.concat(ulLists);\n            return gLists;\n       }\n\n     JSLists.searchList = function(listId, searchTerm) {\n           var i, j, lilNodes, liItems = document.getElementsByTagName(\"LI\");\n           for(i=0; i<liItems.length; i++) {\n                if(liItems[i].hasChildNodes()) {\n                    for(j=0; j<liItems[i].childNodes.length; j++) {\n                        if(liItems[i].childNodes[j].innerHTML == searchTerm) {\n                           //?????\n                        }\n                    }\n                }\n           }\n        }\n\n        JSLists.collapseAll = function(listId) {\n           var i, ulLists = document.getElementsByTagName(\"UL\");\n           for(i=0; i<ulLists.length; i++) {\n               if(ulLists[i].className == \"jsl-collapsed\") {\n                    console.log(ulLists[i].className + '\\n' + '@');\n               }\n            };\n       };\n\n       JSLists.openAll = function(listId){\n           var i, olLists = Array.prototype.slice.call(document.getElementsByTagName(\"UL\")),\n               ulLists = Array.prototype.slice.call(document.getElementsByTagName(\"OL\"))\n           var gLists = olLists.concat(ulLists);\n\n           for(i=1; i<gLists.length; i++) {\n               gLists[i].setAttribute('class', 'jsl-open');\n         };\n       };\n\n        JSLists.padUnorderedLists = function(listId) {\n           var i, listItems = document.getElementById(listId).getElementsByTagName(\"UL\");\n           for(i=0; i<listItems.length; i++) {\n               listItems[i].classList.add('jslist-ul');\n         }\n       };\n\n        JSLists.padOrderedLists = function(listId) {\n           var i, listItems = document.getElementById(listId).getElementsByTagName(\"UL\");\n           for(i=0; i<listItems.length; i++) {\n               listItems[i].classList.add('jslist-ol');\n         }\n       };\n\n        JSLists.padLists = function(listId) {\n           var i, listItems = document.getElementById(listId).getElementsByTagName(\"LI\");\n           for(i=0; i<listItems.length; i++) {\n               if(listItems[i].childNodes[0].className != \"jsl-collapsed-arrow\") {\n                   listItems[i].classList.add('jslist-li');\n             }\n           }\n            for(i=1; i<listItems.length; i++) {\n               // console.log(listItems[i].childNodes.length);\n               if(listItems[i].classList = \"jslist-li\" && listItems[i].childNodes.length < 2) {\n                   listItems[i].innerHTML = blackCircle + listItems[i].innerHTML\n               }\n            }\n           this.padUnorderedLists(listId);\n           this.padOrderedLists(listId);\n        };\n\n        JSLists.createTree = function(listId, bulletPoint) {\n           document.getElementById(listId).style.display = \"none;\"\n           var i, j, curElem, ulCount, olCount, listItems = document.getElementById(listId).getElementsByTagName('LI'); //this should be the main parent\n           for(i=0; i<listItems.length; i++) {\n               if(listItems[i].id.length > 0) {\n                   curElem = document.getElementById(listItems[i].id);\n                    ulCount = document.getElementById(listItems[i].id).getElementsByTagName(\"UL\");\n                    if(ulCount.length > 0){\n                        for(j=0; j<ulCount.length; j++) {\n                            if(ulCount[j].nodeName == \"UL\") {\n                                break;\n                            }\n                        }\n                        ulCount[j].setAttribute('class', 'jsl-collapsed');\n                        var tglDiv = document.createElement(\"div\");\n                        tglDiv.setAttribute('class', 'jsl-list-closed');\n                        tglDiv.setAttribute(\"id\", listItems[i].id + i +'_tgl');\n                        curElem.insertBefore(tglDiv, curElem.childNodes[0]);\n\n                        document.getElementById(listItems[i].id + i +'_tgl').addEventListener('click', function(e) {\n                            document.getElementById(e.target.id).classList.toggle('jsl-list-open');\n                            document.getElementById(e.target.id).parentElement.lastElementChild.classList.toggle('jsl-open');\n                            e.stopPropagation();\n                        },true);\n                    }\n                } else {\n                   listItems[i].setAttribute(\"id\", listId+\"tmp\"+i);\n                   curElem = document.getElementById(listId+\"tmp\"+i);\n                   ulCount = document.getElementById(listItems[i].id).getElementsByTagName(\"UL\");\n\n                   if(ulCount.length > 0) { //There is a nested UL in this LI element, now find the position of the UL\n                       for(j=0; j<ulCount.length; j++) {\n                           if(ulCount[j].nodeName == \"UL\") {\n                               break; //Multiple UL's? //Set class collapseAll here\n                           }\n                        }\n                       ulCount[j].setAttribute('class', 'jsl-collapsed');\n                       var tglDiv = document.createElement(\"div\");\n                       tglDiv.setAttribute('class', 'jsl-list-closed');\n                       tglDiv.setAttribute(\"id\", listItems[i].id + i +'_tgl');\n                       curElem.insertBefore(tglDiv, curElem.childNodes[0]);\n\n                       document.getElementById(listItems[i].id + i +'_tgl').addEventListener('click', function(e){\n                           document.getElementById(e.target.id).classList.toggle('jsl-list-open');\n                           document.getElementById(e.target.id).parentElement.lastElementChild.classList.toggle('jsl-open');\n                           e.stopPropagation();\n                     },true);\n                   }\n                    listItems[i].removeAttribute(\"id\");\n               }\n            }\n            setTimeout(function() {\n               document.getElementById(listId).style.display = \"block;\"\n           }, 50); // stops FOUC!\n           this.padLists(listId);\n       };\n\n       // JSLists.applyToList = function(listId, listType, applyIcons, applyTheme, themeNumber){\n       //Check the params here\n      // does the id exist?\n       JSLists.applyToList = function(listId, bulletPoint) {\n            this.createTree(listId, \"UL\");\n        };\n   return JSLists;\n    }\n\n   //define the JSLists library in the global namespace if it doesn't already exist\n   if(typeof(JSLists) === 'undefined') {\n       window.JSLists = define_JSLists();\n   }else{\n       console.log(\"JSLists already defined.\");\n   }\n})();       \n       </script>\n        <script> \n           JSLists.createTree(\"traceform\");\n       </script>\n   </body>\n</html>";
                html = StringUtils.replace((String)html, (String)"`1`", (String)jsStr);
                return F.openHTMLOnDesktop(html);
            }
            catch (Exception ex) {
                LOGGER.debug("F.printJSFormData() failed", (Throwable)ex);
            }
        }
        return null;
    }

    public static String openSVGOnDesktop(IAST show) throws IOException {
        String html = "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" viewBox=\"-0.333333 -0.333333 350.666667 350.666667\" width=\"350.6666666px\" height=\"350.6666666px\">\n`1`\n</svg>";
        StringBuilder stw = new StringBuilder();
        GraphicsFunctions.graphicsToSVG(show.getAST(1), stw);
        html = StringUtils.replace((String)html, (String)"`1`", (String)stw.toString());
        File temp = java.io.File.createTempFile("tempfile", ".svg");
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(temp));){
            bw.write(html);
        }
        if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().open(temp);
        }
        return temp.toString();
    }

    public static String openHTMLOnDesktop(String html) throws IOException {
        File temp = java.io.File.createTempFile("tempfile", ".html");
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(temp));){
            bw.write(html);
        }
        if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().open(temp);
        }
        return temp.toString();
    }

    public static IAST flattenSequence(IAST list) {
        if (list.isEvalFlagOn(524288)) {
            return NIL;
        }
        boolean isList = list.isList();
        int indx = list.indexOf(x -> x.isSequence() || isList && x == Nothing);
        if (indx > 0) {
            int extraSize = list.get(indx).size();
            IASTAppendable seqResult = F.ast(list.head(), list.size() + extraSize + 1);
            seqResult.appendArgs(list, indx);
            list.forEach(indx, list.size(), x -> {
                if (x.isSequence()) {
                    seqResult.appendArgs((IAST)x);
                } else if (!isList || x != Nothing) {
                    seqResult.append((IExpr)x);
                }
            });
            return seqResult;
        }
        list.addEvalFlags(524288);
        return NIL;
    }

    static {
        EXPR_FIELD = new ExprField();
        CN1 = AbstractIntegerSym.valueOf(-1);
        CN2 = AbstractIntegerSym.valueOf(-2);
        CN3 = AbstractIntegerSym.valueOf(-3);
        CN4 = AbstractIntegerSym.valueOf(-4);
        CN5 = AbstractIntegerSym.valueOf(-5);
        CN6 = AbstractIntegerSym.valueOf(-6);
        CN7 = AbstractIntegerSym.valueOf(-7);
        CN8 = AbstractIntegerSym.valueOf(-8);
        CN9 = AbstractIntegerSym.valueOf(-9);
        CN10 = AbstractIntegerSym.valueOf(-10);
        UNARY_INVERSE_FUNCTIONS = new IdentityHashMap<ISymbol, IExpr>();
        COUNT_DOWN_LATCH = new CountDownLatch(1);
        try {
            AST2Expr.initialize();
            ExprParserFactory.initialize();
            PreemptStatus.setNotAllow();
            ComputerThreads.NO_THREADS = Config.JAS_NO_THREADS;
            ApfloatContext ctx = ApfloatContext.getContext();
            ctx.setNumberOfProcessors(1);
            Slot.setAttributes(24576);
            Slot.setEvaluator(ICoreFunctionEvaluator.ARGS_EVALUATOR);
            SlotSequence.setAttributes(24576);
            SlotSequence.setEvaluator(ICoreFunctionEvaluator.ARGS_EVALUATOR);
            PatternTest.setAttributes(64);
            List.setEvaluator(ICoreFunctionEvaluator.ARGS_EVALUATOR);
            CEmptySequence = F.headAST0(Sequence);
            CEmptyList = F.headAST0(List);
            CEmptyString = F.$str("");
            CMissingNotFound = F.Missing("NotFound");
            CListC0 = new B1.List(C0);
            CListC1 = new B1.List(C1);
            CListC2 = new B1.List(C2);
            CListCN1 = new B1.List(CN1);
            CListC1C1 = new B2.List(C1, C1);
            CListC1C2 = new B2.List(C1, C2);
            CListC2C1 = new B2.List(C2, C1);
            CListC2C2 = new B2.List(C2, C2);
            CReturnFalse = new B1.Return(False);
            CReturnTrue = new B1.Return(True);
            CThrowFalse = new B1.Throw(False);
            CThrowTrue = new B1.Throw(True);
            oo = CInfinity = F.unaryAST1(DirectedInfinity, C1);
            Noo = CNInfinity = F.unaryAST1(DirectedInfinity, CN1);
            CIInfinity = F.unaryAST1(DirectedInfinity, CI);
            CNIInfinity = F.unaryAST1(DirectedInfinity, CNI);
            CComplexInfinity = F.headAST0(DirectedInfinity);
            CNPi = new B2.Times(CN1, Pi);
            CN2Pi = new B2.Times(CN2, Pi);
            C2Pi = new B2.Times(C2, Pi);
            CNPiHalf = new B2.Times(CN1D2, Pi);
            CPiHalf = new B2.Times(C1D2, Pi);
            CSqrt2 = new B2.Power(C2, C1D2);
            CSqrt3 = new B2.Power(C3, C1D2);
            CSqrt5 = new B2.Power(C5, C1D2);
            CSqrt6 = new B2.Power(C6, C1D2);
            CSqrt7 = new B2.Power(C7, C1D2);
            CSqrt10 = new B2.Power(C10, C1D2);
            C1DSqrt2 = new B2.Power(C2, CN1D2);
            C1DSqrt3 = new B2.Power(C3, CN1D2);
            C1DSqrt5 = new B2.Power(C5, CN1D2);
            C1DSqrt6 = new B2.Power(C6, CN1D2);
            C1DSqrt7 = new B2.Power(C7, CN1D2);
            C1DSqrt10 = new B2.Power(C10, CN1D2);
            Slot1 = F.unaryAST1(Slot, C1);
            Slot2 = F.unaryAST1(Slot, C2);
            Slot3 = F.unaryAST1(Slot, C3);
            COMMON_IDS = new IExpr[]{CN1, CN2, CN3, CN4, CN5, CN6, CN7, CN8, CN9, CN10, C0, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, CI, CNI, C1D2, CN1D2, C1D3, CN1D3, C1D4, CN1D4, CD0, CD1, CInfinity, CNInfinity, CComplexInfinity, CSqrt2, CSqrt3, CSqrt5, CSqrt6, CSqrt7, CSqrt10, C1DSqrt2, C1DSqrt3, C1DSqrt5, C1DSqrt6, C1DSqrt7, C1DSqrt10, Slot1, Slot2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v, w, x, y, z, ASymbol, BSymbol, CSymbol, FSymbol, GSymbol, a_, b_, c_, d_, e_, f_, g_, h_, i_, j_, k_, l_, m_, n_, o_, p_, q_, r_, s_, t_, u_, v_, w_, x_, y_, z_, A_, B_, C_, F_, G_, a_Symbol, b_Symbol, c_Symbol, d_Symbol, e_Symbol, f_Symbol, g_Symbol, h_Symbol, i_Symbol, j_Symbol, k_Symbol, l_Symbol, m_Symbol, n_Symbol, o_Symbol, p_Symbol, q_Symbol, r_Symbol, s_Symbol, t_Symbol, u_Symbol, v_Symbol, w_Symbol, x_Symbol, y_Symbol, z_Symbol, a_DEFAULT, b_DEFAULT, c_DEFAULT, d_DEFAULT, e_DEFAULT, f_DEFAULT, g_DEFAULT, h_DEFAULT, i_DEFAULT, j_DEFAULT, k_DEFAULT, l_DEFAULT, m_DEFAULT, n_DEFAULT, o_DEFAULT, p_DEFAULT, q_DEFAULT, r_DEFAULT, s_DEFAULT, t_DEFAULT, u_DEFAULT, v_DEFAULT, w_DEFAULT, x_DEFAULT, y_DEFAULT, z_DEFAULT, A_DEFAULT, B_DEFAULT, C_DEFAULT, F_DEFAULT, G_DEFAULT};
            short exprID = EXPRID_MAX_BUILTIN_LENGTH;
            for (int i = 0; i < COMMON_IDS.length; i = (int)((short)(i + 1))) {
                short s = exprID;
                exprID = (short)(exprID + 1);
                GLOBAL_IDS_MAP.put(COMMON_IDS[i], s);
            }
            PREDEFINED_INTERNAL_FORM_STRINGS.put("Pi", "Pi");
            PREDEFINED_INTERNAL_FORM_STRINGS.put("E", "E");
            PREDEFINED_INTERNAL_FORM_STRINGS.put("False", "False");
            PREDEFINED_INTERNAL_FORM_STRINGS.put("True", "True");
            PREDEFINED_INTERNAL_FORM_STRINGS.put("Null", "Null");
            PREDEFINED_INTERNAL_FORM_STRINGS.put("Integer", "IntegerHead");
            PREDEFINED_INTERNAL_FORM_STRINGS.put("Symbol", "SymbolHead");
            PREDEFINED_INTERNAL_FORM_STRINGS.put("Infinity", "CInfinity");
            PREDEFINED_INTERNAL_FORM_STRINGS.put("ComplexInfinity", "CComplexInfinity");
            PREDEFINED_INTERNAL_FORM_STRINGS.put("Plus", "Plus");
            PREDEFINED_INTERNAL_FORM_STRINGS.put("Power", "Power");
            PREDEFINED_INTERNAL_FORM_STRINGS.put("Times", "Times");
            Arithmetic.initialize();
            PredicateQ.initialize();
            AttributeFunctions.initialize();
            F.createInverseFunctionMap();
            DENOMINATOR_NUMERATOR_SYMBOLS = Collections.unmodifiableList(java.util.Arrays.asList(Sin, Cos, Tan, Csc, Sec, Cot));
            DENOMINATOR_TRIG_TRUE_EXPRS = Collections.unmodifiableList(java.util.Arrays.asList(C1, C1, Cos, Sin, Cos, Sin));
            NUMERATOR_NUMERATOR_SYMBOLS = Collections.unmodifiableList(java.util.Arrays.asList(Sin, Cos, Tan, Csc, Sec, Cot));
            NUMERATOR_TRIG_TRUE_EXPRS = Collections.unmodifiableList(java.util.Arrays.asList(Sin, Cos, Sin, C1, C1, Cos));
            ConstantDefinitions.initialize();
            FunctionDefinitions.initialize();
            Integrate.setEvaluator(org.matheclipse.core.reflection.system.Integrate.CONST);
            IOFunctions.initialize();
            Programming.initialize();
            PatternMatching.initialize();
            FileFunctions.initialize();
            Algebra.initialize();
            SimplifyFunctions.initialize();
            StructureFunctions.initialize();
            ExpTrigsFunctions.initialize();
            NumberTheory.initialize();
            BooleanFunctions.initialize();
            LinearAlgebra.initialize();
            TensorFunctions.initialize();
            ListFunctions.initialize();
            Combinatoric.initialize();
            IntegerFunctions.initialize();
            BesselFunctions.initialize();
            SpecialFunctions.initialize();
            StringFunctions.initialize();
            OutputFunctions.initialize();
            RandomFunctions.initialize();
            StatisticsFunctions.initialize();
            HypergeometricFunctions.initialize();
            EllipticIntegrals.initialize();
            PolynomialFunctions.initialize();
            RootsFunctions.initialize();
            SeriesFunctions.initialize();
            AssumptionFunctions.initialize();
            ContainsFunctions.initialize();
            CurveFitterFunctions.initialize();
            VectorAnalysisFunctions.initialize();
            QuantityFunctions.initialize();
            IntervalFunctions.initialize();
            FinancialFunctions.initialize();
            WXFFunctions.initialize();
            WindowFunctions.initialize();
            MinMaxFunctions.initialize();
            GraphFunctions.initialize();
            GraphDataFunctions.initialize();
            AssociationFunctions.initialize();
            GeodesyFunctions.initialize();
            ManipulateFunction.initialize();
            ImageFunctions.initialize();
            EntityFunctions.initialize();
            ClusteringFunctions.initialize();
            SourceCodeFunctions.initialize();
            SparseArrayFunctions.initialize();
            UnitTestingFunctions.initialize();
            BoxesFunctions.initialize();
            NumericArrayFunctions.initialize();
            GraphicsFunctions.initialize();
            CompilerFunctions.initialize();
            JavaFunctions.initialize();
            SidesFunctions.initialize();
            ComputationalGeometryFunctions.initialize();
            COUNT_DOWN_LATCH.countDown();
        }
        catch (Throwable th) {
            LOGGER.error("F-class initilaization failed", th);
            throw th;
        }
    }
}

