/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.parser.trie.Trie;
import org.matheclipse.parser.trie.TrieMatch;
import org.matheclipse.parser.trie.TrieNode;

public class ExprTrie {
    private Trie<String, IExpr> exprMap = Config.TRIE_STRING2EXPR_BUILDER.build();

    public void clear() {
        this.exprMap.clear();
    }

    public ExprTrie copy() {
        ExprTrie trie = new ExprTrie();
        trie.exprMap = Config.TRIE_STRING2EXPR_BUILDER.build();
        for (TrieNode<String, IExpr> entry : this.nodeSet()) {
            trie.exprMap.put((Object)((String)entry.getKey()), (Object)((IExpr)entry.getValue()));
        }
        return trie;
    }

    public IExpr compute(String key, BiFunction<? super String, ? super IExpr, ? extends IExpr> remappingFunction) {
        return (IExpr)this.exprMap.compute((Object)key, remappingFunction);
    }

    public IExpr computeIfAbsent(String key, Function<? super String, ? extends IExpr> mappingFunction) {
        return (IExpr)this.exprMap.computeIfAbsent((Object)key, mappingFunction);
    }

    public IExpr computeIfPresent(String key, BiFunction<? super String, ? super IExpr, ? extends IExpr> remappingFunction) {
        return (IExpr)this.exprMap.computeIfPresent((Object)key, remappingFunction);
    }

    public boolean containsKey(String key) {
        return this.exprMap.containsKey((Object)key);
    }

    public boolean containsValue(IExpr value) {
        return this.exprMap.containsValue((Object)value);
    }

    public Set<Map.Entry<String, IExpr>> entrySet() {
        return this.exprMap.entrySet();
    }

    public Set<Map.Entry<String, IExpr>> entrySet(String sequence) {
        return this.exprMap.entrySet((Object)sequence);
    }

    public Set<Map.Entry<String, IExpr>> entrySet(String sequence, TrieMatch match) {
        return this.exprMap.entrySet((Object)sequence, match);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExprTrie) {
            return this.exprMap.equals(((ExprTrie)obj).exprMap);
        }
        return false;
    }

    public void forEach(BiConsumer<? super String, ? super IExpr> action) {
        this.exprMap.forEach(action);
    }

    public IExpr get(String sequence) {
        return (IExpr)this.exprMap.get((Object)sequence);
    }

    public IExpr get(String sequence, TrieMatch match) {
        return (IExpr)this.exprMap.get((Object)sequence, match);
    }

    public TrieMatch getDefaultMatch() {
        return this.exprMap.getDefaultMatch();
    }

    public IExpr getDefaultValue() {
        return (IExpr)this.exprMap.getDefaultValue();
    }

    public IExpr getOrDefault(String key, IExpr defaultValue) {
        return (IExpr)this.exprMap.getOrDefault((Object)key, (Object)defaultValue);
    }

    public boolean has(String sequence) {
        return this.exprMap.has((Object)sequence);
    }

    public boolean has(String sequence, TrieMatch match) {
        return this.exprMap.has((Object)sequence, match);
    }

    public int hashCode() {
        return this.exprMap.hashCode();
    }

    public boolean isEmpty() {
        return this.exprMap.isEmpty();
    }

    public Set<String> keySet() {
        return this.exprMap.keySet();
    }

    public Set<String> keySet(String sequence) {
        return this.exprMap.keySet((Object)sequence);
    }

    public Set<String> keySet(String sequence, TrieMatch match) {
        return this.exprMap.keySet((Object)sequence, match);
    }

    public IExpr merge(String key, IExpr value, BiFunction<? super IExpr, ? super IExpr, ? extends IExpr> remappingFunction) {
        return (IExpr)this.exprMap.merge((Object)key, (Object)value, remappingFunction);
    }

    public Trie<String, IExpr> newEmptyClone() {
        return this.exprMap.newEmptyClone();
    }

    public Set<TrieNode<String, IExpr>> nodeSet() {
        return this.exprMap.nodeSet();
    }

    public Set<TrieNode<String, IExpr>> nodeSet(String sequence) {
        return this.exprMap.nodeSet((Object)sequence);
    }

    public Set<TrieNode<String, IExpr>> nodeSet(String sequence, TrieMatch match) {
        return this.exprMap.nodeSet((Object)sequence, match);
    }

    public Iterable<TrieNode<String, IExpr>> nodeSetAll() {
        return this.exprMap.nodeSetAll();
    }

    public Iterable<TrieNode<String, IExpr>> nodeSetAll(String sequence) {
        return this.exprMap.nodeSetAll((Object)sequence);
    }

    public Iterable<TrieNode<String, IExpr>> nodeSetAll(String sequence, TrieMatch match) {
        return this.exprMap.nodeSetAll((Object)sequence, match);
    }

    public IExpr put(String query, Function<IExpr, IExpr> updater) {
        return (IExpr)this.exprMap.put((Object)query, updater);
    }

    public IExpr put(String query, Function<IExpr, IExpr> updater, IExpr defaultPrevious) {
        return (IExpr)this.exprMap.put((Object)query, updater, (Object)defaultPrevious);
    }

    public IExpr put(String query, IExpr value) {
        return (IExpr)this.exprMap.put((Object)query, (Object)value);
    }

    public void putAll(Map<? extends String, ? extends IExpr> map) {
        this.exprMap.putAll(map);
    }

    public IExpr putIfAbsent(String key, IExpr value) {
        return (IExpr)this.exprMap.putIfAbsent((Object)key, (Object)value);
    }

    public IExpr remove(String sequence) {
        return (IExpr)this.exprMap.remove((Object)sequence);
    }

    public boolean remove(String key, IExpr value) {
        return this.exprMap.remove((Object)key, (Object)value);
    }

    public IExpr replace(String key, IExpr value) {
        return (IExpr)this.exprMap.replace((Object)key, (Object)value);
    }

    public boolean replace(String key, IExpr oldValue, IExpr newValue) {
        return this.exprMap.replace((Object)key, (Object)oldValue, (Object)newValue);
    }

    public void replaceAll(BiFunction<? super String, ? super IExpr, ? extends IExpr> function) {
        this.exprMap.replaceAll(function);
    }

    public void setDefaultMatch(TrieMatch match) {
        this.exprMap.setDefaultMatch(match);
    }

    public void setDefaultValue(IExpr defaultValue) {
        this.exprMap.setDefaultValue((Object)defaultValue);
    }

    public int size() {
        return this.exprMap.size();
    }

    public String toString() {
        return this.exprMap.toString();
    }

    public Collection<IExpr> values() {
        return this.exprMap.values();
    }

    public Collection<IExpr> values(String sequence) {
        return this.exprMap.values((Object)sequence);
    }

    public Collection<IExpr> values(String sequence, TrieMatch match) {
        return this.exprMap.values((Object)sequence, match);
    }
}

