/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import org.jgrapht.graph.AbstractBaseGraph;
import org.matheclipse.core.builtin.GraphFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.data.ExprEdge;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IDataExpr;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;

public abstract class DataExpr<T>
implements IDataExpr<T> {
    private static final long serialVersionUID = 4987827851920443376L;
    protected IBuiltInSymbol fHead;
    protected T fData;

    protected DataExpr(IBuiltInSymbol head, T data) {
        this.fHead = head;
        this.fData = data;
    }

    @Override
    public IExpr accept(IVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return false;
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return 0;
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return 0L;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DataExpr) {
            return this.fData.equals(((DataExpr)obj).fData);
        }
        return false;
    }

    @Override
    public int compareTo(IExpr expr) {
        int y;
        if (expr instanceof DataExpr) {
            DataExpr de = (DataExpr)expr;
            if (this.fData != null) {
                if (de.fData != null) {
                    int y2;
                    if (this.fData.getClass() == de.fData.getClass() && this.fData instanceof Comparable) {
                        return ((Comparable)this.fData).compareTo(de.fData);
                    }
                    int x = this.hierarchy();
                    return x < (y2 = expr.hierarchy()) ? -1 : (x == y2 ? 0 : 1);
                }
                return 1;
            }
            return -1;
        }
        if (expr.isAST()) {
            return -1 * expr.compareTo(this);
        }
        int x = this.hierarchy();
        return x < (y = expr.hierarchy()) ? -1 : (x == y ? 0 : 1);
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        return F.NIL;
    }

    @Override
    public String fullFormString() {
        if (this.fHead.equals(S.Graph) && this.fData instanceof AbstractBaseGraph) {
            AbstractBaseGraph g = (AbstractBaseGraph)this.fData;
            return GraphFunctions.graphToIExpr((AbstractBaseGraph<IExpr, ExprEdge>)g).fullFormString();
        }
        return this.fHead + "(" + this.fData.toString() + ")";
    }

    public int hashCode() {
        return this.fData == null ? 181 : 181 + this.fData.hashCode();
    }

    @Override
    public ISymbol head() {
        return this.fHead;
    }

    @Override
    public int hierarchy() {
        return 32786;
    }

    @Override
    public T toData() {
        return this.fData;
    }

    public String toString() {
        return this.fHead + "[" + this.fData.toString() + "]";
    }
}

