/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.expression.Context;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Symbol;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.ParserConfig;

public final class ContextPath
implements Iterable<Context> {
    public static Set<String> PACKAGES = new TreeSet<String>();
    private HashMap<String, Context> fContextMap;
    private ArrayList<Context> path = new ArrayList();
    private Context fContext;

    public static ContextPath initialContext() {
        ContextPath cp = new ContextPath();
        cp.fContextMap = new HashMap(17);
        cp.path.add(Context.SYSTEM);
        cp.fContextMap.put(Context.SYSTEM.getContextName(), Context.SYSTEM);
        cp.fContextMap.put(Context.RUBI.getContextName(), Context.RUBI);
        Context global = new Context("Global`");
        cp.path.add(global);
        cp.fContextMap.put("Global`", global);
        cp.fContext = global;
        return cp;
    }

    private ContextPath() {
    }

    public ContextPath(Context context) {
        this.fContextMap = new HashMap(17);
        this.path.add(context);
        this.path.add(Context.SYSTEM);
        this.fContextMap.put(Context.SYSTEM.getContextName(), Context.SYSTEM);
        this.fContextMap.put(Context.RUBI.getContextName(), Context.RUBI);
        this.fContext = context;
    }

    public boolean add(Context context) {
        return this.path.add(context);
    }

    public void add(int index, Context context) {
        this.path.add(index, context);
    }

    public boolean contains(Context context) {
        return this.path.contains(context);
    }

    public ContextPath copy() {
        ContextPath cp = new ContextPath();
        cp.fContextMap = new HashMap<String, Context>(this.fContextMap);
        cp.path = new ArrayList<Context>(this.path);
        cp.fContext = this.fContext;
        return cp;
    }

    public IStringX currentCompleteContextName() {
        return F.stringx(this.fContext.completeContextName());
    }

    public Context currentContext() {
        return this.fContext;
    }

    public IStringX currentContextString() {
        return F.stringx(this.fContext.getContextName());
    }

    public Context get(int index) {
        return this.path.get(index);
    }

    public Context getContext(String contextName) {
        Context context = this.fContextMap.get(contextName);
        if (context != null) {
            return context;
        }
        for (int i = 0; i < this.path.size(); ++i) {
            Context ctxt = this.path.get(i);
            if (!ctxt.completeContextName().equals(contextName)) continue;
            return ctxt;
        }
        context = new Context(contextName);
        this.fContextMap.put(contextName, context);
        return context;
    }

    public Map<String, Context> getContextMap() {
        return this.fContextMap;
    }

    public Context getContext(String contextName, Context parentContext) {
        Context context;
        Object name = contextName;
        if (parentContext != null) {
            String packageName = parentContext.getContextName();
            name = packageName.substring(0, packageName.length() - 1) + (String)name;
        }
        if ((context = this.fContextMap.get(name)) != null) {
            return context;
        }
        context = new Context(contextName, parentContext);
        this.fContextMap.put((String)name, context);
        return context;
    }

    public Context getGlobalContext() {
        return this.fContextMap.get("Global`");
    }

    public static ISymbol getSymbol(String symbolName, Context context, boolean relaxedSyntax) {
        ISymbol symbol;
        String name = symbolName;
        if (relaxedSyntax) {
            name = symbolName.length() == 1 ? symbolName : symbolName.toLowerCase(Locale.ENGLISH);
        }
        if ((symbol = context.get(name)) != null) {
            return symbol;
        }
        symbol = new Symbol(name, context);
        context.put(name, symbol);
        if (Config.SERVER_MODE && name.charAt(0) == '$') {
            F.SYMBOL_OBSERVER.createUserSymbol(symbol);
        }
        return symbol;
    }

    @Override
    public Iterator<Context> iterator() {
        return this.path.iterator();
    }

    public IAST pathAsStrings() {
        int size = this.path.size();
        IASTAppendable result = F.ListAlloc(size);
        for (int i = 0; i < size; ++i) {
            result.append(this.path.get(i).getContextName());
        }
        return result;
    }

    public Context remove(int index) {
        return this.path.remove(index);
    }

    public ISymbol removeSymbol(String symbolName) {
        String name = symbolName;
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
            name = symbolName.length() == 1 ? symbolName : symbolName.toLowerCase(Locale.ENGLISH);
        }
        for (int i = this.path.size() - 1; i >= 0; --i) {
            ISymbol symbol;
            Context context = this.path.get(i);
            if (context.equals(Context.SYSTEM) || (symbol = context.remove(name)) == null) continue;
            return symbol;
        }
        return null;
    }

    public Context set(int index, Context element) {
        return this.path.set(index, element);
    }

    public void setCurrentContext(Context context) {
        this.fContext = context;
    }

    public boolean setGlobalContext(Context context) {
        int start;
        int size = this.path.size();
        for (int i = start = size - 1; i >= 0; --i) {
            Context temp = this.path.get(i);
            if (!temp.getContextName().equals("Global`")) continue;
            this.path.set(i, context);
            this.fContextMap.put("Global`", context);
            if (this.fContext.getContextName().equals("Global`")) {
                this.fContext = context;
            }
            return true;
        }
        return false;
    }

    public int size() {
        return this.path.size();
    }

    public ISymbol symbol(String symbolName, Context newContext, boolean relaxedSyntax) {
        ISymbol symbol;
        String name = symbolName;
        if (relaxedSyntax) {
            name = symbolName.length() == 1 ? symbolName : symbolName.toLowerCase(Locale.ENGLISH);
        }
        for (int i = 0; i < this.path.size(); ++i) {
            Context context = this.path.get(i);
            symbol = context.get(name);
            if (symbol == null) continue;
            return symbol;
        }
        symbol = newContext.get(name);
        if (symbol != null) {
            return symbol;
        }
        symbol = new Symbol(name, newContext);
        newContext.put(name, symbol);
        if (Config.SERVER_MODE && name.charAt(0) == '$') {
            F.SYMBOL_OBSERVER.createUserSymbol(symbol);
        }
        return symbol;
    }

    public boolean hasSymbol(String symbolName, boolean relaxedSyntax) {
        String name = symbolName;
        if (relaxedSyntax) {
            name = symbolName.length() == 1 ? symbolName : symbolName.toLowerCase(Locale.ENGLISH);
        }
        for (int i = 0; i < this.path.size(); ++i) {
            Context context = this.path.get(i);
            ISymbol symbol = context.get(name);
            if (symbol == null) continue;
            return true;
        }
        return false;
    }

    public void synchronize(ContextPath path) {
        Context c = path.fContext;
        if (!this.fContextMap.containsKey(c.getContextName())) {
            this.fContextMap.put(c.getContextName(), c);
        }
        for (Map.Entry<String, Context> entry : path.fContextMap.entrySet()) {
            if (this.fContextMap.containsKey(entry.getKey())) continue;
            this.fContextMap.put(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        return this.path.toString();
    }

    static {
        PACKAGES.add("Rubi`");
        PACKAGES.add("Global`");
        PACKAGES.add("System`");
    }
}

