/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.trie.TrieMatch;

public class Context
implements Serializable {
    private static final long serialVersionUID = 8656114325955206899L;
    public static final Map<String, ISymbol> PREDEFINED_SYMBOLS_MAP = Config.TRIE_STRING2SYMBOL_BUILDER.withMatch(TrieMatch.EXACT).build();
    public static final String DUMMY_CONTEXT_NAME = "DUMMY`";
    public static final Context DUMMY = new Context("DUMMY`", null);
    public static final String SYSTEM_CONTEXT_NAME = "System`";
    public static final Context SYSTEM = new Context("System`", null, PREDEFINED_SYMBOLS_MAP);
    public static final String RUBI_STR = "Rubi`";
    public static final Context RUBI = new Context("Rubi`");
    private String contextName;
    private transient Context parentContext;
    private Map<String, ISymbol> symbolTable;
    private transient Class<?> javaClass = null;
    public static final String GLOBAL_CONTEXT_NAME = "Global`";

    public Context(String contextName) {
        this(contextName, null, new HashMap<String, ISymbol>());
    }

    public Context(String contextName, Context parentContext) {
        this(contextName, parentContext, new HashMap<String, ISymbol>());
    }

    private Context(String contextName, Context parentContext, Map<String, ISymbol> symbolTable) {
        this.symbolTable = symbolTable;
        this.contextName = contextName;
        this.parentContext = parentContext;
    }

    public Context copy() {
        if (this == SYSTEM) {
            return SYSTEM;
        }
        return new Context(this.contextName, this.parentContext, new HashMap<String, ISymbol>(this.symbolTable));
    }

    public Set<Map.Entry<String, ISymbol>> entrySet() {
        return this.symbolTable.entrySet();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Context) {
            return this.contextName.equals(((Context)obj).contextName);
        }
        return false;
    }

    public ISymbol get(String key) {
        return this.symbolTable.get(key);
    }

    public String getContextName() {
        return this.contextName;
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    public String completeContextName() {
        String packageName;
        Object completeContextName = this.contextName;
        if (this.parentContext != null && !(packageName = this.parentContext.getContextName()).equals(GLOBAL_CONTEXT_NAME)) {
            completeContextName = packageName.substring(0, packageName.length() - 1) + this.contextName;
        }
        return completeContextName;
    }

    public int hashCode() {
        return 47 + this.contextName.hashCode();
    }

    public boolean isGlobal() {
        return this.contextName.equals(GLOBAL_CONTEXT_NAME);
    }

    public boolean isSystem() {
        return this.contextName.equals(SYSTEM_CONTEXT_NAME);
    }

    public ISymbol put(String key, ISymbol value) {
        return this.symbolTable.put(key, value);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int i;
        this.contextName = stream.readUTF();
        int size = stream.readInt();
        this.symbolTable = new HashMap<String, ISymbol>(size + size / 10);
        EvalEngine.get().getContextPath().setGlobalContext(this);
        String[] table = new String[size];
        for (i = 0; i < size; ++i) {
            table[i] = stream.readUTF();
        }
        for (i = 0; i < size; ++i) {
            ISymbol symbol = (ISymbol)stream.readObject();
            this.symbolTable.put(table[i], symbol);
        }
    }

    public ISymbol remove(String key) {
        return this.symbolTable.remove(key);
    }

    public void setJavaClass(Class<?> javaClass) {
        this.javaClass = javaClass;
    }

    public int size() {
        return this.symbolTable.size();
    }

    public String toString() {
        return this.contextName;
    }

    private Object readResolve() {
        if (this.contextName.equals(DUMMY_CONTEXT_NAME)) {
            return DUMMY;
        }
        if (this.contextName.equals(SYSTEM_CONTEXT_NAME)) {
            return SYSTEM;
        }
        return this;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeUTF(this.contextName);
        Set<Map.Entry<String, ISymbol>> entrySet = this.symbolTable.entrySet();
        stream.writeInt(entrySet.size());
        for (Map.Entry<String, ISymbol> entry : entrySet) {
            stream.writeUTF(entry.getKey());
        }
        for (Map.Entry<String, ISymbol> entry : entrySet) {
            stream.writeObject(entry.getValue());
        }
    }
}

