/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.math.BigInteger;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.apfloat.FixedPrecisionApfloatHelper;
import org.hipparchus.fraction.BigFraction;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.BigIntegerLimitExceeded;
import org.matheclipse.core.expression.AbstractAST;
import org.matheclipse.core.expression.AbstractFractionSym;
import org.matheclipse.core.expression.AbstractIntegerSym;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;
import org.matheclipse.parser.client.ParserConfig;

public class ComplexSym
implements IComplex {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1489050560741527824L;
    private static final ComplexSym ZERO = ComplexSym.valueOf(0L, 1L, 0L, 1L);
    private static final ComplexSym MINUS_ONE = ComplexSym.valueOf(-1L, 1L, 0L, 1L);
    private static final ComplexSym ONE = ComplexSym.valueOf(1L, 1L, 0L, 1L);
    private static final ComplexSym POSITIVE_I = ComplexSym.valueOf(0L, 1L, 1L, 1L);
    private static final ComplexSym NEGATIVE_I = ComplexSym.valueOf(0L, 1L, -1L, 1L);
    private IRational fReal;
    private IRational fImaginary;
    private transient int fHashValue;

    public static ComplexSym valueOf(BigFraction real, BigFraction imaginary) {
        ComplexSym c = new ComplexSym();
        c.fReal = AbstractFractionSym.valueOf(real);
        c.fImaginary = AbstractFractionSym.valueOf(imaginary);
        return c;
    }

    public static ComplexSym valueOf(BigInteger real) {
        ComplexSym c = new ComplexSym();
        c.fReal = AbstractIntegerSym.valueOf(real);
        c.fImaginary = F.C0;
        return c;
    }

    public static ComplexSym valueOf(BigInteger real, BigInteger imaginary) {
        ComplexSym c = new ComplexSym();
        c.fReal = AbstractIntegerSym.valueOf(real);
        c.fImaginary = AbstractIntegerSym.valueOf(imaginary);
        return c;
    }

    public static ComplexSym valueOf(IFraction real) {
        ComplexSym c = new ComplexSym();
        c.fReal = real;
        c.fImaginary = F.C0;
        return c;
    }

    public static ComplexSym valueOf(IRational real) {
        ComplexSym c = new ComplexSym();
        c.fReal = real;
        c.fImaginary = F.C0;
        return c;
    }

    public static ComplexSym valueOf(IRational real, IRational imaginary) {
        ComplexSym c = new ComplexSym();
        c.fReal = real;
        c.fImaginary = imaginary;
        return c;
    }

    public static ComplexSym valueOf(long real_numerator, long real_denominator, long imag_numerator, long imag_denominator) {
        ComplexSym c = new ComplexSym();
        c.fReal = real_denominator == 1L ? AbstractIntegerSym.valueOf(real_numerator) : AbstractFractionSym.valueOf(real_numerator, real_denominator);
        c.fImaginary = imag_denominator == 1L ? AbstractIntegerSym.valueOf(imag_numerator) : AbstractFractionSym.valueOf(imag_numerator, imag_denominator);
        return c;
    }

    private ComplexSym() {
    }

    @Override
    public IExpr abs() {
        if (this.fReal.isZero()) {
            return this.fImaginary.abs();
        }
        if (this.fImaginary.isZero()) {
            return this.fReal.abs();
        }
        return F.Sqrt(this.fReal.multiply(this.fReal).add(this.fImaginary.multiply(this.fImaginary)));
    }

    @Override
    public IExpr complexArg() {
        IRational x = this.getRealPart();
        IRational y = this.getImaginaryPart();
        int xi = x.compareTo(F.C0);
        int yi = y.compareTo(F.C0);
        if (xi < 0) {
            if (yi < 0) {
                return F.Plus(F.Negate(S.Pi), (IExpr)F.ArcTan(F.Divide(y, x)));
            }
            return F.Plus((IExpr)S.Pi, (IExpr)F.ArcTan(F.Divide(y, x)));
        }
        if (xi > 0) {
            return F.ArcTan(F.Divide(y, x));
        }
        if (yi < 0) {
            return F.Plus((IExpr)F.Times((IExpr)F.CN1D2, (IExpr)S.Pi), (IExpr)F.ArcTan(F.Divide(x, y)));
        }
        if (yi > 0) {
            return F.Plus((IExpr)F.Times((IExpr)F.C1D2, (IExpr)S.Pi), (IExpr)F.ArcTan(F.Divide(x, y)));
        }
        return F.C0;
    }

    @Override
    public IExpr accept(IVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return visitor.visit(this);
    }

    public ComplexSym add(ComplexSym parm1) {
        return ComplexSym.valueOf(this.fReal.add(parm1.fReal), this.fImaginary.add(parm1.fImaginary));
    }

    @Override
    public IComplex add(IComplex parm1) {
        return ComplexSym.valueOf(this.fReal.add(parm1.getRealPart()), this.fImaginary.add(parm1.getImaginaryPart()));
    }

    @Override
    public ApcomplexNum apcomplexNumValue() {
        return ApcomplexNum.valueOf(this.apcomplexValue());
    }

    @Override
    public Apcomplex apcomplexValue() {
        FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
        long precision = h.precision();
        Apfloat real = h.divide(new Apfloat(this.fReal.toBigNumerator(), precision), new Apfloat(this.fReal.toBigDenominator(), precision));
        Apfloat imag = h.divide(new Apfloat(this.fImaginary.toBigNumerator(), precision), new Apfloat(this.fImaginary.toBigDenominator(), precision));
        return new Apcomplex(real, imag);
    }

    @Override
    public INumber ceilFraction() {
        return ComplexSym.valueOf(this.fReal.ceilFraction(), this.fImaginary.ceilFraction());
    }

    @Override
    public int compareAbsValueToOne() {
        IRational temp = this.fReal.multiply(this.fReal).add(this.fImaginary.multiply(this.fImaginary));
        return temp.compareTo(F.C1);
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof ComplexSym) {
            int cp = this.fReal.compareTo(((ComplexSym)expr).fReal);
            if (cp != 0) {
                return cp;
            }
            return this.fImaginary.compareTo(((ComplexSym)expr).fImaginary);
        }
        if (expr.isNumber()) {
            int c = this.fReal.compareTo(((INumber)expr).re());
            if (c != 0) {
                return c;
            }
            if (expr.isReal()) {
                return 1;
            }
            return this.fImaginary.compareTo(((INumber)expr).im());
        }
        return IComplex.super.compareTo(expr);
    }

    @Override
    public ComplexNum complexNumValue() {
        double nr = this.fReal.numerator().doubleValue();
        double dr = this.fReal.denominator().doubleValue();
        double ni = this.fImaginary.numerator().doubleValue();
        double di = this.fImaginary.denominator().doubleValue();
        return ComplexNum.valueOf(nr / dr, ni / di);
    }

    @Override
    public int complexSign() {
        int i = this.fReal.numerator().complexSign();
        if (i == 0) {
            return this.fImaginary.numerator().complexSign();
        }
        return i;
    }

    @Override
    public IComplex conjugate() {
        return ComplexSym.valueOf(this.fReal, this.fImaginary.negate());
    }

    public IExpr copy() {
        try {
            return (IExpr)this.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("ComplexSym.copy() failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public IExpr dec() {
        return this.add(MINUS_ONE);
    }

    @Override
    public IExpr inc() {
        return this.add(ONE);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ComplexSym) {
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            return this.fReal.equals(((ComplexSym)obj).fReal) && this.fImaginary.equals(((ComplexSym)obj).fImaginary);
        }
        return false;
    }

    @Override
    public boolean equalsInt(int i) {
        return false;
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        if (engine.isNumericMode()) {
            if (this.isImaginaryUnit()) {
                return F.CDI;
            }
            if (this.isNegativeImaginaryUnit()) {
                return F.CDNI;
            }
            return this.numericNumber();
        }
        INumber cTemp = this.normalize();
        return cTemp == this ? F.NIL : cTemp;
    }

    @Override
    public IComplex fractionalPart() {
        return ComplexSym.valueOf(this.fReal.fractionalPart(), this.fImaginary.fractionalPart());
    }

    @Override
    public IComplex integerPart() {
        return ComplexSym.valueOf(this.fReal.integerPart(), this.fImaginary.integerPart());
    }

    @Override
    public INumber floorFraction() {
        return ComplexSym.valueOf(this.fReal.floorFraction(), this.fImaginary.floorFraction());
    }

    @Override
    public String fullFormString() {
        StringBuilder buf = new StringBuilder("Complex");
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
            buf.append('(');
        } else {
            buf.append('[');
        }
        if (this.fReal.denominator().isOne()) {
            buf.append(this.fReal.numerator().toString());
        } else {
            buf.append("Rational");
            if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
                buf.append('(');
            } else {
                buf.append('[');
            }
            buf.append(this.fReal.numerator().toString());
            buf.append(',');
            buf.append(this.fReal.denominator().toString());
            if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
                buf.append(')');
            } else {
                buf.append(']');
            }
        }
        buf.append(',');
        if (this.fImaginary.denominator().isOne()) {
            buf.append(this.fImaginary.numerator().toString());
        } else {
            buf.append("Rational");
            if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
                buf.append('(');
            } else {
                buf.append('[');
            }
            buf.append(this.fImaginary.numerator().toString());
            buf.append(',');
            buf.append(this.fImaginary.denominator().toString());
            if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
                buf.append(')');
            } else {
                buf.append(']');
            }
        }
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
            buf.append(')');
        } else {
            buf.append(']');
        }
        return buf.toString();
    }

    @Override
    public IInteger[] gaussianIntegers() {
        if (this.fReal.isInteger() && this.fImaginary.isInteger()) {
            return new IInteger[]{(IInteger)this.fReal, (IInteger)this.fImaginary};
        }
        return null;
    }

    @Override
    public double imDoubleValue() {
        return this.fImaginary.doubleValue();
    }

    @Override
    public IRational getImaginaryPart() {
        return this.fImaginary;
    }

    @Override
    public double reDoubleValue() {
        return this.fReal.doubleValue();
    }

    @Override
    public IRational getRealPart() {
        return this.fReal;
    }

    public final int hashCode() {
        if (this.fHashValue == 0) {
            this.fHashValue = this.fReal.hashCode() * 29 + this.fImaginary.hashCode();
        }
        return this.fHashValue;
    }

    @Override
    public ISymbol head() {
        return S.Complex;
    }

    @Override
    public int hierarchy() {
        return 32;
    }

    @Override
    public IRational im() {
        return this.imRational();
    }

    @Override
    public IRational imRational() {
        if (this.fImaginary.denominator().isOne()) {
            return this.fImaginary.numerator();
        }
        return this.fImaginary;
    }

    @Override
    public CharSequence internalFormString(boolean symbolsAsFactoryMethod, int depth) {
        IExpr.SourceCodeProperties p = AbstractAST.stringFormProperties(symbolsAsFactoryMethod);
        return this.internalJavaString(p, depth, x -> null);
    }

    @Override
    public CharSequence internalJavaString(IExpr.SourceCodeProperties properties, int depth, Function<ISymbol, ? extends CharSequence> variables) {
        String prefix = AbstractAST.getPrefixF(properties);
        if (this.fReal.isZero()) {
            if (this.fImaginary.isOne()) {
                return new StringBuilder(prefix).append("CI");
            }
            if (this.fImaginary.isMinusOne()) {
                return new StringBuilder(prefix).append("CNI");
            }
        }
        BigInteger realNumerator = this.fReal.toBigNumerator();
        BigInteger realDenominator = this.fReal.toBigDenominator();
        BigInteger imagNumerator = this.fImaginary.toBigNumerator();
        BigInteger imagDenominator = this.fImaginary.toBigDenominator();
        if (NumberUtil.hasIntValue(realNumerator) && NumberUtil.hasIntValue(realDenominator) && NumberUtil.hasIntValue(imagNumerator) && NumberUtil.hasIntValue(imagDenominator)) {
            return prefix + "CC(" + realNumerator.intValue() + "L," + realDenominator.intValue() + "L," + imagNumerator.intValue() + "L," + imagDenominator.intValue() + "L)";
        }
        return prefix + "CC(" + this.fReal.internalJavaString(properties, depth, variables) + "," + this.fImaginary.internalJavaString(properties, depth, variables) + ")";
    }

    @Override
    public CharSequence internalScalaString(boolean symbolsAsFactoryMethod, int depth) {
        IExpr.SourceCodeProperties p = AbstractAST.scalaFormProperties(symbolsAsFactoryMethod);
        return this.internalJavaString(p, depth, x -> null);
    }

    @Override
    public IComplex inverse() {
        IRational tmp = this.fReal.multiply(this.fReal).add(this.fImaginary.multiply(this.fImaginary));
        return ComplexSym.valueOf(this.fReal.divideBy(tmp), this.fImaginary.negate().divideBy(tmp));
    }

    @Override
    public boolean isImaginaryUnit() {
        return this.equals(F.CI);
    }

    @Override
    public boolean isNegativeImaginaryUnit() {
        return this.equals(F.CNI);
    }

    @Override
    public boolean isZero() {
        return NumberUtil.isZero(this.fReal) && NumberUtil.isZero(this.fImaginary);
    }

    @Override
    public long leafCountSimplify() {
        return 1L + this.fReal.leafCountSimplify() + this.fImaginary.leafCountSimplify();
    }

    @Override
    public long leafCount() {
        return 1L + this.fReal.leafCount() + this.fImaginary.leafCount();
    }

    @Override
    public IComplex multiply(IComplex parm1) {
        this.checkBitLength();
        parm1.checkBitLength();
        return ComplexSym.valueOf(this.fReal.multiply(parm1.getRealPart()).subtract(this.fImaginary.multiply(parm1.getImaginaryPart())), this.fReal.multiply(parm1.getImaginaryPart()).add(parm1.getRealPart().multiply(this.fImaginary)));
    }

    @Override
    public IComplex[] quotientRemainder(IComplex c2) {
        IRational re = c2.re();
        IRational im = c2.im();
        IRational numeratorReal = this.fReal.multiply(re).subtract(this.fImaginary.multiply(im.negate()));
        IRational numeratorImaginary = this.fReal.multiply(im.negate()).add(re.multiply(this.fImaginary));
        IRational denominator = re.multiply(re).add(im.multiply(im));
        if (denominator.isZero()) {
            throw new IllegalArgumentException("Denominator can not be zero.");
        }
        IInteger divisionReal = numeratorReal.divideBy(denominator).roundExpr();
        IInteger divisionImaginary = numeratorImaginary.divideBy(denominator).roundExpr();
        IRational remainderReal = this.fReal.subtract(re.multiply(divisionReal)).subtract(im.multiply(divisionImaginary).negate());
        IRational remainderImaginary = this.fImaginary.subtract(re.multiply(divisionImaginary)).subtract(im.multiply(divisionReal));
        return new ComplexSym[]{ComplexSym.valueOf(divisionReal, divisionImaginary), ComplexSym.valueOf(remainderReal, remainderImaginary)};
    }

    @Override
    public ComplexSym negate() {
        return ComplexSym.valueOf(this.fReal.negate(), this.fImaginary.negate());
    }

    @Override
    public INumber normalize() {
        if (this.fImaginary.isZero()) {
            if (this.fReal instanceof IFraction) {
                if (this.fReal.denominator().isOne()) {
                    return this.fReal.numerator();
                }
                if (this.fReal.numerator().isZero()) {
                    return F.C0;
                }
            }
            return this.fReal;
        }
        boolean evaled = false;
        IRational newRe = this.fReal;
        IRational newIm = this.fImaginary;
        if (this.fReal instanceof IFraction) {
            if (this.fReal.denominator().isOne()) {
                newRe = this.fReal.numerator();
                evaled = true;
            }
            if (this.fReal.numerator().isZero()) {
                newRe = F.C0;
                evaled = true;
            }
        }
        if (this.fImaginary instanceof IFraction && this.fImaginary.denominator().isOne()) {
            newIm = this.fImaginary.numerator();
            evaled = true;
        }
        return evaled ? ComplexSym.valueOf(newRe, newIm) : this;
    }

    @Override
    public final INumber numericNumber() {
        return F.complexNum(this);
    }

    @Override
    public INumber opposite() {
        return ComplexSym.valueOf(this.fReal.negate(), this.fImaginary.negate());
    }

    @Override
    public IExpr plus(IExpr that) {
        if (that instanceof ComplexSym) {
            return this.add((ComplexSym)that);
        }
        if (that instanceof IInteger) {
            return this.add(ComplexSym.valueOf((IInteger)that));
        }
        if (that instanceof IFraction) {
            return this.add(ComplexSym.valueOf((IFraction)that));
        }
        return IComplex.super.plus(that);
    }

    @Override
    public IExpr power(IExpr that) {
        if (that instanceof IInteger) {
            if (that.isZero()) {
                if (!this.isZero()) {
                    return F.C1;
                }
                return IComplex.super.power(that);
            }
            if (that.isOne()) {
                return this;
            }
            if (that.isMinusOne()) {
                return this.inverse();
            }
            long n = ((IInteger)that).toLongDefault();
            if (n != Long.MIN_VALUE) {
                return this.power(n);
            }
        }
        return IComplex.super.power(that);
    }

    @Override
    public IComplex pow(int n) {
        if (n == 0 && this.fReal.isZero() && this.fImaginary.isZero()) {
            throw new ArithmeticException("Indeterminate: 0^0");
        }
        if (n == Integer.MIN_VALUE) {
            throw new ArithmeticException();
        }
        if (n == 1) {
            return this;
        }
        if (n < 0) {
            IComplex res = this.powPositive(-n);
            return res.inverse();
        }
        return this.powPositive(n);
    }

    private IComplex powPositive(long n) {
        IComplex r;
        if (this.fReal.isZero()) {
            long modN = n % 4L;
            if (this.fImaginary.isOne()) {
                if (modN == 0L) {
                    return ONE;
                }
                if (modN == 1L) {
                    return this;
                }
                if (modN == 2L) {
                    return MINUS_ONE;
                }
                return NEGATIVE_I;
            }
            if (this.fImaginary.isMinusOne()) {
                if (modN == 0L) {
                    return ONE;
                }
                if (modN == 1L) {
                    return NEGATIVE_I;
                }
                if (modN == 2L) {
                    return MINUS_ONE;
                }
                return POSITIVE_I;
            }
        }
        long exp = n;
        long b2pow = 0L;
        while ((exp & 1L) == 0L) {
            ++b2pow;
            exp >>= 1;
        }
        IComplex x = r = this;
        while ((exp >>= 1) > 0L) {
            x = x.multiply(x);
            if ((exp & 1L) == 0L) continue;
            r.checkBitLength();
            r = r.multiply(x);
        }
        r.checkBitLength();
        while (b2pow-- > 0L) {
            r = r.multiply(r);
            r.checkBitLength();
        }
        return r;
    }

    @Override
    public void checkBitLength() {
        if (Integer.MAX_VALUE > Config.MAX_BIT_LENGTH) {
            long bitLength = this.fReal.toBigNumerator().bitLength() + this.fReal.toBigDenominator().bitLength();
            if (bitLength > (long)(Config.MAX_BIT_LENGTH / 4)) {
                BigIntegerLimitExceeded.throwIt(bitLength);
            }
            if ((bitLength = (long)(this.fImaginary.toBigNumerator().bitLength() + this.fImaginary.toBigDenominator().bitLength())) > (long)(Config.MAX_BIT_LENGTH / 4)) {
                BigIntegerLimitExceeded.throwIt(bitLength);
            }
        }
    }

    @Override
    public IRational rationalFactor() {
        if (this.fReal.isZero()) {
            return this.fImaginary;
        }
        if (this.fImaginary.isZero()) {
            return this.fReal;
        }
        if (this.fReal.equals(this.fImaginary)) {
            return this.fReal;
        }
        return null;
    }

    @Override
    public IRational re() {
        return this.reRational();
    }

    @Override
    public IRational reRational() {
        if (this.fReal.denominator().isOne()) {
            return this.fReal.numerator();
        }
        return this.fReal;
    }

    @Override
    public INumber roundExpr() {
        return ComplexSym.valueOf(this.fReal.roundExpr(), this.fImaginary.roundExpr());
    }

    @Override
    public IComplex sqrtCC() {
        IExpr val2;
        IExpr a;
        IRational c = this.fReal;
        IRational d = this.fImaginary;
        IExpr val1 = c.multiply(c).add(d.multiply(d)).sqrt();
        if (val1.isRational() && (a = c.add((IRational)val1).divide(F.C2).sqrt()).isRational() && (val2 = ((IRational)val1).subtract(c).divide(F.C2).sqrt()).isRational()) {
            IRational b = (IRational)val2;
            return ComplexSym.valueOf((IRational)a, d.complexSign() >= 0 ? b : b.negate());
        }
        return null;
    }

    @Override
    public IExpr times(IExpr that) {
        if (that instanceof ComplexSym) {
            return this.multiply((ComplexSym)that);
        }
        if (that instanceof IInteger) {
            return this.multiply(ComplexSym.valueOf((IInteger)that));
        }
        if (that instanceof IFraction) {
            return this.multiply(ComplexSym.valueOf((IFraction)that));
        }
        return IComplex.super.times(that);
    }

    @Override
    public IAST toPolarCoordinates() {
        return F.list(this.abs(), this.complexArg());
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            OutputFormFactory.get().convertComplex(sb, this, Integer.MIN_VALUE, false);
            return sb.toString();
        }
        catch (Exception e1) {
            StringBuilder tb = new StringBuilder();
            tb.append('(');
            tb.append(this.fReal.toString());
            tb.append(")+I*(");
            tb.append(this.fImaginary.toString());
            tb.append(')');
            return tb.toString();
        }
    }
}

