/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import com.google.common.math.DoubleMath;
import java.math.RoundingMode;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatRuntimeException;
import org.hipparchus.complex.Complex;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.expression.AbstractAST;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.form.DoubleToMMA;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;
import org.matheclipse.parser.client.ParserConfig;

public class ComplexNum
implements IComplexNum {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = -6033055105824482264L;
    public static final ComplexNum I = ComplexNum.valueOf(0.0, 1.0);
    public static final ComplexNum INF = ComplexNum.valueOf(Complex.INF);
    public static final ComplexNum NaN = ComplexNum.valueOf(Complex.NaN);
    public static final ComplexNum NI = ComplexNum.valueOf(0.0, -1.0);
    public static final ComplexNum MINUS_ONE = ComplexNum.valueOf(-1.0, 0.0);
    public static final ComplexNum ONE = ComplexNum.valueOf(1.0, 0.0);
    public static final ComplexNum ZERO = ComplexNum.valueOf(0.0, 0.0);
    Complex fComplex;

    public static double dabs(Complex c) {
        if (c.isNaN()) {
            return Double.NaN;
        }
        if (c.isInfinite()) {
            return Double.POSITIVE_INFINITY;
        }
        if (Math.abs(c.getReal()) < Math.abs(c.getImaginary())) {
            if (F.isZero(c.getImaginary())) {
                return Math.abs(c.getReal());
            }
            double q = c.getReal() / c.getImaginary();
            return Math.abs(c.getImaginary()) * Math.sqrt(1.0 + q * q);
        }
        if (F.isZero(c.getReal())) {
            return Math.abs(c.getImaginary());
        }
        double q = c.getImaginary() / c.getReal();
        return Math.abs(c.getReal()) * Math.sqrt(1.0 + q * q);
    }

    private static ComplexNum newInstance(Complex value) {
        return new ComplexNum(value);
    }

    public static ComplexNum valueOf(Complex c) {
        double real = c.getReal();
        double imaginary = c.getImaginary();
        if (real == 0.0 || real == -0.0) {
            if (imaginary == 0.0 || imaginary == -0.0) {
                return ZERO;
            }
            return ComplexNum.newInstance(new Complex(0.0, imaginary));
        }
        if (imaginary == 0.0 || imaginary == -0.0) {
            return ComplexNum.newInstance(new Complex(real, 0.0));
        }
        return ComplexNum.newInstance(c);
    }

    public static ComplexNum valueOf(double real) {
        if (real == 0.0 || real == -0.0) {
            return ZERO;
        }
        return ComplexNum.newInstance(new Complex(real, 0.0));
    }

    public static ComplexNum valueOf(double real, double imaginary) {
        if (real == 0.0 || real == -0.0) {
            if (imaginary == 0.0 || imaginary == -0.0) {
                return ComplexNum.newInstance(new Complex(0.0, 0.0));
            }
            return ComplexNum.newInstance(new Complex(0.0, imaginary));
        }
        if (imaginary == 0.0 || imaginary == -0.0) {
            return ComplexNum.newInstance(new Complex(real, 0.0));
        }
        return ComplexNum.newInstance(new Complex(real, imaginary));
    }

    public static ComplexNum valueOf(INum d) {
        double real = d.getRealPart();
        if (real == 0.0 || real == -0.0) {
            return ZERO;
        }
        return ComplexNum.newInstance(new Complex(real, 0.0));
    }

    private ComplexNum(double r, double i) {
        this.fComplex = new Complex(r, i);
    }

    private ComplexNum(Complex complex) {
        this.fComplex = complex;
    }

    @Override
    public IExpr accept(IVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return visitor.visit(this);
    }

    private ComplexNum add(ComplexNum addend) {
        return ComplexNum.newInstance(this.fComplex.add(addend.fComplex));
    }

    @Override
    public IComplexNum add(IComplexNum val) {
        if (val instanceof ApcomplexNum) {
            return this.apcomplexNumValue().add(val);
        }
        return ComplexNum.newInstance(this.fComplex.add(((ComplexNum)val).fComplex));
    }

    @Override
    public ApcomplexNum apcomplexNumValue() {
        return ApcomplexNum.valueOf(this.apcomplexValue());
    }

    @Override
    public Apcomplex apcomplexValue() {
        return new Apcomplex(new Apfloat(this.fComplex.getReal()), new Apfloat(this.fComplex.getImaginary()));
    }

    @Override
    public INumber ceilFraction() throws ArithmeticException {
        try {
            return F.complex(NumberUtil.toLong(Math.ceil(this.fComplex.getReal())), NumberUtil.toLong(Math.ceil(this.fComplex.getImaginary())));
        }
        catch (ArithmeticException ae) {
            ArgumentTypeException.throwArg(this, F.Ceiling(this));
            return null;
        }
    }

    @Override
    public int compareAbsValueToOne() {
        double temp = this.dabs();
        return Double.compare(temp, 1.0);
    }

    @Override
    public int compareTo(Complex that) {
        long l2;
        if (this.fComplex.getReal() < that.getReal()) {
            return -1;
        }
        if (this.fComplex.getReal() > that.getReal()) {
            return 1;
        }
        long l1 = Double.doubleToLongBits(this.fComplex.getReal());
        if (l1 < (l2 = Double.doubleToLongBits(that.getReal()))) {
            return -1;
        }
        if (l1 > l2) {
            return 1;
        }
        if (F.isZero(that.getImaginary())) {
            if (!F.isZero(this.imDoubleValue())) {
                return 1;
            }
        } else if (F.isZero(this.imDoubleValue())) {
            return -1;
        }
        if (this.fComplex.getImaginary() < that.getImaginary()) {
            return -1;
        }
        if (this.fComplex.getImaginary() > that.getImaginary()) {
            return 1;
        }
        l1 = Double.doubleToLongBits(this.fComplex.getImaginary());
        if (l1 < (l2 = Double.doubleToLongBits(that.getImaginary()))) {
            return -1;
        }
        if (l1 > l2) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr.isNumber()) {
            if (expr instanceof ComplexNum) {
                return this.compareTo(((ComplexNum)expr).fComplex);
            }
            if (expr instanceof ApcomplexNum) {
                ApcomplexNum apcomplexNum = (ApcomplexNum)expr;
                return -1 * apcomplexNum.compareTo(this.apcomplexNumValue());
            }
            return this.compareTo(new Complex(((INumber)expr).reDoubleValue(), ((INumber)expr).imDoubleValue()));
        }
        return -1;
    }

    @Override
    public ComplexNum complexNumValue() {
        return this;
    }

    @Override
    public int complexSign() {
        int i = (int)Math.signum(this.fComplex.getReal());
        if (i == 0) {
            return (int)Math.signum(this.fComplex.getImaginary());
        }
        return i;
    }

    public Complex complexValue() {
        return this.fComplex;
    }

    @Override
    public IComplexNum conjugate() {
        return ComplexNum.newInstance(this.fComplex.conjugate());
    }

    public IExpr copy() {
        try {
            return (IExpr)this.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("ComplexNum.copy() failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public IExpr copySign(IExpr that) {
        if (that instanceof ComplexNum) {
            return ComplexNum.newInstance(this.fComplex.copySign(((ComplexNum)that).fComplex));
        }
        if (that instanceof Num) {
            return ComplexNum.newInstance(this.fComplex.copySign(((Num)that).fDouble));
        }
        return IComplexNum.super.copySign(that);
    }

    @Override
    public IExpr dec() {
        return this.add(MINUS_ONE);
    }

    @Override
    public IExpr inc() {
        return this.add(ONE);
    }

    @Override
    public double dabs() {
        return ComplexNum.dabs(this.fComplex);
    }

    @Override
    public long determinePrecision() {
        return 16L;
    }

    @Override
    public IComplexNum divide(IComplexNum that) {
        if (that instanceof ApcomplexNum) {
            return this.apcomplexNumValue().divide(that);
        }
        return ComplexNum.newInstance(this.fComplex.divide(((ComplexNum)that).fComplex));
    }

    @Override
    public Num abs() {
        return Num.valueOf(this.dabs());
    }

    @Override
    public IExpr complexArg() {
        return F.num(this.fComplex.getArgument());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ComplexNum) {
            return this.fComplex.equals((Object)((ComplexNum)obj).fComplex);
        }
        return false;
    }

    @Override
    public boolean equalsInt(int i) {
        return false;
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        if (this.fComplex.isInfinite()) {
            return F.CComplexInfinity;
        }
        if (this.fComplex.isNaN()) {
            return S.Indeterminate;
        }
        if (engine.isNumericMode() && engine.isArbitraryMode()) {
            return ApcomplexNum.valueOf(this.getRealPart(), this.getImaginaryPart());
        }
        return F.NIL;
    }

    @Override
    public Complex evalComplex() {
        return this.fComplex;
    }

    @Override
    public INumber evalNumber() {
        return this;
    }

    @Override
    public INumber fractionalPart() {
        return F.complexNum(this.getRealPart() % 1.0, this.getImaginaryPart() % 1.0);
    }

    @Override
    public String fullFormString() {
        int indx;
        double re = this.fComplex.getReal();
        double im = this.fComplex.getImaginary();
        StringBuilder buf = new StringBuilder("Complex");
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
            buf.append('(');
        } else {
            buf.append('[');
        }
        Object str = Double.toString(re);
        if (!ParserConfig.EXPLICIT_TIMES_OPERATOR) {
            indx = ((String)str).indexOf("E");
            str = indx > 0 ? ((String)str).replace("E", "`*^") : (String)str + "`";
        }
        buf.append((String)str);
        buf.append(',');
        str = Double.toString(im);
        if (!ParserConfig.EXPLICIT_TIMES_OPERATOR) {
            indx = ((String)str).indexOf("E");
            str = indx > 0 ? ((String)str).replace("E", "`*^") : (String)str + "`";
        }
        buf.append((String)str);
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
            buf.append(')');
        } else {
            buf.append(']');
        }
        return buf.toString();
    }

    @Override
    public IComplex integerPart() {
        double re = this.fComplex.getReal();
        double im = this.fComplex.getImaginary();
        IInteger reInt = re < 0.0 ? F.ZZ(NumberUtil.toLong(Math.ceil(re))) : F.ZZ(NumberUtil.toLong(Math.floor(re)));
        IInteger imInt = im < 0.0 ? F.ZZ(NumberUtil.toLong(Math.ceil(im))) : F.ZZ(NumberUtil.toLong(Math.floor(im)));
        return F.complex(reInt, imInt);
    }

    @Override
    public INumber floorFraction() throws ArithmeticException {
        try {
            return F.complex(NumberUtil.toLong(Math.floor(this.fComplex.getReal())), NumberUtil.toLong(Math.floor(this.fComplex.getImaginary())));
        }
        catch (ArithmeticException ae) {
            ArgumentTypeException.throwArg(this, F.Floor(this));
            return null;
        }
    }

    public Complex getCMComplex() {
        return new Complex(this.fComplex.getReal(), this.fComplex.getImaginary());
    }

    @Override
    public ISignedNumber im() {
        return F.num(this.getImaginaryPart());
    }

    @Override
    public double imDoubleValue() {
        return this.fComplex.getImaginary();
    }

    @Override
    public double getImaginaryPart() {
        double temp = this.fComplex.getImaginary();
        if (temp == -0.0) {
            temp = 0.0;
        }
        return temp;
    }

    @Override
    public ISignedNumber re() {
        return F.num(this.getRealPart());
    }

    @Override
    public IExpr sqrt() {
        return ComplexNum.valueOf(this.fComplex.sqrt());
    }

    @Override
    public double reDoubleValue() {
        return this.fComplex.getReal();
    }

    @Override
    public INumber roundExpr() throws ArithmeticException {
        return F.complex(F.ZZ(DoubleMath.roundToBigInteger((double)this.fComplex.getReal(), (RoundingMode)RoundingMode.HALF_EVEN)), F.ZZ(DoubleMath.roundToBigInteger((double)this.fComplex.getImaginary(), (RoundingMode)RoundingMode.HALF_EVEN)));
    }

    @Override
    public double getRealPart() {
        double temp = this.fComplex.getReal();
        if (temp == -0.0) {
            temp = 0.0;
        }
        return temp;
    }

    public final int hashCode() {
        return this.fComplex.hashCode();
    }

    @Override
    public ISymbol head() {
        return S.Complex;
    }

    @Override
    public int hierarchy() {
        return 4;
    }

    @Override
    public CharSequence internalFormString(boolean symbolsAsFactoryMethod, int depth) {
        IExpr.SourceCodeProperties p = AbstractAST.stringFormProperties(symbolsAsFactoryMethod);
        return this.internalJavaString(p, depth, x -> null);
    }

    @Override
    public CharSequence internalJavaString(IExpr.SourceCodeProperties properties, int depth, Function<ISymbol, ? extends CharSequence> variables) {
        String prefix = AbstractAST.getPrefixF(properties);
        return new StringBuilder(prefix).append("complexNum(").append(this.fComplex.getReal()).append(",").append(this.fComplex.getImaginary()).append(")");
    }

    @Override
    public CharSequence internalScalaString(boolean symbolsAsFactoryMethod, int depth) {
        IExpr.SourceCodeProperties p = AbstractAST.scalaFormProperties(symbolsAsFactoryMethod);
        return this.internalJavaString(p, depth, x -> null);
    }

    @Override
    public IExpr inverse() {
        double tmp = this.fComplex.getReal() * this.fComplex.getReal() + this.fComplex.getImaginary() * this.fComplex.getImaginary();
        return ComplexNum.valueOf(this.fComplex.getReal() / tmp, -this.fComplex.getImaginary() / tmp);
    }

    @Override
    public boolean isImaginaryUnit() {
        return this.equals(I);
    }

    public boolean isInfinite() {
        return this.fComplex.isInfinite();
    }

    public boolean isNaN() {
        return this.fComplex.isNaN();
    }

    @Override
    public boolean isNegativeImaginaryUnit() {
        return this.equals(NI);
    }

    @Override
    public boolean isNumIntValue() {
        return F.isZero(this.fComplex.getImaginary()) && F.isNumIntValue(this.fComplex.getReal());
    }

    @Override
    public int toIntDefault(int defaultValue) {
        double re;
        if (F.isZero(this.fComplex.getImaginary()) && DoubleMath.isMathematicalInteger((double)(re = this.fComplex.getReal()))) {
            return (int)re;
        }
        return defaultValue;
    }

    @Override
    public boolean isSame(IExpr expression, double epsilon) {
        if (expression instanceof ComplexNum) {
            return F.isZero(this.fComplex.getReal() - ((ComplexNum)expression).fComplex.getReal(), epsilon) && F.isZero(this.fComplex.getImaginary() - ((ComplexNum)expression).fComplex.getImaginary(), epsilon);
        }
        return false;
    }

    @Override
    public boolean isZero() {
        return F.isZero(this.fComplex.getReal(), Config.DOUBLE_TOLERANCE) && F.isZero(this.fComplex.getImaginary(), Config.DOUBLE_TOLERANCE);
    }

    @Override
    public long leafCountSimplify() {
        return 5L;
    }

    public ComplexNum multiply(ComplexNum factor) {
        return ComplexNum.newInstance(this.fComplex.multiply(factor.fComplex));
    }

    @Override
    public IComplexNum multiply(IComplexNum val) {
        if (val instanceof ApcomplexNum) {
            return this.apcomplexNumValue().multiply(val);
        }
        return ComplexNum.newInstance(this.fComplex.multiply(((ComplexNum)val).fComplex));
    }

    @Override
    public ComplexNum negate() {
        return ComplexNum.newInstance(this.fComplex.negate());
    }

    @Override
    public INumber opposite() {
        return ComplexNum.newInstance(this.fComplex.negate());
    }

    @Override
    public IExpr plus(IExpr that) {
        if (that instanceof ComplexNum) {
            return ComplexNum.newInstance(this.fComplex.add(((ComplexNum)that).fComplex));
        }
        if (that instanceof ApcomplexNum) {
            ApcomplexNum acn = (ApcomplexNum)that;
            return ApcomplexNum.valueOf(this.getRealPart(), this.getImaginaryPart()).add(acn);
        }
        if (that instanceof ApfloatNum) {
            ApfloatNum afn = (ApfloatNum)that;
            return ApcomplexNum.valueOf(this.getRealPart(), this.getImaginaryPart()).add(ApcomplexNum.valueOf(afn.fApfloat, (Apfloat)Apcomplex.ZERO));
        }
        if (that instanceof Num) {
            return this.add(ComplexNum.valueOf(((Num)that).getRealPart()));
        }
        return IComplexNum.super.plus(that);
    }

    @Override
    public IComplexNum pow(IComplexNum val) {
        if (Complex.equals((Complex)this.fComplex, (Complex)Complex.ZERO, (double)Config.DOUBLE_EPSILON)) {
            ISignedNumber sn = val.re();
            if (sn.isNegative()) {
                IOFunctions.printMessage(S.Power, "infy", F.list(F.Power((IExpr)F.C0, sn)), EvalEngine.get());
                return INF;
            }
            if (sn.isZero()) {
                IOFunctions.printMessage(S.Power, "indet", F.list(F.Power((IExpr)F.C0, F.C0)), EvalEngine.get());
                return NaN;
            }
            return ZERO;
        }
        return ComplexNum.newInstance(this.fComplex.pow(((ComplexNum)val).fComplex));
    }

    @Override
    public long precision() throws ApfloatRuntimeException {
        return 15L;
    }

    @Override
    public IComplexNum subtract(IComplexNum subtrahend) {
        if (subtrahend instanceof ApcomplexNum) {
            return this.apcomplexNumValue().subtract((ApcomplexNum)subtrahend);
        }
        return ComplexNum.newInstance(this.fComplex.subtract(((ComplexNum)subtrahend).fComplex));
    }

    @Override
    public IExpr times(IExpr that) {
        if (that instanceof ComplexNum) {
            return ComplexNum.newInstance(this.fComplex.multiply(((ComplexNum)that).fComplex));
        }
        if (that instanceof ApcomplexNum) {
            return this.apcomplexNumValue().multiply(that);
        }
        if (that instanceof ApfloatNum) {
            return ApcomplexNum.valueOf(this.getRealPart(), this.getImaginaryPart()).multiply(that);
        }
        if (that instanceof Num) {
            return this.multiply(ComplexNum.valueOf(((Num)that).getRealPart()));
        }
        return IComplexNum.super.times(that);
    }

    @Override
    public IAST toPolarCoordinates() {
        return F.list(this.abs(), this.complexArg());
    }

    public String toString() {
        if (ParserConfig.EXPLICIT_TIMES_OPERATOR) {
            return this.fComplex.toString();
        }
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        double realPart = this.fComplex.getReal();
        double imaginaryPart = this.fComplex.getImaginary();
        if (realPart != 0.0 || imaginaryPart == 0.0) {
            DoubleToMMA.doubleToMMA(buf, realPart, 5, 7);
        }
        if (imaginaryPart != 0.0) {
            if (imaginaryPart < 0.0) {
                buf.append("-I*");
                imaginaryPart *= -1.0;
            } else {
                if (realPart != 0.0) {
                    buf.append("+");
                }
                buf.append("I*");
            }
            DoubleToMMA.doubleToMMA(buf, imaginaryPart, 5, 7);
        }
        buf.append(")");
        return buf.toString();
    }

    public static ComplexNum[] quotientRemainder(ComplexNum cn1, ComplexNum cn2) {
        Complex c1 = cn1.fComplex;
        Complex c2 = cn2.fComplex;
        Complex[] arr = ComplexNum.quotientRemainder(c1, c2);
        return new ComplexNum[]{ComplexNum.valueOf(arr[0]), ComplexNum.valueOf(arr[1])};
    }

    public static Complex[] quotientRemainder(Complex c1, Complex c2) {
        Complex remainder = c1.remainder(c2);
        Complex quotient = c1.subtract(remainder).divide(c2).rint();
        return new Complex[]{quotient, remainder};
    }

    @Override
    public IExpr cos() {
        return ComplexNum.valueOf(this.fComplex.cos());
    }

    @Override
    public IExpr cosh() {
        return ComplexNum.valueOf(this.fComplex.cosh());
    }

    @Override
    public IExpr exp() {
        return ComplexNum.valueOf(this.fComplex.exp());
    }

    @Override
    public IExpr log() {
        return ComplexNum.valueOf(this.fComplex.log());
    }

    @Override
    public IExpr pow(int n) {
        return ComplexNum.valueOf(this.fComplex.pow(n));
    }

    @Override
    public IExpr rootN(int n) {
        return ComplexNum.valueOf(this.fComplex.rootN(n));
    }

    @Override
    public IExpr sign() {
        if (this.isNaN() || this.isZero()) {
            return this;
        }
        return ComplexNum.valueOf(this.fComplex.sign());
    }

    @Override
    public IExpr sin() {
        return ComplexNum.valueOf(this.fComplex.sin());
    }

    @Override
    public IExpr sinh() {
        return ComplexNum.valueOf(this.fComplex.sinh());
    }

    @Override
    public IExpr tan() {
        return ComplexNum.valueOf(this.fComplex.tan());
    }

    @Override
    public IExpr tanh() {
        return ComplexNum.valueOf(this.fComplex.tanh());
    }

    @Override
    public IExpr ulp() {
        return ComplexNum.valueOf(this.fComplex.ulp());
    }

    @Override
    public IExpr getPi() {
        return F.num(Math.PI);
    }

    @Override
    public IExpr toDegrees() {
        return ComplexNum.valueOf(this.fComplex.toDegrees());
    }

    @Override
    public IExpr toRadians() {
        return ComplexNum.valueOf(this.fComplex.toRadians());
    }
}

