/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.function.DoubleFunction;
import java.util.function.Predicate;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractCorePredicateEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractPredicateEvaluator;
import org.matheclipse.core.eval.interfaces.ICoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.ISignedNumberConstant;
import org.matheclipse.core.eval.interfaces.ISymbolEvaluator;
import org.matheclipse.core.expression.Context;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.Symbol;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IBooleanFormula;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IComparatorFunction;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPredicate;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.ParserConfig;

public class BuiltInSymbol
extends Symbol
implements IBuiltInSymbol {
    private static final long serialVersionUID = -4991038487281911261L;
    public static final DummyEvaluator DUMMY_EVALUATOR = new DummyEvaluator();
    private transient IEvaluator fEvaluator = DUMMY_EVALUATOR;
    private transient int fOrdinal;

    public BuiltInSymbol(String symbolName, int ordinal) {
        super(symbolName, Context.SYSTEM);
        this.fOrdinal = ordinal;
        if (symbolName.charAt(0) != '$' || ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
            this.fAttributes = Config.BUILTIN_PROTECTED;
        }
    }

    @Override
    public final void assignValue(IExpr value, boolean setDelayed) {
        super.assignValue(value, setDelayed);
    }

    @Override
    public final void clearAttributes(int attributes) {
        if (Config.FUZZ_TESTING) {
            throw new NullPointerException();
        }
        super.clearAttributes(attributes);
    }

    @Override
    public void clearAll(EvalEngine engine) {
        if (Config.FUZZ_TESTING) {
            throw new NullPointerException();
        }
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof BuiltInSymbol) {
            int ordinal = ((BuiltInSymbol)expr).fOrdinal;
            return this.fOrdinal < ordinal ? -1 : (this.fOrdinal == ordinal ? 0 : 1);
        }
        return super.compareTo(expr);
    }

    @Override
    public String definitionToString() {
        this.getEvaluator();
        return super.definitionToString();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public IExpr.COMPARE_TERNARY equalTernary(IExpr arg2, EvalEngine engine) {
        if (this.isIndeterminate() || arg2.isIndeterminate()) {
            return IExpr.COMPARE_TERNARY.UNDECIDABLE;
        }
        if (this == arg2) {
            return IExpr.COMPARE_TERNARY.TRUE;
        }
        if (this.isTrue() ? arg2.isFalse() : this.isFalse() && arg2.isTrue()) {
            return IExpr.COMPARE_TERNARY.FALSE;
        }
        if (this.isConstantAttribute() && arg2.isConstantAttribute()) {
            return IExpr.COMPARE_TERNARY.FALSE;
        }
        return super.equalTernary(arg2, engine);
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        if (this.fEvaluator instanceof ISymbolEvaluator) {
            if (engine.isNumericMode()) {
                if (engine.isArbitraryMode()) {
                    return ((ISymbolEvaluator)this.fEvaluator).apfloatEval(this, engine);
                }
                return ((ISymbolEvaluator)this.fEvaluator).numericEval(this, engine);
            }
            return ((ISymbolEvaluator)this.fEvaluator).evaluate(this, engine);
        }
        if (this.hasAssignedSymbolValue()) {
            return this.assignedValue();
        }
        return F.NIL;
    }

    @Override
    public IExpr evaluateHead(IAST ast, EvalEngine engine) {
        return this.isConstantAttribute() ? F.NIL : super.evaluateHead(ast, engine);
    }

    @Override
    public IEvaluator getEvaluator() {
        return this.fEvaluator;
    }

    @Override
    public int hashCode() {
        return this.fOrdinal;
    }

    @Override
    public int ordinal() {
        return this.fOrdinal;
    }

    @Override
    protected CharSequence internalJavaStringAsFactoryMethod() {
        if (Config.RUBI_CONVERT_SYMBOLS && this.fOrdinal >= 1) {
            if (Config.RUBI_CONVERT_SYMBOLS && "C".equals(this.fSymbolName)) {
                return new StringBuilder(this.fSymbolName).append("Symbol");
            }
            return this.fSymbolName;
        }
        return super.internalJavaStringAsFactoryMethod();
    }

    @Override
    public boolean isCoreFunctionSymbol() {
        return this.fEvaluator instanceof ICoreFunctionEvaluator;
    }

    @Override
    public boolean isBooleanFormulaSymbol() {
        return this.fEvaluator instanceof IBooleanFormula;
    }

    @Override
    public boolean isComparatorFunctionSymbol() {
        return this.fEvaluator instanceof IComparatorFunction;
    }

    @Override
    public boolean isPredicateFunctionSymbol() {
        return this.fEvaluator instanceof IPredicate;
    }

    @Override
    public final boolean isHoldOrHoldFormOrDefer() {
        return this.equals(S.Defer) || this.equals(S.Hold) || this.equals(S.HoldForm);
    }

    @Override
    public final boolean isE() {
        return this == S.E;
    }

    @Override
    public final boolean isFalse() {
        return this == S.False;
    }

    @Override
    public final boolean isIndeterminate() {
        return this == S.Indeterminate;
    }

    @Override
    public final boolean isPi() {
        return this == S.Pi;
    }

    @Override
    public final boolean isNegative() {
        if (this.isRealConstant()) {
            return ((ISignedNumberConstant)((Object)this.fEvaluator)).isNegative();
        }
        return false;
    }

    @Override
    public final boolean isPositive() {
        if (this.isRealConstant()) {
            return ((ISignedNumberConstant)((Object)this.fEvaluator)).isPositive();
        }
        return false;
    }

    @Override
    public final boolean isRealConstant() {
        return this.fEvaluator instanceof ISignedNumberConstant;
    }

    @Override
    public final boolean isSymbolID(int ... ids) {
        for (int i = 0; i < ids.length; ++i) {
            if (this.fOrdinal != ids[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isTrue() {
        return this == S.True;
    }

    @Override
    public IExpr of(EvalEngine engine, IExpr ... args) {
        if (this.fEvaluator instanceof ICoreFunctionEvaluator) {
            ICoreFunctionEvaluator coreFunction = (ICoreFunctionEvaluator)this.getEvaluator();
            IASTAppendable ast = F.ast(args, this);
            return coreFunction.evaluate(ast, engine);
        }
        return super.of(engine, args);
    }

    @Override
    public boolean ofQ(EvalEngine engine, IExpr ... args) {
        if (args.length == 1 && this.fEvaluator instanceof AbstractCorePredicateEvaluator) {
            AbstractCorePredicateEvaluator coreFunction = (AbstractCorePredicateEvaluator)this.getEvaluator();
            return coreFunction.evalArg1Boole(args[0], engine);
        }
        return super.ofQ(engine, args);
    }

    @Override
    public IExpr mapConstantDouble(DoubleFunction<IExpr> function) {
        double value;
        if (this.fEvaluator instanceof ISignedNumberConstant && (value = ((ISignedNumberConstant)((Object)this.fEvaluator)).evalReal()) < 2.147483647E9 && value > -2.147483648E9) {
            return function.apply(value);
        }
        return F.NIL;
    }

    @Override
    public final void setAttributes(int attributes) {
        super.setAttributes(attributes | Config.BUILTIN_PROTECTED);
    }

    @Override
    public final void setEvaluator(IEvaluator evaluator) {
        evaluator.setUp(this);
        this.fEvaluator = evaluator;
    }

    @Override
    public final void setPredicateQ(Predicate<IExpr> predicate) {
        this.fEvaluator = new PredicateEvaluator(predicate);
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        this.fOrdinal = stream.readInt();
    }

    @Override
    public Object readResolve() {
        return S.symbol(this.fOrdinal);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(this.fOrdinal);
    }

    private static class DummyEvaluator
    implements IEvaluator {
        private DummyEvaluator() {
        }

        @Override
        public void await() throws InterruptedException {
            F.await();
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class PredicateEvaluator
    extends AbstractPredicateEvaluator
    implements IPredicate {
        Predicate<IExpr> predicate;

        public PredicateEvaluator(Predicate<IExpr> predicate) {
            this.predicate = predicate;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return this.predicate.test(ast.arg1()) ? S.True : S.False;
        }

        @Override
        public boolean evalArg1Boole(IExpr arg1, EvalEngine engine) {
            return this.predicate.test(arg1);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return IFunctionEvaluator.ARGS_1_1;
        }
    }
}

