/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.Collator;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.AttributeFunctions;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.exception.RuleCreationError;
import org.matheclipse.core.expression.AbstractAST;
import org.matheclipse.core.expression.Context;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.Symbol;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.generic.UnaryVariable2Slot;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcherAndInvoker;
import org.matheclipse.core.patternmatching.RulesData;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;
import org.matheclipse.parser.client.ParserConfig;

public class BuiltInDummy
implements IBuiltInSymbol,
Serializable {
    private static final long serialVersionUID = -1921824292485125087L;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Collator US_COLLATOR = Collator.getInstance(Locale.US);
    protected int fAttributes = 0;
    protected int fEvalFlags = 0;
    protected transient RulesData fRulesData;
    protected String fSymbolName;
    private IExpr fValue = null;
    private transient IEvaluator fEvaluator;

    public BuiltInDummy(String symbolName) {
        this.fSymbolName = symbolName;
    }

    @Override
    public IExpr accept(IVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return visitor.visit(this);
    }

    @Override
    public final void addAttributes(int attributes) {
        this.fAttributes |= attributes;
        if (this.isLocked()) {
            throw new RuleCreationError(this);
        }
        EvalEngine engine = EvalEngine.get();
        engine.addModifiedVariable(this);
    }

    @Override
    public final ISymbol addEvalFlags(int i) {
        this.fEvalFlags |= i;
        return this;
    }

    @Override
    public final IExpr apply(IExpr ... expressions) {
        return F.ast(expressions, this);
    }

    @Override
    public IExpr assignedValue() {
        Context globalContext = EvalEngine.get().getContextPath().getGlobalContext();
        ISymbol globalSubstitute = globalContext.get(this.fSymbolName);
        if (globalSubstitute != null) {
            return globalSubstitute.assignedValue();
        }
        this.addEvalFlags(1);
        return this.fValue;
    }

    @Override
    public final void assignValue(IExpr value, boolean setDelayed) {
        Context globalContext = EvalEngine.get().getContextPath().getGlobalContext();
        ISymbol globalSubstitute = globalContext.get(this.fSymbolName);
        if (globalSubstitute != null) {
            globalSubstitute.assignValue(value, false);
            return;
        }
        this.fValue = value;
        this.clearEvalFlags(1);
        if (setDelayed) {
            this.addEvalFlags(0x10000002);
        } else {
            this.clearEvalFlags(0x10000002);
        }
    }

    @Override
    public final void clear(EvalEngine engine) {
        if (!engine.isPackageMode() && this.isLocked()) {
            throw new RuleCreationError(this);
        }
        this.clearValue();
        if (this.fRulesData != null) {
            this.fRulesData = null;
        }
    }

    @Override
    public final void clearAll(EvalEngine engine) {
        this.clear(engine);
        this.fAttributes = 0;
    }

    @Override
    public final void clearAttributes(int attributes) {
        this.fAttributes &= 0xFFFFFFFF ^ attributes;
        if (this.isLocked()) {
            throw new RuleCreationError(this);
        }
        EvalEngine engine = EvalEngine.get();
        engine.addModifiedVariable(this);
    }

    @Override
    public void clearEvalFlags(int flags) {
        this.fEvalFlags &= 0xFFFFFFFF ^ flags;
    }

    @Override
    public void clearValue() {
        this.fValue = null;
        this.clearEvalFlags(1);
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof ISymbol) {
            if (this == expr) {
                return 0;
            }
            return US_COLLATOR.compare(this.fSymbolName, ((ISymbol)expr).getSymbolName());
        }
        if (expr.isNot() && expr.first().isSymbol()) {
            int cp = this.compareTo(expr.first());
            return cp != 0 ? cp : -1;
        }
        return IBuiltInSymbol.super.compareTo(expr);
    }

    @Override
    public boolean containsRules() {
        return this.fRulesData != null;
    }

    public IExpr copy() {
        try {
            return (IExpr)this.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("BuiltInDummy.copy() failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public final RulesData createRulesData(int[] sizes) {
        if (this.fRulesData == null) {
            this.fRulesData = new RulesData(sizes);
        }
        return this.fRulesData;
    }

    @Override
    public IAST definition() {
        IASTAppendable result = F.ListAlloc();
        if (this.hasAssignedSymbolValue()) {
            if (this.isEvalFlagOn(0x10000002)) {
                result.append(F.SetDelayed(this, this.assignedValue()));
            } else {
                result.append(F.Set(this, this.assignedValue()));
            }
        }
        if (this.fRulesData != null) {
            result.appendAll(this.fRulesData.definition());
        }
        return result;
    }

    @Override
    public String definitionToString() {
        StringWriter buf = new StringWriter();
        IAST attributesList = AttributeFunctions.attributesList(this);
        if (attributesList.size() > 1) {
            buf.append("Attributes(");
            buf.append(this.toString());
            buf.append(")=");
            buf.append(attributesList.toString());
            buf.append("\n");
        }
        OutputFormFactory off = OutputFormFactory.get(EvalEngine.get().isRelaxedSyntax());
        off.setIgnoreNewLine(true);
        IAST list = this.definition();
        for (int i = 1; i < list.size(); ++i) {
            if (!off.convert(buf, list.get(i))) {
                return "ERROR-IN-OUTPUTFORM";
            }
            if (i >= list.size() - 1) continue;
            buf.append("\n");
            off.setColumnCounter(0);
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (Config.FUZZ_TESTING && obj instanceof ISymbol && this.fSymbolName.equals(((ISymbol)obj).getSymbolName()) && this.getContext().equals(((ISymbol)obj).getContext()) && this != obj) {
            throw new NullPointerException();
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof BuiltInDummy) {
            return this.fSymbolName.equals(((BuiltInDummy)obj).fSymbolName);
        }
        return false;
    }

    @Override
    public final IExpr evalDownRule(EvalEngine engine, IExpr expression) {
        if (this.fRulesData == null) {
            return F.NIL;
        }
        return this.fRulesData.evalDownRule(expression, engine);
    }

    @Override
    public IExpr evalMessage(String messageName) {
        IExpr temp;
        if (this.fRulesData != null && (temp = (IExpr)this.fRulesData.getMessages().get(messageName)) != null) {
            return temp;
        }
        return F.NIL;
    }

    @Override
    public final INumber evalNumber() {
        if (this.isNumericFunction(true)) {
            IExpr result = F.evaln(this);
            if (result.isNumber()) {
                return (INumber)result;
            }
        } else {
            IExpr result;
            IExpr temp = this.assignedValue();
            if (temp != null && temp.isNumericFunction(true) && (result = F.evaln(this)).isNumber()) {
                return (INumber)result;
            }
        }
        return null;
    }

    @Override
    public final ISignedNumber evalReal() {
        if (this.isNumericFunction(true)) {
            IExpr result = F.evaln(this);
            if (result.isReal()) {
                return (ISignedNumber)result;
            }
        } else {
            IExpr result;
            IExpr temp = this.assignedValue();
            if (temp != null && temp.isNumericFunction(true) && (result = F.evaln(this)).isReal()) {
                return (ISignedNumber)result;
            }
        }
        return null;
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        Context globalContext = engine.getContextPath().getGlobalContext();
        ISymbol globalSubstitute = globalContext.get(this.fSymbolName);
        if (globalSubstitute != null) {
            return globalSubstitute.evaluate(engine);
        }
        if (this.hasAssignedSymbolValue()) {
            return IExpr.ofNullable(this.assignedValue());
        }
        return F.NIL;
    }

    @Override
    public IExpr evaluateHead(IAST ast, EvalEngine engine) {
        IExpr result = this.evaluate(engine);
        if (result.isPresent()) {
            return ast.apply(result);
        }
        return F.NIL;
    }

    @Override
    public final IExpr evalUpRules(IExpr expression, EvalEngine engine) {
        if (this.fRulesData == null) {
            return F.NIL;
        }
        return this.fRulesData.evalUpRule(expression, engine);
    }

    @Override
    public String fullFormString() {
        String str;
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS && (str = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(this.fSymbolName)) != null) {
            return str;
        }
        return this.fSymbolName;
    }

    @Override
    public final int getAttributes() {
        return this.fAttributes;
    }

    @Override
    public Context getContext() {
        return Context.DUMMY;
    }

    @Override
    public IExpr getDefaultValue() {
        IExpr value = this.fRulesData != null ? this.fRulesData.getDefaultValue(Integer.MIN_VALUE) : null;
        return value == null ? F.NIL : value;
    }

    @Override
    public IExpr getDefaultValue(int pos) {
        IExpr value = this.fRulesData != null ? this.fRulesData.getDefaultValue(pos) : null;
        return value == null ? F.NIL : value;
    }

    @Override
    public IEvaluator getEvaluator() {
        return this.fEvaluator;
    }

    @Override
    public RulesData getRulesData() {
        return this.fRulesData;
    }

    @Override
    public final String getSymbolName() {
        return this.fSymbolName;
    }

    @Override
    public boolean hasAssignedSymbolValue() {
        IExpr temp = this.assignedValue();
        return temp != null;
    }

    @Override
    public boolean hasFlatAttribute() {
        return ISymbol.hasFlatAttribute(this.fAttributes);
    }

    @Override
    public final boolean hasHoldAllCompleteAttribute() {
        return ISymbol.hasHoldAllCompleteAttribute(this.fAttributes);
    }

    @Override
    public final boolean hasListableAttribute() {
        return ISymbol.hasListableAttribute(this.fAttributes);
    }

    public int hashCode() {
        return this.fSymbolName == null ? 31 : this.fSymbolName.hashCode();
    }

    @Override
    public boolean hasOneIdentityAttribute() {
        return (this.fAttributes & 1) == 1;
    }

    @Override
    public boolean hasOrderlessAttribute() {
        return (this.fAttributes & 4) == 4;
    }

    @Override
    public boolean hasOrderlessFlatAttribute() {
        return (this.fAttributes & 0xC) == 12;
    }

    @Override
    public ISymbol head() {
        return S.Symbol;
    }

    @Override
    public int hierarchy() {
        return 512;
    }

    @Override
    public CharSequence internalFormString(boolean symbolsAsFactoryMethod, int depth) {
        IExpr.SourceCodeProperties p = AbstractAST.stringFormProperties(symbolsAsFactoryMethod);
        return this.internalJavaString(p, depth, x -> null);
    }

    @Override
    public CharSequence internalJavaString(IExpr.SourceCodeProperties properties, int depth, Function<ISymbol, ? extends CharSequence> variables) {
        String name;
        CharSequence result = variables.apply(this);
        if (result != null) {
            return result;
        }
        String prefix = AbstractAST.getPrefixF(properties);
        if (properties.symbolsAsFactoryMethod) {
            return new StringBuilder(prefix).append(this.internalJavaStringAsFactoryMethod());
        }
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS ? (name = this.fSymbolName.length() == 1 ? AST2Expr.PREDEFINED_SYMBOLS_MAP.get(this.fSymbolName) : AST2Expr.PREDEFINED_SYMBOLS_MAP.get(this.fSymbolName.toLowerCase(Locale.ENGLISH))) != null : (name = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(this.fSymbolName.toLowerCase(Locale.ENGLISH))) != null && name.equals(this.fSymbolName)) {
            return new StringBuilder(prefix).append(name);
        }
        char ch = this.fSymbolName.charAt(0);
        if (!properties.noSymbolPrefix && this.fSymbolName.length() == 1 && 'a' <= ch && ch <= 'z') {
            return new StringBuilder(prefix).append(this.fSymbolName);
        }
        return this.fSymbolName;
    }

    private String internalJavaStringAsFactoryMethod() {
        String alias;
        char ch;
        if (this.fSymbolName.length() == 1) {
            ch = this.fSymbolName.charAt(0);
            if ('a' <= ch && ch <= 'z') {
                return this.fSymbolName;
            }
            if ('A' <= ch && ch <= 'G' && ch != 'D' && ch != 'E') {
                return this.fSymbolName + "Symbol";
            }
        }
        if (Config.RUBI_CONVERT_SYMBOLS) {
            if (this.fSymbolName.length() == 2 && '\u00a7' == this.fSymbolName.charAt(0) && Character.isLowerCase(this.fSymbolName.charAt(1))) {
                ch = this.fSymbolName.charAt(1);
                if ('a' <= ch && ch <= 'z') {
                    return "p" + ch;
                }
            } else if (this.fSymbolName.equals("Int")) {
                return "Integrate";
            }
        }
        if (Character.isUpperCase(this.fSymbolName.charAt(0)) && (alias = F.getPredefinedInternalFormString(this.fSymbolName)) != null) {
            if (Config.RUBI_CONVERT_SYMBOLS && alias.startsWith("Rubi`")) {
                return "$rubi(\"" + alias.substring(5) + "\")";
            }
            return alias;
        }
        return "$s(\"" + this.fSymbolName + "\")";
    }

    @Override
    public CharSequence internalScalaString(boolean symbolsAsFactoryMethod, int depth) {
        IExpr.SourceCodeProperties p = AbstractAST.scalaFormProperties(symbolsAsFactoryMethod);
        return this.internalJavaString(p, depth, x -> null);
    }

    @Override
    public final boolean isAtom() {
        return true;
    }

    @Override
    public final boolean isEvalFlagOff(int i) {
        return (this.fEvalFlags & i) == 0;
    }

    @Override
    public final boolean isEvalFlagOn(int i) {
        return (this.fEvalFlags & i) == i;
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public boolean isLocked(boolean packageMode) {
        return false;
    }

    @Override
    public boolean isNegative() {
        IExpr temp;
        return this.isNumericFunction(true) && (temp = F.evaln(this)).isReal() && temp.isNegative();
    }

    @Override
    public boolean isNumericFunction(boolean allowList) {
        if (this.isConstantAttribute()) {
            return true;
        }
        IExpr temp = this.assignedValue();
        return temp != null && temp.isNumericFunction(true);
    }

    @Override
    public boolean isPolynomial(IAST variables) {
        if (variables.isAST0()) {
            return true;
        }
        if (this.isConstantAttribute()) {
            return true;
        }
        return variables.exists(x -> this.equals(x));
    }

    @Override
    public boolean isPolynomial(IExpr variable) {
        if (variable == null) {
            return true;
        }
        return this.equals(variable);
    }

    @Override
    public boolean isPolynomialOfMaxDegree(ISymbol variable, long maxDegree) {
        return maxDegree != 0L || !this.equals(variable);
    }

    @Override
    public boolean isPolynomialStruct() {
        return this.isVariable();
    }

    @Override
    public boolean isPositive() {
        IExpr temp;
        return this.isNumericFunction(true) && (temp = F.evaln(this)).isReal() && temp.isPositive();
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public final boolean isString(String str) {
        return this.fSymbolName.equals(str);
    }

    @Override
    public final boolean isStringIgnoreCase(String str) {
        return this.fSymbolName.equalsIgnoreCase(str);
    }

    @Override
    public final boolean isSymbolName(String name) {
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
            if (this.fSymbolName.length() == 1) {
                return this.fSymbolName.equals(name);
            }
            return this.fSymbolName.equalsIgnoreCase(name);
        }
        return this.fSymbolName.equals(name);
    }

    @Override
    public final boolean isValue() {
        return this.evaluate(EvalEngine.get()).isPresent();
    }

    @Override
    public boolean isVariable() {
        return !this.isConstantAttribute();
    }

    @Override
    public ISymbol mapToGlobal(EvalEngine engine) {
        Context globalContext = engine.getContextPath().getGlobalContext();
        ISymbol globalSubstitute = globalContext.get(this.fSymbolName);
        if (globalSubstitute != null) {
            globalSubstitute.setAttributes(this.fAttributes);
            globalSubstitute.assignValue(this.assignedValue(), false);
            return globalSubstitute;
        }
        globalSubstitute = new Symbol(this.fSymbolName, globalContext);
        globalContext.put(this.fSymbolName, globalSubstitute);
        globalSubstitute.setAttributes(this.fAttributes);
        globalSubstitute.assignValue(this.assignedValue(), false);
        return globalSubstitute;
    }

    @Override
    public IExpr of(EvalEngine engine, IExpr ... args) {
        IASTAppendable ast = F.ast(args, this);
        return engine.evaluate(ast);
    }

    @Override
    public IExpr of1(EvalEngine engine, IExpr arg, IExpr ... parts) {
        IASTAppendable ast = F.ast((IExpr)this, 1 + parts.length);
        ast.append(arg);
        ast.appendAll(parts, 0, parts.length);
        return engine.evaluate(ast);
    }

    @Override
    public IExpr ofNIL(EvalEngine engine, IExpr ... args) {
        IASTAppendable ast = F.ast(args, this);
        return engine.evaluateNIL(ast);
    }

    @Override
    public boolean ofQ(EvalEngine engine, IExpr ... args) {
        IASTAppendable ast = F.ast(args, this);
        return engine.evalTrue(ast);
    }

    @Override
    public boolean ofQ(IExpr ... args) {
        return this.ofQ(EvalEngine.get(), args);
    }

    @Override
    public final void putDownRule(int setSymbol, boolean equalRule, IExpr leftHandSide, IExpr rightHandSide, boolean packageMode) {
        this.putDownRule(setSymbol, equalRule, leftHandSide, rightHandSide, Integer.MAX_VALUE, packageMode);
    }

    @Override
    public final void putDownRule(int setSymbol, boolean equalRule, IExpr leftHandSide, IExpr rightHandSide, int priority, boolean packageMode) {
        if (!packageMode) {
            if (this.isLocked(packageMode)) {
                throw new RuleCreationError(leftHandSide);
            }
            EvalEngine.get().addModifiedVariable(this);
        }
        if (this.fRulesData == null) {
            this.fRulesData = new RulesData();
        }
        this.fRulesData.putDownRule(setSymbol, equalRule, leftHandSide, rightHandSide, priority);
    }

    @Override
    public final void putDownRule(PatternMatcherAndInvoker pmEvaluator) {
        if (this.fRulesData == null) {
            this.fRulesData = new RulesData();
        }
        this.fRulesData.insertMatcher(pmEvaluator);
    }

    @Override
    public void putMessage(int setSymbol, String messageName, IStringX message) {
    }

    @Override
    public final IPatternMatcher putUpRule(int setSymbol, boolean equalRule, IAST leftHandSide, IExpr rightHandSide) {
        return this.putUpRule(setSymbol, equalRule, leftHandSide, rightHandSide, Integer.MAX_VALUE);
    }

    @Override
    public final IPatternMatcher putUpRule(int setSymbol, boolean equalRule, IAST leftHandSide, IExpr rightHandSide, int priority) {
        throw new UnsupportedOperationException();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.fSymbolName = stream.readUTF();
        this.fAttributes = stream.read();
        IExpr value = (IExpr)stream.readObject();
        this.assignValue(value, false);
    }

    @Override
    public void readRules(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.fSymbolName = stream.readUTF();
        this.fAttributes = stream.read();
        boolean hasDownRulesData = stream.readBoolean();
        if (hasDownRulesData) {
            this.fRulesData = new RulesData();
            this.fRulesData = (RulesData)stream.readObject();
        }
    }

    @Override
    public IExpr[] reassignSymbolValue(Function<IExpr, IExpr> function, ISymbol functionSymbol, EvalEngine engine) {
        if (this.hasAssignedSymbolValue()) {
            IExpr calculatedResult;
            IExpr[] result = new IExpr[2];
            result[0] = this.fValue;
            if (this.isEvalFlagOn(1) && result[0].isAST()) {
                result[0] = ((IAST)result[0]).copy();
            }
            if ((calculatedResult = function.apply(result[0])).isPresent()) {
                this.assignValue(calculatedResult, false);
                result[1] = calculatedResult;
                return result;
            }
        }
        IOFunctions.printMessage(functionSymbol, "rvalue", F.list(this), engine);
        return null;
    }

    @Override
    public IExpr[] reassignSymbolValue(IASTMutable ast, ISymbol functionSymbol, EvalEngine engine) {
        IExpr temp = this.assignedValue();
        if (temp != null) {
            IExpr[] result = new IExpr[2];
            result[0] = temp;
            ast.set(1, temp);
            IExpr calculatedResult = engine.evaluate(ast);
            if (calculatedResult != null) {
                this.assignValue(calculatedResult, false);
                result[1] = calculatedResult;
                return result;
            }
        }
        throw new ArgumentTypeException(functionSymbol.toString() + " - Symbol: " + this.toString() + " has no value! Reassignment with a new value is not possible");
    }

    @Override
    public final boolean removeRule(int setSymbol, boolean equalRule, IExpr leftHandSide, boolean packageMode) {
        if (!packageMode) {
            if (this.isLocked(packageMode)) {
                throw new RuleCreationError(leftHandSide);
            }
            EvalEngine.get().addModifiedVariable(this);
        }
        if (leftHandSide.isSymbol()) {
            this.clearValue();
            return true;
        }
        if (this.fRulesData != null) {
            return this.fRulesData.removeRule(setSymbol, equalRule, leftHandSide);
        }
        return false;
    }

    @Override
    public final void setAttributes(int attributes) {
        this.fAttributes = attributes;
        if (this.isLocked()) {
            throw new RuleCreationError(this);
        }
        EvalEngine engine = EvalEngine.get();
        engine.addModifiedVariable(this);
    }

    @Override
    public void setDefaultValue(IExpr expr) {
        this.setDefaultValue(Integer.MIN_VALUE, expr);
    }

    @Override
    public void setDefaultValue(int pos, IExpr expr) {
        if (this.fRulesData == null) {
            this.fRulesData = new RulesData();
        }
        this.fRulesData.putfDefaultValues(pos, expr);
    }

    @Override
    public void setEvaluator(IEvaluator module) {
        this.fEvaluator = module;
    }

    @Override
    public void setPredicateQ(Predicate<IExpr> predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRulesData(RulesData rd) {
        this.fRulesData = rd;
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            OutputFormFactory.get(EvalEngine.get().isRelaxedSyntax()).convertSymbol(sb, this);
            return sb.toString();
        }
        catch (Exception e1) {
            return this.fSymbolName;
        }
    }

    @Override
    public IExpr variables2Slots(Map<IExpr, IExpr> map, Collection<IExpr> variableCollector) {
        UnaryVariable2Slot uv2s = new UnaryVariable2Slot(map, variableCollector);
        return uv2s.apply(this);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeUTF(this.fSymbolName);
        stream.write(this.fAttributes);
        stream.writeObject(this.fValue);
    }

    private Object writeReplace() {
        return this.optional();
    }

    @Override
    public boolean writeRules(ObjectOutputStream stream) throws IOException {
        stream.writeUTF(this.fSymbolName);
        stream.write(this.fAttributes);
        if (this.fRulesData == null) {
            stream.writeBoolean(false);
        } else {
            stream.writeBoolean(true);
            stream.writeObject(this.fRulesData);
        }
        return true;
    }
}

