/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.hipparchus.util.Pair;
import org.matheclipse.core.expression.AbstractAST;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IPatternObject;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMap;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcher;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;
import org.matheclipse.parser.client.ParserConfig;

public class Blank
implements IPattern {
    private static final long serialVersionUID = 1306007999071682207L;
    protected final IExpr fHeadTest;
    protected final boolean fDefault;

    public static IPattern valueOf() {
        return new Blank();
    }

    public static IPattern valueOf(IExpr condition) {
        return new Blank(condition);
    }

    public Blank() {
        this(null);
    }

    public Blank(IExpr condition) {
        this(condition, false);
    }

    public Blank(IExpr condition, boolean def) {
        this.fHeadTest = condition;
        this.fDefault = def;
    }

    @Override
    public IExpr accept(IVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return visitor.visit(this);
    }

    @Override
    public int[] addPattern(List<Pair<IExpr, IPatternObject>> patternIndexMap) {
        IPatternMap.addPattern(patternIndexMap, this);
        int[] result = new int[2];
        if (this.isPatternDefault() || this.isPatternOptional()) {
            result[0] = 4;
            result[1] = 2;
        } else {
            result[0] = 1;
            result[1] = 5;
        }
        if (this.fHeadTest != null) {
            result[1] = result[1] + 2;
        }
        return result;
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof Blank) {
            Blank blank = (Blank)expr;
            if (this.fDefault != blank.fDefault) {
                return this.fDefault ? 1 : -1;
            }
            if (this.fHeadTest == null) {
                if (blank.fHeadTest != null) {
                    return -1;
                }
            } else {
                if (blank.fHeadTest == null) {
                    return 1;
                }
                int result = this.fHeadTest.compareTo(blank.fHeadTest);
                if (result != 0) {
                    return result;
                }
            }
            return 0;
        }
        return IPattern.super.compareTo(expr);
    }

    public IExpr copy() {
        return new Blank(this.fHeadTest, this.fDefault);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Blank) {
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            Blank blank = (Blank)obj;
            if (this.fHeadTest != null && blank.fHeadTest != null) {
                return this.fHeadTest.equals(blank.fHeadTest);
            }
            return this.fHeadTest == blank.fHeadTest;
        }
        return false;
    }

    @Override
    public boolean equivalent(IPatternObject patternObject, IPatternMap pm1, IPatternMap pm2) {
        if (this == patternObject) {
            return true;
        }
        if (patternObject instanceof Blank) {
            IExpr o1 = this.getHeadTest();
            IExpr o2 = patternObject.getHeadTest();
            if (o1 == null || o2 == null) {
                return o1 == o2;
            }
            return o1.equals(o2);
        }
        return false;
    }

    @Override
    public String fullFormString() {
        StringBuilder buf = new StringBuilder();
        if (this.fDefault) {
            buf.append("Optional");
            if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
                buf.append('(');
            } else {
                buf.append('[');
            }
        }
        buf.append("Blank");
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
            buf.append('(');
        } else {
            buf.append('[');
        }
        if (this.fHeadTest != null) {
            buf.append(this.fHeadTest.fullFormString());
        }
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
            buf.append(')');
        } else {
            buf.append(']');
        }
        if (this.fDefault) {
            if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
                buf.append(')');
            } else {
                buf.append(']');
            }
        }
        return buf.toString();
    }

    @Override
    public IExpr getHeadTest() {
        return this.fHeadTest;
    }

    @Override
    public int getEvalFlags() {
        if (this.isPatternDefault()) {
            return 4;
        }
        return 1;
    }

    @Override
    public int getIndex(IPatternMap pm) {
        if (pm != null) {
            return pm.get(this);
        }
        return -1;
    }

    @Override
    public ISymbol getSymbol() {
        return null;
    }

    public int hashCode() {
        return this.fHeadTest == null ? 193 : 23 + this.fHeadTest.hashCode();
    }

    @Override
    public ISymbol head() {
        return S.Blank;
    }

    @Override
    public int hierarchy() {
        return 4096;
    }

    @Override
    public CharSequence internalJavaString(IExpr.SourceCodeProperties properties, int depth, Function<ISymbol, ? extends CharSequence> variables) {
        String prefix = AbstractAST.getPrefixF(properties);
        StringBuilder buffer = new StringBuilder(prefix).append("$b(");
        if (this.fHeadTest != null) {
            buffer.append(this.fHeadTest.internalJavaString(properties, 0, variables));
        }
        return buffer.append(')');
    }

    @Override
    public boolean isBlank() {
        return true;
    }

    public boolean isCase(IExpr that) {
        PatternMatcher matcher = new PatternMatcher(this);
        return ((IPatternMatcher)matcher).test(that);
    }

    @Override
    public boolean isConditionMatched(IExpr expr, IPatternMap patternMap) {
        if (this.fHeadTest == null || expr.head().equals(this.fHeadTest)) {
            return patternMap.setValue(this, expr);
        }
        return false;
    }

    @Override
    public boolean isFreeOfPatterns() {
        return false;
    }

    @Override
    public boolean isPatternDefault() {
        return this.fDefault;
    }

    @Override
    public final boolean isPatternExpr() {
        return true;
    }

    @Override
    public boolean isPatternOptional() {
        return false;
    }

    @Override
    public boolean matchPattern(IExpr expr, IPatternMap patternMap) {
        return this.isConditionMatched(expr, patternMap);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('_');
        if (this.fHeadTest != null) {
            buffer.append(this.fHeadTest.toString());
        }
        if (this.fDefault) {
            buffer.append('.');
        }
        return buffer.toString();
    }

    @Override
    public IExpr variables2Slots(Map<IExpr, IExpr> map, Collection<IExpr> variableCollector) {
        return F.NIL;
    }

    private Object writeReplace() {
        return this.optional();
    }
}

