/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import com.google.common.math.BigIntegerMath;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.function.Function;
import org.hipparchus.fraction.BigFraction;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.exception.BigIntegerLimitExceeded;
import org.matheclipse.core.eval.exception.LimitException;
import org.matheclipse.core.expression.AbstractAST;
import org.matheclipse.core.expression.AbstractFractionSym;
import org.matheclipse.core.expression.AbstractIntegerSym;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IntegerSym;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.numbertheory.Primality;

public class BigIntegerSym
extends AbstractIntegerSym {
    private static final long serialVersionUID = 6389228668633533063L;
    BigInteger fBigIntValue;
    private transient int fHashValue = 0;

    public static BigInteger eulerPhi(BigInteger value) throws ArithmeticException {
        if (value.equals(BigInteger.ZERO)) {
            return BigInteger.ZERO;
        }
        if (value.equals(BigInteger.ONE)) {
            return BigInteger.ONE;
        }
        IASTAppendable ast = AbstractIntegerSym.valueOf(value).factorInteger();
        IInteger phi = F.C1;
        for (int i = 1; i < ast.size(); ++i) {
            IAST element = (IAST)ast.get(i);
            IInteger q = (IInteger)element.arg1();
            int c = ((IInteger)element.arg2()).toInt();
            phi = c == 1 ? phi.multiply(q.subtract(F.C1)) : phi.multiply(q.subtract(F.C1).multiply(q.powerRational(c - 1)));
        }
        return phi.toBigNumerator();
    }

    public static BigInteger jacobiSymbolF(BigInteger val) {
        BigInteger a = val.mod(AbstractIntegerSym.BI_EIGHT);
        if (a.equals(BigInteger.ONE)) {
            return BigInteger.ONE;
        }
        if (a.equals(AbstractIntegerSym.BI_SEVEN)) {
            return BigInteger.ONE;
        }
        return AbstractIntegerSym.BI_MINUS_ONE;
    }

    public static BigInteger jacobiSymbolG(BigInteger a, BigInteger b) {
        BigInteger i1 = a.mod(AbstractIntegerSym.BI_FOUR);
        if (i1.equals(BigInteger.ONE)) {
            return BigInteger.ONE;
        }
        BigInteger i2 = b.mod(AbstractIntegerSym.BI_FOUR);
        if (i2.equals(BigInteger.ONE)) {
            return BigInteger.ONE;
        }
        return AbstractIntegerSym.BI_MINUS_ONE;
    }

    public BigIntegerSym() {
        this.fBigIntValue = null;
    }

    public BigIntegerSym(long value) {
        this.fBigIntValue = BigInteger.valueOf(value);
    }

    public BigIntegerSym(BigInteger value) {
        if (Config.MAX_BIT_LENGTH < value.bitLength()) {
            BigIntegerLimitExceeded.throwIt(value.bitLength());
        }
        this.fBigIntValue = value;
    }

    public BigIntegerSym(byte[] bytes) {
        if (Config.MAX_BIT_LENGTH < bytes.length * 8) {
            BigIntegerLimitExceeded.throwIt((long)bytes.length * 8L);
        }
        this.fBigIntValue = new BigInteger(bytes);
    }

    @Override
    public IInteger abs() {
        return BigIntegerSym.valueOf(this.fBigIntValue.abs());
    }

    @Override
    public IInteger add(IInteger that) {
        return BigIntegerSym.valueOf(this.fBigIntValue.add(that.toBigNumerator()));
    }

    @Override
    public IRational add(IRational parm1) {
        if (parm1.isZero()) {
            return this;
        }
        if (parm1 instanceof IFraction) {
            return ((IFraction)parm1).add(this);
        }
        IInteger p1 = (IInteger)parm1;
        BigInteger newnum = this.toBigNumerator().add(p1.toBigNumerator());
        return BigIntegerSym.valueOf(newnum);
    }

    @Override
    public long bitLength() {
        return this.fBigIntValue.bitLength();
    }

    @Override
    public int compareAbsValueToOne() {
        BigInteger temp = this.fBigIntValue;
        if (this.fBigIntValue.compareTo(BigInteger.ZERO) < 0) {
            temp = temp.negate();
        }
        return temp.compareTo(BigInteger.ONE);
    }

    @Override
    public int compareInt(int value) {
        if (this.fBigIntValue.bitLength() <= 31) {
            int temp = this.fBigIntValue.intValue();
            return temp > value ? 1 : (temp == value ? 0 : -1);
        }
        return this.fBigIntValue.signum();
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof IRational) {
            if (expr instanceof IntegerSym) {
                return this.compareInt(((IntegerSym)expr).fIntValue);
            }
            if (expr instanceof BigIntegerSym) {
                return this.fBigIntValue.compareTo(((BigIntegerSym)expr).fBigIntValue);
            }
            if (expr instanceof IFraction) {
                return -((IFraction)expr).compareTo(AbstractFractionSym.valueOf(this.fBigIntValue, BigInteger.ONE));
            }
        }
        if (expr.isReal()) {
            return Double.compare(this.fBigIntValue.doubleValue(), ((ISignedNumber)expr).doubleValue());
        }
        return super.compareTo(expr);
    }

    @Override
    public ComplexNum complexNumValue() {
        return ComplexNum.valueOf(this.doubleValue());
    }

    @Override
    public IInteger dec() {
        return this.add(F.CN1);
    }

    @Override
    public IInteger inc() {
        return this.add(F.C1);
    }

    @Override
    public IInteger div(IInteger that) {
        return BigIntegerSym.valueOf(this.fBigIntValue.divide(that.toBigNumerator()));
    }

    @Override
    public IInteger[] divideAndRemainder(IInteger that) {
        IInteger[] res = new IInteger[2];
        BigInteger[] largeRes = this.fBigIntValue.divideAndRemainder(that.toBigNumerator());
        res[0] = BigIntegerSym.valueOf(largeRes[0]);
        res[1] = BigIntegerSym.valueOf(largeRes[1]);
        return res;
    }

    @Override
    public IInteger irem(IInteger that) {
        BigInteger[] largeRes = this.fBigIntValue.divideAndRemainder(that.toBigNumerator());
        return BigIntegerSym.valueOf(largeRes[1]);
    }

    @Override
    public IInteger iquo(IInteger that) {
        BigInteger[] largeRes = this.fBigIntValue.divideAndRemainder(that.toBigNumerator());
        return BigIntegerSym.valueOf(largeRes[0]);
    }

    @Override
    public ISignedNumber divideBy(ISignedNumber that) {
        if (that instanceof BigIntegerSym) {
            return AbstractFractionSym.valueOf(this).divideBy(that);
        }
        if (that instanceof IFraction) {
            return AbstractFractionSym.valueOf(this).divideBy(that);
        }
        return Num.valueOf(this.fBigIntValue.doubleValue() / that.doubleValue());
    }

    @Override
    public double doubleValue() {
        return this.fBigIntValue.doubleValue();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BigIntegerSym) {
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            return this.fBigIntValue.equals(((BigIntegerSym)obj).fBigIntValue);
        }
        return false;
    }

    @Override
    public final boolean equalsFraction(int numerator, int denominator) {
        if (denominator != 1) {
            return false;
        }
        return this.fBigIntValue.intValue() == numerator && this.fBigIntValue.bitLength() <= 31;
    }

    @Override
    public final boolean equalsInt(int value) {
        return this.fBigIntValue.intValue() == value && this.fBigIntValue.bitLength() <= 31;
    }

    @Override
    public IExpr exponent(IInteger base) {
        IInteger b = this;
        if (this.complexSign() < 0) {
            b = b.negate();
        } else {
            if (b.isZero()) {
                return F.CInfinity;
            }
            if (b.isOne()) {
                return F.C0;
            }
        }
        if (b.equals(base)) {
            return F.C1;
        }
        BigInteger rest = Primality.countExponent(b.toBigNumerator(), base.toBigNumerator());
        return BigIntegerSym.valueOf(rest);
    }

    @Override
    public IInteger gcd(IInteger that) {
        return BigIntegerSym.valueOf(this.fBigIntValue.gcd(that.toBigNumerator()));
    }

    @Override
    public IInteger denominator() {
        return F.C1;
    }

    @Override
    public BigFraction toBigFraction() {
        return new BigFraction(this.fBigIntValue);
    }

    @Override
    public IInteger numerator() {
        return this;
    }

    public final int hashCode() {
        if (this.fHashValue == 0) {
            this.fHashValue = this.fBigIntValue.hashCode();
        }
        return this.fHashValue;
    }

    @Override
    public ISignedNumber im() {
        return F.C0;
    }

    @Override
    public long integerLength(IInteger radix) {
        long length = 0L;
        IInteger ai = this;
        while (!ai.isZero()) {
            ai = ai.div(radix);
            ++length;
        }
        return length;
    }

    @Override
    public CharSequence internalJavaString(IExpr.SourceCodeProperties properties, int depth, Function<ISymbol, ? extends CharSequence> variables) {
        String prefix = AbstractAST.getPrefixF(properties);
        if (NumberUtil.hasIntValue(this.fBigIntValue)) {
            int intValue = this.fBigIntValue.intValueExact();
            switch (intValue) {
                case -1: {
                    return prefix + "CN1";
                }
                case -2: {
                    return prefix + "CN2";
                }
                case -3: {
                    return prefix + "CN3";
                }
                case -4: {
                    return prefix + "CN4";
                }
                case -5: {
                    return prefix + "CN5";
                }
                case -6: {
                    return prefix + "CN6";
                }
                case -7: {
                    return prefix + "CN7";
                }
                case -8: {
                    return prefix + "CN8";
                }
                case -9: {
                    return prefix + "CN9";
                }
                case -10: {
                    return prefix + "CN10";
                }
                case 0: {
                    return prefix + "C0";
                }
                case 1: {
                    return prefix + "C1";
                }
                case 2: {
                    return prefix + "C2";
                }
                case 3: {
                    return prefix + "C3";
                }
                case 4: {
                    return prefix + "C4";
                }
                case 5: {
                    return prefix + "C5";
                }
                case 6: {
                    return prefix + "C6";
                }
                case 7: {
                    return prefix + "C7";
                }
                case 8: {
                    return prefix + "C8";
                }
                case 9: {
                    return prefix + "C9";
                }
                case 10: {
                    return prefix + "C10";
                }
            }
            return prefix + "ZZ(" + intValue + ")";
        }
        if (NumberUtil.hasLongValue(this.fBigIntValue)) {
            return prefix + "ZZ(" + this.fBigIntValue.longValueExact() + "L)";
        }
        return prefix + "ZZ(\"" + this.fBigIntValue.toString() + "\", 10)";
    }

    @Override
    public CharSequence internalScalaString(boolean symbolsAsFactoryMethod, int depth) {
        IExpr.SourceCodeProperties p = AbstractAST.scalaFormProperties(symbolsAsFactoryMethod);
        return this.internalJavaString(p, depth, x -> null);
    }

    @Override
    public byte byteValue() {
        return this.fBigIntValue.byteValue();
    }

    @Override
    public int intValue() {
        return this.fBigIntValue.intValue();
    }

    @Override
    public IRational inverse() {
        if (this.isOne() || this.isMinusOne()) {
            return this;
        }
        if (NumberUtil.isNegative(this.fBigIntValue)) {
            return AbstractFractionSym.valueOf(BigInteger.valueOf(-1L), this.fBigIntValue.negate());
        }
        return AbstractFractionSym.valueOf(BigInteger.ONE, this.fBigIntValue);
    }

    @Override
    public boolean isEven() {
        return NumberUtil.isEven(this.fBigIntValue);
    }

    @Override
    public boolean isGT(ISignedNumber obj) {
        if (obj instanceof BigIntegerSym) {
            return this.fBigIntValue.compareTo(((BigIntegerSym)obj).fBigIntValue) > 0;
        }
        if (obj instanceof IFraction) {
            return -((IFraction)obj).compareTo(AbstractFractionSym.valueOf(this.fBigIntValue, BigInteger.ONE)) > 0;
        }
        return this.fBigIntValue.doubleValue() > obj.doubleValue();
    }

    public boolean isLargerThan(BigInteger that) {
        return this.fBigIntValue.compareTo(that) > 0;
    }

    @Override
    public boolean isLT(ISignedNumber obj) {
        if (obj instanceof BigIntegerSym) {
            return this.fBigIntValue.compareTo(((BigIntegerSym)obj).fBigIntValue) < 0;
        }
        if (obj instanceof IFraction) {
            return -((IFraction)obj).compareTo(AbstractFractionSym.valueOf(this.fBigIntValue, BigInteger.ONE)) < 0;
        }
        return this.fBigIntValue.doubleValue() < obj.doubleValue();
    }

    @Override
    public boolean isMinusOne() {
        return this.fBigIntValue.equals(BI_MINUS_ONE);
    }

    @Override
    public boolean isNegative() {
        return this.fBigIntValue.compareTo(BigInteger.ZERO) < 0;
    }

    @Override
    public boolean isOdd() {
        return NumberUtil.isOdd(this.fBigIntValue);
    }

    @Override
    public boolean isOne() {
        return this.fBigIntValue.equals(BigInteger.ONE);
    }

    @Override
    public boolean isPositive() {
        return this.fBigIntValue.compareTo(BigInteger.ZERO) > 0;
    }

    @Override
    public boolean isProbablePrime() {
        return this.isProbablePrime(32);
    }

    @Override
    public boolean isProbablePrime(int certainty) {
        return this.fBigIntValue.isProbablePrime(certainty);
    }

    @Override
    public boolean isRationalValue(IRational value) {
        return this.equals(value);
    }

    @Override
    public boolean isZero() {
        return this.fBigIntValue.equals(BigInteger.ZERO);
    }

    @Override
    public long longValue() {
        return this.fBigIntValue.longValue();
    }

    @Override
    public IInteger mod(IInteger that) {
        return BigIntegerSym.valueOf(this.fBigIntValue.mod(that.toBigNumerator()));
    }

    @Override
    public IInteger modInverse(IInteger m) {
        return BigIntegerSym.valueOf(this.fBigIntValue.modInverse(m.toBigNumerator()));
    }

    @Override
    public IInteger modPow(IInteger exp, IInteger m) {
        if (m.isZero()) {
            throw new ArithmeticException("the argument " + m.toString() + " should be nonzero.");
        }
        return BigIntegerSym.valueOf(this.fBigIntValue.modPow(exp.toBigNumerator(), m.toBigNumerator()));
    }

    @Override
    public IInteger multiply(IInteger that) {
        if (that instanceof IntegerSym) {
            switch (((IntegerSym)that).fIntValue) {
                case 0: {
                    return F.C0;
                }
                case 1: {
                    return this;
                }
                case -1: {
                    return this.negate();
                }
            }
        }
        BigInteger thatBigIntValue = that.toBigNumerator();
        if (Config.MAX_BIT_LENGTH < this.fBigIntValue.bitLength() + thatBigIntValue.bitLength()) {
            BigIntegerLimitExceeded.throwIt(this.fBigIntValue.bitLength() + thatBigIntValue.bitLength());
        }
        return BigIntegerSym.valueOf(this.fBigIntValue.multiply(thatBigIntValue));
    }

    @Override
    public IInteger multiply(int value) {
        switch (value) {
            case 0: {
                return F.C0;
            }
            case 1: {
                return this;
            }
            case -1: {
                return this.negate();
            }
        }
        return BigIntegerSym.valueOf(this.fBigIntValue.multiply(BigInteger.valueOf(value)));
    }

    @Override
    public IRational multiply(IRational parm1) {
        if (parm1.isZero()) {
            return F.C0;
        }
        if (parm1.isOne()) {
            return this;
        }
        if (parm1.isMinusOne()) {
            return this.negate();
        }
        if (parm1 instanceof IFraction) {
            return ((IFraction)parm1).multiply(this);
        }
        IInteger p1 = (IInteger)parm1;
        BigInteger newnum = this.toBigNumerator().multiply(p1.toBigNumerator());
        return BigIntegerSym.valueOf(newnum);
    }

    @Override
    public IInteger negate() {
        return BigIntegerSym.valueOf(this.fBigIntValue.negate());
    }

    @Override
    public IRational normalize() {
        return this;
    }

    @Override
    public IExpr nthRoot(int n) throws ArithmeticException {
        BigIntegerSym result;
        if (n < 0) {
            throw new IllegalArgumentException("nthRoot(" + n + ") n must be >= 0");
        }
        if (n == 2) {
            return this.sqrt();
        }
        if (this.complexSign() == 0) {
            return F.C0;
        }
        if (this.complexSign() < 0) {
            if (n % 2 == 0) {
                throw new ArithmeticException();
            }
            return this.negate().nthRoot(n).negate();
        }
        IInteger temp = this;
        do {
            result = temp;
        } while ((temp = this.divideAndRemainder(temp.powerRational((long)n - 1L))[0].add(temp.multiply(AbstractIntegerSym.valueOf(n - 1))).divideAndRemainder(AbstractIntegerSym.valueOf(n))[0]).compareTo(result) < 0);
        return result;
    }

    @Override
    public final INumber numericNumber() {
        return F.num(this);
    }

    @Override
    public Num numValue() {
        return Num.valueOf(this.doubleValue());
    }

    @Override
    public ISignedNumber re() {
        return this;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte attributeFlags = objectInput.readByte();
        switch (attributeFlags) {
            case 1: {
                byte value = objectInput.readByte();
                this.fBigIntValue = BigInteger.valueOf(value);
                return;
            }
            case 2: {
                short value = objectInput.readShort();
                this.fBigIntValue = BigInteger.valueOf(value);
                return;
            }
            case 4: {
                int value = objectInput.readInt();
                this.fBigIntValue = BigInteger.valueOf(value);
                return;
            }
        }
        this.fBigIntValue = (BigInteger)objectInput.readObject();
    }

    @Override
    public IExpr remainder(IExpr that) {
        if (that instanceof IntegerSym) {
            return BigIntegerSym.valueOf(this.fBigIntValue.remainder(((IntegerSym)that).toBigNumerator()));
        }
        if (that instanceof BigIntegerSym) {
            return BigIntegerSym.valueOf(this.fBigIntValue.remainder(((BigIntegerSym)that).fBigIntValue));
        }
        return this;
    }

    public IInteger remainder(IInteger that) {
        return BigIntegerSym.valueOf(this.fBigIntValue.remainder(that.toBigNumerator()));
    }

    @Override
    public IInteger roundExpr() {
        return this;
    }

    @Override
    public IInteger shiftLeft(int n) {
        return BigIntegerSym.valueOf(this.toBigNumerator().shiftLeft(n));
    }

    @Override
    public IInteger shiftRight(int n) {
        return BigIntegerSym.valueOf(this.toBigNumerator().shiftRight(n));
    }

    @Override
    public int complexSign() {
        return this.fBigIntValue.signum();
    }

    @Override
    public IExpr sqrt() {
        try {
            return BigIntegerSym.valueOf(BigIntegerMath.sqrt((BigInteger)this.fBigIntValue, (RoundingMode)RoundingMode.UNNECESSARY));
        }
        catch (LimitException lime) {
            throw lime;
        }
        catch (RuntimeException rex) {
            return F.Sqrt(this);
        }
    }

    @Override
    public IInteger subtract(IInteger that) {
        return BigIntegerSym.valueOf(this.fBigIntValue.subtract(that.toBigNumerator()));
    }

    @Override
    public BigInteger toBigDenominator() {
        return BigInteger.ONE;
    }

    @Override
    public BigInteger toBigNumerator() {
        return this.fBigIntValue;
    }

    @Override
    public int toInt() throws ArithmeticException {
        return this.fBigIntValue.intValueExact();
    }

    @Override
    public int toIntDefault(int defaultValue) {
        try {
            return this.fBigIntValue.intValueExact();
        }
        catch (ArithmeticException aex) {
            return defaultValue;
        }
    }

    @Override
    public long toLongDefault(long defaultValue) {
        try {
            return this.fBigIntValue.longValueExact();
        }
        catch (ArithmeticException aex) {
            return defaultValue;
        }
    }

    @Override
    public long toLong() throws ArithmeticException {
        return this.fBigIntValue.longValueExact();
    }

    public String toString() {
        return this.fBigIntValue.toString();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.fBigIntValue.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) >= 0 && this.fBigIntValue.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) <= 0) {
            int value = this.fBigIntValue.intValue();
            if (value <= 127 && value >= -128) {
                objectOutput.writeByte(1);
                objectOutput.writeByte((byte)value);
                return;
            }
            if (value <= Short.MAX_VALUE && value >= Short.MIN_VALUE) {
                objectOutput.writeByte(2);
                objectOutput.writeShort((short)value);
                return;
            }
            objectOutput.writeByte(4);
            objectOutput.writeInt(value);
            return;
        }
        objectOutput.writeByte(0);
        objectOutput.writeObject(this.fBigIntValue);
    }

    private Object writeReplace() {
        return this.optional();
    }
}

