/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.math.BigInteger;
import java.util.function.Function;
import org.hipparchus.fraction.BigFraction;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.exception.BigIntegerLimitExceeded;
import org.matheclipse.core.expression.AbstractAST;
import org.matheclipse.core.expression.AbstractFractionSym;
import org.matheclipse.core.expression.AbstractIntegerSym;
import org.matheclipse.core.expression.BigIntegerSym;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.FractionSym;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.ParserConfig;

public class BigFractionSym
extends AbstractFractionSym {
    private static final long serialVersionUID = -553051997353641162L;
    transient int fHashValue;
    BigFraction fFraction;

    BigFractionSym(BigFraction fraction) {
        this.fFraction = fraction;
        this.checkBitLength();
    }

    BigFractionSym(BigInteger nom, BigInteger denom) {
        int bitLength = nom.bitLength();
        if (Config.MAX_BIT_LENGTH < bitLength) {
            BigIntegerLimitExceeded.throwIt(bitLength);
        }
        if (Config.MAX_BIT_LENGTH < (bitLength = denom.bitLength())) {
            BigIntegerLimitExceeded.throwIt(bitLength);
        }
        this.fFraction = new BigFraction(nom, denom);
    }

    @Override
    public IFraction abs() {
        return BigFractionSym.valueOf(this.fFraction.abs());
    }

    @Override
    public IFraction add(IFraction other) {
        BigInteger odenom;
        if (other.isZero()) {
            return this;
        }
        if (other instanceof BigFractionSym) {
            BigFraction res = this.fFraction.add(((BigFractionSym)other).toBigFraction());
            return BigFractionSym.valueOf(res);
        }
        BigInteger tdenom = this.toBigDenominator();
        if (tdenom.equals(odenom = other.toBigDenominator())) {
            return BigFractionSym.valueOf(this.toBigNumerator().add(other.toBigNumerator()), tdenom);
        }
        BigInteger gcd = tdenom.gcd(odenom);
        BigInteger tdenomgcd = tdenom.divide(gcd);
        BigInteger odenomgcd = odenom.divide(gcd);
        BigInteger newnum = this.toBigNumerator().multiply(odenomgcd).add(other.toBigNumerator().multiply(tdenomgcd));
        BigInteger newdenom = tdenom.multiply(odenomgcd);
        return BigFractionSym.valueOf(newnum, newdenom);
    }

    @Override
    public IRational add(IRational parm1) {
        if (parm1.isZero()) {
            return this;
        }
        if (parm1 instanceof IFraction) {
            return this.add((IFraction)parm1);
        }
        IInteger p1 = (IInteger)parm1;
        BigInteger newnum = this.toBigNumerator().add(this.toBigDenominator().multiply(p1.toBigNumerator()));
        return BigFractionSym.valueOf(newnum, this.toBigDenominator());
    }

    @Override
    public IInteger ceil() {
        if (this.isIntegral()) {
            return AbstractIntegerSym.valueOf(this.toBigNumerator());
        }
        BigInteger div = this.toBigNumerator().divide(this.toBigDenominator());
        if (this.toBigNumerator().signum() > 0) {
            div = div.add(BigInteger.ONE);
        }
        return AbstractIntegerSym.valueOf(div);
    }

    @Override
    public IInteger ceilFraction() {
        if (this.isIntegral()) {
            return F.ZZ(this.toBigNumerator());
        }
        BigInteger div = this.toBigNumerator().divide(this.toBigDenominator());
        if (this.toBigNumerator().signum() > 0) {
            div = div.add(BigInteger.ONE);
        }
        return F.ZZ(div);
    }

    @Override
    public int compareAbsValueToOne() {
        BigFraction temp = this.fFraction;
        if (this.fFraction.compareTo(BigFraction.ZERO) < 0) {
            temp = temp.negate();
        }
        return temp.compareTo(BigFraction.ONE);
    }

    @Override
    public int compareInt(int value) {
        BigInteger dOn = this.toBigDenominator().multiply(BigInteger.valueOf(value));
        return this.toBigNumerator().compareTo(dOn);
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof IRational) {
            if (expr instanceof IFraction) {
                BigInteger valthis = this.toBigNumerator().multiply(((IFraction)expr).toBigDenominator());
                BigInteger valo = ((IFraction)expr).toBigNumerator().multiply(this.toBigDenominator());
                return valthis.compareTo(valo);
            }
            if (expr instanceof IInteger) {
                return this.fFraction.compareTo(new BigFraction(((IInteger)expr).toBigNumerator(), BigInteger.ONE));
            }
        }
        if (expr.isReal()) {
            return Double.compare(this.fFraction.doubleValue(), ((ISignedNumber)expr).doubleValue());
        }
        return -1;
    }

    @Override
    public ComplexNum complexNumValue() {
        double nr = this.toBigNumerator().doubleValue();
        double dr = this.toBigDenominator().doubleValue();
        return ComplexNum.valueOf(nr / dr);
    }

    @Override
    public IRational dec() {
        return this.add(F.CN1);
    }

    @Override
    public IRational inc() {
        return this.add(F.C1);
    }

    @Override
    public IFraction div(IFraction other) {
        if (other.isOne()) {
            return this;
        }
        if (other.isMinusOne()) {
            return this.negate();
        }
        BigInteger denom = this.toBigDenominator().multiply(other.toBigNumerator());
        BigInteger nom = this.toBigNumerator().multiply(other.toBigDenominator());
        if (denom.equals(BigInteger.ZERO) && other.toBigNumerator().signum() == -1) {
            nom = nom.negate();
        }
        return BigFractionSym.valueOf(nom, denom);
    }

    @Override
    public IInteger[] divideAndRemainder() {
        IInteger[] result = new IInteger[2];
        BigInteger[] intResult = this.toBigNumerator().divideAndRemainder(this.toBigDenominator());
        result[0] = AbstractIntegerSym.valueOf(intResult[0]);
        result[1] = AbstractIntegerSym.valueOf(intResult[1]);
        return result;
    }

    @Override
    public double doubleValue() {
        return this.fFraction.doubleValue();
    }

    public boolean equals(Object o) {
        if (o instanceof BigFractionSym) {
            BigFractionSym r = (BigFractionSym)o;
            return this.fFraction.equals((Object)r.fFraction);
        }
        return false;
    }

    @Override
    public final boolean equalsFraction(int numerator, int denominator) {
        BigInteger num = this.fFraction.getNumerator();
        BigInteger den = this.fFraction.getDenominator();
        return num.intValue() == numerator && den.intValue() == denominator && num.bitLength() <= 31 && den.bitLength() <= 31;
    }

    @Override
    public boolean equalsInt(int numerator) {
        BigInteger num = this.fFraction.getNumerator();
        return num.intValue() == numerator && this.fFraction.getDenominator().equals(BigInteger.ONE) && num.bitLength() <= 31;
    }

    @Override
    public IInteger floor() {
        if (this.isIntegral()) {
            return AbstractIntegerSym.valueOf(this.toBigNumerator());
        }
        BigInteger div = this.toBigNumerator().divide(this.toBigDenominator());
        if (this.toBigNumerator().signum() < 0) {
            div = div.subtract(BigInteger.ONE);
        }
        return AbstractIntegerSym.valueOf(div);
    }

    @Override
    public IInteger floorFraction() {
        if (this.isIntegral()) {
            return F.ZZ(this.toBigNumerator());
        }
        BigInteger div = this.toBigNumerator().divide(this.toBigDenominator());
        if (this.toBigNumerator().signum() < 0) {
            div = div.subtract(BigInteger.ONE);
        }
        return F.ZZ(div);
    }

    @Override
    public IFraction fractionalPart() {
        if (this.isIntegral()) {
            return FractionSym.ZERO;
        }
        BigInteger den = this.fFraction.getDenominator();
        BigInteger newnum = this.fFraction.getNumerator().mod(den);
        if (this.isNegative()) {
            return AbstractFractionSym.valueOf(newnum.negate(), den);
        }
        return AbstractFractionSym.valueOf(newnum, den);
    }

    @Override
    public String fullFormString() {
        StringBuilder buf = new StringBuilder("Rational");
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
            buf.append('(');
        } else {
            buf.append('[');
        }
        buf.append(this.fFraction.getNumerator().toString());
        buf.append(',');
        buf.append(this.fFraction.getDenominator().toString());
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
            buf.append(')');
        } else {
            buf.append(']');
        }
        return buf.toString();
    }

    @Override
    public IExpr gcd(IExpr that) {
        if (that instanceof IFraction) {
            BigFraction arg2 = ((IFraction)that).toBigFraction();
            return BigFractionSym.valueOf(this.fFraction.getNumerator().gcd(arg2.getNumerator()), AbstractIntegerSym.lcm(this.fFraction.getDenominator(), arg2.getDenominator()));
        }
        return super.gcd(that);
    }

    @Override
    public IFraction gcd(IFraction other) {
        if (other.isZero()) {
            return this;
        }
        BigInteger tdenom = this.toBigDenominator();
        BigInteger odenom = other.toBigDenominator();
        BigInteger gcddenom = tdenom.gcd(odenom);
        BigInteger denom = tdenom.divide(gcddenom).multiply(odenom);
        BigInteger num = this.toBigNumerator().gcd(other.toBigNumerator());
        return AbstractFractionSym.valueOf(num, denom);
    }

    @Override
    public BigInteger toBigDenominator() {
        return this.fFraction.getDenominator();
    }

    @Override
    public BigInteger toBigNumerator() {
        return this.fFraction.getNumerator();
    }

    @Override
    public BigFraction toBigFraction() {
        return this.fFraction;
    }

    public int hashCode() {
        if (this.fHashValue == 0 && this.fFraction != null) {
            this.fHashValue = this.fFraction.hashCode();
        }
        return this.fHashValue;
    }

    public IFraction idiv(IFraction other) {
        BigInteger num = this.toBigDenominator().multiply(other.toBigNumerator());
        BigInteger denom = this.toBigNumerator().multiply(other.toBigDenominator());
        if (denom.equals(BigInteger.ZERO) && this.toBigNumerator().signum() == -1) {
            num = num.negate();
        }
        return BigFractionSym.valueOf(num, denom);
    }

    @Override
    public CharSequence internalJavaString(IExpr.SourceCodeProperties properties, int depth, Function<ISymbol, ? extends CharSequence> variables) {
        String prefix = AbstractAST.getPrefixF(properties);
        BigInteger numerator = this.fFraction.getNumerator();
        BigInteger denominator = this.fFraction.getDenominator();
        if (NumberUtil.hasIntValue(numerator) && NumberUtil.hasIntValue(denominator)) {
            int num = numerator.intValue();
            if (num == 1) {
                switch (denominator.intValue()) {
                    case 2: {
                        return prefix + "C1D2";
                    }
                    case 3: {
                        return prefix + "C1D3";
                    }
                    case 4: {
                        return prefix + "C1D4";
                    }
                }
            } else if (num == -1) {
                switch (denominator.intValue()) {
                    case 2: {
                        return prefix + "CN1D2";
                    }
                    case 3: {
                        return prefix + "CN1D3";
                    }
                    case 4: {
                        return prefix + "CN1D4";
                    }
                }
            }
        }
        if (NumberUtil.hasLongValue(numerator) && NumberUtil.hasLongValue(denominator)) {
            return prefix + "QQ(" + numerator.toString() + "L," + denominator.toString() + "L)";
        }
        CharSequence numCode = new BigIntegerSym(numerator).internalJavaString(properties, 0, null);
        CharSequence denCode = new BigIntegerSym(denominator).internalJavaString(properties, 0, null);
        return prefix + "QQ(" + numCode + "," + denCode + ")";
    }

    @Override
    public IFraction inverse() {
        return BigFractionSym.valueOf(this.fFraction.reciprocal());
    }

    @Override
    public boolean isIntegral() {
        return this.fFraction.getDenominator().equals(BigInteger.ONE);
    }

    @Override
    public boolean isMinusOne() {
        return this.fFraction.equals((Object)BigFraction.MINUS_ONE);
    }

    @Override
    public boolean isNegative() {
        return this.fFraction.getNumerator().compareTo(BigInteger.ZERO) < 0;
    }

    @Override
    public boolean isOne() {
        return this.fFraction.equals((Object)BigFraction.ONE);
    }

    @Override
    public boolean isPositive() {
        return this.fFraction.getNumerator().compareTo(BigInteger.ZERO) > 0;
    }

    @Override
    public boolean isZero() {
        return this.fFraction.equals((Object)BigFraction.ZERO);
    }

    public IFraction mul(BigInteger other) {
        if (other.bitLength() < 2) {
            int oint = other.intValue();
            if (oint == 1) {
                return this;
            }
            if (oint == -1) {
                return this.negate();
            }
            if (oint == 0) {
                return FractionSym.ZERO;
            }
        }
        return BigFractionSym.valueOf(this.toBigNumerator().multiply(other), this.toBigDenominator());
    }

    @Override
    public IRational multiply(IRational parm1) {
        if (parm1.isOne()) {
            return this;
        }
        if (parm1.isZero()) {
            return parm1;
        }
        if (parm1.isMinusOne()) {
            return this.negate();
        }
        if (parm1 instanceof IFraction) {
            return this.mul((IFraction)parm1);
        }
        IInteger p1 = (IInteger)parm1;
        BigInteger newnum = this.toBigNumerator().multiply(p1.toBigNumerator());
        return BigFractionSym.valueOf(newnum, this.toBigDenominator());
    }

    @Override
    public IRational multiply(int n) {
        if (n == 1) {
            return this;
        }
        if (n == 0) {
            return FractionSym.ZERO;
        }
        if (n == -1) {
            return this.negate();
        }
        BigInteger newnum = this.toBigNumerator().multiply(BigInteger.valueOf(n));
        return BigFractionSym.valueOf(newnum, this.toBigDenominator());
    }

    @Override
    public IFraction negate() {
        return BigFractionSym.valueOf(this.fFraction.negate());
    }

    @Override
    public IRational normalize() {
        if (this.toBigDenominator().equals(BigInteger.ONE)) {
            return F.ZZ(this.toBigNumerator());
        }
        if (this.toBigNumerator().equals(BigInteger.ZERO)) {
            return F.C0;
        }
        return this;
    }

    @Override
    public IInteger roundExpr() {
        return AbstractIntegerSym.valueOf(NumberUtil.round(this.fFraction, 6));
    }

    @Override
    public int complexSign() {
        return this.fFraction.getNumerator().signum();
    }

    @Override
    public int toInt() throws ArithmeticException {
        if (this.toBigDenominator().equals(BigInteger.ONE)) {
            return this.toBigNumerator().intValueExact();
        }
        if (this.toBigNumerator().equals(BigInteger.ZERO)) {
            return 0;
        }
        throw new ArithmeticException("toInt: denominator != 1");
    }

    @Override
    public int toIntDefault(int defaultValue) {
        if (this.toBigDenominator().equals(BigInteger.ONE)) {
            try {
                return this.toBigNumerator().intValueExact();
            }
            catch (ArithmeticException aex) {
                return defaultValue;
            }
        }
        return this.fFraction.equals((Object)BigFraction.ZERO) ? 0 : defaultValue;
    }

    @Override
    public long toLongDefault(long defaultValue) {
        if (this.toBigDenominator().equals(BigInteger.ONE)) {
            try {
                return this.toBigNumerator().longValueExact();
            }
            catch (ArithmeticException aex) {
                return defaultValue;
            }
        }
        return this.fFraction.equals((Object)BigFraction.ZERO) ? 0L : defaultValue;
    }

    @Override
    public long toLong() throws ArithmeticException {
        if (this.toBigDenominator().equals(BigInteger.ONE)) {
            return this.toBigNumerator().longValueExact();
        }
        if (this.toBigNumerator().equals(BigInteger.ZERO)) {
            return 0L;
        }
        throw new ArithmeticException("toLong: denominator != 1");
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            OutputFormFactory.get().convertFraction(sb, this, Integer.MIN_VALUE, false);
            return sb.toString();
        }
        catch (Exception e1) {
            return this.fFraction.getNumerator().toString() + "/" + this.fFraction.getDenominator().toString();
        }
    }
}

