/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.AST0;
import org.matheclipse.core.expression.AST1;
import org.matheclipse.core.expression.AST2;
import org.matheclipse.core.expression.AbstractAST;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.generic.ObjIntPredicate;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public abstract class B2
extends AbstractAST
implements Externalizable,
RandomAccess {
    private static final int SIZE = 3;
    protected IExpr arg1;
    protected IExpr arg2;

    public B2() {
    }

    public B2(IExpr arg1, IExpr arg2) {
        this.arg1 = arg1;
        this.arg2 = arg2;
    }

    @Override
    public final IExpr arg1() {
        return this.arg1;
    }

    @Override
    public final IExpr arg2() {
        return this.arg2;
    }

    @Override
    public IExpr arg3() {
        throw new IndexOutOfBoundsException("Index: 3, Size: " + this.size());
    }

    @Override
    public IExpr arg4() {
        throw new IndexOutOfBoundsException("Index: 4, Size: " + this.size());
    }

    @Override
    public IExpr arg5() {
        throw new IndexOutOfBoundsException("Index: 5, Size: " + this.size());
    }

    @Override
    public int argSize() {
        return 2;
    }

    @Override
    public Set<IExpr> asSet() {
        HashSet<IExpr> set = new HashSet<IExpr>();
        set.add(this.arg1);
        set.add(this.arg2);
        return set;
    }

    public IAST clone() {
        return this.copy();
    }

    @Override
    public boolean contains(Object object) {
        return this.head().equals(object) || this.arg1.equals(object) || this.arg2.equals(object);
    }

    @Override
    public abstract IASTMutable copy();

    @Override
    public IASTAppendable copyAppendable() {
        return new AST(this.head(), this.arg1, this.arg2);
    }

    @Override
    public IASTAppendable copyAppendable(int additionalCapacity) {
        IASTAppendable result = F.ast((IExpr)this.head(), additionalCapacity + 2);
        result.append(this.arg1);
        result.append(this.arg2);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractAST) {
            IAST list = (IAST)obj;
            ISymbol head = this.head();
            if (head != ((AbstractAST)list).head()) {
                return false;
            }
            return list.size() == 3 && this.arg1.equals(list.arg1()) && this.arg2.equals(list.arg2());
        }
        return false;
    }

    @Override
    public boolean exists(ObjIntPredicate<? super IExpr> predicate, int startOffset) {
        switch (startOffset) {
            case 0: {
                return predicate.test(this.head(), 0) || predicate.test(this.arg1, 1) || predicate.test(this.arg2, 2);
            }
            case 1: {
                return predicate.test(this.arg1, 1) || predicate.test(this.arg2, 2);
            }
            case 2: {
                return predicate.test(this.arg2, 2);
            }
        }
        return false;
    }

    @Override
    public boolean exists(Predicate<? super IExpr> predicate, int startOffset) {
        switch (startOffset) {
            case 0: {
                return predicate.test(this.head()) || predicate.test(this.arg1) || predicate.test(this.arg2);
            }
            case 1: {
                return predicate.test(this.arg1) || predicate.test(this.arg2);
            }
            case 2: {
                return predicate.test(this.arg2);
            }
        }
        return false;
    }

    @Override
    public boolean existsLeft(BiPredicate<IExpr, IExpr> stopPredicate) {
        return stopPredicate.test(this.arg1, this.arg2);
    }

    @Override
    public IAST filter(IASTAppendable filterAST, IASTAppendable restAST, Predicate<? super IExpr> predicate) {
        if (predicate.test(this.arg1)) {
            filterAST.append(this.arg1);
        } else {
            restAST.append(this.arg1);
        }
        if (predicate.test(this.arg2)) {
            filterAST.append(this.arg2);
        } else {
            restAST.append(this.arg2);
        }
        return filterAST;
    }

    @Override
    public IAST filter(IASTAppendable filterAST, Predicate<? super IExpr> predicate) {
        if (predicate.test(this.arg1)) {
            filterAST.append(this.arg1);
        }
        if (predicate.test(this.arg2)) {
            filterAST.append(this.arg2);
        }
        return filterAST;
    }

    @Override
    public IAST filterFunction(IASTAppendable filterAST, IASTAppendable restAST, Function<IExpr, IExpr> function) {
        IExpr expr = function.apply(this.arg1);
        if (expr.isPresent()) {
            filterAST.append(expr);
        } else {
            restAST.append(this.arg1);
        }
        expr = function.apply(this.arg2);
        if (expr.isPresent()) {
            filterAST.append(expr);
        } else {
            restAST.append(this.arg2);
        }
        return filterAST;
    }

    @Override
    public boolean forAll(ObjIntPredicate<? super IExpr> predicate, int startOffset) {
        switch (startOffset) {
            case 0: {
                return predicate.test(this.head(), 0) && predicate.test(this.arg1, 1) && predicate.test(this.arg2, 2);
            }
            case 1: {
                return predicate.test(this.arg1, 1) && predicate.test(this.arg2, 2);
            }
            case 2: {
                return predicate.test(this.arg2, 2);
            }
        }
        return true;
    }

    @Override
    public boolean forAll(Predicate<? super IExpr> predicate, int startOffset) {
        switch (startOffset) {
            case 0: {
                return predicate.test(this.head()) && predicate.test(this.arg1) && predicate.test(this.arg2);
            }
            case 1: {
                return predicate.test(this.arg1) && predicate.test(this.arg2);
            }
            case 2: {
                return predicate.test(this.arg2);
            }
        }
        return true;
    }

    @Override
    public void forEach(Consumer<? super IExpr> action) {
        action.accept(this.arg1);
        action.accept(this.arg2);
    }

    @Override
    public void forEach(Consumer<? super IExpr> action, int startOffset) {
        switch (startOffset) {
            case 0: {
                action.accept(this.head());
                action.accept(this.arg1);
                action.accept(this.arg2);
                break;
            }
            case 1: {
                action.accept(this.arg1);
                action.accept(this.arg2);
                break;
            }
            case 2: {
                action.accept(this.arg2);
            }
        }
    }

    @Override
    public void forEach(int startOffset, int endOffset, Consumer<? super IExpr> action) {
        if (startOffset < endOffset) {
            switch (startOffset) {
                case 0: {
                    action.accept(this.head());
                    if (startOffset + 1 >= endOffset) break;
                    action.accept(this.arg1);
                    if (startOffset + 2 >= endOffset) break;
                    action.accept(this.arg2);
                    break;
                }
                case 1: {
                    action.accept(this.arg1);
                    if (startOffset + 1 >= endOffset) break;
                    action.accept(this.arg2);
                    break;
                }
                case 2: {
                    action.accept(this.arg2);
                }
            }
        }
    }

    @Override
    public void forEach(int start, int end, ObjIntConsumer<? super IExpr> action) {
        if (start < end) {
            switch (start) {
                case 0: {
                    action.accept(this.head(), 0);
                    if (start + 1 >= end) break;
                    action.accept(this.arg1, 1);
                    if (start + 2 >= end) break;
                    action.accept(this.arg2, 2);
                    break;
                }
                case 1: {
                    action.accept(this.arg1, 1);
                    if (start + 1 >= end) break;
                    action.accept(this.arg2, 2);
                    break;
                }
                case 2: {
                    action.accept(this.arg2, 2);
                }
            }
        }
    }

    @Override
    public int indexOf(IExpr expr) {
        if (this.arg1.equals(expr)) {
            return 1;
        }
        if (this.arg2.equals(expr)) {
            return 2;
        }
        return -1;
    }

    @Override
    public int indexOf(Predicate<? super IExpr> predicate, int fromIndex) {
        if (fromIndex == 1 && predicate.test(this.arg1)) {
            return 1;
        }
        if ((fromIndex == 1 || fromIndex == 2) && predicate.test(this.arg2)) {
            return 2;
        }
        return -1;
    }

    @Override
    public IExpr findFirst(Function<IExpr, IExpr> function) {
        IExpr temp = function.apply(this.arg1);
        if (temp.isPresent()) {
            return temp;
        }
        return function.apply(this.arg2);
    }

    @Override
    public IExpr get(int location) {
        switch (location) {
            case 0: {
                return this.head();
            }
            case 1: {
                return this.arg1;
            }
            case 2: {
                return this.arg2;
            }
        }
        throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(location) + ", Size: 3");
    }

    @Override
    public IAST getItems(int[] items, int length) {
        if (length == 0) {
            return this;
        }
        AST result = new AST(length, true);
        result.set(0, this.head());
        for (int i = 0; i < length; ++i) {
            result.set(i + 1, this.get(items[i]));
        }
        return result;
    }

    @Override
    public abstract ISymbol head();

    @Override
    public int headID() {
        ISymbol head = this.head();
        return head instanceof IBuiltInSymbol ? ((IBuiltInSymbol)head).ordinal() : -1;
    }

    @Override
    public int hashCode() {
        if (this.hashValue == 0 && this.arg2 != null) {
            this.hashValue = -2128831035;
            this.hashValue = this.hashValue * 16777619 ^ this.head().hashCode() & 0xFF;
            this.hashValue = this.hashValue * 16777619 ^ this.arg1.hashCode() & 0xFF;
            this.hashValue = this.hashValue * 16777619 ^ this.arg2.hashCode() & 0xFF;
        }
        return this.hashValue;
    }

    @Override
    public final boolean isAST1() {
        return false;
    }

    @Override
    public boolean isAST2() {
        return true;
    }

    @Override
    public boolean isAST3() {
        return false;
    }

    @Override
    public boolean isFlatAST() {
        return false;
    }

    @Override
    public boolean isPlus() {
        return this.head() == S.Plus;
    }

    @Override
    public boolean isPlusTimesPower() {
        ISymbol head = this.head();
        return head == S.Plus || head == S.Times || head == S.Power;
    }

    @Override
    public boolean isPower() {
        return this.head() == S.Power;
    }

    @Override
    public boolean isSameHead(ISymbol head, int length) {
        return this.head() == head && length == 3;
    }

    @Override
    public boolean isSameHead(ISymbol head, int minLength, int maxLength) {
        return this.head() == head && minLength <= 3 && maxLength >= 3;
    }

    @Override
    public boolean isSameHeadSizeGE(ISymbol head, int length) {
        return this.head() == head && length <= 3;
    }

    @Override
    public boolean isTimes() {
        return this.head() == S.Times;
    }

    @Override
    public final IExpr last() {
        return this.arg2;
    }

    @Override
    public final IExpr oneIdentity(IExpr defaultValue) {
        return this;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.fEvalFlags = objectInput.readShort();
        for (int i = 1; i < 3; ++i) {
            this.set(i, (IExpr)objectInput.readObject());
        }
    }

    @Override
    public IAST removeFromEnd(int fromPosition) {
        if (fromPosition == 1) {
            return new AST0(this.head());
        }
        if (fromPosition == 2) {
            return new AST1(this.head(), this.arg1);
        }
        if (fromPosition == 3) {
            return this;
        }
        throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(fromPosition) + ", Size: " + this.size());
    }

    @Override
    public IASTMutable setAtCopy(int i, IExpr expr) {
        if (i == 0) {
            return new AST2(expr, this.arg1(), this.arg2());
        }
        IASTMutable ast = this.copy();
        ast.set(i, expr);
        return ast;
    }

    @Override
    public IExpr set(int location, IExpr object) {
        this.hashValue = 0;
        switch (location) {
            case 0: {
                throw new IndexOutOfBoundsException("Index: 0, Size: 3");
            }
            case 1: {
                IExpr result = this.arg1;
                this.arg1 = object;
                return result;
            }
            case 2: {
                IExpr result = this.arg2;
                this.arg2 = object;
                return result;
            }
        }
        throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(location) + ", Size: 3");
    }

    @Override
    public int size() {
        return 3;
    }

    @Override
    public ISymbol topHead() {
        return this.head();
    }

    @Override
    public IExpr[] toArray() {
        return new IExpr[]{this.head(), this.arg1, this.arg2};
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeShort(this.fEvalFlags);
        for (int i = 1; i < 3; ++i) {
            objectOutput.writeObject(this.get(i));
        }
    }

    static final class With
    extends B2 {
        public With() {
        }

        With(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.With;
        }

        @Override
        public IASTMutable copy() {
            return new With(this.arg1, this.arg2);
        }
    }

    static final class UndirectedEdge
    extends B2 {
        public UndirectedEdge() {
        }

        UndirectedEdge(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.UndirectedEdge;
        }

        @Override
        public IASTMutable copy() {
            return new UndirectedEdge(this.arg1, this.arg2);
        }
    }

    static final class Times
    extends B2 {
        public Times() {
        }

        Times(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.Times;
        }

        @Override
        public final IBuiltInSymbol topHead() {
            return S.Times;
        }

        @Override
        public IASTMutable copy() {
            return new Times(this.arg1, this.arg2);
        }

        @Override
        public boolean isPlusTimesPower() {
            return true;
        }

        @Override
        public boolean isPlus() {
            return false;
        }

        @Override
        public boolean isPower() {
            return false;
        }

        @Override
        public boolean isTimes() {
            return true;
        }

        @Override
        public final boolean isFlatAST() {
            return true;
        }
    }

    static final class SameQ
    extends B2 {
        public SameQ() {
        }

        SameQ(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.SameQ;
        }

        @Override
        public IASTMutable copy() {
            return new SameQ(this.arg1, this.arg2);
        }
    }

    static final class RuleDelayed
    extends B2 {
        public RuleDelayed() {
        }

        RuleDelayed(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.RuleDelayed;
        }

        @Override
        public IASTMutable copy() {
            return new RuleDelayed(this.arg1, this.arg2);
        }
    }

    static final class Rule
    extends B2 {
        public Rule() {
        }

        Rule(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.Rule;
        }

        @Override
        public IASTMutable copy() {
            return new Rule(this.arg1, this.arg2);
        }
    }

    static final class B2Set
    extends B2 {
        public B2Set() {
        }

        B2Set(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.Set;
        }

        @Override
        public IASTMutable copy() {
            return new B2Set(this.arg1, this.arg2);
        }
    }

    static final class Power
    extends B2 {
        public Power() {
        }

        Power(IExpr base, IExpr exponent) {
            super(base, exponent);
        }

        @Override
        public IExpr base() {
            return this.arg1;
        }

        @Override
        public IExpr exponent() {
            return this.arg2;
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.Power;
        }

        @Override
        public IASTMutable copy() {
            return new Power(this.arg1, this.arg2);
        }

        @Override
        public boolean isPlus() {
            return false;
        }

        @Override
        public boolean isPlusTimesPower() {
            return true;
        }

        @Override
        public boolean isPower() {
            return true;
        }

        @Override
        public boolean isTimes() {
            return false;
        }
    }

    static final class PolynomialQ
    extends B2 {
        public PolynomialQ() {
        }

        PolynomialQ(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.PolynomialQ;
        }

        @Override
        public IASTMutable copy() {
            return new PolynomialQ(this.arg1, this.arg2);
        }
    }

    static final class Plus
    extends B2 {
        public Plus() {
        }

        Plus(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.Plus;
        }

        @Override
        public final IBuiltInSymbol topHead() {
            return S.Plus;
        }

        @Override
        public IASTMutable copy() {
            return new Plus(this.arg1, this.arg2);
        }

        @Override
        public boolean isPlus() {
            return true;
        }

        @Override
        public boolean isPlusTimesPower() {
            return true;
        }

        @Override
        public boolean isPower() {
            return false;
        }

        @Override
        public boolean isTimes() {
            return false;
        }

        @Override
        public final boolean isFlatAST() {
            return true;
        }
    }

    static final class Part
    extends B2 {
        public Part() {
        }

        Part(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.Part;
        }

        @Override
        public IASTMutable copy() {
            return new Part(this.arg1, this.arg2);
        }
    }

    static final class Or
    extends B2 {
        public Or() {
        }

        Or(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.Or;
        }

        @Override
        public IASTMutable copy() {
            return new Or(this.arg1, this.arg2);
        }

        @Override
        public final boolean isFlatAST() {
            return true;
        }
    }

    static final class MemberQ
    extends B2 {
        public MemberQ() {
        }

        MemberQ(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.MemberQ;
        }

        @Override
        public IASTMutable copy() {
            return new MemberQ(this.arg1, this.arg2);
        }
    }

    static final class LessEqual
    extends B2 {
        public LessEqual() {
        }

        LessEqual(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.LessEqual;
        }

        @Override
        public IASTMutable copy() {
            return new LessEqual(this.arg1, this.arg2);
        }
    }

    static final class Less
    extends B2 {
        public Less() {
        }

        Less(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.Less;
        }

        @Override
        public IASTMutable copy() {
            return new Less(this.arg1, this.arg2);
        }
    }

    static final class Integrate
    extends B2 {
        public Integrate() {
        }

        Integrate(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.Integrate;
        }

        @Override
        public IASTMutable copy() {
            return new Integrate(this.arg1, this.arg2);
        }
    }

    static final class If
    extends B2 {
        public If() {
        }

        If(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.If;
        }

        @Override
        public IASTMutable copy() {
            return new If(this.arg1, this.arg2);
        }
    }

    static final class GreaterEqual
    extends B2 {
        public GreaterEqual() {
        }

        GreaterEqual(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.GreaterEqual;
        }

        @Override
        public IASTMutable copy() {
            return new GreaterEqual(this.arg1, this.arg2);
        }
    }

    static final class Greater
    extends B2 {
        public Greater() {
        }

        Greater(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.Greater;
        }

        @Override
        public IASTMutable copy() {
            return new Greater(this.arg1, this.arg2);
        }
    }

    static final class FreeQ
    extends B2 {
        public FreeQ() {
        }

        FreeQ(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.FreeQ;
        }

        @Override
        public IASTMutable copy() {
            return new FreeQ(this.arg1, this.arg2);
        }
    }

    static final class Equal
    extends B2 {
        public Equal() {
        }

        Equal(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.Equal;
        }

        @Override
        public IASTMutable copy() {
            return new Equal(this.arg1, this.arg2);
        }
    }

    static final class DirectedEdge
    extends B2 {
        public DirectedEdge() {
        }

        DirectedEdge(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.DirectedEdge;
        }

        @Override
        public IASTMutable copy() {
            return new DirectedEdge(this.arg1, this.arg2);
        }
    }

    static final class Condition
    extends B2 {
        public Condition() {
        }

        Condition(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.Condition;
        }

        @Override
        public IASTMutable copy() {
            return new Condition(this.arg1, this.arg2);
        }
    }

    static final class And
    extends B2 {
        public And() {
        }

        And(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.And;
        }

        @Override
        public IASTMutable copy() {
            return new And(this.arg1, this.arg2);
        }

        @Override
        public final boolean isFlatAST() {
            return true;
        }
    }

    static final class List
    extends B2 {
        public List() {
        }

        List(IExpr arg1, IExpr arg2) {
            super(arg1, arg2);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.List;
        }

        @Override
        public final IBuiltInSymbol topHead() {
            return S.List;
        }

        @Override
        public IASTMutable copy() {
            return new List(this.arg1, this.arg2);
        }
    }
}

