/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.AST0;
import org.matheclipse.core.expression.AST1;
import org.matheclipse.core.expression.AbstractAST;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.generic.ObjIntPredicate;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public abstract class B1
extends AbstractAST
implements Externalizable,
RandomAccess {
    private static final int SIZE = 2;
    protected IExpr arg1;

    public B1() {
    }

    public B1(IExpr arg1) {
        this.arg1 = arg1;
    }

    @Override
    public final IExpr arg1() {
        return this.arg1;
    }

    @Override
    public final IExpr arg2() {
        throw new IndexOutOfBoundsException("Index: 2, Size: " + this.size());
    }

    @Override
    public IExpr arg3() {
        throw new IndexOutOfBoundsException("Index: 3, Size: " + this.size());
    }

    @Override
    public IExpr arg4() {
        throw new IndexOutOfBoundsException("Index: 4, Size: " + this.size());
    }

    @Override
    public IExpr arg5() {
        throw new IndexOutOfBoundsException("Index: 5, Size: " + this.size());
    }

    @Override
    public int argSize() {
        return 1;
    }

    @Override
    public Set<IExpr> asSet() {
        HashSet<IExpr> set = new HashSet<IExpr>();
        set.add(this.arg1);
        return set;
    }

    public IAST clone() {
        return this.copy();
    }

    @Override
    public boolean contains(Object object) {
        return this.head().equals(object) || this.arg1.equals(object);
    }

    @Override
    public abstract IASTMutable copy();

    @Override
    public IASTAppendable copyAppendable() {
        return new AST(this.head(), this.arg1);
    }

    @Override
    public IASTAppendable copyAppendable(int additionalCapacity) {
        IASTAppendable result = F.ast((IExpr)this.head(), additionalCapacity + 1);
        result.append(this.arg1);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractAST) {
            IAST list = (IAST)obj;
            ISymbol head = this.head();
            if (head != ((AbstractAST)list).head()) {
                return false;
            }
            return list.size() == 2 && this.arg1.equals(list.arg1());
        }
        return false;
    }

    @Override
    public boolean exists(ObjIntPredicate<? super IExpr> predicate, int startOffset) {
        switch (startOffset) {
            case 0: {
                return predicate.test(this.head(), 0) || predicate.test(this.arg1, 1);
            }
            case 1: {
                return predicate.test(this.arg1, 1);
            }
        }
        return false;
    }

    @Override
    public boolean exists(Predicate<? super IExpr> predicate, int startOffset) {
        switch (startOffset) {
            case 0: {
                return predicate.test(this.head()) || predicate.test(this.arg1);
            }
            case 1: {
                return predicate.test(this.arg1);
            }
        }
        return false;
    }

    @Override
    public boolean existsLeft(BiPredicate<IExpr, IExpr> stopPredicate) {
        return false;
    }

    @Override
    public IAST filter(IASTAppendable filterAST, IASTAppendable restAST, Predicate<? super IExpr> predicate) {
        if (predicate.test(this.arg1)) {
            filterAST.append(this.arg1);
        } else {
            restAST.append(this.arg1);
        }
        return filterAST;
    }

    @Override
    public IAST filter(IASTAppendable filterAST, Predicate<? super IExpr> predicate) {
        if (predicate.test(this.arg1)) {
            filterAST.append(this.arg1);
        }
        return filterAST;
    }

    @Override
    public IAST filterFunction(IASTAppendable filterAST, IASTAppendable restAST, Function<IExpr, IExpr> function) {
        IExpr expr = function.apply(this.arg1);
        if (expr.isPresent()) {
            filterAST.append(expr);
        } else {
            restAST.append(this.arg1);
        }
        return filterAST;
    }

    @Override
    public boolean forAll(ObjIntPredicate<? super IExpr> predicate, int startOffset) {
        switch (startOffset) {
            case 0: {
                return predicate.test(this.head(), 0) && predicate.test(this.arg1, 1);
            }
            case 1: {
                return predicate.test(this.arg1, 1);
            }
        }
        return true;
    }

    @Override
    public boolean forAll(Predicate<? super IExpr> predicate, int startOffset) {
        switch (startOffset) {
            case 0: {
                return predicate.test(this.head()) && predicate.test(this.arg1);
            }
            case 1: {
                return predicate.test(this.arg1);
            }
        }
        return true;
    }

    @Override
    public void forEach(Consumer<? super IExpr> action) {
        action.accept(this.arg1);
    }

    @Override
    public void forEach(Consumer<? super IExpr> action, int startOffset) {
        switch (startOffset) {
            case 0: {
                action.accept(this.head());
                action.accept(this.arg1);
                break;
            }
            case 1: {
                action.accept(this.arg1);
            }
        }
    }

    @Override
    public void forEach(int startOffset, int endOffset, Consumer<? super IExpr> action) {
        if (startOffset < endOffset) {
            switch (startOffset) {
                case 0: {
                    action.accept(this.head());
                    if (startOffset + 1 >= endOffset) break;
                    action.accept(this.arg1);
                    break;
                }
                case 1: {
                    action.accept(this.arg1);
                }
            }
        }
    }

    @Override
    public void forEach(int start, int end, ObjIntConsumer<? super IExpr> action) {
        if (start < end) {
            switch (start) {
                case 0: {
                    action.accept(this.head(), 0);
                    if (start + 1 >= end) break;
                    action.accept(this.arg1, 1);
                    break;
                }
                case 1: {
                    action.accept(this.arg1, 1);
                }
            }
        }
    }

    @Override
    public int indexOf(IExpr expr) {
        return this.arg1.equals(expr) ? 1 : -1;
    }

    @Override
    public int indexOf(Predicate<? super IExpr> predicate, int fromIndex) {
        if (fromIndex == 1 && predicate.test(this.arg1)) {
            return 1;
        }
        return -1;
    }

    @Override
    public IExpr findFirst(Function<IExpr, IExpr> function) {
        return function.apply(this.arg1);
    }

    @Override
    public IExpr get(int location) {
        switch (location) {
            case 0: {
                return this.head();
            }
            case 1: {
                return this.arg1;
            }
        }
        throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(location) + ", Size: 2");
    }

    @Override
    public IAST getItems(int[] items, int length) {
        if (length == 0) {
            return this;
        }
        AST result = new AST(length, true);
        result.set(0, this.head());
        for (int i = 0; i < length; ++i) {
            result.set(i + 1, this.get(items[i]));
        }
        return result;
    }

    @Override
    public abstract ISymbol head();

    @Override
    public int headID() {
        ISymbol head = this.head();
        return head instanceof IBuiltInSymbol ? ((IBuiltInSymbol)head).ordinal() : -1;
    }

    @Override
    public int hashCode() {
        if (this.hashValue == 0 && this.arg1 != null) {
            this.hashValue = -2128831035;
            this.hashValue = this.hashValue * 16777619 ^ this.head().hashCode() & 0xFF;
            this.hashValue = this.hashValue * 16777619 ^ this.arg1.hashCode() & 0xFF;
        }
        return this.hashValue;
    }

    @Override
    public final boolean isAST1() {
        return true;
    }

    @Override
    public boolean isAST2() {
        return false;
    }

    @Override
    public boolean isAST3() {
        return false;
    }

    @Override
    public final boolean isPlus() {
        return this.head() == S.Plus;
    }

    @Override
    public boolean isPower() {
        return this.head() == S.Power;
    }

    @Override
    public boolean isSameHead(ISymbol head, int length) {
        return this.head() == head && length == 2;
    }

    @Override
    public boolean isSameHead(ISymbol head, int minLength, int maxLength) {
        return this.head() == head && minLength <= 2 && maxLength >= 2;
    }

    @Override
    public boolean isSameHeadSizeGE(ISymbol head, int length) {
        return this.head() == head && length <= 2;
    }

    @Override
    public final boolean isTimes() {
        return this.head() == S.Times;
    }

    @Override
    public final IExpr last() {
        return this.arg1;
    }

    @Override
    public final IExpr oneIdentity(IExpr defaultValue) {
        return this;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.fEvalFlags = objectInput.readShort();
        for (int i = 1; i < 2; ++i) {
            this.set(i, (IExpr)objectInput.readObject());
        }
    }

    @Override
    public IAST removeFromEnd(int fromPosition) {
        if (fromPosition == 1) {
            return new AST0(this.head());
        }
        if (fromPosition == 2) {
            return this;
        }
        throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(fromPosition) + ", Size: " + this.size());
    }

    @Override
    public IASTMutable setAtCopy(int i, IExpr expr) {
        if (i == 0) {
            return new AST1(expr, this.arg1());
        }
        IASTMutable ast = this.copy();
        ast.set(i, expr);
        return ast;
    }

    @Override
    public IExpr set(int location, IExpr object) {
        this.hashValue = 0;
        switch (location) {
            case 0: {
                throw new IndexOutOfBoundsException("Index: 0, Size: 2");
            }
            case 1: {
                IExpr result = this.arg1;
                this.arg1 = object;
                return result;
            }
        }
        throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(location) + ", Size: 2");
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public IExpr[] toArray() {
        return new IExpr[]{this.head(), this.arg1};
    }

    @Override
    public final ISymbol topHead() {
        return this.head();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeShort(this.fEvalFlags);
        for (int i = 1; i < 2; ++i) {
            objectOutput.writeObject(this.get(i));
        }
    }

    static class Throw
    extends B1 {
        public Throw() {
        }

        Throw(IExpr arg1) {
            super(arg1);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.Throw;
        }

        @Override
        public IASTMutable copy() {
            return new Throw(this.arg1);
        }
    }

    static class Tan
    extends B1 {
        public Tan() {
        }

        Tan(IExpr arg1) {
            super(arg1);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.Tan;
        }

        @Override
        public IASTMutable copy() {
            return new Tan(this.arg1);
        }
    }

    static class Sin
    extends B1 {
        public Sin() {
        }

        Sin(IExpr arg1) {
            super(arg1);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.Sin;
        }

        @Override
        public IASTMutable copy() {
            return new Sin(this.arg1);
        }
    }

    static class Return
    extends B1 {
        public Return() {
        }

        Return(IExpr arg1) {
            super(arg1);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.Return;
        }

        @Override
        public IASTMutable copy() {
            return new Return(this.arg1);
        }
    }

    static class Point
    extends B1 {
        public Point() {
        }

        Point(IExpr arg1) {
            super(arg1);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.Point;
        }

        @Override
        public IASTMutable copy() {
            return new Point(this.arg1);
        }
    }

    static class Not
    extends B1 {
        public Not() {
        }

        Not(IExpr arg1) {
            super(arg1);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.Not;
        }

        @Override
        public IASTMutable copy() {
            return new Not(this.arg1);
        }
    }

    static class Missing
    extends B1 {
        public Missing() {
        }

        Missing(IExpr arg1) {
            super(arg1);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.Missing;
        }

        @Override
        public IASTMutable copy() {
            return new Missing(this.arg1);
        }
    }

    static class Log
    extends B1 {
        public Log() {
        }

        Log(IExpr arg1) {
            super(arg1);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.Log;
        }

        @Override
        public IASTMutable copy() {
            return new Log(this.arg1);
        }
    }

    static class List
    extends B1 {
        public List() {
        }

        List(IExpr arg1) {
            super(arg1);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.List;
        }

        @Override
        public IASTMutable copy() {
            return new List(this.arg1);
        }
    }

    static class Line
    extends B1 {
        public Line() {
        }

        Line(IExpr arg1) {
            super(arg1);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.Line;
        }

        @Override
        public IASTMutable copy() {
            return new Line(this.arg1);
        }
    }

    static class IntegerQ
    extends B1 {
        public IntegerQ() {
        }

        IntegerQ(IExpr arg1) {
            super(arg1);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.IntegerQ;
        }

        @Override
        public IASTMutable copy() {
            return new IntegerQ(this.arg1);
        }
    }

    static class Csc
    extends B1 {
        public Csc() {
        }

        Csc(IExpr arg1) {
            super(arg1);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.Csc;
        }

        @Override
        public IASTMutable copy() {
            return new Csc(this.arg1);
        }
    }

    static class Cos
    extends B1 {
        public Cos() {
        }

        Cos(IExpr arg1) {
            super(arg1);
        }

        @Override
        public final IBuiltInSymbol head() {
            return S.Cos;
        }

        @Override
        public IASTMutable copy() {
            return new Cos(this.arg1);
        }
    }
}

