/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.math.BigInteger;
import java.math.RoundingMode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.FixedPrecisionApfloatHelper;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;
import org.matheclipse.parser.client.ParserConfig;

public class ApfloatNum
implements INum {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 2500259920655377884L;
    Apfloat fApfloat;
    public static final Apint MINUS_ONE = new Apint(-1L);

    public static ApfloatNum valueOf(double value) {
        return ApfloatNum.valueOf(new Apfloat(value));
    }

    public static ApfloatNum valueOf(Apfloat value) {
        return new ApfloatNum(value);
    }

    public static ApfloatNum valueOf(BigInteger numerator) {
        return new ApfloatNum(numerator);
    }

    public static ApfloatNum valueOf(BigInteger numerator, BigInteger denominator) {
        FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
        Apfloat n = new Apfloat(numerator, h.precision());
        Apfloat d = new Apfloat(denominator, h.precision());
        return new ApfloatNum(h.divide(n, d));
    }

    public static ApfloatNum valueOf(String value, long precision) {
        return new ApfloatNum(value, precision);
    }

    private ApfloatNum(String value, long precision) {
        this.fApfloat = new Apfloat(value, precision);
    }

    private ApfloatNum(BigInteger value) {
        this.fApfloat = new Apfloat(value, EvalEngine.getApfloat().precision());
    }

    private ApfloatNum(Apfloat value) {
        this.fApfloat = value;
    }

    @Override
    public int hierarchy() {
        return 2;
    }

    @Override
    public boolean isNumEqualInteger(IInteger ii) throws ArithmeticException {
        return this.fApfloat.truncate().equals((Object)new Apint(ii.toBigNumerator())) && this.fApfloat.frac().equals((Object)Apfloat.ZERO);
    }

    @Override
    public boolean isNumEqualRational(IRational value) throws ArithmeticException {
        long precision = this.fApfloat.precision();
        return this.fApfloat.equals((Object)new Apfloat(value.toBigNumerator(), precision).divide(new Apfloat(value.toBigDenominator(), precision)));
    }

    @Override
    public boolean isNumIntValue() {
        return this.fApfloat.frac().equals((Object)Apfloat.ZERO);
    }

    @Override
    public boolean isNegative() {
        return this.fApfloat.signum() == -1;
    }

    @Override
    public boolean isPositive() {
        return this.fApfloat.signum() > 0;
    }

    @Override
    public boolean equalsInt(int i) {
        try {
            return this.fApfloat.intValueExact() == i;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        return F.NIL;
    }

    @Override
    public ISignedNumber evalReal() {
        return this;
    }

    @Override
    public INumber evalNumber() {
        return this;
    }

    @Override
    public INum add(INum value) {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().add(this.fApfloat, value.apfloatValue()));
    }

    @Override
    public INum subtract(INum value) {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().subtract(this.fApfloat, value.apfloatValue()));
    }

    @Override
    public INum divide(INum value) {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().divide(this.fApfloat, value.apfloatValue()));
    }

    @Override
    public INum multiply(INum value) {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().multiply(this.fApfloat, value.apfloatValue()));
    }

    @Override
    public INum pow(INum value) {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().pow(this.fApfloat, value.apfloatValue()));
    }

    @Override
    public IExpr power(IExpr that) {
        if (that instanceof IComplexNum) {
            return F.complexNum(EvalEngine.getApfloat().pow((Apcomplex)this.fApfloat, ((IComplexNum)that).apcomplexValue()));
        }
        if (that instanceof INum) {
            if (this.fApfloat.compareTo((Apfloat)Apfloat.ZERO) < 0) {
                return F.complexNum(EvalEngine.getApfloat().pow((Apcomplex)this.fApfloat, ((INum)that).apcomplexValue()));
            }
            return ApfloatNum.valueOf(EvalEngine.getApfloat().pow(this.fApfloat, ((INum)that).apfloatValue()));
        }
        return INum.super.power(that);
    }

    @Override
    public long precision() throws ApfloatRuntimeException {
        return this.fApfloat.precision();
    }

    @Override
    public ApfloatNum abs() {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().abs(this.fApfloat));
    }

    @Override
    public int compareAbsValueToOne() {
        return EvalEngine.getApfloat().abs(this.fApfloat).compareTo((Apfloat)Apfloat.ONE);
    }

    @Override
    public IExpr dec() {
        return this.add(F.CND1);
    }

    @Override
    public long determinePrecision() {
        return this.precision();
    }

    @Override
    public IExpr inc() {
        return this.add(F.CD1);
    }

    @Override
    public IExpr plus(IExpr that) {
        if (that instanceof ApfloatNum) {
            return this.add((ApfloatNum)that);
        }
        if (that instanceof Num) {
            return this.add(ApfloatNum.valueOf(((Num)that).getRealPart()));
        }
        if (that instanceof ApcomplexNum) {
            return ApcomplexNum.valueOf(this.fApfloat).add((ApcomplexNum)that);
        }
        if (that instanceof ComplexNum) {
            ComplexNum cn = (ComplexNum)that;
            return ApcomplexNum.valueOf(this.fApfloat).add(ApcomplexNum.valueOf(cn.getRealPart(), cn.getImaginaryPart()));
        }
        return INum.super.plus(that);
    }

    @Override
    public ISignedNumber divideBy(ISignedNumber that) {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().divide(this.fApfloat, that.apfloatValue()));
    }

    @Override
    public ISignedNumber subtractFrom(ISignedNumber that) {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().subtract(this.fApfloat, that.apfloatValue()));
    }

    @Override
    public double doubleValue() {
        return this.fApfloat.doubleValue();
    }

    @Override
    public Apfloat apfloatValue() {
        return this.fApfloat;
    }

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 instanceof ApfloatNum) {
            return this.fApfloat.equals((Object)((ApfloatNum)arg0).fApfloat);
        }
        return false;
    }

    @Override
    public boolean isSame(IExpr expression, double epsilon) {
        if (expression instanceof ApfloatNum) {
            return this.fApfloat.equals((Object)((ApfloatNum)expression).fApfloat);
        }
        return false;
    }

    public final int hashCode() {
        return this.fApfloat.hashCode();
    }

    @Override
    public int intValue() {
        return this.fApfloat.intValue();
    }

    @Override
    public int toInt() throws ArithmeticException {
        return this.fApfloat.intValueExact();
    }

    @Override
    public int toIntDefault(int defaultValue) {
        try {
            return this.fApfloat.intValueExact();
        }
        catch (RuntimeException runtimeException) {
            return defaultValue;
        }
    }

    @Override
    public long toLongDefault(long defaultValue) {
        try {
            return this.fApfloat.longValueExact();
        }
        catch (RuntimeException runtimeException) {
            return defaultValue;
        }
    }

    @Override
    public long toLong() throws ArithmeticException {
        return this.fApfloat.longValueExact();
    }

    @Override
    public long leafCountSimplify() {
        return 2L;
    }

    public long longValue() {
        return this.fApfloat.longValue();
    }

    @Override
    public IExpr times(IExpr that) {
        if (that instanceof ApfloatNum) {
            return this.multiply((ApfloatNum)that);
        }
        if (that instanceof Num) {
            return this.multiply(ApfloatNum.valueOf(((Num)that).getRealPart()));
        }
        if (that instanceof ApcomplexNum) {
            return ApcomplexNum.valueOf(this.fApfloat).multiply((ApcomplexNum)that);
        }
        if (that instanceof ComplexNum) {
            ComplexNum cn = (ComplexNum)that;
            return ApcomplexNum.valueOf(this.fApfloat).multiply(ApcomplexNum.valueOf(cn.getRealPart(), cn.getImaginaryPart()));
        }
        return INum.super.times(that);
    }

    @Override
    public ApfloatNum negate() {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().negate(this.fApfloat));
    }

    @Override
    public ApfloatNum opposite() {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().negate(this.fApfloat));
    }

    @Override
    public ApfloatNum inverse() {
        if (this.isOne()) {
            return this;
        }
        return ApfloatNum.valueOf(EvalEngine.getApfloat().inverseRoot(this.fApfloat, 1L));
    }

    @Override
    public IExpr sqrt() {
        if (this.isNegative()) {
            return F.complexNum(EvalEngine.getApfloat().sqrt(this.apcomplexValue()));
        }
        return ApfloatNum.valueOf(EvalEngine.getApfloat().sqrt(this.fApfloat));
    }

    @Override
    public double getRealPart() {
        double temp = this.fApfloat.doubleValue();
        if (temp == -0.0) {
            temp = 0.0;
        }
        return temp;
    }

    @Override
    public boolean isE() {
        return this.fApfloat.equals((Object)EvalEngine.getApfloat().exp((Apfloat)Apfloat.ONE));
    }

    @Override
    public boolean isMinusOne() {
        return this.fApfloat.equals((Object)MINUS_ONE);
    }

    @Override
    public boolean isOne() {
        return this.fApfloat.equals((Object)Apfloat.ONE);
    }

    @Override
    public boolean isPi() {
        return this.fApfloat.equals((Object)EvalEngine.getApfloat().pi());
    }

    @Override
    public boolean isRationalValue(IRational value) {
        return this.fApfloat.equals((Object)value.apfloatNumValue().fApfloat);
    }

    @Override
    public boolean isZero() {
        return this.fApfloat.signum() == 0;
    }

    @Override
    public IInteger roundExpr() {
        Apfloat f = ApfloatMath.round((Apfloat)this.fApfloat, (long)1L, (RoundingMode)RoundingMode.HALF_EVEN);
        return F.ZZ(ApfloatMath.floor((Apfloat)f).toBigInteger());
    }

    @Override
    public ISignedNumber roundClosest(ISignedNumber multiple) {
        throw new ArithmeticException("Apfloat: Round closest not implemented");
    }

    @Override
    public int complexSign() {
        return this.fApfloat.signum();
    }

    @Override
    public IInteger ceilFraction() {
        return F.ZZ(ApfloatMath.ceil((Apfloat)this.fApfloat).toBigInteger());
    }

    public IExpr copy() {
        try {
            return (IExpr)this.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("ApfloatNum.copy() failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public ISignedNumber fractionalPart() {
        return F.num(this.fApfloat.frac());
    }

    @Override
    public String fullFormString() {
        return ApfloatNum.fullFormString(this.fApfloat);
    }

    public static String fullFormString(Apfloat apfloat) {
        Object str = apfloat.toString();
        long precision = apfloat.precision();
        if (!ParserConfig.EXPLICIT_TIMES_OPERATOR) {
            int indx = ((String)str).indexOf("e");
            str = indx > 0 ? ((String)str).substring(0, indx) + "`" + precision + "*^" + ((String)str).substring(indx + 1) : (String)str + "`" + precision;
        }
        return str;
    }

    @Override
    public IInteger floorFraction() {
        return F.ZZ(ApfloatMath.floor((Apfloat)this.fApfloat).toBigInteger());
    }

    @Override
    public IInteger integerPart() {
        return this.isNegative() ? this.ceilFraction() : this.floorFraction();
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof ApfloatNum) {
            return this.fApfloat.compareTo(((ApfloatNum)expr).fApfloat);
        }
        if (expr.isNumber()) {
            if (expr.isReal()) {
                return this.fApfloat.compareTo(((ISignedNumber)expr).apfloatValue());
            }
            int c = this.compareTo(((INumber)expr).re());
            if (c != 0) {
                return c;
            }
        }
        return -1;
    }

    @Override
    public boolean isLT(ISignedNumber that) {
        if (that instanceof ApfloatNum) {
            return this.fApfloat.compareTo(((ApfloatNum)that).fApfloat) < 0;
        }
        return this.doubleValue() < that.doubleValue();
    }

    @Override
    public boolean isGT(ISignedNumber that) {
        if (that instanceof ApfloatNum) {
            return this.fApfloat.compareTo(((ApfloatNum)that).fApfloat) > 0;
        }
        return this.doubleValue() > that.doubleValue();
    }

    @Override
    public ISymbol head() {
        return S.Real;
    }

    public String toString() {
        String str = this.fApfloat.toString();
        if (ParserConfig.EXPLICIT_TIMES_OPERATOR) {
            return str.replace("e", "E");
        }
        int index = str.indexOf(101);
        if (index > 0) {
            String exponentStr = str.substring(index + 1);
            String result = str.substring(0, index);
            return result + "*10^" + exponentStr;
        }
        return str;
    }

    @Override
    public IExpr accept(IVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return visitor.visit(this);
    }

    @Override
    public ISignedNumber im() {
        return F.CD0;
    }

    @Override
    public ISignedNumber re() {
        return this;
    }

    @Override
    public ApfloatNum apfloatNumValue() {
        return this;
    }

    @Override
    public Num numValue() {
        return Num.valueOf(this.doubleValue());
    }

    @Override
    public Apcomplex apcomplexValue() {
        return new Apcomplex(this.fApfloat);
    }

    @Override
    public ApcomplexNum apcomplexNumValue() {
        return ApcomplexNum.valueOf(this.fApfloat);
    }

    @Override
    public ComplexNum complexNumValue() {
        return ComplexNum.valueOf(this.fApfloat.doubleValue());
    }

    @Override
    public double imDoubleValue() {
        return 0.0;
    }

    @Override
    public double reDoubleValue() {
        return this.doubleValue();
    }

    @Override
    public IExpr multiply(int value) {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().multiply(this.fApfloat, new Apfloat((long)value)));
    }

    @Override
    public IExpr acos() {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().acos(this.fApfloat));
    }

    @Override
    public IExpr acosh() {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().acosh(this.fApfloat));
    }

    @Override
    public IExpr add(double value) {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().add(this.fApfloat, new Apfloat(value)));
    }

    @Override
    public IExpr asin() {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().asin(this.fApfloat));
    }

    @Override
    public IExpr asinh() {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().asinh(this.fApfloat));
    }

    @Override
    public IExpr atan() {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().atan(this.fApfloat));
    }

    @Override
    public IExpr atanh() {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().atanh(this.fApfloat));
    }

    @Override
    public IExpr cbrt() {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().cbrt(this.fApfloat));
    }

    @Override
    public IExpr ceil() {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().ceil(this.fApfloat));
    }

    @Override
    public IExpr copySign(double d) {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().copySign(this.fApfloat, new Apfloat(d)));
    }

    @Override
    public IExpr cos() {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().cos(this.fApfloat));
    }

    @Override
    public IExpr cosh() {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().cosh(this.fApfloat));
    }

    @Override
    public IExpr divide(double value) {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().divide(this.fApfloat, new Apfloat(value)));
    }

    @Override
    public IExpr divide(IExpr that) {
        if (that instanceof ApfloatNum) {
            return this.divide((ApfloatNum)that);
        }
        if (that instanceof Num) {
            return this.divide(((Num)that).getRealPart());
        }
        if (that instanceof ApcomplexNum) {
            return F.complexNum(EvalEngine.getApfloat().divide((Apcomplex)this.fApfloat, ((ApcomplexNum)that).apcomplexValue()));
        }
        if (that instanceof ComplexNum) {
            return F.complexNum(EvalEngine.getApfloat().divide((Apcomplex)this.fApfloat, ((ComplexNum)that).apcomplexValue()));
        }
        return INum.super.divide(that);
    }

    @Override
    public IExpr expm1() {
        FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
        return ApfloatNum.valueOf(h.subtract(h.exp(this.fApfloat), (Apfloat)Apfloat.ONE));
    }

    @Override
    public IExpr floor() {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().floor(this.fApfloat));
    }

    @Override
    public double getReal() {
        return this.fApfloat.doubleValue();
    }

    @Override
    public IExpr exp() {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().exp(this.fApfloat));
    }

    @Override
    public IExpr log() {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().log(this.fApfloat));
    }

    @Override
    public IExpr log10() {
        FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
        return ApfloatNum.valueOf(h.log(this.fApfloat, new Apfloat(10L)));
    }

    @Override
    public IExpr log1p() {
        FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
        return ApfloatNum.valueOf(h.log(h.add(this.fApfloat, (Apfloat)Apfloat.ONE)));
    }

    @Override
    public IExpr multiply(double value) {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().multiply(this.fApfloat, new Apfloat(value)));
    }

    @Override
    public ApfloatNum newInstance(double d) {
        return ApfloatNum.valueOf(d);
    }

    @Override
    public IExpr pow(int n) {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().pow(this.fApfloat, (long)n));
    }

    @Override
    public IExpr pow(double value) {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().pow(this.fApfloat, new Apfloat(value)));
    }

    @Override
    public IExpr reciprocal() {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().inverseRoot(this.fApfloat, 1L));
    }

    @Override
    public IExpr remainder(double value) {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().mod(this.fApfloat, new Apfloat(value)));
    }

    @Override
    public IExpr rint() {
        return ApfloatNum.valueOf(ApfloatNum.apfloatRint(this.fApfloat));
    }

    static Apfloat apfloatRint(Apfloat fApfloat) {
        if (fApfloat.scale() > 0L) {
            return ApfloatMath.round((Apfloat)fApfloat, (long)fApfloat.scale(), (RoundingMode)RoundingMode.HALF_EVEN);
        }
        if (ApfloatMath.abs((Apfloat)fApfloat).compareTo(new Apfloat("0.5")) <= 0) {
            return Apfloat.ZERO;
        }
        return ApfloatMath.copySign((Apfloat)Apfloat.ONE, (Apfloat)fApfloat);
    }

    @Override
    public IExpr scalb(int n) {
        FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
        return ApfloatNum.valueOf(h.multiply(this.fApfloat, h.pow(new Apfloat(2L), (long)n)));
    }

    @Override
    public IExpr rootN(int n) {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().root(this.fApfloat, (long)n));
    }

    @Override
    public IExpr sign() {
        if (this.isNaN() || this.isZero()) {
            return this;
        }
        return ApfloatNum.valueOf(EvalEngine.getApfloat().abs(this.fApfloat));
    }

    @Override
    public IExpr sin() {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().sin(this.fApfloat));
    }

    @Override
    public IExpr sinh() {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().sinh(this.fApfloat));
    }

    @Override
    public IExpr subtract(double value) {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().subtract(this.fApfloat, new Apfloat(value)));
    }

    @Override
    public IExpr subtract(IExpr that) {
        if (that instanceof ApfloatNum) {
            return this.subtract((ApfloatNum)that);
        }
        if (that instanceof Num) {
            return this.subtract(((Num)that).getRealPart());
        }
        if (that instanceof ApcomplexNum) {
            return F.complexNum(EvalEngine.getApfloat().subtract((Apcomplex)this.fApfloat, ((ApcomplexNum)that).apcomplexValue()));
        }
        if (that instanceof ComplexNum) {
            return F.complexNum(EvalEngine.getApfloat().subtract((Apcomplex)this.fApfloat, ((ComplexNum)that).apcomplexValue()));
        }
        return INum.super.subtract(that);
    }

    @Override
    public IExpr tan() {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().tan(this.fApfloat));
    }

    @Override
    public IExpr tanh() {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().tanh(this.fApfloat));
    }

    @Override
    public IExpr ulp() {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().ulp((Apfloat)Apfloat.ONE));
    }

    @Override
    public IExpr getPi() {
        return ApfloatNum.valueOf(EvalEngine.getApfloat().pi());
    }

    @Override
    public IExpr toDegrees() {
        FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
        return ApfloatNum.valueOf(ApfloatNum.toDegrees(this.fApfloat, h));
    }

    @Override
    public IExpr toRadians() {
        FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
        return ApfloatNum.valueOf(ApfloatNum.toRadians(this.fApfloat, h));
    }

    static Apfloat toDegrees(Apfloat radians, FixedPrecisionApfloatHelper h) {
        return h.divide(h.multiply(radians, new Apfloat(180L)), h.pi());
    }

    static Apfloat toRadians(Apfloat degrees, FixedPrecisionApfloatHelper h) {
        return h.divide(h.multiply(degrees, h.pi()), new Apfloat(180L));
    }
}

