/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.FixedPrecisionApfloatHelper;
import org.hipparchus.complex.Complex;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;
import org.matheclipse.parser.client.ParserConfig;

public class ApcomplexNum
implements IComplexNum {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = -6033055105824482264L;
    public static final ApcomplexNum I = new ApcomplexNum(Apcomplex.I);
    public static final ApcomplexNum ONE = new ApcomplexNum((Apfloat)Apcomplex.ONE);
    public static final ApcomplexNum MINUS_ONE = new ApcomplexNum(new Apfloat(-1L));
    public static final ApcomplexNum ZERO = new ApcomplexNum((Apfloat)Apcomplex.ZERO);
    Apcomplex fApcomplex;

    public static ApcomplexNum valueOf(Apcomplex value) {
        return new ApcomplexNum(value);
    }

    public static ApcomplexNum valueOf(Apfloat real) {
        return new ApcomplexNum(real);
    }

    public static ApcomplexNum valueOf(Apfloat real, Apfloat imag) {
        return new ApcomplexNum(real, imag);
    }

    public static ApcomplexNum valueOf(double real) {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().valueOf(new Apcomplex(new Apfloat(real))));
    }

    public static ApcomplexNum valueOf(double real, double imaginary) {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().valueOf(new Apcomplex(new Apfloat(real), new Apfloat(imaginary))));
    }

    public static ApcomplexNum valueOf(Complex c, long precision) {
        return ApcomplexNum.valueOf(new Apcomplex(new Apfloat(new BigDecimal(c.getReal()), precision), new Apfloat(new BigDecimal(c.getImaginary()), precision)));
    }

    public static ApcomplexNum valueOf(String realPart, String imaginaryPart, long precision) {
        return new ApcomplexNum(realPart, imaginaryPart, precision);
    }

    public static ApcomplexNum valueOf(BigInteger realNumerator, BigInteger realDenominator, BigInteger imagNumerator, BigInteger imagDenominator) {
        FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
        long prec = h.precision();
        Apfloat real = h.divide(new Apfloat(realNumerator, prec), new Apfloat(realDenominator, prec));
        Apfloat imag = h.divide(new Apfloat(imagNumerator, prec), new Apfloat(imagDenominator, prec));
        return new ApcomplexNum(real, imag);
    }

    private ApcomplexNum(Apcomplex complex) {
        this.fApcomplex = complex;
    }

    private ApcomplexNum(Apfloat real) {
        this.fApcomplex = new Apcomplex(real);
    }

    private ApcomplexNum(Apfloat real, Apfloat imag) {
        this.fApcomplex = new Apcomplex(real, imag);
    }

    private ApcomplexNum(String realPart, String imaginaryPart, long precision) {
        this.fApcomplex = new Apcomplex(new Apfloat(realPart, precision), new Apfloat(imaginaryPart, precision));
    }

    @Override
    public double getImaginaryPart() {
        double temp = this.fApcomplex.imag().doubleValue();
        if (temp == -0.0) {
            temp = 0.0;
        }
        return temp;
    }

    @Override
    public Apcomplex apcomplexValue() {
        return this.fApcomplex;
    }

    @Override
    public ApcomplexNum apcomplexNumValue() {
        return this;
    }

    @Override
    public ComplexNum complexNumValue() {
        return ComplexNum.valueOf(this.fApcomplex.real().doubleValue(), this.fApcomplex.imag().doubleValue());
    }

    @Override
    public IExpr dec() {
        return this.add(MINUS_ONE);
    }

    @Override
    public long determinePrecision() {
        return this.precision();
    }

    @Override
    public IExpr inc() {
        return this.add(ONE);
    }

    @Override
    public double getRealPart() {
        double temp = this.fApcomplex.real().doubleValue();
        if (temp == -0.0) {
            temp = 0.0;
        }
        return temp;
    }

    @Override
    public boolean isZero() {
        return this.fApcomplex.real().signum() == 0 && this.fApcomplex.imag().signum() == 0;
    }

    @Override
    public int hierarchy() {
        return 4;
    }

    @Override
    public IComplexNum add(IComplexNum val) {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().add(this.fApcomplex, val.apcomplexValue()));
    }

    public ApcomplexNum add(ApcomplexNum that) {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().add(this.fApcomplex, that.fApcomplex));
    }

    @Override
    public IComplexNum multiply(IComplexNum val) {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().multiply(this.fApcomplex, val.apcomplexValue()));
    }

    @Override
    public IExpr multiply(IExpr that) {
        if (that instanceof IComplexNum) {
            return ApcomplexNum.valueOf(EvalEngine.getApfloat().multiply(this.fApcomplex, ((IComplexNum)that).apcomplexValue()));
        }
        if (that instanceof INum) {
            return ApcomplexNum.valueOf(EvalEngine.getApfloat().multiply(this.fApcomplex, ((INum)that).apcomplexValue()));
        }
        return IComplexNum.super.multiply(that);
    }

    @Override
    public IComplexNum pow(IComplexNum val) {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().pow(this.fApcomplex, val.apcomplexValue()));
    }

    @Override
    public IExpr power(IExpr that) {
        if (that instanceof IComplexNum) {
            return ApcomplexNum.valueOf(EvalEngine.getApfloat().pow(this.fApcomplex, ((IComplexNum)that).apcomplexValue()));
        }
        if (that instanceof INum) {
            return ApcomplexNum.valueOf(EvalEngine.getApfloat().pow(this.fApcomplex, ((INum)that).apcomplexValue()));
        }
        return IComplexNum.super.power(that);
    }

    @Override
    public IComplexNum conjugate() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().conj(this.fApcomplex));
    }

    public IExpr copy() {
        try {
            return (IExpr)this.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("ApcomplexNum.copy() failed", (Throwable)e);
            return null;
        }
    }

    public ApcomplexNum divide(ApcomplexNum that) throws ArithmeticException {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().divide(this.fApcomplex, that.fApcomplex));
    }

    @Override
    public IComplexNum divide(IComplexNum val) {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().divide(this.fApcomplex, val.apcomplexValue()));
    }

    @Override
    public IExpr divide(IExpr that) {
        if (that.isZero()) {
            IOFunctions.printMessage(S.Divide, "infy", F.list(F.Divide(this, that)), EvalEngine.get());
            return F.CComplexInfinity;
        }
        if (that instanceof IComplexNum) {
            return ApcomplexNum.valueOf(EvalEngine.getApfloat().divide(this.fApcomplex, ((IComplexNum)that).apcomplexValue()));
        }
        if (that instanceof INum) {
            return ApcomplexNum.valueOf(EvalEngine.getApfloat().divide(this.fApcomplex, ((INum)that).apcomplexValue()));
        }
        return IComplexNum.super.divide(that);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ApcomplexNum) {
            return this.fApcomplex.equals((Object)((ApcomplexNum)obj).fApcomplex);
        }
        return false;
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        return F.NIL;
    }

    @Override
    public INumber evalNumber() {
        return this;
    }

    @Override
    public boolean isSame(IExpr expression, double epsilon) {
        if (expression instanceof ApcomplexNum) {
            return this.fApcomplex.equals((Object)((ApcomplexNum)expression).fApcomplex);
        }
        return false;
    }

    @Override
    public double dabs() {
        if (Math.abs(this.reDoubleValue()) < Math.abs(this.imDoubleValue())) {
            if (this.imDoubleValue() == 0.0) {
                return Math.abs(this.reDoubleValue());
            }
            double q = this.reDoubleValue() / this.imDoubleValue();
            return Math.abs(this.imDoubleValue()) * Math.sqrt(1.0 + q * q);
        }
        if (this.reDoubleValue() == 0.0) {
            return Math.abs(this.imDoubleValue());
        }
        double q = this.imDoubleValue() / this.reDoubleValue();
        return Math.abs(this.reDoubleValue()) * Math.sqrt(1.0 + q * q);
    }

    @Override
    public IExpr complexArg() {
        try {
            return F.num(EvalEngine.getApfloat().arg(this.fApcomplex));
        }
        catch (ArithmeticException aex) {
            IOFunctions.printMessage(S.Arg, "indet", F.list(F.Arg(this)), EvalEngine.get());
            return S.Indeterminate;
        }
    }

    @Override
    public int compareAbsValueToOne() {
        double temp = this.dabs();
        return Double.compare(temp, 1.0);
    }

    @Override
    public double imDoubleValue() {
        return this.fApcomplex.imag().doubleValue();
    }

    @Override
    public double reDoubleValue() {
        return this.fApcomplex.real().doubleValue();
    }

    public final int hashCode() {
        return this.fApcomplex.hashCode();
    }

    @Override
    public long leafCountSimplify() {
        return 5L;
    }

    public ApcomplexNum multiply(ApcomplexNum that) {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().multiply(this.fApcomplex, that.fApcomplex));
    }

    @Override
    public ApcomplexNum negate() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().negate(this.fApcomplex));
    }

    @Override
    public INumber opposite() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().negate(this.fApcomplex));
    }

    @Override
    public IExpr plus(IExpr that) {
        if (that instanceof IComplexNum) {
            return ApcomplexNum.valueOf(EvalEngine.getApfloat().add(this.fApcomplex, ((IComplexNum)that).apcomplexValue()));
        }
        if (that instanceof INum) {
            return ApcomplexNum.valueOf(EvalEngine.getApfloat().add(this.fApcomplex, ((INum)that).apcomplexValue()));
        }
        return IComplexNum.super.plus(that);
    }

    @Override
    public IExpr inverse() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().inverseRoot(this.fApcomplex, 1L));
    }

    public Apcomplex subtract(Apcomplex that) {
        return EvalEngine.getApfloat().subtract(this.fApcomplex, that);
    }

    public ApcomplexNum subtract(ApcomplexNum that) {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().subtract(this.fApcomplex, that.fApcomplex));
    }

    @Override
    public IComplexNum subtract(IComplexNum val) {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().subtract(this.fApcomplex, ((ApcomplexNum)val).fApcomplex));
    }

    @Override
    public IExpr times(IExpr that) {
        if (that instanceof ApcomplexNum) {
            return ApcomplexNum.valueOf(EvalEngine.getApfloat().multiply(this.fApcomplex, ((ApcomplexNum)that).fApcomplex));
        }
        if (that instanceof ApfloatNum) {
            return this.multiply(ApcomplexNum.valueOf(((ApfloatNum)that).fApfloat, (Apfloat)Apcomplex.ZERO));
        }
        if (that instanceof Num) {
            return this.multiply(ApcomplexNum.valueOf(((Num)that).getRealPart()));
        }
        if (that instanceof ComplexNum) {
            return ApcomplexNum.valueOf(EvalEngine.getApfloat().multiply(this.fApcomplex, ((ComplexNum)that).apcomplexValue()));
        }
        return IComplexNum.super.times(that);
    }

    @Override
    public IAST toPolarCoordinates() {
        return F.list(this.abs(), this.complexArg());
    }

    public String toString() {
        String str = this.fApcomplex.toString();
        if (ParserConfig.EXPLICIT_TIMES_OPERATOR) {
            return str.replace("e", "E");
        }
        int index = str.indexOf(101);
        if (index > 0) {
            String exponentStr1 = str.substring(++index);
            str = str.replace("e", "*10^");
            int index2 = exponentStr1.indexOf(101);
            if (index2 > 0) {
                str = str.replace("e", "*10^");
            }
        }
        return str;
    }

    @Override
    public int complexSign() {
        int i = this.fApcomplex.real().signum();
        if (i == 0) {
            return this.fApcomplex.imag().signum();
        }
        return i;
    }

    @Override
    public int compareTo(Apcomplex that) {
        if (this.fApcomplex.real().compareTo(that.real()) < 0) {
            return -1;
        }
        if (this.fApcomplex.real().compareTo(that.real()) > 0) {
            return 1;
        }
        if (that.imag().signum() == 0) {
            if (this.fApcomplex.imag().signum() != 0) {
                return 1;
            }
        } else if (this.fApcomplex.imag().signum() == 0) {
            return -1;
        }
        return this.fApcomplex.imag().compareTo(that.imag());
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr.isNumber()) {
            if (expr instanceof ApcomplexNum) {
                return this.compareTo(((ApcomplexNum)expr).fApcomplex);
            }
            return this.compareTo(((INumber)expr).apcomplexValue());
        }
        return -1;
    }

    @Override
    public ISymbol head() {
        return S.Complex;
    }

    public Apcomplex getComplex() {
        return this.fApcomplex;
    }

    public Complex getCMComplex() {
        return new Complex(this.fApcomplex.real().doubleValue(), this.fApcomplex.imag().doubleValue());
    }

    @Override
    public IExpr accept(IVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equalsInt(int i) {
        return false;
    }

    @Override
    public ISignedNumber im() {
        return F.num(this.getImaginaryPart());
    }

    @Override
    public ISignedNumber re() {
        return F.num(this.getRealPart());
    }

    @Override
    public INumber roundExpr() {
        Apfloat re = ApfloatMath.round((Apfloat)this.fApcomplex.real(), (long)1L, (RoundingMode)RoundingMode.HALF_EVEN);
        Apfloat im = ApfloatMath.round((Apfloat)this.fApcomplex.imag(), (long)1L, (RoundingMode)RoundingMode.HALF_EVEN);
        return F.complex(F.ZZ(ApfloatMath.floor((Apfloat)re).toBigInteger()), F.ZZ(ApfloatMath.floor((Apfloat)im).toBigInteger()));
    }

    @Override
    public IExpr sqrt() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().sqrt(this.fApcomplex));
    }

    @Override
    public INumber ceilFraction() throws ArithmeticException {
        return F.complex(F.ZZ(ApfloatMath.ceil((Apfloat)this.fApcomplex.real()).toBigInteger()), F.ZZ(ApfloatMath.ceil((Apfloat)this.fApcomplex.imag()).toBigInteger()));
    }

    @Override
    public INumber fractionalPart() {
        return F.complexNum(this.fApcomplex.real().frac(), this.fApcomplex.imag().frac());
    }

    @Override
    public INumber floorFraction() throws ArithmeticException {
        return F.complex(F.ZZ(ApfloatMath.floor((Apfloat)this.fApcomplex.real()).toBigInteger()), F.ZZ(ApfloatMath.floor((Apfloat)this.fApcomplex.imag()).toBigInteger()));
    }

    @Override
    public String fullFormString() {
        int indx;
        StringBuilder buf = new StringBuilder();
        long precision = this.fApcomplex.precision();
        Object str = this.fApcomplex.real().toString();
        if (!ParserConfig.EXPLICIT_TIMES_OPERATOR) {
            indx = ((String)str).indexOf("e");
            str = indx > 0 ? ((String)str).substring(0, indx) + "`" + precision + "*^" + ((String)str).substring(indx + 1) : (String)str + "`" + precision;
        }
        buf.append((String)str);
        buf.append(',');
        str = this.fApcomplex.imag().toString();
        if (!ParserConfig.EXPLICIT_TIMES_OPERATOR) {
            indx = ((String)str).indexOf("e");
            str = indx > 0 ? ((String)str).substring(0, indx) + "``" + precision + "*^" + ((String)str).substring(indx + 1) : (String)str + "`" + precision;
        }
        buf.append((String)str);
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
            buf.append(')');
        } else {
            buf.append(']');
        }
        return buf.toString();
    }

    @Override
    public IComplex integerPart() {
        Apfloat re = this.fApcomplex.real();
        Apfloat im = this.fApcomplex.imag();
        IInteger reInt = re.signum() == -1 ? F.ZZ(ApfloatMath.ceil((Apfloat)re).toBigInteger()) : F.ZZ(ApfloatMath.floor((Apfloat)re).toBigInteger());
        IInteger imInt = im.signum() == -1 ? F.ZZ(ApfloatMath.ceil((Apfloat)im).toBigInteger()) : F.ZZ(ApfloatMath.floor((Apfloat)im).toBigInteger());
        return F.complex(reInt, imInt);
    }

    @Override
    public long precision() throws ApfloatRuntimeException {
        return this.fApcomplex.precision();
    }

    @Override
    public IExpr abs() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().abs(this.fApcomplex));
    }

    @Override
    public IExpr acos() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().acos(this.fApcomplex));
    }

    @Override
    public IExpr acosh() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().acosh(this.fApcomplex));
    }

    @Override
    public IExpr add(double value) {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().divide(this.fApcomplex, (Apcomplex)new Apfloat(value)));
    }

    @Override
    public IExpr asin() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().asin(this.fApcomplex));
    }

    @Override
    public IExpr asinh() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().asinh(this.fApcomplex));
    }

    @Override
    public IExpr atan() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().atan(this.fApcomplex));
    }

    @Override
    public IExpr atan2(IExpr value) {
        try {
            if (value instanceof ApcomplexNum) {
                Apcomplex th = this.fApcomplex;
                Apcomplex x = ((ApcomplexNum)value).fApcomplex;
                FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
                Apcomplex r = h.sqrt(h.add(h.multiply(x, x), h.multiply(th, th)));
                if (x.real().compareTo((Apfloat)Apfloat.ZERO) >= 0) {
                    return ApcomplexNum.valueOf(h.multiply(h.atan(h.divide(th, h.add(r, x))), (Apcomplex)new Apfloat(2L)));
                }
                return ApcomplexNum.valueOf(h.add(h.multiply(h.atan(h.divide(th, h.subtract(r, x))), (Apcomplex)new Apfloat(-2L)), (Apcomplex)h.pi()));
            }
            return IComplexNum.super.atan2(value);
        }
        catch (ArithmeticException aex) {
            IOFunctions.printMessage(S.ArcTan, "indet", F.list(F.ArcTan(value, this)), EvalEngine.get());
            return S.Indeterminate;
        }
    }

    @Override
    public IExpr atanh() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().atanh(this.fApcomplex));
    }

    @Override
    public IExpr cbrt() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().cbrt(this.fApcomplex));
    }

    @Override
    public IExpr ceil() {
        return ApcomplexNum.valueOf((Apfloat)ApfloatMath.ceil((Apfloat)this.fApcomplex.real()), (Apfloat)ApfloatMath.ceil((Apfloat)this.fApcomplex.imag()));
    }

    @Override
    public IExpr copySign(double d) {
        FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
        Apfloat sign = new Apfloat(d);
        return ApcomplexNum.valueOf(h.copySign(this.fApcomplex.real(), sign), h.copySign(this.fApcomplex.imag(), sign));
    }

    @Override
    public IExpr cos() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().cos(this.fApcomplex));
    }

    @Override
    public IExpr cosh() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().cosh(this.fApcomplex));
    }

    @Override
    public IExpr divide(double value) {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().divide(this.fApcomplex, (Apcomplex)new Apfloat(value)));
    }

    @Override
    public IExpr expm1() {
        FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
        return ApcomplexNum.valueOf(h.subtract(h.exp(this.fApcomplex), (Apcomplex)Apfloat.ONE));
    }

    @Override
    public IExpr floor() {
        return ApcomplexNum.valueOf((Apfloat)ApfloatMath.floor((Apfloat)this.fApcomplex.real()), (Apfloat)ApfloatMath.floor((Apfloat)this.fApcomplex.imag()));
    }

    @Override
    public double getReal() {
        return this.fApcomplex.real().doubleValue();
    }

    @Override
    public IExpr exp() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().exp(this.fApcomplex));
    }

    @Override
    public IExpr log() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().log(this.fApcomplex));
    }

    @Override
    public IExpr log10() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().log(this.fApcomplex, (Apcomplex)new Apfloat(10L)));
    }

    @Override
    public IExpr log1p() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().log(this.fApcomplex.add((Apcomplex)Apfloat.ONE)));
    }

    @Override
    public IExpr multiply(double value) {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().multiply(this.fApcomplex, (Apcomplex)new Apfloat(value)));
    }

    @Override
    public IExpr multiply(int value) {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().multiply(this.fApcomplex, (Apcomplex)new Apfloat((long)value)));
    }

    @Override
    public ApcomplexNum newInstance(double d) {
        return ApcomplexNum.valueOf(d);
    }

    @Override
    public IExpr pow(int n) {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().pow(this.fApcomplex, (long)n));
    }

    @Override
    public IExpr pow(double value) {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().pow(this.fApcomplex, (Apcomplex)new Apfloat(value)));
    }

    @Override
    public IExpr reciprocal() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().inverseRoot(this.fApcomplex, 1L));
    }

    @Override
    public IExpr remainder(double value) {
        FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
        return ApcomplexNum.valueOf(h.mod(this.fApcomplex.real(), new Apfloat(value)), h.mod(this.fApcomplex.imag(), new Apfloat(value)));
    }

    @Override
    public IExpr rint() {
        return ApcomplexNum.valueOf(ApfloatNum.apfloatRint(this.fApcomplex.real()), ApfloatNum.apfloatRint(this.fApcomplex.imag()));
    }

    @Override
    public IExpr scalb(int n) {
        FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
        return ApcomplexNum.valueOf(h.multiply(this.fApcomplex, (Apcomplex)h.pow(new Apfloat(2L), (long)n)));
    }

    @Override
    public IExpr rootN(int n) {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().root(this.fApcomplex, (long)n));
    }

    @Override
    public IExpr sign() {
        if (this.isNaN() || this.isZero()) {
            return this;
        }
        FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
        return ApcomplexNum.valueOf(h.divide(this.fApcomplex, (Apcomplex)h.abs(this.fApcomplex)));
    }

    @Override
    public IExpr sin() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().sin(this.fApcomplex));
    }

    @Override
    public IExpr sinh() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().sinh(this.fApcomplex));
    }

    @Override
    public IExpr subtract(double value) {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().subtract(this.fApcomplex, (Apcomplex)new Apfloat(value)));
    }

    @Override
    public IExpr subtract(IExpr that) {
        if (that instanceof IComplexNum) {
            return ApcomplexNum.valueOf(EvalEngine.getApfloat().subtract(this.fApcomplex, ((IComplexNum)that).apcomplexValue()));
        }
        if (that instanceof INum) {
            return ApcomplexNum.valueOf(EvalEngine.getApfloat().subtract(this.fApcomplex, ((INum)that).apcomplexValue()));
        }
        return IComplexNum.super.subtract(that);
    }

    @Override
    public IExpr tan() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().tan(this.fApcomplex));
    }

    @Override
    public IExpr tanh() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().tanh(this.fApcomplex));
    }

    @Override
    public IExpr ulp() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().ulp((Apfloat)Apfloat.ONE));
    }

    @Override
    public IExpr getPi() {
        return ApcomplexNum.valueOf(EvalEngine.getApfloat().pi());
    }

    @Override
    public IExpr toDegrees() {
        FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
        return ApcomplexNum.valueOf(ApfloatNum.toDegrees(this.fApcomplex.real(), h), ApfloatNum.toDegrees(this.fApcomplex.imag(), h));
    }

    @Override
    public IExpr toRadians() {
        FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
        return ApcomplexNum.valueOf(ApfloatNum.toRadians(this.fApcomplex.real(), h), ApfloatNum.toRadians(this.fApcomplex.imag(), h));
    }
}

