/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import com.google.common.math.BigIntegerMath;
import edu.jas.arith.PrimeInteger;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntRBTreeMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.Externalizable;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.util.ArithmeticUtils;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.NumberTheory;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ASTElementLimitExceeded;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.exception.BigIntegerLimitExceeded;
import org.matheclipse.core.expression.AbstractAST;
import org.matheclipse.core.expression.AbstractFractionSym;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.BigIntegerSym;
import org.matheclipse.core.expression.ComplexSym;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IntegerSym;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.numbertheory.Primality;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;

public abstract class AbstractIntegerSym
implements IInteger,
Externalizable {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final BigInteger BI_MINUS_ONE = BigInteger.valueOf(-1L);
    public static final BigInteger BI_TWO = BigInteger.valueOf(2L);
    public static final BigInteger BI_THREE = BigInteger.valueOf(3L);
    public static final BigInteger BI_FOUR = BigInteger.valueOf(4L);
    public static final BigInteger BI_SEVEN = BigInteger.valueOf(7L);
    public static final BigInteger BI_EIGHT = BigInteger.valueOf(8L);

    @Override
    public IAST divisors() {
        if (this.isOne() || this.isMinusOne()) {
            return F.CListC1;
        }
        SortedSet<IInteger> set = this.divisorsSet();
        IASTAppendable resultList = F.ListAlloc(set.size() + 1);
        for (IInteger divisor : set) {
            resultList.append(divisor);
        }
        return resultList;
    }

    private SortedSet<IInteger> divisorsSet() throws ASTElementLimitExceeded {
        IASTAppendable factors = this.factorInteger();
        if (factors.size() == 1) {
            TreeSet<IInteger> treeSet = new TreeSet<IInteger>();
            treeSet.add(F.C1);
            return treeSet;
        }
        ArrayList<IInteger> primes = new ArrayList<IInteger>();
        IntArrayList maxPowers = new IntArrayList();
        for (int i = 1; i < factors.size(); ++i) {
            IExpr arg = factors.get(i);
            primes.add((IInteger)arg.first());
            maxPowers.add(arg.second().toIntDefault());
        }
        TreeSet<IInteger> divisors = new TreeSet<IInteger>();
        if (primes.size() == 0 || primes.size() == 1 && ((IInteger)primes.get(0)).equals(F.C0)) {
            return divisors;
        }
        Stack<IntArrayList> stack = new Stack<IntArrayList>();
        IntArrayList emptyPowers = new IntArrayList();
        for (int i = 0; i < maxPowers.size(); ++i) {
            emptyPowers.add(0);
        }
        stack.push(emptyPowers);
        while (!stack.isEmpty()) {
            int i;
            IntArrayList powers = (IntArrayList)stack.pop();
            IInteger divisor = F.C1;
            for (i = 0; i < powers.size(); ++i) {
                int power = powers.getInt(i);
                if (power <= 0) continue;
                divisor = divisor.multiply(((IInteger)primes.get(i)).powerRational(power));
            }
            if (!divisors.add(divisor)) continue;
            if (Config.MAX_AST_SIZE < divisors.size()) {
                ASTElementLimitExceeded.throwIt(divisors.size());
            }
            for (i = 0; i < maxPowers.size(); ++i) {
                int maxPower = maxPowers.getInt(i);
                int power = powers.getInt(i);
                if (power >= maxPower) continue;
                IntArrayList enhancedPowers = new IntArrayList((IntList)powers);
                enhancedPowers.set(i, power + 1);
                stack.push(enhancedPowers);
            }
        }
        return divisors;
    }

    public static BigInteger jacobiSymbol(BigInteger a, BigInteger b) {
        if (a.equals(BigInteger.ONE)) {
            return BigInteger.ONE;
        }
        if (a.equals(BigInteger.ZERO)) {
            return BigInteger.ZERO;
        }
        if (a.equals(BI_TWO)) {
            return BigIntegerSym.jacobiSymbolF(b);
        }
        if (!NumberUtil.isOdd(a)) {
            BigInteger aDIV2 = a.shiftRight(1);
            return AbstractIntegerSym.jacobiSymbol(aDIV2, b).multiply(AbstractIntegerSym.jacobiSymbol(BI_TWO, b));
        }
        return AbstractIntegerSym.jacobiSymbol(b.mod(a), a).multiply(BigIntegerSym.jacobiSymbolG(a, b));
    }

    public static long jacobiSymbol(long a, long b) {
        if (a == 1L) {
            return 1L;
        }
        if (a == 0L) {
            return 0L;
        }
        if (a == 2L) {
            return AbstractIntegerSym.jacobiSymbolF(b);
        }
        if ((a & 1L) != 1L) {
            long aDIV2 = a >> 1;
            return AbstractIntegerSym.jacobiSymbol(aDIV2, b) * AbstractIntegerSym.jacobiSymbol(2L, b);
        }
        return AbstractIntegerSym.jacobiSymbol(b % a, a) * AbstractIntegerSym.jacobiSymbolG(a, b);
    }

    public static long jacobiSymbolF(long val) {
        long a = val % 8L;
        if (a == 1L) {
            return 1L;
        }
        if (a == 7L) {
            return 1L;
        }
        return -1L;
    }

    public static long jacobiSymbolG(long a, long b) {
        long i1 = a % 4L;
        if (i1 == 1L) {
            return 1L;
        }
        long i2 = b % 4L;
        if (i2 == 1L) {
            return 1L;
        }
        return -1L;
    }

    public static BigInteger lcm(BigInteger i0, BigInteger i1) {
        if (i0.equals(BigInteger.ZERO) && i1.equals(BigInteger.ZERO)) {
            return BigInteger.ZERO;
        }
        BigInteger a = i0.abs();
        BigInteger b = i1.abs();
        BigInteger gcd = i0.gcd(b);
        BigInteger lcm = a.multiply(b).divide(gcd);
        return lcm;
    }

    public static IInteger valueOf(BigInteger bigInteger) {
        if (bigInteger.bitLength() <= 31) {
            return AbstractIntegerSym.valueOf(bigInteger.intValue());
        }
        return new BigIntegerSym(bigInteger);
    }

    public static IInteger valueOf(int newnum) {
        if (newnum == Integer.MIN_VALUE) {
            return new BigIntegerSym(newnum);
        }
        if (newnum == 1000) {
            return F.C1000;
        }
        return newnum >= -128 && newnum <= 128 ? IntegerSym.CACHE[newnum + 128] : new IntegerSym(newnum);
    }

    public static IInteger valueOf(long newnum) {
        if (Integer.MIN_VALUE < newnum && newnum <= Integer.MAX_VALUE) {
            return AbstractIntegerSym.valueOf((int)newnum);
        }
        BigIntegerSym z = new BigIntegerSym(newnum);
        return z;
    }

    public static IInteger valueOf(String integerString, int radix) {
        int length = integerString.length();
        if (radix == 10) {
            char ch;
            if (length == 1) {
                ch = integerString.charAt(0);
                switch (ch) {
                    case '0': {
                        return F.C0;
                    }
                    case '1': {
                        return F.C1;
                    }
                    case '2': {
                        return F.C2;
                    }
                    case '3': {
                        return F.C3;
                    }
                    case '4': {
                        return F.C4;
                    }
                    case '5': {
                        return F.C5;
                    }
                    case '6': {
                        return F.C6;
                    }
                    case '7': {
                        return F.C7;
                    }
                    case '8': {
                        return F.C8;
                    }
                    case '9': {
                        return F.C9;
                    }
                }
            } else if (length == 2 && integerString.charAt(0) == '-') {
                ch = integerString.charAt(1);
                switch (ch) {
                    case '0': {
                        return F.C0;
                    }
                    case '1': {
                        return F.CN1;
                    }
                    case '2': {
                        return F.CN2;
                    }
                    case '3': {
                        return F.CN3;
                    }
                    case '4': {
                        return F.CN4;
                    }
                    case '5': {
                        return F.CN5;
                    }
                    case '6': {
                        return F.CN6;
                    }
                    case '7': {
                        return F.CN7;
                    }
                    case '8': {
                        return F.CN8;
                    }
                    case '9': {
                        return F.CN9;
                    }
                }
            }
        }
        try {
            int newnum = Integer.parseInt(integerString, radix);
            return AbstractIntegerSym.valueOf(newnum);
        }
        catch (NumberFormatException numberFormatException) {
            return new BigIntegerSym(new BigInteger(integerString, radix));
        }
    }

    public static IInteger valueOfUniqueReference(int newnum) {
        if (newnum == Integer.MIN_VALUE) {
            return new BigIntegerSym(newnum);
        }
        return new IntegerSym(newnum);
    }

    @Override
    public IExpr accept(IVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return visitor.visit(this);
    }

    @Override
    public ApcomplexNum apcomplexNumValue() {
        return ApcomplexNum.valueOf(this.apcomplexValue());
    }

    @Override
    public Apcomplex apcomplexValue() {
        return new Apcomplex(new Apfloat(this.toBigNumerator(), EvalEngine.getApfloat().precision()));
    }

    @Override
    public ApfloatNum apfloatNumValue() {
        return ApfloatNum.valueOf(this.toBigNumerator());
    }

    @Override
    public Apfloat apfloatValue() {
        return new Apfloat(this.toBigNumerator(), EvalEngine.getApfloat().precision());
    }

    @Override
    public IInteger ceil() {
        return this;
    }

    @Override
    public IInteger ceilFraction() {
        return this;
    }

    @Override
    public IInteger charmichaelLambda() {
        return AbstractIntegerSym.valueOf(Primality.charmichaelLambda(this.toBigNumerator()));
    }

    @Override
    public int compareTo(IExpr expr) {
        int c;
        if (expr.isNumber() && (c = this.compareTo(((INumber)expr).re())) != 0) {
            return c;
        }
        return -1;
    }

    public IExpr copy() {
        try {
            return (IExpr)this.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("AbstractIntegerSym.copy() failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public IRational divideBy(IRational that) {
        return AbstractFractionSym.valueOf(this).divideBy(that);
    }

    @Override
    public IExpr[] egcd(IExpr that) {
        if (that instanceof IInteger) {
            BigInteger S2 = ((IInteger)that).toBigNumerator();
            IExpr[] result = new IInteger[]{null, F.C1, F.C1};
            if (that.isZero()) {
                result[0] = this;
                return result;
            }
            if (this.isZero()) {
                result[0] = (BigIntegerSym)that;
                return result;
            }
            BigInteger q = this.toBigNumerator();
            BigInteger r = S2;
            BigInteger c1 = BigInteger.ONE;
            BigInteger d1 = BigInteger.ZERO;
            BigInteger c2 = BigInteger.ZERO;
            BigInteger d2 = BigInteger.ONE;
            while (!r.equals(BigInteger.ZERO)) {
                BigInteger[] qr = q.divideAndRemainder(r);
                q = qr[0];
                BigInteger x1 = c1.subtract(q.multiply(d1));
                BigInteger x2 = c2.subtract(q.multiply(d2));
                c1 = d1;
                c2 = d2;
                d1 = x1;
                d2 = x2;
                q = r;
                r = qr[1];
            }
            if (q.signum() < 0) {
                q = q.negate();
                c1 = c1.negate();
                c2 = c2.negate();
            }
            result[0] = AbstractIntegerSym.valueOf(q);
            result[1] = AbstractIntegerSym.valueOf(c1);
            result[2] = AbstractIntegerSym.valueOf(c2);
            return result;
        }
        return IInteger.super.egcd(that);
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        if (engine.isNumericMode()) {
            return this.numericNumber();
        }
        return F.NIL;
    }

    @Override
    public IInteger eulerPhi() throws ArithmeticException {
        return AbstractIntegerSym.valueOf(Primality.eulerPhi(this.toBigNumerator()));
    }

    @Override
    public IASTAppendable factorInteger() {
        IInteger last = F.CN2;
        int count = 0;
        IAST iFactors = this.factorize();
        IASTAppendable subList = null;
        int size = iFactors.size();
        IASTAppendable list = F.ListAlloc(size);
        for (int i = 1; i < size; ++i) {
            IInteger factor = (IInteger)iFactors.get(i);
            if (!last.equals(factor)) {
                if (subList != null) {
                    subList.append(AbstractIntegerSym.valueOf(count));
                    list.append(subList);
                }
                count = 0;
                subList = F.ListAlloc(2);
                subList.append(factor);
            }
            ++count;
            last = factor;
        }
        if (subList != null) {
            subList.append(AbstractIntegerSym.valueOf(count));
            list.append(subList);
        }
        return list;
    }

    public IAST factorize() {
        return Config.PRIME_FACTORS.factorIInteger(this);
    }

    @Override
    public IAST factorSmallPrimes(int numerator, int root) {
        Int2IntRBTreeMap map = new Int2IntRBTreeMap();
        IInteger b = this;
        boolean isNegative = false;
        if (this.complexSign() < 0) {
            b = b.negate();
            isNegative = true;
        }
        if (numerator != 1) {
            b = b.powerRational(numerator);
        }
        if (b.isLT(F.C8)) {
            return F.NIL;
        }
        BigInteger number = b.toBigNumerator();
        return AbstractIntegerSym.factorBigInteger(number, isNegative, numerator, root, (Int2IntMap)map);
    }

    protected static IAST factorBigInteger(BigInteger number, boolean isNegative, int numerator, int denominator, Int2IntMap map) {
        IInteger[] sr;
        if (number.compareTo(BigInteger.valueOf(7L)) <= 0) {
            return F.NIL;
        }
        if (number.bitLength() > Config.MAX_BIT_LENGTH / 100) {
            BigIntegerLimitExceeded.throwIt(number.bitLength());
        }
        BigInteger rest = Primality.countPrimes32749(number, map);
        if (map.size() == 0) {
            return F.NIL;
        }
        IASTAppendable result = F.TimesAlloc(map.size() + 4);
        boolean evaled = false;
        for (Int2IntMap.Entry entry : map.int2IntEntrySet()) {
            int key = entry.getIntKey();
            int value = entry.getIntValue();
            int mod = value % denominator;
            int div = value / denominator;
            if (div != 0) {
                result.append(F.Power((IExpr)AbstractIntegerSym.valueOf(key), F.ZZ(div)));
                if (mod != 0) {
                    result.append(F.Power((IExpr)AbstractIntegerSym.valueOf(key), F.QQ(mod, denominator)));
                }
                evaled = true;
                continue;
            }
            result.append(F.Power((IExpr)F.Power((IExpr)AbstractIntegerSym.valueOf(key), AbstractIntegerSym.valueOf(value)), F.QQ(1L, denominator)));
        }
        if (denominator == 2 && numerator == 1 && rest.compareTo(BigInteger.valueOf(32747L)) > 0 && (sr = F.ZZ(rest).sqrtAndRemainder()) != null && sr[1].isZero()) {
            result.append(sr[0]);
            rest = BigInteger.ONE;
            evaled = true;
        }
        if (evaled) {
            if (!rest.equals(BigInteger.ONE)) {
                result.append(F.Power((IExpr)AbstractIntegerSym.valueOf(rest), F.QQ(1L, denominator)));
            }
            if (isNegative) {
                result.append(F.Power((IExpr)F.CN1, F.QQ(numerator, denominator)));
            }
            return result;
        }
        return F.NIL;
    }

    public static IAST factorizeLong(long value) {
        int allocSize = 0;
        long longValue = value;
        if (longValue < 0L) {
            allocSize = 1;
            longValue = -longValue;
        }
        SortedMap map = PrimeInteger.factors((long)longValue);
        for (Map.Entry entry : map.entrySet()) {
            allocSize += ((Integer)entry.getValue()).intValue();
        }
        IASTAppendable result = F.ListAlloc(allocSize);
        if (value < 0L) {
            result.append(F.CN1);
        }
        for (Map.Entry entry : map.entrySet()) {
            long key = (Long)entry.getKey();
            IInteger is = AbstractIntegerSym.valueOf(key);
            for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                result.append(is);
            }
        }
        return result;
    }

    @Override
    public IRational fractionalPart() {
        return F.C0;
    }

    @Override
    public IInteger integerPart() {
        return this;
    }

    @Override
    public IInteger floor() {
        return this;
    }

    @Override
    public IInteger floorFraction() {
        return this;
    }

    @Override
    public IInteger factorial() {
        int ni = this.toIntDefault();
        if (ni > Integer.MIN_VALUE) {
            return NumberTheory.factorial(ni);
        }
        throw new ArgumentTypeException("intm", F.list(F.Factorial(this), F.C1));
    }

    @Override
    public IInteger[] gaussianIntegers() {
        return new IInteger[]{this, F.C0};
    }

    @Override
    public IExpr gcd(IExpr that) {
        if (that instanceof IInteger) {
            return this.gcd((IInteger)that);
        }
        if (that instanceof IFraction) {
            ((IFraction)that).gcd(F.fraction(this.toBigNumerator(), BigInteger.ONE));
        }
        return F.C1;
    }

    @Override
    public double imDoubleValue() {
        return 0.0;
    }

    @Override
    public double reDoubleValue() {
        return this.doubleValue();
    }

    @Override
    public IRational roundClosest(ISignedNumber multiple) {
        if (!multiple.isRational()) {
            multiple = F.fraction(multiple.doubleValue(), Config.DOUBLE_EPSILON);
        }
        IInteger ii = this.divideBy((IRational)multiple).roundExpr();
        return ii.multiply((IRational)multiple);
    }

    @Override
    public IInteger[] sqrtAndRemainder() {
        if (this.complexSign() > 0) {
            BigInteger bignum = this.toBigNumerator();
            BigInteger s = BigIntegerMath.sqrt((BigInteger)bignum, (RoundingMode)RoundingMode.FLOOR);
            BigInteger r = bignum.subtract(s.multiply(s));
            return new IInteger[]{AbstractIntegerSym.valueOf(s), AbstractIntegerSym.valueOf(r)};
        }
        return null;
    }

    @Override
    public ISymbol head() {
        return S.Integer;
    }

    @Override
    public int hierarchy() {
        return 8;
    }

    @Override
    public CharSequence internalFormString(boolean symbolsAsFactoryMethod, int depth) {
        IExpr.SourceCodeProperties p = AbstractAST.stringFormProperties(symbolsAsFactoryMethod);
        return this.internalJavaString(p, depth, x -> null);
    }

    @Override
    public abstract IRational inverse();

    @Override
    public boolean isNumEqualInteger(IInteger value) throws ArithmeticException {
        return this.equals(value);
    }

    @Override
    public boolean isNumEqualRational(IRational value) throws ArithmeticException {
        return this.equals(value);
    }

    @Override
    public boolean isNumIntValue() {
        return true;
    }

    @Override
    public IInteger jacobiSymbol(IInteger b) {
        if (this.isOne()) {
            return F.C1;
        }
        if (this.isZero()) {
            return F.C0;
        }
        if (this.equals(F.C2)) {
            return b.jacobiSymbolF();
        }
        if (!this.isOdd()) {
            IInteger aDIV2 = this.shiftRight(1);
            return aDIV2.jacobiSymbol(b).multiply(F.C2.jacobiSymbol(b));
        }
        return b.mod(this).jacobiSymbol(this).multiply(this.jacobiSymbolG(b));
    }

    @Override
    public IInteger jacobiSymbolF() {
        IInteger a = this.mod(F.C8);
        if (a.isOne()) {
            return F.C1;
        }
        if (a.equals(F.C7)) {
            return F.C1;
        }
        return F.CN1;
    }

    @Override
    public IInteger jacobiSymbolG(IInteger b) {
        IInteger i1 = this.mod(F.C4);
        if (i1.isOne()) {
            return F.C1;
        }
        IInteger i2 = b.mod(F.C4);
        if (i2.isOne()) {
            return F.C1;
        }
        return F.CN1;
    }

    @Override
    public long leafCountSimplify() {
        if (this.isZero()) {
            return 1L;
        }
        return this.integerLength(F.C10) + (long)(this.isPositive() ? 0 : 1);
    }

    @Override
    public IInteger lcm(IInteger that) {
        if (this.isZero() || that.isZero()) {
            return F.C0;
        }
        if (this.equals(that)) {
            return this.abs();
        }
        if (this.isOne()) {
            return that.abs();
        }
        if (that.isOne()) {
            return this.abs();
        }
        IInteger a = this.abs();
        IInteger b = that.abs();
        IInteger gcd = a.gcd(b);
        IInteger lcm = a.multiply(b).div(gcd);
        return lcm;
    }

    @Override
    public IInteger moebiusMu() {
        return AbstractIntegerSym.valueOf(Primality.moebiusMu(this.toBigNumerator()));
    }

    public BigInteger multiply(long val) {
        return this.toBigNumerator().multiply(BigInteger.valueOf(val));
    }

    @Override
    public abstract IInteger negate();

    @Override
    public IInteger[] nthRootSplit(int n) throws ArithmeticException {
        IInteger[] result = new IInteger[2];
        if (this.complexSign() == 0) {
            result[0] = F.C0;
            result[1] = F.C1;
            return result;
        }
        if (this.complexSign() < 0) {
            if (n % 2 == 0) {
                throw new ArithmeticException();
            }
            result = this.negate().nthRootSplit(n);
            result[1] = result[1].negate();
            return result;
        }
        AbstractIntegerSym b = this;
        BigInteger[] nthRoot = Primality.countRoot1021(b.toBigNumerator(), n);
        result[0] = AbstractIntegerSym.valueOf(nthRoot[0]);
        result[1] = AbstractIntegerSym.valueOf(nthRoot[1]);
        return result;
    }

    @Override
    public IInteger opposite() {
        return this.negate();
    }

    @Override
    public IExpr plus(IExpr that) {
        if (this.isZero()) {
            return that;
        }
        if (that instanceof IInteger) {
            return this.add((IInteger)that);
        }
        if (that instanceof IFraction) {
            return AbstractFractionSym.valueOf(this).add((IFraction)that);
        }
        if (that instanceof ComplexSym) {
            return ((ComplexSym)that).add(ComplexSym.valueOf(this)).normalize();
        }
        return IInteger.super.plus(that);
    }

    @Override
    public IExpr power(IExpr that) {
        if (that instanceof IInteger) {
            if (that.isZero()) {
                if (!this.isZero()) {
                    return F.C1;
                }
                return IInteger.super.power(that);
            }
            if (that.isOne()) {
                return this;
            }
            if (that.isMinusOne()) {
                return this.inverse();
            }
            long n = ((IInteger)that).toLongDefault();
            if (n != Long.MIN_VALUE) {
                return this.power(n);
            }
        }
        return IInteger.super.power(that);
    }

    @Override
    public final IInteger powerRational(long exponent) throws ArithmeticException {
        IInteger r;
        if (exponent < 0L) {
            throw new ArithmeticException("Negative exponent");
        }
        if (exponent == 0L) {
            if (!this.isZero()) {
                return F.C1;
            }
            throw new ArithmeticException("Indeterminate: 0^0");
        }
        if (exponent == 1L) {
            return this;
        }
        if (this.isOne()) {
            return F.C1;
        }
        if (this.isMinusOne()) {
            if ((exponent & 1L) == 1L) {
                return F.CN1;
            }
            return F.C1;
        }
        if (this instanceof IntegerSym && exponent < 63L) {
            try {
                return AbstractIntegerSym.valueOf(ArithmeticUtils.pow((long)((IntegerSym)this).fIntValue, (int)((int)exponent)));
            }
            catch (MathRuntimeException mathRuntimeException) {
                // empty catch block
            }
        }
        long exp = exponent;
        long b2pow = 0L;
        while ((exp & 1L) == 0L) {
            ++b2pow;
            exp >>= 1;
        }
        IInteger x = r = this;
        while ((exp >>= 1) > 0L) {
            x = x.multiply(x);
            if ((exp & 1L) == 0L) continue;
            r.checkBitLength();
            r = r.multiply(x);
        }
        while (b2pow-- > 0L) {
            r.checkBitLength();
            r = r.multiply(r);
        }
        return r;
    }

    @Override
    public void checkBitLength() {
        long bitLength = this.bitLength();
        if (bitLength > (long)Config.MAX_BIT_LENGTH) {
            BigIntegerLimitExceeded.throwIt(bitLength);
        }
    }

    @Override
    public IInteger[] primitiveRootList() throws ArithmeticException {
        IInteger phi = this.eulerPhi();
        int size = phi.eulerPhi().toIntDefault();
        if (size <= 0) {
            return null;
        }
        if (this.isEven() && !this.equals(F.C2) && !this.equals(F.C4) && this.quotient(F.C2).isEven()) {
            return new IInteger[0];
        }
        IASTAppendable ast = phi.factorInteger();
        IInteger[] d = new IInteger[ast.argSize()];
        for (int i = 1; i < ast.size(); ++i) {
            IAST element = (IAST)ast.get(i);
            IInteger q = (IInteger)element.arg1();
            d[i - 1] = phi.quotient(q);
        }
        int k = 0;
        AbstractIntegerSym n = this;
        IInteger m = F.C1;
        if (Config.MAX_AST_SIZE < size) {
            throw new ASTElementLimitExceeded(size);
        }
        IInteger[] resultArray = new IInteger[size];
        while (m.compareTo(n) < 0) {
            boolean b = m.gcd(n).isOne();
            for (int i = 0; i < d.length; ++i) {
                b = b && m.modPow(d[i], n).isGT(F.C1);
            }
            if (b) {
                resultArray[k++] = m;
            }
            m = m.add(F.C1);
        }
        if (resultArray[0] == null) {
            return new IInteger[0];
        }
        return resultArray;
    }

    @Override
    public IInteger quotient(IInteger that) {
        BigInteger quotient = this.toBigNumerator().divide(that.toBigNumerator());
        BigInteger mod = this.toBigNumerator().remainder(that.toBigNumerator());
        if (mod.equals(BigInteger.ZERO)) {
            return AbstractIntegerSym.valueOf(quotient);
        }
        if (quotient.compareTo(BigInteger.ZERO) < 0) {
            return AbstractIntegerSym.valueOf(quotient.subtract(BigInteger.ONE));
        }
        return AbstractIntegerSym.valueOf(quotient);
    }

    @Override
    public IRational subtract(IRational that) {
        if (this.isZero()) {
            return that.negate();
        }
        return this.add(that.negate());
    }

    @Override
    public ISignedNumber subtractFrom(ISignedNumber that) {
        if (that instanceof IRational) {
            return this.add((IRational)that.negate());
        }
        return Num.valueOf(this.doubleValue() - that.doubleValue());
    }

    @Override
    public IExpr times(IExpr that) {
        if (this.isZero()) {
            return F.C0;
        }
        if (this.isOne()) {
            return that;
        }
        if (that instanceof IInteger) {
            return this.multiply((IInteger)that);
        }
        if (that instanceof IFraction) {
            return AbstractFractionSym.valueOf(this).mul((IFraction)that).normalize();
        }
        if (that instanceof ComplexSym) {
            return ((ComplexSym)that).multiply(ComplexSym.valueOf(this)).normalize();
        }
        return IInteger.super.times(that);
    }

    @Override
    public byte[] toByteArray() {
        return this.toBigNumerator().toByteArray();
    }
}

