/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntRBTreeMap;
import java.math.BigInteger;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.DoubleFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.apfloat.FixedPrecisionApfloatHelper;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.fraction.BigFraction;
import org.hipparchus.util.ArithmeticUtils;
import org.hipparchus.util.FastMath;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalAttributes;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.exception.BigIntegerLimitExceeded;
import org.matheclipse.core.expression.AbstractIntegerSym;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.BigFractionSym;
import org.matheclipse.core.expression.BigIntegerSym;
import org.matheclipse.core.expression.ComplexSym;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.FractionSym;
import org.matheclipse.core.expression.IntegerSym;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;

public abstract class AbstractFractionSym
implements IFraction {
    private static final long serialVersionUID = -8743141041586314213L;
    private static final long RATIONALIZATION_OVERFLOW = Integer.MAX_VALUE;
    private static final Logger LOGGER = LogManager.getLogger();

    private static BigFraction converge(double value, int maxIterations, ConvergencePredicate convergence) {
        long p0 = 0L;
        long q0 = 1L;
        long p1 = 1L;
        long q1 = 0L;
        double r1 = value;
        for (int i = 0; i < maxIterations; ++i) {
            long q2;
            long a1 = (long)FastMath.floor((double)r1);
            long p2 = a1 * p1 + p0;
            if (convergence.test(p2, q2 = a1 * q1 + q0)) {
                return new BigFraction(p2, q2);
            }
            if (p2 > Integer.MAX_VALUE || q2 > Integer.MAX_VALUE) {
                throw new MathIllegalStateException((Localizable)LocalizedCoreFormats.FRACTION_CONVERSION_OVERFLOW, new Object[]{value, p2, q2});
            }
            p0 = p1;
            q0 = q1;
            p1 = p2;
            q1 = q2;
            r1 = 1.0 / (r1 - (double)a1);
        }
        return null;
    }

    public static BigInteger gcd(BigInteger i1, BigInteger i2) {
        if (i1.equals(BigInteger.ONE) || i2.equals(BigInteger.ONE)) {
            return BigInteger.ONE;
        }
        if (NumberUtil.hasIntValue(i1) && NumberUtil.hasIntValue(i2)) {
            return BigInteger.valueOf(ArithmeticUtils.gcd((int)i1.intValue(), (int)i2.intValue()));
        }
        if (NumberUtil.hasLongValue(i1) && NumberUtil.hasLongValue(i2)) {
            return BigInteger.valueOf(ArithmeticUtils.gcd((long)i1.longValue(), (long)i2.longValue()));
        }
        return i1.gcd(i2);
    }

    public static IFraction valueOf(BigFraction fraction) {
        IFraction f = AbstractFractionSym.fractionOf(fraction.getNumerator(), fraction.getDenominator());
        return f != null ? f : new BigFractionSym(fraction);
    }

    public static IFraction valueOf(BigInteger numerator, BigInteger denominator) {
        IFraction f = AbstractFractionSym.fractionOf(numerator, denominator);
        return f != null ? f : new BigFractionSym(numerator, denominator);
    }

    private static IFraction fractionOf(BigInteger numerator, BigInteger denominator) {
        if (BigInteger.ZERO.equals(denominator)) {
            throw AbstractFractionSym.getDivisionTroughZeroException(F.ZZ(numerator));
        }
        if (NumberUtil.hasIntValue(denominator) && NumberUtil.hasIntValue(numerator)) {
            return AbstractFractionSym.valueOf(numerator.intValue(), denominator.intValue());
        }
        return null;
    }

    public static IFraction valueOf(IInteger numerator, IInteger denominator) {
        if (numerator instanceof IntegerSym && denominator instanceof IntegerSym) {
            return AbstractFractionSym.valueOf(((IntegerSym)numerator).fIntValue, ((IntegerSym)denominator).fIntValue);
        }
        return AbstractFractionSym.valueOf(numerator.toBigNumerator(), denominator.toBigNumerator());
    }

    public static IFraction valueOf(long numerator, long denominator) {
        if (denominator == 0L) {
            throw AbstractFractionSym.getDivisionTroughZeroException(F.ZZ(numerator));
        }
        if (numerator == 0L) {
            return FractionSym.ZERO;
        }
        if (numerator == denominator) {
            return FractionSym.ONE;
        }
        if (numerator > Long.MIN_VALUE && denominator > Long.MIN_VALUE) {
            if (numerator != 1L && denominator != 1L) {
                long gcd = Math.abs(ArithmeticUtils.gcd((long)numerator, (long)denominator));
                if (denominator < 0L) {
                    gcd = -gcd;
                }
                numerator /= gcd;
                denominator /= gcd;
            }
            if (denominator == 1L) {
                if (numerator == 1L) {
                    return FractionSym.ONE;
                }
                if (numerator == -1L) {
                    return FractionSym.MONE;
                }
                if (numerator == 0L) {
                    return FractionSym.ZERO;
                }
            }
            if (Integer.MIN_VALUE < numerator && numerator <= Integer.MAX_VALUE && denominator <= Integer.MAX_VALUE) {
                return new FractionSym((int)numerator, (int)denominator);
            }
        }
        return new BigFractionSym(BigInteger.valueOf(numerator), BigInteger.valueOf(denominator));
    }

    private static ArgumentTypeException getDivisionTroughZeroException(IInteger num) {
        String str = IOFunctions.getMessage("infy", F.list(F.Rational(num, F.C0)), EvalEngine.get());
        return new ArgumentTypeException(str);
    }

    public static IFraction valueOf(IInteger numerator) {
        if (numerator instanceof IntegerSym) {
            return AbstractFractionSym.valueOf(((IntegerSym)numerator).fIntValue);
        }
        return AbstractFractionSym.valueOf(numerator.toBigNumerator());
    }

    public static IFraction valueOf(BigInteger numerator) {
        return AbstractFractionSym.valueOf(numerator, BigInteger.ONE);
    }

    public static IFraction valueOf(long numerator) {
        if (numerator == 0L) {
            return FractionSym.ZERO;
        }
        if (numerator == 1L) {
            return FractionSym.ONE;
        }
        if (numerator == -1L) {
            return FractionSym.MONE;
        }
        if (Integer.MIN_VALUE < numerator && numerator <= Integer.MAX_VALUE) {
            return new FractionSym((int)numerator, 1);
        }
        return new BigFractionSym(BigInteger.valueOf(numerator), BigInteger.ONE);
    }

    public static IFraction valueOfEpsilon(double value, double epsilon) {
        return AbstractFractionSym.rationalize(value, v -> new BigFraction(v, epsilon, 200));
    }

    public static IFraction valueOfConvergent(double value) {
        IFraction fraction = AbstractFractionSym.convergeFraction(value, 20, 5.0E-5);
        if (fraction == null) {
            throw new NoSuchElementException("No converging fraction found for value " + value);
        }
        return fraction;
    }

    private static IFraction convergeFraction(double value, int maxIterations, double lhs) {
        return AbstractFractionSym.rationalize(value, v -> AbstractFractionSym.converge(v, maxIterations, (p, q) -> FastMath.abs((double)((double)(p * q) - v * (double)q * (double)q)) <= lhs));
    }

    private static IFraction rationalize(double value, DoubleFunction<BigFraction> f) {
        try {
            BigFraction fraction = f.apply(value < 0.0 ? -value : value);
            if (fraction == null) {
                return null;
            }
            return AbstractFractionSym.valueOf(value < 0.0 ? fraction.negate() : fraction);
        }
        catch (MathIllegalStateException e) {
            return AbstractFractionSym.valueOf(new BigFraction(value));
        }
    }

    public static IExpr valueOfExact(double value) {
        IExpr ii = AbstractFractionSym.getInfiniteOrInteger(value);
        if (ii != null) {
            return ii;
        }
        BigFraction exactFraction = new BigFraction(value);
        int denominatorExponent2 = exactFraction.getDenominator().bitLength() - 1;
        if (denominatorExponent2 <= 1023) {
            return AbstractFractionSym.valueOf(exactFraction);
        }
        int exp2 = Math.getExponent(value);
        double mantissa2 = value * Math.pow(2.0, -exp2);
        IExpr mantissaFraction = AbstractFractionSym.getInfiniteOrInteger(mantissa2);
        if (mantissaFraction == null) {
            mantissaFraction = AbstractFractionSym.valueOf(new BigFraction(mantissa2));
        }
        return F.Times(mantissaFraction, (IExpr)F.Power((IExpr)F.C2, F.ZZ(exp2)));
    }

    private static IExpr getInfiniteOrInteger(double value) {
        if (Double.isNaN(value)) {
            return F.NIL;
        }
        if (value == Double.POSITIVE_INFINITY) {
            return F.CInfinity;
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return F.CNInfinity;
        }
        long integerValue = (long)value;
        if (value == (double)integerValue) {
            return F.ZZ(integerValue);
        }
        return null;
    }

    public static IExpr valueOfExactNice(double value) {
        IFraction fraction;
        IExpr ii = AbstractFractionSym.getInfiniteOrInteger(value);
        if (ii != null) {
            return ii;
        }
        if (FastMath.abs((int)Math.getExponent(value)) < 100 && (fraction = AbstractFractionSym.convergeFraction(value, 5, 0.0)) != null && value == fraction.doubleValue()) {
            return fraction;
        }
        return AbstractFractionSym.valueOfExact(value);
    }

    @Override
    public IExpr accept(IVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return visitor.visit(this);
    }

    public IFraction addmul(IFraction fac1, IFraction fac2) {
        return this.add(fac1.mul(fac2));
    }

    @Override
    public ApcomplexNum apcomplexNumValue() {
        return ApcomplexNum.valueOf(this.apcomplexValue());
    }

    @Override
    public Apcomplex apcomplexValue() {
        FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
        Apfloat real = h.divide(new Apfloat(this.toBigNumerator(), h.precision()), new Apfloat(this.toBigDenominator(), h.precision()));
        return new Apcomplex(real);
    }

    @Override
    public ApfloatNum apfloatNumValue() {
        return ApfloatNum.valueOf(this.toBigNumerator(), this.toBigDenominator());
    }

    @Override
    public Apfloat apfloatValue() {
        long precision = EvalEngine.getApfloat().precision();
        Apfloat n = new Apfloat(this.toBigNumerator(), precision);
        Apfloat d = new Apfloat(this.toBigDenominator(), precision);
        return n.divide(d);
    }

    @Override
    public int compareTo(IExpr expr) {
        int c;
        if (expr.isNumber() && (c = this.compareTo(((INumber)expr).re())) != 0) {
            return c;
        }
        return -1;
    }

    public IExpr copy() {
        try {
            return (IExpr)this.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("AbstractFractionSym.copy() failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public IRational divideBy(IRational that) {
        if (that instanceof IFraction) {
            return this.div((IFraction)that);
        }
        if (that instanceof IntegerSym) {
            return this.div(AbstractFractionSym.valueOf(((IntegerSym)that).fIntValue));
        }
        return this.div(AbstractFractionSym.valueOf(((BigIntegerSym)that).fBigIntValue));
    }

    @Override
    public ISignedNumber divideBy(ISignedNumber that) {
        if (that instanceof IRational) {
            return this.divideBy((IRational)that);
        }
        return Num.valueOf(this.doubleValue() / that.doubleValue());
    }

    @Override
    public boolean equalsInt(int i) {
        return this.toBigNumerator().equals(BigInteger.valueOf(i)) && this.toBigDenominator().equals(BigInteger.ONE);
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        if (engine.isNumericMode()) {
            return this.numericNumber();
        }
        IRational cTemp = this.normalize();
        return cTemp == this ? F.NIL : cTemp;
    }

    @Override
    public IASTAppendable factorInteger() {
        IInteger num = this.numerator();
        IInteger den = this.denominator();
        IASTAppendable result = den.factorInteger();
        result.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)list -> ((IASTMutable)list).set(2, list.second().negate())));
        result.appendArgs(num.factorInteger());
        EvalAttributes.sort(result);
        return result;
    }

    @Override
    public IAST factorSmallPrimes(int numerator, int root) {
        IInteger b = this.numerator();
        boolean isNegative = false;
        if (this.complexSign() < 0) {
            b = b.negate();
            isNegative = true;
        }
        if (numerator != 1) {
            b = b.powerRational(numerator);
        }
        IInteger d = this.denominator();
        if (numerator != 1) {
            d = d.powerRational(numerator);
        }
        Int2IntRBTreeMap bMap = new Int2IntRBTreeMap();
        BigInteger number = b.toBigNumerator();
        IAST bAST = AbstractIntegerSym.factorBigInteger(number, isNegative, numerator, root, (Int2IntMap)bMap);
        Int2IntRBTreeMap dMap = new Int2IntRBTreeMap();
        number = d.toBigNumerator();
        IAST dAST = AbstractIntegerSym.factorBigInteger(number, false, numerator, root, (Int2IntMap)dMap);
        if (bAST.isPresent()) {
            if (dAST.isPresent()) {
                return F.Times((IExpr)bAST, (IExpr)F.Power((IExpr)dAST, F.CN1));
            }
            return F.Times((IExpr)bAST, (IExpr)F.Power((IExpr)this.denominator(), F.QQ(-numerator, root)));
        }
        if (dAST.isPresent()) {
            return F.Times((IExpr)F.Power((IExpr)this.numerator(), F.QQ(numerator, root)), (IExpr)F.Power((IExpr)dAST, F.CN1));
        }
        return F.NIL;
    }

    @Override
    public IInteger integerPart() {
        return this.isNegative() ? this.ceilFraction() : this.floorFraction();
    }

    @Override
    public IInteger denominator() {
        return AbstractIntegerSym.valueOf(this.toBigDenominator());
    }

    @Override
    public ISignedNumber im() {
        return F.C0;
    }

    @Override
    public double imDoubleValue() {
        return 0.0;
    }

    @Override
    public IInteger numerator() {
        return AbstractIntegerSym.valueOf(this.toBigNumerator());
    }

    @Override
    public ISignedNumber re() {
        return this;
    }

    @Override
    public double reDoubleValue() {
        return this.doubleValue();
    }

    @Override
    public IRational roundClosest(ISignedNumber multiple) {
        if (!multiple.isRational()) {
            multiple = F.fraction(multiple.doubleValue(), Config.DOUBLE_EPSILON);
        }
        IInteger ii = this.divideBy((IRational)multiple).roundExpr();
        return ii.multiply((IRational)multiple);
    }

    @Override
    public ISymbol head() {
        return S.Rational;
    }

    @Override
    public int hierarchy() {
        return 16;
    }

    @Override
    public boolean isGT(ISignedNumber obj) {
        if (obj instanceof FractionSym) {
            return this.compareTo(obj) > 0;
        }
        if (obj instanceof IInteger) {
            return this.compareTo(AbstractFractionSym.valueOf(((IInteger)obj).toBigNumerator(), BigInteger.ONE)) > 0;
        }
        return this.doubleValue() > obj.doubleValue();
    }

    public abstract boolean isIntegral();

    @Override
    public boolean isLT(ISignedNumber obj) {
        if (obj instanceof FractionSym) {
            return this.compareTo(obj) < 0;
        }
        if (obj instanceof IInteger) {
            return this.compareTo(AbstractFractionSym.valueOf(((IInteger)obj).toBigNumerator(), BigInteger.ONE)) < 0;
        }
        return this.doubleValue() < obj.doubleValue();
    }

    @Override
    public boolean isNumEqualRational(IRational value) throws ArithmeticException {
        return this.equals(value);
    }

    @Override
    public boolean isRationalValue(IRational value) {
        return this.equals(value);
    }

    @Override
    public long leafCountSimplify() {
        return 1L + this.numerator().leafCountSimplify() + this.denominator().leafCountSimplify();
    }

    @Override
    public long leafCount() {
        return 3L;
    }

    @Override
    public IFraction mul(IFraction other) {
        if (other.isOne()) {
            return this;
        }
        if (other.isZero()) {
            return other;
        }
        if (other.isMinusOne()) {
            return this.negate();
        }
        BigInteger newnum = this.toBigNumerator().multiply(other.toBigNumerator());
        BigInteger newdenom = this.toBigDenominator().multiply(other.toBigDenominator());
        return AbstractFractionSym.valueOf(newnum, newdenom);
    }

    @Override
    public INumber numericNumber() {
        return F.num(this);
    }

    @Override
    public Num numValue() {
        return Num.valueOf(this.doubleValue());
    }

    @Override
    public ISignedNumber opposite() {
        return this.negate();
    }

    @Override
    public IExpr plus(IExpr that) {
        if (that instanceof IFraction) {
            return this.add((IFraction)that).normalize();
        }
        if (that instanceof IntegerSym) {
            return this.add(AbstractFractionSym.valueOf(((IntegerSym)that).fIntValue)).normalize();
        }
        if (that instanceof BigIntegerSym) {
            return this.add(AbstractFractionSym.valueOf(((BigIntegerSym)that).fBigIntValue)).normalize();
        }
        if (that instanceof ComplexSym) {
            return ((ComplexSym)that).add(ComplexSym.valueOf(this)).normalize();
        }
        return IFraction.super.plus(that);
    }

    @Override
    public IExpr power(IExpr that) {
        if (that instanceof IInteger) {
            if (that.isZero()) {
                if (!this.isZero()) {
                    return F.C1;
                }
                return IFraction.super.power(that);
            }
            if (that.isOne()) {
                return this;
            }
            if (that.isMinusOne()) {
                return this.inverse();
            }
            long n = ((IInteger)that).toLongDefault();
            if (n != Long.MIN_VALUE) {
                return this.power(n);
            }
        }
        return IFraction.super.power(that);
    }

    @Override
    public final IFraction powerRational(long n) throws ArithmeticException {
        if (n == 0L) {
            if (!this.isZero()) {
                return FractionSym.ONE;
            }
            throw new ArithmeticException("Indeterminate: 0^0");
        }
        if (n == 1L) {
            return this;
        }
        if (n == -1L) {
            return this.inverse();
        }
        long exp = n;
        if (n < 0L) {
            if (n == Long.MIN_VALUE) {
                throw new ArithmeticException();
            }
            exp *= -1L;
        }
        int b2pow = 0;
        while ((exp & 1L) == 0L) {
            ++b2pow;
            exp >>= 1;
        }
        IFraction result = this;
        IFraction x = result;
        while ((exp >>= 1) > 0L) {
            x = x.mul(x);
            if ((exp & 1L) == 0L) continue;
            result.checkBitLength();
            result = result.mul(x);
        }
        while (b2pow-- > 0) {
            result.checkBitLength();
            result = result.mul(result);
        }
        if (n < 0L) {
            return result.inverse();
        }
        return result;
    }

    @Override
    public void checkBitLength() {
        long bitLength;
        if (Integer.MAX_VALUE > Config.MAX_BIT_LENGTH && (bitLength = (long)this.toBigNumerator().bitLength() + (long)this.toBigDenominator().bitLength()) > (long)Config.MAX_BIT_LENGTH) {
            BigIntegerLimitExceeded.throwIt(bitLength);
        }
    }

    @Override
    public int complexSign() {
        return this.toBigNumerator().signum();
    }

    @Override
    public IFraction sub(IFraction other) {
        return this.add(other.negate());
    }

    public IFraction subdiv(IFraction s, FractionSym d) {
        return this.sub(s).div(d);
    }

    @Override
    public IRational subtract(IRational that) {
        if (this.isZero()) {
            return that.negate();
        }
        return this.add(that.negate());
    }

    @Override
    public ISignedNumber subtractFrom(ISignedNumber that) {
        if (that instanceof IRational) {
            return this.add((IRational)that.negate());
        }
        return Num.valueOf(this.doubleValue() - that.doubleValue());
    }

    @Override
    public IExpr times(IExpr that) {
        if (that instanceof IFraction) {
            return this.mul((IFraction)that).normalize();
        }
        if (that instanceof IntegerSym) {
            return this.mul(AbstractFractionSym.valueOf(((IntegerSym)that).fIntValue)).normalize();
        }
        if (that instanceof BigIntegerSym) {
            return this.mul(AbstractFractionSym.valueOf(((BigIntegerSym)that).fBigIntValue)).normalize();
        }
        if (that instanceof ComplexSym) {
            return ((ComplexSym)that).multiply(ComplexSym.valueOf(this)).normalize();
        }
        return IFraction.super.times(that);
    }

    @FunctionalInterface
    private static interface ConvergencePredicate {
        public boolean test(long var1, long var3);
    }
}

