/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import com.google.common.base.Suppliers;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import it.unimi.dsi.fastutil.ints.IntList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.complex.Complex;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.RealMatrix;
import org.jgrapht.GraphType;
import org.jgrapht.graph.DefaultGraphType;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.BooleanFunctions;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.JavaFunctions;
import org.matheclipse.core.builtin.PredicateQ;
import org.matheclipse.core.builtin.StructureFunctions;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.convert.Object2Expr;
import org.matheclipse.core.convert.VariablesSet;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.exception.FlowControlException;
import org.matheclipse.core.eval.exception.SymjaMathException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.ICoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IRewrite;
import org.matheclipse.core.eval.util.AbstractAssumptions;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.AbstractIntegerSym;
import org.matheclipse.core.expression.ExprID;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.generic.ObjIntPredicate;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.generic.UnaryVariable2Slot;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IContinuousDistribution;
import org.matheclipse.core.interfaces.IDiscreteDistribution;
import org.matheclipse.core.interfaces.IDistribution;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IPatternObject;
import org.matheclipse.core.interfaces.IPatternSequence;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.interfaces.IUnaryIndexFunction;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcherEvalEngine;
import org.matheclipse.core.polynomials.longexponent.ExprPolynomial;
import org.matheclipse.core.polynomials.longexponent.ExprPolynomialRing;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;
import org.matheclipse.core.visit.VisitorReplaceAll;
import org.matheclipse.parser.client.ParserConfig;

public abstract class AbstractAST
implements IASTMutable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Supplier<Cache<IAST, EnumMap<IAST.PROPERTY, Object>>> IAST_CACHE = Suppliers.memoize(AbstractAST::initCache);
    static final NILPointer NIL = new NILPointer();
    private static final long serialVersionUID = -8682706994448890660L;
    protected int fEvalFlags = 0;
    protected transient int hashValue = 0;
    private static final IExpr.SourceCodeProperties STRING_FORM_SYMBOL_FACTORY = IExpr.SourceCodeProperties.of(true, false, IExpr.SourceCodeProperties.Prefix.NONE, false);
    private static final IExpr.SourceCodeProperties STRING_FORM_NO_SYMBOL_FACTORY = IExpr.SourceCodeProperties.of(false, false, IExpr.SourceCodeProperties.Prefix.NONE, false);
    private static final IExpr.SourceCodeProperties SCALA_FORM_SYMBOL_FACTORY = IExpr.SourceCodeProperties.of(true, true, IExpr.SourceCodeProperties.Prefix.NONE, false);
    private static final IExpr.SourceCodeProperties SCALA_FORM_NO_SYMBOL_FACTORY = IExpr.SourceCodeProperties.of(false, true, IExpr.SourceCodeProperties.Prefix.NONE, false);

    private static Cache<IAST, EnumMap<IAST.PROPERTY, Object>> initCache() {
        return CacheBuilder.newBuilder().maximumSize(500L).build();
    }

    private static Cache<IAST, EnumMap<IAST.PROPERTY, Object>> propertyCache() {
        return IAST_CACHE.get();
    }

    private static int compareToASTDecreasing(IAST lhsAST, IAST rhsAST) {
        int rhsSize;
        int lhsSize;
        block1: {
            int cp;
            lhsSize = lhsAST.size();
            int k = lhsSize > (rhsSize = rhsAST.size()) ? rhsSize : lhsSize;
            do {
                int n = --k;
                --k;
                if (n <= 0) break block1;
            } while ((cp = lhsAST.get(--lhsSize).compareTo(rhsAST.get(--rhsSize))) == 0);
            return cp;
        }
        return lhsSize > rhsSize ? 1 : (lhsSize < rhsSize ? -1 : 0);
    }

    private static int compareToASTDecreasingArg1(IAST lhsAST, IExpr arg1, IInteger value) {
        int lhsSize = lhsAST.size();
        int cp = lhsAST.get(lhsSize - 1).compareTo(arg1);
        if (cp != 0) {
            return cp;
        }
        if (lhsSize >= 2 && (cp = lhsAST.get(--lhsSize - 1).compareTo(value)) != 0) {
            return cp;
        }
        return 1;
    }

    private static int compareToASTIncreasing(IAST lhsAST, IAST rhsAST) {
        int cp;
        if (lhsAST.isPlusTimesPower()) {
            if (!rhsAST.isPlusTimesPower()) {
                return -1;
            }
        } else if (rhsAST.isPlusTimesPower()) {
            return 1;
        }
        if ((cp = lhsAST.head().compareTo(rhsAST.head())) != 0) {
            return cp;
        }
        int minimumSize = lhsAST.size() > rhsAST.size() ? rhsAST.size() : lhsAST.size();
        for (int i = 1; i < minimumSize; ++i) {
            cp = lhsAST.get(i).compareTo(rhsAST.get(i));
            if (cp == 0) continue;
            return cp;
        }
        if (lhsAST.size() > rhsAST.size()) {
            return 1;
        }
        if (lhsAST.size() < rhsAST.size()) {
            return -1;
        }
        return 0;
    }

    private static int compareToASTIncreasingArg1(IAST lhsAST, IExpr arg1, IInteger value) {
        int cp = lhsAST.arg1().compareTo(arg1);
        if (cp != 0) {
            return cp;
        }
        if (lhsAST.size() >= 2 && (cp = lhsAST.arg2().compareTo(value)) != 0) {
            return cp;
        }
        return 1;
    }

    private static void internalFormOrderless(IAST ast, StringBuilder text, String sep, IExpr.SourceCodeProperties properties, int depth, Function<ISymbol, ? extends CharSequence> variables) {
        for (int i = 1; i < ast.size(); ++i) {
            if (ast.get(i) instanceof IAST && ast.head().equals(ast.get(i).head())) {
                AbstractAST.internalFormOrderless((IAST)ast.get(i), text, sep, properties, depth, variables);
            } else {
                text.append(ast.get(i).internalJavaString(properties, depth + 1, variables));
            }
            if (i >= ast.argSize()) continue;
            text.append(sep);
        }
    }

    private static IExpr variables2Slots(IExpr expr, Predicate<IExpr> from, Function<IExpr, ? extends IExpr> to) {
        if (from.test(expr)) {
            return to.apply(expr);
        }
        if (expr.isAST()) {
            IAST nestedList = (IAST)expr;
            IExpr head = nestedList.head();
            IExpr temp = AbstractAST.variables2Slots(head, from, to);
            if (!temp.isPresent()) {
                return F.NIL;
            }
            IASTAppendable result = nestedList.apply(temp);
            int size = nestedList.size();
            for (int i = 1; i < size; ++i) {
                temp = AbstractAST.variables2Slots(nestedList.get(i), from, to);
                if (!temp.isPresent()) {
                    return F.NIL;
                }
                result.set(i, temp);
            }
            return result;
        }
        return expr;
    }

    @Override
    public IExpr accept(IVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public final boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public final int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return visitor.visit(this);
    }

    @Override
    public final IAST addEvalFlags(int i) {
        this.fEvalFlags |= i;
        return this;
    }

    @Override
    public IASTAppendable appendAtClone(int position, IExpr expr) {
        IASTAppendable ast = this.copyAppendable();
        ast.append(position, expr);
        return ast;
    }

    @Override
    public IASTAppendable appendClone(IExpr expr) {
        IASTAppendable ast = this.copyAppendable(1);
        ast.append(expr);
        return ast;
    }

    @Override
    public IASTAppendable apply(IExpr head) {
        return this.setAtClone(0, head);
    }

    @Override
    public final IAST apply(IExpr head, int start) {
        return this.apply(head, start, this.size());
    }

    @Override
    public IAST apply(IExpr head, int start, int end) {
        IASTAppendable ast = F.ast(head, end - start);
        ast.appendArgs(start, end, i -> this.get(i));
        return ast;
    }

    @Override
    public IExpr getUnevaluated(int position) {
        IExpr arg = this.get(position);
        return arg.isUnevaluated() ? arg.first() : arg;
    }

    @Override
    public Set<IExpr> asSet() {
        return null;
    }

    @Override
    public Object asType(Class<?> clazz) {
        if (clazz.equals(Boolean.class)) {
            IExpr temp = F.eval(this);
            if (temp.equals(S.True)) {
                return Boolean.TRUE;
            }
            if (temp.equals(S.False)) {
                return Boolean.FALSE;
            }
        } else if (clazz.equals(Integer.class)) {
            IExpr temp = F.eval(this);
            if (temp.isReal()) {
                try {
                    return ((ISignedNumber)((Object)this)).toInt();
                }
                catch (ArithmeticException arithmeticException) {}
            }
        } else if (clazz.equals(BigInteger.class)) {
            IExpr temp = F.eval(this);
            if (temp instanceof AbstractIntegerSym) {
                return new BigInteger(((AbstractIntegerSym)temp).toByteArray());
            }
        } else if (clazz.equals(String.class)) {
            return this.toString();
        }
        throw new UnsupportedOperationException("AST.asType() - cast not supported.");
    }

    @Override
    public void clearHashCache() {
        this.hashValue = 0;
    }

    @Override
    public boolean compareAdjacent(BiPredicate<IExpr, IExpr> predicate) {
        if (this.size() < 2) {
            return false;
        }
        IExpr elem = this.get(1);
        for (int i = 2; i < this.size(); ++i) {
            if (!predicate.test(elem, this.get(i))) {
                return false;
            }
            elem = this.get(i);
        }
        return true;
    }

    @Override
    public int compareTo(IExpr rhsExpr) {
        int y;
        int x;
        int lhsOrdinal = this.headID();
        int rhsOrdinal = -1;
        if (lhsOrdinal < 0) {
            if (rhsExpr.isNumber()) {
                return 1;
            }
            rhsOrdinal = rhsExpr.headID();
            if (rhsOrdinal < 0) {
                int y2;
                if (rhsExpr.isAST()) {
                    return AbstractAST.compareToASTIncreasing(this, (IAST)rhsExpr);
                }
                int x2 = this.hierarchy();
                return x2 < (y2 = rhsExpr.hierarchy()) ? -1 : (x2 == y2 ? 0 : 1);
            }
        } else {
            if (lhsOrdinal == 355 && this.isDirectedInfinity()) {
                if (rhsExpr.isNumber() || rhsExpr.isSymbol()) {
                    return 1;
                }
                if (!rhsExpr.isDirectedInfinity()) {
                    return -1;
                }
                return AbstractAST.compareToASTIncreasing(this, (IAST)rhsExpr);
            }
            if (rhsExpr.isNumber()) {
                return 1;
            }
            rhsOrdinal = rhsExpr.headID();
        }
        if (rhsExpr.isAST()) {
            if (rhsOrdinal == 355 && rhsExpr.isDirectedInfinity()) {
                if (!this.isDirectedInfinity()) {
                    return 1;
                }
                return AbstractAST.compareToASTIncreasing(this, (IAST)rhsExpr);
            }
            if (lhsOrdinal >= 1014 && lhsOrdinal <= 1341 && this.size() > 1) {
                IAST rhs = (IAST)rhsExpr;
                switch (lhsOrdinal) {
                    case 1014: {
                        if (rhsOrdinal == 1014) {
                            if (rhs.size() < 1) break;
                            return AbstractAST.compareToASTDecreasing(this, rhs);
                        }
                        if (rhsExpr.isSameHeadSizeGE(S.Plus, 1) || rhsExpr.isSameHeadSizeGE(S.Times, 1)) break;
                        return AbstractAST.compareToASTDecreasingArg1(this, rhsExpr, F.C0);
                    }
                    case 1036: {
                        if (rhsOrdinal == 1036) {
                            if (rhs.size() == 3) {
                                int baseCompare = this.base().compareTo(rhs.base());
                                if (baseCompare == 0) {
                                    return this.exponent().compareTo(rhs.exponent());
                                }
                                return baseCompare;
                            }
                            return AbstractAST.compareToASTIncreasingArg1(this, rhsExpr, F.C1);
                        }
                        if (rhsExpr.isSameHeadSizeGE(S.Times, 1) || rhsExpr.isSameHeadSizeGE(S.Plus, 1)) break;
                        return AbstractAST.compareToASTIncreasingArg1(this, rhsExpr, F.C1);
                    }
                    case 1341: {
                        if (rhsOrdinal == 1341 && rhs.size() >= 1) {
                            return AbstractAST.compareToASTDecreasing(this, rhs);
                        }
                        return AbstractAST.compareToASTDecreasingArg1(this, rhsExpr, F.C1);
                    }
                }
            }
            if (rhsOrdinal < 0 || !rhsExpr.isPlusTimesPower()) {
                return AbstractAST.compareToASTIncreasing(this, (IAST)rhsExpr);
            }
            return -1 * rhsExpr.compareTo(this);
        }
        if (lhsOrdinal >= 922 && lhsOrdinal <= 1341 && this.size() > 1) {
            switch (lhsOrdinal) {
                case 922: {
                    if (!rhsExpr.isSymbol() || !this.arg1().isSymbol() || this.size() != 2) break;
                    return -1 * rhsExpr.compareTo(this);
                }
                case 1014: {
                    return AbstractAST.compareToASTDecreasingArg1(this, rhsExpr, F.C1);
                }
                case 1036: {
                    if (this.size() != 3) break;
                    return AbstractAST.compareToASTIncreasingArg1(this, rhsExpr, F.C1);
                }
                case 1341: {
                    return AbstractAST.compareToASTDecreasingArg1(this, rhsExpr, F.C1);
                }
            }
        }
        return (x = this.hierarchy()) < (y = rhsExpr.hierarchy()) ? -1 : (x == y ? 0 : 1);
    }

    @Override
    public boolean contains(Object object) {
        return this.exists((? super IExpr x) -> object.equals(x), 0);
    }

    public IAST copyAlloc(int capacity) {
        return this.copy();
    }

    @Override
    public IASTAppendable copyFrom(int index) {
        AST result = new AST(this.size() - index + 1, false);
        result.append(this.head());
        result.appendAll(this, index, this.size());
        return result;
    }

    @Override
    public IASTAppendable copyHead() {
        return AST.newInstance(this.head());
    }

    @Override
    public IASTAppendable copyHead(int intialCapacity) {
        return AST.newInstance(intialCapacity, this.head(), false);
    }

    @Override
    public IASTAppendable copyUntil(int index) {
        return AST.newInstance(index, this, index);
    }

    @Override
    public IASTAppendable copyUntil(int intialCapacity, int index) {
        return AST.newInstance(intialCapacity, this, index);
    }

    @Override
    public int depth() {
        int maxDepth = 1;
        for (int i = 1; i < this.size(); ++i) {
            int d;
            if (!this.get(i).isAST() || (d = ((IAST)this.get(i)).depth()) <= maxDepth) continue;
            maxDepth = d;
        }
        return ++maxDepth;
    }

    @Override
    public long determinePrecision() {
        long precision = -1L;
        if (this.isAST(S.N, 3)) {
            long determinedPrecision = this.arg1().determinePrecision();
            if (determinedPrecision > 0L) {
                return determinedPrecision;
            }
            int p = this.arg2().toIntDefault();
            if ((long)p >= 16L) {
                precision = p;
            }
            return precision;
        }
        for (int i = 1; i < this.size(); ++i) {
            long p = this.get(i).determinePrecision();
            if (p <= precision) continue;
            precision = p;
        }
        return precision;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractAST) {
            AbstractAST ast = (AbstractAST)obj;
            if (this.size() != ast.size()) {
                return false;
            }
            IExpr head = this.head();
            if (head instanceof ISymbol ? head != ast.head() : !head.equals(ast.head())) {
                return false;
            }
            if (this.hashCode() != ((Object)ast).hashCode()) {
                return false;
            }
            return this.forAll((? super IExpr x, int i) -> x.equals(ast.get(i)), 1);
        }
        return false;
    }

    @Override
    public final boolean equalsAt(int position, IExpr expr) {
        return this.get(position).equals(expr);
    }

    public final boolean equalsFromPosition(int from0, IAST f1, int from1) {
        if (this.size() - from0 != f1.size() - from1) {
            return false;
        }
        int j = from1;
        for (int i = from0; i < this.argSize(); ++i) {
            if (this.get(i + 1).equals(f1.get(1 + j++))) continue;
            return false;
        }
        return true;
    }

    @Override
    public IExpr.COMPARE_TERNARY equalTernary(IExpr that, EvalEngine engine) {
        if (that.isIndeterminate()) {
            return IExpr.COMPARE_TERNARY.UNDECIDABLE;
        }
        if (this == that) {
            return IExpr.COMPARE_TERNARY.TRUE;
        }
        if (that.isAST()) {
            IAST list2 = (IAST)that;
            if (this.isList() && list2.isList()) {
                int size1 = this.size();
                if (size1 != list2.size()) {
                    return IExpr.COMPARE_TERNARY.FALSE;
                }
                IExpr.COMPARE_TERNARY b = IExpr.COMPARE_TERNARY.TRUE;
                for (int i = 1; i < size1; ++i) {
                    b = this.get(i).equalTernary(list2.get(i), engine);
                    if (b == IExpr.COMPARE_TERNARY.FALSE) {
                        return IExpr.COMPARE_TERNARY.FALSE;
                    }
                    if (b == IExpr.COMPARE_TERNARY.TRUE) continue;
                    return IExpr.COMPARE_TERNARY.UNDECIDABLE;
                }
                return IExpr.COMPARE_TERNARY.TRUE;
            }
            int size1 = this.size();
            if (size1 == list2.size() && size1 > 0 && this.head().equals(list2.head())) {
                boolean unequal = false;
                IExpr.COMPARE_TERNARY b = IExpr.COMPARE_TERNARY.TRUE;
                for (int i = 1; i < size1; ++i) {
                    b = this.get(i).equalTernary(list2.get(i), engine);
                    if (b == IExpr.COMPARE_TERNARY.TRUE) continue;
                    unequal = true;
                    break;
                }
                if (!unequal) {
                    return IExpr.COMPARE_TERNARY.TRUE;
                }
            }
        }
        return IASTMutable.super.equalTernary(that, engine);
    }

    @Override
    public final INumber evalNumber() {
        IExpr result;
        if (this.isNumericFunction(true) && (result = EvalEngine.get().evalN(this)).isNumber()) {
            return (INumber)result;
        }
        return null;
    }

    @Override
    public final ISignedNumber evalReal() {
        IExpr result;
        if (this.isNumericFunction(true) && (result = EvalEngine.get().evalN(this)).isReal()) {
            return (ISignedNumber)result;
        }
        return null;
    }

    public IExpr evalEvaluate(EvalEngine engine) {
        IASTMutable[] rlist = new IASTMutable[]{F.NIL};
        if (!this.isHoldAllCompleteAST()) {
            this.forEach(1, this.size(), (? super IExpr x, int i) -> {
                if (x.isAST(S.Evaluate)) {
                    engine.evalArg(rlist, this, (IExpr)x, i, false);
                }
            });
        }
        return rlist[0];
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        LOGGER.debug("Evaluate {}", (Object)this);
        IExpr head = this.head();
        int argSize = this.argSize();
        if (head instanceof ISymbol) {
            IEvaluator evaluator;
            ISymbol headSymbol = (ISymbol)head;
            Class<?> clazz = headSymbol.getContext().getJavaClass();
            if (clazz != null) {
                String staticMethodName = headSymbol.getSymbolName();
                Method[] methods = clazz.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Object[] params;
                    Parameter[] parameters;
                    if (!Modifier.isStatic(methods[i].getModifiers()) || !staticMethodName.equals(methods[i].getName()) || (parameters = methods[i].getParameters()).length != this.argSize() || (params = JavaFunctions.determineParameters(this, parameters, 1)) == null) continue;
                    try {
                        Object result = methods[i].invoke(null, params);
                        if (result instanceof String) {
                            return F.stringx((String)result);
                        }
                        return Object2Expr.convert(result, false, true);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                        // empty catch block
                    }
                }
            }
            if (head instanceof IBuiltInSymbol && (evaluator = ((IBuiltInSymbol)head).getEvaluator()) instanceof ICoreFunctionEvaluator) {
                try {
                    IExpr temp;
                    ICoreFunctionEvaluator functionEvaluator = (ICoreFunctionEvaluator)evaluator;
                    EvalEngine.OptionsResult opres = engine.checkBuiltinArguments(this, functionEvaluator);
                    if (opres == null) {
                        return F.NIL;
                    }
                    IAST ast = opres.result;
                    IBuiltInSymbol header = (IBuiltInSymbol)head;
                    if ((header.getAttributes() & 0x40000) != 262144 && (temp = F.flattenSequence(this)).isPresent()) {
                        return temp;
                    }
                    if (this.isBooleanFunction() && (temp = this.extractConditionalExpression(false)).isPresent()) {
                        return temp;
                    }
                    IExpr evaluateTemp = this.evalEvaluate(engine);
                    if (evaluateTemp.isPresent()) {
                        return evaluateTemp;
                    }
                    return functionEvaluator.evaluate(ast, engine);
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(this.topHead(), ve, engine);
                }
                catch (FlowControlException e) {
                    throw e;
                }
                catch (SymjaMathException ve) {
                    LOGGER.log(engine.getLogLevel(), (Object)this.topHead(), (Throwable)((Object)ve));
                    return F.NIL;
                }
            }
        }
        if (head.isAssociation() && argSize == 1) {
            return ((IAssociation)head).getValue(this.arg1());
        }
        ISymbol symbol = this.topHead();
        IExpr temp = engine.evalAttributes(symbol, this);
        if (temp.isPresent()) {
            return temp;
        }
        return engine.evalRules(symbol, this);
    }

    @Override
    public boolean exists(ObjIntPredicate<? super IExpr> predicate, int startOffset) {
        int size = this.size();
        for (int i = startOffset; i < size; ++i) {
            if (!predicate.test(this.get(i), i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean exists(Predicate<? super IExpr> predicate, int startOffset) {
        int size = this.size();
        for (int i = startOffset; i < size; ++i) {
            if (!predicate.test(this.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public final IASTAppendable[] filterNIL(Function<IExpr, IExpr> function) {
        IASTAppendable[] result = new IASTAppendable[]{this.copyHead(this.size()), this.copyHead(this.size())};
        this.filterFunction(result[0], result[1], function);
        return result;
    }

    @Override
    public IAST filter(IASTAppendable filterAST, IASTAppendable restAST, Predicate<? super IExpr> predicate) {
        this.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> {
            if (predicate.test((IExpr)x)) {
                filterAST.append((IExpr)x);
            } else {
                restAST.append((IExpr)x);
            }
        }));
        return filterAST;
    }

    @Override
    public final IAST filter(IASTAppendable filterAST, IExpr unaryHead) {
        EvalEngine engine = EvalEngine.get();
        return this.filter(filterAST, (? super IExpr x) -> engine.evalTrue(unaryHead, (IExpr)x));
    }

    @Override
    public IAST filter(IASTAppendable filterAST, Predicate<? super IExpr> predicate) {
        this.forEach(this.size(), (? super IExpr x) -> {
            if (predicate.test((IExpr)x)) {
                filterAST.append((IExpr)x);
            }
        });
        return filterAST;
    }

    @Override
    public IAST filter(IASTAppendable filterAST, Predicate<? super IExpr> predicate, int maxMatches) {
        int[] count = new int[1];
        if (count[0] >= maxMatches) {
            return filterAST;
        }
        this.exists((? super IExpr x) -> {
            if (predicate.test((IExpr)x)) {
                count[0] = count[0] + 1;
                if (count[0] == maxMatches) {
                    filterAST.append((IExpr)x);
                    return true;
                }
                filterAST.append((IExpr)x);
            }
            return false;
        });
        return filterAST;
    }

    @Override
    public IAST select(Predicate<? super IExpr> predicate) {
        int[] items = new int[this.size()];
        int length = 0;
        for (int i = 1; i < this.size(); ++i) {
            if (!predicate.test(this.get(i))) continue;
            items[length++] = i;
        }
        if (length == this.argSize()) {
            return this;
        }
        return this.getItems(items, length);
    }

    @Override
    public IAST select(Predicate<? super IExpr> predicate, int maxMatches) {
        maxMatches = this.size() > maxMatches ? maxMatches : this.size();
        int[] items = new int[maxMatches];
        int length = 0;
        for (int i = 1; i < this.size(); ++i) {
            if (!predicate.test(this.get(i))) continue;
            items[length++] = i;
            if (maxMatches == length) break;
        }
        if (length == this.argSize()) {
            return this;
        }
        return this.getItems(items, length);
    }

    @Override
    public IAST[] filter(Predicate<? super IExpr> predicate) {
        IAST[] result = new IASTAppendable[]{this.copyHead(), this.copyHead()};
        this.filter(result[0], result[1], predicate);
        return result;
    }

    @Override
    public IAST removeIf(Predicate<? super IExpr> predicate) {
        IASTAppendable result = F.NIL;
        for (int i = 1; i < this.size(); ++i) {
            IExpr arg = this.get(i);
            if (predicate.test(arg)) continue;
            if (!result.isPresent()) {
                result = this.copyHead(this.argSize());
            }
            result.appendRule(arg);
        }
        return result.orElse(this);
    }

    protected IAST filterFunction(IASTAppendable filterAST, IASTAppendable restAST, Function<IExpr, IExpr> function) {
        this.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> {
            IExpr expr = (IExpr)function.apply((IExpr)x);
            if (expr.isPresent()) {
                filterAST.append(expr);
            } else {
                restAST.append((IExpr)x);
            }
        }));
        return filterAST;
    }

    @Override
    public IExpr foldLeft(BiFunction<IExpr, IExpr, ? extends IExpr> function, IExpr startValue, int start) {
        IExpr value = startValue;
        for (int i = start; i < this.size(); ++i) {
            if ((value = function.apply(value, this.get(i))).isPresent()) continue;
            return F.NIL;
        }
        return value;
    }

    @Override
    public IExpr foldRight(BiFunction<IExpr, IExpr, ? extends IExpr> function, IExpr startValue, int start) {
        int end;
        IExpr value = startValue;
        for (int i = end = this.argSize(); i >= start; --i) {
            if ((value = function.apply(value, this.get(i))).isPresent()) continue;
            return F.NIL;
        }
        return value;
    }

    @Override
    public boolean forAll(ObjIntPredicate<? super IExpr> predicate, int startOffset) {
        int size = this.size();
        for (int i = startOffset; i < size; ++i) {
            if (predicate.test(this.getRule(i), i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forAll(Predicate<? super IExpr> predicate, int startOffset) {
        int size = this.size();
        for (int i = startOffset; i < size; ++i) {
            if (predicate.test(this.getRule(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forAllLeaves(Predicate<? super IExpr> predicate, int startOffset) {
        int size = this.size();
        for (int i = startOffset; i < size; ++i) {
            if (!(this.get(i).isAST() ? !((IAST)this.get(i)).forAllLeaves(predicate, startOffset) : !predicate.test(this.get(i)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void forEach(Consumer<? super IExpr> action) {
        this.forEach(action, 1);
    }

    @Override
    public void forEach(Consumer<? super IExpr> action, int startOffset) {
        this.forEach(startOffset, this.size(), action);
    }

    @Override
    public String fullFormString() {
        return this.fullFormString(this.head());
    }

    protected String fullFormString(IExpr head) {
        String sep = ", ";
        StringBuilder text = new StringBuilder();
        if (head == null) {
            text.append("<null-head>");
            head = S.Null;
        } else {
            text.append(head.fullFormString());
        }
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS && head.isSymbol()) {
            text.append('(');
        } else {
            text.append('[');
        }
        for (int i = 1; i < this.size(); ++i) {
            IExpr temp = this.get(i);
            if (temp == null) {
                text.append("<null-arg>");
                continue;
            }
            text.append(this.get(i).fullFormString());
            if (i >= this.argSize()) continue;
            text.append(", ");
        }
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS && head.isSymbol()) {
            text.append(')');
        } else {
            text.append(']');
        }
        return text.toString();
    }

    @Override
    public final IExpr gcd(IExpr that) {
        if (this.equals(that)) {
            return that;
        }
        return F.C1;
    }

    @Override
    public abstract IExpr get(int var1);

    @Override
    public IExpr get(IInteger location) {
        return this.get(location.toIntDefault());
    }

    @Override
    public final IAST getAST(int index) {
        try {
            return (IAST)this.get(index);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("argument " + this.get(index).toString() + " is not an IAST");
        }
    }

    @Override
    public final IExpr getAt(int index) {
        return this.get(index);
    }

    @Override
    public final int getEvalFlags() {
        return this.fEvalFlags;
    }

    @Override
    public int getHashCache() {
        return this.hashValue;
    }

    @Override
    public final IInteger getInt(int index) {
        try {
            return (IInteger)this.get(index);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("argument " + this.get(index).toString() + " is not an IInteger");
        }
    }

    @Override
    public final IAST getList(int index) {
        IExpr temp = this.get(index);
        if (temp.isList()) {
            return (IAST)temp;
        }
        throw new IllegalArgumentException("argument " + this.get(index).toString() + " is not a list");
    }

    @Override
    public final INumber getNumber(int index) {
        try {
            return (INumber)this.get(index);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("argument " + this.get(index).toString() + " is not an INumber");
        }
    }

    @Override
    public IExpr getOptionalValue() {
        if (this.isAST(S.Optional, 3)) {
            return this.arg2();
        }
        return null;
    }

    @Override
    public IExpr getPart(int ... positions) {
        IExpr expr = this;
        int size = positions.length;
        for (int i = 0; i < size && expr.isAST(); ++i) {
            expr = ((IAST)expr).get(positions[i]);
            if (i != size - 1) continue;
            return expr;
        }
        return F.NIL;
    }

    @Override
    public final IExpr getPart(IntList positions) {
        IExpr expr = this;
        int size = positions.size();
        for (int i = 0; i < size && expr.isAST(); ++i) {
            expr = ((IAST)expr).get(positions.getInt(i));
            if (i != size - 1) continue;
            return expr;
        }
        return null;
    }

    public Object getProperty(IAST.PROPERTY key) {
        EnumMap map = (EnumMap)AbstractAST.propertyCache().getIfPresent((Object)this);
        if (map == null) {
            return null;
        }
        return map.get((Object)key);
    }

    @Override
    public final boolean has(Predicate<IExpr> predicate, boolean heads) {
        if (predicate.test(this)) {
            return true;
        }
        return this.exists((? super IExpr x) -> x.has(predicate, heads), heads ? 0 : 1);
    }

    @Override
    public final boolean hasTrigonometricFunction() {
        return this.has((IExpr x) -> {
            IExpr head;
            if (x.isAST1() && (head = x.head()).isBuiltInSymbol()) {
                return head == S.ArcCos || head == S.ArcCsc || head == S.ArcCot || head == S.ArcSec || head == S.ArcSin || head == S.ArcTan || head == S.Cos || head == S.Csc || head == S.Cot || head == S.Sec || head == S.Sin || head == S.Sinc || head == S.Tan || head == S.Cosh || head == S.Csch || head == S.Coth || head == S.Sech || head == S.Sinh || head == S.Tanh || head == S.Haversine || head == S.InverseHaversine;
            }
            if (x.isAST2()) {
                return x.head() == S.ArcTan;
            }
            return false;
        }, false);
    }

    public int hashCode() {
        if (this.hashValue == 0) {
            this.hashValue = -2128831035;
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                this.hashValue = this.hashValue * 16777619 ^ this.get(i).hashCode() & 0xFF;
            }
        }
        return this.hashValue;
    }

    @Override
    public int hierarchy() {
        return 1024;
    }

    @Override
    public int indexOf(IExpr expr) {
        for (int i = 1; i < this.size(); ++i) {
            if (!this.getRule(i).equals(expr)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int indexOf(Predicate<? super IExpr> predicate, int fromIndex) {
        for (int i = fromIndex; i < this.size(); ++i) {
            if (!predicate.test(this.getRule(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public IExpr findFirst(Function<IExpr, IExpr> function) {
        for (int i = 1; i < this.size(); ++i) {
            IExpr temp = function.apply(this.getRule(i));
            if (!temp.isPresent()) continue;
            return temp;
        }
        return F.NIL;
    }

    static IExpr.SourceCodeProperties stringFormProperties(boolean symbolsAsFactoryMethod) {
        return symbolsAsFactoryMethod ? STRING_FORM_SYMBOL_FACTORY : STRING_FORM_NO_SYMBOL_FACTORY;
    }

    @Override
    public final CharSequence internalFormString(boolean symbolsAsFactoryMethod, int depth) {
        return this.internalJavaString(AbstractAST.stringFormProperties(symbolsAsFactoryMethod), depth, x -> null);
    }

    @Override
    public CharSequence internalJavaString(IExpr.SourceCodeProperties properties, int depth, Function<ISymbol, ? extends CharSequence> variables) {
        String sep = ",";
        IExpr temp = this.head();
        if (temp.equals(S.HoldForm) && this.size() == 2) {
            return this.arg1().internalJavaString(properties, depth, variables);
        }
        if (temp.equals(S.Hold) && this.size() == 2) {
            return this.arg1().internalJavaString(properties, depth, variables);
        }
        String prefix = AbstractAST.getPrefixF(properties);
        if (this.isInfinity()) {
            return new StringBuilder(prefix).append("oo");
        }
        if (this.isNegativeInfinity()) {
            return new StringBuilder(prefix).append("Noo");
        }
        if (this.isComplexInfinity()) {
            return new StringBuilder(prefix).append("CComplexInfinity");
        }
        if (this.equals(F.Slot1)) {
            return new StringBuilder(prefix).append("Slot1");
        }
        if (this.equals(F.Slot2)) {
            return new StringBuilder(prefix).append("Slot2");
        }
        if (temp.equals(S.Inequality) && this.size() >= 4) {
            return BooleanFunctions.inequality2And(this).internalJavaString(properties, depth, variables);
        }
        if (temp.equals(S.Rational) && this.size() == 3 && this.arg1().isInteger() && this.arg2().isInteger()) {
            return F.QQ((IInteger)this.arg1(), (IInteger)this.arg2()).internalJavaString(properties, depth, variables);
        }
        if (this.isPower()) {
            IInteger i;
            if (this.arg1().isInteger() && this.arg2().isMinusOne()) {
                i = (IInteger)this.arg1();
                if (i.equals(F.C2)) {
                    return new StringBuilder(prefix).append("C1D2");
                }
                if (i.equals(F.C3)) {
                    return new StringBuilder(prefix).append("C1D3");
                }
                if (i.equals(F.C4)) {
                    return new StringBuilder(prefix).append("C1D4");
                }
                if (i.equals(F.CN2)) {
                    return new StringBuilder(prefix).append("CN1D2");
                }
                if (i.equals(F.CN3)) {
                    return new StringBuilder(prefix).append("CN1D3");
                }
                if (i.equals(F.CN4)) {
                    return new StringBuilder(prefix).append("CN1D4");
                }
            }
            if (this.equalsAt(1, S.E)) {
                return new StringBuilder(prefix).append("Exp(").append(this.arg2().internalJavaString(properties, depth + 1, variables)).append(")");
            }
            if (this.equalsAt(2, F.C1D2)) {
                if (this.base().isInteger()) {
                    i = (IInteger)this.base();
                    if (i.equals(F.C2)) {
                        return new StringBuilder(prefix).append("CSqrt2");
                    }
                    if (i.equals(F.C3)) {
                        return new StringBuilder(prefix).append("CSqrt3");
                    }
                    if (i.equals(F.C5)) {
                        return new StringBuilder(prefix).append("CSqrt5");
                    }
                    if (i.equals(F.C6)) {
                        return new StringBuilder(prefix).append("CSqrt6");
                    }
                    if (i.equals(F.C7)) {
                        return new StringBuilder(prefix).append("CSqrt7");
                    }
                    if (i.equals(F.C10)) {
                        return new StringBuilder(prefix).append("CSqrt10");
                    }
                }
                return new StringBuilder(prefix).append("Sqrt(").append(this.arg1().internalJavaString(properties, depth + 1, variables)).append(")");
            }
            if (this.equalsAt(2, F.C2)) {
                return new StringBuilder(prefix).append("Sqr(").append(this.arg1().internalJavaString(properties, depth + 1, variables)).append(")");
            }
            if (this.equalsAt(2, F.CN1D2) && this.arg1().isInteger()) {
                i = (IInteger)this.arg1();
                if (i.equals(F.C2)) {
                    return new StringBuilder(prefix).append("C1DSqrt2");
                }
                if (i.equals(F.C3)) {
                    return new StringBuilder(prefix).append("C1DSqrt3");
                }
                if (i.equals(F.C5)) {
                    return new StringBuilder(prefix).append("C1DSqrt5");
                }
                if (i.equals(F.C6)) {
                    return new StringBuilder(prefix).append("C1DSqrt6");
                }
                if (i.equals(F.C7)) {
                    return new StringBuilder(prefix).append("C1DSqrt7");
                }
                if (i.equals(F.C10)) {
                    return new StringBuilder(prefix).append("C1DSqrt10");
                }
            }
        }
        StringBuilder text = new StringBuilder(this.size() * 10);
        if (temp.isSymbol()) {
            ISymbol sym = (ISymbol)temp;
            String name = null;
            if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
                name = sym.toString();
                if (name.length() > 0) {
                    name = name.toLowerCase(Locale.ENGLISH);
                }
                name = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(name);
            }
            if (name == null && !Character.isUpperCase(sym.toString().charAt(0))) {
                text.append(prefix).append("$(");
                for (int i = 0; i < this.size(); ++i) {
                    text.append(this.get(i).internalJavaString(properties, depth + 1, variables));
                    if (i >= this.argSize()) continue;
                    text.append(",");
                }
                return text.append(')');
            }
        } else if (temp.isPattern() || temp.isAST()) {
            text.append(prefix).append("$(");
            for (int i = 0; i < this.size(); ++i) {
                text.append(this.get(i).internalJavaString(properties, depth + 1, variables));
                if (i >= this.argSize()) continue;
                text.append(",");
            }
            return text.append(')');
        }
        if (this.isAST(S.Times, 3)) {
            if (this.equals(F.CNPi)) {
                return new StringBuilder(prefix).append("CNPi");
            }
            if (this.equals(F.CN2Pi)) {
                return new StringBuilder(prefix).append("CN2Pi");
            }
            if (this.equals(F.C2Pi)) {
                return new StringBuilder(prefix).append("C2Pi");
            }
            if (this.equals(F.CNPiHalf)) {
                return new StringBuilder(prefix).append("CNPiHalf");
            }
            if (this.equals(F.CPiHalf)) {
                return new StringBuilder(prefix).append("CPiHalf");
            }
            if (this.arg1().isMinusOne() && !this.arg2().isTimes()) {
                if (this.arg2().isNumber()) {
                    IExpr num = ((INumber)this.arg2()).negate();
                    return num.internalJavaString(properties, depth + 1, variables);
                }
                return new StringBuilder(prefix).append("Negate(").append(this.arg2().internalJavaString(properties, depth + 1, variables)).append(")");
            }
        } else if (this.isAST(S.Plus, 3)) {
            if (this.arg2().isAST(S.Times, 3) && this.arg2().first().isMinusOne()) {
                return new StringBuilder(prefix).append("Subtract(").append(this.arg1().internalJavaString(properties, depth + 1, variables)).append(",").append(this.arg2().second().internalJavaString(properties, depth + 1, variables)).append(")");
            }
        } else if (this.isList() && this.size() <= 4) {
            switch (this.size()) {
                case 2: {
                    return new StringBuilder(prefix).append("list(").append(this.arg1().internalJavaString(properties, depth + 1, variables)).append(")");
                }
                case 3: {
                    return new StringBuilder(prefix).append("list(").append(this.arg1().internalJavaString(properties, depth + 1, variables)).append(",").append(this.arg2().internalJavaString(properties, depth + 1, variables)).append(")");
                }
                case 4: {
                    return new StringBuilder(prefix).append("list(").append(this.arg1().internalJavaString(properties, depth + 1, variables)).append(",").append(this.arg2().internalJavaString(properties, depth + 1, variables)).append(",").append(this.arg3().internalJavaString(properties, depth + 1, variables)).append(")");
                }
            }
        }
        if (properties.useOperators && this.size() == 3) {
            IExpr arg2;
            IExpr arg1;
            if (this.isTimes()) {
                arg1 = this.arg1();
                arg2 = this.arg2();
                boolean isLowerPrecedence = arg1.isPlus();
                this.internalOperatorForm(arg1, isLowerPrecedence, properties, depth, text);
                text.append('*');
                isLowerPrecedence = arg2.isPlus();
                this.internalOperatorForm(arg2, isLowerPrecedence, properties, depth, text);
                return text;
            }
            if (this.isPlus()) {
                arg1 = this.arg1();
                arg2 = this.arg2();
                this.internalOperatorForm(arg1, false, properties, depth, text);
                text.append('+');
                this.internalOperatorForm(arg2, false, properties, depth, text);
                return text;
            }
            if (this.isPower()) {
                arg1 = this.arg1();
                arg2 = this.arg2();
                boolean isLowerPrecedence = arg1.isTimes() || arg1.isPlus();
                this.internalOperatorForm(arg1, isLowerPrecedence, properties, depth, text);
                text.append('^');
                isLowerPrecedence = arg2.isTimes() || arg2.isPlus();
                this.internalOperatorForm(arg2, isLowerPrecedence, properties, depth, text);
                return text;
            }
        }
        text.append(temp.internalJavaString(IExpr.SourceCodeProperties.copyWithoutSymbolsAsFactoryMethod(properties), 0, variables));
        text.append('(');
        if (this.isTimes() || this.isPlus()) {
            if (depth == 0 && this.isList()) {
                text.append('\n');
            }
            AbstractAST.internalFormOrderless(this, text, ",", properties, depth, variables);
        } else {
            if (depth == 0 && this.isList()) {
                text.append('\n');
            }
            for (int i = 1; i < this.size(); ++i) {
                text.append(this.get(i).internalJavaString(properties, depth + 1, variables));
                if (i >= this.argSize()) continue;
                text.append(",");
                if (depth != 0 || !this.isList()) continue;
                text.append('\n');
            }
        }
        if (depth == 0 && this.isList()) {
            text.append('\n');
        }
        return text.append(')');
    }

    static String getPrefixF(IExpr.SourceCodeProperties properties) {
        switch (properties.prefix) {
            case FULLY_QUALIFIED_CLASS_NAME: {
                return "org.matheclipse.core.expression.F.";
            }
            case CLASS_NAME: {
                return "F.";
            }
        }
        return "";
    }

    private void internalOperatorForm(IExpr arg1, boolean isLowerPrecedence, IExpr.SourceCodeProperties properties, int depth, StringBuilder text) {
        if (isLowerPrecedence) {
            text.append('(');
        }
        text.append(arg1.internalJavaString(properties, depth + 1, x -> null));
        if (isLowerPrecedence) {
            text.append(')');
        }
    }

    static IExpr.SourceCodeProperties scalaFormProperties(boolean symbolsAsFactoryMethod) {
        return symbolsAsFactoryMethod ? SCALA_FORM_SYMBOL_FACTORY : SCALA_FORM_NO_SYMBOL_FACTORY;
    }

    @Override
    public final CharSequence internalScalaString(boolean symbolsAsFactoryMethod, int depth) {
        return this.internalJavaString(AbstractAST.scalaFormProperties(symbolsAsFactoryMethod), depth, x -> null);
    }

    @Override
    public boolean isAbs() {
        return this.isSameHead(S.Abs, 2);
    }

    @Override
    public boolean isAllExpanded() {
        return !this.isEvalFlagOff(8192);
    }

    @Override
    public final boolean isAlternatives() {
        return this.isSameHeadSizeGE(S.Alternatives, 1);
    }

    @Override
    public final boolean isAnd() {
        return this.isSameHeadSizeGE(S.And, 3);
    }

    @Override
    public final boolean isArcCos() {
        return this.isSameHead(S.ArcCos, 2);
    }

    @Override
    public final boolean isArcCosh() {
        return this.isSameHead(S.ArcCosh, 2);
    }

    @Override
    public final boolean isArcSin() {
        return this.isSameHead(S.ArcSin, 2);
    }

    @Override
    public final boolean isArcSinh() {
        return this.isSameHead(S.ArcSinh, 2);
    }

    @Override
    public final boolean isArcTan() {
        return this.isSameHead(S.ArcTan, 2);
    }

    @Override
    public final boolean isArcTanh() {
        return this.isSameHead(S.ArcTanh, 2);
    }

    @Override
    public boolean isAST() {
        return true;
    }

    @Override
    public boolean isAST(IExpr header) {
        return this.head().equals(header);
    }

    @Override
    public boolean isAST(IExpr header, int length) {
        return this.head().equals(header) && length == this.size();
    }

    @Override
    public boolean isAST(IExpr header, int length, IExpr ... args) {
        if (this.isAST(header, length)) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null || this.get(i + 1).equals(args[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isAST(IExpr head, int minLength, int maxLength) {
        int size = this.size();
        return this.head().equals(head) && minLength <= size && maxLength >= size;
    }

    @Override
    public boolean isAST(String symbol) {
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
            String str;
            String name = symbol;
            if (name.length() > 0) {
                name = symbol.toLowerCase(Locale.ENGLISH);
            }
            if ((str = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(name)) != null) {
                name = str;
            }
            return this.head().toString().equals(name);
        }
        return this.head().toString().equals(symbol);
    }

    @Override
    public boolean isAST(String symbol, int length) {
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
            String name = symbol;
            if (name.length() > 0) {
                name = symbol.toLowerCase(Locale.ENGLISH);
            }
            return this.size() == length && this.head().toString().equals(name);
        }
        return this.size() == length && this.head().toString().equals(symbol);
    }

    @Override
    public boolean isAST0() {
        return this.size() == 1;
    }

    @Override
    public boolean isAST1() {
        return this.size() == 2;
    }

    @Override
    public boolean isAST2() {
        return this.size() == 3;
    }

    @Override
    public boolean isAST3() {
        return this.size() == 4;
    }

    @Override
    public boolean isASTSizeGE(IExpr header, int length) {
        return this.head().equals(header) && length <= this.size();
    }

    @Override
    public boolean isAtom() {
        return false;
    }

    @Override
    public final boolean isComplexInfinity() {
        return this.isSameHead(S.DirectedInfinity, 1);
    }

    @Override
    public boolean isCondition() {
        return this.head() == S.Condition && this.size() == 3;
    }

    @Override
    public boolean isConditionalExpression() {
        return this.head() == S.ConditionalExpression && this.size() == 3;
    }

    @Override
    public final boolean isConjugate() {
        return this.isSameHead(S.Conjugate, 2);
    }

    @Override
    public final boolean isCos() {
        return this.isSameHead(S.Cos, 2);
    }

    @Override
    public final boolean isCosh() {
        return this.isSameHead(S.Cosh, 2);
    }

    @Override
    public final boolean isDefer() {
        return this.isSameHead(S.Defer, 2);
    }

    @Override
    public final IAST[] isDerivative() {
        if (this.head().isAST()) {
            IAST headAST = (IAST)this.head();
            if (headAST.isSameHeadSizeGE(S.Derivative, 2)) {
                IAST[] result = new IAST[3];
                result[0] = headAST;
                result[1] = this;
                return result;
            }
            if (headAST.head().isSameHeadSizeGE(S.Derivative, 2)) {
                if (this.size() != ((IAST)headAST.head()).size()) {
                    return null;
                }
                IAST[] result = new IAST[]{(IAST)headAST.head(), headAST, this};
                return result;
            }
        }
        return null;
    }

    @Override
    public final IAST[] isDerivativeAST1() {
        if (this.head().isAST()) {
            IAST headAST = (IAST)this.head();
            if (headAST.isAST(S.Derivative, 2)) {
                IAST[] result = new IAST[3];
                result[0] = headAST;
                result[1] = this;
                return result;
            }
            if (headAST.head().isAST(S.Derivative, 2)) {
                if (this.size() != ((IAST)headAST.head()).size()) {
                    return null;
                }
                IAST[] result = new IAST[]{(IAST)headAST.head(), headAST, this};
                return result;
            }
        }
        return null;
    }

    @Override
    public final boolean isDirectedInfinity() {
        return this.isSameHead(S.DirectedInfinity, 1, 2);
    }

    @Override
    public final boolean isDirectedInfinity(IExpr x) {
        return this.isSameHead(S.DirectedInfinity, 2) && this.arg1().equals(x);
    }

    @Override
    public boolean isContinuousDistribution() {
        if (this.head().isBuiltInSymbol()) {
            IEvaluator evaluator = ((IBuiltInSymbol)this.head()).getEvaluator();
            return evaluator instanceof IContinuousDistribution;
        }
        return false;
    }

    @Override
    public boolean isDiscreteDistribution() {
        if (this.head().isBuiltInSymbol()) {
            IEvaluator evaluator = ((IBuiltInSymbol)this.head()).getEvaluator();
            return evaluator instanceof IDiscreteDistribution;
        }
        return false;
    }

    @Override
    public boolean isDistribution() {
        if (this.head().isBuiltInSymbol()) {
            IEvaluator evaluator = ((IBuiltInSymbol)this.head()).getEvaluator();
            return evaluator instanceof IDistribution;
        }
        return false;
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 1;
    }

    @Override
    public final boolean isEqual() {
        return this.isSameHead(S.Equal, 3);
    }

    @Override
    public final boolean isEvalFlagOff(int i) {
        return (this.fEvalFlags & i) == 0;
    }

    @Override
    public final boolean isEvalFlagOn(int i) {
        return (this.fEvalFlags & i) == i;
    }

    @Override
    public boolean isExcept() {
        return this.isAST((IExpr)S.Except, 2, 3);
    }

    @Override
    public boolean isExpanded() {
        return !this.isPlusTimesPower() || !this.isEvalFlagOff(4096);
    }

    @Override
    public boolean isFlatAST() {
        return this.topHead().hasFlatAttribute();
    }

    @Override
    public final boolean isFree(IPatternMatcher predicate, boolean heads) {
        return !this.has(predicate, heads);
    }

    @Override
    public final boolean isFree(Predicate<IExpr> predicate, boolean heads) {
        return !this.has(predicate, heads);
    }

    @Override
    public final boolean isFreeAST(IExpr pattern) {
        PatternMatcherEvalEngine matcher = new PatternMatcherEvalEngine(pattern, EvalEngine.get());
        return this.isFreeAST(matcher);
    }

    @Override
    public final boolean isFreeAST(Predicate<IExpr> predicate) {
        if (predicate.test(this)) {
            return false;
        }
        if (predicate.test(this.head())) {
            return false;
        }
        for (int i = 1; i < this.size(); ++i) {
            IExpr arg = this.get(i);
            if (!arg.isAST() || arg.isFreeAST(predicate)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isFreeAt(int position, IExpr pattern) {
        return this.get(position).isFree(pattern, true);
    }

    @Override
    public final boolean isFreeOfPatterns() {
        int evalFlags = this.getEvalFlags();
        if ((evalFlags & 8) == 8) {
            return true;
        }
        if ((evalFlags & 7) != 0) {
            return false;
        }
        if (this.isPatternMatchingFunction()) {
            this.addEvalFlags(1);
            return false;
        }
        boolean isFreeOfPatterns = true;
        for (int i = 0; i < this.size(); ++i) {
            IExpr temp = this.get(i);
            if (temp.isAST() && !temp.isFreeOfPatterns()) {
                isFreeOfPatterns = false;
                this.addEvalFlags(((IAST)temp).getEvalFlags() & 7);
                continue;
            }
            if (!(temp instanceof IPatternObject)) continue;
            isFreeOfPatterns = false;
            if (temp instanceof IPatternSequence) {
                if (temp.isPatternDefault()) {
                    this.addEvalFlags(4);
                }
                this.addEvalFlags(2);
                continue;
            }
            if (temp.isPatternDefault()) {
                this.addEvalFlags(4);
            }
            this.addEvalFlags(1);
        }
        if (isFreeOfPatterns) {
            this.addEvalFlags(8);
        }
        return isFreeOfPatterns;
    }

    @Override
    public final boolean isFunction() {
        return this.size() >= 2 && this.head().equals(S.Function);
    }

    @Override
    public final boolean isGEOrdered(IExpr obj) {
        return this.compareTo(obj) >= 0;
    }

    @Override
    public final boolean isGTOrdered(IExpr obj) {
        return this.compareTo(obj) > 0;
    }

    @Override
    public final boolean isHoldPatternOrLiteral() {
        return this.isSameHead(S.HoldPattern, 2) || this.isSameHead(S.Literal, 2);
    }

    @Override
    public final boolean isHoldAllCompleteAST() {
        return this.topHead().hasHoldAllCompleteAttribute();
    }

    @Override
    public final boolean isInfinity() {
        return this.equals(F.CInfinity);
    }

    @Override
    public boolean isBooleanFormula() {
        return this.head().isBooleanFormulaSymbol() && this.forAll((? super IExpr x) -> x.isBooleanFormula());
    }

    @Override
    public boolean isBooleanResult() {
        return this.head().isPredicateFunctionSymbol() || (this.head().isBooleanFormulaSymbol() || this.head().isComparatorFunctionSymbol()) && this.forAll((? super IExpr x) -> x.isBooleanResult());
    }

    @Override
    public boolean isBooleanFunction() {
        return this.head().isBooleanFormulaSymbol() && this.size() >= 2;
    }

    @Override
    public boolean isComparatorFunction() {
        return this.head().isComparatorFunctionSymbol() && this.size() > 2;
    }

    @Override
    public boolean isIntegerResult() {
        if (S.True.equals(AbstractAssumptions.assumeReal(this))) {
            return true;
        }
        ISymbol symbol = this.topHead();
        if (symbol.equals(S.Floor) || symbol.equals(S.Ceiling) || symbol.equals(S.IntegerPart)) {
            return true;
        }
        if (this.isPower() && this.exponent().isInteger() && this.base().isPositive()) {
            return this.base().isIntegerResult();
        }
        if (this.isPlus() || this.isTimes() || symbol.equals(S.Binomial) || symbol.equals(S.Factorial)) {
            for (int i = 1; i < this.size(); ++i) {
                if (this.get(i).isIntegerResult()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isInterval() {
        if (this.isSameHeadSizeGE(S.Interval, 2)) {
            for (int i = 1; i < this.size(); ++i) {
                if (this.get(i).isVector() == 2) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isInterval1() {
        return this.isSameHead(S.Interval, 2) && this.arg1().isAST(S.List, 3);
    }

    @Override
    public boolean isEmptyList() {
        return this.equals(F.CEmptyList);
    }

    @Override
    public boolean isNonEmptyList() {
        return this.isList() && this.size() > 1;
    }

    @Override
    public boolean isList() {
        return this.isSameHeadSizeGE(S.List, 1);
    }

    @Override
    public final boolean isListableAST() {
        return this.topHead().hasListableAttribute();
    }

    @Override
    public boolean isList(Predicate<IExpr> pred) {
        if (this.isList() && this.size() > 1) {
            for (int i = 1; i < this.size(); ++i) {
                if (pred.test(this.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isListOfLists() {
        if (this.isList() && this.size() > 1) {
            for (int i = 1; i < this.size(); ++i) {
                if (this.get(i).isList()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isListOfMatrices() {
        if (this.isList() && this.size() > 1) {
            for (int i = 1; i < this.size(); ++i) {
                if (this.get(i).isMatrix(false) != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public GraphType isListOfEdges() {
        if (this.head().equals(S.List)) {
            boolean directed = true;
            for (int i = 1; i < this.size(); ++i) {
                IExpr temp = this.get(i);
                if (temp.isAST2() && temp.head().isBuiltInSymbol()) {
                    IBuiltInSymbol symbol = (IBuiltInSymbol)temp.head();
                    if (symbol == S.DirectedEdge || symbol == S.Rule) continue;
                    if (symbol != S.UndirectedEdge && symbol != S.TwoWayRule) {
                        return null;
                    }
                    directed = false;
                    continue;
                }
                return null;
            }
            DefaultGraphType.Builder builder = new DefaultGraphType.Builder();
            if (directed) {
                return builder.directed().build();
            }
            return builder.undirected().build();
        }
        return null;
    }

    @Override
    public boolean isEdge() {
        if (this.isAST2() && this.head().isBuiltInSymbol()) {
            IBuiltInSymbol symbol = (IBuiltInSymbol)this.head();
            return symbol == S.DirectedEdge || symbol == S.UndirectedEdge || symbol == S.Rule || symbol == S.TwoWayRule;
        }
        return false;
    }

    @Override
    public boolean isListOfRules(boolean ignoreEmptySublists) {
        if (this.head().equals(S.List)) {
            for (int i = 1; i < this.size(); ++i) {
                if (this.get(i).isRuleAST() || ignoreEmptySublists && this.get(i).isEmptyList()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isListOfRulesOrAssociation(boolean ignoreEmptySublists) {
        if (this.isAssociation()) {
            return true;
        }
        if (this.head().equals(S.List)) {
            for (int i = 1; i < this.size(); ++i) {
                if (this.get(i).isRuleAST()) continue;
                if (this.get(i).isAssociation()) {
                    if (ignoreEmptySublists || this.get(i).size() > 1) continue;
                    return false;
                }
                if (ignoreEmptySublists && this.get(i).isEmptyList()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isListOfStrings() {
        if (this.isList() && this.size() > 1) {
            for (int i = 1; i < this.size(); ++i) {
                if (this.get(i).isString()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean isLog() {
        return this.isSameHead(S.Log, 2);
    }

    @Override
    public int[] isMatrix(boolean setMatrixFormat) {
        int[] dim;
        if (this.isEvalFlagOn(32)) {
            dim = new int[2];
            dim[0] = this.argSize();
            if (dim[0] > 0) {
                dim[1] = ((IAST)this.first()).argSize();
                return dim;
            }
        }
        if (this.isList()) {
            dim = new int[2];
            dim[0] = this.argSize();
            if (dim[0] > 0) {
                dim[1] = 0;
                if (this.arg1().isList()) {
                    dim[1] = ((IAST)this.arg1()).argSize();
                    for (int i = 1; i < this.size(); ++i) {
                        if (!this.get(i).isList()) {
                            return null;
                        }
                        IAST rowList = (IAST)this.get(i);
                        if (dim[1] != rowList.argSize()) {
                            return null;
                        }
                        for (int j = 1; j < rowList.size(); ++j) {
                            if (!rowList.get(j).isList()) continue;
                            return null;
                        }
                    }
                    if (setMatrixFormat && (dim[0] > 1 || dim[1] > 0)) {
                        this.addEvalFlags(32);
                    }
                    return dim;
                }
            }
        }
        return null;
    }

    @Override
    public int[] isMatrixIgnore() {
        int[] dim;
        if (this.isEvalFlagOn(32)) {
            dim = new int[2];
            dim[0] = this.argSize();
            if (dim[0] > 0) {
                dim[1] = ((IAST)this.first()).argSize();
                return dim;
            }
        }
        if (this.isList()) {
            dim = new int[2];
            dim[0] = this.argSize();
            if (dim[0] > 0) {
                dim[1] = -1;
                for (int i = 1; i < this.size(); ++i) {
                    IExpr arg = this.get(i);
                    if (arg.isList()) {
                        if (dim[1] < 0) {
                            dim[1] = ((IAST)arg).argSize();
                            continue;
                        }
                        if (dim[1] == ((IAST)arg).argSize()) continue;
                        return null;
                    }
                    dim[0] = dim[0] - 1;
                }
                if (dim[0] == 0) {
                    return null;
                }
                return dim;
            }
        }
        return null;
    }

    @Override
    public boolean isMember(IExpr pattern, boolean heads, IVisitorBoolean visitor) {
        if (visitor != null) {
            return IASTMutable.super.isMember(pattern, heads, visitor);
        }
        PatternMatcher predicate = pattern.isSymbol() || pattern.isNumber() || pattern.isString() ? x -> x.equals(pattern) : new PatternMatcher(pattern);
        return this.exists(predicate, heads ? 0 : 1);
    }

    @Override
    public final boolean isModule() {
        return this.head() == S.Module && this.size() == 3;
    }

    @Override
    public final boolean isModuleOrWithCondition() {
        if (this.head() == S.With && this.size() >= 3 || this.head() == S.Module && this.size() == 3) {
            return this.last().isCondition() || this.last().isModuleOrWithCondition();
        }
        return false;
    }

    @Override
    public boolean isNegative() {
        IExpr result;
        if (this.isNumericFunction(true) && (result = EvalEngine.get().evalN(this)).isReal()) {
            return result.isNegative();
        }
        return false;
    }

    @Override
    public boolean isNegativeInfinity() {
        return this.equals(F.CNInfinity);
    }

    @Override
    public boolean isNegativeResult() {
        if (this.isDirectedInfinity()) {
            return this.isNegativeInfinity();
        }
        return AbstractAssumptions.isNegativeResult(this);
    }

    @Override
    public boolean isNonNegativeResult() {
        if (this.isDirectedInfinity()) {
            return this.isInfinity();
        }
        return AbstractAssumptions.isNonNegativeResult(this);
    }

    @Override
    public final boolean isNot() {
        return this.size() == 2 && this.head().equals(S.Not);
    }

    @Override
    public boolean isNumericArgument() {
        if (this.isEvalFlagOn(65536)) {
            return this.forAll((? super IExpr x) -> x.isNumericFunction(true) || x.isList() && ((IAST)x).forAll((? super IExpr y) -> y.isNumericFunction(true)));
        }
        return this.isAST(S.Interval) && this.forAll((? super IExpr x) -> x.isNumericArgument() || x.isList() && ((IAST)x).forAll((? super IExpr y) -> y.isNumericArgument()));
    }

    @Override
    public boolean isNumericFunction(boolean allowList) {
        int evalFlags = this.getEvalFlags();
        if ((evalFlags & 0x3C00000) != 0) {
            if (allowList) {
                if ((evalFlags & 0x1000000) == 0x1000000) {
                    return true;
                }
                if ((evalFlags & 0x2000000) == 0x2000000) {
                    return false;
                }
            } else {
                if ((evalFlags & 0x400000) == 0x400000) {
                    return true;
                }
                if ((evalFlags & 0x800000) == 0x800000) {
                    return false;
                }
            }
        }
        if (allowList) {
            if (this.head().isSymbol() && ((ISymbol)this.head()).isNumericFunctionAttribute() || this.isList()) {
                boolean forAll = this.forAll((? super IExpr x) -> x.isNumericFunction(allowList), 1);
                this.addEvalFlags(forAll ? 0x1000000 : 0x2000000);
                return forAll;
            }
        } else if (this.head().isSymbol() && ((ISymbol)this.head()).isNumericFunctionAttribute()) {
            boolean forAll = this.forAll((? super IExpr x) -> x.isNumericFunction(allowList), 1);
            this.addEvalFlags(forAll ? 0x400000 : 0x800000);
            return forAll;
        }
        return false;
    }

    @Override
    public boolean isNumericFunction(VariablesSet varSet) {
        if (this.head().isSymbol() && ((ISymbol)this.head()).isNumericFunctionAttribute() || this.isList()) {
            return this.forAll((? super IExpr x) -> x.isNumericFunction(varSet));
        }
        return false;
    }

    @Override
    public boolean isNumericFunction(IExpr expr) {
        if (this.head().isSymbol() && ((ISymbol)this.head()).isNumericFunctionAttribute() || this.isList()) {
            return this.forAll((? super IExpr x) -> x.isNumericFunction(expr));
        }
        return false;
    }

    @Override
    public boolean isNumericFunction(Function<IExpr, String> list) {
        if (this.head().isSymbol() && ((ISymbol)this.head()).isNumericFunctionAttribute() || this.isList() || list.apply(this) != null) {
            return this.forAll((? super IExpr x) -> x.isNumericFunction(list));
        }
        return IASTMutable.super.isNumericFunction(list);
    }

    @Override
    public boolean isNumericMode() {
        ISymbol symbol = this.topHead();
        if (this.isList() || symbol.isNumericFunctionAttribute()) {
            for (int i = 1; i < this.size(); ++i) {
                if (!this.get(i).isNumericMode()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isOneIdentityAST1() {
        return this.isAST1() && this.topHead().hasOneIdentityAttribute();
    }

    @Override
    public final boolean isOptional() {
        return this.isAST((IExpr)S.Optional, 2, 3);
    }

    @Override
    public final boolean isOr() {
        return this.isSameHeadSizeGE(S.Or, 3);
    }

    @Override
    public final boolean isOrderlessAST() {
        return this.topHead().hasOrderlessAttribute();
    }

    @Override
    public boolean isPatternDefault() {
        return this.isOptional();
    }

    @Override
    public final boolean isPatternExpr() {
        return (this.fEvalFlags & 7) != 0;
    }

    @Override
    public final boolean isPatternTest() {
        return this.isAST(S.PatternTest, 3);
    }

    @Override
    public int[] isPiecewise() {
        if (this.isSameHead(S.Piecewise, 2, 3) && this.arg1().isList()) {
            int[] result = this.arg1().isMatrix(false);
            if (result != null && (result[0] <= 0 || result[1] != 2)) {
                return null;
            }
            return result;
        }
        return null;
    }

    @Override
    public boolean isPlus() {
        return this.head() == S.Plus && 3 <= this.size();
    }

    @Override
    public boolean isPlus2() {
        return this.head() == S.Plus && 3 == this.size();
    }

    @Override
    public boolean isPlus3() {
        return this.head() == S.Plus && 4 == this.size();
    }

    @Override
    public boolean isPlusTimesPower() {
        IExpr h = this.head();
        if (h instanceof IBuiltInSymbol) {
            if (4 <= this.size()) {
                return h == S.Plus || h == S.Times;
            }
            if (3 == this.size()) {
                return h == S.Plus || h == S.Times || h == S.Power;
            }
        }
        return false;
    }

    @Override
    public final boolean isPolynomial(IAST variables) {
        if (this.isPlus() || this.isTimes() || this.isPower()) {
            IExpr expr = F.evalExpandAll(this);
            ExprPolynomialRing ring = new ExprPolynomialRing(variables);
            return ring.isPolynomial(expr);
        }
        return false;
    }

    @Override
    public final boolean isPolynomial(IExpr variable) {
        return this.isPolynomial(F.list(variable));
    }

    @Override
    public boolean isPolynomialStruct() {
        if (this.head().isBuiltInSymbol() && !((ISymbol)this.head()).isNumericFunctionAttribute()) {
            return false;
        }
        return !this.exists((? super IExpr x) -> !x.isPolynomialStruct());
    }

    public final boolean isPolynomialOfMaxDegree(IAST variables, long maxDegree) {
        try {
            if (this.isPlus() || this.isTimes() || this.isPower()) {
                ExprPolynomialRing ring = new ExprPolynomialRing(variables);
                IExpr expr = F.evalExpandAll(this);
                ExprPolynomial poly = ring.create(expr);
                return poly.degree() <= maxDegree;
            }
        }
        catch (ArithmeticException | ClassCastException runtimeException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public final boolean isPolynomialOfMaxDegree(ISymbol variable, long maxDegree) {
        return this.isPolynomialOfMaxDegree(F.list(variable), maxDegree);
    }

    @Override
    public boolean isPositive() {
        IExpr result;
        if (this.isNumericFunction(true) && (result = EvalEngine.get().evalN(this)).isReal()) {
            return ((ISignedNumber)result).isPositive();
        }
        return false;
    }

    @Override
    public boolean isPositiveResult() {
        if (this.isDirectedInfinity()) {
            return this.isInfinity();
        }
        return AbstractAssumptions.isPositiveResult(this);
    }

    @Override
    public boolean isPower() {
        return this.isSameHead(S.Power, 3);
    }

    @Override
    public final boolean isPureFunction() {
        return this.size() == 2 && this.head().equals(S.Function);
    }

    @Override
    public final boolean isRationalResult() {
        ISymbol symbol = this.topHead();
        if (symbol.equals(S.Floor) || symbol.equals(S.Ceiling) || symbol.equals(S.IntegerPart)) {
            return true;
        }
        if (this.isPower() && this.arg2().isInteger() && this.arg2().isPositive()) {
            return this.arg1().isRationalResult();
        }
        if (this.isPlus() || this.isTimes() || symbol.equals(S.Binomial) || symbol.equals(S.Factorial)) {
            for (int i = 1; i < this.size(); ++i) {
                if (this.get(i).isRationalResult()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isRealMatrix() {
        if (this.isList()) {
            int[] dim = new int[2];
            dim[0] = this.argSize();
            if (dim[0] > 0) {
                dim[1] = 0;
                if (this.arg1().isList()) {
                    IAST row = (IAST)this.arg1();
                    dim[1] = row.argSize();
                    boolean containsNum = false;
                    for (int j = 1; j < row.size(); ++j) {
                        if (row.get(j).isReal()) {
                            if (!(row.get(j) instanceof INum)) continue;
                            if (!(row.get(j) instanceof Num)) {
                                return false;
                            }
                            containsNum = true;
                            continue;
                        }
                        return false;
                    }
                    for (int i = 2; i < this.size(); ++i) {
                        if (!this.get(i).isList()) {
                            return false;
                        }
                        row = (IAST)this.get(i);
                        if (dim[1] != row.argSize()) {
                            return false;
                        }
                        for (int j = 1; j < row.size(); ++j) {
                            if (row.get(j).isReal()) {
                                if (!(row.get(j) instanceof INum)) continue;
                                if (!(row.get(j) instanceof Num)) {
                                    return false;
                                }
                                containsNum = true;
                                continue;
                            }
                            return false;
                        }
                    }
                    this.addEvalFlags(32);
                    return containsNum;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isRealResult() {
        if (S.True.equals(AbstractAssumptions.assumeReal(this))) {
            return true;
        }
        IExpr head = this.head();
        if (this.size() == 2 && S.Cos.equals(head) && S.Sin.equals(head)) {
            return this.arg1().isRealResult();
        }
        ISignedNumber e = this.evalReal();
        if (e != null) {
            return true;
        }
        if (this.isPlus() || this.isTimes()) {
            for (int i = 1; i < this.size(); ++i) {
                if (this.get(i).isRealResult()) continue;
                return false;
            }
            return true;
        }
        if (!(!this.isPower() || this.exponent().isZero() && this.base().isZero())) {
            if (!this.arg1().isRealResult()) {
                return false;
            }
            if (this.arg1().isNegativeResult()) {
                return false;
            }
            return this.arg2().isRealResult();
        }
        return this.isInfinity() || this.isNegativeInfinity();
    }

    @Override
    public boolean isRealVector() {
        if (this.isList()) {
            boolean containsNum = false;
            for (int i = 1; i < this.size(); ++i) {
                if (this.get(i).isReal()) {
                    if (!(this.get(i) instanceof INum)) continue;
                    if (!(this.get(i) instanceof Num)) {
                        return false;
                    }
                    containsNum = true;
                    continue;
                }
                return false;
            }
            return containsNum;
        }
        return false;
    }

    @Override
    public boolean isRule() {
        return this.head().equals(S.Rule) && this.size() == 3;
    }

    @Override
    public boolean isRuleAST() {
        return (this.head().equals(S.Rule) || this.head().equals(S.RuleDelayed)) && this.size() == 3;
    }

    @Override
    public boolean isRuleDelayed() {
        return this.head().equals(S.RuleDelayed) && this.size() == 3;
    }

    @Override
    public boolean isSame(IExpr expression) {
        return this.equals(expression);
    }

    @Override
    public boolean isSame(IExpr expression, double epsilon) {
        return this.equals(expression);
    }

    public boolean isSameHead(ISymbol head) {
        return this.head() == head;
    }

    public boolean isSameHead(ISymbol head, int length) {
        return this.head() == head && length == this.size();
    }

    public boolean isSameHead(ISymbol head, int minLength, int maxLength) {
        int size = this.size();
        return this.head().equals(head) && minLength <= size && maxLength >= size;
    }

    @Override
    public final boolean isSequence() {
        return this.isSameHeadSizeGE(S.Sequence, 1);
    }

    @Override
    public final boolean isSin() {
        return this.isSameHead(S.Sin, 2);
    }

    @Override
    public final boolean isSinh() {
        return this.isSameHead(S.Sinh, 2);
    }

    @Override
    public final boolean isSlot() {
        return this.isSameHead(S.Slot, 2) && (this.arg1().isInteger() || this.arg1().isString());
    }

    @Override
    public final boolean isSlotSequence() {
        return this.isSameHead(S.SlotSequence, 2) && this.arg1().isInteger();
    }

    @Override
    public final int[] isSpan(int size) {
        int[] result = null;
        if (this.isSameHead(S.Span, 3, 4)) {
            int index2;
            int step = 1;
            if (this.isAST3()) {
                step = Validate.checkIntType(this, 3, Integer.MIN_VALUE);
            }
            int index1 = Validate.checkIntType(this, 1, Integer.MIN_VALUE);
            if (this.arg2().equals(S.All)) {
                index2 = size - 1;
                if (step < 0) {
                    int tempIndx = index1;
                    index1 = index2;
                    index2 = tempIndx;
                }
            } else {
                index2 = Validate.checkIntType(this, 2, Integer.MIN_VALUE);
            }
            int start = index1;
            if (index1 < 0) {
                start = size + index1;
            }
            int last = index2;
            if (index2 < 0) {
                last = size + index2;
            }
            result = new int[]{start, last, step};
            return result;
        }
        return null;
    }

    @Override
    public final boolean isSubscript() {
        return this.isSameHead(S.Subscript, 3) && this.arg1().isVariable();
    }

    @Override
    public final boolean isTan() {
        return this.isSameHead(S.Tan, 2);
    }

    @Override
    public final boolean isTanh() {
        return this.isSameHead(S.Tanh, 2);
    }

    @Override
    public boolean isTimes() {
        return this.head() == S.Times && 3 <= this.size();
    }

    @Override
    public boolean isTimes2() {
        return this.head() == S.Times && 3 == this.size();
    }

    @Override
    public boolean isTimes3() {
        return this.head() == S.Times && 4 == this.size();
    }

    @Override
    public boolean isTrigFunction() {
        int id = this.headID();
        if (id >= 0) {
            if (this.size() == 2) {
                return id == 289 || id == 78 || id == 294 || id == 80 || id == 303 || id == 82 || id == 1165 || id == 85 || id == 1190 || id == 87 || id == 1310 || id == 89;
            }
            if (this.size() == 3) {
                return id == 89;
            }
        }
        return false;
    }

    @Override
    public boolean isHyperbolicFunction() {
        int id = this.headID();
        if (id >= 0 && this.size() == 2) {
            return id == 291 || id == 79 || id == 295 || id == 81 || id == 304 || id == 83 || id == 1166 || id == 86 || id == 1195 || id == 88 || id == 1311 || id == 90;
        }
        return false;
    }

    @Override
    public final boolean isPatternMatchingFunction() {
        int id = this.headID();
        if (id >= 61 && id <= 1123 && this.size() >= 2) {
            return id == 604 || id == 797 || id == 267 || id == 61 || id == 438 || id == 257 || id == 1096 || id == 955 || id == 986 || id == 1122 || id == 1123;
        }
        return false;
    }

    @Override
    public final boolean isUnevaluated() {
        return this.isSameHead(S.Unevaluated, 2);
    }

    @Override
    public boolean isUnit() {
        if (this.isZero()) {
            return false;
        }
        if (this.isNumber()) {
            return true;
        }
        if (this.isConstantAttribute()) {
            return true;
        }
        IExpr temp = F.eval(F.Times((IExpr)this, (IExpr)F.Power((IExpr)this, F.CN1)));
        return temp.isOne();
    }

    @Override
    public final boolean isValue() {
        ISymbol symbol;
        EvalEngine engine = EvalEngine.get();
        IExpr result = engine.evalAttributes(symbol = this.topHead(), this);
        if (result.isPresent()) {
            if (result.isAST(symbol)) {
                return engine.evalRules(symbol, (IAST)result).isPresent();
            }
            return false;
        }
        return engine.evalRules(symbol, this).isPresent();
    }

    @Override
    public final boolean isVariable() {
        if (this.headID() >= 0) {
            return this.isSlot() || this.isSubscript();
        }
        if (!this.head().isSymbol()) {
            return false;
        }
        for (int i = 1; i < this.size(); ++i) {
            IExpr arg = this.get(i);
            if (arg.isVariable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int isVector() {
        if (this.isEvalFlagOn(64)) {
            return this.argSize();
        }
        if (this.isList()) {
            int length = this.argSize();
            if (length > 0) {
                if (this.arg1().isList()) {
                    return -1;
                }
                for (int i = 2; i < this.size(); ++i) {
                    if (!this.get(i).isList()) continue;
                    return -1;
                }
            }
            this.addEvalFlags(64);
            return length;
        }
        return -1;
    }

    @Override
    public boolean isNumericAST() {
        return this.exists((? super IExpr x) -> x.isInexactNumber());
    }

    @Override
    public final boolean isWith() {
        return this.head() == S.With && this.size() >= 3;
    }

    @Override
    public boolean isPossibleZero(boolean fastTest) {
        return PredicateQ.isPossibleZeroQ(this, fastTest, EvalEngine.get());
    }

    @Override
    public final Iterator<IExpr> iterator() {
        ASTIterator i = new ASTIterator();
        i._table = this;
        i._start = 1;
        i._end = this.size();
        i._nextIndex = 1;
        i._currentIndex = 0;
        return i;
    }

    @Override
    public IExpr last() {
        if (this.size() < 2) {
            return F.NIL;
        }
        return this.get(this.argSize());
    }

    @Override
    public final int lastIndexOf(IExpr object) {
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            if (!object.equals(this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final long leafCount() {
        return this.accept(StructureFunctions.leafCountVisitor());
    }

    @Override
    public long leafCountSimplify() {
        long count = 0L;
        for (int i = 0; i < this.size(); ++i) {
            count += this.get(i).leafCountSimplify();
        }
        return count;
    }

    @Override
    public IExpr[] linear(IExpr variable) {
        int size = this.size();
        int counter = 0;
        if (this.isPlus()) {
            IASTAppendable plusClone = this.copyAppendable();
            IExpr[] subLinear = null;
            int j = 1;
            for (int i = 1; i < size; ++i) {
                if (this.get(i).isFree(variable, true)) {
                    ++j;
                    continue;
                }
                if (counter > 0 || this.get(i).isPlus()) {
                    return null;
                }
                subLinear = this.get(i).linear(variable);
                if (subLinear != null) {
                    ++counter;
                    plusClone.remove(j);
                    continue;
                }
                return null;
            }
            if (subLinear != null) {
                return new IExpr[]{plusClone.oneIdentity0(), subLinear[1]};
            }
            return new IExpr[]{plusClone.oneIdentity0(), F.C0};
        }
        if (this.isTimes()) {
            IASTAppendable timesClone = this.copyAppendable();
            int j = 1;
            for (int i = 1; i < size; ++i) {
                if (this.get(i).isFree(variable, true)) {
                    ++j;
                    continue;
                }
                if (this.get(i).equals(variable)) {
                    if (counter > 0) {
                        return null;
                    }
                    ++counter;
                    timesClone.remove(j);
                    continue;
                }
                return null;
            }
            return new IExpr[]{F.C0, timesClone.oneIdentity1()};
        }
        if (this.equals(variable)) {
            return new IExpr[]{F.C0, F.C1};
        }
        if (this.isFree(variable, true)) {
            return new IExpr[]{this, F.C0};
        }
        return null;
    }

    @Override
    public IExpr[] linearPower(IExpr variable) {
        int size = this.size();
        int counter = 0;
        if (this.isPlus()) {
            IASTAppendable plusClone = this.copyAppendable();
            IExpr[] subLinear = null;
            int j = 1;
            for (int i = 1; i < size; ++i) {
                if (this.get(i).isFree(variable, true)) {
                    ++j;
                    continue;
                }
                if (counter > 0 || this.get(i).isPlus()) {
                    return null;
                }
                subLinear = this.get(i).linearPower(variable);
                if (subLinear != null) {
                    ++counter;
                    plusClone.remove(j);
                    continue;
                }
                return null;
            }
            if (subLinear != null) {
                return new IExpr[]{plusClone.oneIdentity0(), subLinear[1], subLinear[2]};
            }
            return new IExpr[]{plusClone.oneIdentity0(), F.C0, F.C1};
        }
        if (this.isTimes()) {
            IInteger exp = F.C1;
            IASTAppendable timesClone = this.copyAppendable();
            int j = 1;
            for (int i = 1; i < size; ++i) {
                if (this.get(i).isFree(variable, true)) {
                    ++j;
                    continue;
                }
                if (this.get(i).equals(variable)) {
                    if (counter > 0) {
                        return null;
                    }
                    ++counter;
                    timesClone.remove(j);
                    continue;
                }
                if (this.get(i).isPower()) {
                    if (counter > 0) {
                        return null;
                    }
                    IAST power = (IAST)this.get(i);
                    if (power.base().equals(variable) && power.exponent().isInteger()) {
                        exp = (IInteger)power.exponent();
                        ++counter;
                        timesClone.remove(j);
                        continue;
                    }
                }
                return null;
            }
            return new IExpr[]{F.C0, timesClone.oneIdentity1(), exp};
        }
        if (this.isPower() && this.base().equals(variable) && this.exponent().isInteger()) {
            return new IExpr[]{F.C0, F.C1, this.exponent()};
        }
        if (this.equals(variable)) {
            return new IExpr[]{F.C0, F.C1, F.C1};
        }
        if (this.isFree(variable, true)) {
            return new IExpr[]{this, F.C0, F.C1};
        }
        return null;
    }

    @Override
    public IExpr lower() {
        if (this.isInterval1()) {
            return ((IAST)this.arg1()).arg1();
        }
        return F.NIL;
    }

    @Override
    public IAST map(Function<IExpr, IExpr> function) {
        return this.map(function, 1);
    }

    @Override
    public IAST map(Function<IExpr, IExpr> function, int startOffset) {
        IExpr temp;
        int i;
        IASTAppendable result = F.NIL;
        int size = this.size();
        for (i = startOffset; i < size; ++i) {
            temp = function.apply(this.get(i));
            if (!temp.isPresent()) continue;
            result = this.copyAppendable();
            result.set(i++, temp);
            break;
        }
        if (result.isPresent()) {
            while (i < size) {
                temp = function.apply(this.get(i));
                if (temp.isPresent()) {
                    result.set(i, temp);
                }
                ++i;
            }
        }
        return result.orElse(this);
    }

    @Override
    public IAST mapReverse(Function<IExpr, IExpr> function) {
        IASTMutable result = this.copy();
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            IExpr arg = this.get(i);
            IExpr value = function.apply(arg);
            result.set(size - i, value.orElse(arg));
        }
        return result;
    }

    @Override
    public final IAST map(IASTAppendable resultAST, IAST secondAST, BiFunction<IExpr, IExpr, IExpr> function) {
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            resultAST.append(function.apply(this.get(i), secondAST.get(i)));
        }
        return resultAST;
    }

    @Override
    public IASTAppendable map(IASTAppendable astResult, IUnaryIndexFunction<IExpr, IExpr> function) {
        for (int i = 1; i < this.size(); ++i) {
            astResult.append(function.apply(i, this.get(i)));
        }
        return astResult;
    }

    @Override
    public IAST map(IASTMutable clonedResultAST, Function<IExpr, IExpr> function) {
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            IExpr temp = function.apply(this.get(i));
            if (temp == null) continue;
            clonedResultAST.set(i, temp);
        }
        return clonedResultAST;
    }

    @Override
    public final IAST map(IExpr head, Function<IExpr, IExpr> function) {
        return this.map(this.setAtCopy(0, head), function);
    }

    @Override
    public IAST mapLeft(IASTAppendable list, BiFunction<IExpr, IExpr, IExpr> binaryFunction, IExpr leftArg) {
        for (int i = 1; i < this.size(); ++i) {
            IExpr functionResult = binaryFunction.apply(leftArg, this.get(i));
            if (!functionResult.isPresent()) {
                return F.NIL;
            }
            list.append(functionResult);
        }
        return list;
    }

    @Override
    public IExpr mapMatrixColumns(int[] dim, Function<IExpr, IExpr> f) {
        int rowSize = this.size();
        int columnSize = dim[1];
        IASTAppendable result = F.ListAlloc(columnSize++);
        for (int j = 1; j < columnSize; ++j) {
            IASTAppendable row = F.ListAlloc(rowSize);
            int i = 1;
            while (i < rowSize) {
                row.append(this.getPart(i++, j));
            }
            result.append(f.apply(row));
        }
        return result;
    }

    @Override
    public IAST mapRight(IASTAppendable list, BiFunction<IExpr, IExpr, IExpr> binaryFunction, IExpr rightArg) {
        for (int i = 1; i < this.size(); ++i) {
            IExpr functionResult = binaryFunction.apply(this.get(i), rightArg);
            if (!functionResult.isPresent()) {
                return F.NIL;
            }
            list.append(functionResult);
        }
        return list;
    }

    @Override
    public final IASTMutable mapThread(IAST replacement, int position) {
        Function<IExpr, IExpr> function = x -> replacement.setAtCopy(position, (IExpr)x);
        return (IASTMutable)this.map(function, 1);
    }

    @Override
    public final IASTMutable mapThreadEvaled(EvalEngine engine, IAST replacement, int position) {
        Function<IExpr, IExpr> function = x -> engine.evaluate(replacement.setAtCopy(position, (IExpr)x));
        return (IASTMutable)this.map(function, 1);
    }

    @Override
    public final IASTMutable mapThread(Function<IExpr, IExpr> function) {
        return (IASTMutable)this.map(function, 1);
    }

    @Override
    public IASTAppendable mapThreadEvaled(EvalEngine engine, IASTAppendable appendAST, IAST replacement, int position) {
        Function<IExpr, IExpr> function = x -> engine.evaluate(replacement.setAtCopy(position, (IExpr)x));
        for (int i = 1; i < this.size(); ++i) {
            IExpr temp = function.apply(this.get(i));
            if (temp == null) continue;
            appendAST.append(temp);
        }
        return appendAST;
    }

    @Override
    public final IExpr negative() {
        return this.opposite();
    }

    @Override
    public IExpr normal(boolean nilIfUnevaluated) {
        if (this.isConditionalExpression()) {
            return this.arg1();
        }
        IAST temp = this.map(x -> x.normal(nilIfUnevaluated));
        if (temp.isPresent() && temp != this) {
            return temp;
        }
        return nilIfUnevaluated ? F.NIL : this;
    }

    @Override
    public IExpr oneIdentity(IExpr defaultValue) {
        if (this.size() > 2) {
            return this;
        }
        if (this.size() == 2) {
            return this.arg1();
        }
        return defaultValue;
    }

    @Override
    public IExpr opposite() {
        int lhsOrdinal;
        int n = lhsOrdinal = this.head() instanceof IBuiltInSymbol ? ((IBuiltInSymbol)this.head()).ordinal() : -1;
        if (lhsOrdinal > 0) {
            if (this.isTimes()) {
                IExpr arg1 = this.arg1();
                if (arg1.isNumber()) {
                    if (arg1.isMinusOne()) {
                        if (this.size() == 3) {
                            return this.arg2();
                        }
                        return this.rest();
                    }
                    return this.setAtCopy(1, ((INumber)arg1).negate());
                }
                IASTAppendable timesAST = this.copyAppendable();
                timesAST.append(1, F.CN1);
                return timesAST;
            }
            if (this.isNegativeInfinity()) {
                return F.CInfinity;
            }
            if (this.isInfinity()) {
                return F.CNInfinity;
            }
            if (this.isPlus()) {
                return this.map((IExpr x) -> x.negate(), 1);
            }
        }
        return F.Times((IExpr)F.CN1, (IExpr)this);
    }

    @Override
    public IExpr optional() {
        Short id = S.GLOBAL_IDS_MAP.get(this);
        if (id != null) {
            return new ExprID(id);
        }
        return this;
    }

    @Override
    public IAST orElse(IAST other) {
        return this;
    }

    @Override
    public final IAST partition(ISymbol operator, Predicate<? super IExpr> predicate, IExpr init1, IExpr init2, ISymbol combiner, ISymbol action) {
        if (this.head().equals(operator)) {
            IASTAppendable result = F.ast((IExpr)action, 3);
            int size = this.size();
            int newSize = size / 2;
            newSize = newSize <= 4 ? 5 : (newSize += 4);
            IASTAppendable yesAST = F.ast((IExpr)combiner, newSize);
            IASTAppendable noAST = F.ast((IExpr)combiner, newSize);
            this.forEach(size, (? super IExpr x) -> {
                if (predicate.test((IExpr)x)) {
                    yesAST.append((IExpr)x);
                } else {
                    noAST.append((IExpr)x);
                }
            });
            if (yesAST.size() > 1) {
                result.append(F.eval(yesAST));
            } else {
                result.append(init1);
            }
            if (noAST.size() > 1) {
                result.append(F.eval(noAST));
            } else {
                result.append(init2);
            }
            return result;
        }
        return F.NIL;
    }

    @Override
    public final IAST partitionPlus(Predicate<? super IExpr> predicate, IExpr initYes, IExpr initNo, ISymbol action) {
        return this.partition(S.Plus, predicate, initYes, initNo, S.Plus, S.List);
    }

    @Override
    public final IAST partitionTimes(Predicate<? super IExpr> predicate, IExpr initYes, IExpr initNo, ISymbol action) {
        return this.partition(S.Times, predicate, initYes, initNo, S.Times, S.List);
    }

    @Override
    public final int patternHashCode() {
        if (this.size() > 1) {
            int attr = this.topHead().getAttributes() & 0xC;
            if (attr != 0) {
                if (ISymbol.hasOrderlessFlatAttribute(attr)) {
                    return 17 * this.head().hashCode();
                }
                if (ISymbol.hasFlatAttribute(attr)) {
                    if (this.arg1() instanceof IAST) {
                        return 31 * this.head().hashCode() + ((IAST)this.arg1()).head().hashCode();
                    }
                    return 37 * this.head().hashCode() + this.arg1().hashCode();
                }
                return 17 * this.head().hashCode() + this.size();
            }
            if (this.arg1().isPresent()) {
                if (this.arg1() instanceof IAST) {
                    IAST ast1 = (IAST)this.arg1();
                    return 31 * this.head().hashCode() + ast1.head().hashCode() + this.size();
                }
                return 37 * this.head().hashCode() + this.arg1().hashCode() + this.size();
            }
        }
        if (this.size() == 1) {
            return 17 * this.head().hashCode();
        }
        return 41;
    }

    @Override
    public final IASTAppendable prependClone(IExpr expr) {
        return this.appendAtClone(1, expr);
    }

    public Object putProperty(IAST.PROPERTY key, Object value) {
        Cache<IAST, EnumMap<IAST.PROPERTY, Object>> propertyCache = AbstractAST.propertyCache();
        EnumMap<IAST.PROPERTY, Object> map = (EnumMap<IAST.PROPERTY, Object>)propertyCache.getIfPresent((Object)this);
        if (map == null) {
            map = new EnumMap<IAST.PROPERTY, Object>(IAST.PROPERTY.class);
            propertyCache.put((Object)this, map);
        }
        return map.put(key, value);
    }

    @Override
    public IASTAppendable remove(Predicate<? super IExpr> predicate) {
        for (int indx = 1; indx < this.size(); ++indx) {
            if (!predicate.test(this.get(indx))) continue;
            IASTAppendable removed = this.removeAtClone(indx);
            while (indx < removed.size()) {
                if (predicate.test(removed.get(indx))) {
                    removed.remove(indx);
                    continue;
                }
                ++indx;
            }
            return removed;
        }
        return F.NIL;
    }

    @Override
    public final IASTAppendable removeAtClone(int position) {
        IASTAppendable ast = this.copyAppendable();
        ast.remove(position);
        return ast;
    }

    @Override
    public IAST splice(int index, int howMany, IExpr ... items) {
        IASTAppendable ast = this.copyAppendable();
        if (howMany > 0) {
            ast.removeRange(index, index + howMany);
        }
        for (int i = 0; i < items.length; ++i) {
            ast.append(index++, items[i]);
        }
        return ast;
    }

    @Override
    public IASTMutable removeAtCopy(int position) {
        int size = this.size();
        if (position < size && !this.isAssociation()) {
            switch (size) {
                case 2: {
                    switch (position) {
                        case 0: {
                            return F.headAST0(this.arg1());
                        }
                        case 1: {
                            return F.headAST0(this.head());
                        }
                    }
                }
                case 3: {
                    switch (position) {
                        case 0: {
                            return F.unaryAST1(this.arg1(), this.arg2());
                        }
                        case 1: {
                            return F.unaryAST1(this.head(), this.arg2());
                        }
                        case 2: {
                            return F.unaryAST1(this.head(), this.arg1());
                        }
                    }
                }
                case 4: {
                    switch (position) {
                        case 0: {
                            return F.binaryAST2(this.arg1(), this.arg2(), this.arg3());
                        }
                        case 1: {
                            return F.binaryAST2(this.head(), this.arg2(), this.arg3());
                        }
                        case 2: {
                            return F.binaryAST2(this.head(), this.arg1(), this.arg3());
                        }
                        case 3: {
                            return F.binaryAST2(this.head(), this.arg1(), this.arg2());
                        }
                    }
                }
            }
        }
        IASTAppendable ast = this.copyAppendable();
        ast.remove(position);
        return ast;
    }

    @Override
    public IASTAppendable reverse(IASTAppendable resultList) {
        for (int i = this.argSize(); i >= 1; --i) {
            resultList.append(this.get(i));
        }
        return resultList;
    }

    @Override
    public IExpr rewrite(int functionID) {
        IEvaluator evaluator;
        int headID = this.headID();
        if (headID > 0 && (evaluator = ((IBuiltInSymbol)this.head()).getEvaluator()) instanceof IRewrite) {
            return ((IRewrite)((Object)evaluator)).rewrite(this, EvalEngine.get(), functionID);
        }
        return F.NIL;
    }

    @Override
    public IAST rotateLeft(IASTAppendable resultList, int n) {
        int n1;
        int i;
        int size = this.size();
        for (i = n1 = n + 1; i < size; ++i) {
            resultList.append(this.get(i));
        }
        if (n <= size) {
            for (i = 1; i < n1; ++i) {
                resultList.append(this.get(i));
            }
        }
        return resultList;
    }

    @Override
    public IAST rotateRight(IASTAppendable resultList, int n) {
        if (n <= this.size()) {
            int i;
            for (i = this.size() - n; i < this.size(); ++i) {
                resultList.append(this.get(i));
            }
            for (i = 1; i < this.size() - n; ++i) {
                resultList.append(this.get(i));
            }
        }
        return resultList;
    }

    @Override
    public IASTAppendable setAtClone(int position, IExpr expr) {
        IASTAppendable ast = this.copyAppendable();
        ast.set(position, expr);
        return ast;
    }

    @Override
    public final void setEvalFlags(int i) {
        this.fEvalFlags = i;
    }

    @Override
    public IExpr setPart(IExpr value, int ... positions) {
        IExpr expr = this;
        int size = positions.length;
        for (int i = 0; i < size && expr.isAST(); ++i) {
            IASTMutable ast = expr;
            expr = ast.get(positions[i]);
            if (i != size - 1) continue;
            ast.set(positions[i], value);
            return expr;
        }
        return null;
    }

    @Override
    @Deprecated
    public final int signum() {
        IExpr temp;
        if (this.isTimes() && (temp = this.arg1()).isReal() && temp.isNegative()) {
            return -1;
        }
        return 1;
    }

    @Override
    public void sortInplace(Comparator<IExpr> comparator) {
        IExpr[] a = this.toArray();
        int end = a.length;
        if (Config.FUZZ_TESTING) {
            try {
                Arrays.sort(a, 1, this.size(), comparator);
                for (int j = 1; j < end; ++j) {
                    this.set(j, a[j]);
                }
            }
            catch (IllegalArgumentException iae) {
                LOGGER.error((Object)this, (Throwable)iae);
                throw iae;
            }
        } else {
            Arrays.sort(a, 1, this.size(), comparator);
            for (int j = 1; j < end; ++j) {
                this.set(j, a[j]);
            }
        }
    }

    @Override
    public Stream<IExpr> stream() {
        return Arrays.stream(this.toArray(), 1, this.size());
    }

    @Override
    public Stream<IExpr> stream(int startInclusive, int endExclusive) {
        return Arrays.stream(this.toArray(), startInclusive, endExclusive);
    }

    @Override
    public final IExpr timesDistributed(IExpr that) {
        if (that.isZero()) {
            return F.C0;
        }
        if (this.isPlus()) {
            IAST plus = this.map((IExpr x) -> x.times(that), 1);
            return F.eval(plus);
        }
        return F.eval(F.Times((IExpr)this, that));
    }

    @Override
    public double[][] toDoubleMatrix() {
        int[] dim = this.isMatrix();
        if (dim == null) {
            return null;
        }
        try {
            double[][] result = new double[dim[0]][dim[1]];
            for (int i = 1; i <= dim[0]; ++i) {
                IAST row = (IAST)this.get(i);
                for (int j = 1; j <= dim[1]; ++j) {
                    ISignedNumber signedNumber = row.get(j).evalReal();
                    if (signedNumber == null) {
                        return null;
                    }
                    result[i - 1][j - 1] = signedNumber.evalDouble();
                }
            }
            return result;
        }
        catch (ArgumentTypeException argumentTypeException) {
            return null;
        }
    }

    @Override
    public byte[][] toByteMatrix() {
        int[] dim = this.isMatrix();
        if (dim == null) {
            return null;
        }
        byte[][] result = new byte[dim[0]][dim[1]];
        for (int i = 1; i <= dim[0]; ++i) {
            IAST row = (IAST)this.get(i);
            for (int j = 1; j <= dim[1]; ++j) {
                int n = row.get(j).toIntDefault();
                if (n < 0 || n >= 256) {
                    return null;
                }
                result[i - 1][j - 1] = (byte)n;
            }
        }
        return result;
    }

    @Override
    public int[][] toIntMatrix() {
        int[] dim = this.isMatrix();
        if (dim == null) {
            return null;
        }
        int[][] result = new int[dim[0]][dim[1]];
        for (int i = 1; i <= dim[0]; ++i) {
            IAST row = (IAST)this.get(i);
            for (int j = 1; j <= dim[1]; ++j) {
                int n = row.get(j).toIntDefault();
                if (n == Integer.MIN_VALUE) {
                    return null;
                }
                result[i - 1][j - 1] = n;
            }
        }
        return result;
    }

    @Override
    public double[][] toDoubleMatrixIgnore() {
        int[] dim = this.isMatrixIgnore();
        if (dim == null) {
            return null;
        }
        double[][] result = new double[dim[0]][dim[1]];
        int rowIndex = 0;
        for (int i = 1; i < this.size(); ++i) {
            IExpr row = this.get(i);
            if (!row.isList()) continue;
            IAST list = (IAST)row;
            for (int j = 1; j <= dim[1]; ++j) {
                ISignedNumber signedNumber = list.get(j).evalReal();
                if (signedNumber == null) {
                    return null;
                }
                result[rowIndex][j - 1] = signedNumber.doubleValue();
            }
            ++rowIndex;
        }
        return result;
    }

    @Override
    public double[] toDoubleVector() {
        try {
            double[] result = new double[this.argSize()];
            for (int i = 1; i < this.size(); ++i) {
                result[i - 1] = this.get(i).evalDouble();
            }
            return result;
        }
        catch (ArgumentTypeException argumentTypeException) {
            return null;
        }
    }

    @Override
    public double[] toDoubleVectorIgnore() {
        int j;
        int i = 0;
        double[] temp = new double[this.argSize()];
        for (j = 1; j < this.size(); ++j) {
            try {
                temp[i] = this.get(j).evalDouble();
                ++i;
                continue;
            }
            catch (ArgumentTypeException argumentTypeException) {
                // empty catch block
            }
        }
        if (i == 0) {
            return null;
        }
        if (i == j - 1) {
            return temp;
        }
        double[] result = new double[i];
        System.arraycopy(temp, 0, result, 0, i);
        return result;
    }

    @Override
    public Complex[] toComplexVector() {
        try {
            Complex[] result = new Complex[this.argSize()];
            for (int i = 1; i < this.size(); ++i) {
                result[i - 1] = this.get(i).evalComplex();
            }
            return result;
        }
        catch (ArgumentTypeException argumentTypeException) {
            return null;
        }
    }

    @Override
    public int[] toIntVector() {
        int[] result = new int[this.argSize()];
        for (int i = 1; i < this.size(); ++i) {
            int value = this.get(i).toIntDefault();
            if (value == Integer.MIN_VALUE) {
                return null;
            }
            result[i - 1] = value;
        }
        return result;
    }

    private final String toFullFormString() {
        String sep = ", ";
        IExpr temp = null;
        if (this.size() > 0) {
            temp = this.head();
        }
        StringBuilder text = temp == null ? new StringBuilder("<null-tag>") : new StringBuilder(temp.toString());
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
            text.append('(');
        } else {
            text.append('[');
        }
        for (int i = 1; i < this.size(); ++i) {
            IExpr o = this.get(i);
            text = text.append(o == this ? "(this AST)" : o.toString());
            if (i >= this.argSize()) continue;
            text.append(", ");
        }
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
            text.append(')');
        } else {
            text.append(']');
        }
        return text.toString();
    }

    @Override
    public ISymbol topHead() {
        IExpr header = this.head();
        return header instanceof ISymbol ? (ISymbol)header : header.topHead();
    }

    @Override
    public RealMatrix toRealMatrixIgnore() {
        double[][] elements = this.toDoubleMatrixIgnore();
        if (elements != null) {
            return new Array2DRowRealMatrix(elements, false);
        }
        return null;
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            if (OutputFormFactory.get(EvalEngine.get().isRelaxedSyntax()).convert(sb, this)) {
                return sb.toString();
            }
            sb = null;
            StringBuilder buf = new StringBuilder();
            if (this.size() > 0 && this.isListOrAssociation()) {
                if (this.isList()) {
                    buf.append('{');
                } else {
                    buf.append("<|");
                }
                for (int i = 1; i < this.size(); ++i) {
                    buf.append(this.getRule(i) == this ? "(this AST)" : String.valueOf(this.getRule(i)));
                    if (i >= this.argSize()) continue;
                    buf.append(", ");
                }
                if (this.isList()) {
                    buf.append('}');
                } else {
                    buf.append("|>");
                }
                return buf.toString();
            }
            if (this.isAST(S.Slot, 2) && this.arg1().isReal()) {
                int slot = ((ISignedNumber)this.arg1()).toIntDefault();
                if (slot <= 0) {
                    return this.toFullFormString();
                }
                if (slot == 1) {
                    return "#";
                }
                return "#" + slot;
            }
            return this.toFullFormString();
        }
        catch (RuntimeException e) {
            LOGGER.debug("AbstractAST.toString() failed for: {}", new org.apache.logging.log4j.util.Supplier[]{() -> this.fullFormString()});
            throw e;
        }
    }

    @Override
    public IExpr upper() {
        if (this.isInterval1()) {
            return this.first().second();
        }
        return F.NIL;
    }

    @Override
    public final IExpr variables2Slots(Map<IExpr, IExpr> map, Collection<IExpr> variableCollector) {
        return AbstractAST.variables2Slots(this, Predicates.isUnaryVariableOrPattern(), new UnaryVariable2Slot(map, variableCollector));
    }

    @Override
    public IExpr extractConditionalExpression(boolean isUnaryConditionalExpression) {
        if (isUnaryConditionalExpression) {
            IAST conditionalExpr = (IAST)this.arg1();
            IASTMutable copy = this.copy();
            copy.set(1, conditionalExpr.arg1());
            return conditionalExpr.setAtCopy(1, copy);
        }
        int indx = this.indexOf((? super IExpr x) -> x.isConditionalExpression());
        if (indx > 0) {
            IAST conditionalExpr = (IAST)this.get(indx);
            IASTAppendable andExpr = F.And();
            IASTMutable copy = this.copy();
            copy.set(indx, conditionalExpr.arg1());
            andExpr.append(conditionalExpr.arg2());
            for (int i = ++indx; i < copy.size(); ++i) {
                IExpr x2 = copy.get(i);
                if (!x2.isConditionalExpression()) continue;
                conditionalExpr = (IAST)x2;
                copy.set(i, conditionalExpr.arg1());
                andExpr.append(conditionalExpr.arg2());
            }
            IASTMutable mergedResult = conditionalExpr.setAtCopy(1, copy);
            mergedResult.set(2, andExpr);
            return mergedResult;
        }
        return F.NIL;
    }

    private static final class NILPointer
    extends AbstractAST
    implements IAssociation {
        private static final long serialVersionUID = -3552302876858011292L;

        protected NILPointer() {
        }

        @Override
        public IExpr accept(IVisitor visitor) {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public boolean append(IExpr object) {
            ArgumentTypeException.throwNIL();
            return false;
        }

        @Override
        public void append(int location, IExpr object) {
            ArgumentTypeException.throwNIL();
        }

        @Override
        public boolean appendAll(Collection<? extends IExpr> collection) {
            ArgumentTypeException.throwNIL();
            return false;
        }

        @Override
        public boolean appendAll(Map<? extends IExpr, ? extends IExpr> map) {
            ArgumentTypeException.throwNIL();
            return false;
        }

        @Override
        public boolean appendAll(IAST ast, int startPosition, int endPosition) {
            ArgumentTypeException.throwNIL();
            return false;
        }

        @Override
        public boolean appendAll(IExpr[] args, int startPosition, int endPosition) {
            ArgumentTypeException.throwNIL();
            return false;
        }

        @Override
        public boolean appendAll(int location, Collection<? extends IExpr> collection) {
            ArgumentTypeException.throwNIL();
            return false;
        }

        @Override
        public boolean appendAll(List<? extends IExpr> list, int startPosition, int endPosition) {
            ArgumentTypeException.throwNIL();
            return false;
        }

        @Override
        public boolean appendArgs(IAST ast) {
            ArgumentTypeException.throwNIL();
            return false;
        }

        @Override
        public final boolean appendArgs(IAST ast, int untilPosition) {
            ArgumentTypeException.throwNIL();
            return false;
        }

        @Override
        public IASTAppendable appendArgs(int start, int end, IntFunction<IExpr> function) {
            ArgumentTypeException.throwNIL();
            return F.NIL;
        }

        @Override
        public IASTAppendable appendArgs(int end, IntFunction<IExpr> function) {
            ArgumentTypeException.throwNIL();
            return F.NIL;
        }

        @Override
        public IAST appendOneIdentity(IAST subAST) {
            ArgumentTypeException.throwNIL();
            return F.NIL;
        }

        @Override
        public IExpr arg1() {
            ArgumentTypeException.throwNIL();
            return F.NIL;
        }

        @Override
        public IExpr arg2() {
            ArgumentTypeException.throwNIL();
            return F.NIL;
        }

        @Override
        public IExpr arg3() {
            ArgumentTypeException.throwNIL();
            return F.NIL;
        }

        @Override
        public IExpr arg4() {
            ArgumentTypeException.throwNIL();
            return F.NIL;
        }

        @Override
        public IExpr arg5() {
            ArgumentTypeException.throwNIL();
            return F.NIL;
        }

        @Override
        public int argSize() {
            return -1;
        }

        @Override
        public Set<IExpr> asSet() {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public void clear() {
            ArgumentTypeException.throwNIL();
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public IAssociation copy() {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public IASTAppendable copyAppendable() {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public IASTAppendable copyAppendable(int additionalCapacity) {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public IASTAppendable copyAST() {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public final IExpr evaluate(EvalEngine engine) {
            ArgumentTypeException.throwNIL();
            return F.NIL;
        }

        @Override
        public IExpr evalEvaluate(EvalEngine engine) {
            ArgumentTypeException.throwNIL();
            return F.NIL;
        }

        @Override
        public boolean exists(ObjIntPredicate<? super IExpr> predicate, int startOffset) {
            return false;
        }

        @Override
        public boolean exists(Predicate<? super IExpr> predicate, int startOffset) {
            return false;
        }

        @Override
        public boolean forAll(ObjIntPredicate<? super IExpr> predicate, int startOffset) {
            return false;
        }

        @Override
        public boolean forAll(Predicate<? super IExpr> predicate, int startOffset) {
            return false;
        }

        @Override
        protected String fullFormString(IExpr head) {
            return "NIL";
        }

        @Override
        public IExpr get(int location) {
            ArgumentTypeException.throwNIL();
            return F.NIL;
        }

        @Override
        public IAST getItems(int[] items, int length) {
            ArgumentTypeException.throwNIL();
            return F.NIL;
        }

        @Override
        public int hashCode() {
            return -1;
        }

        @Override
        public final IExpr head() {
            ArgumentTypeException.throwNIL();
            return F.NIL;
        }

        @Override
        public ISymbol topHead() {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public final int headID() {
            return -1;
        }

        @Override
        public void ifAppendable(Consumer<? super IASTAppendable> consumer) {
        }

        @Override
        public IExpr ifPresent(Function<? super IExpr, IExpr> function) {
            return F.NIL;
        }

        @Override
        public final CharSequence internalJavaString(IExpr.SourceCodeProperties properties, int depth, Function<ISymbol, ? extends CharSequence> variables) {
            switch (properties.prefix) {
                case FULLY_QUALIFIED_CLASS_NAME: {
                    return "org.matheclipse.core.expression.F.NIL";
                }
                case CLASS_NAME: {
                    return "F.NIL";
                }
            }
            return "NIL";
        }

        @Override
        public boolean isAbs() {
            return false;
        }

        @Override
        public boolean isAllExpanded() {
            return false;
        }

        @Override
        public final boolean isAST() {
            return false;
        }

        @Override
        public final boolean isAST(IExpr header) {
            return false;
        }

        @Override
        public final boolean isAST(IExpr header, int length) {
            return false;
        }

        @Override
        public boolean isAST(IExpr header, int length, IExpr ... args) {
            return false;
        }

        @Override
        public boolean isAST0() {
            return false;
        }

        @Override
        public boolean isAST1() {
            return false;
        }

        @Override
        public boolean isAST2() {
            return false;
        }

        @Override
        public boolean isAST3() {
            return false;
        }

        @Override
        public boolean isASTSizeGE(IExpr header, int length) {
            return false;
        }

        @Override
        public boolean isBooleanFormula() {
            return false;
        }

        @Override
        public boolean isBooleanResult() {
            return false;
        }

        @Override
        public boolean isComparatorFunction() {
            return false;
        }

        @Override
        public boolean isCondition() {
            return false;
        }

        @Override
        public boolean isConditionalExpression() {
            return false;
        }

        @Override
        public boolean isExcept() {
            return false;
        }

        @Override
        public boolean isExpanded() {
            return false;
        }

        @Override
        public boolean isIntegerResult() {
            return false;
        }

        @Override
        public final boolean isInterval() {
            return false;
        }

        @Override
        public final boolean isInterval1() {
            return false;
        }

        @Override
        public boolean isEmptyList() {
            return false;
        }

        @Override
        public boolean isNonEmptyList() {
            return false;
        }

        @Override
        public boolean isList() {
            return false;
        }

        @Override
        public boolean isList(Predicate<IExpr> pred) {
            return false;
        }

        @Override
        public final boolean isListOfLists() {
            return false;
        }

        @Override
        public final boolean isListOfMatrices() {
            return false;
        }

        @Override
        public final GraphType isListOfEdges() {
            return null;
        }

        @Override
        public final boolean isListOfRules(boolean ignoreEmptySublists) {
            return false;
        }

        @Override
        public final boolean isListOfRulesOrAssociation(boolean ignoreEmptySublists) {
            return false;
        }

        @Override
        public int[] isMatrix(boolean setMatrixFormat) {
            return null;
        }

        @Override
        public int[] isMatrixIgnore() {
            return null;
        }

        @Override
        public boolean isNegativeResult() {
            return false;
        }

        @Override
        public boolean isNonNegativeResult() {
            return false;
        }

        @Override
        public final boolean isNumericFunction(boolean allowList) {
            return false;
        }

        @Override
        public final boolean isNumericFunction(VariablesSet varSet) {
            return false;
        }

        @Override
        public final boolean isNumericFunction(IExpr expr) {
            return false;
        }

        @Override
        public final boolean isNumericMode() {
            return false;
        }

        @Override
        public final boolean isOneIdentityAST1() {
            return false;
        }

        @Override
        public int[] isPiecewise() {
            return null;
        }

        @Override
        public final boolean isPlus() {
            return false;
        }

        @Override
        public boolean isPlusTimesPower() {
            return false;
        }

        @Override
        public boolean isPossibleZero(boolean fastTest) {
            return false;
        }

        @Override
        public final boolean isPower() {
            return false;
        }

        @Override
        public final boolean isPresent() {
            return false;
        }

        @Override
        public boolean isRealResult() {
            return false;
        }

        @Override
        public boolean isRealMatrix() {
            return false;
        }

        @Override
        public boolean isRealVector() {
            return false;
        }

        @Override
        public boolean isRGBColor() {
            return false;
        }

        @Override
        public final boolean isRule() {
            return false;
        }

        @Override
        public final boolean isRuleAST() {
            return false;
        }

        @Override
        public final boolean isRuleDelayed() {
            return false;
        }

        @Override
        public final boolean isSame(IExpr expression) {
            return false;
        }

        @Override
        public final boolean isSame(IExpr expression, double epsilon) {
            return false;
        }

        @Override
        public boolean isSameHead(ISymbol head) {
            return false;
        }

        @Override
        public boolean isSameHead(ISymbol head, int length) {
            return false;
        }

        @Override
        public boolean isSameHead(ISymbol head, int minLength, int maxLength) {
            return false;
        }

        @Override
        public boolean isSameHeadSizeGE(ISymbol head, int length) {
            return false;
        }

        @Override
        public final boolean isTimes() {
            return false;
        }

        @Override
        public final int isVector() {
            return -1;
        }

        @Override
        public final boolean isZERO() {
            return false;
        }

        @Override
        public IExpr mapExpr(Function<? super IExpr, ? extends IExpr> mapper) {
            return this;
        }

        @Override
        public final IAST orElse(IAST other) {
            return other;
        }

        @Override
        public final IExpr orElse(IExpr other) {
            return other;
        }

        @Override
        public final IExpr orElseGet(Supplier<? extends IExpr> other) {
            return other.get();
        }

        @Override
        public final <X extends Throwable> IExpr orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
            throw (Throwable)exceptionSupplier.get();
        }

        private Object readResolve() {
            return F.NIL;
        }

        @Override
        public IExpr remove(int location) {
            ArgumentTypeException.throwNIL();
            return F.NIL;
        }

        @Override
        public void removeRange(int start, int end) {
            ArgumentTypeException.throwNIL();
        }

        public IExpr replace(Predicate<IExpr> predicate, Function<IExpr, IExpr> function) {
            return F.NIL;
        }

        @Override
        public IExpr replaceAll(Function<IExpr, IExpr> function) {
            return F.NIL;
        }

        @Override
        public IExpr replaceAll(IAST listOfRules) {
            return F.NIL;
        }

        @Override
        public IExpr replaceAll(Map<? extends IExpr, ? extends IExpr> map) {
            return F.NIL;
        }

        public IExpr replaceAll(VisitorReplaceAll visitor) {
            return F.NIL;
        }

        @Override
        public IExpr replacePart(IAST astRules, IExpr.COMPARE_TERNARY heads) {
            return F.NIL;
        }

        @Override
        public IExpr replaceRepeated(Function<IExpr, IExpr> function) {
            return F.NIL;
        }

        @Override
        public IExpr replaceRepeated(IAST astRules) {
            return F.NIL;
        }

        @Override
        public IExpr replaceRepeated(VisitorReplaceAll visitor, int maxIterations) {
            return F.NIL;
        }

        @Override
        @Deprecated
        public IExpr replaceSlots(IAST slotsList) {
            return F.NIL;
        }

        @Override
        public IExpr set(int location, IExpr object) {
            ArgumentTypeException.throwNIL();
            return F.NIL;
        }

        @Override
        public IASTMutable setArgs(int start, int end, IntFunction<IExpr> function) {
            ArgumentTypeException.throwNIL();
            return F.NIL;
        }

        @Override
        public IASTMutable setArgs(int end, IntFunction<IExpr> function) {
            ArgumentTypeException.throwNIL();
            return F.NIL;
        }

        @Override
        public IExpr setValue(int location, IExpr value) {
            ArgumentTypeException.throwNIL();
            return F.NIL;
        }

        @Override
        public IExpr setPart(IExpr value, int ... positions) {
            ArgumentTypeException.throwNIL();
            return F.NIL;
        }

        @Override
        public IASTAppendable setAtClone(int i, IExpr expr) {
            ArgumentTypeException.throwNIL();
            return F.NIL;
        }

        @Override
        public IASTMutable setAtCopy(int i, IExpr expr) {
            ArgumentTypeException.throwNIL();
            return F.NIL;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public byte[][] toByteMatrix() {
            return null;
        }

        @Override
        public double[][] toDoubleMatrix() {
            return null;
        }

        @Override
        public double[][] toDoubleMatrixIgnore() {
            return null;
        }

        @Override
        public double[] toDoubleVector() {
            return null;
        }

        @Override
        public double[] toDoubleVectorIgnore() {
            return null;
        }

        @Override
        public int[][] toIntMatrix() {
            return null;
        }

        @Override
        public IExpr[] toArray() {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public String toString() {
            return "NIL";
        }

        @Override
        public void appendRules(IAST listOfRules) {
            ArgumentTypeException.throwNIL();
        }

        @Override
        public void appendRules(IAST listOfRules, int startPosition, int endPosition) {
            ArgumentTypeException.throwNIL();
        }

        @Override
        public IAssociation copyHead(int intialCapacity) {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public IExpr getKey(int position) {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public IAST getRule(int position) {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public IExpr getValue(int position) {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public IExpr getValue(IExpr key) {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public IExpr getValue(IExpr key, Supplier<IExpr> defaultValue) {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public boolean isKey(IExpr expr) {
            return false;
        }

        @Override
        public IASTMutable keys() {
            ArgumentTypeException.throwNIL();
            return null;
        }

        public ArrayList<String> keyNames() {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public IAssociation keySort() {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public IAssociation keySort(Comparator<IExpr> comparator) {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public IASTMutable normal(boolean nilIfUnevaluated) {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public IAST matrixOrList() {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public IAssociation sort() {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public IAssociation sort(Comparator<IExpr> comparator) {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public IASTMutable values() {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public IAssociation reverse(IAssociation newAssoc) {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public IAST getRule(String key) {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public IAST getRule(IExpr key) {
            ArgumentTypeException.throwNIL();
            return null;
        }

        @Override
        public void prependRules(IAST listOfRules) {
            ArgumentTypeException.throwNIL();
        }

        @Override
        public void prependRules(IAST listOfRules, int startPosition, int endPosition) {
            ArgumentTypeException.throwNIL();
        }
    }

    protected static final class ASTIterator
    implements ListIterator<IExpr> {
        private int _currentIndex;
        private int _end;
        private int _nextIndex;
        private int _start;
        private IASTMutable _table;

        protected ASTIterator() {
        }

        @Override
        public void add(IExpr o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this._nextIndex != this._end;
        }

        @Override
        public boolean hasPrevious() {
            return this._nextIndex != this._start;
        }

        @Override
        public IExpr next() {
            if (this._nextIndex == this._end) {
                throw new NoSuchElementException();
            }
            this._currentIndex = this._nextIndex++;
            return this._table.get(this._currentIndex);
        }

        @Override
        public int nextIndex() {
            return this._nextIndex;
        }

        @Override
        public IExpr previous() {
            if (this._nextIndex == this._start) {
                throw new NoSuchElementException();
            }
            this._currentIndex = --this._nextIndex;
            return this._table.get(this._currentIndex);
        }

        @Override
        public int previousIndex() {
            return this._nextIndex - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(IExpr o) {
            if (this._currentIndex < 0) {
                throw new IllegalStateException();
            }
            this._table.set(this._currentIndex, o);
        }
    }
}

