/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.util.ArithmeticUtils;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.util.OpenIntToIExprHashMap;
import org.matheclipse.core.expression.AbstractAST;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.IRational;

public class ASTSeriesData
extends AbstractAST
implements Externalizable {
    private static final Logger LOGGER = LogManager.getLogger();
    OpenIntToIExprHashMap<IExpr> coefficientValues;
    private int truncate;
    private IExpr x;
    private IExpr x0;
    private int nMin;
    private int nMax;
    private int denominator;

    public void setDenominator(int denominator) {
        this.denominator = denominator;
    }

    public ASTSeriesData() {
        this.truncate = 0;
        this.denominator = 1;
    }

    public ASTSeriesData(IExpr x, IExpr x0, IAST coefficients, int nMin, int truncate, int denominator) {
        this(x, x0, nMin, nMin, truncate, denominator, new OpenIntToIExprHashMap<IExpr>());
        int index;
        int size = coefficients.size();
        for (int i = 0; i < size - 1 && (index = nMin + i) < truncate; ++i) {
            this.setCoeff(index, coefficients.get(i + 1));
        }
    }

    public ASTSeriesData(IExpr x, IExpr x0, int nMin, int truncate, int denominator) {
        this(x, x0, nMin, nMin, truncate, denominator, new OpenIntToIExprHashMap<IExpr>());
    }

    private ASTSeriesData(IExpr x, IExpr x0, int nMin, int nMax, int truncate, int denominator, OpenIntToIExprHashMap<IExpr> vals) {
        this.coefficientValues = vals;
        this.x = x;
        this.x0 = x0;
        this.nMin = nMin;
        this.nMax = nMax;
        this.truncate = truncate;
        if (this.truncate < 0) {
            this.truncate = 1;
        }
        this.denominator = denominator;
    }

    @Override
    public final IExpr arg1() {
        return this.x;
    }

    @Override
    public final IExpr arg2() {
        return this.x0;
    }

    @Override
    public final IAST arg3() {
        int capacity = this.nMax - this.nMin;
        if (capacity <= 0) {
            capacity = 4;
        }
        IASTAppendable list = F.ListAlloc(capacity);
        for (int i = this.nMin; i < this.nMax; ++i) {
            list.append(this.coefficient(i));
        }
        return list;
    }

    @Override
    public final IInteger arg4() {
        return F.ZZ(this.nMin);
    }

    @Override
    public final IInteger arg5() {
        return F.ZZ(this.truncate);
    }

    @Override
    public int argSize() {
        return 6;
    }

    public IAST clone() {
        return new ASTSeriesData(this.x, this.x0, this.nMin, this.nMax, this.truncate, this.denominator, new OpenIntToIExprHashMap<IExpr>(this.coefficientValues));
    }

    public IExpr coefficient(int k) {
        if (k < this.nMin || k >= this.nMax) {
            return F.C0;
        }
        IExpr coefficient = this.coefficientValues.get(k);
        if (coefficient == null) {
            return F.C0;
        }
        return coefficient;
    }

    @Override
    public int compareTo(IExpr rhsExpr) {
        int y;
        if (rhsExpr instanceof ASTSeriesData) {
            ASTSeriesData rhs = (ASTSeriesData)rhsExpr;
            int cp = this.x.compareTo(rhs.x);
            if (cp != 0) {
                return cp;
            }
            cp = this.x0.compareTo(rhs.x0);
            if (cp != 0) {
                return cp;
            }
            cp = this.nMax - rhs.nMax;
            if (cp != 0) {
                if (cp < 0) {
                    return -1;
                }
                return 1;
            }
            cp = this.nMin - rhs.nMin;
            if (cp != 0) {
                if (cp < 0) {
                    return -1;
                }
                return 1;
            }
            cp = this.denominator - rhs.denominator;
            if (cp != 0) {
                if (cp < 0) {
                    return -1;
                }
                return 1;
            }
            return super.compareTo(rhsExpr);
        }
        int x = this.hierarchy();
        return x < (y = rhsExpr.hierarchy()) ? -1 : (x == y ? 0 : 1);
    }

    public ASTSeriesData compose(ASTSeriesData series2) {
        IExpr coeff0 = series2.coefficient(0);
        if (!coeff0.equals(this.x0)) {
            Level logLevel = EvalEngine.get().getLogLevel();
            LOGGER.log(logLevel, "Constant {} of series {} unequals point {} of series {}", (Object)coeff0, (Object)this, (Object)this.x0, (Object)series2);
            return null;
        }
        ASTSeriesData series = new ASTSeriesData(series2.x, series2.x0, 0, series2.truncate, series2.denominator);
        ASTSeriesData x0Term = this.x0.isZero() ? series2 : series2.subtract(this.x0);
        for (int n = this.nMin; n < this.nMax; ++n) {
            IExpr temp = this.coefficient(n);
            if (temp.isZero()) continue;
            ASTSeriesData s = x0Term.powerSeries(n);
            s = s.times(temp);
            series = series.plusPS(s);
        }
        return series;
    }

    @Override
    public ASTSeriesData copy() {
        return new ASTSeriesData(this.x, this.x0, this.nMin, this.nMax, this.truncate, this.denominator, new OpenIntToIExprHashMap<IExpr>(this.coefficientValues));
    }

    @Override
    public IASTAppendable copyAppendable() {
        return F.NIL;
    }

    @Override
    public IASTAppendable copyAppendable(int additionalCapacity) {
        return this.copyAppendable();
    }

    public ASTSeriesData derive(IExpr x) {
        if (this.x.equals(x)) {
            if (this.isProbableZero()) {
                return this;
            }
            if (this.truncate > 0) {
                ASTSeriesData series = new ASTSeriesData(x, this.x0, this.nMin, this.nMin, this.truncate - 1, this.denominator, new OpenIntToIExprHashMap<IExpr>());
                if (this.nMin >= 0) {
                    if (this.nMin > 0) {
                        series.setCoeff(this.nMin - 1, this.coefficient(this.nMin + 1).times(F.ZZ(this.nMin + 1)));
                    }
                    for (int i = this.nMin; i < this.nMax - 1; ++i) {
                        series.setCoeff(i, this.coefficient(i + 1).times(F.ZZ(i + 1)));
                    }
                    return series;
                }
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ASTSeriesData) {
            if (obj == this) {
                return true;
            }
            ASTSeriesData that = (ASTSeriesData)obj;
            if (!this.x.equals(that.x)) {
                return false;
            }
            if (!this.x0.equals(that.x0)) {
                return false;
            }
            if (this.nMin != that.nMin) {
                return false;
            }
            if (this.denominator != that.denominator) {
                return false;
            }
            if (this.truncate != that.truncate) {
                return false;
            }
            if (this.coefficientValues.equals(that.coefficientValues)) {
                return true;
            }
            for (int i = this.nMin; i < this.nMax; ++i) {
                if (this.coefficient(i).equals(that.coefficient(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        return F.NIL;
    }

    @Override
    public IExpr evalEvaluate(EvalEngine engine) {
        return F.NIL;
    }

    @Override
    public String fullFormString() {
        IAST seriesData = this.toSeriesData();
        return seriesData.fullFormString();
    }

    public IAST toSeriesData() {
        IASTAppendable coefficientList = F.ListAlloc(16);
        for (int i = this.nMin; i < this.nMax; ++i) {
            coefficientList.append(this.coefficient(i));
        }
        IAST seriesData = F.SeriesData(this.x, this.x0, coefficientList, F.ZZ(this.nMin), F.ZZ(this.truncate), F.ZZ(this.denominator));
        return seriesData;
    }

    @Override
    public IExpr get(int location) {
        if (location >= 0 && location <= 7) {
            switch (location) {
                case 0: {
                    return this.head();
                }
                case 1: {
                    return this.arg1();
                }
                case 2: {
                    return this.arg2();
                }
                case 3: {
                    return this.arg3();
                }
                case 4: {
                    return this.arg4();
                }
                case 5: {
                    return this.arg5();
                }
                case 6: {
                    return F.ZZ(this.denominator);
                }
            }
        }
        throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(location) + ", Size: 1");
    }

    @Override
    public IAST getItems(int[] items, int length) {
        IASTMutable result = this.normal(false);
        return result.getItems(items, length);
    }

    public int getDenominator() {
        return this.denominator;
    }

    public int getNMax() {
        return this.nMax;
    }

    public int getNMin() {
        return this.nMin;
    }

    public int order() {
        return this.truncate;
    }

    public IExpr getX() {
        return this.x;
    }

    public IExpr getX0() {
        return this.x0;
    }

    @Override
    public int hashCode() {
        if (this.hashValue == 0 && this.x0 != null) {
            this.hashValue = this.coefficientValues != null ? this.x0.hashCode() + this.truncate * this.coefficientValues.hashCode() : this.x0.hashCode() + this.truncate;
        }
        return this.hashValue;
    }

    @Override
    public IExpr head() {
        return S.SeriesData;
    }

    @Override
    public int hierarchy() {
        return 64;
    }

    public ASTSeriesData integrate(IExpr x) {
        if (this.x.equals(x)) {
            if (this.isProbableZero()) {
                return this;
            }
            if (this.truncate > 0) {
                ASTSeriesData series = new ASTSeriesData(x, this.x0, this.nMin, this.nMin, this.truncate + 1, this.denominator, new OpenIntToIExprHashMap<IExpr>());
                if (this.nMin + 1 > 0) {
                    for (int i = this.nMin + 1; i <= this.nMax; ++i) {
                        series.setCoeff(i, this.coefficient(i - 1).times(F.QQ(1L, i)));
                    }
                    return series;
                }
            }
        }
        return null;
    }

    @Override
    public ASTSeriesData inverse() {
        ASTSeriesData reversion = this.reversion();
        if (reversion != null) {
            return reversion;
        }
        ASTSeriesData result = new ASTSeriesData(this.x, this.x0, 0, this.truncate, this.denominator);
        IExpr d = this.coefficient(0).inverse();
        for (int i = 0; i < this.truncate; ++i) {
            if (i == 0) {
                result.setCoeff(i, d);
                continue;
            }
            IExpr c = F.C0;
            for (int k = 0; k < i; ++k) {
                IExpr coeffK = result.coefficient(k);
                IExpr m = coeffK.multiply(this.coefficient(i - k));
                c = c.sum(m);
            }
            c = c.multiply(d.negate());
            result.setCoeff(i, c);
        }
        return result;
    }

    public ASTSeriesData reversion() {
        IExpr x0Value = this.x0;
        if (this.isInvertible()) {
            x0Value = F.C1;
        }
        if (!this.coefficient(1).isZero()) {
            int maxPower = this.truncate;
            if (maxPower > 10 || maxPower <= 1) {
                return null;
            }
            IExpr a1 = this.coefficient(1);
            IExpr a1Inverse = a1.inverse();
            ASTSeriesData ps = new ASTSeriesData(this.x, x0Value, this.nMin, this.nMin, this.truncate, this.denominator, new OpenIntToIExprHashMap<IExpr>());
            if (!this.x0.isZero()) {
                ps.setCoeff(0, this.x0);
            }
            ps.setCoeff(1, a1Inverse);
            if (maxPower > 2) {
                EvalEngine engine = EvalEngine.get();
                IExpr a2 = this.coefficient(2);
                ps.setCoeff(2, a1.power(-3L).times(a2).negate());
                if (maxPower > 3) {
                    IExpr a3 = this.coefficient(3);
                    ps.setCoeff(3, S.Times.of(engine, F.Power(a1, -5L), F.Subtract(F.Times((IExpr)F.C2, (IExpr)F.Sqr(a2)), F.Times(a1, a3))));
                    if (maxPower > 4) {
                        IExpr a4 = this.coefficient(4);
                        ps.setCoeff(4, S.Times.of(engine, F.Power(a1, -7L), F.Plus((IExpr)F.Times((IExpr)F.CN5, F.Power(a2, 3L)), (IExpr)F.Times(F.C5, a1, a2, a3), (IExpr)F.Times((IExpr)F.CN1, a1, a4))));
                        if (maxPower > 5) {
                            IExpr a5 = this.coefficient(5);
                            ps.setCoeff(5, S.Times.of(engine, F.Power(a1, -9L), F.Plus(F.Times((IExpr)F.ZZ(14L), F.Power(a2, 4L)), F.Times(F.ZZ(-21L), a1, F.Sqr(a2), a3), F.Times((IExpr)F.C3, (IExpr)F.Sqr(a1), (IExpr)F.Sqr(a3)), F.Times(F.C6, F.Sqr(a1), a2, a4), F.Times((IExpr)F.CN1, F.Power(a1, 3L), a5))));
                            if (maxPower > 6) {
                                IExpr a6 = this.coefficient(6);
                                ps.setCoeff(6, S.Times.of(engine, F.Power(a1, -11L), F.Plus(F.Times((IExpr)F.ZZ(-42L), F.Power(a2, 5L)), F.Times(F.ZZ(84L), a1, F.Power(a2, 3L), a3), F.Times(F.ZZ(-28L), F.Sqr(a1), a2, F.Sqr(a3)), F.Times(F.ZZ(-28L), F.Sqr(a1), F.Sqr(a2), a4), F.Times(F.C7, F.Power(a1, 3L), a3, a4), F.Times(F.C7, F.Power(a1, 3L), a2, a5), F.Times((IExpr)F.CN1, F.Power(a1, 4L), a6))));
                                if (maxPower > 7) {
                                    IExpr a7 = this.coefficient(7);
                                    ps.setCoeff(7, S.Times.of(engine, F.Power(a1, -13L), F.Plus(F.Times((IExpr)F.ZZ(132L), F.Power(a2, 6L)), F.Times(F.ZZ(-330L), a1, F.Power(a2, 4L), a3), F.Times(F.ZZ(120L), F.Sqr(a1), F.Power(a2, 3L), a4), F.Times(F.ZZ(-36L), F.Sqr(a1), F.Sqr(a2), F.Plus((IExpr)F.Times((IExpr)F.CN5, (IExpr)F.Sqr(a3)), (IExpr)F.Times(a1, a5))), F.Times(F.C8, F.Power(a1, 3L), a2, F.Plus((IExpr)F.Times((IExpr)F.CN9, a3, a4), (IExpr)F.Times(a1, a6))), F.Times(F.Power(a1, 3L), (IExpr)F.Plus((IExpr)F.Times((IExpr)F.ZZ(-12L), F.Power(a3, 3L)), (IExpr)F.Times(F.C8, a1, a3, a5), (IExpr)F.Times(a1, (IExpr)F.Plus((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Sqr(a4)), (IExpr)F.Times((IExpr)F.CN1, a1, a7)))))), F.Power(a1, 13L)));
                                    if (maxPower > 8) {
                                        IExpr a8 = this.coefficient(8);
                                        ps.setCoeff(8, S.Times.of(engine, F.Power(a1, -15L), F.Plus(F.Times((IExpr)F.ZZ(-429L), F.Power(a2, 7L)), F.Times(F.ZZ(1287L), a1, F.Power(a2, 5L), a3), F.Times(F.ZZ(-495L), F.Sqr(a1), F.Power(a2, 4L), a4), F.Times(F.ZZ(165L), F.Sqr(a1), F.Power(a2, 3L), F.Plus((IExpr)F.Times((IExpr)F.CN6, (IExpr)F.Sqr(a3)), (IExpr)F.Times(a1, a5))), F.Times(F.ZZ(-45L), F.Power(a1, 3L), F.Sqr(a2), F.Plus((IExpr)F.Times((IExpr)F.ZZ(-11L), a3, a4), (IExpr)F.Times(a1, a6))), F.Times(F.C3, F.Power(a1, 3L), a2, F.Plus((IExpr)F.Times((IExpr)F.ZZ(55L), F.Power(a3, 3L)), (IExpr)F.Times(F.ZZ(-30L), a1, a3, a5), (IExpr)F.Times((IExpr)F.C3, a1, (IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN5, (IExpr)F.Sqr(a4)), (IExpr)F.Times(a1, a7))))), F.Times(F.Power(a1, 4L), (IExpr)F.Plus((IExpr)F.Times((IExpr)F.ZZ(-45L), (IExpr)F.Sqr(a3), a4), (IExpr)F.Times(F.C9, a1, a3, a6), (IExpr)F.Times(a1, (IExpr)F.Plus((IExpr)F.Times((IExpr)F.C9, a4, a5), (IExpr)F.Times((IExpr)F.CN1, a1, a8))))))));
                                        if (maxPower > 9) {
                                            IExpr a9 = this.coefficient(9);
                                            ps.setCoeff(9, S.Times.of(engine, F.Power(a1, -17L), F.Plus(F.Times((IExpr)F.ZZ(1430L), F.Power(a2, 8L)), F.Times(F.ZZ(-5005L), a1, F.Power(a2, 6L), a3), F.Times(F.ZZ(2002L), F.Sqr(a1), F.Power(a2, 5L), a4), F.Times(F.ZZ(-715L), F.Sqr(a1), F.Power(a2, 4L), F.Plus((IExpr)F.Times((IExpr)F.CN7, (IExpr)F.Sqr(a3)), (IExpr)F.Times(a1, a5))), F.Times(F.ZZ(220L), F.Power(a1, 3L), F.Power(a2, 3L), F.Plus((IExpr)F.Times((IExpr)F.ZZ(-13L), a3, a4), (IExpr)F.Times(a1, a6))), F.Times(F.ZZ(-55L), F.Power(a1, 3L), F.Sqr(a2), F.Plus((IExpr)F.Times((IExpr)F.ZZ(26L), F.Power(a3, 3L)), (IExpr)F.Times(F.ZZ(-12L), a1, a3, a5), (IExpr)F.Times(a1, (IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN6, (IExpr)F.Sqr(a4)), (IExpr)F.Times(a1, a7))))), F.Times(F.C10, F.Power(a1, 4L), a2, F.Plus((IExpr)F.Times((IExpr)F.ZZ(66L), (IExpr)F.Sqr(a3), a4), (IExpr)F.Times(F.ZZ(-11L), a1, a3, a6), (IExpr)F.Times(a1, (IExpr)F.Plus((IExpr)F.Times((IExpr)F.ZZ(-11L), a4, a5), (IExpr)F.Times(a1, a8))))), F.Times(F.Power(a1, 4L), (IExpr)F.Plus(F.Times((IExpr)F.ZZ(55L), F.Power(a3, 4L)), F.Times(F.ZZ(-55L), a1, F.Sqr(a3), a5), F.Times(F.C5, a1, a3, F.Plus((IExpr)F.Times((IExpr)F.ZZ(-11L), (IExpr)F.Sqr(a4)), (IExpr)F.Times((IExpr)F.C2, a1, a7))), F.Times((IExpr)F.Sqr(a1), (IExpr)F.Plus((IExpr)F.Times((IExpr)F.C5, (IExpr)F.Sqr(a5)), (IExpr)F.Times((IExpr)F.C10, a4, a6), (IExpr)F.Times((IExpr)F.CN1, a1, a9))))))));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return ps;
        }
        return null;
    }

    @Override
    public boolean isAST0() {
        return false;
    }

    @Override
    public boolean isAST1() {
        return false;
    }

    @Override
    public boolean isAST2() {
        return false;
    }

    @Override
    public boolean isAST3() {
        return false;
    }

    public boolean isInvertible() {
        return !this.coefficient(0).isZero();
    }

    public boolean isProbableOne() {
        if (!this.coefficient(0).isOne()) {
            return false;
        }
        for (int i = this.nMin; i < this.nMax; ++i) {
            if (this.coefficient(i).isZero()) continue;
            return false;
        }
        return true;
    }

    public boolean isProbableZero() {
        if (this.coefficientValues.size() == 0) {
            return true;
        }
        for (int i = this.nMin; i < this.nMax; ++i) {
            if (this.coefficient(i).isZero()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ASTSeriesData negate() {
        ASTSeriesData series = this.copy();
        for (int i = this.nMin; i < this.nMax; ++i) {
            series.setCoeff(i, this.coefficient(i).negate());
        }
        return series;
    }

    @Override
    public IASTMutable normal(boolean nilIfUnevaluated) {
        IExpr x = this.getX();
        IExpr x0 = this.getX0();
        int nMin = this.getNMin();
        int nMax = this.getNMax();
        int denominator = this.getDenominator();
        int size = nMax - nMin;
        if (size < 4) {
            size = 4;
        }
        IASTAppendable result = F.PlusAlloc(size);
        for (int i = nMin; i < nMax; ++i) {
            IExpr expr = this.coefficient(i);
            if (expr.isZero()) continue;
            IRational exp = denominator == 1 ? F.ZZ(i) : F.fraction(i, denominator).normalize();
            IExpr pow = x.subtract(x0).power(exp);
            result.append(F.Times(expr, pow));
        }
        return result;
    }

    @Override
    public ASTSeriesData plus(IExpr b) {
        if (b instanceof ASTSeriesData) {
            return this.plusPS((ASTSeriesData)b);
        }
        if (b.isZero()) {
            return this;
        }
        IExpr value = F.eval(this.coefficient(0).plus(b));
        ASTSeriesData series = this.copy();
        if (value.isZero()) {
            series.setZero(0);
        } else {
            series.setCoeff(0, value);
        }
        return series;
    }

    public ASTSeriesData plusPS(ASTSeriesData b) {
        int rest;
        int minSize = this.nMin;
        if (this.nMin > b.nMin) {
            minSize = b.nMin;
        }
        int maxSize = this.nMax;
        if (this.nMax < b.nMax) {
            maxSize = b.nMax;
        }
        int maxPower = this.truncate;
        if (this.truncate > b.truncate) {
            maxPower = b.truncate;
        }
        int newDenominator = this.denominator;
        if (this.denominator != b.denominator && (rest = maxPower % (newDenominator = ArithmeticUtils.lcm((int)this.denominator, (int)b.denominator))) != 0) {
            int div = maxPower / newDenominator;
            maxPower = div * newDenominator + newDenominator;
        }
        ASTSeriesData series = new ASTSeriesData(this.x, this.x0, minSize, maxPower, newDenominator);
        for (int i = minSize; i < maxSize; ++i) {
            series.setCoeff(i, this.coefficient(i).plus(b.coefficient(i)));
        }
        return series;
    }

    public ASTSeriesData powerSeries(long n) {
        ASTSeriesData r;
        if (n == 0L) {
            ASTSeriesData series = new ASTSeriesData(this.x, this.x0, 0, this.truncate, this.denominator);
            series.setCoeff(0, F.C1);
            return series;
        }
        if (n == 1L) {
            return this;
        }
        long exp = n;
        if (n < 0L) {
            if (n == Long.MIN_VALUE) {
                throw new ArithmeticException();
            }
            exp *= -1L;
        }
        long b2pow = 0L;
        while ((exp & 1L) == 0L) {
            ++b2pow;
            exp >>= 1;
        }
        ASTSeriesData x = r = this;
        while ((exp >>= 1) > 0L) {
            x = x.sqrPS();
            if ((exp & 1L) == 0L) continue;
            r = r.timesPS(x);
        }
        while (b2pow-- > 0L) {
            r = r.sqrPS();
        }
        if (n < 0L) {
            return r.inverse();
        }
        return r;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.fEvalFlags = objectInput.readShort();
        int size = objectInput.readInt();
        IExpr[] array = new IExpr[size];
        for (int i = 0; i < size; ++i) {
            array[i] = (IExpr)objectInput.readObject();
        }
        this.x = array[1];
        this.x0 = array[2];
        this.nMin = array[4].toIntDefault(0);
        this.truncate = array[5].toIntDefault(0);
        this.denominator = array[6].toIntDefault(0);
        this.coefficientValues = new OpenIntToIExprHashMap();
        IAST list = (IAST)array[3];
        int listSize = list.size();
        for (int i = 1; i < listSize; ++i) {
            this.setCoeff(i + this.nMin - 1, list.get(i));
        }
    }

    @Override
    public IExpr set(int location, IExpr object) {
        this.hashValue = 0;
        switch (location) {
            case 1: {
                IExpr result = this.x;
                this.x = object;
                return result;
            }
            case 2: {
                IExpr result = this.x0;
                this.x0 = object;
                return result;
            }
            case 3: {
                if (!object.isList()) {
                    throw new IndexOutOfBoundsException("SeriesData: Index[" + Integer.valueOf(location) + "] expects list of data.");
                }
                return this.arg3();
            }
            case 4: {
                IInteger result = F.ZZ(this.nMin);
                this.nMin = object.toIntDefault();
                if (this.nMin == Integer.MIN_VALUE) {
                    throw new IndexOutOfBoundsException("SeriesData: Index[" + Integer.valueOf(location) + "] expects machine size integer.");
                }
                return result;
            }
            case 5: {
                IInteger result = F.ZZ(this.truncate);
                this.truncate = object.toIntDefault();
                if (this.truncate == Integer.MIN_VALUE) {
                    throw new IndexOutOfBoundsException("SeriesData: Index[" + Integer.valueOf(location) + "] expects machine size integer.");
                }
                return result;
            }
            case 6: {
                IInteger result = F.ZZ(this.denominator);
                this.denominator = object.toIntDefault();
                if (this.denominator == Integer.MIN_VALUE) {
                    throw new IndexOutOfBoundsException("SeriesData: Index[" + Integer.valueOf(location) + "] expects machine size integer.");
                }
                return result;
            }
        }
        throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(location));
    }

    public void setCoeff(int k, IExpr value) {
        if (value.isZero() || k >= this.truncate) {
            return;
        }
        this.coefficientValues.put(k, value);
        if (this.coefficientValues.size() == 1) {
            this.nMin = k;
            this.nMax = k + 1;
        } else if (k < this.nMin) {
            this.nMin = k;
        } else if (k >= this.nMax) {
            this.nMax = k + 1;
        }
    }

    public void setZero(int k) {
        if (this.coefficientValues.containsKey(k)) {
            this.coefficientValues.remove(k);
            if (k == this.nMin) {
                this.nMin = k + 1;
            }
            if (k == this.nMax) {
                this.nMax = k - 1;
            }
        }
    }

    public ASTSeriesData shift(int shift) {
        ASTSeriesData series = new ASTSeriesData(this.x, this.x0, this.nMin, this.truncate, this.denominator);
        for (int i = this.nMin; i < this.nMax; ++i) {
            series.setCoeff(i + shift, this.coefficient(i));
        }
        return series;
    }

    public ASTSeriesData shift(int shift, IExpr coefficient, int power) {
        ASTSeriesData series = new ASTSeriesData(this.x, this.x0, this.nMin, power, this.denominator);
        for (int i = this.nMin; i < this.nMax; ++i) {
            series.setCoeff(i + shift, this.coefficient(i).times(coefficient));
        }
        return series;
    }

    public ASTSeriesData shiftTimes(int shift, IExpr coefficient, int power) {
        ASTSeriesData series = new ASTSeriesData(this.x, this.x0, this.nMin, power, this.denominator);
        for (int i = this.nMin; i < this.nMax; ++i) {
            series.setCoeff(i * shift, this.coefficient(i).times(coefficient));
        }
        return series;
    }

    @Override
    public int size() {
        return 7;
    }

    @Override
    public ASTSeriesData subtract(IExpr b) {
        if (b instanceof ASTSeriesData) {
            return this.subtractPS((ASTSeriesData)b);
        }
        if (b.isZero()) {
            return this;
        }
        IExpr value = F.eval(this.coefficient(0).subtract(b));
        ASTSeriesData series = this.copy();
        if (value.isZero()) {
            series.setZero(0);
        } else {
            series.setCoeff(0, value);
        }
        return series;
    }

    public ASTSeriesData subtractPS(ASTSeriesData b) {
        int minSize = this.nMin;
        if (this.nMin > b.nMin) {
            minSize = b.nMin;
        }
        int maxSize = this.nMax;
        if (this.nMax < b.nMax) {
            maxSize = b.nMax;
        }
        int maxPower = this.truncate;
        if (this.truncate > b.truncate) {
            maxPower = b.truncate;
        }
        ASTSeriesData series = new ASTSeriesData(this.x, this.x0, minSize, maxPower, this.denominator);
        for (int i = minSize; i < maxSize; ++i) {
            series.setCoeff(i, this.coefficient(i).subtract(b.coefficient(i)));
        }
        return series;
    }

    @Override
    public ASTSeriesData times(IExpr b) {
        if (b instanceof ASTSeriesData) {
            return this.timesPS((ASTSeriesData)b);
        }
        if (b.isOne()) {
            return this;
        }
        ASTSeriesData series = this.copy();
        for (int i = this.nMin; i < this.nMax; ++i) {
            series.setCoeff(i, this.coefficient(i).times(b));
        }
        return series;
    }

    public ASTSeriesData dividePS(ASTSeriesData ps) {
        int n;
        ASTSeriesData inverse;
        if (ps.isInvertible() && (inverse = this.timesPS(ps.inverse())) != null) {
            return inverse;
        }
        int m = this.order();
        if (m < (n = ps.order())) {
            return new ASTSeriesData(F.C0, this.x0, 0, 1, 1);
        }
        if (!ps.coefficient(n).isUnit()) {
            throw new ArithmeticException("division by non unit coefficient " + ps.coefficient(n) + ", n = " + n);
        }
        ASTSeriesData st = m == 0 ? this : this.shift(-m);
        ASTSeriesData sps = n == 0 ? ps : ps.shift(-n);
        ASTSeriesData q = st.timesPS(sps.inverse());
        ASTSeriesData sq = m == n ? q : q.shift(m - n);
        return sq;
    }

    public ASTSeriesData timesPS(ASTSeriesData b) {
        if (this.equals(b)) {
            return this.sqrPS();
        }
        int minSize = this.nMin;
        if (this.nMin > b.nMin) {
            minSize = b.nMin;
        }
        int newPower = this.truncate;
        if (b.truncate > this.truncate) {
            newPower = b.truncate;
        }
        int newDenominator = this.denominator;
        if (this.denominator != b.denominator) {
            newDenominator = ArithmeticUtils.lcm((int)this.denominator, (int)b.denominator);
            int rest = newPower % newDenominator;
            if (rest != 0) {
                int div = newPower / newDenominator;
                newPower = div * newDenominator + newDenominator;
            } else {
                ++newPower;
            }
        } else if (b.truncate != this.truncate) {
            ++newPower;
        }
        return this.internalTimes(b, minSize, newPower, newDenominator);
    }

    public ASTSeriesData sqrPS() {
        return this.internalTimes(this, this.nMin, this.truncate, this.denominator);
    }

    private ASTSeriesData internalTimes(ASTSeriesData b, int minSize, int newPower, int newDenominator) {
        ASTSeriesData series = new ASTSeriesData(this.x, this.x0, this.nMin + b.nMin, newPower, newDenominator);
        int start = series.nMin;
        int end = this.nMax + b.nMax + 1;
        for (int n = start; n < end; ++n) {
            if (n - start >= series.truncate) continue;
            IASTAppendable sum = F.PlusAlloc(end - start);
            for (int i = minSize; i <= n; ++i) {
                sum.append(this.coefficient(i).times(b.coefficient(n - i)));
            }
            IExpr value = F.eval(sum);
            if (value.isZero()) continue;
            series.setCoeff(n, value);
        }
        return series;
    }

    @Override
    public IExpr[] toArray() {
        IExpr[] result = new IExpr[]{this.head(), this.arg1(), this.arg2(), this.arg3(), this.arg4(), this.arg5(), this.get(6)};
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeShort(this.fEvalFlags);
        int size = this.size();
        objectOutput.writeInt(size);
        for (int i = 0; i < size; ++i) {
            objectOutput.writeObject(this.get(i));
        }
    }

    private Object writeReplace() {
        return this.optional();
    }
}

