/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.complex.Complex;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.RealVector;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ASTElementLimitExceeded;
import org.matheclipse.core.expression.AbstractAST;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class ASTRealVector
extends AbstractAST
implements Externalizable,
RandomAccess {
    private static final Logger LOGGER = LogManager.getLogger();
    RealVector vector;

    public ASTRealVector() {
    }

    public static ASTRealVector map(IAST astVector, DoubleUnaryOperator function) {
        double[] vector = astVector.toDoubleVector();
        for (int i = 0; i < vector.length; ++i) {
            vector[i] = function.applyAsDouble(vector[i]);
        }
        return new ASTRealVector(vector, false);
    }

    public ASTRealVector(double[] vector, boolean deepCopy) {
        if (Config.MAX_AST_SIZE < vector.length) {
            throw new ASTElementLimitExceeded(vector.length);
        }
        this.vector = new ArrayRealVector(vector, deepCopy);
    }

    public ASTRealVector(RealVector vector, boolean deepCopy) {
        if (Config.MAX_AST_SIZE < vector.getDimension()) {
            throw new ASTElementLimitExceeded(vector.getDimension());
        }
        this.vector = deepCopy ? vector.copy() : vector;
    }

    @Override
    public IExpr arg1() {
        return F.num(this.vector.getEntry(0));
    }

    @Override
    public IExpr arg2() {
        return F.num(this.vector.getEntry(1));
    }

    @Override
    public IExpr arg3() {
        return F.num(this.vector.getEntry(2));
    }

    @Override
    public IExpr arg4() {
        return F.num(this.vector.getEntry(3));
    }

    @Override
    public IExpr arg5() {
        return F.num(this.vector.getEntry(4));
    }

    @Override
    public int argSize() {
        return this.vector.getDimension();
    }

    @Override
    public Set<IExpr> asSet() {
        int size = this.size();
        HashSet<IExpr> set = new HashSet<IExpr>(size > 16 ? size : 16);
        for (int i = 1; i < size; ++i) {
            set.add(this.get(i));
        }
        return set;
    }

    public IAST clone() {
        return Convert.vector2List(this.vector, false);
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof Num || object instanceof Double) {
            double d = ((Number)object).doubleValue();
            for (int i = 0; i < this.vector.getDimension(); ++i) {
                if (this.vector.getEntry(i) != d) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ASTRealVector copy() {
        return new ASTRealVector(this.vector.copy(), false);
    }

    @Override
    public IASTAppendable copyAppendable() {
        return Convert.vector2List(this.vector, false);
    }

    @Override
    public IASTAppendable copyAppendable(int additionalCapacity) {
        return this.copyAppendable();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ASTRealVector) {
            if (obj == this) {
                return true;
            }
            return this.vector.equals((Object)((ASTRealVector)obj).vector);
        }
        return false;
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        return F.NIL;
    }

    @Override
    public IExpr evalEvaluate(EvalEngine engine) {
        return F.NIL;
    }

    @Override
    public final IAST filterFunction(IASTAppendable filterAST, IASTAppendable restAST, Function<IExpr, IExpr> function) {
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            IExpr expr = function.apply(this.get(i));
            if (expr.isPresent()) {
                filterAST.append(expr);
                continue;
            }
            restAST.append(this.get(i));
        }
        return filterAST;
    }

    @Override
    public final String fullFormString() {
        return this.fullFormString(S.List);
    }

    @Override
    public IAST filter(IASTAppendable filterAST, IASTAppendable restAST, Predicate<? super IExpr> predicate) {
        return filterAST;
    }

    @Override
    public IAST filter(IASTAppendable filterAST, Predicate<? super IExpr> predicate) {
        return filterAST;
    }

    @Override
    public IExpr get(int location) {
        double val = this.vector.getEntry(location - 1);
        return F.num(val);
    }

    @Override
    public IAST getItems(int[] items, int length) {
        double[] v = new double[length];
        for (int i = 0; i < length; ++i) {
            v[i] = this.vector.getEntry(items[i] - 1);
        }
        return new ASTRealVector(v, false);
    }

    public double getEntry(int location) {
        return this.vector.getEntry(location - 1);
    }

    public RealVector getRealVector() {
        return this.vector;
    }

    @Override
    public int hashCode() {
        if (this.hashValue == 0 && this.vector != null) {
            this.hashValue = this.vector.hashCode();
        }
        return this.hashValue;
    }

    @Override
    public final IExpr head() {
        return S.List;
    }

    @Override
    public boolean isAST0() {
        return this.size() == 1;
    }

    @Override
    public boolean isAST1() {
        return this.size() == 2;
    }

    @Override
    public boolean isAST2() {
        return this.size() == 3;
    }

    @Override
    public boolean isAST3() {
        return this.size() == 4;
    }

    @Override
    public boolean isList() {
        return true;
    }

    public boolean isNaN() {
        return this.vector.isNaN();
    }

    @Override
    public boolean isRealVector() {
        return true;
    }

    @Override
    public boolean isSameHead(ISymbol head) {
        return S.List == head;
    }

    @Override
    public boolean isSameHead(ISymbol head, int length) {
        return S.List == head && this.vector.getDimension() == length - 1;
    }

    @Override
    public boolean isSameHead(ISymbol head, int minLength, int maxLength) {
        int size = this.vector.getDimension() + 1;
        return S.List == head && minLength <= size && maxLength >= size;
    }

    @Override
    public boolean isSameHeadSizeGE(ISymbol head, int length) {
        return S.List == head && length <= this.vector.getDimension() + 1;
    }

    @Override
    public final int isVector() {
        return this.vector.getDimension();
    }

    @Override
    public boolean isNumericAST() {
        return true;
    }

    @Override
    public boolean isNumericFunction(boolean allowList) {
        return allowList;
    }

    @Override
    public boolean isNumericMode() {
        return true;
    }

    @Override
    public void joinToString(StringBuilder builder, CharSequence delimiter) {
        Convert.joinToString(this.vector.toArray(), builder, delimiter);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.fEvalFlags = objectInput.readShort();
        this.vector = (RealVector)objectInput.readObject();
    }

    @Override
    public IExpr set(int location, IExpr object) {
        this.hashValue = 0;
        if (object instanceof Num) {
            double value = this.vector.getEntry(location - 1);
            this.vector.setEntry(location - 1, ((Num)object).reDoubleValue());
            return F.num(value);
        }
        throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(location) + ", Size: " + (this.vector.getDimension() + 1));
    }

    @Override
    public IASTMutable setAtCopy(int i, IExpr expr) {
        if (expr instanceof Num) {
            ASTRealVector ast = this.copy();
            ast.set(i, expr);
            return ast;
        }
        IASTAppendable ast = this.copyAppendable();
        ast.set(i, expr);
        return ast;
    }

    public void setEntry(int location, double value) {
        this.hashValue = 0;
        this.vector.setEntry(location - 1, value);
    }

    @Override
    public int size() {
        return this.vector.getDimension() + 1;
    }

    public ASTRealVector subtract(ASTRealVector that) {
        return new ASTRealVector(this.vector.subtract(that.vector), false);
    }

    @Override
    public IExpr[] toArray() {
        int dimension = this.vector.getDimension();
        IExpr[] result = new IExpr[dimension + 1];
        result[0] = S.List;
        for (int i = 0; i < dimension; ++i) {
            result[i + 1] = F.num(this.vector.getEntry(i));
        }
        return result;
    }

    @Override
    public double[] toDoubleVector() {
        return this.vector.toArray();
    }

    @Override
    public Complex[] toComplexVector() {
        double[] array = this.vector.toArray();
        int size = array.length;
        Complex[] result = new Complex[size];
        for (int i = 0; i < size; ++i) {
            result[i] = Complex.valueOf((double)array[i]);
        }
        return result;
    }

    @Override
    public RealVector toRealVector() {
        return this.vector;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf);
        return buf.toString();
    }

    public void toString(Appendable buf) {
        try {
            buf.append('{');
            int size = this.vector.getDimension();
            for (int i = 0; i < size; ++i) {
                buf.append(Double.toString(this.vector.getEntry(i)));
                if (i >= size - 1) continue;
                buf.append(",");
            }
            buf.append('}');
        }
        catch (IOException e) {
            LOGGER.debug("ASTRealVector.toString() failed", (Throwable)e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeShort(this.fEvalFlags);
        objectOutput.writeObject(this.vector);
    }
}

