/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.RealMatrix;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ASTElementLimitExceeded;
import org.matheclipse.core.expression.ASTRealVector;
import org.matheclipse.core.expression.AbstractAST;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class ASTRealMatrix
extends AbstractAST
implements Externalizable,
RandomAccess {
    private static final Logger LOGGER = LogManager.getLogger();
    RealMatrix matrix;

    public ASTRealMatrix() {
    }

    public static ASTRealMatrix map(IAST matrixAST, DoubleUnaryOperator function) {
        double[][] matrix = matrixAST.toDoubleMatrix();
        int rows = matrix.length;
        int cols = matrix[0].length;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                matrix[i][j] = function.applyAsDouble(matrix[i][j]);
            }
        }
        return new ASTRealMatrix(matrix, false);
    }

    public int getColumnDimension() {
        return this.matrix.getColumnDimension();
    }

    public int getRowDimension() {
        return this.matrix.getRowDimension();
    }

    public ASTRealMatrix(double[][] matrix, boolean deepCopy) {
        if (Config.MAX_MATRIX_DIMENSION_SIZE < matrix.length || Config.MAX_MATRIX_DIMENSION_SIZE < matrix[0].length) {
            throw new ASTElementLimitExceeded(matrix.length, matrix[0].length);
        }
        this.matrix = new Array2DRowRealMatrix(matrix, deepCopy);
    }

    public ASTRealMatrix(RealMatrix matrix, boolean deepCopy) {
        if (Config.MAX_MATRIX_DIMENSION_SIZE < matrix.getRowDimension() || Config.MAX_MATRIX_DIMENSION_SIZE < matrix.getColumnDimension()) {
            throw new ASTElementLimitExceeded(matrix.getRowDimension(), matrix.getColumnDimension());
        }
        this.matrix = deepCopy ? matrix.copy() : matrix;
    }

    @Override
    public IExpr arg1() {
        return new ASTRealVector(this.matrix.getRowVector(0), false);
    }

    @Override
    public IExpr arg2() {
        return new ASTRealVector(this.matrix.getRowVector(1), false);
    }

    @Override
    public IExpr arg3() {
        return new ASTRealVector(this.matrix.getRowVector(2), false);
    }

    @Override
    public IExpr arg4() {
        return new ASTRealVector(this.matrix.getRowVector(3), false);
    }

    @Override
    public IExpr arg5() {
        return new ASTRealVector(this.matrix.getRowVector(4), false);
    }

    @Override
    public int argSize() {
        return this.matrix.getRowDimension();
    }

    @Override
    public Set<IExpr> asSet() {
        int size = this.size();
        HashSet<IExpr> set = new HashSet<IExpr>(size > 16 ? size : 16);
        for (int i = 1; i < size; ++i) {
            set.add(this.get(i));
        }
        return set;
    }

    public IAST clone() {
        return Convert.matrix2List(this.matrix, false);
    }

    @Override
    public boolean contains(Object object) {
        return false;
    }

    @Override
    public IASTMutable copy() {
        return new ASTRealMatrix(this.matrix.copy(), false);
    }

    @Override
    public IASTAppendable copyAppendable() {
        return Convert.matrix2List(this.matrix, false);
    }

    @Override
    public IASTAppendable copyAppendable(int additionalCapacity) {
        return this.copyAppendable();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ASTRealMatrix) {
            if (obj == this) {
                return true;
            }
            return this.matrix.equals(((ASTRealMatrix)obj).matrix);
        }
        return false;
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        return F.NIL;
    }

    @Override
    public IExpr evalEvaluate(EvalEngine engine) {
        return F.NIL;
    }

    @Override
    public final IAST filterFunction(IASTAppendable filterAST, IASTAppendable restAST, Function<IExpr, IExpr> function) {
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            IExpr expr = function.apply(this.get(i));
            if (expr.isPresent()) {
                filterAST.append(expr);
                continue;
            }
            restAST.append(this.get(i));
        }
        return filterAST;
    }

    @Override
    public IAST filter(IASTAppendable filterAST, IASTAppendable restAST, Predicate<? super IExpr> predicate) {
        return filterAST;
    }

    @Override
    public IAST filter(IASTAppendable filterAST, Predicate<? super IExpr> predicate) {
        return filterAST;
    }

    @Override
    public IExpr get(int location) {
        return new ASTRealVector(this.matrix.getRowVector(location - 1), false);
    }

    @Override
    public IAST getItems(int[] items, int length) {
        double[][] m = new double[length][];
        for (int i = 0; i < length; ++i) {
            m[i] = this.matrix.getRow(items[i] - 1);
        }
        return new ASTRealMatrix(m, false);
    }

    @Override
    public final IExpr getPart(int ... positions) {
        if (positions.length == 2) {
            return F.num(this.matrix.getEntry(positions[0], positions[1]));
        }
        return super.getPart(positions);
    }

    public RealMatrix getRealMatrix() {
        return this.matrix;
    }

    @Override
    public int hashCode() {
        if (this.hashValue == 0 && this.matrix != null) {
            this.hashValue = this.matrix.hashCode();
        }
        return this.hashValue;
    }

    @Override
    public final IExpr head() {
        return S.List;
    }

    @Override
    public boolean isAST0() {
        return false;
    }

    @Override
    public boolean isAST1() {
        return false;
    }

    @Override
    public boolean isAST2() {
        return false;
    }

    @Override
    public boolean isAST3() {
        return false;
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public boolean isListOfLists() {
        return true;
    }

    @Override
    public final int[] isMatrix(boolean setMatrixFormat) {
        return new int[]{this.matrix.getRowDimension(), this.matrix.getColumnDimension()};
    }

    @Override
    public boolean isNumericFunction(boolean allowList) {
        return allowList;
    }

    @Override
    public boolean isNumericMode() {
        return true;
    }

    @Override
    public int[] isPiecewise() {
        return null;
    }

    @Override
    public boolean isRealMatrix() {
        return true;
    }

    @Override
    public boolean isSameHead(ISymbol head) {
        return S.List == head;
    }

    @Override
    public boolean isSameHead(ISymbol head, int length) {
        return S.List == head && this.matrix.getRowDimension() == length - 1;
    }

    @Override
    public boolean isSameHead(ISymbol head, int minLength, int maxLength) {
        int size = this.matrix.getRowDimension() + 1;
        return S.List == head && minLength <= size && maxLength >= size;
    }

    @Override
    public boolean isSameHeadSizeGE(ISymbol head, int length) {
        return S.List == head && length <= this.matrix.getRowDimension() + 1;
    }

    @Override
    public IExpr mapMatrixColumns(int[] dim, Function<IExpr, IExpr> f) {
        int columnSize = dim[1];
        IASTAppendable result = F.ListAlloc(columnSize);
        return result.appendArgs(0, columnSize, j -> (IExpr)f.apply(new ASTRealVector(this.matrix.getColumnVector(j), false)));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.fEvalFlags = objectInput.readShort();
        this.matrix = (RealMatrix)objectInput.readObject();
    }

    @Override
    public IExpr set(int location, IExpr object) {
        this.hashValue = 0;
        if (object instanceof ASTRealVector) {
            ASTRealVector value = new ASTRealVector(this.matrix.getRowVector(location - 1), false);
            this.matrix.setRowVector(location - 1, ((ASTRealVector)object).vector);
            return value;
        }
        throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(location) + ", Size: " + (this.matrix.getRowDimension() + 1));
    }

    @Override
    public IASTMutable setAtCopy(int i, IExpr expr) {
        if (expr instanceof ASTRealVector) {
            IASTMutable ast = this.copy();
            ast.set(i, expr);
            return ast;
        }
        IASTAppendable ast = this.copyAppendable();
        ast.set(i, expr);
        return ast;
    }

    @Override
    public int size() {
        return this.matrix.getRowDimension() + 1;
    }

    @Override
    public IExpr[] toArray() {
        int rowDimension = this.matrix.getRowDimension();
        IExpr[] result = new IExpr[rowDimension + 1];
        result[0] = S.List;
        for (int i = 0; i < rowDimension; ++i) {
            result[i + 1] = new ASTRealVector(this.matrix.getRowVector(i), false);
        }
        return result;
    }

    @Override
    public double[][] toDoubleMatrix() {
        return this.matrix.getData();
    }

    @Override
    public RealMatrix toRealMatrix() {
        return this.matrix;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf, false);
        return buf.toString();
    }

    public void toString(Appendable buf, boolean isEmpty) {
        try {
            if (!isEmpty) {
                buf.append('\n');
            }
            buf.append('{');
            int rows = this.matrix.getRowDimension();
            int cols = this.matrix.getColumnDimension();
            for (int i = 0; i < rows; ++i) {
                if (i != 0) {
                    buf.append(" ");
                }
                buf.append("{");
                for (int j = 0; j < cols; ++j) {
                    buf.append(Double.toString(this.matrix.getEntry(i, j)));
                    if (j >= cols - 1) continue;
                    buf.append(",");
                }
                buf.append('}');
                if (i >= rows - 1) continue;
                buf.append(",");
                buf.append('\n');
            }
            buf.append('}');
        }
        catch (IOException e) {
            LOGGER.debug("ASTRealMatrix.toString() failed", (Throwable)e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeShort(this.fEvalFlags);
        objectOutput.writeObject(this.matrix);
    }
}

