/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.exception.ASTElementLimitExceeded;
import org.matheclipse.core.expression.AbstractAST;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.generic.ObjIntPredicate;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.organicdesign.fp.StaticImports;
import org.organicdesign.fp.collections.RrbTree;
import org.organicdesign.fp.collections.UnmodListIterator;

public class ASTRRBTree
extends AbstractAST
implements IASTAppendable,
Externalizable,
RandomAccess {
    protected RrbTree.MutRrbt<IExpr> rrbTree;

    public ASTRRBTree() {
        this.rrbTree = StaticImports.mutableRrb((Object[])new IExpr[0]);
    }

    public ASTRRBTree(int size, boolean test) {
        this.rrbTree = StaticImports.mutableRrb((Object[])new IExpr[0]);
    }

    public void ensureCapacity(int size) {
    }

    public static ASTRRBTree newInstance(int initialCapacity, IExpr head) {
        if (Config.MAX_AST_SIZE < initialCapacity || initialCapacity < 0) {
            ASTElementLimitExceeded.throwIt(initialCapacity);
        }
        return new ASTRRBTree((RrbTree.MutRrbt<IExpr>)StaticImports.mutableRrb((Object[])new IExpr[]{head}));
    }

    public ASTRRBTree(IAST ast) {
        if (Config.MAX_AST_SIZE < ast.size()) {
            throw new ASTElementLimitExceeded(ast.size());
        }
        if (ast instanceof ASTRRBTree) {
            this.rrbTree = ((ASTRRBTree)ast).rrbTree.toMutRrbt();
        } else {
            this.rrbTree = StaticImports.mutableRrb((Object[])new IExpr[0]);
            for (int i = 0; i < ast.size(); ++i) {
                this.rrbTree.append((Object)ast.getRule(i));
            }
        }
    }

    public ASTRRBTree(RrbTree.MutRrbt<IExpr> list) {
        if (Config.MAX_AST_SIZE < list.size()) {
            throw new ASTElementLimitExceeded(list.size());
        }
        this.rrbTree = list.toMutRrbt();
    }

    public ASTRRBTree(RrbTree.ImRrbt<IExpr> list) {
        if (Config.MAX_AST_SIZE < list.size()) {
            throw new ASTElementLimitExceeded(list.size());
        }
        this.rrbTree = list.toMutRrbt();
    }

    public ASTRRBTree(IExpr[] array) {
        if (Config.MAX_AST_SIZE < array.length) {
            throw new ASTElementLimitExceeded(array.length);
        }
        this.rrbTree = StaticImports.mutableRrb((Object[])array);
    }

    @Override
    public IExpr arg1() {
        return (IExpr)this.rrbTree.get(1);
    }

    @Override
    public IExpr arg2() {
        return (IExpr)this.rrbTree.get(2);
    }

    @Override
    public IExpr arg3() {
        return (IExpr)this.rrbTree.get(3);
    }

    @Override
    public IExpr arg4() {
        return (IExpr)this.rrbTree.get(4);
    }

    @Override
    public IExpr arg5() {
        return (IExpr)this.rrbTree.get(5);
    }

    @Override
    public int argSize() {
        return this.rrbTree.size() - 1;
    }

    @Override
    public Set<IExpr> asSet() {
        int size = this.size();
        HashSet<IExpr> set = new HashSet<IExpr>(size > 16 ? size : 16);
        for (int i = 1; i < size; ++i) {
            set.add(this.get(i));
        }
        return set;
    }

    public IAST clone() {
        return this.copy();
    }

    @Override
    public ASTRRBTree copy() {
        return new ASTRRBTree(this.rrbTree);
    }

    @Override
    public IASTAppendable copyAppendable() {
        return this.copy();
    }

    @Override
    public IASTAppendable copyAppendable(int additionalCapacity) {
        return this.copyAppendable();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractAST) {
            AbstractAST ast = (AbstractAST)obj;
            int size = this.size();
            if (size != ast.size()) {
                return false;
            }
            IExpr head = this.head();
            if (head instanceof ISymbol ? head != ast.head() : !head.equals(ast.head())) {
                return false;
            }
            if (this.hashCode() != ((Object)ast).hashCode()) {
                return false;
            }
            return this.forAll((? super IExpr x, int i) -> x.equals(ast.getRule(i)), 1);
        }
        return false;
    }

    @Override
    public boolean exists(ObjIntPredicate<? super IExpr> predicate, int startOffset) {
        int size = this.size();
        UnmodListIterator iter = this.rrbTree.listIterator(startOffset);
        for (int i = startOffset; i < size; ++i) {
            if (!predicate.test((IExpr)iter.next(), i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean exists(Predicate<? super IExpr> predicate, int startOffset) {
        int size = this.size();
        UnmodListIterator iter = this.rrbTree.listIterator(startOffset);
        for (int i = startOffset; i < size; ++i) {
            if (!predicate.test((IExpr)iter.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean forAll(ObjIntPredicate<? super IExpr> predicate, int startOffset) {
        int size = this.size();
        UnmodListIterator iter = this.rrbTree.listIterator(startOffset);
        for (int i = startOffset; i < size; ++i) {
            if (predicate.test((IExpr)iter.next(), i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forAll(Predicate<? super IExpr> predicate, int startOffset) {
        int size = this.size();
        UnmodListIterator iter = this.rrbTree.listIterator(startOffset);
        for (int i = startOffset; i < size; ++i) {
            if (predicate.test((IExpr)iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void forEach(int start, int end, ObjIntConsumer<? super IExpr> action) {
        UnmodListIterator iter = this.rrbTree.listIterator(start);
        for (int i = start; i < end; ++i) {
            action.accept((IExpr)iter.next(), i);
        }
    }

    @Override
    public void forEach(int start, int end, Consumer<? super IExpr> action) {
        UnmodListIterator iter = this.rrbTree.listIterator(start);
        for (int i = start; i < end; ++i) {
            action.accept((IExpr)iter.next());
        }
    }

    @Override
    public IExpr get(int location) {
        return (IExpr)this.rrbTree.get(location);
    }

    @Override
    public IAST getItems(int[] items, int length) {
        RrbTree.MutRrbt mutableRrb = StaticImports.mutableRrb((Object[])new IExpr[0]);
        mutableRrb.append((Object)this.head());
        for (int i = 0; i < length; ++i) {
            mutableRrb = mutableRrb.append((Object)this.get(items[i]));
        }
        return new ASTRRBTree((RrbTree.MutRrbt<IExpr>)mutableRrb);
    }

    @Override
    public int hashCode() {
        if (this.hashValue == 0) {
            this.hashValue = -2128831035;
            UnmodListIterator iter = this.rrbTree.listIterator(0);
            while (iter.hasNext()) {
                this.hashValue = this.hashValue * 16777619 ^ ((IExpr)iter.next()).hashCode() & 0xFF;
            }
        }
        return this.hashValue;
    }

    @Override
    public IExpr head() {
        return (IExpr)this.rrbTree.get(0);
    }

    @Override
    public boolean isAST0() {
        return this.size() == 1;
    }

    @Override
    public boolean isAST1() {
        return this.size() == 2;
    }

    @Override
    public boolean isAST2() {
        return this.size() == 3;
    }

    @Override
    public boolean isAST3() {
        return this.size() == 4;
    }

    @Override
    public boolean isList() {
        return this.head() == S.List;
    }

    @Override
    public boolean isSameHead(ISymbol head) {
        return this.head() == head;
    }

    @Override
    public boolean isSameHead(ISymbol head, int length) {
        return this.head() == head && this.rrbTree.size() == length;
    }

    @Override
    public boolean isSameHead(ISymbol head, int minLength, int maxLength) {
        int size = this.rrbTree.size();
        return this.head() == head && minLength <= size && maxLength >= size;
    }

    @Override
    public boolean isSameHeadSizeGE(ISymbol head, int length) {
        return this.head() == head && length <= this.rrbTree.size();
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.fEvalFlags = objectInput.readShort();
        this.rrbTree = ((RrbTree.ImRrbt)objectInput.readObject()).toMutRrbt();
    }

    @Override
    public IExpr set(int location, IExpr object) {
        this.hashValue = 0;
        if (location < this.rrbTree.size()) {
            IExpr value = (IExpr)this.rrbTree.get(location);
            this.rrbTree = this.rrbTree.replace(location, (Object)object);
            return value;
        }
        throw new IndexOutOfBoundsException("Index: " + location + ", Size: " + this.rrbTree.size());
    }

    @Override
    public IASTMutable setAtCopy(int i, IExpr expr) {
        ASTRRBTree ast = this.copy();
        ast.set(i, expr);
        return ast;
    }

    @Override
    public void sortInplace(Comparator<IExpr> comparator) {
        this.hashValue = 0;
        int size = this.rrbTree.size();
        Object[] a = new IExpr[size];
        this.rrbTree.toArray(a);
        Arrays.sort(a, 1, a.length, comparator);
        this.rrbTree = StaticImports.mutableRrb((Object[])a);
    }

    @Override
    public final int size() {
        return this.rrbTree.size();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeShort(this.fEvalFlags);
        objectOutput.writeObject(this.rrbTree.immutable());
    }

    @Override
    public IExpr[] toArray() {
        int size = this.rrbTree.size();
        Object[] result = new IExpr[size];
        return (IExpr[])this.rrbTree.toArray(result);
    }

    @Override
    public boolean append(IExpr expr) {
        this.hashValue = 0;
        this.rrbTree = this.rrbTree.append((Object)expr);
        return true;
    }

    @Override
    public void append(int location, IExpr expr) {
        this.hashValue = 0;
        if (location >= 0 && location <= this.size()) {
            if (location == this.size()) {
                this.append(expr);
                return;
            }
            this.rrbTree = this.rrbTree.insert(location, (Object)expr);
            return;
        }
        throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(location) + ", Size: " + this.size());
    }

    @Override
    public boolean appendAll(Collection<? extends IExpr> collection) {
        this.hashValue = 0;
        this.rrbTree.addAll(collection);
        return true;
    }

    @Override
    public boolean appendAll(Map<? extends IExpr, ? extends IExpr> map) {
        this.hashValue = 0;
        for (Map.Entry<? extends IExpr, ? extends IExpr> entry : map.entrySet()) {
            this.rrbTree.append((Object)F.Rule(entry.getKey(), entry.getValue()));
        }
        return true;
    }

    @Override
    public boolean appendAll(IAST ast, int startPosition, int endPosition) {
        if (ast.size() > 0 && startPosition < endPosition) {
            this.hashValue = 0;
            for (int i = startPosition; i < endPosition; ++i) {
                this.rrbTree = this.rrbTree.append((Object)ast.get(i));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean appendAll(int location, Collection<? extends IExpr> collection) {
        int i;
        this.hashValue = 0;
        int size = this.rrbTree.size();
        if (location < 0 || location > size) {
            throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(location) + ", Size: " + size);
        }
        if (location == size) {
            this.appendAll(collection);
            return true;
        }
        RrbTree.MutRrbt mutable = StaticImports.mutableRrb((Object[])new IExpr[0]);
        for (i = 0; i < location; ++i) {
            mutable = mutable.append((Object)((IExpr)this.rrbTree.get(i)));
        }
        mutable.addAll(collection);
        for (i = location; i < this.rrbTree.size(); ++i) {
            mutable = mutable.append((Object)((IExpr)this.rrbTree.get(i)));
        }
        this.rrbTree = mutable;
        return true;
    }

    @Override
    public boolean appendAll(List<? extends IExpr> list, int startPosition, int endPosition) {
        if (list.size() > 0 && startPosition < endPosition) {
            this.hashValue = 0;
            for (int i = startPosition; i < endPosition; ++i) {
                this.rrbTree = this.rrbTree.append((Object)list.get(i));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean appendAll(IExpr[] args, int startPosition, int endPosition) {
        if (args.length > 0 && startPosition < endPosition) {
            this.hashValue = 0;
            for (int i = startPosition; i < endPosition; ++i) {
                this.rrbTree = this.rrbTree.append((Object)args[i]);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean appendArgs(IAST ast) {
        return this.appendArgs(ast, ast.size());
    }

    @Override
    public boolean appendArgs(IAST ast, int untilPosition) {
        if (untilPosition > 1) {
            this.hashValue = 0;
            for (int i = 1; i < untilPosition; ++i) {
                this.rrbTree = this.rrbTree.append((Object)ast.get(i));
            }
            return true;
        }
        return false;
    }

    @Override
    public IASTAppendable appendArgs(int start, int end, IntFunction<IExpr> function) {
        IExpr temp;
        if (start >= end) {
            return this;
        }
        this.hashValue = 0;
        for (int i = start; i < end && (temp = function.apply(i)).isPresent(); ++i) {
            this.rrbTree = this.rrbTree.append((Object)temp);
        }
        return this;
    }

    @Override
    public IASTAppendable appendArgs(int end, IntFunction<IExpr> function) {
        return this.appendArgs(1, end, function);
    }

    @Override
    public IAST appendOneIdentity(IAST value) {
        if (value.isAST1()) {
            this.append(value.arg1());
        } else {
            this.append(value);
        }
        return this;
    }

    @Override
    public void clear() {
        this.hashValue = 0;
        this.fEvalFlags = 0;
        this.rrbTree = StaticImports.mutableRrb((Object[])new IExpr[0]);
    }

    @Override
    public IExpr remove(int location) {
        this.hashValue = 0;
        int size = this.rrbTree.size();
        if (location >= 0 && location < size) {
            IExpr expr = (IExpr)this.rrbTree.get(location);
            this.rrbTree = this.rrbTree.without(location);
            return expr;
        }
        throw new IndexOutOfBoundsException("Index: " + location);
    }

    @Override
    public void removeRange(int start, int end) {
        this.hashValue = 0;
        int size = this.rrbTree.size();
        if (start >= 0 && start <= end && end <= size) {
            if (start == end) {
                return;
            }
            for (int i = end - 1; i >= start; --i) {
                this.rrbTree = this.rrbTree.without(i);
            }
        } else {
            throw new IndexOutOfBoundsException("Index: " + this.size());
        }
    }
}

