/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.matheclipse.core.eval.EvalAttributes;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.expression.ASTRRBTree;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.visit.IVisitor;
import org.organicdesign.fp.StaticImports;
import org.organicdesign.fp.collections.MutMap;
import org.organicdesign.fp.collections.RrbTree;
import org.organicdesign.fp.collections.UnmodMap;

public class ASTAssociation
extends ASTRRBTree
implements IAssociation {
    private transient MutMap<IExpr, Integer> keyToIndexMap = StaticImports.mutableMap((Map.Entry[])new Map.Entry[0]);

    public ASTAssociation() {
        super(10, false);
        this.append(S.Association);
    }

    ASTAssociation(IAST listOfRules) {
        super(listOfRules.size(), false);
        this.append(S.Association);
        this.appendRules(listOfRules);
    }

    @Override
    public IExpr accept(IVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean append(IExpr expr) {
        if (expr.isRuleAST() || this.size() == 0) {
            return super.append(expr);
        }
        throw new ArgumentTypeException("invdt2", F.list(expr));
    }

    @Override
    public final void appendRule(IExpr rule) {
        int index = this.size();
        if (rule.isRuleAST()) {
            int value = this.getInt(rule.first());
            if (value == 0) {
                this.append(rule);
                this.keyToIndexMap.assoc((Object)rule.first(), (Object)index++);
            } else {
                this.set(value, rule);
            }
        } else if (!rule.isEmptyList()) {
            throw new ArgumentTypeException("rule expression expected instead of " + rule.toString());
        }
    }

    private static final int appendRule(ASTAssociation assoc, int index, IAST rule) {
        if (rule.isRuleAST()) {
            int indexValue = assoc.getInt(rule.first());
            if (indexValue == 0) {
                assoc.appendRule(rule);
            } else {
                assoc.set(indexValue, rule);
            }
            return index;
        }
        throw new ArgumentTypeException("rule expression expected instead of " + rule.toString());
    }

    private int getInt(IExpr key) {
        Integer value = (Integer)this.keyToIndexMap.get((Object)key);
        return value == null ? 0 : value;
    }

    @Override
    public void appendRules(IAST listOfRules) {
        this.appendRules(listOfRules, 1, listOfRules.size());
    }

    @Override
    public void appendRules(IAST listOfRules, int startPosition, int endPosition) {
        this.appendRules(this.size(), listOfRules, startPosition, endPosition);
    }

    private void appendRules(int index, IAST listOfRules, int startPosition, int endPosition) {
        if (listOfRules.isRuleAST()) {
            ASTAssociation.appendRule(this, index, listOfRules);
        } else {
            for (int i = startPosition; i < endPosition; ++i) {
                IExpr rule = listOfRules.getRule(i);
                if (rule.isAssociation()) {
                    ASTAssociation assoc = (ASTAssociation)rule;
                    for (int j = 1; j < assoc.size(); ++j) {
                        index = ASTAssociation.appendRule(this, index, assoc.getRule(j));
                    }
                    continue;
                }
                if (rule.isRuleAST()) {
                    index = ASTAssociation.appendRule(this, index, (IAST)rule);
                    continue;
                }
                if (rule.isList()) {
                    IAST list = (IAST)rule;
                    this.appendRules(index, list, 1, list.size());
                    continue;
                }
                throw new ArgumentTypeException("rule expression expected instead of " + rule.toString());
            }
        }
    }

    @Override
    public IExpr arg1() {
        return this.get(1);
    }

    @Override
    public IExpr arg2() {
        return this.get(2);
    }

    @Override
    public IExpr arg3() {
        return this.get(3);
    }

    @Override
    public IExpr arg4() {
        return this.get(4);
    }

    @Override
    public IExpr arg5() {
        return this.get(5);
    }

    @Override
    public ASTAssociation copy() {
        ASTAssociation ast = new ASTAssociation();
        ast.rrbTree = this.rrbTree.toMutRrbt();
        ast.hashValue = 0;
        ast.keyToIndexMap = this.keyToIndexMap.toMutMap(x -> x);
        return ast;
    }

    @Override
    public IASTAppendable copyAppendable() {
        return this.copy();
    }

    @Override
    public IASTAppendable copyAppendable(int additionalCapacity) {
        return this.copy();
    }

    @Override
    public IASTAppendable copyAST() {
        IASTAppendable result = F.ast((IExpr)S.Association, this.size());
        for (int i = 1; i < this.size(); ++i) {
            result.append(this.getValue(i));
        }
        return result;
    }

    @Override
    public IASTAppendable copyHead() {
        return F.ast((IExpr)S.Association, this.size());
    }

    @Override
    public IASTAppendable copyHead(int intialCapacity) {
        return F.ast((IExpr)S.Association, intialCapacity);
    }

    @Override
    public IASTAppendable copyUntil(int index) {
        return this.copyUntil(index, index);
    }

    @Override
    public final IASTAppendable copyUntil(int intialCapacity, int index) {
        ASTAssociation result = new ASTAssociation();
        result.appendRules(this.normal(false), 1, index);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ASTAssociation) {
            ASTAssociation assoc = (ASTAssociation)obj;
            RrbTree.MutRrbt imList = assoc.rrbTree;
            int size = this.rrbTree.size();
            if (imList.size() == size) {
                for (int i = 0; i < size; ++i) {
                    if (((IExpr)this.rrbTree.get(i)).equals(imList.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        if (this.isEvalFlagOff(262144)) {
            IAssociation result = F.NIL;
            for (int i = 1; i < this.size(); ++i) {
                IExpr temp;
                IAST arg = this.getRule(i);
                if (!arg.isRule() || !(temp = engine.evaluateNIL(arg.second())).isPresent()) continue;
                if (!result.isPresent()) {
                    result = this.copy();
                }
                result.set(i, this.getRule(i).setAtCopy(2, temp));
            }
            if (result.isPresent()) {
                result.addEvalFlags(262144);
                return result;
            }
            this.addEvalFlags(262144);
        }
        return F.NIL;
    }

    @Override
    public IAST filter(IASTAppendable filterAST, Predicate<? super IExpr> predicate) {
        if (filterAST instanceof ASTAssociation) {
            for (int i = 1; i < this.size(); ++i) {
                if (!predicate.test(this.getValue(i))) continue;
                ((ASTAssociation)filterAST).appendRule(this.getRule(i));
            }
            return filterAST;
        }
        return super.filter(filterAST, predicate);
    }

    @Override
    public IAST filter(IASTAppendable filterAST, Predicate<? super IExpr> predicate, int maxMatches) {
        if (filterAST instanceof ASTAssociation) {
            int[] count = new int[1];
            if (count[0] >= maxMatches) {
                return filterAST;
            }
            for (int i = 1; i < this.size(); ++i) {
                if (!predicate.test(this.getValue(i))) continue;
                count[0] = count[0] + 1;
                if (count[0] == maxMatches) {
                    ((ASTAssociation)filterAST).appendRule(this.getRule(i));
                    break;
                }
                ((ASTAssociation)filterAST).appendRule(this.getRule(i));
            }
            return filterAST;
        }
        return super.filter(filterAST, predicate, maxMatches);
    }

    @Override
    public void forEach(Consumer<? super IExpr> action, int startOffset) {
        for (int i = startOffset; i < this.size(); ++i) {
            action.accept(this.getValue(i));
        }
    }

    @Override
    public void forEach(int startOffset, int endOffset, Consumer<? super IExpr> action) {
        for (int i = startOffset; i < endOffset; ++i) {
            action.accept(this.getValue(i));
        }
    }

    @Override
    public void forEach(int startOffset, int endOffset, ObjIntConsumer<? super IExpr> action) {
        for (int i = startOffset; i < endOffset; ++i) {
            action.accept(this.getValue(i), i);
        }
    }

    @Override
    public String fullFormString() {
        return this.normal(S.Association).fullFormString();
    }

    @Override
    public IExpr get(int position) {
        if (position == 0) {
            return this.head();
        }
        return super.get(position).second();
    }

    @Override
    public IAST getItems(int[] items, int length) {
        ASTAssociation assoc = new ASTAssociation();
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                assoc.appendRule(this.getRule(items[i]));
            }
        }
        return assoc;
    }

    @Override
    public IExpr getKey(int position) {
        IExpr temp = this.getRule(position).first();
        if (temp.isPresent()) {
            return F.Key(temp);
        }
        return F.C0;
    }

    @Override
    public IAST getRule(String key) {
        int index = (Integer)this.keyToIndexMap.get((Object)F.$str(key));
        if (index > 0) {
            return this.getRule(index);
        }
        return F.NIL;
    }

    @Override
    public IAST getRule(IExpr key) {
        int index = this.getInt(key);
        if (index > 0) {
            return this.getRule(index);
        }
        return F.NIL;
    }

    @Override
    public IAST getRule(int position) {
        IExpr temp = super.get(position);
        if (temp != null && temp.isRuleAST()) {
            return (IAST)temp;
        }
        return F.NIL;
    }

    @Override
    public IExpr getValue(IExpr key) {
        return this.getValue(key, () -> F.Missing(F.stringx("KeyAbsent"), key));
    }

    @Override
    public IExpr getValue(IExpr key, Supplier<IExpr> defaultValue) {
        int index = this.getInt(key);
        if (index == 0) {
            return defaultValue.get();
        }
        return this.getValue(index);
    }

    @Override
    public IExpr getValue(int position) {
        if (position == 0) {
            return super.get(position);
        }
        return super.get(position).second();
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 19;
    }

    @Override
    public int indexOf(IExpr expr) {
        for (int i = 1; i < this.size(); ++i) {
            if (!expr.equals(this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int indexOf(Predicate<? super IExpr> predicate, int fromIndex) {
        for (int i = 1; i < this.size(); ++i) {
            if (!predicate.test(this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isAssociation() {
        return true;
    }

    @Override
    public boolean isAST() {
        return false;
    }

    @Override
    public boolean isAST(IExpr header) {
        return false;
    }

    @Override
    public boolean isAST(IExpr header, int length) {
        return false;
    }

    @Override
    public boolean isAST(IExpr header, int length, IExpr ... args) {
        return false;
    }

    @Override
    public final boolean isAST(IExpr head, int minLength, int maxLength) {
        return false;
    }

    @Override
    public final boolean isAST(String symbol) {
        return false;
    }

    @Override
    public final boolean isAST(String symbol, int length) {
        return false;
    }

    @Override
    public boolean isAST0() {
        return false;
    }

    @Override
    public boolean isAST1() {
        return false;
    }

    @Override
    public boolean isAST2() {
        return false;
    }

    @Override
    public boolean isAST3() {
        return false;
    }

    @Override
    public boolean isAtom() {
        return true;
    }

    @Override
    public boolean isKey(IExpr key) {
        return this.keyToIndexMap.containsKey((Object)key);
    }

    @Override
    public boolean isListOrAssociation() {
        return true;
    }

    public ArrayList<String> keyNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (UnmodMap.UnEntry element : this.keyToIndexMap) {
            list.add(((IExpr)element.getKey()).toString());
        }
        return list;
    }

    @Override
    public IASTMutable keys() {
        return this.keys(S.List);
    }

    protected IASTMutable keys(IBuiltInSymbol symbol) {
        IASTMutable list = F.astMutable(symbol, this.argSize());
        for (UnmodMap.UnEntry element : this.keyToIndexMap) {
            int value = (Integer)element.getValue();
            list.set(value, (IExpr)element.getKey());
        }
        return list;
    }

    @Override
    public IAssociation keySort() {
        return this.keySort(null);
    }

    @Override
    public IAssociation keySort(Comparator<IExpr> comparator) {
        IASTMutable list = this.keys();
        if (comparator == null) {
            EvalAttributes.sort(list);
        } else {
            EvalAttributes.sort(list, comparator);
        }
        ASTAssociation assoc = new ASTAssociation();
        for (int i = 1; i < list.size(); ++i) {
            IExpr key = list.get(i);
            int value = this.getInt(key);
            assoc.appendRule(this.getRule(value));
        }
        return assoc;
    }

    @Override
    public IAST map(Function<IExpr, IExpr> function, int startOffset) {
        IExpr temp;
        int i;
        ASTAssociation result = null;
        int size = this.size();
        for (i = startOffset; i < size; ++i) {
            temp = function.apply(this.getValue(i));
            if (!temp.isPresent()) continue;
            result = this.copy();
            result.set(i, this.getRule(i).setAtCopy(2, temp));
            ++i;
            break;
        }
        if (result != null) {
            while (i < size) {
                temp = function.apply(this.getValue(i));
                if (temp.isPresent()) {
                    result.set(i, this.getRule(i).setAtCopy(2, temp));
                }
                ++i;
            }
        }
        if (result != null) {
            return result;
        }
        return this;
    }

    @Override
    public IAST mapReverse(Function<IExpr, IExpr> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IAST matrixOrList() {
        IASTAppendable list;
        boolean numericKeys = true;
        try {
            for (UnmodMap.UnEntry element : this.keyToIndexMap) {
                IExpr key = (IExpr)element.getKey();
                if (key.isReal()) continue;
                double d = key.evalDouble();
                numericKeys = false;
                break;
            }
        }
        catch (RuntimeException rex) {
            numericKeys = false;
        }
        if (numericKeys) {
            list = F.ListAlloc(this.keyToIndexMap.size());
            for (UnmodMap.UnEntry element : this.keyToIndexMap) {
                IExpr key = (IExpr)element.getKey();
                int value = (Integer)element.getValue();
                list.append(F.list(key, this.getValue(value)));
            }
            return list;
        }
        list = F.ListAlloc(this.size());
        for (int i = 1; i < this.size(); ++i) {
            list.append(this.getValue(i));
        }
        return list;
    }

    @Override
    public IAST most() {
        if (this.size() > 1) {
            return this.splice(this.argSize());
        }
        return F.NIL;
    }

    @Override
    public IASTMutable normal(boolean nilIfUnevaluated) {
        return this.normal(S.List);
    }

    protected IASTMutable normal(IBuiltInSymbol symbol) {
        IExpr[] arr = new IExpr[this.size() - 1];
        for (int i = 1; i < this.rrbTree.size(); ++i) {
            arr[i - 1] = (IExpr)this.rrbTree.get(i);
        }
        return F.ast(arr, symbol);
    }

    @Override
    public final void prependRule(IExpr rule) {
        if (rule.isRuleAST()) {
            int value = this.getInt(rule.first());
            this.hashValue = 0;
            if (value != 0) {
                this.remove(value);
            }
            this.insertAt(1, rule);
        } else if (!rule.isEmptyList()) {
            throw new ArgumentTypeException("rule expression expected instead of " + rule.toString());
        }
    }

    private void insertAt(int position, IExpr rule) {
        this.rrbTree.insert(position, (Object)rule);
        for (UnmodMap.UnEntry element : this.keyToIndexMap) {
            int indx = (Integer)element.getValue();
            if (indx < position) continue;
            this.keyToIndexMap.assoc((Object)((IExpr)element.getKey()), (Object)(indx + 1));
        }
        this.keyToIndexMap.assoc((Object)rule.first(), (Object)1);
    }

    @Override
    public void prependRules(IAST listOfRules) {
        this.prependRules(listOfRules, 1, listOfRules.size());
    }

    @Override
    public void prependRules(IAST listOfRules, int startPosition, int endPosition) {
        if (listOfRules.isRuleAST()) {
            this.prependRule(listOfRules);
        } else {
            for (int i = endPosition - 1; i >= startPosition; --i) {
                IExpr rule = listOfRules.getRule(i);
                if (rule.isAssociation()) {
                    ASTAssociation assoc = (ASTAssociation)rule;
                    for (int j = 1; j < assoc.size(); ++j) {
                        rule = assoc.getRule(j);
                        this.prependRule(rule);
                    }
                    continue;
                }
                if (rule.isRuleAST()) {
                    this.prependRule(rule);
                    continue;
                }
                if (rule.isList()) {
                    IAST list = (IAST)rule;
                    this.prependRules(list, 1, list.size());
                    continue;
                }
                throw new ArgumentTypeException("rule expression expected instead of " + rule.toString());
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        IAST ast = (IAST)objectInput.readObject();
        for (int i = 1; i < ast.size(); ++i) {
            this.appendRule(ast.get(i));
        }
    }

    @Override
    public IExpr remove(int location) throws IndexOutOfBoundsException {
        this.hashValue = 0;
        IExpr result = super.remove(location);
        MutMap mutable = this.keyToIndexMap.toMutMap(x -> x);
        mutable.without((Object)result.first());
        for (UnmodMap.UnEntry element : this.keyToIndexMap) {
            int indx = (Integer)element.getValue();
            if (indx < location) continue;
            mutable = mutable.assoc((Object)((IExpr)element.getKey()), (Object)(indx - 1));
        }
        this.keyToIndexMap = mutable;
        return result;
    }

    @Override
    public final IASTMutable removeAtCopy(int position) {
        ASTAssociation assoc = this.copy();
        assoc.remove(position);
        return assoc;
    }

    @Override
    public IAST rest() {
        if (this.size() > 1) {
            return this.removeAtCopy(1);
        }
        return this;
    }

    @Override
    public IAssociation reverse(IAssociation newAssoc) {
        for (int i = this.argSize(); i >= 1; --i) {
            newAssoc.appendRule(this.getRule(i));
        }
        return newAssoc;
    }

    @Override
    public IExpr set(int location, IExpr rule) {
        if (location > 0) {
            if (rule.isRuleAST()) {
                IAST oldRule = this.getRule(location);
                if (oldRule.isPresent()) {
                    this.keyToIndexMap.without((Object)oldRule.first());
                }
                this.keyToIndexMap.assoc((Object)rule.first(), (Object)location);
                this.rrbTree = this.rrbTree.replace(location, (Object)rule);
                return oldRule;
            }
            ArgumentTypeException.throwArg(rule, S.Association);
            return F.NIL;
        }
        return super.set(location, rule);
    }

    @Override
    public IExpr setValue(int location, IExpr value) {
        if (location > 0) {
            IAST oldRule = this.getRule(location);
            MutMap mutable = this.keyToIndexMap.toMutMap(x -> x);
            this.keyToIndexMap = mutable = mutable.assoc((Object)oldRule.first(), (Object)location);
            return super.set(location, oldRule.setAtCopy(2, value));
        }
        return super.set(0, value);
    }

    @Override
    public IAssociation sort() {
        return this.sort(null);
    }

    @Override
    public IAssociation sort(final Comparator<IExpr> comp) {
        IntArrayList indices = new IntArrayList(this.argSize());
        for (int i = 1; i < this.size(); ++i) {
            indices.add(i);
        }
        Comparator<Integer> comparator = comp == null ? new Comparator<Integer>(){

            @Override
            public int compare(Integer i, Integer j) {
                return ASTAssociation.this.getValue(i).compareTo(ASTAssociation.this.getValue(j));
            }
        } : new Comparator<Integer>(){

            @Override
            public int compare(Integer i, Integer j) {
                return comp.compare(ASTAssociation.this.getValue(i), ASTAssociation.this.getValue(j));
            }
        };
        Collections.sort(indices, comparator);
        ASTAssociation result = this.copy();
        MutMap mutable = this.keyToIndexMap.toMutMap(x -> x);
        for (UnmodMap.UnEntry element : this.keyToIndexMap) {
            int indx = (Integer)element.getValue();
            for (int i = 0; i < indices.size(); ++i) {
                if (indices.getInt(i) != indx) continue;
                indx = i + 1;
                break;
            }
            int newValue = indices.getInt(indx - 1);
            result.set(indx, this.getRule(newValue));
            mutable = mutable.assoc((Object)((IExpr)element.getKey()), (Object)indx);
        }
        result.keyToIndexMap = mutable;
        return result;
    }

    @Override
    public IASTMutable values() {
        return this.values(S.List);
    }

    protected IASTMutable values(IBuiltInSymbol symbol) {
        IASTAppendable list = this.copyAST();
        list.set(0, symbol);
        return list;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        IASTMutable ast = this.normal(false);
        objectOutput.writeObject(ast);
    }
}

