/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.StringTokenizer;
import org.hipparchus.complex.Complex;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.exception.ASTElementLimitExceeded;
import org.matheclipse.core.expression.AST0;
import org.matheclipse.core.expression.AST1;
import org.matheclipse.core.expression.AST2;
import org.matheclipse.core.expression.AST3;
import org.matheclipse.core.expression.ASTRRBTree;
import org.matheclipse.core.expression.AbstractIntegerSym;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.HMArrayList;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.StringX;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class AST
extends HMArrayList
implements Externalizable {
    private static final long serialVersionUID = 4295200630292148027L;

    public static AST newInstance(IExpr head) {
        AST ast = new AST(5, false);
        ast.append(head);
        return ast;
    }

    protected static AST newInstance(int intialCapacity, IAST ast, int endPosition) {
        if (Config.MAX_AST_SIZE < intialCapacity) {
            ASTElementLimitExceeded.throwIt(intialCapacity);
        }
        AST result = new AST(intialCapacity, false);
        result.appendAll(ast, 0, endPosition);
        return result;
    }

    public static AST newInstance(int initialCapacity, IExpr head, boolean initNull) {
        if (Config.MAX_AST_SIZE < initialCapacity || initialCapacity < 0) {
            ASTElementLimitExceeded.throwIt(initialCapacity);
        }
        AST ast = new AST(initialCapacity, initNull);
        if (initNull) {
            ast.set(0, head);
        } else {
            ast.append(head);
        }
        return ast;
    }

    public static AST newInstance(int initialCapacity, IExpr head) {
        if (Config.MAX_AST_SIZE < initialCapacity || initialCapacity < 0) {
            ASTElementLimitExceeded.throwIt(initialCapacity);
        }
        AST ast = new AST(initialCapacity);
        ast.append(head);
        return ast;
    }

    public static AST newInstance(ISymbol symbol, boolean evalComplex, Complex ... arr) {
        if (Config.MAX_AST_SIZE < arr.length) {
            ASTElementLimitExceeded.throwIt(arr.length);
        }
        IExpr[] eArr = new IExpr[arr.length + 1];
        eArr[0] = symbol;
        if (evalComplex) {
            for (int i = 1; i <= arr.length; ++i) {
                double im = arr[i - 1].getImaginary();
                eArr[i] = F.isZero(im) ? Num.valueOf(arr[i - 1].getReal()) : ComplexNum.valueOf(arr[i - 1]);
            }
        } else {
            for (int i = 1; i <= arr.length; ++i) {
                eArr[i] = ComplexNum.valueOf(arr[i - 1]);
            }
        }
        return new AST(eArr);
    }

    public static AST newInstance(ISymbol symbol, double ... arr) {
        if (Config.MAX_AST_SIZE < arr.length) {
            ASTElementLimitExceeded.throwIt(arr.length);
        }
        IExpr[] eArr = new IExpr[arr.length + 1];
        eArr[0] = symbol;
        for (int i = 1; i <= arr.length; ++i) {
            eArr[i] = Num.valueOf(arr[i - 1]);
        }
        return new AST(eArr);
    }

    public static AST newInstance(ISymbol symbol, double[][] matrix) {
        if (Config.MAX_AST_SIZE < matrix.length) {
            ASTElementLimitExceeded.throwIt(matrix.length);
        }
        IExpr[] eArr = new IExpr[matrix.length + 1];
        eArr[0] = symbol;
        for (int i = 1; i <= matrix.length; ++i) {
            eArr[i] = AST.newInstance((ISymbol)S.List, matrix[i - 1]);
        }
        return new AST(eArr);
    }

    public static AST newInstance(ISymbol symbol, int ... arr) {
        if (Config.MAX_AST_SIZE < arr.length) {
            ASTElementLimitExceeded.throwIt(arr.length);
        }
        IExpr[] eArr = new IExpr[arr.length + 1];
        eArr[0] = symbol;
        for (int i = 1; i <= arr.length; ++i) {
            eArr[i] = AbstractIntegerSym.valueOf(arr[i - 1]);
        }
        return new AST(eArr);
    }

    public static IAST parse(String inputString) {
        StringTokenizer tokenizer = new StringTokenizer(inputString, "[],", true);
        String token = tokenizer.nextToken();
        AST list = AST.newInstance(StringX.valueOf(token));
        token = tokenizer.nextToken();
        if ("[".equals(token)) {
            AST.parseList(tokenizer, list);
            return list;
        }
        return null;
    }

    private static void parseList(StringTokenizer tokenizer, IASTAppendable list) {
        String token = tokenizer.nextToken();
        do {
            if ("]".equals(token)) {
                return;
            }
            if (!" ".equals(token)) {
                String arg = ",".equals(token) ? tokenizer.nextToken() : token;
                token = tokenizer.nextToken();
                if ("[".equals(token)) {
                    AST argList = AST.newInstance(StringX.valueOf(arg));
                    AST.parseList(tokenizer, argList);
                    list.append(argList);
                } else {
                    list.append(StringX.valueOf(arg));
                    continue;
                }
            }
            token = tokenizer.nextToken();
        } while (tokenizer.hasMoreTokens());
    }

    public AST() {
        super(0);
    }

    AST(IExpr head, IExpr ... exprs) {
        super(head, exprs);
    }

    AST(IExpr[] exprs) {
        super(exprs);
    }

    protected AST(int initialCapacity, boolean setLength) {
        super(initialCapacity + 1);
        this.lastIndex += setLength ? initialCapacity + 1 : 0;
    }

    protected AST(int initialCapacity) {
        super(initialCapacity + 1);
    }

    @Override
    public IAST appendOneIdentity(IAST value) {
        if (value.isAST1()) {
            this.append(value.arg1());
        } else {
            this.append(value);
        }
        return this;
    }

    @Override
    public IASTAppendable copyAppendable() {
        if (this.size() > 32) {
            return new ASTRRBTree(this);
        }
        AST ast = new AST();
        ast.array = (IExpr[])this.array.clone();
        ast.hashValue = 0;
        ast.firstIndex = this.firstIndex;
        ast.lastIndex = this.lastIndex;
        return ast;
    }

    @Override
    public IASTAppendable copyAppendable(int additionalCapacity) {
        int size = this.size();
        if (size > 32 || additionalCapacity > 32) {
            return new ASTRRBTree(this);
        }
        AST ast = new AST();
        if (size + additionalCapacity > this.array.length) {
            ast.array = new IExpr[this.size() + additionalCapacity];
            System.arraycopy(this.array, 0, ast.array, 0, this.array.length);
        } else {
            ast.array = (IExpr[])this.array.clone();
        }
        ast.hashValue = 0;
        ast.firstIndex = this.firstIndex;
        ast.lastIndex = this.lastIndex;
        return ast;
    }

    @Override
    public IAST getItems(int[] items, int length) {
        AST result = new AST(length, true);
        result.set(0, this.head());
        for (int i = 0; i < length; ++i) {
            result.set(i + 1, this.get(items[i]));
        }
        return result;
    }

    @Override
    public IASTMutable copy() {
        switch (this.size()) {
            case 1: {
                return new AST0(this.head());
            }
            case 2: {
                return new AST1(this.head(), this.arg1());
            }
            case 3: {
                return new AST2(this.head(), this.arg1(), this.arg2());
            }
            case 4: {
                return new AST3(this.head(), this.arg1(), this.arg2(), this.arg3());
            }
        }
        AST ast = new AST();
        ast.array = (IExpr[])this.array.clone();
        ast.hashValue = 0;
        ast.firstIndex = this.firstIndex;
        ast.lastIndex = this.lastIndex;
        return ast;
    }

    @Override
    public IAST rest() {
        switch (this.size()) {
            case 1: {
                return this;
            }
            case 2: {
                return F.headAST0(this.head());
            }
            case 3: {
                return F.unaryAST1(this.head(), this.arg2());
            }
        }
        if (this.isOrderlessAST()) {
            return super.rest();
        }
        return super.rest();
    }

    @Override
    public IAST removeFromEnd(int fromPosition) {
        if (0 < fromPosition && fromPosition <= this.size()) {
            if (fromPosition == this.size()) {
                return this;
            }
            AST ast = new AST(this.array);
            ast.firstIndex = this.firstIndex;
            ast.lastIndex = this.firstIndex + fromPosition;
            return ast;
        }
        throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(fromPosition) + ", Size: " + Integer.valueOf(this.lastIndex - this.firstIndex));
    }

    @Override
    public IAST removeFromStart(int firstPosition) {
        if (firstPosition == 1) {
            return this;
        }
        if (0 < firstPosition && firstPosition <= this.size()) {
            int last = this.size();
            int size = last - firstPosition + 1;
            switch (size) {
                case 1: {
                    return F.headAST0(this.head());
                }
                case 2: {
                    return F.unaryAST1(this.head(), this.get(last - 1));
                }
                case 3: {
                    return F.binaryAST2(this.head(), this.get(last - 2), this.get(last - 1));
                }
                case 4: {
                    return F.ternaryAST3(this.head(), this.get(last - 3), this.get(last - 2), this.get(last - 1));
                }
            }
            if (this.isOrderlessAST()) {
                return this.copyFrom(firstPosition);
            }
            return this.copyFrom(firstPosition);
        }
        throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(firstPosition) + ", Size: " + this.size());
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.fEvalFlags = objectInput.readShort();
        byte attributeFlags = objectInput.readByte();
        if (attributeFlags != 0) {
            int i;
            byte size = attributeFlags;
            IExpr[] array = new IExpr[size];
            this.init(array);
            int exprIDSize = objectInput.readByte();
            for (i = 0; i < exprIDSize; ++i) {
                this.array[i] = S.exprID(objectInput.readShort());
            }
            for (i = exprIDSize; i < size; ++i) {
                this.array[i] = (IExpr)objectInput.readObject();
            }
            return;
        }
        int size = objectInput.readInt();
        IExpr[] array = new IExpr[size];
        this.init(array);
        for (int i = 0; i < size; ++i) {
            this.array[i] = (IExpr)objectInput.readObject();
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Short exprID;
        objectOutput.writeShort(this.fEvalFlags);
        int size = this.size();
        int attributeFlags = 0;
        if (size > 0 && size < 128 && (exprID = S.GLOBAL_IDS_MAP.get(this.head())) != null) {
            int i;
            int exprIDSize = 1;
            short[] exprIDArray = new short[size];
            exprIDArray[0] = exprID;
            for (i = 1; i < size && (exprID = S.GLOBAL_IDS_MAP.get(this.get(i))) != null; ++i) {
                exprIDArray[i] = exprID;
                ++exprIDSize;
            }
            attributeFlags = (byte)size;
            objectOutput.writeByte(attributeFlags);
            objectOutput.writeByte((byte)exprIDSize);
            for (i = 0; i < exprIDSize; ++i) {
                objectOutput.writeShort(exprIDArray[i]);
            }
            for (i = exprIDSize; i < size; ++i) {
                objectOutput.writeObject(this.get(i));
            }
            return;
        }
        objectOutput.writeByte(attributeFlags);
        objectOutput.writeInt(size);
        for (int i = 0; i < size; ++i) {
            objectOutput.writeObject(this.get(i));
        }
    }

    private Object writeReplace() {
        return this.optional();
    }
}

