/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import org.matheclipse.core.builtin.NumberTheory;
import org.matheclipse.core.eval.EvalAttributes;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;

public class SolveUtils {
    public static IASTMutable[] filterSolveLists(IAST list, IASTMutable solution, boolean[] isNumeric) {
        boolean numeric = isNumeric[0];
        IASTMutable[] result = new IASTMutable[3];
        IASTAppendable termsEqualZero = F.ListAlloc(list.size());
        IASTAppendable inequalityTerms = F.ListAlloc(list.size());
        result[0] = termsEqualZero;
        result[1] = inequalityTerms;
        result[2] = F.NIL;
        for (int i = 1; i < list.size(); ++i) {
            IExpr arg = list.get(i);
            if (arg.isTrue()) continue;
            if (arg.isFalse()) {
                result[2] = F.ListAlloc();
                return result;
            }
            if (arg.isEqual()) {
                IExpr arg1 = arg.first();
                if (numeric) {
                    termsEqualZero.append(arg1);
                    continue;
                }
                IExpr temp = NumberTheory.rationalize(arg1, false);
                if (temp.isPresent()) {
                    isNumeric[0] = true;
                    termsEqualZero.append(temp);
                    continue;
                }
                termsEqualZero.append(arg1);
                continue;
            }
            inequalityTerms.append(arg);
        }
        EvalAttributes.sort(result[0]);
        EvalAttributes.sort(result[1]);
        if (result[0].isEmpty() && result[1].isEmpty()) {
            result[2] = solution.isPresent() ? solution : F.unary(S.List, F.List());
            return result;
        }
        return result;
    }
}

