/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.util.SetSpec;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;

public class SetSpecification
extends SetSpec {
    public SetSpecification() {
        this.fMinCount = 0;
        this.fMaxCount = Integer.MAX_VALUE;
    }

    public SetSpecification(IExpr expr) {
        super(0);
        this.fMaxCount = -1;
        this.fMinCount = -1;
        if (expr instanceof IInteger) {
            IInteger value = (IInteger)expr;
            if (value.isNegative()) {
                this.fMinCount = 1;
                this.fMaxCount = Integer.MAX_VALUE;
            } else {
                this.fMaxCount = value.toBigNumerator().intValue();
                this.fMinCount = 1;
            }
            return;
        }
        if (expr.isList()) {
            IAST lst = (IAST)expr;
            if (lst.isAST1()) {
                if (lst.arg1() instanceof IInteger) {
                    IInteger i = (IInteger)lst.arg1();
                    if (i.isNegative()) {
                        this.fMinCount = 0;
                        this.fMaxCount = Integer.MAX_VALUE;
                    } else {
                        this.fMaxCount = i.toBigNumerator().intValue();
                        this.fMinCount = i.toBigNumerator().intValue();
                        if (this.fMaxCount < this.fMinCount) {
                            String str = IOFunctions.getMessage("level", F.list(expr), EvalEngine.get());
                            throw new ArgumentTypeException(str);
                        }
                    }
                    return;
                }
            } else if (lst.isAST2()) {
                if (lst.arg1() instanceof IInteger && lst.arg2() instanceof IInteger) {
                    IInteger i0 = (IInteger)lst.arg1();
                    IInteger i1 = (IInteger)lst.arg2();
                    if (i0.isNegative() && i1.isNegative()) {
                        this.fMinCount = 0;
                        this.fMaxCount = Integer.MAX_VALUE;
                    } else {
                        if (i0.isNegative()) {
                            String str = IOFunctions.getMessage("level", F.list(expr), EvalEngine.get());
                            throw new ArgumentTypeException(str);
                        }
                        if (i1.isNegative()) {
                            this.fMinCount = i0.toBigNumerator().intValue();
                            this.fMaxCount = Integer.MAX_VALUE;
                        } else {
                            this.fMinCount = i0.toBigNumerator().intValue();
                            this.fMaxCount = i1.toBigNumerator().intValue();
                        }
                    }
                    return;
                }
                if (lst.arg1() instanceof IInteger && lst.arg2().isInfinity()) {
                    IInteger i0 = (IInteger)lst.arg1();
                    if (i0.isNegative()) {
                        String str = IOFunctions.getMessage("level", F.list(expr), EvalEngine.get());
                        throw new ArgumentTypeException(str);
                    }
                    this.fMinCount = i0.toBigNumerator().intValue();
                    this.fMaxCount = Integer.MAX_VALUE;
                    return;
                }
            }
        }
        if (expr.isInfinity()) {
            this.fMaxCount = Integer.MAX_VALUE;
            this.fMinCount = 1;
            return;
        }
        String str = IOFunctions.getMessage("level", F.list(expr), EvalEngine.get());
        throw new ArgumentTypeException(str);
    }

    public SetSpecification(int level) {
        this(level, level);
    }

    public SetSpecification(int levelFrom, int levelTo) {
        this.fMinCount = levelFrom;
        this.fMaxCount = levelTo;
    }
}

