/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class OptionArgs {
    public static final OptionArgs DUMMY_OPTIONS_ARGS = new OptionArgs();
    private IAST fDefaultOptionsList = F.NIL;
    private IASTAppendable fCurrentOptionsList = F.NIL;
    private EvalEngine fEngine = null;
    private int fLastPosition = -1;
    private int fInvalidPosition = -1;

    public static OptionArgs createOptionArgs(IAST ast, EvalEngine engine) {
        OptionArgs options = new OptionArgs(ast.topHead(), ast, ast.size() - 1, engine, false);
        return options.fInvalidPosition == ast.size() - 1 ? null : options;
    }

    private OptionArgs() {
    }

    public OptionArgs(ISymbol symbol, IAST currentOptionsList, int startIndex, EvalEngine engine) {
        this(symbol, currentOptionsList, startIndex, engine, false);
    }

    public OptionArgs(ISymbol symbol, IAST currentOptionsList, int startIndex, EvalEngine engine, boolean evaluate) {
        this.fEngine = engine;
        this.evalDefaultOptions(symbol);
        this.fCurrentOptionsList = F.NIL;
        if (currentOptionsList.isPresent() && startIndex < currentOptionsList.size()) {
            int j;
            IAST listOfRules;
            IExpr arg;
            int i;
            int size = currentOptionsList.size();
            int allocSize = 1;
            for (i = startIndex; i < size; ++i) {
                arg = currentOptionsList.get(i);
                if (arg.isRule()) {
                    if (this.checkOptionRule(i, (IAST)arg)) {
                        ++allocSize;
                        continue;
                    }
                    return;
                }
                if (arg.isListOfRules(false)) {
                    listOfRules = (IAST)arg;
                    for (j = 1; j < listOfRules.size(); ++j) {
                        IAST rule = (IAST)listOfRules.get(j);
                        if (this.checkOptionRule(i, rule)) {
                            ++allocSize;
                            continue;
                        }
                        return;
                    }
                    continue;
                }
                this.fInvalidPosition = i;
                if (!this.fDefaultOptionsList.isPresent()) continue;
                return;
            }
            this.fCurrentOptionsList = F.ListAlloc(F.allocMin16(allocSize));
            for (i = startIndex; i < size; ++i) {
                arg = currentOptionsList.get(i);
                IExpr iExpr = arg = evaluate ? engine.evaluate(arg) : arg;
                if (arg.isRule()) {
                    this.fCurrentOptionsList.append(arg);
                    continue;
                }
                if (!arg.isListOfRules(false)) continue;
                listOfRules = (IAST)arg;
                for (j = 1; j < listOfRules.size(); ++j) {
                    this.fCurrentOptionsList.append(listOfRules.get(j));
                }
            }
        }
    }

    private boolean checkOptionRule(int i, IAST rule) {
        if (this.fDefaultOptionsList.isPresent()) {
            if (this.fDefaultOptionsList.exists(x -> x.first().equals(rule.first()))) {
                return true;
            }
            this.fInvalidPosition = i;
            return false;
        }
        return true;
    }

    private boolean appendOptionRule(int i, IAST rule) {
        if (this.fDefaultOptionsList.isPresent()) {
            if (this.fDefaultOptionsList.exists(x -> x.first().equals(rule.first()))) {
                this.fCurrentOptionsList.append(rule);
                return true;
            }
            this.fInvalidPosition = i;
            return false;
        }
        this.fCurrentOptionsList.append(rule);
        return true;
    }

    public OptionArgs(ISymbol symbol, IAST currentOptionsList, int startIndex, int endIndex, EvalEngine engine) {
        this.fEngine = engine;
        this.evalDefaultOptions(symbol);
        this.fCurrentOptionsList = F.NIL;
        if (currentOptionsList.isPresent() && startIndex < currentOptionsList.size()) {
            IExpr opt;
            int size = currentOptionsList.size();
            this.fCurrentOptionsList = F.ListAlloc(size);
            int i = endIndex - 1;
            while (i >= startIndex && (opt = currentOptionsList.get(i)).isRule()) {
                this.fLastPosition = i--;
                this.fCurrentOptionsList.append(1, opt);
            }
        }
    }

    public OptionArgs(ISymbol symbol, IExpr optionExpr, EvalEngine engine) {
        this.fEngine = engine;
        this.evalDefaultOptions(symbol);
        this.fCurrentOptionsList = F.ListAlloc();
        this.fCurrentOptionsList.append(optionExpr);
    }

    private void evalDefaultOptions(ISymbol symbol) {
        IExpr temp = this.fEngine.evaluate(F.Options(symbol));
        this.fDefaultOptionsList = temp.isList() && temp.size() > 1 ? (IAST)temp : F.NIL;
    }

    public int getInvalidPosition() {
        return this.fInvalidPosition;
    }

    public int getLastPosition() {
        return this.fLastPosition;
    }

    public IExpr getOption(ISymbol option) {
        IAST[] rule = new IAST[1];
        if (this.fCurrentOptionsList.isPresent()) {
            try {
                if (this.fCurrentOptionsList.exists(x -> {
                    IAST temp;
                    if (x.isAST() && (temp = (IAST)x).isRuleAST() && temp.arg1().equals(option)) {
                        rule[0] = temp;
                        return true;
                    }
                    return false;
                })) {
                    return rule[0].arg2();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.fDefaultOptionsList.isPresent()) {
            try {
                if (this.fDefaultOptionsList.exists(x -> {
                    IAST temp;
                    if (x.isAST() && (temp = (IAST)x).isRuleAST() && temp.arg1().equals(option)) {
                        rule[0] = temp;
                        return true;
                    }
                    return false;
                }, 1)) {
                    return rule[0].arg2();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return F.NIL;
    }

    public IExpr getOptionAutomatic(ISymbol option) {
        IExpr temp = this.getOption(option);
        if (temp == S.Automatic) {
            return F.NIL;
        }
        return temp;
    }

    public int getOptionMaxIterations(ISymbol option) {
        IExpr optionMaxIterations = this.getOption(S.MaxIterations);
        if (optionMaxIterations.isPresent()) {
            if (optionMaxIterations.isInfinity()) {
                return -1;
            }
            int maxIterations = optionMaxIterations.toIntDefault();
            if (maxIterations <= 0) {
                IOFunctions.printMessage(this.fCurrentOptionsList.topHead(), "iopnf", F.list(F.Rule((IExpr)S.MaxIterations, optionMaxIterations)), this.fEngine);
                return Integer.MIN_VALUE;
            }
            return maxIterations;
        }
        return -1;
    }

    public boolean isFalse(ISymbol option) {
        return this.getOption(option).isFalse();
    }

    public boolean isInvalidPosition() {
        return this.fInvalidPosition > -1;
    }

    public boolean isInvalidPosition(IAST ast, int greaterThanPositon) {
        int invalidPosition = this.getInvalidPosition();
        if (invalidPosition > greaterThanPositon) {
            IOFunctions.printMessage(ast.topHead(), "nonopt", F.list(ast.get(invalidPosition), F.ZZ(greaterThanPositon), ast), EvalEngine.get());
            return true;
        }
        return false;
    }

    public boolean isInvalidPosition(int greaterThanPositon) {
        return this.fInvalidPosition > greaterThanPositon;
    }

    public boolean isTrue(ISymbol option) {
        return this.getOption(option).isTrue();
    }

    public IAST printNonopt(IAST ast, int optionPosition, EvalEngine engine) {
        return IOFunctions.printMessage(ast.topHead(), "nonopt", F.list(ast.get(this.fInvalidPosition), F.ZZ(optionPosition), ast), engine);
    }

    public IAST replaceAll(IAST options) {
        if (this.fCurrentOptionsList.isPresent()) {
            return (IAST)this.fEngine.evaluate(F.ReplaceAll(options, this.fCurrentOptionsList));
        }
        if (this.fDefaultOptionsList.isPresent()) {
            return (IAST)this.fEngine.evaluate(F.ReplaceAll(options, this.fDefaultOptionsList));
        }
        return options;
    }

    public static IExpr determineAssumptions(IAST ast, int position, OptionArgs options) {
        IExpr assumptionExpr = F.NIL;
        if (options != null) {
            if (options.fInvalidPosition > 0 && options.fInvalidPosition <= position && ast.size() > position) {
                assumptionExpr = ast.get(position);
            } else {
                IExpr option = options.getOption(S.Assumptions);
                if (option.isPresent()) {
                    if (option.equals(S.$Assumptions)) {
                        assumptionExpr = S.$Assumptions.assignedValue();
                        if (assumptionExpr == null) {
                            assumptionExpr = F.NIL;
                        }
                    } else {
                        assumptionExpr = option;
                        if (option.isTrue() && position > 0 && ast.size() > position) {
                            assumptionExpr = ast.get(position);
                        }
                    }
                } else if (position > 0 && ast.size() > position) {
                    assumptionExpr = ast.get(position);
                }
            }
        } else {
            assumptionExpr = S.$Assumptions.assignedValue();
            if (assumptionExpr == null) {
                assumptionExpr = F.NIL;
            }
        }
        return assumptionExpr;
    }
}

