/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;

public class OpenIntToSet<T>
implements Serializable {
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;
    private static final long serialVersionUID = 5483913974727729407L;
    private static final float LOAD_FACTOR = 0.5f;
    private static final int DEFAULT_EXPECTED_SIZE = 16;
    private static final int RESIZE_MULTIPLIER = 2;
    private static final int PERTURB_SHIFT = 5;
    private Comparator<T> comparator;
    private int[] keys;
    private Set<T>[] values;
    private byte[] states;
    private int size;
    private int mask;
    private transient int count;

    private static int changeIndexSign(int index) {
        return -index - 1;
    }

    private static int computeCapacity(int expectedSize) {
        if (expectedSize == 0) {
            return 1;
        }
        int capacity = (int)Math.ceil((float)expectedSize / 0.5f);
        int powerOfTwo = Integer.highestOneBit(capacity);
        if (powerOfTwo == capacity) {
            return capacity;
        }
        return OpenIntToSet.nextPowerOfTwo(capacity);
    }

    private static int findInsertionIndex(int[] keys, byte[] states, int key, int mask) {
        int hash = OpenIntToSet.hashOf(key);
        int index = hash & mask;
        if (states[index] == 0) {
            return index;
        }
        if (states[index] == 1 && keys[index] == key) {
            return OpenIntToSet.changeIndexSign(index);
        }
        int perturb = OpenIntToSet.perturb(hash);
        int j = index;
        if (states[index] == 1) {
            do {
                j = OpenIntToSet.probe(perturb, j);
                index = j & mask;
                perturb >>= 5;
            } while (states[index] == 1 && keys[index] != key);
        }
        if (states[index] == 0) {
            return index;
        }
        if (states[index] == 1) {
            return OpenIntToSet.changeIndexSign(index);
        }
        int firstRemoved = index;
        while (states[index = (j = OpenIntToSet.probe(perturb, j)) & mask] != 0) {
            if (states[index] == 1 && keys[index] == key) {
                return OpenIntToSet.changeIndexSign(index);
            }
            perturb >>= 5;
        }
        return firstRemoved;
    }

    private static int hashOf(int key) {
        int h = key ^ (key >>> 20 ^ key >>> 12);
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private static int nextPowerOfTwo(int i) {
        return Integer.highestOneBit(i) << 1;
    }

    private static int perturb(int hash) {
        return hash & Integer.MAX_VALUE;
    }

    private static int probe(int perturb, int j) {
        return (j << 2) + j + perturb + 1;
    }

    public OpenIntToSet(Comparator<T> comparator) {
        this(comparator, 16);
    }

    public OpenIntToSet(Comparator<T> comparator, int expectedSize) {
        int capacity = OpenIntToSet.computeCapacity(expectedSize);
        this.comparator = comparator;
        this.keys = new int[capacity];
        this.values = new TreeSet[capacity];
        this.states = new byte[capacity];
        this.mask = capacity - 1;
    }

    public OpenIntToSet(OpenIntToSet<T> source) {
        int length = source.keys.length;
        this.keys = new int[length];
        System.arraycopy(source.keys, 0, this.keys, 0, length);
        this.values = new TreeSet[length];
        System.arraycopy(source.values, 0, this.values, 0, length);
        this.states = new byte[length];
        System.arraycopy(source.states, 0, this.states, 0, length);
        this.size = source.size;
        this.mask = source.mask;
        this.count = source.count;
    }

    public boolean containsEntry(int key, T value) {
        Set<T> set = this.get(key);
        return set != null && set.contains(value);
    }

    public boolean containsKey(int key) {
        int hash = OpenIntToSet.hashOf(key);
        int index = hash & this.mask;
        if (this.containsKey(key, index)) {
            return true;
        }
        if (this.states[index] == 0) {
            return false;
        }
        int j = index;
        int perturb = OpenIntToSet.perturb(hash);
        while (this.states[index] != 0) {
            index = (j = OpenIntToSet.probe(perturb, j)) & this.mask;
            if (this.containsKey(key, index)) {
                return true;
            }
            perturb >>= 5;
        }
        return false;
    }

    private boolean containsKey(int key, int index) {
        return (key != 0 || this.states[index] == 1) && this.keys[index] == key;
    }

    private Set<T> doRemove(int index) {
        this.keys[index] = 0;
        this.states[index] = 2;
        Set<T> previous = this.values[index];
        this.values[index] = null;
        --this.size;
        ++this.count;
        return previous;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpenIntToSet other = (OpenIntToSet)obj;
        if (!Arrays.equals(this.keys, other.keys)) {
            return false;
        }
        if (this.mask != other.mask) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (!Arrays.equals(this.states, other.states)) {
            return false;
        }
        return Arrays.equals(this.values, other.values);
    }

    private int findInsertionIndex(int key) {
        return OpenIntToSet.findInsertionIndex(this.keys, this.states, key, this.mask);
    }

    public Set<T> get(int key) {
        int hash = OpenIntToSet.hashOf(key);
        int index = hash & this.mask;
        if (this.containsKey(key, index)) {
            return this.values[index];
        }
        if (this.states[index] == 0) {
            return null;
        }
        int j = index;
        int perturb = OpenIntToSet.perturb(hash);
        while (this.states[index] != 0) {
            index = (j = OpenIntToSet.probe(perturb, j)) & this.mask;
            if (this.containsKey(key, index)) {
                return this.values[index];
            }
            perturb >>= 5;
        }
        return null;
    }

    public Set<T>[] getValues() {
        return this.values;
    }

    private void growTable() {
        int oldLength = this.states.length;
        int[] oldKeys = this.keys;
        Set<T>[] oldValues = this.values;
        byte[] oldStates = this.states;
        int newLength = 2 * oldLength;
        int[] newKeys = new int[newLength];
        TreeSet[] newValues = new TreeSet[newLength];
        byte[] newStates = new byte[newLength];
        int newMask = newLength - 1;
        for (int i = 0; i < oldLength; ++i) {
            if (oldStates[i] != 1) continue;
            int key = oldKeys[i];
            int index = OpenIntToSet.findInsertionIndex(newKeys, newStates, key, newMask);
            newKeys[index] = key;
            newValues[index] = oldValues[i];
            newStates[index] = 1;
        }
        this.mask = newMask;
        this.keys = newKeys;
        this.values = newValues;
        this.states = newStates;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.keys);
        result = 31 * result + this.mask;
        result = 31 * result + this.size;
        result = 31 * result + Arrays.hashCode(this.states);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public void put(int key, T value) {
        int index = this.findInsertionIndex(key);
        boolean newMapping = true;
        if (index < 0) {
            index = OpenIntToSet.changeIndexSign(index);
            newMapping = false;
        }
        this.keys[index] = key;
        this.states[index] = 1;
        if (this.values[index] == null) {
            this.values[index] = new TreeSet<T>(this.comparator);
        }
        this.values[index].add(value);
        if (newMapping) {
            ++this.size;
            if (this.shouldGrowTable()) {
                this.growTable();
            }
            ++this.count;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.count = 0;
    }

    public Set<T> remove(int key) {
        int hash = OpenIntToSet.hashOf(key);
        int index = hash & this.mask;
        if (this.containsKey(key, index)) {
            return this.doRemove(index);
        }
        if (this.states[index] == 0) {
            return null;
        }
        int j = index;
        int perturb = OpenIntToSet.perturb(hash);
        while (this.states[index] != 0) {
            index = (j = OpenIntToSet.probe(perturb, j)) & this.mask;
            if (this.containsKey(key, index)) {
                return this.doRemove(index);
            }
            perturb >>= 5;
        }
        return null;
    }

    public boolean remove(int key, T value) {
        Set<T> set = this.get(key);
        return set != null && set.remove(value);
    }

    private boolean shouldGrowTable() {
        return (float)this.size > (float)(this.mask + 1) * 0.5f;
    }

    public int size() {
        return this.size;
    }

    public class Iterator {
        private final int referenceCount;
        private int current;
        private int next;

        private Iterator() {
            this.referenceCount = OpenIntToSet.this.count;
            this.next = -1;
            try {
                this.advance();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }

        public void advance() throws ConcurrentModificationException, NoSuchElementException {
            block4: {
                if (this.referenceCount != OpenIntToSet.this.count) {
                    throw new ConcurrentModificationException();
                }
                this.current = this.next;
                try {
                    while (OpenIntToSet.this.states[++this.next] != 1) {
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.next = -2;
                    if (this.current >= 0) break block4;
                    throw new NoSuchElementException();
                }
            }
        }

        public boolean hasNext() {
            return this.next >= 0;
        }

        public int key() throws ConcurrentModificationException, NoSuchElementException {
            if (this.referenceCount != OpenIntToSet.this.count) {
                throw new ConcurrentModificationException();
            }
            if (this.current < 0) {
                throw new NoSuchElementException();
            }
            return OpenIntToSet.this.keys[this.current];
        }

        public Set<T> value() throws ConcurrentModificationException, NoSuchElementException {
            if (this.referenceCount != OpenIntToSet.this.count) {
                throw new ConcurrentModificationException();
            }
            if (this.current < 0) {
                throw new NoSuchElementException();
            }
            return OpenIntToSet.this.values[this.current];
        }
    }
}

