/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.NoSuchElementException;

public class OpenIntToList<T>
implements Serializable {
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;
    private static final long serialVersionUID = 5483913974727729407L;
    private static final float LOAD_FACTOR = 0.5f;
    private static final int DEFAULT_EXPECTED_SIZE = 16;
    private static final int RESIZE_MULTIPLIER = 2;
    private static final int PERTURB_SHIFT = 5;
    private int[] keys;
    private List<T>[] values;
    private byte[] states;
    private int size;
    private int mask;
    private transient int count;

    public OpenIntToList() {
        this(16);
    }

    public OpenIntToList(int expectedSize) {
        int capacity = OpenIntToList.computeCapacity(expectedSize);
        this.keys = new int[capacity];
        this.values = new ArrayList[capacity];
        this.states = new byte[capacity];
        this.mask = capacity - 1;
    }

    public OpenIntToList(OpenIntToList<T> source) {
        int length = source.keys.length;
        this.keys = new int[length];
        System.arraycopy(source.keys, 0, this.keys, 0, length);
        this.values = new ArrayList[length];
        System.arraycopy(source.values, 0, this.values, 0, length);
        this.states = new byte[length];
        System.arraycopy(source.states, 0, this.states, 0, length);
        this.size = source.size;
        this.mask = source.mask;
        this.count = source.count;
    }

    private static int computeCapacity(int expectedSize) {
        if (expectedSize == 0) {
            return 1;
        }
        int capacity = (int)Math.ceil((float)expectedSize / 0.5f);
        int powerOfTwo = Integer.highestOneBit(capacity);
        if (powerOfTwo == capacity) {
            return capacity;
        }
        return OpenIntToList.nextPowerOfTwo(capacity);
    }

    private static int nextPowerOfTwo(int i) {
        return Integer.highestOneBit(i) << 1;
    }

    public List<T> get(int key) {
        int hash = OpenIntToList.hashOf(key);
        int index = hash & this.mask;
        if (this.containsKey(key, index)) {
            return this.values[index];
        }
        if (this.states[index] == 0) {
            return null;
        }
        int j = index;
        int perturb = OpenIntToList.perturb(hash);
        while (this.states[index] != 0) {
            index = (j = OpenIntToList.probe(perturb, j)) & this.mask;
            if (this.containsKey(key, index)) {
                return this.values[index];
            }
            perturb >>= 5;
        }
        return null;
    }

    public boolean containsKey(int key) {
        int hash = OpenIntToList.hashOf(key);
        int index = hash & this.mask;
        if (this.containsKey(key, index)) {
            return true;
        }
        if (this.states[index] == 0) {
            return false;
        }
        int j = index;
        int perturb = OpenIntToList.perturb(hash);
        while (this.states[index] != 0) {
            index = (j = OpenIntToList.probe(perturb, j)) & this.mask;
            if (this.containsKey(key, index)) {
                return true;
            }
            perturb >>= 5;
        }
        return false;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    private static int perturb(int hash) {
        return hash & Integer.MAX_VALUE;
    }

    private int findInsertionIndex(int key) {
        return OpenIntToList.findInsertionIndex(this.keys, this.states, key, this.mask);
    }

    private static int findInsertionIndex(int[] keys, byte[] states, int key, int mask) {
        int hash = OpenIntToList.hashOf(key);
        int index = hash & mask;
        if (states[index] == 0) {
            return index;
        }
        if (states[index] == 1 && keys[index] == key) {
            return OpenIntToList.changeIndexSign(index);
        }
        int perturb = OpenIntToList.perturb(hash);
        int j = index;
        if (states[index] == 1) {
            do {
                j = OpenIntToList.probe(perturb, j);
                index = j & mask;
                perturb >>= 5;
            } while (states[index] == 1 && keys[index] != key);
        }
        if (states[index] == 0) {
            return index;
        }
        if (states[index] == 1) {
            return OpenIntToList.changeIndexSign(index);
        }
        int firstRemoved = index;
        while (states[index = (j = OpenIntToList.probe(perturb, j)) & mask] != 0) {
            if (states[index] == 1 && keys[index] == key) {
                return OpenIntToList.changeIndexSign(index);
            }
            perturb >>= 5;
        }
        return firstRemoved;
    }

    private static int probe(int perturb, int j) {
        return (j << 2) + j + perturb + 1;
    }

    private static int changeIndexSign(int index) {
        return -index - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public List<T> remove(int key) {
        int hash = OpenIntToList.hashOf(key);
        int index = hash & this.mask;
        if (this.containsKey(key, index)) {
            return this.doRemove(index);
        }
        if (this.states[index] == 0) {
            return null;
        }
        int j = index;
        int perturb = OpenIntToList.perturb(hash);
        while (this.states[index] != 0) {
            index = (j = OpenIntToList.probe(perturb, j)) & this.mask;
            if (this.containsKey(key, index)) {
                return this.doRemove(index);
            }
            perturb >>= 5;
        }
        return null;
    }

    private boolean containsKey(int key, int index) {
        return (key != 0 || this.states[index] == 1) && this.keys[index] == key;
    }

    private List<T> doRemove(int index) {
        this.keys[index] = 0;
        this.states[index] = 2;
        List<T> previous = this.values[index];
        this.values[index] = null;
        --this.size;
        ++this.count;
        return previous;
    }

    public void put(int key, T value) {
        int index = this.findInsertionIndex(key);
        boolean newMapping = true;
        if (index < 0) {
            index = OpenIntToList.changeIndexSign(index);
            newMapping = false;
        }
        this.keys[index] = key;
        this.states[index] = 1;
        if (this.values[index] == null) {
            this.values[index] = new ArrayList<T>();
        }
        this.values[index].add(value);
        if (newMapping) {
            ++this.size;
            if (this.shouldGrowTable()) {
                this.growTable();
            }
            ++this.count;
        }
    }

    private void growTable() {
        int oldLength = this.states.length;
        int[] oldKeys = this.keys;
        List<T>[] oldValues = this.values;
        byte[] oldStates = this.states;
        int newLength = 2 * oldLength;
        int[] newKeys = new int[newLength];
        ArrayList[] newValues = new ArrayList[newLength];
        byte[] newStates = new byte[newLength];
        int newMask = newLength - 1;
        for (int i = 0; i < oldLength; ++i) {
            if (oldStates[i] != 1) continue;
            int key = oldKeys[i];
            int index = OpenIntToList.findInsertionIndex(newKeys, newStates, key, newMask);
            newKeys[index] = key;
            newValues[index] = oldValues[i];
            newStates[index] = 1;
        }
        this.mask = newMask;
        this.keys = newKeys;
        this.values = newValues;
        this.states = newStates;
    }

    private boolean shouldGrowTable() {
        return (float)this.size > (float)(this.mask + 1) * 0.5f;
    }

    private static int hashOf(int key) {
        int h = key ^ (key >>> 20 ^ key >>> 12);
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.count = 0;
    }

    public class Iterator {
        private final int referenceCount;
        private int current;
        private int next;

        private Iterator() {
            this.referenceCount = OpenIntToList.this.count;
            this.next = -1;
            try {
                this.advance();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }

        public boolean hasNext() {
            return this.next >= 0;
        }

        public int key() throws ConcurrentModificationException, NoSuchElementException {
            if (this.referenceCount != OpenIntToList.this.count) {
                throw new ConcurrentModificationException();
            }
            if (this.current < 0) {
                throw new NoSuchElementException();
            }
            return OpenIntToList.this.keys[this.current];
        }

        public List<T> value() throws ConcurrentModificationException, NoSuchElementException {
            if (this.referenceCount != OpenIntToList.this.count) {
                throw new ConcurrentModificationException();
            }
            if (this.current < 0) {
                throw new NoSuchElementException();
            }
            return OpenIntToList.this.values[this.current];
        }

        public void advance() throws ConcurrentModificationException, NoSuchElementException {
            block4: {
                if (this.referenceCount != OpenIntToList.this.count) {
                    throw new ConcurrentModificationException();
                }
                this.current = this.next;
                try {
                    while (OpenIntToList.this.states[++this.next] != 1) {
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.next = -2;
                    if (this.current >= 0) break block4;
                    throw new NoSuchElementException();
                }
            }
        }
    }
}

