/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;

public class OpenFixedSizeMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7777565424942239816L;
    private Object[] table;
    private int size = 0;

    public OpenFixedSizeMap(int tableSize) {
        this.table = new Object[tableSize << 1];
    }

    @Override
    public OpenFixedSizeMap<K, V> clone() throws CloneNotSupportedException {
        OpenFixedSizeMap result = (OpenFixedSizeMap)super.clone();
        result.table = new Object[this.table.length];
        result.size = this.size;
        for (int i = 0; i < this.table.length; ++i) {
            result.table[i] = this.table[i];
        }
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new IllegalStateException("entrySet not implemented!");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OpenFixedSizeMap) {
            OpenFixedSizeMap other = (OpenFixedSizeMap)obj;
            if (this.size != other.size) {
                return false;
            }
            return Arrays.equals(this.table, other.table);
        }
        return false;
    }

    @Override
    public V get(Object key) {
        int hash;
        int kHash = hash = this.hash(key);
        int index = kHash * 2;
        do {
            if (this.table[index] == null) {
                return null;
            }
            if (this.table[index].equals(key)) {
                return (V)this.table[index + 1];
            }
            kHash = this.hash(kHash + 1);
            index = kHash << 1;
        } while (hash != kHash);
        return null;
    }

    private int hash(int index) {
        return index % (this.table.length >> 1);
    }

    private int hash(Object key) {
        return this.hash(key.hashCode() & Integer.MAX_VALUE);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.size;
        result = 31 * result + Arrays.hashCode(this.table);
        return result;
    }

    private V put(int i, K key, V value) {
        while (true) {
            int index;
            Object entry;
            if ((entry = this.table[index = i << 1]) == null) {
                this.table[index] = key;
                this.table[index + 1] = value;
                ++this.size;
                return value;
            }
            if (entry.equals(key)) {
                Object oldValue = this.table[++index];
                this.table[index] = value;
                return (V)oldValue;
            }
            i = (i + 1) % (this.table.length >> 1);
        }
    }

    @Override
    public V put(K key, V value) {
        if (this.size == this.table.length >> 1) {
            throw new IllegalStateException("Map is full!");
        }
        int hash = this.hash(key);
        return this.put(hash, key, value);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int length = s.readInt();
        this.table = new Object[length];
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.put(this.hash(key), key, value);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.size);
        int j = 0;
        while (j + 1 < this.table.length) {
            if (this.table[j] != null) {
                s.writeObject(this.table[j]);
                s.writeObject(this.table[j + 1]);
            }
            j += 2;
        }
    }
}

