/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import java.util.HashMap;
import java.util.Map;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public final class MutableInt {
    int value;

    public MutableInt(int value) {
        this.value = value;
    }

    public MutableInt increment() {
        ++this.value;
        return this;
    }

    public MutableInt decrement() {
        --this.value;
        return this;
    }

    public int inc() {
        return ++this.value;
    }

    public int dec() {
        return --this.value;
    }

    public int value() {
        return this.value;
    }

    public static Map<IExpr, MutableInt> createHistogram(IAST ast) {
        HashMap<IExpr, MutableInt> histogramMap = new HashMap<IExpr, MutableInt>(ast.size() + ast.size() / 10 + 6);
        for (int i = 1; i < ast.size(); ++i) {
            IExpr key = ast.get(i);
            histogramMap.compute(key, (k, v) -> v == null ? new MutableInt(1) : v.increment());
        }
        return histogramMap;
    }

    public static boolean isEqualPermutable(IAST ast, Map<IExpr, MutableInt> histogram) {
        for (int i = 1; i < ast.size(); ++i) {
            MutableInt value = histogram.get(ast.get(i));
            if (value != null && value.dec() >= 0) continue;
            return false;
        }
        return true;
    }
}

