/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.convert.VariablesSet;
import org.matheclipse.core.eval.MathUtils;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.Symbol;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class MagicProcessor {
    private static final Logger LOGGER = LogManager.getLogger();
    String outPut = null;
    String err = null;

    public String magicSolve(String q, String function) {
        this.outPut = q;
        LOGGER.debug("Input '{}'", (Object)this.outPut);
        boolean isSysOfEq = this.outPut.contains("Solve");
        if (isSysOfEq) {
            String pattern = "([^=])(=)([^=])";
            this.outPut = this.outPut.replaceAll(pattern, "$1==$3");
            LOGGER.debug("Input has Solve so after replacing all = with == we have '{}'", (Object)this.outPut);
        }
        String processedQ = this.preProcessQues();
        String ans = MathUtils.evaluate(processedQ, function);
        if (processedQ.contains("Solve")) {
            ans = ans.replace("->", "=");
        }
        return ans;
    }

    String preProcessQues() {
        String var;
        VariablesSet eVar;
        IExpr fn;
        IExpr equations;
        String vars;
        IExpr ques;
        String processEq;
        if (this.outPut.contains("=") && (processEq = this.inputQuestionIsPossiblyASystemOfEquation(this.outPut)) != null) {
            this.outPut = S.Solve.toString() + "(" + processEq + ")";
        }
        if ((ques = MathUtils.parse(this.outPut, null)) == null) {
            return this.outPut;
        }
        LOGGER.debug("ques = {}", (Object)ques);
        if (this.wrtArgumentMising(ques, S.Solve) && (vars = this.solve_get_arg_if_missing(equations = this.getArg1(ques))) != null && this.err == null) {
            this.outPut = ((Symbol)((Object)S.Solve)).toString() + "(" + equations.toString() + "," + vars + ")";
            LOGGER.debug(" Result after eq processing {}", (Object)this.outPut);
        }
        if (this.wrtArgumentMising(ques, S.D)) {
            fn = this.getArg1(ques);
            eVar = new VariablesSet(fn);
            var = null;
            var = eVar.isSize(1) ? this.getVarString(eVar, false) : this.getVarString(eVar, true);
            this.outPut = ((Symbol)((Object)S.D)).toString() + "(" + fn.toString() + "," + var + ")";
        }
        if (this.wrtArgumentMising(ques, S.Integrate)) {
            fn = this.getArg1(ques);
            eVar = new VariablesSet(fn);
            var = null;
            var = eVar.isSize(1) ? this.getVarString(eVar, false) : this.getVarString(eVar, true);
            this.outPut = ((Symbol)((Object)S.Integrate)).toString() + "(" + fn.toString() + "," + var + ")";
        }
        LOGGER.debug("Processed q = {}", (Object)this.outPut);
        return this.err == null ? this.outPut : this.err;
    }

    private IExpr getArg1(IExpr ques) {
        if (ques.isAST()) {
            return ques.first();
        }
        return null;
    }

    private int getSize(IExpr ques) {
        if (ques.isAST()) {
            return ((IAST)ques).size();
        }
        return 0;
    }

    public String solve_get_arg_if_missing(IExpr equations) {
        VariablesSet eVar = new VariablesSet(equations);
        if (equations.isAST()) {
            int num_equations;
            int n = num_equations = equations.isList() ? this.getSize(equations) - 1 : 1;
            if (equations.isAST() && eVar.isSize(num_equations)) {
                String vars = this.getVarString(eVar, false);
                LOGGER.debug("\t list of var = {}", (Object)vars);
                return vars;
            }
            if (num_equations == 1) {
                String vars = this.getVarString(eVar, true);
                if (vars != null) {
                    return vars;
                }
                this.err = "Please specify variable also i.e Solve( f(x), x)";
            } else {
                this.err = "Please specify variable also i.e Solve( equatons, {x, y, ...} )";
            }
        }
        return null;
    }

    private boolean wrtArgumentMising(IExpr expr, ISymbol fun) {
        ISymbol s = MagicProcessor.isSymbol(expr.head());
        if (s != null && s == fun) {
            IAST ast;
            LOGGER.debug("{} is instanceof {}", (Object)expr, (Object)fun);
            if (expr.isAST() && (ast = (IAST)expr).isAST1()) {
                return true;
            }
        }
        return false;
    }

    public String getVarString(VariablesSet eVar, boolean onlyXorY) {
        if (onlyXorY) {
            if (eVar.contains(S.x)) {
                return S.x.toString();
            }
            if (eVar.contains(S.y)) {
                return S.y.toString();
            }
            return null;
        }
        IASTAppendable varList = eVar.getVarList();
        return varList.isAST1() ? varList.arg1().toString() : varList.toString();
    }

    boolean isEquation(IExpr exp) {
        if (!exp.isAST() || MagicProcessor.isPolynomial((IAST)exp)) {
            // empty if block
        }
        return false;
    }

    public static ISymbol isSymbol(IExpr exp) {
        ISymbol s = null;
        if (exp.isSymbol()) {
            s = (ISymbol)exp;
        }
        return s;
    }

    public static boolean isPolynomial(IAST exp) {
        VariablesSet eVar = new VariablesSet(exp);
        return exp.isPolynomial(eVar.getVarList());
    }

    public String getFixedEquation(String possibleEq) {
        String eq;
        IExpr eqn;
        String[] list = possibleEq.split("=");
        if (list.length == 2 && (eqn = MathUtils.parse(eq = list[1] + "- (" + list[0] + ")", null)).isAST() && MagicProcessor.isPolynomial((IAST)eqn)) {
            return list[0] + " == " + list[1];
        }
        return null;
    }

    String inputQuestionIsPossiblyASystemOfEquation(String s) {
        int numQuals = s.split("=").length - 1;
        int numComma = s.split(",").length - 1;
        if (numQuals > 0 && numComma + 1 != numQuals) {
            return null;
        }
        String[] listEqn = s.split(",");
        Object processedEqn = "";
        for (int i = 0; i < numQuals; ++i) {
            String fixedEq = this.getFixedEquation(listEqn[i]);
            if (fixedEq == null) {
                return null;
            }
            processedEqn = (String)processedEqn + fixedEq;
            if (i == numQuals - 1) continue;
            processedEqn = (String)processedEqn + ",";
        }
        if (numQuals >= 1) {
            processedEqn = "{" + (String)processedEqn + "}";
        }
        return processedEqn;
    }
}

