/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import org.matheclipse.core.eval.util.AbstractSequence;

public abstract class ListSizeSequence
extends AbstractSequence {
    protected final int fHeadOffset;
    protected int fListSize;

    public ListSizeSequence() {
        this(0);
    }

    public ListSizeSequence(int startOffset) {
        this(startOffset, Integer.MIN_VALUE, 1, 0);
    }

    public ListSizeSequence(int startOffset, int endOffset) {
        this(startOffset, endOffset, 1, 0);
    }

    public ListSizeSequence(int startOffset, int endOffset, int step) {
        this(startOffset, endOffset, step, 0);
    }

    public ListSizeSequence(int startOffset, int endOffset, int step, int headOffset) {
        super(startOffset, endOffset, step);
        this.fHeadOffset = headOffset;
        this.fListSize = Integer.MIN_VALUE;
    }

    @Override
    public void setListSize(int size) {
        this.fListSize = size;
    }

    @Override
    public int getStart() {
        if (this.fStartOffset >= 0) {
            return this.fStartOffset;
        }
        return this.fListSize + this.fStartOffset;
    }

    @Override
    public int getEnd() {
        if (this.fEndOffset < 0) {
            return this.fListSize + this.fEndOffset + 1;
        }
        if (this.fEndOffset > this.fListSize) {
            return this.fListSize;
        }
        return this.fEndOffset + 1;
    }
}

