/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.util.LevelSpec;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;

public class LevelSpecification
extends LevelSpec {
    public LevelSpecification() {
        this.fFromLevel = 0;
        this.fToLevel = Integer.MAX_VALUE;
        this.fFromDepth = Integer.MIN_VALUE;
        this.fToDepth = -1;
    }

    public LevelSpecification(IExpr expr, boolean includeHeads) {
        super(0, includeHeads);
        this.fToLevel = -1;
        this.fFromLevel = -1;
        this.fToDepth = 0;
        this.fFromDepth = 0;
        if (expr instanceof IInteger) {
            IInteger value = (IInteger)expr;
            if (value.isNegative()) {
                this.fFromDepth = Integer.MIN_VALUE;
                this.fToDepth = value.toBigNumerator().intValue();
                this.fFromLevel = 1;
                this.fToLevel = Integer.MAX_VALUE;
            } else {
                this.fToLevel = value.toBigNumerator().intValue();
                this.fFromLevel = 1;
                this.fFromDepth = Integer.MIN_VALUE;
                this.fToDepth = -1;
            }
            return;
        }
        if (expr.isList()) {
            IAST lst = (IAST)expr;
            if (lst.isAST1()) {
                if (lst.arg1() instanceof IInteger) {
                    IInteger i = (IInteger)lst.arg1();
                    if (i.isNegative()) {
                        this.fFromDepth = i.toBigNumerator().intValue();
                        this.fToDepth = i.toBigNumerator().intValue();
                        this.fFromLevel = 0;
                        this.fToLevel = Integer.MAX_VALUE;
                        if (this.fToDepth < this.fFromDepth) {
                            String str = IOFunctions.getMessage("level", F.list(expr), EvalEngine.get());
                            throw new ArgumentTypeException(str);
                        }
                    } else {
                        this.fToLevel = i.toBigNumerator().intValue();
                        this.fFromLevel = i.toBigNumerator().intValue();
                        this.fFromDepth = Integer.MIN_VALUE;
                        this.fToDepth = -1;
                        if (this.fToLevel < this.fFromLevel) {
                            String str = IOFunctions.getMessage("level", F.list(expr), EvalEngine.get());
                            throw new ArgumentTypeException(str);
                        }
                    }
                    return;
                }
            } else if (lst.isAST2()) {
                if (lst.arg1() instanceof IInteger && lst.arg2() instanceof IInteger) {
                    IInteger i0 = (IInteger)lst.arg1();
                    IInteger i1 = (IInteger)lst.arg2();
                    if (i0.isNegative() && i1.isNegative()) {
                        this.fFromDepth = i0.toBigNumerator().intValue();
                        this.fToDepth = i1.toBigNumerator().intValue();
                        this.fFromLevel = 0;
                        this.fToLevel = Integer.MAX_VALUE;
                    } else {
                        if (i0.isNegative()) {
                            String str = IOFunctions.getMessage("level", F.list(expr), EvalEngine.get());
                            throw new ArgumentTypeException(str);
                        }
                        if (i1.isNegative()) {
                            this.fFromDepth = Integer.MIN_VALUE;
                            this.fToDepth = i1.toBigNumerator().intValue();
                            this.fFromLevel = i0.toBigNumerator().intValue();
                            this.fToLevel = Integer.MAX_VALUE;
                        } else {
                            this.fFromDepth = Integer.MIN_VALUE;
                            this.fToDepth = -1;
                            this.fFromLevel = i0.toBigNumerator().intValue();
                            this.fToLevel = i1.toBigNumerator().intValue();
                        }
                    }
                    return;
                }
                if (lst.arg1() instanceof IInteger && lst.arg2().isInfinity()) {
                    IInteger i0 = (IInteger)lst.arg1();
                    if (i0.isNegative()) {
                        String str = IOFunctions.getMessage("level", F.list(expr), EvalEngine.get());
                        throw new ArgumentTypeException(str);
                    }
                    this.fFromDepth = Integer.MIN_VALUE;
                    this.fToDepth = -1;
                    this.fFromLevel = i0.toBigNumerator().intValue();
                    this.fToLevel = Integer.MAX_VALUE;
                    return;
                }
            }
        }
        if (expr.isInfinity()) {
            this.fToLevel = Integer.MAX_VALUE;
            this.fFromLevel = 1;
            this.fFromDepth = Integer.MIN_VALUE;
            this.fToDepth = -1;
            return;
        }
        String str = IOFunctions.getMessage("level", F.list(expr), EvalEngine.get());
        throw new ArgumentTypeException(str);
    }

    public LevelSpecification(int level) {
        this(level, level);
    }

    public LevelSpecification(int levelFrom, int levelTo) {
        this.fFromLevel = levelFrom;
        this.fToLevel = levelTo;
        this.fFromDepth = Integer.MIN_VALUE;
        this.fToDepth = -1;
    }

    public int getFrom() {
        return this.fFromLevel;
    }

    public int getTo() {
        return this.fToLevel;
    }

    public final boolean includesDepth(int i) {
        return this.fFromDepth <= (i *= -1) && this.fToDepth >= i;
    }

    public final boolean includesLevel(int i) {
        return this.fFromLevel <= i && this.fToLevel >= i;
    }

    public final int compareDepth(int i) {
        if (this.fFromDepth > (i *= -1)) {
            return -1;
        }
        if (this.fToDepth < i) {
            return 1;
        }
        return 0;
    }

    public final int compareLevel() {
        return this.compareLevel(this.fCurrentLevel);
    }

    public final int compareLevel(int i) {
        if (this.fFromLevel > i) {
            return -1;
        }
        if (this.fToLevel < i) {
            return 1;
        }
        return 0;
    }

    public void setFrom(int i) {
        this.fFromLevel = i;
    }

    public void setTo(int i) {
        this.fToLevel = i;
    }
}

